import 'dart:collection';

import 'package:simple_sparse_list/simple_sparse_list.dart';

import '../decomposer.dart';

class CompatDecomposer extends Decomposer {
  const CompatDecomposer();

  @override
  List<int>? decompose(int character) {
    if (character < 0 || character > 1114111) {
      throw RangeError.range(character, 0, 1114111, 'character');
    }

    final result = _data[character];
    return result?.toList();
  }

  @override
  List<(int, List<int>)> getMappingList() {
    final groups = _data.getGroups();
    final result = groups.map((e) => (e.$1, e.$3!));
    return UnmodifiableListView(result);
  }
}

SparseList<List<int>?> _unpack(List<(int, List<int>)> data) {
  final list = <(int, int, List<int>)>[];
  var prev = 0;
  for (var i = 0; i < data.length; i++) {
    final element = data[i];
    final code = element.$1 + prev;
    list.add((code, code, element.$2));
    prev = code;
  }

  return SparseList(list, null, length: 0x110000);
}

final _data = _unpack(const [(168, [32, 776]), (7, [32, 772]), (5, [32, 769]), (1, [956]), (3, [32, 807]), (122, [73, 74]), (1, [105, 106]), (12, [76, 183]), (1, [108, 183]), (9, [700, 110]), (54, [115]), (69, [68, 381]), (1, [68, 382]), (1, [100, 382]), (1, [76, 74]), (1, [76, 106]), (1, [108, 106]), (1, [78, 74]), (1, [78, 106]), (1, [110, 106]), (37, [68, 90]), (1, [68, 122]), (1, [100, 122]), (229, [32, 774]), (1, [32, 775]), (1, [32, 778]), (1, [32, 808]), (1, [32, 771]), (1, [32, 779]), (157, [32, 837]), (10, [32, 769]), (76, [946]), (1, [952]), (1, [933]), (3, [966]), (1, [960]), (26, [954]), (1, [961]), (1, [962]), (2, [920]), (1, [949]), (4, [931]), (398, [1381, 1410]), (238, [1575, 1652]), (1, [1608, 1652]), (1, [1735, 1652]), (1, [1610, 1652]), (1979, [3661, 3634]), (128, [3789, 3762]), (41, [3755, 3737]), (1, [3755, 3745]), (154, [4018, 3969]), (2, [4019, 3969]), (3873, [97, 702]), (291, [32, 787]), (2, [32, 787]), (1, [32, 834]), (62, [32, 788]), (4, [32]), (1, [32]), (1, [32]), (1, [32]), (1, [32]), (2, [32]), (1, [32]), (1, [32]), (13, [32, 819]), (13, [46]), (1, [46, 46]), (1, [46, 46, 46]), (13, [8242, 8242]), (1, [8242, 8242, 8242]), (2, [8245, 8245]), (1, [8245, 8245, 8245]), (5, [33, 33]), (2, [32, 773]), (9, [63, 63]), (1, [63, 33]), (1, [33, 63]), (14, [8242, 8242, 8242, 8242]), (8, [32]), (73, [82, 115]), (88, [97, 47, 99]), (1, [97, 47, 115]), (2, [176, 67]), (2, [99, 47, 111]), (1, [99, 47, 117]), (1, [400]), (2, [176, 70]), (13, [78, 111]), (11, [84, 69, 76]), (20, [1488]), (1, [1489]), (1, [1490]), (1, [1491]), (3, [70, 65, 88]), (37, [73]), (1, [73, 73]), (1, [73, 73, 73]), (1, [73, 86]), (1, [86]), (1, [86, 73]), (1, [86, 73, 73]), (1, [86, 73, 73, 73]), (1, [73, 88]), (1, [88]), (1, [88, 73]), (1, [88, 73, 73]), (1, [76]), (1, [67]), (1, [68]), (1, [77]), (1, [105]), (1, [105, 105]), (1, [105, 105, 105]), (1, [105, 118]), (1, [118]), (1, [118, 105]), (1, [118, 105, 105]), (1, [118, 105, 105, 105]), (1, [105, 120]), (1, [120]), (1, [120, 105]), (1, [120, 105, 105]), (1, [108]), (1, [99]), (1, [100]), (1, [109]), (173, [8747, 8747]), (1, [8747, 8747, 8747]), (2, [8750, 8750]), (1, [8750, 8750, 8750]), (580, [40, 49, 41]), (1, [40, 50, 41]), (1, [40, 51, 41]), (1, [40, 52, 41]), (1, [40, 53, 41]), (1, [40, 54, 41]), (1, [40, 55, 41]), (1, [40, 56, 41]), (1, [40, 57, 41]), (1, [40, 49, 48, 41]), (1, [40, 49, 49, 41]), (1, [40, 49, 50, 41]), (1, [40, 49, 51, 41]), (1, [40, 49, 52, 41]), (1, [40, 49, 53, 41]), (1, [40, 49, 54, 41]), (1, [40, 49, 55, 41]), (1, [40, 49, 56, 41]), (1, [40, 49, 57, 41]), (1, [40, 50, 48, 41]), (1, [49, 46]), (1, [50, 46]), (1, [51, 46]), (1, [52, 46]), (1, [53, 46]), (1, [54, 46]), (1, [55, 46]), (1, [56, 46]), (1, [57, 46]), (1, [49, 48, 46]), (1, [49, 49, 46]), (1, [49, 50, 46]), (1, [49, 51, 46]), (1, [49, 52, 46]), (1, [49, 53, 46]), (1, [49, 54, 46]), (1, [49, 55, 46]), (1, [49, 56, 46]), (1, [49, 57, 46]), (1, [50, 48, 46]), (1, [40, 97, 41]), (1, [40, 98, 41]), (1, [40, 99, 41]), (1, [40, 100, 41]), (1, [40, 101, 41]), (1, [40, 102, 41]), (1, [40, 103, 41]), (1, [40, 104, 41]), (1, [40, 105, 41]), (1, [40, 106, 41]), (1, [40, 107, 41]), (1, [40, 108, 41]), (1, [40, 109, 41]), (1, [40, 110, 41]), (1, [40, 111, 41]), (1, [40, 112, 41]), (1, [40, 113, 41]), (1, [40, 114, 41]), (1, [40, 115, 41]), (1, [40, 116, 41]), (1, [40, 117, 41]), (1, [40, 118, 41]), (1, [40, 119, 41]), (1, [40, 120, 41]), (1, [40, 121, 41]), (1, [40, 122, 41]), (1367, [8747, 8747, 8747, 8747]), (104, [58, 58, 61]), (1, [61, 61]), (1, [61, 61, 61]), (1065, [27597]), (84, [40863]), (13, [19968]), (1, [20008]), (1, [20022]), (1, [20031]), (1, [20057]), (1, [20101]), (1, [20108]), (1, [20128]), (1, [20154]), (1, [20799]), (1, [20837]), (1, [20843]), (1, [20866]), (1, [20886]), (1, [20907]), (1, [20960]), (1, [20981]), (1, [20992]), (1, [21147]), (1, [21241]), (1, [21269]), (1, [21274]), (1, [21304]), (1, [21313]), (1, [21340]), (1, [21353]), (1, [21378]), (1, [21430]), (1, [21448]), (1, [21475]), (1, [22231]), (1, [22303]), (1, [22763]), (1, [22786]), (1, [22794]), (1, [22805]), (1, [22823]), (1, [22899]), (1, [23376]), (1, [23424]), (1, [23544]), (1, [23567]), (1, [23586]), (1, [23608]), (1, [23662]), (1, [23665]), (1, [24027]), (1, [24037]), (1, [24049]), (1, [24062]), (1, [24178]), (1, [24186]), (1, [24191]), (1, [24308]), (1, [24318]), (1, [24331]), (1, [24339]), (1, [24400]), (1, [24417]), (1, [24435]), (1, [24515]), (1, [25096]), (1, [25142]), (1, [25163]), (1, [25903]), (1, [25908]), (1, [25991]), (1, [26007]), (1, [26020]), (1, [26041]), (1, [26080]), (1, [26085]), (1, [26352]), (1, [26376]), (1, [26408]), (1, [27424]), (1, [27490]), (1, [27513]), (1, [27571]), (1, [27595]), (1, [27604]), (1, [27611]), (1, [27663]), (1, [27668]), (1, [27700]), (1, [28779]), (1, [29226]), (1, [29238]), (1, [29243]), (1, [29247]), (1, [29255]), (1, [29273]), (1, [29275]), (1, [29356]), (1, [29572]), (1, [29577]), (1, [29916]), (1, [29926]), (1, [29976]), (1, [29983]), (1, [29992]), (1, [30000]), (1, [30091]), (1, [30098]), (1, [30326]), (1, [30333]), (1, [30382]), (1, [30399]), (1, [30446]), (1, [30683]), (1, [30690]), (1, [30707]), (1, [31034]), (1, [31160]), (1, [31166]), (1, [31348]), (1, [31435]), (1, [31481]), (1, [31859]), (1, [31992]), (1, [32566]), (1, [32593]), (1, [32650]), (1, [32701]), (1, [32769]), (1, [32780]), (1, [32786]), (1, [32819]), (1, [32895]), (1, [32905]), (1, [33251]), (1, [33258]), (1, [33267]), (1, [33276]), (1, [33292]), (1, [33307]), (1, [33311]), (1, [33390]), (1, [33394]), (1, [33400]), (1, [34381]), (1, [34411]), (1, [34880]), (1, [34892]), (1, [34915]), (1, [35198]), (1, [35211]), (1, [35282]), (1, [35328]), (1, [35895]), (1, [35910]), (1, [35925]), (1, [35960]), (1, [35997]), (1, [36196]), (1, [36208]), (1, [36275]), (1, [36523]), (1, [36554]), (1, [36763]), (1, [36784]), (1, [36789]), (1, [37009]), (1, [37193]), (1, [37318]), (1, [37324]), (1, [37329]), (1, [38263]), (1, [38272]), (1, [38428]), (1, [38582]), (1, [38585]), (1, [38632]), (1, [38737]), (1, [38750]), (1, [38754]), (1, [38761]), (1, [38859]), (1, [38893]), (1, [38899]), (1, [38913]), (1, [39080]), (1, [39131]), (1, [39135]), (1, [39318]), (1, [39321]), (1, [39340]), (1, [39592]), (1, [39640]), (1, [39647]), (1, [39717]), (1, [39727]), (1, [39730]), (1, [39740]), (1, [39770]), (1, [40165]), (1, [40565]), (1, [40575]), (1, [40613]), (1, [40635]), (1, [40643]), (1, [40653]), (1, [40657]), (1, [40697]), (1, [40701]), (1, [40718]), (1, [40723]), (1, [40736]), (1, [40763]), (1, [40778]), (1, [40786]), (1, [40845]), (1, [40860]), (1, [40864]), (97, [12306]), (2, [21313]), (1, [21316]), (1, [21317]), (97, [32, 12441]), (1, [32, 12442]), (149, [4352]), (1, [4353]), (1, [4522]), (1, [4354]), (1, [4524]), (1, [4525]), (1, [4355]), (1, [4356]), (1, [4357]), (1, [4528]), (1, [4529]), (1, [4530]), (1, [4531]), (1, [4532]), (1, [4533]), (1, [4378]), (1, [4358]), (1, [4359]), (1, [4360]), (1, [4385]), (1, [4361]), (1, [4362]), (1, [4363]), (1, [4364]), (1, [4365]), (1, [4366]), (1, [4367]), (1, [4368]), (1, [4369]), (1, [4370]), (1, [4449]), (1, [4450]), (1, [4451]), (1, [4452]), (1, [4453]), (1, [4454]), (1, [4455]), (1, [4456]), (1, [4457]), (1, [4458]), (1, [4459]), (1, [4460]), (1, [4461]), (1, [4462]), (1, [4463]), (1, [4464]), (1, [4465]), (1, [4466]), (1, [4467]), (1, [4468]), (1, [4469]), (1, [4448]), (1, [4372]), (1, [4373]), (1, [4551]), (1, [4552]), (1, [4556]), (1, [4558]), (1, [4563]), (1, [4567]), (1, [4569]), (1, [4380]), (1, [4573]), (1, [4575]), (1, [4381]), (1, [4382]), (1, [4384]), (1, [4386]), (1, [4387]), (1, [4391]), (1, [4393]), (1, [4395]), (1, [4396]), (1, [4397]), (1, [4398]), (1, [4399]), (1, [4402]), (1, [4406]), (1, [4416]), (1, [4423]), (1, [4428]), (1, [4593]), (1, [4594]), (1, [4439]), (1, [4440]), (1, [4441]), (1, [4484]), (1, [4485]), (1, [4488]), (1, [4497]), (1, [4498]), (1, [4500]), (1, [4510]), (1, [4513]), (114, [40, 4352, 41]), (1, [40, 4354, 41]), (1, [40, 4355, 41]), (1, [40, 4357, 41]), (1, [40, 4358, 41]), (1, [40, 4359, 41]), (1, [40, 4361, 41]), (1, [40, 4363, 41]), (1, [40, 4364, 41]), (1, [40, 4366, 41]), (1, [40, 4367, 41]), (1, [40, 4368, 41]), (1, [40, 4369, 41]), (1, [40, 4370, 41]), (1, [40, 4352, 4449, 41]), (1, [40, 4354, 4449, 41]), (1, [40, 4355, 4449, 41]), (1, [40, 4357, 4449, 41]), (1, [40, 4358, 4449, 41]), (1, [40, 4359, 4449, 41]), (1, [40, 4361, 4449, 41]), (1, [40, 4363, 4449, 41]), (1, [40, 4364, 4449, 41]), (1, [40, 4366, 4449, 41]), (1, [40, 4367, 4449, 41]), (1, [40, 4368, 4449, 41]), (1, [40, 4369, 4449, 41]), (1, [40, 4370, 4449, 41]), (1, [40, 4364, 4462, 41]), (1, [40, 4363, 4457, 4364, 4453, 4523, 41]), (1, [40, 4363, 4457, 4370, 4462, 41]), (2, [40, 19968, 41]), (1, [40, 20108, 41]), (1, [40, 19977, 41]), (1, [40, 22235, 41]), (1, [40, 20116, 41]), (1, [40, 20845, 41]), (1, [40, 19971, 41]), (1, [40, 20843, 41]), (1, [40, 20061, 41]), (1, [40, 21313, 41]), (1, [40, 26376, 41]), (1, [40, 28779, 41]), (1, [40, 27700, 41]), (1, [40, 26408, 41]), (1, [40, 37329, 41]), (1, [40, 22303, 41]), (1, [40, 26085, 41]), (1, [40, 26666, 41]), (1, [40, 26377, 41]), (1, [40, 31038, 41]), (1, [40, 21517, 41]), (1, [40, 29305, 41]), (1, [40, 36001, 41]), (1, [40, 31069, 41]), (1, [40, 21172, 41]), (1, [40, 20195, 41]), (1, [40, 21628, 41]), (1, [40, 23398, 41]), (1, [40, 30435, 41]), (1, [40, 20225, 41]), (1, [40, 36039, 41]), (1, [40, 21332, 41]), (1, [40, 31085, 41]), (1, [40, 20241, 41]), (1, [40, 33258, 41]), (1, [40, 33267, 41]), (125, [49, 26376]), (1, [50, 26376]), (1, [51, 26376]), (1, [52, 26376]), (1, [53, 26376]), (1, [54, 26376]), (1, [55, 26376]), (1, [56, 26376]), (1, [57, 26376]), (1, [49, 48, 26376]), (1, [49, 49, 26376]), (1, [49, 50, 26376]), (141, [48, 28857]), (1, [49, 28857]), (1, [50, 28857]), (1, [51, 28857]), (1, [52, 28857]), (1, [53, 28857]), (1, [54, 28857]), (1, [55, 28857]), (1, [56, 28857]), (1, [57, 28857]), (1, [49, 48, 28857]), (1, [49, 49, 28857]), (1, [49, 50, 28857]), (1, [49, 51, 28857]), (1, [49, 52, 28857]), (1, [49, 53, 28857]), (1, [49, 54, 28857]), (1, [49, 55, 28857]), (1, [49, 56, 28857]), (1, [49, 57, 28857]), (1, [50, 48, 28857]), (1, [50, 49, 28857]), (1, [50, 50, 28857]), (1, [50, 51, 28857]), (1, [50, 52, 28857]), (112, [49, 26085]), (1, [50, 26085]), (1, [51, 26085]), (1, [52, 26085]), (1, [53, 26085]), (1, [54, 26085]), (1, [55, 26085]), (1, [56, 26085]), (1, [57, 26085]), (1, [49, 48, 26085]), (1, [49, 49, 26085]), (1, [49, 50, 26085]), (1, [49, 51, 26085]), (1, [49, 52, 26085]), (1, [49, 53, 26085]), (1, [49, 54, 26085]), (1, [49, 55, 26085]), (1, [49, 56, 26085]), (1, [49, 57, 26085]), (1, [50, 48, 26085]), (1, [50, 49, 26085]), (1, [50, 50, 26085]), (1, [50, 51, 26085]), (1, [50, 52, 26085]), (1, [50, 53, 26085]), (1, [50, 54, 26085]), (1, [50, 55, 26085]), (1, [50, 56, 26085]), (1, [50, 57, 26085]), (1, [51, 48, 26085]), (1, [51, 49, 26085]), (50946, [102, 102]), (1, [102, 105]), (1, [102, 108]), (1, [102, 102, 105]), (1, [102, 102, 108]), (1, [383, 116]), (1, [115, 116]), (13, [1396, 1398]), (1, [1396, 1381]), (1, [1396, 1387]), (1, [1406, 1398]), (1, [1396, 1389]), (56, [1488, 1500]), (762, [8254]), (1, [8254]), (1, [8254]), (1, [8254]), (1, [95]), (1, [95]), (1, [95]), (62129, [48, 46]), (1, [48, 44]), (1, [49, 44]), (1, [50, 44]), (1, [51, 44]), (1, [52, 44]), (1, [53, 44]), (1, [54, 44]), (1, [55, 44]), (1, [56, 44]), (1, [57, 44]), (6, [40, 65, 41]), (1, [40, 66, 41]), (1, [40, 67, 41]), (1, [40, 68, 41]), (1, [40, 69, 41]), (1, [40, 70, 41]), (1, [40, 71, 41]), (1, [40, 72, 41]), (1, [40, 73, 41]), (1, [40, 74, 41]), (1, [40, 75, 41]), (1, [40, 76, 41]), (1, [40, 77, 41]), (1, [40, 78, 41]), (1, [40, 79, 41]), (1, [40, 80, 41]), (1, [40, 81, 41]), (1, [40, 82, 41]), (1, [40, 83, 41]), (1, [40, 84, 41]), (1, [40, 85, 41]), (1, [40, 86, 41]), (1, [40, 87, 41]), (1, [40, 88, 41]), (1, [40, 89, 41]), (1, [40, 90, 41]), (1, [12308, 83, 12309]), (278, [12308, 26412, 12309]), (1, [12308, 19977, 12309]), (1, [12308, 20108, 12309]), (1, [12308, 23433, 12309]), (1, [12308, 28857, 12309]), (1, [12308, 25171, 12309]), (1, [12308, 30423, 12309]), (1, [12308, 21213, 12309]), (1, [12308, 25943, 12309])]);
