import 'package:test/test.dart';
import 'package:youtube_explode_dart/youtube_explode_dart.dart';

import 'skip_gh.dart';

void main() {
  YoutubeExplode? yt;
  setUpAll(() {
    yt = YoutubeExplode();
  });

  tearDownAll(() {
    yt?.close();
  });

  test('Get closed captions of a video', () async {
    final manifest = await yt!.videos.closedCaptions.getManifest('WOxr2dmLHLo');
    expect(manifest.tracks, isNotEmpty);
  }, skip: skipGH);
  test('Get closed caption track of a video', () async {
    final manifest = await yt!.videos.closedCaptions.getManifest('WOxr2dmLHLo');
    final trackInfo = manifest.tracks.first;
    final track = await yt!.videos.closedCaptions.get(trackInfo);

    expect(track.captions, isNotEmpty);
  }, skip: skipGH);

  test('Get closed auto translated caption track file of a video', () async {
    final manifest = await yt!.videos.closedCaptions.getManifest('WOxr2dmLHLo');
    final trackInfo = manifest.tracks.first;

    final subtitles = await yt!.videos.closedCaptions
        .getSubTitles(trackInfo.autoTranslate('it'));

    expect(subtitles, isNotEmpty);
  }, skip: skipGH);
  test('Get closed caption track at a specific time', () async {
    final manifest = await yt!.videos.closedCaptions.getManifest('qfJthDvcZ08');
    final trackInfo = manifest.getByLanguage(
      'en',
      // ignore: avoid_redundant_argument_values
      autoGenerated: false,
    );
    final track = await yt!.videos.closedCaptions.get(trackInfo.first);
    final caption = track.getByTime(
      const Duration(
        hours: 0, // ignore: avoid_redundant_argument_values
        minutes: 1,
        seconds: 48,
      ),
    ); // ignore: avoid_redundant_argument_values

    expect(caption, isNotNull);
    expect(caption?.parts, isEmpty);
    expect(caption?.text, "But what if you don't have a captions file");
  }, skip: skipGH);

  test('Get auto-generated closed caption track at a specific time', () async {
    final manifest = await yt!.videos.closedCaptions.getManifest('ppJy5uGZLi4');
    final trackInfo = manifest.getByLanguage('en', autoGenerated: true);
    final track = await yt!.videos.closedCaptions.get(trackInfo.first);
    final caption = track.getByTime(
      const Duration(
        hours: 0, // ignore: avoid_redundant_argument_values
        minutes: 13,
        seconds: 22,
      ),
    ); // ignore: avoid_redundant_argument_values
    final captionPart =
        caption!.getPartByTime(const Duration(milliseconds: 200));

    expect(caption, isNotNull);
    expect(captionPart, isNotNull);
    expect(
      caption.text,
      anyOf(
        'how about this black there are some',
        'there are some really nice colors here',
      ),
    ); // Seems like sometimes the text changes.
    expect(captionPart?.text, anyOf(' about', ' some', ' are'));
  }, skip: skipGH);
}
