import { ActionType } from './ActionType';
import PanGestureHandler from './web/handlers/PanGestureHandler';
import TapGestureHandler from './web/handlers/TapGestureHandler';
import LongPressGestureHandler from './web/handlers/LongPressGestureHandler';
import PinchGestureHandler from './web/handlers/PinchGestureHandler';
import RotationGestureHandler from './web/handlers/RotationGestureHandler';
import FlingGestureHandler from './web/handlers/FlingGestureHandler';
import NativeViewGestureHandler from './web/handlers/NativeViewGestureHandler';
import ManualGestureHandler from './web/handlers/ManualGestureHandler';
import HammerNativeViewGestureHandler from './web_hammer/NativeViewGestureHandler';
import HammerPanGestureHandler from './web_hammer/PanGestureHandler';
import HammerTapGestureHandler from './web_hammer/TapGestureHandler';
import HammerLongPressGestureHandler from './web_hammer/LongPressGestureHandler';
import HammerPinchGestureHandler from './web_hammer/PinchGestureHandler';
import HammerRotationGestureHandler from './web_hammer/RotationGestureHandler';
import HammerFlingGestureHandler from './web_hammer/FlingGestureHandler';
import { Config } from './web/interfaces';
export declare const Gestures: {
    NativeViewGestureHandler: typeof NativeViewGestureHandler;
    PanGestureHandler: typeof PanGestureHandler;
    TapGestureHandler: typeof TapGestureHandler;
    LongPressGestureHandler: typeof LongPressGestureHandler;
    PinchGestureHandler: typeof PinchGestureHandler;
    RotationGestureHandler: typeof RotationGestureHandler;
    FlingGestureHandler: typeof FlingGestureHandler;
    ManualGestureHandler: typeof ManualGestureHandler;
};
export declare const HammerGestures: {
    NativeViewGestureHandler: typeof HammerNativeViewGestureHandler;
    PanGestureHandler: typeof HammerPanGestureHandler;
    TapGestureHandler: typeof HammerTapGestureHandler;
    LongPressGestureHandler: typeof HammerLongPressGestureHandler;
    PinchGestureHandler: typeof HammerPinchGestureHandler;
    RotationGestureHandler: typeof HammerRotationGestureHandler;
    FlingGestureHandler: typeof HammerFlingGestureHandler;
};
declare const _default: {
    handleSetJSResponder(_tag: number, _blockNativeResponder: boolean): void;
    handleClearJSResponder(): void;
    createGestureHandler<T>(handlerName: keyof typeof Gestures, handlerTag: number, config: T): void;
    attachGestureHandler(handlerTag: number, newView: number, _actionType: ActionType, propsRef: React.RefObject<unknown>): void;
    updateGestureHandler(handlerTag: number, newConfig: Config): void;
    getGestureHandlerNode(handlerTag: number): NativeViewGestureHandler | PanGestureHandler | TapGestureHandler | LongPressGestureHandler | PinchGestureHandler | RotationGestureHandler | FlingGestureHandler | ManualGestureHandler | import("./web/handlers/HoverGestureHandler").default | HammerNativeViewGestureHandler | HammerPanGestureHandler | HammerTapGestureHandler | HammerLongPressGestureHandler | HammerPinchGestureHandler | HammerRotationGestureHandler | HammerFlingGestureHandler;
    dropGestureHandler(handlerTag: number): void;
    flushOperations(): void;
};
export default _default;
