package com.glosdalen.app.backend.anki

import java.io.File

data class AnkiCard(
    val modelName: String,
    val fields: Map<String, String>,
    val tags: List<String> = emptyList(),
    val deckName: String,
    val audioFiles: Map<String, File> = emptyMap() // Map of field name to audio file
)

sealed class AnkiError : Exception() {
    object AnkiDroidNotInstalled : AnkiError()
    data class IntentFailed(val reason: String?) : AnkiError()
    
    // API-specific errors
    data class ApiNotAvailable(val reason: String) : AnkiError()
    data class PermissionDenied(val reason: String) : AnkiError()
    data class ApiError(val reason: String) : AnkiError()
    data class DeckCreationFailed(val reason: String) : AnkiError()
    data class ModelCreationFailed(val reason: String) : AnkiError()
    data class CardCreationFailed(val reason: String) : AnkiError()
}