import 'package:flutter/material.dart';

class ExampleButtonNode extends StatelessWidget {
  const ExampleButtonNode({
    required this.title,
    required this.onPressed,
  });

  final String title;
  final VoidCallback onPressed;

  @override
  Widget build(BuildContext context) {
    return Container(
      margin: const EdgeInsets.symmetric(
        vertical: 20.0,
      ),
      child: Column(
        children: <Widget>[
          Text(
            title,
            textAlign: TextAlign.center,
            style: const TextStyle(
              color: Colors.black,
              fontSize: 21.0,
              fontWeight: FontWeight.w600,
            ),
          ),
          Container(
            margin: const EdgeInsets.only(
              top: 10.0,
            ),
            child: ElevatedButton(
              onPressed: onPressed,
              child: const Text("Open example"),
              style: ButtonStyle(
                backgroundColor: WidgetStateProperty.all(Colors.amber),
              ),
            ),
          )
        ],
      ),
    );
  }
}
