// Copyright (c) 2023, the Dart project authors.  Please see the AUTHORS file
// for details. All rights reserved. Use of this source code is governed by a
// BSD-style license that can be found in the LICENSE file.

import 'dart:developer';

import 'package:test/test.dart';
import 'package:vm_service/vm_service.dart';

import 'common/service_test_common.dart';
import 'common/test_helper.dart';

// AUTOGENERATED START
//
// Update these constants by running:
//
// dart pkg/vm_service/test/update_line_numbers.dart pkg/vm_service/test/set_sdk_library_debuggable_test.dart
//
const LINE_0 = 26;
const LINE_A = 27;
const LINE_B = 28;
const LINE_C = 29;
// AUTOGENERATED END

Future<void> testMain() async {
  debugger(); // LINE_0.
  print('hi'); // LINE_A.
  print('yep'); // LINE_B.
  print('zoo'); // LINE_C.
}

final tests = <IsolateTest>[
  hasStoppedAtBreakpoint,
  markDartColonLibrariesDebuggable,
  (VmService service, IsolateRef isolateRef) async {
    final isolateId = isolateRef.id!;
    final isolate = await service.getIsolate(isolateId);
    final dartCoreRef = isolate.libraries!.firstWhere(
      (library) => library.uri == 'dart:core',
    );
    final dartCore = await service.getObject(
      isolateId,
      dartCoreRef.id!,
    ) as Library;
    expect(dartCore.debuggable, true);
  },
  stoppedInFunction('testMain'),
  stoppedAtLine(LINE_0),
  stepOver,
  stoppedAtLine(LINE_A),
  stepInto,
  stoppedInFunction('print'),
  stepOut,
  stoppedInFunction('testMain'),
  stoppedAtLine(LINE_B),
  (VmService service, IsolateRef isolateRef) async {
    // Mark 'dart:core' as not debuggable.
    final isolateId = isolateRef.id!;
    final isolate = await service.getIsolate(isolateId);
    final dartCoreRef = isolate.libraries!.firstWhere(
      (library) => library.uri == 'dart:core',
    );
    Library dartCore = await service.getObject(
      isolateId,
      dartCoreRef.id!,
    ) as Library;
    expect(dartCore.debuggable, true);

    await service.setLibraryDebuggable(isolateId, dartCoreRef.id!, false);

    // Confirm the library is no longer debuggable.
    dartCore = await service.getObject(
      isolateId,
      dartCoreRef.id!,
    ) as Library;
    expect(dartCore.debuggable, false);
  },
  stoppedInFunction('testMain'),
  stoppedAtLine(LINE_B),
  stepInto,
  stoppedInFunction('testMain'),
  stoppedAtLine(LINE_C),
];

void main([args = const <String>[]]) => runIsolateTests(
      args,
      tests,
      'set_sdk_library_debuggable_test.dart',
      testeeConcurrent: testMain,
    );
