// Copyright (c) 2019, the Dart project authors.  Please see the AUTHORS file
// for details. All rights reserved. Use of this source code is governed by a
// BSD-style license that can be found in the LICENSE file.

import 'common/service_test_common.dart';
import 'common/test_helper.dart';

// AUTOGENERATED START
//
// Update these constants by running:
//
// dart pkg/vm_service/test/update_line_numbers.dart pkg/vm_service/test/column_breakpoint_test.dart
//
const LINE_A = 21;
const LINE_B = 22;
// AUTOGENERATED END

const String shortFile = 'column_breakpoint_test.dart';

void testMain() {
  final b = [1, 2].map((i) => i == 0).toList(); // LINE_A
  print(b.length); // LINE_B
}

final stops = <String>[];

const expected = <String>[
  '$shortFile:$LINE_A:33', // on first '=' of 'i == 0'
  '$shortFile:$LINE_A:33', // iterate twice
  '$shortFile:$LINE_B:11', // on 'l' of 'b.length'
];

final tests = <IsolateTest>[
  hasPausedAtStart,
  setBreakpointAtLineColumn(LINE_A, 34), // on second '=' of 'i == 0'
  setBreakpointAtLineColumn(LINE_B, 13), // on 'n' of 'b.length'
  resumeProgramRecordingStops(stops, false),
  checkRecordedStops(stops, expected),
];

void main([args = const <String>[]]) => runIsolateTests(
      args,
      tests,
      'column_breakpoint_test.dart',
      testeeConcurrent: testMain,
      pauseOnStart: true,
      pauseOnExit: true,
    );
