// This file has been migrated.

import 'dart:typed_data';

import 'package:pointycastle/digests/shake.dart';
import 'package:test/test.dart';

import '../test/src/helpers.dart';

void main() {
  testAgainstCAVPVectors();
  testSHAKESizeEnforcement();
}

class _SHAKEVector {
  _SHAKEVector(this.label, this.algo, this.bits, String msg, String digest) {
    this.msg = createUint8ListFromHexString(msg);
    this.digest = createUint8ListFromHexString(digest);
  }

  String label;
  String algo;
  int bits;
  Uint8List? msg;
  Uint8List? digest;
}

void testAgainstCAVPVectors() {
  var vectors = [
    _SHAKEVector('1', 'SHAKE-128', 0, '',
        '7f9c2ba4e88f827d616045507605853ed73b8093f6efbc88eb1a6eacfa66ef263cb1eea988004b93103cfb0aeefd2a686e01fa4a58e8a3639ca8a1e3f9ae57e235b8cc873c23dc62b8d260169afa2f75ab916a58d974918835d25e6a435085b2badfd6dfaac359a5efbb7bcc4b59d538df9a04302e10c8bc1cbf1a0b3a5120ea17cda7cfad765f5623474d368ccca8af0007cd9f5e4c849f167a580b14aabdefaee7eef47cb0fca9767be1fda69419dfb927e9df07348b196691abaeb580b32def58538b8d23f87732ea63b02b4fa0f4873360e2841928cd60dd4cee8cc0d4c922a96188d032675c8ac850933c7aff1533b94c834adbb69c6115bad4692d8619f90b0cdf8a7b9c264029ac185b70b83f2801f2f4b3f70c593ea3aeeb613a7f1b1de33fd75081f592305f2e4526edc09631b10958f464d889f31ba010250fda7f1368ec2967fc84ef2ae9aff268e0b1700affc6820b523a3d917135f2dff2ee06bfe72b3124721d4a26c04e53a75e30e73a7a9c4a95d91c55d495e9f51dd0b5e9d83c6d5e8ce803aa62b8d654db53d09b8dcff273cdfeb573fad8bcd45578bec2e770d01efde86e721a3f7c6cce275dabe6e2143f1af18da7efddc4c7b70b5e345db93cc936bea323491ccb38a388f546a9ff00dd4e1300b9b2153d2041d205b443e41b45a653f2a5c4492c1add544512dda2529833462b71a41a45be97290b6f'),
    _SHAKEVector('2', 'SHAKE-128', 5, '13',
        '2e0abfba83e6720bfbc225ff6b7ab9ffce58ba027ee3d898764fef287ddeccca3e6e5998411e7ddb32f67538f500b18c8c97c452c370ea2cf0afca3e05de7e4de27fa441a9cb34fd17c978b42d5b7e7f9ab18ffeffc3c5ac2f3a455eebfdc76ceaeb0a2cca22eef6e637f4cabe5c51ded2e3fad8b95270a321845664f107d16496bb7abfbe7504b6ede2e89e4b996fb58efdc4181f9163381cbe7bc006a7a205989c526cd1bd68983693b4bdc53728b241c1cff42bb611502c35205cabb288755655d620c67994f06451187f6fd17e046682ba1286063ff88fe2508d1fcaf9035a1231ad4150a9c9b24c9b2d66b2ad1bde0bd0bbcb8be05b835229ef7919737323424401e1d837b66eb4e630ff1de70cb317c2bacb08001d3477b7a70a576d20869033589d85a01ddb2b6646c043b59fc011311da666fa5ad1d6387fa9bc4015a38a51d1da1ea61d648dc8e39a88b9d622bde207fdabc6f2827a880c330bbf6df733774b653e57305d78dce112f10a2c71f4cdad92ed113e1cea63b91925ed28191e6dbbb5aa5a2afda51fc05a3af5258b87665243550f28948ae2b8beb6bc9c770b35f067eaa641efe65b1a44909d1b149f97eea601391c609ec81d1930f57c18a4e0fab491d1cadfd50483449edc0f07ffb24d2c6f9a9a3bff39ae3d57f560654d7d75c908abe62564753eac39d7503da6d37c2e32e1af3b8aec8ae3069cd9'),
    _SHAKEVector('3', 'SHAKE-128', 30, '53587b19',
        '6d5d39c55f3cca567feaf422dc64ba17401d07756d78b0fa3d546d66afc27671e0010685fc69a7ec3c5367b8fa5fda39d57ce53f153fa4031d277206770aec6b2ddf16aefab669110d6e4a296a14fb1486b0846b690543e4057f7f42aa8c0e6a5a56b60b688d55a196df6f3976e30688cbb6afd48525d76490357f3fd897bafc8736d907b9bac816591fc24e79360be3a7ffa62982c45abb0e584c07ec93a19530509d9f816215d7277bb999437c821450f0759281cd8e16a3483e3cc752091b7aae92909d2f501ef7dce989759891b3377ceab493ffe496010a0c7e51959994f56f565e633af6093ac6e1e0f0048871ec4778f48ef8bd5bcb80ea7df9ff4711c81e24c0221c2ad9744fba7935eaeca114224fd108efc5ac74c66252089275b4277673708c4af92f8813b193599fd64bd7484f2e5ec369e3646499768e581dd053aa4814d8bf1acff5fd774519a749be66754741ebc5362212a9fea8a814e9e010bc2720b3b7d94fab74bc7f923e1072b8a5dddda83ba0157d8cba55c192df6965cb7dba46a3340df8c3fa89c7c4db539d38dc406f1d2cf54e5905580b4404bfd7b3719561c5a59d5dfdb1bf93df13825225edcce0fa7d87efcd239feb49fc9e2de9d828feeb1f2cf579b95dd050ab2ca47105a8d30f3fd2a1154c15f87fb37b2c7156bd7f3cf2b745c912a40bc1b559b656e3e903cc5733e86ba15dfef70678'),
    _SHAKEVector(
        '4',
        'SHAKE-128',
        1600,
        'a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3',
        '131ab8d2b594946b9c81333f9bb6e0ce75c3b93104fa3469d3917457385da037cf232ef7164a6d1eb448c8908186ad852d3f85a5cf28da1ab6fe3438171978467f1c05d58c7ef38c284c41f6c2221a76f12ab1c04082660250802294fb87180213fdef5b0ecb7df50ca1f8555be14d32e10f6edcde892c09424b29f597afc270c904556bfcb47a7d40778d390923642b3cbd0579e60908d5a000c1d08b98ef933f806445bf87f8b009ba9e94f7266122ed7ac24e5e266c42a82fa1bbefb7b8db0066e16a85e0493f07df4809aec084a593748ac3dde5a6d7aae1e8b6e5352b2d71efbb47d4caeed5e6d633805d2d323e6fd81b4684b93a2677d45e7421c2c6aea259b855a698fd7d13477a1fe53e5a4a6197dbec5ce95f505b520bcd9570c4a8265a7e01f89c0c002c59bfec6cd4a5c109258953ee5ee70cd577ee217af21fa70178f0946c9bf6ca8751793479f6b537737e40b6ed28511d8a2d7e73eb75f8daac912ff906e0ab955b083bac45a8e5e9b744c8506f37e9b4e749a184b30f43eb188d855f1b70d71ff3e50c537ac1b0f8974f0fe1a6ad295ba42f6aec74d123a7abedde6e2c0711cab36be5acb1a5a11a4b1db08ba6982efccd716929a7741cfc63aa4435e0b69a9063e880795c3dc5ef3272e11c497a91acf699fefee206227a44c9fb359fd56ac0a9a75a743cff6862f17d7259ab075216c0699511643b6439'),
    _SHAKEVector(
        '5',
        'SHAKE-128',
        1605,
        'a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a303',
        '4ac38ebd1678b4a452792c5673f9777d36b55451aaae2424924942d318a2f6f51bbc837dcc7022c5403b69d29ac99a745f06d06f2a41b0cc243cd270fa44d43065af00d2ad358bd5a5d06d331bc230cd8dda4655628f9102711adafb7636c160b2d25ec6235a2fe0f37394d87fc5ffd7dbf1993e558aebea6c61e907188c61f5fcde278e264f958ffd7b3382dc10139b625e1241ab5bbc2a1fbcac31a335cfc7b20e427712246cbb55232259a7ef1602bd56f6567d66942d4a7149f4222210b074ea54154b38e8fdfa0dcf4fa3ecd2154e8318a6578b535dbcfc217a3cab52532965846f89781457025563e2dc15cc3af902ba2ad280ffbbbfa4c52b60fa41bac21f4ab23536268119fc98cd982da5cd5da21e1b5692d47105de9f1e0132c6fe315d67fa464997c2ab5533c79f98e6e64ff80802a7fe96ca04a81f885527370a2206b10b3936dd81b8246353f4cd90511089268d744f210ac689d49d2875054a727b604d13d269b37190d427c7d15cccdcd7870e0b8adbeb977111a9bcf7781a161356a5941c799907ef9d3b1a441f09515f2831c4fafde3dc7c1e9b5aa57d3e83cd6734da3d8b9ef3fc448805ea29c99cba6b352bcabe2fd970ae9580d2bf25152b960e6b806d87d7d0608b247f61089e298692c27f19c52d03ebe395a36806ad540bec2d046c18e355faf8313d2ef8995ee6aae42568f314933e3a21e5be40'),
    _SHAKEVector(
        '6',
        'SHAKE-128',
        1630,
        'a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a323',
        '89846dc776ac0f014572ea79f560773451002938248e6882569ac32aeab191fcacde68eb07557539c4845fb444108e6e0545e731fcca2d4f67a3bfd41cff3eaf35eefb53441177965bb516950cf5dcb2aafcbbc6300e8eefd9bcd0e5f32d1a4e872e0f1dbd8f8e00cbb878698c5883e3ca184b9490389e46002c08a0b16b05a36b2cb5a1cae08e11ad972fd24af70101ce4746c84f1671877f0df6c415d1670ff40b8ddedd89cc3e656db9058049d609b6784cc9d05e60cc6ac9c8194993ba29158fd4db8cf225e9574f18a77f66ec1052bf17993bda206a17737d785bd4c18cee4c76aa5735a5223f3c55e79daec13d4bf60f1562e0ad0fa3b558eccfa8ab3eef61474d576e8caf4c11e4de5ccb36d7df7d892c1fca2017be8bbda5a47195448cc67a078e628a2ef763ffe1dc9d9d6ff78e68961c33ffd9000c11dee7f7408d8da5c605b0b4d56bb55e9364c77bfad9c8191ed6e1fe7b7a937c6d07095fe5ea91a700b4bdfc17b428d036922aa8ab5e2cd585846fb81fc693b8d59bf85c74bc700cd2bc3e6aab437d93d8a30f1cf692efef43602028e0ce5742eb3f4f4d5b029158dd6896acb5e3a7f684d9aa8914e70974b223a6fec38d76c7473e86e4b9b32c621e2015c55e947dd016c675c82368ce26fb456a5b65881af513bfdc88687c6381676abbd2d9104ed23a9e89310246b026cedd57595b1ab6fe88a784be0c06'),
    _SHAKEVector('7', 'SHAKE-256', 0, '',
        '46b9dd2b0ba88d13233b3feb743eeb243fcd52ea62b81b82b50c27646ed5762fd75dc4ddd8c0f200cb05019d67b592f6fc821c49479ab48640292eacb3b7c4be141e96616fb13957692cc7edd0b45ae3dc07223c8e92937bef84bc0eab862853349ec75546f58fb7c2775c38462c5010d846c185c15111e595522a6bcd16cf86f3d122109e3b1fdd943b6aec468a2d621a7c06c6a957c62b54dafc3be87567d677231395f6147293b68ceab7a9e0c58d864e8efde4e1b9a46cbe854713672f5caaae314ed9083dab4b099f8e300f01b8650f1f4b1d8fcf3f3cb53fb8e9eb2ea203bdc970f50ae55428a91f7f53ac266b28419c3778a15fd248d339ede785fb7f5a1aaa96d313eacc890936c173cdcd0fab882c45755feb3aed96d477ff96390bf9a66d1368b208e21f7c10d04a3dbd4e360633e5db4b602601c14cea737db3dcf722632cc77851cbdde2aaf0a33a07b373445df490cc8fc1e4160ff118378f11f0477de055a81a9eda57a4a2cfb0c83929d310912f729ec6cfa36c6ac6a75837143045d791cc85eff5b21932f23861bcf23a52b5da67eaf7baae0f5fb1369db78f3ac45f8c4ac5671d85735cdddb09d2b1e34a1fc066ff4a162cb263d6541274ae2fcc865f618abe27c124cd8b074ccd516301b91875824d09958f341ef274bdab0bae316339894304e35877b0c28a9b1fd166c796b9cc258a064a8f57e27f2a'),
    _SHAKEVector('8', 'SHAKE-256', 5, '13',
        '48a5c11abaeeff092f3646ef0d6b3d3ff76c2f55f9c732ac6470c03764008212e21b1467778b181989f88858211b45df8799cf961f800dfac99e644039e2979a4016f5456ff421c5b385da2b855da7e31c8c2e8e4ba41eb4095cb999d9759cb40358da8562a2e61349e05a2e13f1b74ec9e69f5b426dc74138ffcdc571c32b39b9f55563e1a99dc422c306026d6a0f9de85162b386794ca0688b764b3d32200cc459749732a0f3a341c0efc96a22c63bad7d96cc9ba4768c6fcfa1f200107cf9fae5c0d754958c5a756b376a3be69f88074f200e9e95a8ca5bcf969998db1dc37d0d3d916f6caab3f03782c9c44a2e14e80786bece4587b9ef82cbf454e0e34bd175ae57d36af4e726b221332ced36c8ce2e06203c656ae8da037d08e7160b480c1a8516bf06dd97bf4aa4c0249310dc0b065dc639576355384d165c6a509b12f7bbd1e15b22bce02fa048ddfaacf7415f49b6324c1d067b5264e1125f7f75427f312bd9346eb4e400b1f7cb31288c9e3f735eca9ced0db888e2e2f402243bd64618a23e10f9c229397440542d0ab1b2e10dacc5c95e597f2c7ea38438105f97803dbb03fcc0fd416b0905a41d184deb238905775891f93501fb4176a3bd6c464461d36ee8b008aabd9e26a34055e80c8c813eeba07f728ab32b15605ad161a0669f6fce5c5509fbb6afd24aeacc5fa4a51523e6b173246ed4bfa521d74fc6bb'),
    _SHAKEVector('9', 'SHAKE-256', 30, '53587b19',
        '465d081dff875e396200e4481a3e9dcd88d079aa6d66226cb6ba454107cb81a7841ab02960de279ccbe34b42c36585ad86964db0db52b6e7b4369ece8f7248589ba78ab1828ffc335cb12397119bfd2b87eb7898aeb956b6f23ddf0bd4004386a8e526554ef4e483facee30dd32e204fff8c36bbd602a576d139089c75a8050266fcbf721e4443de4645832922eb8aae39d1f572845364817b0033543899940023f2e965a60a80eb221eb19dc57b121291564c6f693583b3ac7c6f272f4f67a19a7678d4234b0bf4a2ebc08aa235b9788db787161f6617022865c0ef9aa533802d136cdbc7aeba532acf1be183b0295ab0e33a2ef69be356daaf309687153e2f99a1243609d603126a8c823e8843e459bfc72b30691cdcc3ddb27cf028afd51e4437ee3b71c0c1ec87a93436f0c247b7e8c50ce96825c97029997a74c318afacaa18a0180bc7f2f0f1c5e7ef1a2d183ac7ee7e4915c3b68c30978ab6c428193441df4705b722ce25a08a1fadca0eef1fafe83adf13021d520de5c827ff9a97b75546193a9b923f0590385dc4bff7c49d4915b5a365db4c84ddcb185de8f9eeb334965a42f1381c8badc22ba1f8ee4c0e4daaf7a88e7f42ddb8148f3bf8d3b8d74f098155a37cb4cb27876b85da602e5c789c10e03be73407bab8c49213f8c74e1266ce9b11286e674ca9c10c9c9955049a66e9051d9a2b1fc9afe26798e9cec6'),
    _SHAKEVector(
        '10',
        'SHAKE-256',
        1600,
        'a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3',
        'cd8a920ed141aa0407a22d59288652e9d9f1a7ee0c1e7c1ca699424da84a904d2d700caae7396ece96604440577da4f3aa22aeb8857f961c4cd8e06f0ae6610b1048a7f64e1074cd629e85ad7566048efc4fb500b486a3309a8f26724c0ed628001a1099422468de726f1061d99eb9e93604d5aa7467d4b1bd6484582a384317d7f47d750b8f5499512bb85a226c4243556e696f6bd072c5aa2d9b69730244b56853d16970ad817e213e470618178001c9fb56c54fefa5fee67d2da524bb3b0b61ef0e9114a92cdbb6cccb98615cfe76e3510dd88d1cc28ff99287512f24bfafa1a76877b6f37198e3a641c68a7c42d45fa7acc10dae5f3cefb7b735f12d4e589f7a456e78c0f5e4c4471fffa5e4fa0514ae974d8c2648513b5db494cea847156d277ad0e141c24c7839064cd08851bc2e7ca109fd4e251c35bb0a04fb05b364ff8c4d8b59bc303e25328c09a882e952518e1a8ae0ff265d61c465896973d7490499dc639fb8502b39456791b1b6ec5bcc5d9ac36a6df622a070d43fed781f5f149f7b62675e7d1a4d6dec48c1c7164586eae06a51208c0b791244d307726505c3ad4b26b6822377257aa152037560a739714a3ca79bd605547c9b78dd1f596f2d4f1791bc689a0e9b799a37339c04275733740143ef5d2b58b96a363d4e08076a1a9d7846436e4dca5728b6f760eef0ca92bf0be5615e96959d767197a0beeb'),
    _SHAKEVector(
        '11',
        'SHAKE-256',
        1605,
        'a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a303',
        '98d093b067475760124ffb9204a5b327c6bb05c54ff234f0b43fac7240415166a8c705ea0d739f0808b06576d996662c1f376694d98f515719b66407720dcf781c51cd56ef8b610c668ddc1ac1c2c429ea4d6f274aa7a773bf8b0cab306f1eee2a171b91334ea0facd2aac1f51d4d5eb0e63a4e6754ecafeec246b7aaf58d0e0a974c7ff4058bdbdedb33ed04b0fa45d70c7c84f3da13e4f7d1beddb534d37e5abdfb29f2b44c4fb0d6ccab831d90ba46a00530662f907dedd479e9b5428e5e2db8040b0e2b1f174ce347f32a06a5ac22b19aafe927b8878d0c8103a4d2f19e32336c64cfadc1b9acb3978a8298571dcd89c36a65692816d0c61ce0ed17942367017bd40f59dfbae34635827920afe7a27bf567009a138403f06b6e4de94da077db49773c235466119426f79888d3a81b407dfeba87e01cd48f90e01b6f90243c40125de47e8c8f3e6ea3388cbfeeb36541ef23d2c8348458ea28caa5066f4983776f0cb2fdc66049cf88ac8eae51212aace867bea4c3caee44f147a9bf99d04874e8722d03d3f5ff6ef3bebe7642fe4916c5f10ff3fd61387d5d91bcd32f9e8e4593dcaad23eccc05d2fc9be2c1cd630ea123dca9cb6938d60cddedc11e1e9bc9d268a5456ba9ccff18597c5ff9735708413b9d84b9f4721937cc6595712797532b48d6f1a2d1723b07d5460bc13916d96e88180713ac33d2c232e35e764e04'),
    _SHAKEVector(
        '12',
        'SHAKE-256',
        1630,
        'a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a3a323',
        '8a8325079b0fc3265d52f59855cafe655df438aa639f6fec991f2494330ce32fa37f7db90f6966d8e4a46e50c5ede57b9b8f082a96627f730475029a619229d84f432ed69fd059234d4d7dd358e8393f6a36a45ccf041f90fc0a4e5802d73063d36531336a0090ecfe1a4d4d29aa824ba42b4937b4bb98f4f33a0e3bd8b511e69528d59537110d7521fb78aca018df76160f54a3421b84149264ed032f6dce467a731a8e34048e3a46e98039df3c328debfbe5d1bc8be7ff4ef8917b01f0b7893672492d6ee5c71df2d0531f8b684764ba0a2b57ec6a4f60ba4f36fe2db0e65ad7aa5f14f3ef9f34a0ab5bc33d488733ba36bf4b2b4fce028eff8c6ce03b192cf075cc9f00d29c0e06c35c4489d27f07fa49a91ca92471e34dab7787ae24a6e0f309ef0ba53f7c8b2992520a07bedd509a0b6dbea570a5960ed624826dd8ecd1915c87327e74491c405a7411c12c0d4497512689bd7f5adbedb02c6d2e68474e8bf31b884040818f4bca03a45217eac7083ad3a33cb8477a04c9e3266a133477de45e71830a40eb0d075afccfcd9dc548d0d529460ea7ac2adac722e7678ef597dd3b495bd7d1a8ff39448bbab1dc6a88481801cf5a8010e873c31e479a5e3db3d4e67d1d948e67cc66fd75a4a19c120662ef55977bddbac0721c80d69902693c83d5ef7bc27efa393af4c439fc39958e0e75537358802ef0853b7470b0f19ac')
  ];

  group('SHAKE', () {
    for (var vector in vectors) {
      late SHAKEDigest dig;
      switch (vector.algo) {
        case 'SHAKE-128':
          dig = SHAKEDigest(128);
          break;
        case 'SHAKE-256':
          dig = SHAKEDigest(256);
          break;
        default:
          fail('Unknown: ${vector.algo}');
      }

      test('${vector.algo}, label = ${vector.label} ', () {
        var result = Uint8List(vector.digest!.length);

        var partialBits = vector.bits % 8;

        if (partialBits == 0) {
          dig.update(vector.msg!, 0, vector.msg!.length);
          dig.doFinalRange(result, 0, result.length);
        } else {
          dig.update(vector.msg!, 0, vector.msg!.length - 1);
          dig.doFinalPartial(result, 0, result.length,
              vector.msg![vector.msg!.length - 1], partialBits);
        }

        expect(vector.digest, equals(result));
      });
    }
  });
}

void testSHAKESizeEnforcement() {
  group('SHAKE Tests', () {
    test('enforcement of valid SHAKE sizes', () {
      SHAKEDigest(128);
      SHAKEDigest(256);

      var bitLen = 123;
      try {
        SHAKEDigest(bitLen);
        fail('Invalid SHAKE bitlen accepted');
      } on StateError catch (se) {
        expect(se.message,
            'invalid bitLength ($bitLen) for SHAKE must only be 128 or 256');
      }
    });
  });
}
