// Copyright (c) 2014, the Dart project authors.
// Please see the AUTHORS file
// for details. All rights reserved. Use of this source
// code is governed by a
// BSD-style license that can be found in the LICENSE file.

/// Date/time formatting symbols for all locales.
// DO NOT EDIT. This file is autogenerated by script.  See
// http://go/generate_number_constants.py using the --for_dart flag.
// File generated from CLDR ver. 46
//
// Before checkin, this file could have been manually edited. This is
// to incorporate changes before we could correct CLDR. All manual
// modification must be documented in this section, and should be
// removed after those changes land to CLDR.
library;

// MANUAL EDIT TO SUPPRESS WARNINGS IN GENERATED CODE
// ignore_for_file: unnecessary_new, prefer_single_quotes, prefer_const_constructors
import "number_symbols.dart";

/// Map from locale to [NumberSymbols] used for that locale.
Map<String, NumberSymbols> numberFormatSymbols = <String, NumberSymbols>{
  // Number formatting symbols for locale af.
  "af": new NumberSymbols(
      NAME: "af",
      DECIMAL_SEP: ',',
      GROUP_SEP: '\u00A0',
      PERCENT: '%',
      ZERO_DIGIT: '0',
      PLUS_SIGN: '+',
      MINUS_SIGN: '-',
      EXP_SYMBOL: 'E',
      PERMILL: '\u2030',
      INFINITY: '\u221E',
      NAN: 'NaN',
      DECIMAL_PATTERN: '#,##0.###',
      SCIENTIFIC_PATTERN: '#E0',
      PERCENT_PATTERN: '#,##0%',
      CURRENCY_PATTERN: '\u00A4#,##0.00',
      DEF_CURRENCY_CODE: 'ZAR'),
  // Number formatting symbols for locale am.
  "am": new NumberSymbols(
      NAME: "am",
      DECIMAL_SEP: '.',
      GROUP_SEP: ',',
      PERCENT: '%',
      ZERO_DIGIT: '0',
      PLUS_SIGN: '+',
      MINUS_SIGN: '-',
      EXP_SYMBOL: 'E',
      PERMILL: '\u2030',
      INFINITY: '\u221E',
      NAN:
          '\u1260\u1241\u1325\u122D\u00A0\u120A\u1308\u1208\u133D\u00A0\u12E8\u121B\u12ED\u127D\u120D',
      DECIMAL_PATTERN: '#,##0.###',
      SCIENTIFIC_PATTERN: '#E0',
      PERCENT_PATTERN: '#,##0%',
      CURRENCY_PATTERN: '\u00A4#,##0.00',
      DEF_CURRENCY_CODE: 'ETB'),
  // Number formatting symbols for locale ar.
  "ar": new NumberSymbols(
      NAME: "ar",
      DECIMAL_SEP: '.',
      GROUP_SEP: ',',
      PERCENT: '\u200E%\u200E',
      ZERO_DIGIT: '0',
      PLUS_SIGN: '\u200E+',
      MINUS_SIGN: '\u200E-',
      EXP_SYMBOL: 'E',
      PERMILL: '\u2030',
      INFINITY: '\u221E',
      NAN: '\u0644\u064A\u0633\u00A0\u0631\u0642\u0645\u064B\u0627',
      DECIMAL_PATTERN: '#,##0.###',
      SCIENTIFIC_PATTERN: '#E0',
      PERCENT_PATTERN: '#,##0%',
      CURRENCY_PATTERN:
          '\u200F#,##0.00\u00A0\u00A4;\u200F-#,##0.00\u00A0\u00A4',
      DEF_CURRENCY_CODE: 'EGP'),
  // Number formatting symbols for locale ar_DZ.
  "ar_DZ": new NumberSymbols(
      NAME: "ar_DZ",
      DECIMAL_SEP: ',',
      GROUP_SEP: '.',
      PERCENT: '\u200E%\u200E',
      ZERO_DIGIT: '0',
      PLUS_SIGN: '\u200E+',
      MINUS_SIGN: '\u200E-',
      EXP_SYMBOL: 'E',
      PERMILL: '\u2030',
      INFINITY: '\u221E',
      NAN: '\u0644\u064A\u0633\u00A0\u0631\u0642\u0645\u064B\u0627',
      DECIMAL_PATTERN: '#,##0.###',
      SCIENTIFIC_PATTERN: '#E0',
      PERCENT_PATTERN: '#,##0%',
      CURRENCY_PATTERN:
          '\u200F#,##0.00\u00A0\u00A4;\u200F-#,##0.00\u00A0\u00A4',
      DEF_CURRENCY_CODE: 'DZD'),
  // Number formatting symbols for locale ar_EG.
  "ar_EG": new NumberSymbols(
      NAME: "ar_EG",
      DECIMAL_SEP: '\u066B',
      GROUP_SEP: '\u066C',
      PERCENT: '\u066A\u061C',
      ZERO_DIGIT: '\u0660',
      PLUS_SIGN: '\u061C+',
      MINUS_SIGN: '\u061C-',
      EXP_SYMBOL: '\u0623\u0633',
      PERMILL: '\u0609',
      INFINITY: '\u221E',
      NAN: '\u0644\u064A\u0633\u00A0\u0631\u0642\u0645\u064B\u0627',
      DECIMAL_PATTERN: '#,##0.###',
      SCIENTIFIC_PATTERN: '#E0',
      PERCENT_PATTERN: '#,##0%',
      CURRENCY_PATTERN: '\u200F#,##0.00\u00A0\u00A4',
      DEF_CURRENCY_CODE: 'EGP'),
  // Number formatting symbols for locale as.
  "as": new NumberSymbols(
      NAME: "as",
      DECIMAL_SEP: '.',
      GROUP_SEP: ',',
      PERCENT: '%',
      ZERO_DIGIT: '\u09E6',
      PLUS_SIGN: '+',
      MINUS_SIGN: '-',
      EXP_SYMBOL: 'E',
      PERMILL: '\u2030',
      INFINITY: '\u221E',
      NAN: 'NaN',
      DECIMAL_PATTERN: '#,##,##0.###',
      SCIENTIFIC_PATTERN: '#E0',
      PERCENT_PATTERN: '#,##,##0%',
      CURRENCY_PATTERN: '\u00A4\u00A0#,##,##0.00',
      DEF_CURRENCY_CODE: 'INR'),
  // Number formatting symbols for locale az.
  "az": new NumberSymbols(
      NAME: "az",
      DECIMAL_SEP: ',',
      GROUP_SEP: '.',
      PERCENT: '%',
      ZERO_DIGIT: '0',
      PLUS_SIGN: '+',
      MINUS_SIGN: '-',
      EXP_SYMBOL: 'E',
      PERMILL: '\u2030',
      INFINITY: '\u221E',
      NAN: 'NaN',
      DECIMAL_PATTERN: '#,##0.###',
      SCIENTIFIC_PATTERN: '#E0',
      PERCENT_PATTERN: '#,##0%',
      CURRENCY_PATTERN: '#,##0.00\u00A0\u00A4',
      DEF_CURRENCY_CODE: 'AZN'),
  // Number formatting symbols for locale be.
  "be": new NumberSymbols(
      NAME: "be",
      DECIMAL_SEP: ',',
      GROUP_SEP: '\u00A0',
      PERCENT: '%',
      ZERO_DIGIT: '0',
      PLUS_SIGN: '+',
      MINUS_SIGN: '-',
      EXP_SYMBOL: 'E',
      PERMILL: '\u2030',
      INFINITY: '\u221E',
      NAN: 'NaN',
      DECIMAL_PATTERN: '#,##0.###',
      SCIENTIFIC_PATTERN: '#E0',
      PERCENT_PATTERN: '#,##0\u00A0%',
      CURRENCY_PATTERN: '#,##0.00\u00A0\u00A4',
      DEF_CURRENCY_CODE: 'BYN'),
  // Number formatting symbols for locale bg.
  "bg": new NumberSymbols(
      NAME: "bg",
      DECIMAL_SEP: ',',
      GROUP_SEP: '\u00A0',
      PERCENT: '%',
      ZERO_DIGIT: '0',
      PLUS_SIGN: '+',
      MINUS_SIGN: '-',
      EXP_SYMBOL: 'E',
      PERMILL: '\u2030',
      INFINITY: '\u221E',
      NAN: 'NaN',
      DECIMAL_PATTERN: '#,##0.###',
      SCIENTIFIC_PATTERN: '#E0',
      PERCENT_PATTERN: '#,##0%',
      CURRENCY_PATTERN: '#,##0.00\u00A0\u00A4',
      DEF_CURRENCY_CODE: 'BGN'),
  // Number formatting symbols for locale bm.
  "bm": new NumberSymbols(
      NAME: "bm",
      DECIMAL_SEP: '.',
      GROUP_SEP: ',',
      PERCENT: '%',
      ZERO_DIGIT: '0',
      PLUS_SIGN: '+',
      MINUS_SIGN: '-',
      EXP_SYMBOL: 'E',
      PERMILL: '\u2030',
      INFINITY: '\u221E',
      NAN: 'NaN',
      DECIMAL_PATTERN: '#,##0.###',
      SCIENTIFIC_PATTERN: '#E0',
      PERCENT_PATTERN: '#,##0%',
      CURRENCY_PATTERN: '\u00A4#,##0.00',
      DEF_CURRENCY_CODE: 'XOF'),
  // Number formatting symbols for locale bn.
  "bn": new NumberSymbols(
      NAME: "bn",
      DECIMAL_SEP: '.',
      GROUP_SEP: ',',
      PERCENT: '%',
      ZERO_DIGIT: '\u09E6',
      PLUS_SIGN: '+',
      MINUS_SIGN: '-',
      EXP_SYMBOL: 'E',
      PERMILL: '\u2030',
      INFINITY: '\u221E',
      NAN: 'NaN',
      DECIMAL_PATTERN: '#,##,##0.###',
      SCIENTIFIC_PATTERN: '#E0',
      PERCENT_PATTERN: '#,##0%',
      CURRENCY_PATTERN: '#,##,##0.00\u00A4',
      DEF_CURRENCY_CODE: 'BDT'),
  // Number formatting symbols for locale br.
  "br": new NumberSymbols(
      NAME: "br",
      DECIMAL_SEP: ',',
      GROUP_SEP: '\u00A0',
      PERCENT: '%',
      ZERO_DIGIT: '0',
      PLUS_SIGN: '+',
      MINUS_SIGN: '-',
      EXP_SYMBOL: 'E',
      PERMILL: '\u2030',
      INFINITY: '\u221E',
      NAN: 'NaN',
      DECIMAL_PATTERN: '#,##0.###',
      SCIENTIFIC_PATTERN: '#E0',
      PERCENT_PATTERN: '#,##0\u00A0%',
      CURRENCY_PATTERN: '#,##0.00\u00A0\u00A4',
      DEF_CURRENCY_CODE: 'EUR'),
  // Number formatting symbols for locale bs.
  "bs": new NumberSymbols(
      NAME: "bs",
      DECIMAL_SEP: ',',
      GROUP_SEP: '.',
      PERCENT: '%',
      ZERO_DIGIT: '0',
      PLUS_SIGN: '+',
      MINUS_SIGN: '-',
      EXP_SYMBOL: 'E',
      PERMILL: '\u2030',
      INFINITY: '\u221E',
      NAN: 'NaN',
      DECIMAL_PATTERN: '#,##0.###',
      SCIENTIFIC_PATTERN: '#E0',
      PERCENT_PATTERN: '#,##0%',
      CURRENCY_PATTERN: '#,##0.00\u00A0\u00A4',
      DEF_CURRENCY_CODE: 'BAM'),
  // Number formatting symbols for locale ca.
  "ca": new NumberSymbols(
      NAME: "ca",
      DECIMAL_SEP: ',',
      GROUP_SEP: '.',
      PERCENT: '%',
      ZERO_DIGIT: '0',
      PLUS_SIGN: '+',
      MINUS_SIGN: '-',
      EXP_SYMBOL: 'E',
      PERMILL: '\u2030',
      INFINITY: '\u221E',
      NAN: 'NaN',
      DECIMAL_PATTERN: '#,##0.###',
      SCIENTIFIC_PATTERN: '#E0',
      PERCENT_PATTERN: '#,##0\u00A0%',
      CURRENCY_PATTERN: '#,##0.00\u00A0\u00A4',
      DEF_CURRENCY_CODE: 'EUR'),
  // Number formatting symbols for locale chr.
  "chr": new NumberSymbols(
      NAME: "chr",
      DECIMAL_SEP: '.',
      GROUP_SEP: ',',
      PERCENT: '%',
      ZERO_DIGIT: '0',
      PLUS_SIGN: '+',
      MINUS_SIGN: '-',
      EXP_SYMBOL: 'E',
      PERMILL: '\u2030',
      INFINITY: '\u221E',
      NAN: 'NaN',
      DECIMAL_PATTERN: '#,##0.###',
      SCIENTIFIC_PATTERN: '#E0',
      PERCENT_PATTERN: '#,##0%',
      CURRENCY_PATTERN: '\u00A4#,##0.00',
      DEF_CURRENCY_CODE: 'USD'),
  // Number formatting symbols for locale cs.
  "cs": new NumberSymbols(
      NAME: "cs",
      DECIMAL_SEP: ',',
      GROUP_SEP: '\u00A0',
      PERCENT: '%',
      ZERO_DIGIT: '0',
      PLUS_SIGN: '+',
      MINUS_SIGN: '-',
      EXP_SYMBOL: 'E',
      PERMILL: '\u2030',
      INFINITY: '\u221E',
      NAN: 'NaN',
      DECIMAL_PATTERN: '#,##0.###',
      SCIENTIFIC_PATTERN: '#E0',
      PERCENT_PATTERN: '#,##0\u00A0%',
      CURRENCY_PATTERN: '#,##0.00\u00A0\u00A4',
      DEF_CURRENCY_CODE: 'CZK'),
  // Number formatting symbols for locale cy.
  "cy": new NumberSymbols(
      NAME: "cy",
      DECIMAL_SEP: '.',
      GROUP_SEP: ',',
      PERCENT: '%',
      ZERO_DIGIT: '0',
      PLUS_SIGN: '+',
      MINUS_SIGN: '-',
      EXP_SYMBOL: 'E',
      PERMILL: '\u2030',
      INFINITY: '\u221E',
      NAN: 'NaN',
      DECIMAL_PATTERN: '#,##0.###',
      SCIENTIFIC_PATTERN: '#E0',
      PERCENT_PATTERN: '#,##0%',
      CURRENCY_PATTERN: '\u00A4#,##0.00',
      DEF_CURRENCY_CODE: 'GBP'),
  // Number formatting symbols for locale da.
  "da": new NumberSymbols(
      NAME: "da",
      DECIMAL_SEP: ',',
      GROUP_SEP: '.',
      PERCENT: '%',
      ZERO_DIGIT: '0',
      PLUS_SIGN: '+',
      MINUS_SIGN: '-',
      EXP_SYMBOL: 'E',
      PERMILL: '\u2030',
      INFINITY: '\u221E',
      NAN: 'NaN',
      DECIMAL_PATTERN: '#,##0.###',
      SCIENTIFIC_PATTERN: '#E0',
      PERCENT_PATTERN: '#,##0\u00A0%',
      CURRENCY_PATTERN: '#,##0.00\u00A0\u00A4',
      DEF_CURRENCY_CODE: 'DKK'),
  // Number formatting symbols for locale de.
  "de": new NumberSymbols(
      NAME: "de",
      DECIMAL_SEP: ',',
      GROUP_SEP: '.',
      PERCENT: '%',
      ZERO_DIGIT: '0',
      PLUS_SIGN: '+',
      MINUS_SIGN: '-',
      EXP_SYMBOL: 'E',
      PERMILL: '\u2030',
      INFINITY: '\u221E',
      NAN: 'NaN',
      DECIMAL_PATTERN: '#,##0.###',
      SCIENTIFIC_PATTERN: '#E0',
      PERCENT_PATTERN: '#,##0\u00A0%',
      CURRENCY_PATTERN: '#,##0.00\u00A0\u00A4',
      DEF_CURRENCY_CODE: 'EUR'),
  // Number formatting symbols for locale de_AT.
  "de_AT": new NumberSymbols(
      NAME: "de_AT",
      DECIMAL_SEP: ',',
      GROUP_SEP: '\u00A0',
      PERCENT: '%',
      ZERO_DIGIT: '0',
      PLUS_SIGN: '+',
      MINUS_SIGN: '-',
      EXP_SYMBOL: 'E',
      PERMILL: '\u2030',
      INFINITY: '\u221E',
      NAN: 'NaN',
      DECIMAL_PATTERN: '#,##0.###',
      SCIENTIFIC_PATTERN: '#E0',
      PERCENT_PATTERN: '#,##0\u00A0%',
      CURRENCY_PATTERN: '\u00A4\u00A0#,##0.00',
      DEF_CURRENCY_CODE: 'EUR'),
  // Number formatting symbols for locale de_CH.
  "de_CH": new NumberSymbols(
      NAME: "de_CH",
      DECIMAL_SEP: '.',
      GROUP_SEP: '\u2019',
      PERCENT: '%',
      ZERO_DIGIT: '0',
      PLUS_SIGN: '+',
      MINUS_SIGN: '-',
      EXP_SYMBOL: 'E',
      PERMILL: '\u2030',
      INFINITY: '\u221E',
      NAN: 'NaN',
      DECIMAL_PATTERN: '#,##0.###',
      SCIENTIFIC_PATTERN: '#E0',
      PERCENT_PATTERN: '#,##0%',
      CURRENCY_PATTERN: '\u00A4\u00A0#,##0.00;\u00A4-#,##0.00',
      DEF_CURRENCY_CODE: 'CHF'),
  // Number formatting symbols for locale el.
  "el": new NumberSymbols(
      NAME: "el",
      DECIMAL_SEP: ',',
      GROUP_SEP: '.',
      PERCENT: '%',
      ZERO_DIGIT: '0',
      PLUS_SIGN: '+',
      MINUS_SIGN: '-',
      EXP_SYMBOL: 'e',
      PERMILL: '\u2030',
      INFINITY: '\u221E',
      NAN: 'NaN',
      DECIMAL_PATTERN: '#,##0.###',
      SCIENTIFIC_PATTERN: '#E0',
      PERCENT_PATTERN: '#,##0%',
      CURRENCY_PATTERN: '#,##0.00\u00A0\u00A4',
      DEF_CURRENCY_CODE: 'EUR'),
  // Number formatting symbols for locale en.
  "en": new NumberSymbols(
      NAME: "en",
      DECIMAL_SEP: '.',
      GROUP_SEP: ',',
      PERCENT: '%',
      ZERO_DIGIT: '0',
      PLUS_SIGN: '+',
      MINUS_SIGN: '-',
      EXP_SYMBOL: 'E',
      PERMILL: '\u2030',
      INFINITY: '\u221E',
      NAN: 'NaN',
      DECIMAL_PATTERN: '#,##0.###',
      SCIENTIFIC_PATTERN: '#E0',
      PERCENT_PATTERN: '#,##0%',
      CURRENCY_PATTERN: '\u00A4#,##0.00',
      DEF_CURRENCY_CODE: 'USD'),
  // Number formatting symbols for locale en_AU.
  "en_AU": new NumberSymbols(
      NAME: "en_AU",
      DECIMAL_SEP: '.',
      GROUP_SEP: ',',
      PERCENT: '%',
      ZERO_DIGIT: '0',
      PLUS_SIGN: '+',
      MINUS_SIGN: '-',
      EXP_SYMBOL: 'e',
      PERMILL: '\u2030',
      INFINITY: '\u221E',
      NAN: 'NaN',
      DECIMAL_PATTERN: '#,##0.###',
      SCIENTIFIC_PATTERN: '#E0',
      PERCENT_PATTERN: '#,##0%',
      CURRENCY_PATTERN: '\u00A4#,##0.00',
      DEF_CURRENCY_CODE: 'AUD'),
  // Number formatting symbols for locale en_CA.
  "en_CA": new NumberSymbols(
      NAME: "en_CA",
      DECIMAL_SEP: '.',
      GROUP_SEP: ',',
      PERCENT: '%',
      ZERO_DIGIT: '0',
      PLUS_SIGN: '+',
      MINUS_SIGN: '-',
      EXP_SYMBOL: 'E',
      PERMILL: '\u2030',
      INFINITY: '\u221E',
      NAN: 'NaN',
      DECIMAL_PATTERN: '#,##0.###',
      SCIENTIFIC_PATTERN: '#E0',
      PERCENT_PATTERN: '#,##0%',
      CURRENCY_PATTERN: '\u00A4#,##0.00',
      DEF_CURRENCY_CODE: 'CAD'),
  // Number formatting symbols for locale en_GB.
  "en_GB": new NumberSymbols(
      NAME: "en_GB",
      DECIMAL_SEP: '.',
      GROUP_SEP: ',',
      PERCENT: '%',
      ZERO_DIGIT: '0',
      PLUS_SIGN: '+',
      MINUS_SIGN: '-',
      EXP_SYMBOL: 'E',
      PERMILL: '\u2030',
      INFINITY: '\u221E',
      NAN: 'NaN',
      DECIMAL_PATTERN: '#,##0.###',
      SCIENTIFIC_PATTERN: '#E0',
      PERCENT_PATTERN: '#,##0%',
      CURRENCY_PATTERN: '\u00A4#,##0.00',
      DEF_CURRENCY_CODE: 'GBP'),
  // Number formatting symbols for locale en_IE.
  "en_IE": new NumberSymbols(
      NAME: "en_IE",
      DECIMAL_SEP: '.',
      GROUP_SEP: ',',
      PERCENT: '%',
      ZERO_DIGIT: '0',
      PLUS_SIGN: '+',
      MINUS_SIGN: '-',
      EXP_SYMBOL: 'E',
      PERMILL: '\u2030',
      INFINITY: '\u221E',
      NAN: 'NaN',
      DECIMAL_PATTERN: '#,##0.###',
      SCIENTIFIC_PATTERN: '#E0',
      PERCENT_PATTERN: '#,##0%',
      CURRENCY_PATTERN: '\u00A4#,##0.00',
      DEF_CURRENCY_CODE: 'EUR'),
  // Number formatting symbols for locale en_IN.
  "en_IN": new NumberSymbols(
      NAME: "en_IN",
      DECIMAL_SEP: '.',
      GROUP_SEP: ',',
      PERCENT: '%',
      ZERO_DIGIT: '0',
      PLUS_SIGN: '+',
      MINUS_SIGN: '-',
      EXP_SYMBOL: 'E',
      PERMILL: '\u2030',
      INFINITY: '\u221E',
      NAN: 'NaN',
      DECIMAL_PATTERN: '#,##,##0.###',
      SCIENTIFIC_PATTERN: '#E0',
      PERCENT_PATTERN: '#,##,##0%',
      CURRENCY_PATTERN: '\u00A4#,##,##0.00',
      DEF_CURRENCY_CODE: 'INR'),
  // Number formatting symbols for locale en_MY.
  "en_MY": new NumberSymbols(
      NAME: "en_MY",
      DECIMAL_SEP: '.',
      GROUP_SEP: ',',
      PERCENT: '%',
      ZERO_DIGIT: '0',
      PLUS_SIGN: '+',
      MINUS_SIGN: '-',
      EXP_SYMBOL: 'E',
      PERMILL: '\u2030',
      INFINITY: '\u221E',
      NAN: 'NaN',
      DECIMAL_PATTERN: '#,##0.###',
      SCIENTIFIC_PATTERN: '#E0',
      PERCENT_PATTERN: '#,##0%',
      CURRENCY_PATTERN: '\u00A4#,##0.00',
      DEF_CURRENCY_CODE: 'MYR'),
  // Number formatting symbols for locale en_NZ.
  "en_NZ": new NumberSymbols(
      NAME: "en_NZ",
      DECIMAL_SEP: '.',
      GROUP_SEP: ',',
      PERCENT: '%',
      ZERO_DIGIT: '0',
      PLUS_SIGN: '+',
      MINUS_SIGN: '-',
      EXP_SYMBOL: 'E',
      PERMILL: '\u2030',
      INFINITY: '\u221E',
      NAN: 'NaN',
      DECIMAL_PATTERN: '#,##0.###',
      SCIENTIFIC_PATTERN: '#E0',
      PERCENT_PATTERN: '#,##0%',
      CURRENCY_PATTERN: '\u00A4#,##0.00',
      DEF_CURRENCY_CODE: 'NZD'),
  // Number formatting symbols for locale en_SG.
  "en_SG": new NumberSymbols(
      NAME: "en_SG",
      DECIMAL_SEP: '.',
      GROUP_SEP: ',',
      PERCENT: '%',
      ZERO_DIGIT: '0',
      PLUS_SIGN: '+',
      MINUS_SIGN: '-',
      EXP_SYMBOL: 'E',
      PERMILL: '\u2030',
      INFINITY: '\u221E',
      NAN: 'NaN',
      DECIMAL_PATTERN: '#,##0.###',
      SCIENTIFIC_PATTERN: '#E0',
      PERCENT_PATTERN: '#,##0%',
      CURRENCY_PATTERN: '\u00A4#,##0.00',
      DEF_CURRENCY_CODE: 'SGD'),
  // Number formatting symbols for locale en_US.
  "en_US": new NumberSymbols(
      NAME: "en_US",
      DECIMAL_SEP: '.',
      GROUP_SEP: ',',
      PERCENT: '%',
      ZERO_DIGIT: '0',
      PLUS_SIGN: '+',
      MINUS_SIGN: '-',
      EXP_SYMBOL: 'E',
      PERMILL: '\u2030',
      INFINITY: '\u221E',
      NAN: 'NaN',
      DECIMAL_PATTERN: '#,##0.###',
      SCIENTIFIC_PATTERN: '#E0',
      PERCENT_PATTERN: '#,##0%',
      CURRENCY_PATTERN: '\u00A4#,##0.00',
      DEF_CURRENCY_CODE: 'USD'),
  // Number formatting symbols for locale en_ZA.
  "en_ZA": new NumberSymbols(
      NAME: "en_ZA",
      DECIMAL_SEP: ',',
      GROUP_SEP: '\u00A0',
      PERCENT: '%',
      ZERO_DIGIT: '0',
      PLUS_SIGN: '+',
      MINUS_SIGN: '-',
      EXP_SYMBOL: 'E',
      PERMILL: '\u2030',
      INFINITY: '\u221E',
      NAN: 'NaN',
      DECIMAL_PATTERN: '#,##0.###',
      SCIENTIFIC_PATTERN: '#E0',
      PERCENT_PATTERN: '#,##0%',
      CURRENCY_PATTERN: '\u00A4#,##0.00',
      DEF_CURRENCY_CODE: 'ZAR'),
  // Number formatting symbols for locale es.
  "es": new NumberSymbols(
      NAME: "es",
      DECIMAL_SEP: ',',
      GROUP_SEP: '.',
      PERCENT: '%',
      ZERO_DIGIT: '0',
      PLUS_SIGN: '+',
      MINUS_SIGN: '-',
      EXP_SYMBOL: 'E',
      PERMILL: '\u2030',
      INFINITY: '\u221E',
      NAN: 'NaN',
      DECIMAL_PATTERN: '#,##0.###',
      SCIENTIFIC_PATTERN: '#E0',
      PERCENT_PATTERN: '#,##0\u00A0%',
      CURRENCY_PATTERN: '#,##0.00\u00A0\u00A4',
      DEF_CURRENCY_CODE: 'EUR'),
  // Number formatting symbols for locale es_419.
  "es_419": new NumberSymbols(
      NAME: "es_419",
      DECIMAL_SEP: '.',
      GROUP_SEP: ',',
      PERCENT: '%',
      ZERO_DIGIT: '0',
      PLUS_SIGN: '+',
      MINUS_SIGN: '-',
      EXP_SYMBOL: 'E',
      PERMILL: '\u2030',
      INFINITY: '\u221E',
      NAN: 'NaN',
      DECIMAL_PATTERN: '#,##0.###',
      SCIENTIFIC_PATTERN: '#E0',
      PERCENT_PATTERN: '#,##0%',
      CURRENCY_PATTERN: '\u00A4#,##0.00',
      DEF_CURRENCY_CODE: 'MXN'),
  // Number formatting symbols for locale es_ES.
  "es_ES": new NumberSymbols(
      NAME: "es_ES",
      DECIMAL_SEP: ',',
      GROUP_SEP: '.',
      PERCENT: '%',
      ZERO_DIGIT: '0',
      PLUS_SIGN: '+',
      MINUS_SIGN: '-',
      EXP_SYMBOL: 'E',
      PERMILL: '\u2030',
      INFINITY: '\u221E',
      NAN: 'NaN',
      DECIMAL_PATTERN: '#,##0.###',
      SCIENTIFIC_PATTERN: '#E0',
      PERCENT_PATTERN: '#,##0\u00A0%',
      CURRENCY_PATTERN: '#,##0.00\u00A0\u00A4',
      DEF_CURRENCY_CODE: 'EUR'),
  // Number formatting symbols for locale es_MX.
  "es_MX": new NumberSymbols(
      NAME: "es_MX",
      DECIMAL_SEP: '.',
      GROUP_SEP: ',',
      PERCENT: '%',
      ZERO_DIGIT: '0',
      PLUS_SIGN: '+',
      MINUS_SIGN: '-',
      EXP_SYMBOL: 'E',
      PERMILL: '\u2030',
      INFINITY: '\u221E',
      NAN: 'NaN',
      DECIMAL_PATTERN: '#,##0.###',
      SCIENTIFIC_PATTERN: '#E0',
      PERCENT_PATTERN: '#,##0%',
      CURRENCY_PATTERN: '\u00A4#,##0.00',
      DEF_CURRENCY_CODE: 'MXN'),
  // Number formatting symbols for locale es_US.
  "es_US": new NumberSymbols(
      NAME: "es_US",
      DECIMAL_SEP: '.',
      GROUP_SEP: ',',
      PERCENT: '%',
      ZERO_DIGIT: '0',
      PLUS_SIGN: '+',
      MINUS_SIGN: '-',
      EXP_SYMBOL: 'E',
      PERMILL: '\u2030',
      INFINITY: '\u221E',
      NAN: 'NaN',
      DECIMAL_PATTERN: '#,##0.###',
      SCIENTIFIC_PATTERN: '#E0',
      PERCENT_PATTERN: '#,##0%',
      CURRENCY_PATTERN: '\u00A4#,##0.00',
      DEF_CURRENCY_CODE: 'USD'),
  // Number formatting symbols for locale et.
  "et": new NumberSymbols(
      NAME: "et",
      DECIMAL_SEP: ',',
      GROUP_SEP: '\u00A0',
      PERCENT: '%',
      ZERO_DIGIT: '0',
      PLUS_SIGN: '+',
      MINUS_SIGN: '\u2212',
      EXP_SYMBOL: '\u00D710^',
      PERMILL: '\u2030',
      INFINITY: '\u221E',
      NAN: 'NaN',
      DECIMAL_PATTERN: '#,##0.###',
      SCIENTIFIC_PATTERN: '#E0',
      PERCENT_PATTERN: '#,##0%',
      CURRENCY_PATTERN: '#,##0.00\u00A0\u00A4',
      DEF_CURRENCY_CODE: 'EUR'),
  // Number formatting symbols for locale eu.
  "eu": new NumberSymbols(
      NAME: "eu",
      DECIMAL_SEP: ',',
      GROUP_SEP: '.',
      PERCENT: '%',
      ZERO_DIGIT: '0',
      PLUS_SIGN: '+',
      MINUS_SIGN: '\u2212',
      EXP_SYMBOL: 'E',
      PERMILL: '\u2030',
      INFINITY: '\u221E',
      NAN: 'NaN',
      DECIMAL_PATTERN: '#,##0.###',
      SCIENTIFIC_PATTERN: '#E0',
      PERCENT_PATTERN: '%\u00A0#,##0',
      CURRENCY_PATTERN: '#,##0.00\u00A0\u00A4',
      DEF_CURRENCY_CODE: 'EUR'),
  // Number formatting symbols for locale fa.
  "fa": new NumberSymbols(
      NAME: "fa",
      DECIMAL_SEP: '\u066B',
      GROUP_SEP: '\u066C',
      PERCENT: '\u066A',
      ZERO_DIGIT: '\u06F0',
      PLUS_SIGN: '\u200E+',
      MINUS_SIGN: '\u200E\u2212',
      EXP_SYMBOL: '\u00D7\u06F1\u06F0^',
      PERMILL: '\u0609',
      INFINITY: '\u221E',
      NAN: '\u0646\u0627\u0639\u062F\u062F',
      DECIMAL_PATTERN: '#,##0.###',
      SCIENTIFIC_PATTERN: '#E0',
      PERCENT_PATTERN: '#,##0%',
      CURRENCY_PATTERN: '\u200E\u00A4#,##0.00',
      DEF_CURRENCY_CODE: 'IRR'),
  // Number formatting symbols for locale fi.
  "fi": new NumberSymbols(
      NAME: "fi",
      DECIMAL_SEP: ',',
      GROUP_SEP: '\u00A0',
      PERCENT: '%',
      ZERO_DIGIT: '0',
      PLUS_SIGN: '+',
      MINUS_SIGN: '\u2212',
      EXP_SYMBOL: 'E',
      PERMILL: '\u2030',
      INFINITY: '\u221E',
      NAN: 'ep\u00E4luku',
      DECIMAL_PATTERN: '#,##0.###',
      SCIENTIFIC_PATTERN: '#E0',
      PERCENT_PATTERN: '#,##0\u00A0%',
      CURRENCY_PATTERN: '#,##0.00\u00A0\u00A4',
      DEF_CURRENCY_CODE: 'EUR'),
  // Number formatting symbols for locale fil.
  "fil": new NumberSymbols(
      NAME: "fil",
      DECIMAL_SEP: '.',
      GROUP_SEP: ',',
      PERCENT: '%',
      ZERO_DIGIT: '0',
      PLUS_SIGN: '+',
      MINUS_SIGN: '-',
      EXP_SYMBOL: 'E',
      PERMILL: '\u2030',
      INFINITY: '\u221E',
      NAN: 'NaN',
      DECIMAL_PATTERN: '#,##0.###',
      SCIENTIFIC_PATTERN: '#E0',
      PERCENT_PATTERN: '#,##0%',
      CURRENCY_PATTERN: '\u00A4#,##0.00',
      DEF_CURRENCY_CODE: 'PHP'),
  // Number formatting symbols for locale fr.
  "fr": new NumberSymbols(
      NAME: "fr",
      DECIMAL_SEP: ',',
      GROUP_SEP: '\u202F',
      PERCENT: '%',
      ZERO_DIGIT: '0',
      PLUS_SIGN: '+',
      MINUS_SIGN: '-',
      EXP_SYMBOL: 'E',
      PERMILL: '\u2030',
      INFINITY: '\u221E',
      NAN: 'NaN',
      DECIMAL_PATTERN: '#,##0.###',
      SCIENTIFIC_PATTERN: '#E0',
      PERCENT_PATTERN: '#,##0\u00A0%',
      CURRENCY_PATTERN: '#,##0.00\u00A0\u00A4',
      DEF_CURRENCY_CODE: 'EUR'),
  // Number formatting symbols for locale fr_CA.
  "fr_CA": new NumberSymbols(
      NAME: "fr_CA",
      DECIMAL_SEP: ',',
      GROUP_SEP: '\u00A0',
      PERCENT: '%',
      ZERO_DIGIT: '0',
      PLUS_SIGN: '+',
      MINUS_SIGN: '-',
      EXP_SYMBOL: 'E',
      PERMILL: '\u2030',
      INFINITY: '\u221E',
      NAN: 'NaN',
      DECIMAL_PATTERN: '#,##0.###',
      SCIENTIFIC_PATTERN: '#E0',
      PERCENT_PATTERN: '#,##0\u00A0%',
      CURRENCY_PATTERN: '#,##0.00\u00A0\u00A4',
      DEF_CURRENCY_CODE: 'CAD'),
  // Number formatting symbols for locale fr_CH.
  "fr_CH": new NumberSymbols(
      NAME: "fr_CH",
      DECIMAL_SEP: ',',
      GROUP_SEP: '\u202F',
      PERCENT: '%',
      ZERO_DIGIT: '0',
      PLUS_SIGN: '+',
      MINUS_SIGN: '-',
      EXP_SYMBOL: 'E',
      PERMILL: '\u2030',
      INFINITY: '\u221E',
      NAN: 'NaN',
      DECIMAL_PATTERN: '#,##0.###',
      SCIENTIFIC_PATTERN: '#E0',
      PERCENT_PATTERN: '#,##0%',
      CURRENCY_PATTERN: '#,##0.00\u00A0\u00A4',
      DEF_CURRENCY_CODE: 'CHF'),
  // Number formatting symbols for locale fur.
  "fur": new NumberSymbols(
      NAME: "fur",
      DECIMAL_SEP: ',',
      GROUP_SEP: '.',
      PERCENT: '%',
      ZERO_DIGIT: '0',
      PLUS_SIGN: '+',
      MINUS_SIGN: '-',
      EXP_SYMBOL: 'E',
      PERMILL: '\u2030',
      INFINITY: '\u221E',
      NAN: 'NaN',
      DECIMAL_PATTERN: '#,##0.###',
      SCIENTIFIC_PATTERN: '#E0',
      PERCENT_PATTERN: '#,##0%',
      CURRENCY_PATTERN: '\u00A4\u00A0#,##0.00',
      DEF_CURRENCY_CODE: 'EUR'),
  // Number formatting symbols for locale ga.
  "ga": new NumberSymbols(
      NAME: "ga",
      DECIMAL_SEP: '.',
      GROUP_SEP: ',',
      PERCENT: '%',
      ZERO_DIGIT: '0',
      PLUS_SIGN: '+',
      MINUS_SIGN: '-',
      EXP_SYMBOL: 'E',
      PERMILL: '\u2030',
      INFINITY: '\u221E',
      NAN: 'Nuimh',
      DECIMAL_PATTERN: '#,##0.###',
      SCIENTIFIC_PATTERN: '#E0',
      PERCENT_PATTERN: '#,##0%',
      CURRENCY_PATTERN: '\u00A4#,##0.00',
      DEF_CURRENCY_CODE: 'EUR'),
  // Number formatting symbols for locale gl.
  "gl": new NumberSymbols(
      NAME: "gl",
      DECIMAL_SEP: ',',
      GROUP_SEP: '.',
      PERCENT: '%',
      ZERO_DIGIT: '0',
      PLUS_SIGN: '+',
      MINUS_SIGN: '-',
      EXP_SYMBOL: 'E',
      PERMILL: '\u2030',
      INFINITY: '\u221E',
      NAN: 'NaN',
      DECIMAL_PATTERN: '#,##0.###',
      SCIENTIFIC_PATTERN: '#E0',
      PERCENT_PATTERN: '#,##0\u00A0%',
      CURRENCY_PATTERN: '#,##0.00\u00A0\u00A4',
      DEF_CURRENCY_CODE: 'EUR'),
  // Number formatting symbols for locale gsw.
  "gsw": new NumberSymbols(
      NAME: "gsw",
      DECIMAL_SEP: '.',
      GROUP_SEP: '\u2019',
      PERCENT: '%',
      ZERO_DIGIT: '0',
      PLUS_SIGN: '+',
      MINUS_SIGN: '\u2212',
      EXP_SYMBOL: 'E',
      PERMILL: '\u2030',
      INFINITY: '\u221E',
      NAN: 'NaN',
      DECIMAL_PATTERN: '#,##0.###',
      SCIENTIFIC_PATTERN: '#E0',
      PERCENT_PATTERN: '#,##0\u00A0%',
      CURRENCY_PATTERN: '#,##0.00\u00A0\u00A4',
      DEF_CURRENCY_CODE: 'CHF'),
  // Number formatting symbols for locale gu.
  "gu": new NumberSymbols(
      NAME: "gu",
      DECIMAL_SEP: '.',
      GROUP_SEP: ',',
      PERCENT: '%',
      ZERO_DIGIT: '0',
      PLUS_SIGN: '+',
      MINUS_SIGN: '-',
      EXP_SYMBOL: 'E',
      PERMILL: '\u2030',
      INFINITY: '\u221E',
      NAN: 'NaN',
      DECIMAL_PATTERN: '#,##,##0.###',
      SCIENTIFIC_PATTERN: '[#E0]',
      PERCENT_PATTERN: '#,##,##0%',
      CURRENCY_PATTERN: '\u00A4#,##,##0.00',
      DEF_CURRENCY_CODE: 'INR'),
  // Number formatting symbols for locale haw.
  "haw": new NumberSymbols(
      NAME: "haw",
      DECIMAL_SEP: '.',
      GROUP_SEP: ',',
      PERCENT: '%',
      ZERO_DIGIT: '0',
      PLUS_SIGN: '+',
      MINUS_SIGN: '-',
      EXP_SYMBOL: 'E',
      PERMILL: '\u2030',
      INFINITY: '\u221E',
      NAN: 'NaN',
      DECIMAL_PATTERN: '#,##0.###',
      SCIENTIFIC_PATTERN: '#E0',
      PERCENT_PATTERN: '#,##0%',
      CURRENCY_PATTERN: '\u00A4#,##0.00',
      DEF_CURRENCY_CODE: 'USD'),
  // Number formatting symbols for locale he.
  "he": new NumberSymbols(
      NAME: "he",
      DECIMAL_SEP: '.',
      GROUP_SEP: ',',
      PERCENT: '%',
      ZERO_DIGIT: '0',
      PLUS_SIGN: '\u200E+',
      MINUS_SIGN: '\u200E-',
      EXP_SYMBOL: 'E',
      PERMILL: '\u2030',
      INFINITY: '\u221E',
      NAN: 'NaN',
      DECIMAL_PATTERN: '#,##0.###',
      SCIENTIFIC_PATTERN: '#E0',
      PERCENT_PATTERN: '#,##0%',
      CURRENCY_PATTERN:
          '\u200F#,##0.00\u00A0\u200F\u00A4;\u200F-#,##0.00\u00A0\u200F\u00A4',
      DEF_CURRENCY_CODE: 'ILS'),
  // Number formatting symbols for locale hi.
  "hi": new NumberSymbols(
      NAME: "hi",
      DECIMAL_SEP: '.',
      GROUP_SEP: ',',
      PERCENT: '%',
      ZERO_DIGIT: '0',
      PLUS_SIGN: '+',
      MINUS_SIGN: '-',
      EXP_SYMBOL: 'E',
      PERMILL: '\u2030',
      INFINITY: '\u221E',
      NAN: 'NaN',
      DECIMAL_PATTERN: '#,##,##0.###',
      SCIENTIFIC_PATTERN: '[#E0]',
      PERCENT_PATTERN: '#,##,##0%',
      CURRENCY_PATTERN: '\u00A4#,##,##0.00',
      DEF_CURRENCY_CODE: 'INR'),
  // Number formatting symbols for locale hr.
  "hr": new NumberSymbols(
      NAME: "hr",
      DECIMAL_SEP: ',',
      GROUP_SEP: '.',
      PERCENT: '%',
      ZERO_DIGIT: '0',
      PLUS_SIGN: '+',
      MINUS_SIGN: '\u2212',
      EXP_SYMBOL: 'E',
      PERMILL: '\u2030',
      INFINITY: '\u221E',
      NAN: 'NaN',
      DECIMAL_PATTERN: '#,##0.###',
      SCIENTIFIC_PATTERN: '#E0',
      PERCENT_PATTERN: '#,##0\u00A0%',
      CURRENCY_PATTERN: '#,##0.00\u00A0\u00A4',
      DEF_CURRENCY_CODE: 'EUR'),
  // Number formatting symbols for locale hu.
  "hu": new NumberSymbols(
      NAME: "hu",
      DECIMAL_SEP: ',',
      GROUP_SEP: '\u00A0',
      PERCENT: '%',
      ZERO_DIGIT: '0',
      PLUS_SIGN: '+',
      MINUS_SIGN: '-',
      EXP_SYMBOL: 'E',
      PERMILL: '\u2030',
      INFINITY: '\u221E',
      NAN: 'NaN',
      DECIMAL_PATTERN: '#,##0.###',
      SCIENTIFIC_PATTERN: '#E0',
      PERCENT_PATTERN: '#,##0%',
      CURRENCY_PATTERN: '#,##0.00\u00A0\u00A4',
      DEF_CURRENCY_CODE: 'HUF'),
  // Number formatting symbols for locale hy.
  "hy": new NumberSymbols(
      NAME: "hy",
      DECIMAL_SEP: ',',
      GROUP_SEP: '\u00A0',
      PERCENT: '%',
      ZERO_DIGIT: '0',
      PLUS_SIGN: '+',
      MINUS_SIGN: '-',
      EXP_SYMBOL: 'E',
      PERMILL: '\u2030',
      INFINITY: '\u221E',
      NAN: '\u0548\u0579\u0539',
      DECIMAL_PATTERN: '#,##0.###',
      SCIENTIFIC_PATTERN: '#E0',
      PERCENT_PATTERN: '#,##0%',
      CURRENCY_PATTERN: '#,##0.00\u00A0\u00A4',
      DEF_CURRENCY_CODE: 'AMD'),
  // Number formatting symbols for locale id.
  "id": new NumberSymbols(
      NAME: "id",
      DECIMAL_SEP: ',',
      GROUP_SEP: '.',
      PERCENT: '%',
      ZERO_DIGIT: '0',
      PLUS_SIGN: '+',
      MINUS_SIGN: '-',
      EXP_SYMBOL: 'E',
      PERMILL: '\u2030',
      INFINITY: '\u221E',
      NAN: 'NaN',
      DECIMAL_PATTERN: '#,##0.###',
      SCIENTIFIC_PATTERN: '#E0',
      PERCENT_PATTERN: '#,##0%',
      CURRENCY_PATTERN: '\u00A4#,##0.00',
      DEF_CURRENCY_CODE: 'IDR'),
  // Number formatting symbols for locale in.
  "in": new NumberSymbols(
      NAME: "in",
      DECIMAL_SEP: ',',
      GROUP_SEP: '.',
      PERCENT: '%',
      ZERO_DIGIT: '0',
      PLUS_SIGN: '+',
      MINUS_SIGN: '-',
      EXP_SYMBOL: 'E',
      PERMILL: '\u2030',
      INFINITY: '\u221E',
      NAN: 'NaN',
      DECIMAL_PATTERN: '#,##0.###',
      SCIENTIFIC_PATTERN: '#E0',
      PERCENT_PATTERN: '#,##0%',
      CURRENCY_PATTERN: '\u00A4#,##0.00',
      DEF_CURRENCY_CODE: 'IDR'),
  // Number formatting symbols for locale is.
  "is": new NumberSymbols(
      NAME: "is",
      DECIMAL_SEP: ',',
      GROUP_SEP: '.',
      PERCENT: '%',
      ZERO_DIGIT: '0',
      PLUS_SIGN: '+',
      MINUS_SIGN: '-',
      EXP_SYMBOL: 'E',
      PERMILL: '\u2030',
      INFINITY: '\u221E',
      NAN: 'NaN',
      DECIMAL_PATTERN: '#,##0.###',
      SCIENTIFIC_PATTERN: '#E0',
      PERCENT_PATTERN: '#,##0%',
      CURRENCY_PATTERN: '#,##0.00\u00A0\u00A4',
      DEF_CURRENCY_CODE: 'ISK'),
  // Number formatting symbols for locale it.
  "it": new NumberSymbols(
      NAME: "it",
      DECIMAL_SEP: ',',
      GROUP_SEP: '.',
      PERCENT: '%',
      ZERO_DIGIT: '0',
      PLUS_SIGN: '+',
      MINUS_SIGN: '-',
      EXP_SYMBOL: 'E',
      PERMILL: '\u2030',
      INFINITY: '\u221E',
      NAN: 'NaN',
      DECIMAL_PATTERN: '#,##0.###',
      SCIENTIFIC_PATTERN: '#E0',
      PERCENT_PATTERN: '#,##0%',
      CURRENCY_PATTERN: '#,##0.00\u00A0\u00A4',
      DEF_CURRENCY_CODE: 'EUR'),
  // Number formatting symbols for locale it_CH.
  "it_CH": new NumberSymbols(
      NAME: "it_CH",
      DECIMAL_SEP: '.',
      GROUP_SEP: '\u2019',
      PERCENT: '%',
      ZERO_DIGIT: '0',
      PLUS_SIGN: '+',
      MINUS_SIGN: '-',
      EXP_SYMBOL: 'E',
      PERMILL: '\u2030',
      INFINITY: '\u221E',
      NAN: 'NaN',
      DECIMAL_PATTERN: '#,##0.###',
      SCIENTIFIC_PATTERN: '#E0',
      PERCENT_PATTERN: '#,##0%',
      CURRENCY_PATTERN: '\u00A4\u00A0#,##0.00;\u00A4-#,##0.00',
      DEF_CURRENCY_CODE: 'CHF'),
  // Number formatting symbols for locale iw.
  "iw": new NumberSymbols(
      NAME: "iw",
      DECIMAL_SEP: '.',
      GROUP_SEP: ',',
      PERCENT: '%',
      ZERO_DIGIT: '0',
      PLUS_SIGN: '\u200E+',
      MINUS_SIGN: '\u200E-',
      EXP_SYMBOL: 'E',
      PERMILL: '\u2030',
      INFINITY: '\u221E',
      NAN: 'NaN',
      DECIMAL_PATTERN: '#,##0.###',
      SCIENTIFIC_PATTERN: '#E0',
      PERCENT_PATTERN: '#,##0%',
      CURRENCY_PATTERN:
          '\u200F#,##0.00\u00A0\u200F\u00A4;\u200F-#,##0.00\u00A0\u200F\u00A4',
      DEF_CURRENCY_CODE: 'ILS'),
  // Number formatting symbols for locale ja.
  "ja": new NumberSymbols(
      NAME: "ja",
      DECIMAL_SEP: '.',
      GROUP_SEP: ',',
      PERCENT: '%',
      ZERO_DIGIT: '0',
      PLUS_SIGN: '+',
      MINUS_SIGN: '-',
      EXP_SYMBOL: 'E',
      PERMILL: '\u2030',
      INFINITY: '\u221E',
      NAN: 'NaN',
      DECIMAL_PATTERN: '#,##0.###',
      SCIENTIFIC_PATTERN: '#E0',
      PERCENT_PATTERN: '#,##0%',
      CURRENCY_PATTERN: '\u00A4#,##0.00',
      DEF_CURRENCY_CODE: 'JPY'),
  // Number formatting symbols for locale ka.
  "ka": new NumberSymbols(
      NAME: "ka",
      DECIMAL_SEP: ',',
      GROUP_SEP: '\u00A0',
      PERCENT: '%',
      ZERO_DIGIT: '0',
      PLUS_SIGN: '+',
      MINUS_SIGN: '-',
      EXP_SYMBOL: 'E',
      PERMILL: '\u2030',
      INFINITY: '\u221E',
      NAN:
          '\u10D0\u10E0\u00A0\u10D0\u10E0\u10D8\u10E1\u00A0\u10E0\u10D8\u10EA\u10EE\u10D5\u10D8',
      DECIMAL_PATTERN: '#,##0.###',
      SCIENTIFIC_PATTERN: '#E0',
      PERCENT_PATTERN: '#,##0%',
      CURRENCY_PATTERN: '#,##0.00\u00A0\u00A4',
      DEF_CURRENCY_CODE: 'GEL'),
  // Number formatting symbols for locale kk.
  "kk": new NumberSymbols(
      NAME: "kk",
      DECIMAL_SEP: ',',
      GROUP_SEP: '\u00A0',
      PERCENT: '%',
      ZERO_DIGIT: '0',
      PLUS_SIGN: '+',
      MINUS_SIGN: '-',
      EXP_SYMBOL: 'E',
      PERMILL: '\u2030',
      INFINITY: '\u221E',
      NAN: '\u0441\u0430\u043D\u00A0\u0435\u043C\u0435\u0441',
      DECIMAL_PATTERN: '#,##0.###',
      SCIENTIFIC_PATTERN: '#E0',
      PERCENT_PATTERN: '#,##0%',
      CURRENCY_PATTERN: '#,##0.00\u00A0\u00A4',
      DEF_CURRENCY_CODE: 'KZT'),
  // Number formatting symbols for locale km.
  "km": new NumberSymbols(
      NAME: "km",
      DECIMAL_SEP: '.',
      GROUP_SEP: ',',
      PERCENT: '%',
      ZERO_DIGIT: '0',
      PLUS_SIGN: '+',
      MINUS_SIGN: '-',
      EXP_SYMBOL: 'E',
      PERMILL: '\u2030',
      INFINITY: '\u221E',
      NAN: 'NaN',
      DECIMAL_PATTERN: '#,##0.###',
      SCIENTIFIC_PATTERN: '#E0',
      PERCENT_PATTERN: '#,##0%',
      CURRENCY_PATTERN: '#,##0.00\u00A4',
      DEF_CURRENCY_CODE: 'KHR'),
  // Number formatting symbols for locale kn.
  "kn": new NumberSymbols(
      NAME: "kn",
      DECIMAL_SEP: '.',
      GROUP_SEP: ',',
      PERCENT: '%',
      ZERO_DIGIT: '0',
      PLUS_SIGN: '+',
      MINUS_SIGN: '-',
      EXP_SYMBOL: 'E',
      PERMILL: '\u2030',
      INFINITY: '\u221E',
      NAN: 'NaN',
      DECIMAL_PATTERN: '#,##0.###',
      SCIENTIFIC_PATTERN: '#E0',
      PERCENT_PATTERN: '#,##0%',
      CURRENCY_PATTERN: '\u00A4#,##0.00',
      DEF_CURRENCY_CODE: 'INR'),
  // Number formatting symbols for locale ko.
  "ko": new NumberSymbols(
      NAME: "ko",
      DECIMAL_SEP: '.',
      GROUP_SEP: ',',
      PERCENT: '%',
      ZERO_DIGIT: '0',
      PLUS_SIGN: '+',
      MINUS_SIGN: '-',
      EXP_SYMBOL: 'E',
      PERMILL: '\u2030',
      INFINITY: '\u221E',
      NAN: 'NaN',
      DECIMAL_PATTERN: '#,##0.###',
      SCIENTIFIC_PATTERN: '#E0',
      PERCENT_PATTERN: '#,##0%',
      CURRENCY_PATTERN: '\u00A4#,##0.00',
      DEF_CURRENCY_CODE: 'KRW'),
  // Number formatting symbols for locale ky.
  "ky": new NumberSymbols(
      NAME: "ky",
      DECIMAL_SEP: ',',
      GROUP_SEP: '\u00A0',
      PERCENT: '%',
      ZERO_DIGIT: '0',
      PLUS_SIGN: '+',
      MINUS_SIGN: '-',
      EXP_SYMBOL: 'E',
      PERMILL: '\u2030',
      INFINITY: '\u221E',
      NAN: '\u0441\u0430\u043D\u00A0\u044D\u043C\u0435\u0441',
      DECIMAL_PATTERN: '#,##0.###',
      SCIENTIFIC_PATTERN: '#E0',
      PERCENT_PATTERN: '#,##0%',
      CURRENCY_PATTERN: '#,##0.00\u00A0\u00A4',
      DEF_CURRENCY_CODE: 'KGS'),
  // Number formatting symbols for locale ln.
  "ln": new NumberSymbols(
      NAME: "ln",
      DECIMAL_SEP: ',',
      GROUP_SEP: '.',
      PERCENT: '%',
      ZERO_DIGIT: '0',
      PLUS_SIGN: '+',
      MINUS_SIGN: '-',
      EXP_SYMBOL: 'E',
      PERMILL: '\u2030',
      INFINITY: '\u221E',
      NAN: 'NaN',
      DECIMAL_PATTERN: '#,##0.###',
      SCIENTIFIC_PATTERN: '#E0',
      PERCENT_PATTERN: '#,##0%',
      CURRENCY_PATTERN: '#,##0.00\u00A0\u00A4',
      DEF_CURRENCY_CODE: 'CDF'),
  // Number formatting symbols for locale lo.
  "lo": new NumberSymbols(
      NAME: "lo",
      DECIMAL_SEP: ',',
      GROUP_SEP: '.',
      PERCENT: '%',
      ZERO_DIGIT: '0',
      PLUS_SIGN: '+',
      MINUS_SIGN: '-',
      EXP_SYMBOL: 'E',
      PERMILL: '\u2030',
      INFINITY: '\u221E',
      NAN:
          '\u0E9A\u0ECD\u0EC8\u200B\u0EC1\u0EA1\u0EC8\u0E99\u200B\u0EC2\u0E95\u200B\u0EC0\u0EA5\u0E81',
      DECIMAL_PATTERN: '#,##0.###',
      SCIENTIFIC_PATTERN: '#',
      PERCENT_PATTERN: '#,##0%',
      CURRENCY_PATTERN: '\u00A4#,##0.00;\u00A4-#,##0.00',
      DEF_CURRENCY_CODE: 'LAK'),
  // Number formatting symbols for locale lt.
  "lt": new NumberSymbols(
      NAME: "lt",
      DECIMAL_SEP: ',',
      GROUP_SEP: '\u00A0',
      PERCENT: '%',
      ZERO_DIGIT: '0',
      PLUS_SIGN: '+',
      MINUS_SIGN: '\u2212',
      EXP_SYMBOL: '\u00D710^',
      PERMILL: '\u2030',
      INFINITY: '\u221E',
      NAN: 'NaN',
      DECIMAL_PATTERN: '#,##0.###',
      SCIENTIFIC_PATTERN: '#E0',
      PERCENT_PATTERN: '#,##0\u00A0%',
      CURRENCY_PATTERN: '#,##0.00\u00A0\u00A4',
      DEF_CURRENCY_CODE: 'EUR'),
  // Number formatting symbols for locale lv.
  "lv": new NumberSymbols(
      NAME: "lv",
      DECIMAL_SEP: ',',
      GROUP_SEP: '\u00A0',
      PERCENT: '%',
      ZERO_DIGIT: '0',
      PLUS_SIGN: '+',
      MINUS_SIGN: '-',
      EXP_SYMBOL: 'E',
      PERMILL: '\u2030',
      INFINITY: '\u221E',
      NAN: 'NS',
      DECIMAL_PATTERN: '#,##0.###',
      SCIENTIFIC_PATTERN: '#E0',
      PERCENT_PATTERN: '#,##0%',
      CURRENCY_PATTERN: '#,##0.00\u00A0\u00A4',
      DEF_CURRENCY_CODE: 'EUR'),
  // Number formatting symbols for locale mg.
  "mg": new NumberSymbols(
      NAME: "mg",
      DECIMAL_SEP: '.',
      GROUP_SEP: ',',
      PERCENT: '%',
      ZERO_DIGIT: '0',
      PLUS_SIGN: '+',
      MINUS_SIGN: '-',
      EXP_SYMBOL: 'E',
      PERMILL: '\u2030',
      INFINITY: '\u221E',
      NAN: 'NaN',
      DECIMAL_PATTERN: '#,##0.###',
      SCIENTIFIC_PATTERN: '#E0',
      PERCENT_PATTERN: '#,##0%',
      CURRENCY_PATTERN: '\u00A4#,##0.00',
      DEF_CURRENCY_CODE: 'MGA'),
  // Number formatting symbols for locale mk.
  "mk": new NumberSymbols(
      NAME: "mk",
      DECIMAL_SEP: ',',
      GROUP_SEP: '.',
      PERCENT: '%',
      ZERO_DIGIT: '0',
      PLUS_SIGN: '+',
      MINUS_SIGN: '-',
      EXP_SYMBOL: 'E',
      PERMILL: '\u2030',
      INFINITY: '\u221E',
      NAN: 'NaN',
      DECIMAL_PATTERN: '#,##0.###',
      SCIENTIFIC_PATTERN: '#E0',
      PERCENT_PATTERN: '#,##0\u00A0%',
      CURRENCY_PATTERN: '#,##0.00\u00A0\u00A4',
      DEF_CURRENCY_CODE: 'MKD'),
  // Number formatting symbols for locale ml.
  "ml": new NumberSymbols(
      NAME: "ml",
      DECIMAL_SEP: '.',
      GROUP_SEP: ',',
      PERCENT: '%',
      ZERO_DIGIT: '0',
      PLUS_SIGN: '+',
      MINUS_SIGN: '-',
      EXP_SYMBOL: 'E',
      PERMILL: '\u2030',
      INFINITY: '\u221E',
      NAN: 'NaN',
      DECIMAL_PATTERN: '#,##,##0.###',
      SCIENTIFIC_PATTERN: '#E0',
      PERCENT_PATTERN: '#,##0%',
      CURRENCY_PATTERN: '\u00A4#,##0.00',
      DEF_CURRENCY_CODE: 'INR'),
  // Number formatting symbols for locale mn.
  "mn": new NumberSymbols(
      NAME: "mn",
      DECIMAL_SEP: '.',
      GROUP_SEP: ',',
      PERCENT: '%',
      ZERO_DIGIT: '0',
      PLUS_SIGN: '+',
      MINUS_SIGN: '-',
      EXP_SYMBOL: 'E',
      PERMILL: '\u2030',
      INFINITY: '\u221E',
      NAN: 'NaN',
      DECIMAL_PATTERN: '#,##0.###',
      SCIENTIFIC_PATTERN: '#E0',
      PERCENT_PATTERN: '#,##0%',
      CURRENCY_PATTERN: '\u00A4\u00A0#,##0.00',
      DEF_CURRENCY_CODE: 'MNT'),
  // Number formatting symbols for locale mr.
  "mr": new NumberSymbols(
      NAME: "mr",
      DECIMAL_SEP: '.',
      GROUP_SEP: ',',
      PERCENT: '%',
      ZERO_DIGIT: '\u0966',
      PLUS_SIGN: '+',
      MINUS_SIGN: '-',
      EXP_SYMBOL: 'E',
      PERMILL: '\u2030',
      INFINITY: '\u221E',
      NAN: 'NaN',
      DECIMAL_PATTERN: '#,##,##0.###',
      SCIENTIFIC_PATTERN: '[#E0]',
      PERCENT_PATTERN: '#,##0%',
      CURRENCY_PATTERN: '\u00A4#,##0.00',
      DEF_CURRENCY_CODE: 'INR'),
  // Number formatting symbols for locale ms.
  "ms": new NumberSymbols(
      NAME: "ms",
      DECIMAL_SEP: '.',
      GROUP_SEP: ',',
      PERCENT: '%',
      ZERO_DIGIT: '0',
      PLUS_SIGN: '+',
      MINUS_SIGN: '-',
      EXP_SYMBOL: 'E',
      PERMILL: '\u2030',
      INFINITY: '\u221E',
      NAN: 'NaN',
      DECIMAL_PATTERN: '#,##0.###',
      SCIENTIFIC_PATTERN: '#E0',
      PERCENT_PATTERN: '#,##0%',
      CURRENCY_PATTERN: '\u00A4#,##0.00',
      DEF_CURRENCY_CODE: 'MYR'),
  // Number formatting symbols for locale mt.
  "mt": new NumberSymbols(
      NAME: "mt",
      DECIMAL_SEP: '.',
      GROUP_SEP: ',',
      PERCENT: '%',
      ZERO_DIGIT: '0',
      PLUS_SIGN: '+',
      MINUS_SIGN: '-',
      EXP_SYMBOL: 'E',
      PERMILL: '\u2030',
      INFINITY: '\u221E',
      NAN: 'NaN',
      DECIMAL_PATTERN: '#,##0.###',
      SCIENTIFIC_PATTERN: '#E0',
      PERCENT_PATTERN: '#,##0%',
      CURRENCY_PATTERN: '\u00A4#,##0.00',
      DEF_CURRENCY_CODE: 'EUR'),
  // Number formatting symbols for locale my.
  "my": new NumberSymbols(
      NAME: "my",
      DECIMAL_SEP: '.',
      GROUP_SEP: ',',
      PERCENT: '%',
      ZERO_DIGIT: '\u1040',
      PLUS_SIGN: '+',
      MINUS_SIGN: '-',
      EXP_SYMBOL: 'E',
      PERMILL: '\u2030',
      INFINITY: '\u221E',
      NAN:
          '\u1002\u100F\u1014\u103A\u1038\u1019\u101F\u102F\u1010\u103A\u101E\u1031\u102C',
      DECIMAL_PATTERN: '#,##0.###',
      SCIENTIFIC_PATTERN: '#E0',
      PERCENT_PATTERN: '#,##0%',
      CURRENCY_PATTERN: '#,##0.00\u00A0\u00A4',
      DEF_CURRENCY_CODE: 'MMK'),
  // Number formatting symbols for locale nb.
  "nb": new NumberSymbols(
      NAME: "nb",
      DECIMAL_SEP: ',',
      GROUP_SEP: '\u00A0',
      PERCENT: '%',
      ZERO_DIGIT: '0',
      PLUS_SIGN: '+',
      MINUS_SIGN: '\u2212',
      EXP_SYMBOL: 'E',
      PERMILL: '\u2030',
      INFINITY: '\u221E',
      NAN: 'NaN',
      DECIMAL_PATTERN: '#,##0.###',
      SCIENTIFIC_PATTERN: '#E0',
      PERCENT_PATTERN: '#,##0\u00A0%',
      CURRENCY_PATTERN: '#,##0.00\u00A0\u00A4;-#,##0.00\u00A0\u00A4',
      DEF_CURRENCY_CODE: 'NOK'),
  // Number formatting symbols for locale ne.
  "ne": new NumberSymbols(
      NAME: "ne",
      DECIMAL_SEP: '.',
      GROUP_SEP: ',',
      PERCENT: '%',
      ZERO_DIGIT: '\u0966',
      PLUS_SIGN: '+',
      MINUS_SIGN: '-',
      EXP_SYMBOL: 'E',
      PERMILL: '\u2030',
      INFINITY: '\u221E',
      NAN: 'NaN',
      DECIMAL_PATTERN: '#,##,##0.###',
      SCIENTIFIC_PATTERN: '#E0',
      PERCENT_PATTERN: '#,##,##0%',
      CURRENCY_PATTERN: '\u00A4\u00A0#,##,##0.00',
      DEF_CURRENCY_CODE: 'NPR'),
  // Number formatting symbols for locale nl.
  "nl": new NumberSymbols(
      NAME: "nl",
      DECIMAL_SEP: ',',
      GROUP_SEP: '.',
      PERCENT: '%',
      ZERO_DIGIT: '0',
      PLUS_SIGN: '+',
      MINUS_SIGN: '-',
      EXP_SYMBOL: 'E',
      PERMILL: '\u2030',
      INFINITY: '\u221E',
      NAN: 'NaN',
      DECIMAL_PATTERN: '#,##0.###',
      SCIENTIFIC_PATTERN: '#E0',
      PERCENT_PATTERN: '#,##0%',
      CURRENCY_PATTERN: '\u00A4\u00A0#,##0.00;\u00A4\u00A0-#,##0.00',
      DEF_CURRENCY_CODE: 'EUR'),
  // Number formatting symbols for locale no.
  "no": new NumberSymbols(
      NAME: "no",
      DECIMAL_SEP: ',',
      GROUP_SEP: '\u00A0',
      PERCENT: '%',
      ZERO_DIGIT: '0',
      PLUS_SIGN: '+',
      MINUS_SIGN: '\u2212',
      EXP_SYMBOL: 'E',
      PERMILL: '\u2030',
      INFINITY: '\u221E',
      NAN: 'NaN',
      DECIMAL_PATTERN: '#,##0.###',
      SCIENTIFIC_PATTERN: '#E0',
      PERCENT_PATTERN: '#,##0\u00A0%',
      CURRENCY_PATTERN: '#,##0.00\u00A0\u00A4;-#,##0.00\u00A0\u00A4',
      DEF_CURRENCY_CODE: 'NOK'),
  // Number formatting symbols for locale no_NO.
  "no_NO": new NumberSymbols(
      NAME: "no_NO",
      DECIMAL_SEP: ',',
      GROUP_SEP: '\u00A0',
      PERCENT: '%',
      ZERO_DIGIT: '0',
      PLUS_SIGN: '+',
      MINUS_SIGN: '\u2212',
      EXP_SYMBOL: 'E',
      PERMILL: '\u2030',
      INFINITY: '\u221E',
      NAN: 'NaN',
      DECIMAL_PATTERN: '#,##0.###',
      SCIENTIFIC_PATTERN: '#E0',
      PERCENT_PATTERN: '#,##0\u00A0%',
      CURRENCY_PATTERN: '#,##0.00\u00A0\u00A4;-#,##0.00\u00A0\u00A4',
      DEF_CURRENCY_CODE: 'NOK'),
  // Number formatting symbols for locale nyn.
  "nyn": new NumberSymbols(
      NAME: "nyn",
      DECIMAL_SEP: '.',
      GROUP_SEP: ',',
      PERCENT: '%',
      ZERO_DIGIT: '0',
      PLUS_SIGN: '+',
      MINUS_SIGN: '-',
      EXP_SYMBOL: 'E',
      PERMILL: '\u2030',
      INFINITY: '\u221E',
      NAN: 'NaN',
      DECIMAL_PATTERN: '#,##0.###',
      SCIENTIFIC_PATTERN: '#E0',
      PERCENT_PATTERN: '#,##0%',
      CURRENCY_PATTERN: '\u00A4#,##0.00',
      DEF_CURRENCY_CODE: 'UGX'),
  // Number formatting symbols for locale or.
  "or": new NumberSymbols(
      NAME: "or",
      DECIMAL_SEP: '.',
      GROUP_SEP: ',',
      PERCENT: '%',
      ZERO_DIGIT: '0',
      PLUS_SIGN: '+',
      MINUS_SIGN: '-',
      EXP_SYMBOL: 'E',
      PERMILL: '\u2030',
      INFINITY: '\u221E',
      NAN: 'NaN',
      DECIMAL_PATTERN: '#,##,##0.###',
      SCIENTIFIC_PATTERN: '#E0',
      PERCENT_PATTERN: '#,##0%',
      CURRENCY_PATTERN: '\u00A4#,##0.00',
      DEF_CURRENCY_CODE: 'INR'),
  // Number formatting symbols for locale pa.
  "pa": new NumberSymbols(
      NAME: "pa",
      DECIMAL_SEP: '.',
      GROUP_SEP: ',',
      PERCENT: '%',
      ZERO_DIGIT: '0',
      PLUS_SIGN: '+',
      MINUS_SIGN: '-',
      EXP_SYMBOL: 'E',
      PERMILL: '\u2030',
      INFINITY: '\u221E',
      NAN: 'NaN',
      DECIMAL_PATTERN: '#,##,##0.###',
      SCIENTIFIC_PATTERN: '[#E0]',
      PERCENT_PATTERN: '#,##,##0%',
      CURRENCY_PATTERN: '\u00A4#,##,##0.00',
      DEF_CURRENCY_CODE: 'INR'),
  // Number formatting symbols for locale pl.
  "pl": new NumberSymbols(
      NAME: "pl",
      DECIMAL_SEP: ',',
      GROUP_SEP: '\u00A0',
      PERCENT: '%',
      ZERO_DIGIT: '0',
      PLUS_SIGN: '+',
      MINUS_SIGN: '-',
      EXP_SYMBOL: 'E',
      PERMILL: '\u2030',
      INFINITY: '\u221E',
      NAN: 'NaN',
      DECIMAL_PATTERN: '#,##0.###',
      SCIENTIFIC_PATTERN: '#E0',
      PERCENT_PATTERN: '#,##0%',
      CURRENCY_PATTERN: '#,##0.00\u00A0\u00A4',
      DEF_CURRENCY_CODE: 'PLN'),
  // Number formatting symbols for locale ps.
  "ps": new NumberSymbols(
      NAME: "ps",
      DECIMAL_SEP: '\u066B',
      GROUP_SEP: '\u066C',
      PERCENT: '\u066A',
      ZERO_DIGIT: '\u06F0',
      PLUS_SIGN: '\u200E+\u200E',
      MINUS_SIGN: '\u200E-\u200E',
      EXP_SYMBOL: '\u00D7\u06F1\u06F0^',
      PERMILL: '\u0609',
      INFINITY: '\u221E',
      NAN: 'NaN',
      DECIMAL_PATTERN: '#,##0.###',
      SCIENTIFIC_PATTERN: '#E0',
      PERCENT_PATTERN: '#,##0%',
      CURRENCY_PATTERN: '\u00A4#,##0.00;(\u00A4#,##0.00)',
      DEF_CURRENCY_CODE: 'AFN'),
  // Number formatting symbols for locale pt.
  "pt": new NumberSymbols(
      NAME: "pt",
      DECIMAL_SEP: ',',
      GROUP_SEP: '.',
      PERCENT: '%',
      ZERO_DIGIT: '0',
      PLUS_SIGN: '+',
      MINUS_SIGN: '-',
      EXP_SYMBOL: 'E',
      PERMILL: '\u2030',
      INFINITY: '\u221E',
      NAN: 'NaN',
      DECIMAL_PATTERN: '#,##0.###',
      SCIENTIFIC_PATTERN: '#E0',
      PERCENT_PATTERN: '#,##0%',
      CURRENCY_PATTERN: '\u00A4\u00A0#,##0.00',
      DEF_CURRENCY_CODE: 'BRL'),
  // Number formatting symbols for locale pt_BR.
  "pt_BR": new NumberSymbols(
      NAME: "pt_BR",
      DECIMAL_SEP: ',',
      GROUP_SEP: '.',
      PERCENT: '%',
      ZERO_DIGIT: '0',
      PLUS_SIGN: '+',
      MINUS_SIGN: '-',
      EXP_SYMBOL: 'E',
      PERMILL: '\u2030',
      INFINITY: '\u221E',
      NAN: 'NaN',
      DECIMAL_PATTERN: '#,##0.###',
      SCIENTIFIC_PATTERN: '#E0',
      PERCENT_PATTERN: '#,##0%',
      CURRENCY_PATTERN: '\u00A4\u00A0#,##0.00',
      DEF_CURRENCY_CODE: 'BRL'),
  // Number formatting symbols for locale pt_PT.
  "pt_PT": new NumberSymbols(
      NAME: "pt_PT",
      DECIMAL_SEP: ',',
      GROUP_SEP: '\u00A0',
      PERCENT: '%',
      ZERO_DIGIT: '0',
      PLUS_SIGN: '+',
      MINUS_SIGN: '-',
      EXP_SYMBOL: 'E',
      PERMILL: '\u2030',
      INFINITY: '\u221E',
      NAN: 'NaN',
      DECIMAL_PATTERN: '#,##0.###',
      SCIENTIFIC_PATTERN: '#E0',
      PERCENT_PATTERN: '#,##0%',
      CURRENCY_PATTERN: '#,##0.00\u00A0\u00A4',
      DEF_CURRENCY_CODE: 'EUR'),
  // Number formatting symbols for locale ro.
  "ro": new NumberSymbols(
      NAME: "ro",
      DECIMAL_SEP: ',',
      GROUP_SEP: '.',
      PERCENT: '%',
      ZERO_DIGIT: '0',
      PLUS_SIGN: '+',
      MINUS_SIGN: '-',
      EXP_SYMBOL: 'E',
      PERMILL: '\u2030',
      INFINITY: '\u221E',
      NAN: 'NaN',
      DECIMAL_PATTERN: '#,##0.###',
      SCIENTIFIC_PATTERN: '#E0',
      PERCENT_PATTERN: '#,##0\u00A0%',
      CURRENCY_PATTERN: '#,##0.00\u00A0\u00A4',
      DEF_CURRENCY_CODE: 'RON'),
  // Number formatting symbols for locale ru.
  "ru": new NumberSymbols(
      NAME: "ru",
      DECIMAL_SEP: ',',
      GROUP_SEP: '\u00A0',
      PERCENT: '%',
      ZERO_DIGIT: '0',
      PLUS_SIGN: '+',
      MINUS_SIGN: '-',
      EXP_SYMBOL: 'E',
      PERMILL: '\u2030',
      INFINITY: '\u221E',
      NAN: '\u043D\u0435\u00A0\u0447\u0438\u0441\u043B\u043E',
      DECIMAL_PATTERN: '#,##0.###',
      SCIENTIFIC_PATTERN: '#E0',
      PERCENT_PATTERN: '#,##0\u00A0%',
      CURRENCY_PATTERN: '#,##0.00\u00A0\u00A4',
      DEF_CURRENCY_CODE: 'RUB'),
  // Number formatting symbols for locale si.
  "si": new NumberSymbols(
      NAME: "si",
      DECIMAL_SEP: '.',
      GROUP_SEP: ',',
      PERCENT: '%',
      ZERO_DIGIT: '0',
      PLUS_SIGN: '+',
      MINUS_SIGN: '-',
      EXP_SYMBOL: 'E',
      PERMILL: '\u2030',
      INFINITY: '\u221E',
      NAN: 'NaN',
      DECIMAL_PATTERN: '#,##0.###',
      SCIENTIFIC_PATTERN: '#',
      PERCENT_PATTERN: '#,##0%',
      CURRENCY_PATTERN: '\u00A4#,##0.00',
      DEF_CURRENCY_CODE: 'LKR'),
  // Number formatting symbols for locale sk.
  "sk": new NumberSymbols(
      NAME: "sk",
      DECIMAL_SEP: ',',
      GROUP_SEP: '\u00A0',
      PERCENT: '%',
      ZERO_DIGIT: '0',
      PLUS_SIGN: '+',
      MINUS_SIGN: '-',
      EXP_SYMBOL: 'e',
      PERMILL: '\u2030',
      INFINITY: '\u221E',
      NAN: 'NaN',
      DECIMAL_PATTERN: '#,##0.###',
      SCIENTIFIC_PATTERN: '#E0',
      PERCENT_PATTERN: '#,##0\u00A0%',
      CURRENCY_PATTERN: '#,##0.00\u00A0\u00A4',
      DEF_CURRENCY_CODE: 'EUR'),
  // Number formatting symbols for locale sl.
  "sl": new NumberSymbols(
      NAME: "sl",
      DECIMAL_SEP: ',',
      GROUP_SEP: '.',
      PERCENT: '%',
      ZERO_DIGIT: '0',
      PLUS_SIGN: '+',
      MINUS_SIGN: '\u2212',
      EXP_SYMBOL: 'e',
      PERMILL: '\u2030',
      INFINITY: '\u221E',
      NAN: 'NaN',
      DECIMAL_PATTERN: '#,##0.###',
      SCIENTIFIC_PATTERN: '#E0',
      PERCENT_PATTERN: '#,##0\u00A0%',
      CURRENCY_PATTERN: '#,##0.00\u00A0\u00A4',
      DEF_CURRENCY_CODE: 'EUR'),
  // Number formatting symbols for locale sq.
  "sq": new NumberSymbols(
      NAME: "sq",
      DECIMAL_SEP: ',',
      GROUP_SEP: '\u00A0',
      PERCENT: '%',
      ZERO_DIGIT: '0',
      PLUS_SIGN: '+',
      MINUS_SIGN: '-',
      EXP_SYMBOL: 'E',
      PERMILL: '\u2030',
      INFINITY: '\u221E',
      NAN: 'NaN',
      DECIMAL_PATTERN: '#,##0.###',
      SCIENTIFIC_PATTERN: '#E0',
      PERCENT_PATTERN: '#,##0%',
      CURRENCY_PATTERN: '#,##0.00\u00A0\u00A4',
      DEF_CURRENCY_CODE: 'ALL'),
  // Number formatting symbols for locale sr.
  "sr": new NumberSymbols(
      NAME: "sr",
      DECIMAL_SEP: ',',
      GROUP_SEP: '.',
      PERCENT: '%',
      ZERO_DIGIT: '0',
      PLUS_SIGN: '+',
      MINUS_SIGN: '-',
      EXP_SYMBOL: 'E',
      PERMILL: '\u2030',
      INFINITY: '\u221E',
      NAN: 'NaN',
      DECIMAL_PATTERN: '#,##0.###',
      SCIENTIFIC_PATTERN: '#E0',
      PERCENT_PATTERN: '#,##0%',
      CURRENCY_PATTERN: '#,##0.00\u00A0\u00A4',
      DEF_CURRENCY_CODE: 'RSD'),
  // Number formatting symbols for locale sr_Latn.
  "sr_Latn": new NumberSymbols(
      NAME: "sr_Latn",
      DECIMAL_SEP: ',',
      GROUP_SEP: '.',
      PERCENT: '%',
      ZERO_DIGIT: '0',
      PLUS_SIGN: '+',
      MINUS_SIGN: '-',
      EXP_SYMBOL: 'E',
      PERMILL: '\u2030',
      INFINITY: '\u221E',
      NAN: 'NaN',
      DECIMAL_PATTERN: '#,##0.###',
      SCIENTIFIC_PATTERN: '#E0',
      PERCENT_PATTERN: '#,##0%',
      CURRENCY_PATTERN: '#,##0.00\u00A0\u00A4',
      DEF_CURRENCY_CODE: 'RSD'),
  // Number formatting symbols for locale sv.
  "sv": new NumberSymbols(
      NAME: "sv",
      DECIMAL_SEP: ',',
      GROUP_SEP: '\u00A0',
      PERCENT: '%',
      ZERO_DIGIT: '0',
      PLUS_SIGN: '+',
      MINUS_SIGN: '\u2212',
      EXP_SYMBOL: '\u00D710^',
      PERMILL: '\u2030',
      INFINITY: '\u221E',
      NAN: 'NaN',
      DECIMAL_PATTERN: '#,##0.###',
      SCIENTIFIC_PATTERN: '#E0',
      PERCENT_PATTERN: '#,##0\u00A0%',
      CURRENCY_PATTERN: '#,##0.00\u00A0\u00A4',
      DEF_CURRENCY_CODE: 'SEK'),
  // Number formatting symbols for locale sw.
  "sw": new NumberSymbols(
      NAME: "sw",
      DECIMAL_SEP: '.',
      GROUP_SEP: ',',
      PERCENT: '%',
      ZERO_DIGIT: '0',
      PLUS_SIGN: '+',
      MINUS_SIGN: '-',
      EXP_SYMBOL: 'E',
      PERMILL: '\u2030',
      INFINITY: '\u221E',
      NAN: 'NaN',
      DECIMAL_PATTERN: '#,##0.###',
      SCIENTIFIC_PATTERN: '#E0',
      PERCENT_PATTERN: '#,##0%',
      CURRENCY_PATTERN: '\u00A4\u00A0#,##0.00',
      DEF_CURRENCY_CODE: 'TZS'),
  // Number formatting symbols for locale ta.
  "ta": new NumberSymbols(
      NAME: "ta",
      DECIMAL_SEP: '.',
      GROUP_SEP: ',',
      PERCENT: '%',
      ZERO_DIGIT: '0',
      PLUS_SIGN: '+',
      MINUS_SIGN: '-',
      EXP_SYMBOL: 'E',
      PERMILL: '\u2030',
      INFINITY: '\u221E',
      NAN: 'NaN',
      DECIMAL_PATTERN: '#,##,##0.###',
      SCIENTIFIC_PATTERN: '#E0',
      PERCENT_PATTERN: '#,##,##0%',
      CURRENCY_PATTERN: '\u00A4#,##,##0.00',
      DEF_CURRENCY_CODE: 'INR'),
  // Number formatting symbols for locale te.
  "te": new NumberSymbols(
      NAME: "te",
      DECIMAL_SEP: '.',
      GROUP_SEP: ',',
      PERCENT: '%',
      ZERO_DIGIT: '0',
      PLUS_SIGN: '+',
      MINUS_SIGN: '-',
      EXP_SYMBOL: 'E',
      PERMILL: '\u2030',
      INFINITY: '\u221E',
      NAN: 'NaN',
      DECIMAL_PATTERN: '#,##,##0.###',
      SCIENTIFIC_PATTERN: '#E0',
      PERCENT_PATTERN: '#,##0%',
      CURRENCY_PATTERN: '\u00A4#,##,##0.00',
      DEF_CURRENCY_CODE: 'INR'),
  // Number formatting symbols for locale th.
  "th": new NumberSymbols(
      NAME: "th",
      DECIMAL_SEP: '.',
      GROUP_SEP: ',',
      PERCENT: '%',
      ZERO_DIGIT: '0',
      PLUS_SIGN: '+',
      MINUS_SIGN: '-',
      EXP_SYMBOL: 'E',
      PERMILL: '\u2030',
      INFINITY: '\u221E',
      NAN: 'NaN',
      DECIMAL_PATTERN: '#,##0.###',
      SCIENTIFIC_PATTERN: '#E0',
      PERCENT_PATTERN: '#,##0%',
      CURRENCY_PATTERN: '\u00A4#,##0.00',
      DEF_CURRENCY_CODE: 'THB'),
  // Number formatting symbols for locale tl.
  "tl": new NumberSymbols(
      NAME: "tl",
      DECIMAL_SEP: '.',
      GROUP_SEP: ',',
      PERCENT: '%',
      ZERO_DIGIT: '0',
      PLUS_SIGN: '+',
      MINUS_SIGN: '-',
      EXP_SYMBOL: 'E',
      PERMILL: '\u2030',
      INFINITY: '\u221E',
      NAN: 'NaN',
      DECIMAL_PATTERN: '#,##0.###',
      SCIENTIFIC_PATTERN: '#E0',
      PERCENT_PATTERN: '#,##0%',
      CURRENCY_PATTERN: '\u00A4#,##0.00',
      DEF_CURRENCY_CODE: 'PHP'),
  // Number formatting symbols for locale tr.
  "tr": new NumberSymbols(
      NAME: "tr",
      DECIMAL_SEP: ',',
      GROUP_SEP: '.',
      PERCENT: '%',
      ZERO_DIGIT: '0',
      PLUS_SIGN: '+',
      MINUS_SIGN: '-',
      EXP_SYMBOL: 'E',
      PERMILL: '\u2030',
      INFINITY: '\u221E',
      NAN: 'NaN',
      DECIMAL_PATTERN: '#,##0.###',
      SCIENTIFIC_PATTERN: '#E0',
      PERCENT_PATTERN: '%#,##0',
      CURRENCY_PATTERN: '\u00A4#,##0.00',
      DEF_CURRENCY_CODE: 'TRY'),
  // Number formatting symbols for locale uk.
  "uk": new NumberSymbols(
      NAME: "uk",
      DECIMAL_SEP: ',',
      GROUP_SEP: '\u00A0',
      PERCENT: '%',
      ZERO_DIGIT: '0',
      PLUS_SIGN: '+',
      MINUS_SIGN: '-',
      EXP_SYMBOL: '\u0415',
      PERMILL: '\u2030',
      INFINITY: '\u221E',
      NAN: 'NaN',
      DECIMAL_PATTERN: '#,##0.###',
      SCIENTIFIC_PATTERN: '#E0',
      PERCENT_PATTERN: '#,##0%',
      CURRENCY_PATTERN: '#,##0.00\u00A0\u00A4',
      DEF_CURRENCY_CODE: 'UAH'),
  // Number formatting symbols for locale ur.
  "ur": new NumberSymbols(
      NAME: "ur",
      DECIMAL_SEP: '.',
      GROUP_SEP: ',',
      PERCENT: '%',
      ZERO_DIGIT: '0',
      PLUS_SIGN: '\u200E+',
      MINUS_SIGN: '\u200E-',
      EXP_SYMBOL: 'E',
      PERMILL: '\u2030',
      INFINITY: '\u221E',
      NAN: 'NaN',
      DECIMAL_PATTERN: '#,##0.###',
      SCIENTIFIC_PATTERN: '#E0',
      PERCENT_PATTERN: '#,##0%',
      CURRENCY_PATTERN: '\u00A4#,##0.00',
      DEF_CURRENCY_CODE: 'PKR'),
  // Number formatting symbols for locale uz.
  "uz": new NumberSymbols(
      NAME: "uz",
      DECIMAL_SEP: ',',
      GROUP_SEP: '\u00A0',
      PERCENT: '%',
      ZERO_DIGIT: '0',
      PLUS_SIGN: '+',
      MINUS_SIGN: '-',
      EXP_SYMBOL: 'E',
      PERMILL: '\u2030',
      INFINITY: '\u221E',
      NAN: 'son\u00A0emas',
      DECIMAL_PATTERN: '#,##0.###',
      SCIENTIFIC_PATTERN: '#E0',
      PERCENT_PATTERN: '#,##0%',
      CURRENCY_PATTERN: '#,##0.00\u00A0\u00A4',
      DEF_CURRENCY_CODE: 'UZS'),
  // Number formatting symbols for locale vi.
  "vi": new NumberSymbols(
      NAME: "vi",
      DECIMAL_SEP: ',',
      GROUP_SEP: '.',
      PERCENT: '%',
      ZERO_DIGIT: '0',
      PLUS_SIGN: '+',
      MINUS_SIGN: '-',
      EXP_SYMBOL: 'E',
      PERMILL: '\u2030',
      INFINITY: '\u221E',
      NAN: 'NaN',
      DECIMAL_PATTERN: '#,##0.###',
      SCIENTIFIC_PATTERN: '#E0',
      PERCENT_PATTERN: '#,##0%',
      CURRENCY_PATTERN: '#,##0.00\u00A0\u00A4',
      DEF_CURRENCY_CODE: 'VND'),
  // Number formatting symbols for locale zh.
  "zh": new NumberSymbols(
      NAME: "zh",
      DECIMAL_SEP: '.',
      GROUP_SEP: ',',
      PERCENT: '%',
      ZERO_DIGIT: '0',
      PLUS_SIGN: '+',
      MINUS_SIGN: '-',
      EXP_SYMBOL: 'E',
      PERMILL: '\u2030',
      INFINITY: '\u221E',
      NAN: 'NaN',
      DECIMAL_PATTERN: '#,##0.###',
      SCIENTIFIC_PATTERN: '#E0',
      PERCENT_PATTERN: '#,##0%',
      CURRENCY_PATTERN: '\u00A4#,##0.00',
      DEF_CURRENCY_CODE: 'CNY'),
  // Number formatting symbols for locale zh_CN.
  "zh_CN": new NumberSymbols(
      NAME: "zh_CN",
      DECIMAL_SEP: '.',
      GROUP_SEP: ',',
      PERCENT: '%',
      ZERO_DIGIT: '0',
      PLUS_SIGN: '+',
      MINUS_SIGN: '-',
      EXP_SYMBOL: 'E',
      PERMILL: '\u2030',
      INFINITY: '\u221E',
      NAN: 'NaN',
      DECIMAL_PATTERN: '#,##0.###',
      SCIENTIFIC_PATTERN: '#E0',
      PERCENT_PATTERN: '#,##0%',
      CURRENCY_PATTERN: '\u00A4#,##0.00',
      DEF_CURRENCY_CODE: 'CNY'),
  // Number formatting symbols for locale zh_HK.
  "zh_HK": new NumberSymbols(
      NAME: "zh_HK",
      DECIMAL_SEP: '.',
      GROUP_SEP: ',',
      PERCENT: '%',
      ZERO_DIGIT: '0',
      PLUS_SIGN: '+',
      MINUS_SIGN: '-',
      EXP_SYMBOL: 'E',
      PERMILL: '\u2030',
      INFINITY: '\u221E',
      NAN: '\u975E\u6578\u503C',
      DECIMAL_PATTERN: '#,##0.###',
      SCIENTIFIC_PATTERN: '#E0',
      PERCENT_PATTERN: '#,##0%',
      CURRENCY_PATTERN: '\u00A4#,##0.00',
      DEF_CURRENCY_CODE: 'HKD'),
  // Number formatting symbols for locale zh_TW.
  "zh_TW": new NumberSymbols(
      NAME: "zh_TW",
      DECIMAL_SEP: '.',
      GROUP_SEP: ',',
      PERCENT: '%',
      ZERO_DIGIT: '0',
      PLUS_SIGN: '+',
      MINUS_SIGN: '-',
      EXP_SYMBOL: 'E',
      PERMILL: '\u2030',
      INFINITY: '\u221E',
      NAN: '\u975E\u6578\u503C',
      DECIMAL_PATTERN: '#,##0.###',
      SCIENTIFIC_PATTERN: '#E0',
      PERCENT_PATTERN: '#,##0%',
      CURRENCY_PATTERN: '\u00A4#,##0.00',
      DEF_CURRENCY_CODE: 'TWD'),
  // Number formatting symbols for locale zu.
  "zu": new NumberSymbols(
      NAME: "zu",
      DECIMAL_SEP: '.',
      GROUP_SEP: ',',
      PERCENT: '%',
      ZERO_DIGIT: '0',
      PLUS_SIGN: '+',
      MINUS_SIGN: '-',
      EXP_SYMBOL: 'E',
      PERMILL: '\u2030',
      INFINITY: '\u221E',
      NAN: 'NaN',
      DECIMAL_PATTERN: '#,##0.###',
      SCIENTIFIC_PATTERN: '#E0',
      PERCENT_PATTERN: '#,##0%',
      CURRENCY_PATTERN: '\u00A4#,##0.00',
      DEF_CURRENCY_CODE: 'ZAR')
};

Map<String, CompactNumberSymbols> compactNumberSymbols = {
  // Compact number symbols for locale af.
  "af": new CompactNumberSymbols(COMPACT_DECIMAL_SHORT_PATTERN: const {
    3: {'other': '0\u00A0k'},
    6: {'other': '0\u00A0m'},
    9: {'other': '0\u00A0mjd'},
    12: {'other': '0\u00A0bn'},
  }, COMPACT_DECIMAL_LONG_PATTERN: const {
    3: {'other': '0 duisend'},
    6: {'other': '0 miljoen'},
    9: {'other': '0 miljard'},
    12: {'other': '0 biljoen'},
  }, COMPACT_DECIMAL_SHORT_CURRENCY_PATTERN: const {
    3: {'other': '\u00A40\u00A0k'},
    6: {'other': '\u00A40\u00A0m'},
    9: {'other': '\u00A40\u00A0mjd'},
    12: {'other': '\u00A40\u00A0bn'},
    14: {
      'one': '\u00A4000\u00A0bn',
      'other': '\u00A4\u00A0000\u00A0bn',
    },
  }),
  // Compact number symbols for locale am.
  "am": new CompactNumberSymbols(COMPACT_DECIMAL_SHORT_PATTERN: const {
    3: {'other': '0\u00A0\u123A'},
    6: {'other': '0\u00A0\u121A'},
    9: {'other': '0\u00A0\u1262'},
    12: {'other': '0\u00A0\u1275'},
  }, COMPACT_DECIMAL_LONG_PATTERN: const {
    3: {'other': '0 \u123A'},
    6: {'other': '0 \u121A\u120A\u12EE\u1295'},
    9: {'other': '0 \u1262\u120A\u12EE\u1295'},
    12: {'other': '0 \u1275\u122A\u120A\u12EE\u1295'},
  }, COMPACT_DECIMAL_SHORT_CURRENCY_PATTERN: const {
    3: {'other': '\u00A40\u00A0\u123A'},
    6: {'other': '\u00A40\u00A0\u121A'},
    9: {'other': '\u00A40\u00A0\u1262'},
    12: {'other': '\u00A40\u00A0\u1275'},
  }),
  // Compact number symbols for locale ar.
  "ar": new CompactNumberSymbols(COMPACT_DECIMAL_SHORT_PATTERN: const {
    3: {
      'few': '0\u00A0\u0622\u0644\u0627\u0641',
      'many': '0\u00A0\u0623\u0644\u0641',
      'one': '0\u00A0\u0623\u0644\u0641',
      'other': '0\u00A0\u0623\u0644\u0641',
      'two': '0\u00A0\u0623\u0644\u0641',
      'zero': '0\u00A0\u0623\u0644\u0641',
    },
    4: {'other': '00\u00A0\u0623\u0644\u0641'},
    6: {'other': '0\u00A0\u0645\u0644\u064A\u0648\u0646'},
    9: {'other': '0\u00A0\u0645\u0644\u064A\u0627\u0631'},
    12: {'other': '0\u00A0\u062A\u0631\u0644\u064A\u0648\u0646'},
  }, COMPACT_DECIMAL_LONG_PATTERN: const {
    3: {
      'few': '0 \u0622\u0644\u0627\u0641',
      'many': '0 \u0623\u0644\u0641',
      'one': '0 \u0623\u0644\u0641',
      'other': '0 \u0623\u0644\u0641',
      'two': '0 \u0623\u0644\u0641',
      'zero': '0 \u0623\u0644\u0641',
    },
    4: {'other': '00 \u0623\u0644\u0641'},
    6: {
      'few': '0 \u0645\u0644\u0627\u064A\u064A\u0646',
      'many': '0 \u0645\u0644\u064A\u0648\u0646',
      'one': '0 \u0645\u0644\u064A\u0648\u0646',
      'other': '0 \u0645\u0644\u064A\u0648\u0646',
      'two': '0 \u0645\u0644\u064A\u0648\u0646',
      'zero': '0 \u0645\u0644\u064A\u0648\u0646',
    },
    8: {'other': '000 \u0645\u0644\u064A\u0648\u0646'},
    9: {'other': '0 \u0645\u0644\u064A\u0627\u0631'},
    12: {'other': '0 \u062A\u0631\u0644\u064A\u0648\u0646'},
  }, COMPACT_DECIMAL_SHORT_CURRENCY_PATTERN: const {
    3: {'other': '0\u00A0\u0623\u0644\u0641\u00A0\u00A4'},
    6: {'other': '0\u00A0\u0645\u0644\u064A\u0648\u0646\u00A0\u00A4'},
    9: {'other': '0\u00A0\u0645\u0644\u064A\u0627\u0631\u00A0\u00A4'},
    12: {'other': '0\u00A0\u062A\u0631\u0644\u064A\u0648\u0646\u00A0\u00A4'},
  }),
  // Compact number symbols for locale ar_DZ.
  "ar_DZ": new CompactNumberSymbols(COMPACT_DECIMAL_SHORT_PATTERN: const {
    3: {
      'few': '0\u00A0\u0622\u0644\u0627\u0641',
      'many': '0\u00A0\u0623\u0644\u0641',
      'one': '0\u00A0\u0623\u0644\u0641',
      'other': '0\u00A0\u0623\u0644\u0641',
      'two': '0\u00A0\u0623\u0644\u0641',
      'zero': '0\u00A0\u0623\u0644\u0641',
    },
    4: {'other': '00\u00A0\u0623\u0644\u0641'},
    6: {'other': '0\u00A0\u0645\u0644\u064A\u0648\u0646'},
    9: {'other': '0\u00A0\u0645\u0644\u064A\u0627\u0631'},
    12: {'other': '0\u00A0\u062A\u0631\u0644\u064A\u0648\u0646'},
  }, COMPACT_DECIMAL_LONG_PATTERN: const {
    3: {
      'few': '0 \u0622\u0644\u0627\u0641',
      'many': '0 \u0623\u0644\u0641',
      'one': '0 \u0623\u0644\u0641',
      'other': '0 \u0623\u0644\u0641',
      'two': '0 \u0623\u0644\u0641',
      'zero': '0 \u0623\u0644\u0641',
    },
    4: {'other': '00 \u0623\u0644\u0641'},
    6: {
      'few': '0 \u0645\u0644\u0627\u064A\u064A\u0646',
      'many': '0 \u0645\u0644\u064A\u0648\u0646',
      'one': '0 \u0645\u0644\u064A\u0648\u0646',
      'other': '0 \u0645\u0644\u064A\u0648\u0646',
      'two': '0 \u0645\u0644\u064A\u0648\u0646',
      'zero': '0 \u0645\u0644\u064A\u0648\u0646',
    },
    8: {'other': '000 \u0645\u0644\u064A\u0648\u0646'},
    9: {'other': '0 \u0645\u0644\u064A\u0627\u0631'},
    12: {'other': '0 \u062A\u0631\u0644\u064A\u0648\u0646'},
  }, COMPACT_DECIMAL_SHORT_CURRENCY_PATTERN: const {
    3: {'other': '0\u00A0\u0623\u0644\u0641\u00A0\u00A4'},
    6: {'other': '0\u00A0\u0645\u0644\u064A\u0648\u0646\u00A0\u00A4'},
    9: {'other': '0\u00A0\u0645\u0644\u064A\u0627\u0631\u00A0\u00A4'},
    12: {'other': '0\u00A0\u062A\u0631\u0644\u064A\u0648\u0646\u00A0\u00A4'},
  }),
  // Compact number symbols for locale ar_EG.
  "ar_EG": new CompactNumberSymbols(COMPACT_DECIMAL_SHORT_PATTERN: const {
    3: {
      'few': '0\u00A0\u0622\u0644\u0627\u0641',
      'many': '0\u00A0\u0623\u0644\u0641',
      'one': '0\u00A0\u0623\u0644\u0641',
      'other': '0\u00A0\u0623\u0644\u0641',
      'two': '0\u00A0\u0623\u0644\u0641',
      'zero': '0\u00A0\u0623\u0644\u0641',
    },
    4: {'other': '00\u00A0\u0623\u0644\u0641'},
    6: {'other': '0\u00A0\u0645\u0644\u064A\u0648\u0646'},
    9: {'other': '0\u00A0\u0645\u0644\u064A\u0627\u0631'},
    12: {'other': '0\u00A0\u062A\u0631\u0644\u064A\u0648\u0646'},
  }, COMPACT_DECIMAL_LONG_PATTERN: const {
    3: {
      'few': '0 \u0622\u0644\u0627\u0641',
      'many': '0 \u0623\u0644\u0641',
      'one': '0 \u0623\u0644\u0641',
      'other': '0 \u0623\u0644\u0641',
      'two': '0 \u0623\u0644\u0641',
      'zero': '0 \u0623\u0644\u0641',
    },
    4: {'other': '00 \u0623\u0644\u0641'},
    6: {
      'few': '0 \u0645\u0644\u0627\u064A\u064A\u0646',
      'many': '0 \u0645\u0644\u064A\u0648\u0646',
      'one': '0 \u0645\u0644\u064A\u0648\u0646',
      'other': '0 \u0645\u0644\u064A\u0648\u0646',
      'two': '0 \u0645\u0644\u064A\u0648\u0646',
      'zero': '0 \u0645\u0644\u064A\u0648\u0646',
    },
    8: {'other': '000 \u0645\u0644\u064A\u0648\u0646'},
    9: {'other': '0 \u0645\u0644\u064A\u0627\u0631'},
    12: {'other': '0 \u062A\u0631\u0644\u064A\u0648\u0646'},
  }, COMPACT_DECIMAL_SHORT_CURRENCY_PATTERN: const {
    3: {'other': '0\u00A0\u0623\u0644\u0641\u00A0\u00A4'},
    6: {'other': '0\u00A0\u0645\u0644\u064A\u0648\u0646\u00A0\u00A4'},
    9: {'other': '0\u00A0\u0645\u0644\u064A\u0627\u0631\u00A0\u00A4'},
    12: {'other': '0\u00A0\u062A\u0631\u0644\u064A\u0648\u0646\u00A0\u00A4'},
  }),
  // Compact number symbols for locale as.
  "as": new CompactNumberSymbols(COMPACT_DECIMAL_SHORT_PATTERN: const {
    3: {'other': '0\u00A0\u09B9\u09BE\u099C\u09BE\u09F0'},
    5: {'other': '0\u00A0\u09B2\u09BE\u0996'},
    6: {'other': '0\u00A0\u09A8\u09BF\u09AF\u09C1\u09A4'},
    8: {'other': '000\u00A0\u09A8\u09BF\u0983'},
    9: {'other': '0\u00A0\u09B6\u0983\u00A0\u0995\u09CB\u0983'},
    11: {'other': '000\u00A0\u09B6\u0983\u00A0\u0995\u0983'},
    12: {'other': '0\u00A0\u09B6\u0983\u00A0\u09AA\u0983'},
  }, COMPACT_DECIMAL_LONG_PATTERN: const {
    3: {'other': '0 \u09B9\u09BE\u099C\u09BE\u09F0'},
    5: {'other': '0 \u09B2\u09BE\u0996'},
    6: {'other': '0 \u09A8\u09BF\u09AF\u09C1\u09A4'},
    9: {'other': '0 \u09B6\u09A4 \u0995\u09CB\u099F\u09BF'},
    12: {
      'other': '0 \u09B6\u09A4 \u09AA\u09F0\u09BE\u09F0\u09CD\u09A6\u09CD\u09A7'
    },
  }, COMPACT_DECIMAL_SHORT_CURRENCY_PATTERN: const {
    3: {'other': '\u00A4\u00A00\u00A0\u09B9\u09BE\u099C\u09BE\u09F0'},
    5: {'other': '\u00A4\u00A0000\u00A0\u09B2\u09BE\u0996'},
    6: {'other': '\u00A4\u00A00\u00A0\u09A8\u09BF\u09AF\u09C1\u09A4'},
    9: {
      'other': '\u00A4\u00A00\u00A0\u09B6\u09A4\u00A0\u0995\u09CB\u099F\u09BF'
    },
    12: {
      'other':
          '\u00A4\u00A00\u00A0\u09B6\u09A4\u00A0\u09AA\u09F0\u09BE\u09F0\u09CD\u09A6\u09CD\u09A7'
    },
  }),
  // Compact number symbols for locale az.
  "az": new CompactNumberSymbols(COMPACT_DECIMAL_SHORT_PATTERN: const {
    3: {'other': '0K'},
    6: {'other': '0\u00A0mln'},
    9: {'other': '0\u00A0mlrd'},
    12: {'other': '0\u00A0trln'},
  }, COMPACT_DECIMAL_LONG_PATTERN: const {
    3: {'other': '0 min'},
    6: {'other': '0 milyon'},
    9: {'other': '0 milyard'},
    12: {'other': '0 trilyon'},
  }, COMPACT_DECIMAL_SHORT_CURRENCY_PATTERN: const {
    3: {'other': '0K\u00A0\u00A4'},
    6: {'other': '0M\u00A0\u00A4'},
    9: {'other': '0G\u00A0\u00A4'},
    12: {'other': '0T\u00A0\u00A4'},
  }),
  // Compact number symbols for locale be.
  "be": new CompactNumberSymbols(COMPACT_DECIMAL_SHORT_PATTERN: const {
    3: {'other': '0\u00A0\u0442\u044B\u0441.'},
    6: {'other': '0\u00A0\u043C\u043B\u043D'},
    9: {'other': '0\u00A0\u043C\u043B\u0440\u0434'},
    12: {'other': '0\u00A0\u0442\u0440\u043B\u043D'},
  }, COMPACT_DECIMAL_LONG_PATTERN: const {
    3: {
      'few': '0 \u0442\u044B\u0441\u044F\u0447\u044B',
      'many': '0 \u0442\u044B\u0441\u044F\u0447',
      'one': '0 \u0442\u044B\u0441\u044F\u0447\u0430',
      'other': '0 \u0442\u044B\u0441\u044F\u0447\u044B',
    },
    6: {
      'few': '0 \u043C\u0456\u043B\u044C\u0451\u043D\u044B',
      'many': '0 \u043C\u0456\u043B\u044C\u0451\u043D\u0430\u045E',
      'one': '0 \u043C\u0456\u043B\u044C\u0451\u043D',
      'other': '0 \u043C\u0456\u043B\u044C\u0451\u043D\u0430',
    },
    9: {
      'few': '0 \u043C\u0456\u043B\u044C\u044F\u0440\u0434\u044B',
      'many': '0 \u043C\u0456\u043B\u044C\u044F\u0440\u0434\u0430\u045E',
      'one': '0 \u043C\u0456\u043B\u044C\u044F\u0440\u0434',
      'other': '0 \u043C\u0456\u043B\u044C\u044F\u0440\u0434\u0430',
    },
    12: {
      'few': '0 \u0442\u0440\u044B\u043B\u044C\u0451\u043D\u044B',
      'many': '0 \u0442\u0440\u044B\u043B\u044C\u0451\u043D\u0430\u045E',
      'one': '0 \u0442\u0440\u044B\u043B\u044C\u0451\u043D',
      'other': '0 \u0442\u0440\u044B\u043B\u044C\u0451\u043D\u0430',
    },
  }, COMPACT_DECIMAL_SHORT_CURRENCY_PATTERN: const {
    3: {'other': '0\u00A0\u0442\u044B\u0441.\u00A0\u00A4'},
    6: {'other': '0\u00A0\u043C\u043B\u043D\u00A0\u00A4'},
    9: {'other': '0\u00A0\u043C\u043B\u0440\u0434\u00A0\u00A4'},
    12: {'other': '0\u00A0\u0442\u0440\u043B\u043D\u00A0\u00A4'},
  }),
  // Compact number symbols for locale bg.
  "bg": new CompactNumberSymbols(COMPACT_DECIMAL_SHORT_PATTERN: const {
    3: {'other': '0\u00A0\u0445\u0438\u043B.'},
    6: {'other': '0\u00A0\u043C\u043B\u043D.'},
    9: {'other': '0\u00A0\u043C\u043B\u0440\u0434.'},
    12: {'other': '0\u00A0\u0442\u0440\u043B\u043D.'},
  }, COMPACT_DECIMAL_LONG_PATTERN: const {
    3: {
      'one': '0 \u0445\u0438\u043B.',
      'other': '0 \u0445\u0438\u043B\u044F\u0434\u0438',
    },
    4: {'other': '00 \u0445\u0438\u043B\u044F\u0434\u0438'},
    6: {
      'one': '0 \u043C\u0438\u043B\u0438\u043E\u043D',
      'other': '0 \u043C\u0438\u043B\u0438\u043E\u043D\u0430',
    },
    7: {'other': '00 \u043C\u0438\u043B\u0438\u043E\u043D\u0430'},
    9: {
      'one': '0 \u043C\u0438\u043B\u0438\u0430\u0440\u0434',
      'other': '0 \u043C\u0438\u043B\u0438\u0430\u0440\u0434\u0430',
    },
    10: {'other': '00 \u043C\u0438\u043B\u0438\u0430\u0440\u0434\u0430'},
    12: {
      'one': '0 \u0442\u0440\u0438\u043B\u0438\u043E\u043D',
      'other': '0 \u0442\u0440\u0438\u043B\u0438\u043E\u043D\u0430',
    },
    13: {'other': '00 \u0442\u0440\u0438\u043B\u0438\u043E\u043D\u0430'},
  }, COMPACT_DECIMAL_SHORT_CURRENCY_PATTERN: const {
    3: {'other': '0\u00A0\u0445\u0438\u043B.\u00A0\u00A4'},
    6: {'other': '0\u00A0\u043C\u043B\u043D.\u00A0\u00A4'},
    9: {'other': '0\u00A0\u043C\u043B\u0440\u0434.\u00A0\u00A4'},
    12: {'other': '0\u00A0\u0442\u0440\u043B\u043D.\u00A0\u00A4'},
  }),
  // Compact number symbols for locale bm.
  "bm": new CompactNumberSymbols(COMPACT_DECIMAL_SHORT_PATTERN: const {
    3: {'other': '0K'},
    6: {'other': '0M'},
    9: {'other': '0G'},
    12: {'other': '0T'},
  }, COMPACT_DECIMAL_SHORT_CURRENCY_PATTERN: const {
    3: {'other': '\u00A40K'},
    6: {'other': '\u00A40M'},
    9: {'other': '\u00A40G'},
    12: {'other': '\u00A40T'},
  }),
  // Compact number symbols for locale bn.
  "bn": new CompactNumberSymbols(COMPACT_DECIMAL_SHORT_PATTERN: const {
    3: {'other': '0\u00A0\u09B9\u09BE'},
    5: {'other': '0\u00A0\u09B2\u09BE'},
    7: {'other': '0\u00A0\u0995\u09CB'},
    10: {
      'one': '00\u00A0\u09B6\u09A4\u00A0\u0995\u09CB',
      'other': '00\u09B6\u09A4\u00A0\u0995\u09CB',
    },
    11: {'other': '000\u0995\u09CB'},
    12: {'other': '0\u00A0\u09B2\u09BE.\u0995\u09CB.'},
  }, COMPACT_DECIMAL_LONG_PATTERN: const {
    3: {'other': '0 \u09B9\u09BE\u099C\u09BE\u09B0'},
    5: {'other': '0 \u09B2\u09BE\u0996'},
    7: {'other': '0 \u0995\u09CB\u099F\u09BF'},
    12: {'other': '0 \u09B2\u09BE\u0996 \u0995\u09CB\u099F\u09BF'},
  }, COMPACT_DECIMAL_SHORT_CURRENCY_PATTERN: const {
    3: {'other': '0\u00A0\u09B9\u09BE\u00A4'},
    5: {'other': '0\u00A0\u09B2\u09BE\u00A4'},
    7: {'other': '0\u00A0\u0995\u09CB\u00A4'},
    12: {'other': '0\u00A0\u09B2\u09BE.\u0995\u09CB.\u00A4'},
  }),
  // Compact number symbols for locale br.
  "br": new CompactNumberSymbols(COMPACT_DECIMAL_SHORT_PATTERN: const {
    3: {'other': '0k'},
    6: {'other': '0M'},
    9: {'other': '0G'},
    12: {'other': '0T'},
  }, COMPACT_DECIMAL_LONG_PATTERN: const {
    3: {
      'few': '0 miliad',
      'many': '0 a viliado\u00F9',
      'one': '0 miliad',
      'other': '0 miliad',
      'two': '0 viliad',
    },
    6: {
      'few': '0 milion',
      'many': '0 a v/miliono\u00F9',
      'one': '0 milion',
      'other': '0 milion',
      'two': '0 v/milion',
    },
    9: {
      'few': '0 miliard',
      'many': '0 a viliardo\u00F9',
      'one': '0 miliard',
      'other': '0 miliard',
      'two': '0 viliard',
    },
    12: {
      'few': '0 bilion',
      'many': '0 a v/biliono\u00F9',
      'one': '0 bilion',
      'other': '0 bilion',
      'two': '0 v/bilion',
    },
  }, COMPACT_DECIMAL_SHORT_CURRENCY_PATTERN: const {
    3: {'other': '0\u00A0k\u00A4'},
    6: {'other': '0\u00A0M\u00A4'},
    9: {'other': '0\u00A0G\u00A4'},
    12: {'other': '0\u00A0T\u00A4'},
  }),
  // Compact number symbols for locale bs.
  "bs": new CompactNumberSymbols(COMPACT_DECIMAL_SHORT_PATTERN: const {
    3: {'other': '0\u00A0hilj.'},
    6: {'other': '0\u00A0mil.'},
    9: {'other': '0\u00A0mlrd.'},
    12: {'other': '0\u00A0bil.'},
  }, COMPACT_DECIMAL_LONG_PATTERN: const {
    3: {
      'few': '0 hiljade',
      'one': '0 hiljada',
      'other': '0 hiljada',
    },
    6: {
      'few': '0 miliona',
      'one': '0 milion',
      'other': '0 miliona',
    },
    9: {
      'few': '0 milijarde',
      'one': '0 milijarda',
      'other': '0 milijardi',
    },
    12: {
      'few': '0 biliona',
      'one': '0 bilion',
      'other': '0 biliona',
    },
  }, COMPACT_DECIMAL_SHORT_CURRENCY_PATTERN: const {
    3: {'other': '0\u00A0hilj.\u00A0\u00A4'},
    6: {'other': '0\u00A0mil.\u00A0\u00A4'},
    9: {'other': '0\u00A0mlrd.\u00A0\u00A4'},
    12: {'other': '0\u00A0bil.\u00A0\u00A4'},
  }),
  // Compact number symbols for locale ca.
  "ca": new CompactNumberSymbols(COMPACT_DECIMAL_SHORT_PATTERN: const {
    3: {'other': '0\u00A0k'},
    6: {'other': '0\u00A0M'},
    10: {'other': '00\u00A0kM'},
    12: {'other': '0\u00A0B'},
  }, COMPACT_DECIMAL_LONG_PATTERN: const {
    3: {
      'one': '0 miler',
      'other': '0 milers',
    },
    4: {'other': '00 milers'},
    6: {
      'one': '0 mili\u00F3',
      'other': '0 milions',
    },
    7: {'other': '00 milions'},
    9: {
      'one': '0 miler de milions',
      'other': '0 milers de milions',
    },
    10: {'other': '00 milers de milions'},
    12: {
      'one': '0 bili\u00F3',
      'other': '0 bilions',
    },
    13: {'other': '00 bilions'},
  }, COMPACT_DECIMAL_SHORT_CURRENCY_PATTERN: const {
    3: {'other': '0\u00A0k\u00A4'},
    6: {'other': '0\u00A0M\u00A4'},
    10: {'other': '00\u00A0kM\u00A4'},
    12: {'other': '0\u00A0B\u00A4'},
  }),
  // Compact number symbols for locale chr.
  "chr": new CompactNumberSymbols(COMPACT_DECIMAL_SHORT_PATTERN: const {
    3: {'other': '0K'},
    6: {'other': '0M'},
    9: {'other': '0B'},
    12: {'other': '0T'},
  }, COMPACT_DECIMAL_LONG_PATTERN: const {
    3: {'other': '0 \u13A2\u13EF\u13A6\u13F4\u13B5'},
    6: {'other': '0 \u13A2\u13F3\u13C6\u13D7\u13C5\u13DB'},
    9: {'other': '0 \u13A2\u13EF\u13D4\u13B3\u13D7\u13C5\u13DB'},
    12: {'other': '0 \u13A2\u13EF\u13E6\u13A0\u13D7\u13C5\u13DB'},
  }, COMPACT_DECIMAL_SHORT_CURRENCY_PATTERN: const {
    3: {'other': '\u00A40K'},
    6: {'other': '\u00A40M'},
    9: {'other': '\u00A40B'},
    12: {'other': '\u00A40T'},
  }),
  // Compact number symbols for locale cs.
  "cs": new CompactNumberSymbols(COMPACT_DECIMAL_SHORT_PATTERN: const {
    3: {'other': '0\u00A0tis.'},
    6: {'other': '0\u00A0mil.'},
    9: {'other': '0\u00A0mld.'},
    12: {'other': '0\u00A0bil.'},
  }, COMPACT_DECIMAL_LONG_PATTERN: const {
    3: {
      'few': '0 tis\u00EDce',
      'many': '0 tis\u00EDce',
      'one': '0 tis\u00EDc',
      'other': '0 tis\u00EDc',
    },
    4: {
      'few': '00 tis\u00EDc',
      'many': '00 tis\u00EDce',
      'one': '00 tis\u00EDc',
      'other': '00 tis\u00EDc',
    },
    6: {
      'few': '0 miliony',
      'many': '0 milionu',
      'one': '0 milion',
      'other': '0 milion\u016F',
    },
    7: {
      'few': '00 milion\u016F',
      'many': '00 milionu',
      'one': '00 milion\u016F',
      'other': '00 milion\u016F',
    },
    9: {
      'few': '0 miliardy',
      'many': '0 miliardy',
      'one': '0 miliarda',
      'other': '0 miliard',
    },
    10: {
      'few': '00 miliard',
      'many': '00 miliardy',
      'one': '00 miliard',
      'other': '00 miliard',
    },
    12: {
      'few': '0 biliony',
      'many': '0 bilionu',
      'one': '0 bilion',
      'other': '0 bilion\u016F',
    },
    13: {
      'few': '00 bilion\u016F',
      'many': '00 bilionu',
      'one': '00 bilion\u016F',
      'other': '00 bilion\u016F',
    },
  }, COMPACT_DECIMAL_SHORT_CURRENCY_PATTERN: const {
    3: {'other': '0\u00A0tis.\u00A0\u00A4'},
    6: {'other': '0\u00A0mil.\u00A0\u00A4'},
    9: {'other': '0\u00A0mld.\u00A0\u00A4'},
    12: {'other': '0\u00A0bil.\u00A0\u00A4'},
  }),
  // Compact number symbols for locale cy.
  "cy": new CompactNumberSymbols(COMPACT_DECIMAL_SHORT_PATTERN: const {
    3: {'other': '0K'},
    6: {'other': '0M'},
    9: {'other': '0B'},
    12: {'other': '0T'},
  }, COMPACT_DECIMAL_LONG_PATTERN: const {
    3: {
      'few': '0K',
      'many': '0K',
      'one': '0 mil',
      'other': '0 mil',
      'two': '0K',
      'zero': '0 mil',
    },
    4: {
      'few': '00K',
      'many': '00K',
      'one': '00 mil',
      'other': '00 mil',
      'two': '00K',
      'zero': '00K',
    },
    6: {'other': '0 miliwn'},
    9: {'other': '0 biliwn'},
    12: {'other': '0 triliwn'},
    14: {
      'one': '000T',
      'other': '000 triliwn',
    },
  }, COMPACT_DECIMAL_SHORT_CURRENCY_PATTERN: const {
    3: {'other': '\u00A40K'},
    6: {'other': '\u00A40M'},
    9: {'other': '\u00A40B'},
    12: {'other': '\u00A40T'},
  }),
  // Compact number symbols for locale da.
  "da": new CompactNumberSymbols(COMPACT_DECIMAL_SHORT_PATTERN: const {
    3: {'other': '0\u00A0t'},
    6: {'other': '0\u00A0mio.'},
    9: {'other': '0\u00A0mia.'},
    12: {'other': '0\u00A0bio.'},
  }, COMPACT_DECIMAL_LONG_PATTERN: const {
    3: {'other': '0 tusind'},
    6: {
      'one': '0 million',
      'other': '0 millioner',
    },
    7: {'other': '00 millioner'},
    9: {
      'one': '0 milliard',
      'other': '0 milliarder',
    },
    10: {'other': '00 milliarder'},
    12: {
      'one': '0 billion',
      'other': '0 billioner',
    },
    13: {'other': '00 billioner'},
  }, COMPACT_DECIMAL_SHORT_CURRENCY_PATTERN: const {
    3: {'other': '0\u00A0t\u00A0\u00A4'},
    6: {'other': '0\u00A0mio.\u00A0\u00A4'},
    9: {'other': '0\u00A0mia.\u00A0\u00A4'},
    12: {'other': '0\u00A0bio.\u00A0\u00A4'},
  }),
  // Compact number symbols for locale de.
  "de": new CompactNumberSymbols(COMPACT_DECIMAL_SHORT_PATTERN: const {
    3: {'other': '0'},
    4: {'other': '0'},
    5: {'other': '0'},
    6: {'other': '0\u00A0Mio.'},
    9: {'other': '0\u00A0Mrd.'},
    12: {'other': '0\u00A0Bio.'},
  }, COMPACT_DECIMAL_LONG_PATTERN: const {
    3: {'other': '0 Tausend'},
    6: {
      'one': '0 Million',
      'other': '0 Millionen',
    },
    7: {'other': '00 Millionen'},
    9: {
      'one': '0 Milliarde',
      'other': '0 Milliarden',
    },
    10: {'other': '00 Milliarden'},
    12: {
      'one': '0 Billion',
      'other': '0 Billionen',
    },
    13: {'other': '00 Billionen'},
  }, COMPACT_DECIMAL_SHORT_CURRENCY_PATTERN: const {
    3: {'other': '0'},
    4: {'other': '0'},
    5: {'other': '0'},
    6: {'other': '0\u00A0Mio.\u00A0\u00A4'},
    9: {'other': '0\u00A0Mrd.\u00A0\u00A4'},
    12: {'other': '0\u00A0Bio.\u00A0\u00A4'},
  }),
  // Compact number symbols for locale de_AT.
  "de_AT": new CompactNumberSymbols(COMPACT_DECIMAL_SHORT_PATTERN: const {
    3: {'other': '0'},
    4: {'other': '0'},
    5: {'other': '0'},
    6: {'other': '0\u00A0Mio.'},
    9: {'other': '0\u00A0Mrd.'},
    12: {'other': '0\u00A0Bio.'},
  }, COMPACT_DECIMAL_LONG_PATTERN: const {
    3: {'other': '0 Tausend'},
    6: {
      'one': '0 Million',
      'other': '0 Millionen',
    },
    7: {'other': '00 Millionen'},
    9: {
      'one': '0 Milliarde',
      'other': '0 Milliarden',
    },
    10: {'other': '00 Milliarden'},
    12: {
      'one': '0 Billion',
      'other': '0 Billionen',
    },
    13: {'other': '00 Billionen'},
  }, COMPACT_DECIMAL_SHORT_CURRENCY_PATTERN: const {
    3: {'other': '0'},
    4: {'other': '0'},
    5: {'other': '0'},
    6: {'other': '0\u00A0Mio.\u00A0\u00A4'},
    9: {'other': '0\u00A0Mrd.\u00A0\u00A4'},
    12: {'other': '0\u00A0Bio.\u00A0\u00A4'},
  }),
  // Compact number symbols for locale de_CH.
  "de_CH": new CompactNumberSymbols(COMPACT_DECIMAL_SHORT_PATTERN: const {
    3: {'other': '0'},
    4: {'other': '0'},
    5: {'other': '0'},
    6: {'other': '0\u00A0Mio.'},
    9: {'other': '0\u00A0Mrd.'},
    12: {'other': '0\u00A0Bio.'},
  }, COMPACT_DECIMAL_LONG_PATTERN: const {
    3: {'other': '0 Tausend'},
    6: {
      'one': '0 Million',
      'other': '0 Millionen',
    },
    7: {'other': '00 Millionen'},
    9: {
      'one': '0 Milliarde',
      'other': '0 Milliarden',
    },
    10: {'other': '00 Milliarden'},
    12: {
      'one': '0 Billion',
      'other': '0 Billionen',
    },
    13: {'other': '00 Billionen'},
  }, COMPACT_DECIMAL_SHORT_CURRENCY_PATTERN: const {
    3: {'other': '0'},
    4: {'other': '0'},
    5: {'other': '0'},
    6: {'other': '0\u00A0Mio.\u00A0\u00A4'},
    9: {'other': '0\u00A0Mrd.\u00A0\u00A4'},
    12: {'other': '0\u00A0Bio.\u00A0\u00A4'},
  }),
  // Compact number symbols for locale el.
  "el": new CompactNumberSymbols(COMPACT_DECIMAL_SHORT_PATTERN: const {
    3: {'other': '0\u00A0\u03C7\u03B9\u03BB.'},
    6: {'other': '0\u00A0\u03B5\u03BA.'},
    9: {'other': '0\u00A0\u03B4\u03B9\u03C3.'},
    12: {'other': '0\u00A0\u03C4\u03C1\u03B9\u03C3.'},
  }, COMPACT_DECIMAL_LONG_PATTERN: const {
    3: {
      'one': '0 \u03C7\u03B9\u03BB\u03B9\u03AC\u03B4\u03B1',
      'other': '0 \u03C7\u03B9\u03BB\u03B9\u03AC\u03B4\u03B5\u03C2',
    },
    4: {'other': '00 \u03C7\u03B9\u03BB\u03B9\u03AC\u03B4\u03B5\u03C2'},
    6: {
      'one':
          '0 \u03B5\u03BA\u03B1\u03C4\u03BF\u03BC\u03BC\u03CD\u03C1\u03B9\u03BF',
      'other':
          '0 \u03B5\u03BA\u03B1\u03C4\u03BF\u03BC\u03BC\u03CD\u03C1\u03B9\u03B1',
    },
    7: {
      'other':
          '00 \u03B5\u03BA\u03B1\u03C4\u03BF\u03BC\u03BC\u03CD\u03C1\u03B9\u03B1'
    },
    9: {
      'one':
          '0 \u03B4\u03B9\u03C3\u03B5\u03BA\u03B1\u03C4\u03BF\u03BC\u03BC\u03CD\u03C1\u03B9\u03BF',
      'other':
          '0 \u03B4\u03B9\u03C3\u03B5\u03BA\u03B1\u03C4\u03BF\u03BC\u03BC\u03CD\u03C1\u03B9\u03B1',
    },
    10: {
      'other':
          '00 \u03B4\u03B9\u03C3\u03B5\u03BA\u03B1\u03C4\u03BF\u03BC\u03BC\u03CD\u03C1\u03B9\u03B1'
    },
    12: {
      'one':
          '0 \u03C4\u03C1\u03B9\u03C3\u03B5\u03BA\u03B1\u03C4\u03BF\u03BC\u03BC\u03CD\u03C1\u03B9\u03BF',
      'other':
          '0 \u03C4\u03C1\u03B9\u03C3\u03B5\u03BA\u03B1\u03C4\u03BF\u03BC\u03BC\u03CD\u03C1\u03B9\u03B1',
    },
    13: {
      'other':
          '00 \u03C4\u03C1\u03B9\u03C3\u03B5\u03BA\u03B1\u03C4\u03BF\u03BC\u03BC\u03CD\u03C1\u03B9\u03B1'
    },
  }, COMPACT_DECIMAL_SHORT_CURRENCY_PATTERN: const {
    3: {'other': '0\u00A0\u03C7\u03B9\u03BB.\u00A0\u00A4'},
    6: {'other': '0\u00A0\u03B5\u03BA.\u00A0\u00A4'},
    9: {'other': '0\u00A0\u03B4\u03B9\u03C3.\u00A0\u00A4'},
    12: {'other': '0\u00A0\u03C4\u03C1\u03B9\u03C3.\u00A0\u00A4'},
  }),
  // Compact number symbols for locale en.
  "en": new CompactNumberSymbols(COMPACT_DECIMAL_SHORT_PATTERN: const {
    3: {'other': '0K'},
    6: {'other': '0M'},
    9: {'other': '0B'},
    12: {'other': '0T'},
  }, COMPACT_DECIMAL_LONG_PATTERN: const {
    3: {'other': '0 thousand'},
    6: {'other': '0 million'},
    9: {'other': '0 billion'},
    12: {'other': '0 trillion'},
  }, COMPACT_DECIMAL_SHORT_CURRENCY_PATTERN: const {
    3: {'other': '\u00A40K'},
    6: {'other': '\u00A40M'},
    9: {'other': '\u00A40B'},
    12: {'other': '\u00A40T'},
  }),
  // Compact number symbols for locale en_AU.
  "en_AU": new CompactNumberSymbols(COMPACT_DECIMAL_SHORT_PATTERN: const {
    3: {'other': '0K'},
    6: {'other': '0M'},
    9: {'other': '0B'},
    12: {'other': '0T'},
  }, COMPACT_DECIMAL_LONG_PATTERN: const {
    3: {'other': '0 thousand'},
    6: {'other': '0 million'},
    9: {'other': '0 billion'},
    12: {'other': '0 trillion'},
  }, COMPACT_DECIMAL_SHORT_CURRENCY_PATTERN: const {
    3: {'other': '\u00A40K'},
    6: {'other': '\u00A40M'},
    9: {'other': '\u00A40B'},
    12: {'other': '\u00A40T'},
  }),
  // Compact number symbols for locale en_CA.
  "en_CA": new CompactNumberSymbols(COMPACT_DECIMAL_SHORT_PATTERN: const {
    3: {'other': '0K'},
    6: {'other': '0M'},
    9: {'other': '0B'},
    12: {'other': '0T'},
  }, COMPACT_DECIMAL_LONG_PATTERN: const {
    3: {'other': '0 thousand'},
    6: {'other': '0 million'},
    9: {'other': '0 billion'},
    12: {'other': '0 trillion'},
  }, COMPACT_DECIMAL_SHORT_CURRENCY_PATTERN: const {
    3: {'other': '\u00A40K'},
    6: {'other': '\u00A40M'},
    9: {'other': '\u00A40B'},
    12: {'other': '\u00A40T'},
  }),
  // Compact number symbols for locale en_GB.
  "en_GB": new CompactNumberSymbols(COMPACT_DECIMAL_SHORT_PATTERN: const {
    3: {'other': '0K'},
    6: {'other': '0M'},
    9: {'other': '0B'},
    12: {'other': '0T'},
  }, COMPACT_DECIMAL_LONG_PATTERN: const {
    3: {'other': '0 thousand'},
    6: {'other': '0 million'},
    9: {'other': '0 billion'},
    12: {'other': '0 trillion'},
  }, COMPACT_DECIMAL_SHORT_CURRENCY_PATTERN: const {
    3: {'other': '\u00A40K'},
    6: {'other': '\u00A40M'},
    9: {'other': '\u00A40B'},
    12: {'other': '\u00A40T'},
  }),
  // Compact number symbols for locale en_IE.
  "en_IE": new CompactNumberSymbols(COMPACT_DECIMAL_SHORT_PATTERN: const {
    3: {'other': '0K'},
    6: {'other': '0M'},
    9: {'other': '0B'},
    12: {'other': '0T'},
  }, COMPACT_DECIMAL_LONG_PATTERN: const {
    3: {'other': '0 thousand'},
    6: {'other': '0 million'},
    9: {'other': '0 billion'},
    12: {'other': '0 trillion'},
  }, COMPACT_DECIMAL_SHORT_CURRENCY_PATTERN: const {
    3: {'other': '\u00A40K'},
    6: {'other': '\u00A40M'},
    9: {'other': '\u00A40B'},
    12: {'other': '\u00A40T'},
  }),
  // Compact number symbols for locale en_IN.
  "en_IN": new CompactNumberSymbols(COMPACT_DECIMAL_SHORT_PATTERN: const {
    3: {'other': '0K'},
    5: {'other': '0L'},
    7: {'other': '0Cr'},
    10: {'other': '0KCr'},
    12: {'other': '0LCr'},
  }, COMPACT_DECIMAL_LONG_PATTERN: const {
    3: {'other': '0 thousand'},
    6: {'other': '0 million'},
    9: {'other': '0 billion'},
    12: {'other': '0 trillion'},
  }, COMPACT_DECIMAL_SHORT_CURRENCY_PATTERN: const {
    3: {'other': '\u00A40K'},
    5: {'other': '\u00A40L'},
    7: {'other': '\u00A40Cr'},
    10: {'other': '\u00A40KCr'},
    12: {'other': '\u00A40LCr'},
  }),
  // Compact number symbols for locale en_MY.
  "en_MY": new CompactNumberSymbols(COMPACT_DECIMAL_SHORT_PATTERN: const {
    3: {'other': '0K'},
    6: {'other': '0M'},
    9: {'other': '0B'},
    12: {'other': '0T'},
  }, COMPACT_DECIMAL_LONG_PATTERN: const {
    3: {'other': '0 thousand'},
    6: {'other': '0 million'},
    9: {'other': '0 billion'},
    12: {'other': '0 trillion'},
  }, COMPACT_DECIMAL_SHORT_CURRENCY_PATTERN: const {
    3: {'other': '\u00A40K'},
    6: {'other': '\u00A40M'},
    9: {'other': '\u00A40B'},
    12: {'other': '\u00A40T'},
  }),
  // Compact number symbols for locale en_NZ.
  "en_NZ": new CompactNumberSymbols(COMPACT_DECIMAL_SHORT_PATTERN: const {
    3: {'other': '0K'},
    6: {'other': '0M'},
    9: {'other': '0B'},
    12: {'other': '0T'},
  }, COMPACT_DECIMAL_LONG_PATTERN: const {
    3: {'other': '0 thousand'},
    6: {'other': '0 million'},
    9: {'other': '0 billion'},
    12: {'other': '0 trillion'},
  }, COMPACT_DECIMAL_SHORT_CURRENCY_PATTERN: const {
    3: {'other': '\u00A40K'},
    6: {'other': '\u00A40M'},
    9: {'other': '\u00A40B'},
    12: {'other': '\u00A40T'},
  }),
  // Compact number symbols for locale en_SG.
  "en_SG": new CompactNumberSymbols(COMPACT_DECIMAL_SHORT_PATTERN: const {
    3: {'other': '0K'},
    6: {'other': '0M'},
    9: {'other': '0B'},
    12: {'other': '0T'},
  }, COMPACT_DECIMAL_LONG_PATTERN: const {
    3: {'other': '0 thousand'},
    6: {'other': '0 million'},
    9: {'other': '0 billion'},
    12: {'other': '0 trillion'},
  }, COMPACT_DECIMAL_SHORT_CURRENCY_PATTERN: const {
    3: {'other': '\u00A40K'},
    6: {'other': '\u00A40M'},
    9: {'other': '\u00A40B'},
    12: {'other': '\u00A40T'},
  }),
  // Compact number symbols for locale en_US.
  "en_US": new CompactNumberSymbols(COMPACT_DECIMAL_SHORT_PATTERN: const {
    3: {'other': '0K'},
    6: {'other': '0M'},
    9: {'other': '0B'},
    12: {'other': '0T'},
  }, COMPACT_DECIMAL_LONG_PATTERN: const {
    3: {'other': '0 thousand'},
    6: {'other': '0 million'},
    9: {'other': '0 billion'},
    12: {'other': '0 trillion'},
  }, COMPACT_DECIMAL_SHORT_CURRENCY_PATTERN: const {
    3: {'other': '\u00A40K'},
    6: {'other': '\u00A40M'},
    9: {'other': '\u00A40B'},
    12: {'other': '\u00A40T'},
  }),
  // Compact number symbols for locale en_ZA.
  "en_ZA": new CompactNumberSymbols(COMPACT_DECIMAL_SHORT_PATTERN: const {
    3: {'other': '0K'},
    6: {'other': '0M'},
    9: {'other': '0B'},
    12: {'other': '0T'},
  }, COMPACT_DECIMAL_LONG_PATTERN: const {
    3: {'other': '0 thousand'},
    6: {'other': '0 million'},
    9: {'other': '0 billion'},
    12: {'other': '0 trillion'},
  }, COMPACT_DECIMAL_SHORT_CURRENCY_PATTERN: const {
    3: {'other': '\u00A40K'},
    6: {'other': '\u00A40M'},
    9: {'other': '\u00A40B'},
    12: {'other': '\u00A40T'},
  }),
  // Compact number symbols for locale es.
  "es": new CompactNumberSymbols(COMPACT_DECIMAL_SHORT_PATTERN: const {
    3: {'other': '0\u00A0mil'},
    6: {'other': '0\u00A0M'},
    10: {'other': '00\u00A0mil\u00A0M'},
    12: {'other': '0\u00A0B'},
  }, COMPACT_DECIMAL_LONG_PATTERN: const {
    3: {'other': '0 mil'},
    6: {
      'one': '0 mill\u00F3n',
      'other': '0 millones',
    },
    7: {'other': '00 millones'},
    9: {'other': '0 mil millones'},
    12: {
      'one': '0 bill\u00F3n',
      'other': '0 billones',
    },
    13: {'other': '00 billones'},
  }, COMPACT_DECIMAL_SHORT_CURRENCY_PATTERN: const {
    3: {'other': '0\u00A0mil\u00A0\u00A4'},
    6: {'other': '0\u00A0M\u00A4'},
    10: {'other': '00\u00A0mil\u00A0M\u00A4'},
    12: {'other': '0\u00A0B\u00A4'},
  }),
  // Compact number symbols for locale es_419.
  "es_419": new CompactNumberSymbols(COMPACT_DECIMAL_SHORT_PATTERN: const {
    3: {'other': '0\u00A0K'},
    4: {'other': '00\u00A0k'},
    6: {'other': '0\u00A0M'},
    10: {'other': '00\u00A0mil\u00A0M'},
    12: {'other': '0\u00A0B'},
  }, COMPACT_DECIMAL_LONG_PATTERN: const {
    3: {'other': '0 mil'},
    6: {
      'one': '0 mill\u00F3n',
      'other': '0 millones',
    },
    7: {'other': '00 millones'},
    9: {'other': '0 mil millones'},
    12: {
      'one': '0 bill\u00F3n',
      'other': '0 billones',
    },
    13: {'other': '00 billones'},
  }, COMPACT_DECIMAL_SHORT_CURRENCY_PATTERN: const {
    3: {'other': '\u00A40\u00A0K'},
    6: {'other': '\u00A40\u00A0M'},
    10: {'other': '\u00A400\u00A0MRD'},
    12: {'other': '\u00A40\u00A0B'},
  }),
  // Compact number symbols for locale es_ES.
  "es_ES": new CompactNumberSymbols(COMPACT_DECIMAL_SHORT_PATTERN: const {
    3: {'other': '0\u00A0mil'},
    6: {'other': '0\u00A0M'},
    10: {'other': '00\u00A0mil\u00A0M'},
    12: {'other': '0\u00A0B'},
  }, COMPACT_DECIMAL_LONG_PATTERN: const {
    3: {'other': '0 mil'},
    6: {
      'one': '0 mill\u00F3n',
      'other': '0 millones',
    },
    7: {'other': '00 millones'},
    9: {'other': '0 mil millones'},
    12: {
      'one': '0 bill\u00F3n',
      'other': '0 billones',
    },
    13: {'other': '00 billones'},
  }, COMPACT_DECIMAL_SHORT_CURRENCY_PATTERN: const {
    3: {'other': '0\u00A0mil\u00A0\u00A4'},
    6: {'other': '0\u00A0M\u00A4'},
    10: {'other': '00\u00A0mil\u00A0M\u00A4'},
    12: {'other': '0\u00A0B\u00A4'},
  }),
  // Compact number symbols for locale es_MX.
  "es_MX": new CompactNumberSymbols(COMPACT_DECIMAL_SHORT_PATTERN: const {
    3: {'other': '0\u00A0k'},
    6: {'other': '0\u00A0M'},
    10: {'other': '00\u00A0mil\u00A0M'},
    12: {'other': '0\u00A0B'},
  }, COMPACT_DECIMAL_LONG_PATTERN: const {
    3: {'other': '0 mil'},
    6: {
      'one': '0 mill\u00F3n',
      'other': '0 millones',
    },
    7: {'other': '00 millones'},
    9: {'other': '0 mil millones'},
    12: {
      'one': '0 bill\u00F3n',
      'other': '0 billones',
    },
    13: {'other': '00 billones'},
  }, COMPACT_DECIMAL_SHORT_CURRENCY_PATTERN: const {
    3: {'other': '0\u00A0k\u00A4'},
    6: {'other': '0\u00A0M\u00A4'},
    10: {'other': '00\u00A0MRD\u00A0\u00A4'},
    12: {'other': '0\u00A0B\u00A4'},
  }),
  // Compact number symbols for locale es_US.
  "es_US": new CompactNumberSymbols(COMPACT_DECIMAL_SHORT_PATTERN: const {
    3: {'other': '0\u00A0K'},
    6: {'other': '0\u00A0M'},
    10: {'other': '00\u00A0mil\u00A0M'},
    12: {'other': '0\u00A0B'},
  }, COMPACT_DECIMAL_LONG_PATTERN: const {
    3: {'other': '0 mil'},
    6: {
      'one': '0 mill\u00F3n',
      'other': '0 millones',
    },
    7: {'other': '00 millones'},
    9: {'other': '0 mil millones'},
    12: {
      'one': '0 bill\u00F3n',
      'other': '0 billones',
    },
    13: {'other': '00 billones'},
  }, COMPACT_DECIMAL_SHORT_CURRENCY_PATTERN: const {
    3: {'other': '\u00A40\u00A0K'},
    6: {'other': '\u00A40\u00A0M'},
    10: {'other': '\u00A400\u00A0B'},
    12: {'other': '\u00A40\u00A0T'},
  }),
  // Compact number symbols for locale et.
  "et": new CompactNumberSymbols(COMPACT_DECIMAL_SHORT_PATTERN: const {
    3: {'other': '0\u00A0tuh'},
    6: {'other': '0\u00A0mln'},
    9: {'other': '0\u00A0mld'},
    12: {'other': '0\u00A0trln'},
  }, COMPACT_DECIMAL_LONG_PATTERN: const {
    3: {'other': '0 tuhat'},
    6: {
      'one': '0 miljon',
      'other': '0 miljonit',
    },
    7: {'other': '00 miljonit'},
    9: {
      'one': '0 miljard',
      'other': '0 miljardit',
    },
    10: {'other': '00 miljardit'},
    12: {
      'one': '0 triljon',
      'other': '0 triljonit',
    },
    13: {'other': '00 triljonit'},
  }, COMPACT_DECIMAL_SHORT_CURRENCY_PATTERN: const {
    3: {'other': '0\u00A0tuh\u00A0\u00A4'},
    6: {'other': '0\u00A0mln\u00A0\u00A4'},
    9: {'other': '0\u00A0mld\u00A0\u00A4'},
    12: {'other': '0\u00A0trln\u00A0\u00A4'},
  }),
  // Compact number symbols for locale eu.
  "eu": new CompactNumberSymbols(COMPACT_DECIMAL_SHORT_PATTERN: const {
    3: {'other': '0'},
    4: {'other': '0'},
    5: {'other': '0'},
    6: {'other': '0\u00A0M'},
    12: {'other': '0\u00A0B'},
  }, COMPACT_DECIMAL_LONG_PATTERN: const {
    6: {'other': '0 milioi'},
    12: {'other': '0 bilioi'},
  }, COMPACT_DECIMAL_SHORT_CURRENCY_PATTERN: const {
    3: {'other': '0'},
    4: {'other': '0'},
    5: {'other': '0'},
    6: {'other': '0\u00A0M\u00A0\u00A4'},
    12: {'other': '0\u00A0B\u00A0\u00A4'},
  }),
  // Compact number symbols for locale fa.
  "fa": new CompactNumberSymbols(COMPACT_DECIMAL_SHORT_PATTERN: const {
    3: {'other': '0\u00A0\u0647\u0632\u0627\u0631'},
    6: {'other': '0\u00A0\u0645\u06CC\u0644\u06CC\u0648\u0646'},
    9: {'other': '0\u00A0\u0645\u06CC\u0644\u06CC\u0627\u0631\u062F'},
    12: {'other': '0\u00A0\u062A\u0631\u06CC\u0644\u06CC\u0648\u0646'},
  }, COMPACT_DECIMAL_LONG_PATTERN: const {
    3: {'other': '0 \u0647\u0632\u0627\u0631'},
    6: {'other': '0 \u0645\u06CC\u0644\u06CC\u0648\u0646'},
    9: {'other': '0 \u0645\u06CC\u0644\u06CC\u0627\u0631\u062F'},
    12: {
      'other':
          '0 \u0647\u0632\u0627\u0631\u0645\u06CC\u0644\u06CC\u0627\u0631\u062F'
    },
  }, COMPACT_DECIMAL_SHORT_CURRENCY_PATTERN: const {
    3: {'other': '0\u00A0\u0647\u0632\u0627\u0631\u00A0\u00A4'},
    6: {'other': '0\u00A0\u0645\u06CC\u0644\u06CC\u0648\u0646\u00A0\u00A4'},
    9: {
      'other': '0\u00A0\u0645\u06CC\u0644\u06CC\u0627\u0631\u062F\u00A0\u00A4'
    },
    12: {
      'other':
          '0\u00A0\u0647\u0632\u0627\u0631\u0645\u06CC\u0644\u06CC\u0627\u0631\u062F\u00A0\u00A4'
    },
  }),
  // Compact number symbols for locale fi.
  "fi": new CompactNumberSymbols(COMPACT_DECIMAL_SHORT_PATTERN: const {
    3: {'other': '0\u00A0t.'},
    6: {'other': '0\u00A0milj.'},
    9: {'other': '0\u00A0mrd.'},
    12: {'other': '0\u00A0bilj.'},
  }, COMPACT_DECIMAL_LONG_PATTERN: const {
    3: {
      'one': '0 tuhat',
      'other': '0 tuhatta',
    },
    4: {'other': '00 tuhatta'},
    6: {
      'one': '0 miljoona',
      'other': '0 miljoonaa',
    },
    7: {'other': '00 miljoonaa'},
    9: {
      'one': '0 miljardi',
      'other': '0 miljardia',
    },
    10: {'other': '00 miljardia'},
    12: {
      'one': '0 biljoona',
      'other': '0 biljoonaa',
    },
    13: {'other': '00 biljoonaa'},
  }, COMPACT_DECIMAL_SHORT_CURRENCY_PATTERN: const {
    3: {'other': '0\u00A0t.\u00A0\u00A4'},
    6: {'other': '0\u00A0milj.\u00A0\u00A4'},
    9: {'other': '0\u00A0mrd.\u00A0\u00A4'},
    12: {'other': '0\u00A0bilj.\u00A0\u00A4'},
  }),
  // Compact number symbols for locale fil.
  "fil": new CompactNumberSymbols(COMPACT_DECIMAL_SHORT_PATTERN: const {
    3: {'other': '0K'},
    6: {'other': '0M'},
    9: {'other': '0B'},
    12: {'other': '0T'},
  }, COMPACT_DECIMAL_LONG_PATTERN: const {
    3: {
      'one': '0 libo',
      'other': '0 na libo',
    },
    6: {
      'one': '0 milyon',
      'other': '0 na milyon',
    },
    9: {
      'one': '0 bilyon',
      'other': '0 na bilyon',
    },
    12: {
      'one': '0 trilyon',
      'other': '0 na trilyon',
    },
  }, COMPACT_DECIMAL_SHORT_CURRENCY_PATTERN: const {
    3: {'other': '\u00A40K'},
    6: {'other': '\u00A40M'},
    9: {'other': '\u00A40B'},
    12: {'other': '\u00A40T'},
  }),
  // Compact number symbols for locale fr.
  "fr": new CompactNumberSymbols(COMPACT_DECIMAL_SHORT_PATTERN: const {
    3: {'other': '0\u00A0k'},
    6: {'other': '0\u00A0M'},
    9: {'other': '0\u00A0Md'},
    12: {'other': '0\u00A0Bn'},
  }, COMPACT_DECIMAL_LONG_PATTERN: const {
    3: {
      '1': 'mille',
      'one': '0 millier',
      'other': '0 mille',
    },
    4: {'other': '00 mille'},
    6: {
      'one': '0 million',
      'other': '0 millions',
    },
    9: {
      'one': '0 milliard',
      'other': '0 milliards',
    },
    12: {
      'one': '0 billion',
      'other': '0 billions',
    },
  }, COMPACT_DECIMAL_SHORT_CURRENCY_PATTERN: const {
    3: {'other': '0\u00A0k\u00A0\u00A4'},
    6: {'other': '0\u00A0M\u00A0\u00A4'},
    9: {'other': '0\u00A0Md\u00A0\u00A4'},
    12: {'other': '0\u00A0Bn\u00A0\u00A4'},
  }),
  // Compact number symbols for locale fr_CA.
  "fr_CA": new CompactNumberSymbols(COMPACT_DECIMAL_SHORT_PATTERN: const {
    3: {'other': '0\u00A0k'},
    6: {'other': '0\u00A0M'},
    9: {'other': '0\u00A0G'},
    12: {'other': '0\u00A0T'},
  }, COMPACT_DECIMAL_LONG_PATTERN: const {
    3: {'other': '0 mille'},
    4: {'other': '00 mille'},
    6: {
      'one': '0 million',
      'other': '0 millions',
    },
    9: {
      'one': '0 milliard',
      'other': '0 milliards',
    },
    12: {
      'one': '0 billion',
      'other': '0 billions',
    },
  }, COMPACT_DECIMAL_SHORT_CURRENCY_PATTERN: const {
    3: {'other': '0\u00A0k\u00A4'},
    6: {'other': '0\u00A0M\u00A4'},
    9: {'other': '0\u00A0G\u00A4'},
    12: {'other': '0\u00A0T\u00A4'},
  }),
  // Compact number symbols for locale fr_CH.
  "fr_CH": new CompactNumberSymbols(COMPACT_DECIMAL_SHORT_PATTERN: const {
    3: {'other': '0\u00A0k'},
    6: {'other': '0\u00A0M'},
    9: {'other': '0\u00A0Md'},
    12: {'other': '0\u00A0Bn'},
  }, COMPACT_DECIMAL_LONG_PATTERN: const {
    3: {
      '1': 'mille',
      'one': '0 millier',
      'other': '0 mille',
    },
    4: {'other': '00 mille'},
    6: {
      'one': '0 million',
      'other': '0 millions',
    },
    9: {
      'one': '0 milliard',
      'other': '0 milliards',
    },
    12: {
      'one': '0 billion',
      'other': '0 billions',
    },
  }, COMPACT_DECIMAL_SHORT_CURRENCY_PATTERN: const {
    3: {'other': '0\u00A0k\u00A0\u00A4'},
    6: {'other': '0\u00A0M\u00A0\u00A4'},
    9: {'other': '0\u00A0Md\u00A0\u00A4'},
    12: {'other': '0\u00A0Bn\u00A0\u00A4'},
  }),
  // Compact number symbols for locale fur.
  "fur": new CompactNumberSymbols(COMPACT_DECIMAL_SHORT_PATTERN: const {
    3: {'other': '0K'},
    6: {'other': '0M'},
    9: {'other': '0G'},
    12: {'other': '0T'},
  }, COMPACT_DECIMAL_SHORT_CURRENCY_PATTERN: const {
    3: {'other': '\u00A4\u00A00K'},
    6: {'other': '\u00A4\u00A00M'},
    9: {'other': '\u00A4\u00A00G'},
    12: {'other': '\u00A4\u00A00T'},
  }),
  // Compact number symbols for locale ga.
  "ga": new CompactNumberSymbols(COMPACT_DECIMAL_SHORT_PATTERN: const {
    3: {'other': '0k'},
    6: {'other': '0M'},
    9: {'other': '0B'},
    12: {'other': '0T'},
  }, COMPACT_DECIMAL_LONG_PATTERN: const {
    3: {
      'few': '0 mh\u00EDle',
      'many': '0 m\u00EDle',
      'one': '0 mh\u00EDle',
      'other': '0 m\u00EDle',
      'two': '0 mh\u00EDle',
    },
    4: {'other': '00 m\u00EDle'},
    6: {
      'few': '0 mhilli\u00FAn',
      'many': '0 milli\u00FAn',
      'one': '0 mhilli\u00FAn',
      'other': '0 milli\u00FAn',
      'two': '0 mhilli\u00FAn',
    },
    7: {'other': '00 milli\u00FAn'},
    9: {
      'few': '0 bhilli\u00FAn',
      'many': '0 mbilli\u00FAn',
      'one': '0 bhilli\u00FAn',
      'other': '0 billi\u00FAn',
      'two': '0 bhilli\u00FAn',
    },
    10: {
      'few': '00 billi\u00FAn',
      'many': '00 mbilli\u00FAn',
      'one': '00 billi\u00FAn',
      'other': '00 billi\u00FAn',
      'two': '00 billi\u00FAn',
    },
    11: {'other': '000 billi\u00FAn'},
    12: {
      'few': '0 thrilli\u00FAn',
      'many': '0 dtrilli\u00FAn',
      'one': '0 trilli\u00FAn',
      'other': '0 trilli\u00FAn',
      'two': '0 thrilli\u00FAn',
    },
    13: {
      'few': '00 trilli\u00FAn',
      'many': '00 dtrilli\u00FAn',
      'one': '00 trilli\u00FAn',
      'other': '00 trilli\u00FAn',
      'two': '00 trilli\u00FAn',
    },
    14: {'other': '000 trilli\u00FAn'},
  }, COMPACT_DECIMAL_SHORT_CURRENCY_PATTERN: const {
    3: {'other': '\u00A40k'},
    6: {'other': '\u00A40M'},
    9: {'other': '\u00A40B'},
    12: {'other': '\u00A40T'},
  }),
  // Compact number symbols for locale gl.
  "gl": new CompactNumberSymbols(COMPACT_DECIMAL_SHORT_PATTERN: const {
    3: {'other': '0'},
    4: {'other': '0'},
    5: {'other': '0'},
    6: {'other': '0\u00A0M'},
    12: {'other': '0\u00A0B'},
  }, COMPACT_DECIMAL_LONG_PATTERN: const {
    6: {
      'one': '0 mill\u00F3n',
      'other': '0 mill\u00F3ns',
    },
    7: {'other': '00 mill\u00F3ns'},
    12: {
      'one': '0 bill\u00F3n',
      'other': '0 bill\u00F3ns',
    },
    13: {'other': '00 bill\u00F3ns'},
  }, COMPACT_DECIMAL_SHORT_CURRENCY_PATTERN: const {
    3: {'other': '0'},
    4: {'other': '0'},
    5: {'other': '0'},
    6: {'other': '0\u00A0M\u00A4'},
    12: {'other': '0\u00A0B\u00A4'},
  }),
  // Compact number symbols for locale gsw.
  "gsw": new CompactNumberSymbols(COMPACT_DECIMAL_SHORT_PATTERN: const {
    3: {'other': '0\u00A0Tsg.'},
    6: {'other': '0\u00A0Mio.'},
    9: {'other': '0\u00A0Mrd.'},
    12: {'other': '0\u00A0Bio.'},
  }, COMPACT_DECIMAL_LONG_PATTERN: const {
    3: {'other': '0 Tuusig'},
    6: {
      'one': '0 Millioon',
      'other': '0 Millioone',
    },
    9: {'other': '0 Milliarde'},
    12: {
      'one': '0 Billioon',
      'other': '0 Billioone',
    },
  }, COMPACT_DECIMAL_SHORT_CURRENCY_PATTERN: const {
    3: {'other': '0\u00A0Tsg.\u00A0\u00A4'},
    6: {'other': '0\u00A0Mio.\u00A0\u00A4'},
    9: {'other': '0\u00A0Mrd.\u00A0\u00A4'},
    12: {'other': '0\u00A0Bio.\u00A0\u00A4'},
  }),
  // Compact number symbols for locale gu.
  "gu": new CompactNumberSymbols(COMPACT_DECIMAL_SHORT_PATTERN: const {
    3: {'other': '0\u00A0\u0AB9\u0A9C\u0ABE\u0AB0'},
    5: {'other': '0\u00A0\u0AB2\u0ABE\u0A96'},
    7: {'other': '0\u00A0\u0A95\u0AB0\u0ACB\u0AA1'},
    9: {'other': '0\u00A0\u0A85\u0AAC\u0A9C'},
    11: {'other': '0\u00A0\u0AA8\u0ABF\u0A96\u0AB0\u0ACD\u0AB5'},
    12: {'other': '0\u00A0\u0AAE\u0AB9\u0ABE\u0AAA\u0AA6\u0ACD\u0AAE'},
    13: {'other': '0\u00A0\u0AB6\u0A82\u0A95\u0AC1'},
    14: {'other': '0\u00A0\u0A9C\u0AB2\u0AA7\u0ABF'},
  }, COMPACT_DECIMAL_LONG_PATTERN: const {
    3: {'other': '0 \u0AB9\u0A9C\u0ABE\u0AB0'},
    5: {'other': '0 \u0AB2\u0ABE\u0A96'},
    7: {'other': '0 \u0A95\u0AB0\u0ACB\u0AA1'},
    9: {'other': '0 \u0A85\u0AAC\u0A9C'},
    11: {'other': '0 \u0AA8\u0ABF\u0A96\u0AB0\u0ACD\u0AB5'},
    12: {'other': '0 \u0AAE\u0AB9\u0ABE\u0AAA\u0AA6\u0ACD\u0AAE'},
    13: {'other': '0 \u0AB6\u0A82\u0A95\u0AC1'},
    14: {'other': '0 \u0A9C\u0AB2\u0AA7\u0ABF'},
  }, COMPACT_DECIMAL_SHORT_CURRENCY_PATTERN: const {
    3: {'other': '\u00A40\u00A0\u0AB9\u0A9C\u0ABE\u0AB0'},
    5: {'other': '\u00A40\u00A0\u0AB2\u0ABE\u0A96'},
    7: {'other': '\u00A40\u00A0\u0A95\u0AB0\u0ACB\u0AA1'},
    9: {'other': '\u00A40\u00A0\u0A85\u0AAC\u0A9C'},
    11: {'other': '\u00A40\u00A0\u0AA8\u0ABF\u0A96\u0AB0\u0ACD\u0AB5'},
    12: {'other': '\u00A40\u00A0\u0AAE\u0AB9\u0ABE\u0AAA\u0AA6\u0ACD\u0AAE'},
    13: {'other': '\u00A40\u00A0\u0AB6\u0A82\u0A95\u0AC1'},
    14: {'other': '\u00A40\u00A0\u0A9C\u0AB2\u0AA7\u0ABF'},
  }),
  // Compact number symbols for locale haw.
  "haw": new CompactNumberSymbols(COMPACT_DECIMAL_SHORT_PATTERN: const {
    3: {'other': '0K'},
    6: {'other': '0M'},
    9: {'other': '0G'},
    12: {'other': '0T'},
  }, COMPACT_DECIMAL_SHORT_CURRENCY_PATTERN: const {
    3: {'other': '\u00A40K'},
    6: {'other': '\u00A40M'},
    9: {'other': '\u00A40G'},
    12: {'other': '\u00A40T'},
  }),
  // Compact number symbols for locale he.
  "he": new CompactNumberSymbols(COMPACT_DECIMAL_SHORT_PATTERN: const {
    3: {'other': '0K\u200F'},
    6: {'other': '0M\u200F'},
    9: {'other': '0B\u200F'},
    12: {'other': '0T\u200F'},
  }, COMPACT_DECIMAL_LONG_PATTERN: const {
    3: {'other': '\u200F0 \u05D0\u05DC\u05E3'},
    6: {'other': '\u200F0 \u05DE\u05D9\u05DC\u05D9\u05D5\u05DF'},
    9: {'other': '\u200F0 \u05DE\u05D9\u05DC\u05D9\u05D0\u05E8\u05D3'},
    12: {'other': '\u200F0 \u05D8\u05E8\u05D9\u05DC\u05D9\u05D5\u05DF'},
  }, COMPACT_DECIMAL_SHORT_CURRENCY_PATTERN: const {
    3: {'other': '\u00A40K\u200F'},
    6: {'other': '\u00A40M\u200F'},
    9: {'other': '\u00A40B\u200F'},
    12: {'other': '\u00A40T\u200F'},
  }),
  // Compact number symbols for locale hi.
  "hi": new CompactNumberSymbols(COMPACT_DECIMAL_SHORT_PATTERN: const {
    3: {'other': '0\u00A0\u0939\u091C\u093C\u093E\u0930'},
    5: {'other': '0\u00A0\u0932\u093E\u0916'},
    7: {'other': '0\u00A0\u0915\u0970'},
    9: {'other': '0\u00A0\u0905\u0970'},
    11: {'other': '0\u00A0\u0916\u0970'},
    13: {'other': '0\u00A0\u0928\u0940\u0932'},
  }, COMPACT_DECIMAL_LONG_PATTERN: const {
    3: {'other': '0 \u0939\u091C\u093C\u093E\u0930'},
    5: {'other': '0 \u0932\u093E\u0916'},
    7: {'other': '0 \u0915\u0930\u094B\u0921\u093C'},
    9: {'other': '0 \u0905\u0930\u092C'},
    11: {'other': '0 \u0916\u0930\u092C'},
  }, COMPACT_DECIMAL_SHORT_CURRENCY_PATTERN: const {
    3: {'other': '\u00A40\u00A0\u0939\u091C\u093C\u093E\u0930'},
    5: {'other': '\u00A40\u00A0\u0932\u093E\u0916'},
    7: {'other': '\u00A40\u00A0\u0915\u0970'},
    9: {'other': '\u00A40\u00A0\u0905\u0970'},
    11: {'other': '\u00A40\u00A0\u0916\u0970'},
    13: {'other': '\u00A40\u00A0\u0928\u0940\u0932'},
  }),
  // Compact number symbols for locale hr.
  "hr": new CompactNumberSymbols(COMPACT_DECIMAL_SHORT_PATTERN: const {
    3: {'other': '0\u00A0tis.'},
    6: {'other': '0\u00A0mil.'},
    9: {'other': '0\u00A0mlr.'},
    12: {'other': '0\u00A0bil.'},
  }, COMPACT_DECIMAL_LONG_PATTERN: const {
    3: {
      'few': '0 tisu\u0107e',
      'one': '0 tisu\u0107a',
      'other': '0 tisu\u0107a',
    },
    6: {
      'few': '0 milijuna',
      'one': '0 milijun',
      'other': '0 milijuna',
    },
    9: {
      'few': '0 milijarde',
      'one': '0 milijarda',
      'other': '0 milijardi',
    },
    12: {
      'few': '0 bilijuna',
      'one': '0 bilijun',
      'other': '0 bilijuna',
    },
  }, COMPACT_DECIMAL_SHORT_CURRENCY_PATTERN: const {
    3: {'other': '0\u00A0tis.\u00A0\u00A4'},
    6: {'other': '0\u00A0mil.\u00A0\u00A4'},
    9: {'other': '0\u00A0mlr.\u00A0\u00A4'},
    12: {'other': '0\u00A0bil.\u00A0\u00A4'},
  }),
  // Compact number symbols for locale hu.
  "hu": new CompactNumberSymbols(COMPACT_DECIMAL_SHORT_PATTERN: const {
    3: {'other': '0\u00A0E'},
    6: {'other': '0\u00A0M'},
    9: {'other': '0\u00A0Mrd'},
    12: {'other': '0\u00A0B'},
  }, COMPACT_DECIMAL_LONG_PATTERN: const {
    3: {'other': '0 ezer'},
    6: {'other': '0 milli\u00F3'},
    9: {'other': '0 milli\u00E1rd'},
    12: {'other': '0 billi\u00F3'},
  }, COMPACT_DECIMAL_SHORT_CURRENCY_PATTERN: const {
    3: {'other': '0\u00A0E\u00A0\u00A4'},
    6: {'other': '0\u00A0M\u00A0\u00A4'},
    9: {'other': '0\u00A0Mrd\u00A0\u00A4'},
    12: {'other': '0\u00A0B\u00A0\u00A4'},
  }),
  // Compact number symbols for locale hy.
  "hy": new CompactNumberSymbols(COMPACT_DECIMAL_SHORT_PATTERN: const {
    3: {'other': '0\u00A0\u0570\u0566\u0580'},
    6: {'other': '0\u00A0\u0574\u056C\u0576'},
    9: {'other': '0\u00A0\u0574\u056C\u0580\u0564'},
    12: {'other': '0\u00A0\u057F\u0580\u056C\u0576'},
  }, COMPACT_DECIMAL_LONG_PATTERN: const {
    3: {'other': '0 \u0570\u0561\u0566\u0561\u0580'},
    6: {'other': '0 \u0574\u056B\u056C\u056B\u0578\u0576'},
    9: {'other': '0 \u0574\u056B\u056C\u056B\u0561\u0580\u0564'},
    12: {'other': '0 \u057F\u0580\u056B\u056C\u056B\u0578\u0576'},
  }, COMPACT_DECIMAL_SHORT_CURRENCY_PATTERN: const {
    3: {'other': '0\u00A0\u0570\u0566\u0580\u00A0\u00A4'},
    6: {'other': '0\u00A0\u0574\u056C\u0576\u00A0\u00A4'},
    9: {'other': '0\u00A0\u0574\u056C\u0580\u0564\u00A0\u00A4'},
    12: {'other': '0\u00A0\u057F\u0580\u056C\u0576\u00A0\u00A4'},
  }),
  // Compact number symbols for locale id.
  "id": new CompactNumberSymbols(COMPACT_DECIMAL_SHORT_PATTERN: const {
    3: {'other': '0\u00A0rb'},
    6: {'other': '0\u00A0jt'},
    9: {'other': '0\u00A0M'},
    12: {'other': '0\u00A0T'},
  }, COMPACT_DECIMAL_LONG_PATTERN: const {
    3: {'other': '0 ribu'},
    6: {'other': '0 juta'},
    9: {'other': '0 miliar'},
    12: {'other': '0 triliun'},
  }, COMPACT_DECIMAL_SHORT_CURRENCY_PATTERN: const {
    3: {'other': '\u00A40\u00A0rb'},
    6: {'other': '\u00A40\u00A0jt'},
    9: {'other': '\u00A40\u00A0M'},
    12: {'other': '\u00A40\u00A0T'},
  }),
  // Compact number symbols for locale in.
  "in": new CompactNumberSymbols(COMPACT_DECIMAL_SHORT_PATTERN: const {
    3: {'other': '0\u00A0rb'},
    6: {'other': '0\u00A0jt'},
    9: {'other': '0\u00A0M'},
    12: {'other': '0\u00A0T'},
  }, COMPACT_DECIMAL_LONG_PATTERN: const {
    3: {'other': '0 ribu'},
    6: {'other': '0 juta'},
    9: {'other': '0 miliar'},
    12: {'other': '0 triliun'},
  }, COMPACT_DECIMAL_SHORT_CURRENCY_PATTERN: const {
    3: {'other': '\u00A40\u00A0rb'},
    6: {'other': '\u00A40\u00A0jt'},
    9: {'other': '\u00A40\u00A0M'},
    12: {'other': '\u00A40\u00A0T'},
  }),
  // Compact number symbols for locale is.
  "is": new CompactNumberSymbols(COMPACT_DECIMAL_SHORT_PATTERN: const {
    3: {'other': '0\u00A0\u00FE.'},
    6: {'other': '0\u00A0m.'},
    9: {'other': '0\u00A0ma.'},
    12: {'other': '0\u00A0bn'},
  }, COMPACT_DECIMAL_LONG_PATTERN: const {
    3: {'other': '0 \u00FE\u00FAsund'},
    6: {
      'one': '0 millj\u00F3n',
      'other': '0 millj\u00F3nir',
    },
    9: {
      'one': '0 milljar\u00F0ur',
      'other': '0 milljar\u00F0ar',
    },
    12: {
      'one': '0 billj\u00F3n',
      'other': '0 billj\u00F3nir',
    },
  }, COMPACT_DECIMAL_SHORT_CURRENCY_PATTERN: const {
    3: {'other': '0\u00A0\u00FE.\u00A0\u00A4'},
    6: {'other': '0\u00A0m.\u00A0\u00A4'},
    9: {'other': '0\u00A0ma.\u00A0\u00A4'},
    12: {'other': '0\u00A0bn\u00A0\u00A4'},
  }),
  // Compact number symbols for locale it.
  "it": new CompactNumberSymbols(COMPACT_DECIMAL_SHORT_PATTERN: const {
    3: {'other': '0'},
    4: {'other': '0'},
    5: {'other': '0'},
    6: {'other': '0\u00A0Mln'},
    9: {'other': '0\u00A0Mld'},
    12: {'other': '0\u00A0Bln'},
  }, COMPACT_DECIMAL_LONG_PATTERN: const {
    3: {
      'one': 'mille',
      'other': '0 mila',
    },
    4: {'other': '00 mila'},
    6: {
      'one': '0 milione',
      'other': '0 milioni',
    },
    7: {'other': '00 milioni'},
    9: {
      'one': '0 miliardo',
      'other': '0 miliardi',
    },
    10: {'other': '00 miliardi'},
    12: {
      'one': '0 mille miliardi',
      'other': '0 mila miliardi',
    },
    13: {'other': '00 mila miliardi'},
  }, COMPACT_DECIMAL_SHORT_CURRENCY_PATTERN: const {
    3: {'other': '0'},
    4: {'other': '0'},
    5: {'other': '0'},
    6: {'other': '0\u00A0Mln\u00A0\u00A4'},
    9: {'other': '0\u00A0Mld\u00A0\u00A4'},
    12: {'other': '0\u00A0Bln\u00A0\u00A4'},
  }),
  // Compact number symbols for locale it_CH.
  "it_CH": new CompactNumberSymbols(COMPACT_DECIMAL_SHORT_PATTERN: const {
    3: {'other': '0'},
    4: {'other': '0'},
    5: {'other': '0'},
    6: {'other': '0\u00A0Mln'},
    9: {'other': '0\u00A0Mld'},
    12: {'other': '0\u00A0Bln'},
  }, COMPACT_DECIMAL_LONG_PATTERN: const {
    3: {
      'one': 'mille',
      'other': '0 mila',
    },
    4: {'other': '00 mila'},
    6: {
      'one': '0 milione',
      'other': '0 milioni',
    },
    7: {'other': '00 milioni'},
    9: {
      'one': '0 miliardo',
      'other': '0 miliardi',
    },
    10: {'other': '00 miliardi'},
    12: {
      'one': '0 mille miliardi',
      'other': '0 mila miliardi',
    },
    13: {'other': '00 mila miliardi'},
  }, COMPACT_DECIMAL_SHORT_CURRENCY_PATTERN: const {
    3: {'other': '0'},
    4: {'other': '0'},
    5: {'other': '0'},
    6: {'other': '0\u00A0Mln\u00A0\u00A4'},
    9: {'other': '0\u00A0Mld\u00A0\u00A4'},
    12: {'other': '0\u00A0Bln\u00A0\u00A4'},
  }),
  // Compact number symbols for locale iw.
  "iw": new CompactNumberSymbols(COMPACT_DECIMAL_SHORT_PATTERN: const {
    3: {'other': '0K\u200F'},
    6: {'other': '0M\u200F'},
    9: {'other': '0B\u200F'},
    12: {'other': '0T\u200F'},
  }, COMPACT_DECIMAL_LONG_PATTERN: const {
    3: {'other': '\u200F0 \u05D0\u05DC\u05E3'},
    6: {'other': '\u200F0 \u05DE\u05D9\u05DC\u05D9\u05D5\u05DF'},
    9: {'other': '\u200F0 \u05DE\u05D9\u05DC\u05D9\u05D0\u05E8\u05D3'},
    12: {'other': '\u200F0 \u05D8\u05E8\u05D9\u05DC\u05D9\u05D5\u05DF'},
  }, COMPACT_DECIMAL_SHORT_CURRENCY_PATTERN: const {
    3: {'other': '\u00A40K\u200F'},
    6: {'other': '\u00A40M\u200F'},
    9: {'other': '\u00A40B\u200F'},
    12: {'other': '\u00A40T\u200F'},
  }),
  // Compact number symbols for locale ja.
  "ja": new CompactNumberSymbols(COMPACT_DECIMAL_SHORT_PATTERN: const {
    3: {'other': '0'},
    4: {'other': '0\u4E07'},
    8: {'other': '0\u5104'},
    12: {'other': '0\u5146'},
    16: {'other': '0\u4EAC'},
  }, COMPACT_DECIMAL_SHORT_CURRENCY_PATTERN: const {
    3: {'other': '0'},
    4: {'other': '\u00A40\u4E07'},
    8: {'other': '\u00A40\u5104'},
    12: {'other': '\u00A40\u5146'},
    16: {'other': '\u00A40\u4EAC'},
  }),
  // Compact number symbols for locale ka.
  "ka": new CompactNumberSymbols(COMPACT_DECIMAL_SHORT_PATTERN: const {
    3: {'other': '0\u00A0\u10D0\u10D7.'},
    6: {'other': '0\u00A0\u10DB\u10DA\u10DC.'},
    9: {'other': '0\u00A0\u10DB\u10DA\u10E0\u10D3.'},
    11: {'other': '000\u00A0\u10DB\u10DA\u10E0.'},
    12: {'other': '0\u00A0\u10E2\u10E0\u10DA.'},
  }, COMPACT_DECIMAL_LONG_PATTERN: const {
    3: {'other': '0 \u10D0\u10D7\u10D0\u10E1\u10D8'},
    6: {'other': '0 \u10DB\u10D8\u10DA\u10D8\u10DD\u10DC\u10D8'},
    9: {'other': '0 \u10DB\u10D8\u10DA\u10D8\u10D0\u10E0\u10D3\u10D8'},
    12: {'other': '0 \u10E2\u10E0\u10D8\u10DA\u10D8\u10DD\u10DC\u10D8'},
  }, COMPACT_DECIMAL_SHORT_CURRENCY_PATTERN: const {
    3: {'other': '0\u00A0\u10D0\u10D7.\u00A0\u00A4'},
    6: {'other': '0\u00A0\u10DB\u10DA\u10DC.\u00A0\u00A4'},
    9: {'other': '0\u00A0\u10DB\u10DA\u10E0\u10D3.\u00A0\u00A4'},
    11: {'other': '000\u00A0\u10DB\u10DA\u10E0.\u00A0\u00A4'},
    12: {'other': '0\u00A0\u10E2\u10E0\u10DA.\u00A0\u00A4'},
  }),
  // Compact number symbols for locale kk.
  "kk": new CompactNumberSymbols(COMPACT_DECIMAL_SHORT_PATTERN: const {
    3: {'other': '0\u00A0\u043C\u044B\u04A3'},
    5: {'other': '000\u00A0\u043C.'},
    6: {'other': '0\u00A0\u043C\u043B\u043D'},
    9: {'other': '0\u00A0\u043C\u043B\u0440\u0434'},
    12: {'other': '0\u00A0\u0442\u0440\u043B\u043D'},
  }, COMPACT_DECIMAL_LONG_PATTERN: const {
    3: {'other': '0 \u043C\u044B\u04A3'},
    6: {'other': '0 \u043C\u0438\u043B\u043B\u0438\u043E\u043D'},
    9: {'other': '0 \u043C\u0438\u043B\u043B\u0438\u0430\u0440\u0434'},
    12: {'other': '0 \u0442\u0440\u0438\u043B\u043B\u0438\u043E\u043D'},
  }, COMPACT_DECIMAL_SHORT_CURRENCY_PATTERN: const {
    3: {'other': '0\u00A0\u043C\u044B\u04A3\u00A0\u00A4'},
    6: {'other': '0\u00A0\u043C\u043B\u043D\u00A0\u00A4'},
    9: {'other': '0\u00A0\u043C\u043B\u0440\u0434\u00A0\u00A4'},
    12: {'other': '0\u00A0\u0442\u0440\u043B\u043D\u00A0\u00A4'},
  }),
  // Compact number symbols for locale km.
  "km": new CompactNumberSymbols(COMPACT_DECIMAL_SHORT_PATTERN: const {
    3: {'other': '0\u1796\u17B6\u1793\u17CB'},
    4: {'other': '00\u00A0\u1796\u17B6\u1793\u17CB'},
    6: {'other': '0\u00A0\u179B\u17B6\u1793'},
    9: {'other': '0\u00A0\u1794\u17CA\u17B8\u179B\u17B6\u1793'},
    12: {'other': '0\u00A0\u1791\u17D2\u179A\u17B8\u179B\u17B6\u1793'},
  }, COMPACT_DECIMAL_LONG_PATTERN: const {
    3: {'other': '0 \u1796\u17B6\u1793\u17CB'},
    5: {'other': '000\u1796\u17B6\u1793\u17CB'},
    6: {'other': '0 \u179B\u17B6\u1793'},
    9: {'other': '0 \u1794\u17CA\u17B8\u179B\u17B6\u1793'},
    12: {'other': '0 \u1791\u17D2\u179A\u17B8\u179B\u17B6\u1793'},
  }, COMPACT_DECIMAL_SHORT_CURRENCY_PATTERN: const {
    3: {'other': '\u00A40\u00A0\u1796\u17B6\u1793\u17CB'},
    6: {'other': '\u00A40\u00A0\u179B\u17B6\u1793'},
    9: {'other': '\u00A40\u00A0\u1794\u17CA\u17B8\u179B\u17B6\u1793'},
    12: {'other': '\u00A40\u00A0\u1791\u17D2\u179A\u17B8\u179B\u17B6\u1793'},
  }),
  // Compact number symbols for locale kn.
  "kn": new CompactNumberSymbols(COMPACT_DECIMAL_SHORT_PATTERN: const {
    3: {'other': '0\u0CB8\u0CBE'},
    6: {'other': '0\u0CAE\u0CBF'},
    9: {'other': '0\u0CAC\u0CBF'},
    12: {'other': '0\u0C9F\u0CCD\u0CB0\u0CBF'},
  }, COMPACT_DECIMAL_LONG_PATTERN: const {
    3: {'other': '0 \u0CB8\u0CBE\u0CB5\u0CBF\u0CB0'},
    6: {'other': '0 \u0CAE\u0CBF\u0CB2\u0CBF\u0CAF\u0CA8\u0CCD'},
    9: {'other': '0 \u0CAC\u0CBF\u0CB2\u0CBF\u0CAF\u0CA8\u0CCD'},
    12: {
      'other': '0 \u0C9F\u0CCD\u0CB0\u0CBF\u0CB2\u0CBF\u0CAF\u0CA8\u0CCD\u200C'
    },
  }, COMPACT_DECIMAL_SHORT_CURRENCY_PATTERN: const {
    3: {'other': '\u00A40\u0CB8\u0CBE'},
    6: {'other': '\u00A40\u0CAE\u0CBF'},
    9: {'other': '\u00A40\u0CAC\u0CBF'},
    12: {'other': '\u00A40\u0C9F\u0CCD\u0CB0\u0CBF'},
  }),
  // Compact number symbols for locale ko.
  "ko": new CompactNumberSymbols(COMPACT_DECIMAL_SHORT_PATTERN: const {
    3: {'other': '0\uCC9C'},
    4: {'other': '0\uB9CC'},
    8: {'other': '0\uC5B5'},
    12: {'other': '0\uC870'},
  }, COMPACT_DECIMAL_SHORT_CURRENCY_PATTERN: const {
    3: {'other': '\u00A40\uCC9C'},
    4: {'other': '\u00A40\uB9CC'},
    8: {'other': '\u00A40\uC5B5'},
    12: {'other': '\u00A40\uC870'},
  }),
  // Compact number symbols for locale ky.
  "ky": new CompactNumberSymbols(COMPACT_DECIMAL_SHORT_PATTERN: const {
    3: {'other': '0\u00A0\u043C\u0438\u04A3'},
    6: {'other': '0\u00A0\u043C\u043B\u043D'},
    9: {'other': '0\u00A0\u043C\u043B\u0434'},
    12: {'other': '0\u00A0\u0442\u0440\u043B\u043D'},
  }, COMPACT_DECIMAL_LONG_PATTERN: const {
    3: {'other': '0 \u043C\u0438\u04A3'},
    6: {'other': '0 \u043C\u0438\u043B\u043B\u0438\u043E\u043D'},
    9: {'other': '0 \u043C\u0438\u043B\u043B\u0438\u0430\u0440\u0434'},
    12: {'other': '0 \u0442\u0440\u0438\u043B\u043B\u0438\u043E\u043D'},
  }, COMPACT_DECIMAL_SHORT_CURRENCY_PATTERN: const {
    3: {'other': '0\u00A0\u043C\u0438\u04A3\u00A0\u00A4'},
    6: {'other': '0\u00A0\u043C\u043B\u043D\u00A0\u00A4'},
    9: {'other': '0\u00A0\u043C\u043B\u0434\u00A0\u00A4'},
    12: {'other': '0\u00A0\u0442\u0440\u043B\u043D\u00A0\u00A4'},
  }),
  // Compact number symbols for locale ln.
  "ln": new CompactNumberSymbols(COMPACT_DECIMAL_SHORT_PATTERN: const {
    3: {'other': '0K'},
    6: {'other': '0M'},
    9: {'other': '0G'},
    12: {'other': '0T'},
  }, COMPACT_DECIMAL_SHORT_CURRENCY_PATTERN: const {
    3: {'other': '0K\u00A0\u00A4'},
    6: {'other': '0M\u00A0\u00A4'},
    9: {'other': '0G\u00A0\u00A4'},
    12: {'other': '0T\u00A0\u00A4'},
  }),
  // Compact number symbols for locale lo.
  "lo": new CompactNumberSymbols(COMPACT_DECIMAL_SHORT_PATTERN: const {
    3: {'other': '0\u00A0\u0E9E\u0EB1\u0E99'},
    6: {'other': '0\u00A0\u0EA5\u0EC9\u0EB2\u0E99'},
    9: {'other': '0\u00A0\u0E95\u0EB7\u0EC9'},
    12: {'other': '0\u00A0\u0EA5\u0EC9\u0EB2\u0E99\u0EA5\u0EC9\u0EB2\u0E99'},
    13: {'other': '00\u0EA5\u0EA5'},
  }, COMPACT_DECIMAL_LONG_PATTERN: const {
    3: {'other': '0 \u0E9E\u0EB1\u0E99'},
    5: {'other': '0 \u0EC1\u0EAA\u0E99'},
    6: {'other': '0 \u0EA5\u0EC9\u0EB2\u0E99'},
    9: {'other': '0 \u0E95\u0EB7\u0EC9'},
    12: {'other': '0 \u0EA5\u0EC9\u0EB2\u0E99\u0EA5\u0EC9\u0EB2\u0E99'},
  }, COMPACT_DECIMAL_SHORT_CURRENCY_PATTERN: const {
    3: {'other': '\u00A40\u00A0\u0E9E\u0EB1\u0E99'},
    6: {'other': '\u00A40\u00A0\u0EA5\u0EC9\u0EB2\u0E99'},
    9: {'other': '\u00A40\u00A0\u0E95\u0EB7\u0EC9'},
    12: {
      'other': '\u00A40\u00A0\u0EA5\u0EC9\u0EB2\u0E99\u0EA5\u0EC9\u0EB2\u0E99'
    },
  }),
  // Compact number symbols for locale lt.
  "lt": new CompactNumberSymbols(COMPACT_DECIMAL_SHORT_PATTERN: const {
    3: {'other': '0\u00A0t\u016Bkst.'},
    6: {'other': '0\u00A0mln.'},
    9: {'other': '0\u00A0mlrd.'},
    12: {'other': '0\u00A0trln.'},
  }, COMPACT_DECIMAL_LONG_PATTERN: const {
    3: {
      'few': '0 t\u016Bkstan\u010Diai',
      'many': '0 t\u016Bkstan\u010Dio',
      'one': '0 t\u016Bkstantis',
      'other': '0 t\u016Bkstan\u010Di\u0173',
    },
    6: {
      'few': '0 milijonai',
      'many': '0 milijono',
      'one': '0 milijonas',
      'other': '0 milijon\u0173',
    },
    9: {
      'few': '0 milijardai',
      'many': '0 milijardo',
      'one': '0 milijardas',
      'other': '0 milijard\u0173',
    },
    12: {
      'few': '0 trilijonai',
      'many': '0 trilijono',
      'one': '0 trilijonas',
      'other': '0 trilijon\u0173',
    },
  }, COMPACT_DECIMAL_SHORT_CURRENCY_PATTERN: const {
    3: {'other': '0\u00A0t\u016Bkst.\u00A0\u00A4'},
    6: {'other': '0\u00A0mln.\u00A0\u00A4'},
    9: {'other': '0\u00A0mlrd.\u00A0\u00A4'},
    12: {'other': '0\u00A0trln.\u00A0\u00A4'},
  }),
  // Compact number symbols for locale lv.
  "lv": new CompactNumberSymbols(COMPACT_DECIMAL_SHORT_PATTERN: const {
    3: {'other': '0\u00A0t\u016Bkst.'},
    6: {'other': '0\u00A0milj.'},
    9: {'other': '0\u00A0mljrd.'},
    12: {'other': '0\u00A0trilj.'},
  }, COMPACT_DECIMAL_LONG_PATTERN: const {
    3: {
      'one': '0 t\u016Bkstotis',
      'other': '0 t\u016Bksto\u0161i',
      'zero': '0 t\u016Bksto\u0161u',
    },
    4: {
      'one': '00 t\u016Bkstotis',
      'other': '00 t\u016Bksto\u0161i',
      'zero': '00 t\u016Bksto\u0161i',
    },
    6: {
      'one': '0 miljons',
      'other': '0 miljoni',
      'zero': '0 miljonu',
    },
    7: {
      'one': '00 miljons',
      'other': '00 miljoni',
      'zero': '00 miljoni',
    },
    9: {
      'one': '0 miljards',
      'other': '0 miljardi',
      'zero': '0 miljardu',
    },
    10: {
      'one': '00 miljards',
      'other': '00 miljardi',
      'zero': '00 miljardi',
    },
    12: {
      'one': '0 triljons',
      'other': '0 triljoni',
      'zero': '0 triljonu',
    },
    13: {
      'one': '00 triljons',
      'other': '00 triljoni',
      'zero': '00 triljoni',
    },
  }, COMPACT_DECIMAL_SHORT_CURRENCY_PATTERN: const {
    3: {'other': '0\u00A0t\u016Bkst.\u00A0\u00A4'},
    6: {'other': '0\u00A0milj.\u00A0\u00A4'},
    9: {'other': '0\u00A0mljrd.\u00A0\u00A4'},
    12: {'other': '0\u00A0trilj.\u00A0\u00A4'},
  }),
  // Compact number symbols for locale mg.
  "mg": new CompactNumberSymbols(COMPACT_DECIMAL_SHORT_PATTERN: const {
    3: {'other': '0K'},
    6: {'other': '0M'},
    9: {'other': '0G'},
    12: {'other': '0T'},
  }, COMPACT_DECIMAL_SHORT_CURRENCY_PATTERN: const {
    3: {'other': '\u00A40K'},
    6: {'other': '\u00A40M'},
    9: {'other': '\u00A40G'},
    12: {'other': '\u00A40T'},
  }),
  // Compact number symbols for locale mk.
  "mk": new CompactNumberSymbols(COMPACT_DECIMAL_SHORT_PATTERN: const {
    3: {'other': '0\u00A0\u0438\u043B\u0458.'},
    6: {'other': '0\u00A0\u043C\u0438\u043B.'},
    8: {'other': '000\u00A0\u041C'},
    9: {'other': '0\u00A0\u043C\u0438\u043B\u0458.'},
    11: {
      'one': '000\u00A0\u043C\u0458.',
      'other': '000\u00A0\u043C\u0438.',
    },
    12: {'other': '0\u00A0\u0431\u0438\u043B.'},
  }, COMPACT_DECIMAL_LONG_PATTERN: const {
    3: {
      'one': '0 \u0438\u043B\u0458\u0430\u0434\u0430',
      'other': '0 \u0438\u043B\u0458\u0430\u0434\u0438',
    },
    6: {
      'one': '0 \u043C\u0438\u043B\u0438\u043E\u043D',
      'other': '0 \u043C\u0438\u043B\u0438\u043E\u043D\u0438',
    },
    9: {
      'one': '0 \u043C\u0438\u043B\u0438\u0458\u0430\u0440\u0434\u0430',
      'other': '0 \u043C\u0438\u043B\u0438\u0458\u0430\u0440\u0434\u0438',
    },
    12: {
      'one': '0 \u0431\u0438\u043B\u0438\u043E\u043D',
      'other': '0 \u0431\u0438\u043B\u0438\u043E\u043D\u0438',
    },
  }, COMPACT_DECIMAL_SHORT_CURRENCY_PATTERN: const {
    3: {'other': '0\u00A0\u0438\u043B\u0458.\u00A0\u00A4'},
    6: {'other': '0\u00A0\u043C\u0438\u043B.\u00A0\u00A4'},
    9: {'other': '0\u00A0\u043C\u0438\u043B\u0458.\u00A0\u00A4'},
    12: {'other': '0\u00A0\u0431\u0438\u043B.\u00A0\u00A4'},
  }),
  // Compact number symbols for locale ml.
  "ml": new CompactNumberSymbols(COMPACT_DECIMAL_SHORT_PATTERN: const {
    3: {'other': '0K'},
    6: {'other': '0M'},
    9: {'other': '0B'},
    12: {'other': '0T'},
  }, COMPACT_DECIMAL_LONG_PATTERN: const {
    3: {'other': '0 \u0D06\u0D2F\u0D3F\u0D30\u0D02'},
    6: {'other': '0 \u0D26\u0D36\u0D32\u0D15\u0D4D\u0D37\u0D02'},
    9: {'other': '0 \u0D2C\u0D3F\u0D32\u0D4D\u0D2F\u0D7A'},
    12: {'other': '0 \u0D1F\u0D4D\u0D30\u0D3F\u0D32\u0D4D\u0D2F\u0D7A'},
  }, COMPACT_DECIMAL_SHORT_CURRENCY_PATTERN: const {
    3: {'other': '\u00A40K'},
    6: {'other': '\u00A40M'},
    9: {'other': '\u00A40B'},
    12: {'other': '\u00A40T'},
  }),
  // Compact number symbols for locale mn.
  "mn": new CompactNumberSymbols(COMPACT_DECIMAL_SHORT_PATTERN: const {
    3: {'other': '0\u00A0\u043C\u044F\u043D\u0433\u0430'},
    6: {'other': '0\u00A0\u0441\u0430\u044F'},
    9: {'other': '0\u00A0\u0442\u044D\u0440\u0431\u0443\u043C'},
    11: {'other': '000\u0422'},
    12: {'other': '0\u0418\u041D'},
  }, COMPACT_DECIMAL_LONG_PATTERN: const {
    3: {'other': '0 \u043C\u044F\u043D\u0433\u0430'},
    6: {'other': '0 \u0441\u0430\u044F'},
    9: {'other': '0 \u0442\u044D\u0440\u0431\u0443\u043C'},
    12: {'other': '0 \u0438\u0445 \u043D\u0430\u044F\u0434'},
  }, COMPACT_DECIMAL_SHORT_CURRENCY_PATTERN: const {
    3: {'other': '\u00A4\u00A00\u00A0\u043C\u044F\u043D\u0433\u0430'},
    5: {'other': '\u00A4000\u00A0\u043C\u044F\u043D\u0433\u0430'},
    6: {'other': '\u00A40\u00A0\u0441\u0430\u044F'},
    9: {'other': '\u00A40\u00A0\u0442\u044D\u0440\u0431\u0443\u043C'},
    10: {'other': '\u00A4\u00A000\u00A0\u0442\u044D\u0440\u0431\u0443\u043C'},
    12: {
      'other': '\u00A4\u00A00\u00A0\u0438\u0445\u00A0\u043D\u0430\u044F\u0434'
    },
  }),
  // Compact number symbols for locale mr.
  "mr": new CompactNumberSymbols(COMPACT_DECIMAL_SHORT_PATTERN: const {
    3: {'other': '0\u00A0\u0939'},
    5: {'other': '0\u00A0\u0932\u093E\u0916'},
    7: {'other': '0\u00A0\u0915\u094B\u091F\u0940'},
    9: {'other': '0\u00A0\u0905\u092C\u094D\u091C'},
    11: {'other': '0\u00A0\u0916\u0930\u094D\u0935'},
    13: {'other': '0\u00A0\u092A\u0926\u094D\u092E'},
  }, COMPACT_DECIMAL_LONG_PATTERN: const {
    3: {'other': '0 \u0939\u091C\u093E\u0930'},
    5: {'other': '0 \u0932\u093E\u0916'},
    7: {'other': '0 \u0915\u094B\u091F\u0940'},
    9: {'other': '0 \u0905\u092C\u094D\u091C'},
    11: {'other': '0 \u0916\u0930\u094D\u0935'},
    13: {'other': '0 \u092A\u0926\u094D\u092E'},
  }, COMPACT_DECIMAL_SHORT_CURRENCY_PATTERN: const {
    3: {'other': '\u00A40\u00A0\u0939'},
    5: {'other': '\u00A40\u00A0\u0932\u093E\u0916'},
    7: {'other': '\u00A40\u00A0\u0915\u094B\u091F\u0940'},
    9: {'other': '\u00A40\u00A0\u0905\u092C\u094D\u091C'},
    11: {'other': '\u00A40\u00A0\u0916\u0930\u094D\u0935'},
    13: {'other': '\u00A40\u00A0\u092A\u0926\u094D\u092E'},
  }),
  // Compact number symbols for locale ms.
  "ms": new CompactNumberSymbols(COMPACT_DECIMAL_SHORT_PATTERN: const {
    3: {'other': '0K'},
    6: {'other': '0J'},
    9: {'other': '0B'},
    12: {'other': '0T'},
  }, COMPACT_DECIMAL_LONG_PATTERN: const {
    3: {'other': '0 ribu'},
    6: {'other': '0 juta'},
    9: {'other': '0 bilion'},
    12: {'other': '0 trilion'},
  }, COMPACT_DECIMAL_SHORT_CURRENCY_PATTERN: const {
    3: {'other': '\u00A40K'},
    6: {'other': '\u00A40J'},
    9: {'other': '\u00A40B'},
    12: {'other': '\u00A40T'},
  }),
  // Compact number symbols for locale mt.
  "mt": new CompactNumberSymbols(COMPACT_DECIMAL_SHORT_PATTERN: const {
    3: {'other': '0K'},
    6: {'other': '0M'},
    9: {'other': '0G'},
    12: {'other': '0T'},
  }, COMPACT_DECIMAL_SHORT_CURRENCY_PATTERN: const {
    3: {'other': '\u00A40K'},
    6: {'other': '\u00A40M'},
    9: {'other': '\u00A40G'},
    12: {'other': '\u00A40T'},
  }),
  // Compact number symbols for locale my.
  "my": new CompactNumberSymbols(COMPACT_DECIMAL_SHORT_PATTERN: const {
    3: {'other': '0\u00A0\u1011\u1031\u102C\u1004\u103A'},
    4: {'other': '0\u00A0\u101E\u1031\u102C\u1004\u103A\u1038'},
    5: {'other': '0\u00A0\u101E\u102D\u1014\u103A\u1038'},
    6: {'other': '0\u00A0\u101E\u1014\u103A\u1038'},
    7: {'other': '0\u00A0\u1000\u102F\u100B\u1031'},
    9: {'other': '000\u00A0\u100B\u1031'},
    10: {'other': '\u100B\u1031\u00A00\u00A0\u1011'},
    11: {'other': '\u100B\u1031\u00A00\u00A0\u101E'},
    12: {'other': '\u100B\u1031\u00A00\u00A0\u101E\u102D\u1014\u103A\u1038'},
    13: {'other': '\u100B\u1031\u00A00\u00A0\u101E\u1014\u103A\u1038'},
    14: {'other': '0\u00A0\u1000\u1031\u102C\u100B\u102D'},
  }, COMPACT_DECIMAL_LONG_PATTERN: const {
    3: {'other': '0 \u1011\u1031\u102C\u1004\u103A'},
    4: {'other': '0 \u101E\u1031\u102C\u1004\u103A\u1038'},
    5: {'other': '0 \u101E\u102D\u1014\u103A\u1038'},
    6: {'other': '0 \u101E\u1014\u103A\u1038'},
    7: {'other': '0 \u1000\u102F\u100B\u1031'},
    11: {
      'other': '\u1000\u102F\u100B\u1031 0 \u101E\u1031\u102C\u1004\u103A\u1038'
    },
    12: {'other': '\u1000\u102F\u100B\u1031 0 \u101E\u102D\u1014\u103A\u1038'},
    13: {'other': '\u1000\u102F\u100B\u1031 0 \u101E\u1014\u103A\u1038'},
    14: {'other': '0 \u1000\u1031\u102C\u100B\u102D'},
  }, COMPACT_DECIMAL_SHORT_CURRENCY_PATTERN: const {
    3: {'other': '\u00A4\u00A00\u00A0\u1011\u1031\u102C\u1004\u103A'},
    4: {'other': '\u00A4\u00A00\u00A0\u101E\u1031\u102C\u1004\u103A\u1038'},
    5: {'other': '\u00A4\u00A00\u00A0\u101E\u102D\u1014\u103A\u1038'},
    6: {'other': '\u00A4\u00A00\u00A0\u101E\u1014\u103A\u1038'},
    7: {'other': '\u00A4\u00A00\u00A0\u1000\u102F\u100B\u1031'},
    11: {
      'other':
          '\u00A4\u00A0\u1000\u102F\u100B\u1031\u00A00\u00A0\u101E\u1031\u102C\u1004\u103A\u1038'
    },
    12: {
      'other':
          '\u00A4\u00A0\u1000\u102F\u100B\u1031\u00A00\u00A0\u101E\u102D\u1014\u103A\u1038'
    },
    13: {
      'other':
          '\u00A4\u00A0\u1000\u102F\u100B\u1031\u00A00\u00A0\u101E\u1014\u103A\u1038'
    },
    14: {'other': '\u00A4\u00A00\u00A0\u1000\u1031\u102C\u100B\u102D'},
  }),
  // Compact number symbols for locale nb.
  "nb": new CompactNumberSymbols(COMPACT_DECIMAL_SHORT_PATTERN: const {
    3: {'other': '0k'},
    6: {'other': '0\u00A0mill.'},
    9: {'other': '0\u00A0mrd.'},
    12: {'other': '0\u00A0bill.'},
  }, COMPACT_DECIMAL_LONG_PATTERN: const {
    3: {'other': '0 tusen'},
    6: {
      'one': '0 million',
      'other': '0 millioner',
    },
    7: {'other': '00 millioner'},
    9: {
      'one': '0 milliard',
      'other': '0 milliarder',
    },
    10: {'other': '00 milliarder'},
    12: {
      'one': '0 billion',
      'other': '0 billioner',
    },
    13: {'other': '00 billioner'},
  }, COMPACT_DECIMAL_SHORT_CURRENCY_PATTERN: const {
    3: {'other': '\u00A4\u00A00k'},
    6: {'other': '\u00A4\u00A00\u00A0mill.'},
    9: {'other': '\u00A4\u00A00\u00A0mrd.'},
    12: {'other': '\u00A4\u00A00\u00A0bill.'},
  }),
  // Compact number symbols for locale ne.
  "ne": new CompactNumberSymbols(COMPACT_DECIMAL_SHORT_PATTERN: const {
    3: {'other': '0\u00A0\u0939\u091C\u093E\u0930'},
    5: {'other': '0\u00A0\u0932\u093E\u0916'},
    7: {'other': '0\u00A0\u0915\u0930\u094B\u0921'},
    9: {'other': '0\u00A0\u0905\u0930\u092C'},
    11: {'other': '0\u00A0\u0916\u0930\u092C'},
    13: {'other': '0\u00A0\u0936\u0902\u0916'},
  }, COMPACT_DECIMAL_LONG_PATTERN: const {
    3: {'other': '0 \u0939\u091C\u093E\u0930'},
    5: {'other': '0 \u0932\u093E\u0916'},
    6: {'other': '0 \u0915\u0930\u094B\u0921'},
    9: {'other': '0 \u0905\u0930\u092C'},
    12: {'other': '00 \u0916\u0930\u092C'},
    13: {'other': '0 \u0936\u0902\u0916'},
  }, COMPACT_DECIMAL_SHORT_CURRENCY_PATTERN: const {
    3: {'other': '\u00A4\u00A00\u00A0\u0939\u091C\u093E\u0930'},
    5: {'other': '\u00A4\u00A00\u00A0\u0932\u093E\u0916'},
    7: {'other': '\u00A4\u00A00\u00A0\u0915\u0930\u094B\u0921'},
    9: {'other': '\u00A4\u00A00\u00A0\u0905\u0930\u092C'},
    11: {'other': '\u00A4\u00A00\u00A0\u0916\u0930\u092C'},
    13: {'other': '\u00A4\u00A00\u00A0\u0936\u0902\u0916'},
  }),
  // Compact number symbols for locale nl.
  "nl": new CompactNumberSymbols(COMPACT_DECIMAL_SHORT_PATTERN: const {
    3: {'other': '0K'},
    6: {'other': '0\u00A0mln.'},
    9: {'other': '0\u00A0mld.'},
    12: {'other': '0\u00A0bln.'},
  }, COMPACT_DECIMAL_LONG_PATTERN: const {
    3: {'other': '0 duizend'},
    6: {'other': '0 miljoen'},
    9: {'other': '0 miljard'},
    12: {'other': '0 biljoen'},
  }, COMPACT_DECIMAL_SHORT_CURRENCY_PATTERN: const {
    3: {'other': '\u00A4\u00A00K'},
    6: {'other': '\u00A4\u00A00\u00A0mln.'},
    9: {'other': '\u00A4\u00A00\u00A0mld.'},
    12: {'other': '\u00A4\u00A00\u00A0bln.'},
  }),
  // Compact number symbols for locale no.
  "no": new CompactNumberSymbols(COMPACT_DECIMAL_SHORT_PATTERN: const {
    3: {'other': '0k'},
    6: {'other': '0\u00A0mill.'},
    9: {'other': '0\u00A0mrd.'},
    12: {'other': '0\u00A0bill.'},
  }, COMPACT_DECIMAL_LONG_PATTERN: const {
    3: {'other': '0 tusen'},
    6: {
      'one': '0 million',
      'other': '0 millioner',
    },
    7: {'other': '00 millioner'},
    9: {
      'one': '0 milliard',
      'other': '0 milliarder',
    },
    10: {'other': '00 milliarder'},
    12: {
      'one': '0 billion',
      'other': '0 billioner',
    },
    13: {'other': '00 billioner'},
  }, COMPACT_DECIMAL_SHORT_CURRENCY_PATTERN: const {
    3: {'other': '\u00A4\u00A00k'},
    6: {'other': '\u00A4\u00A00\u00A0mill.'},
    9: {'other': '\u00A4\u00A00\u00A0mrd.'},
    12: {'other': '\u00A4\u00A00\u00A0bill.'},
  }),
  // Compact number symbols for locale no_NO.
  "no_NO": new CompactNumberSymbols(COMPACT_DECIMAL_SHORT_PATTERN: const {
    3: {'other': '0k'},
    6: {'other': '0\u00A0mill.'},
    9: {'other': '0\u00A0mrd.'},
    12: {'other': '0\u00A0bill.'},
  }, COMPACT_DECIMAL_LONG_PATTERN: const {
    3: {'other': '0 tusen'},
    6: {
      'one': '0 million',
      'other': '0 millioner',
    },
    7: {'other': '00 millioner'},
    9: {
      'one': '0 milliard',
      'other': '0 milliarder',
    },
    10: {'other': '00 milliarder'},
    12: {
      'one': '0 billion',
      'other': '0 billioner',
    },
    13: {'other': '00 billioner'},
  }, COMPACT_DECIMAL_SHORT_CURRENCY_PATTERN: const {
    3: {'other': '\u00A4\u00A00k'},
    6: {'other': '\u00A4\u00A00\u00A0mill.'},
    9: {'other': '\u00A4\u00A00\u00A0mrd.'},
    12: {'other': '\u00A4\u00A00\u00A0bill.'},
  }),
  // Compact number symbols for locale nyn.
  "nyn": new CompactNumberSymbols(COMPACT_DECIMAL_SHORT_PATTERN: const {
    3: {'other': '0K'},
    6: {'other': '0M'},
    9: {'other': '0G'},
    12: {'other': '0T'},
  }, COMPACT_DECIMAL_SHORT_CURRENCY_PATTERN: const {
    3: {'other': '\u00A40K'},
    6: {'other': '\u00A40M'},
    9: {'other': '\u00A40G'},
    12: {'other': '\u00A40T'},
  }),
  // Compact number symbols for locale or.
  "or": new CompactNumberSymbols(COMPACT_DECIMAL_SHORT_PATTERN: const {
    3: {'other': '0\u0B39'},
    6: {'other': '0\u0B28\u0B3F'},
    9: {'other': '0\u0B2C\u0B3F'},
    12: {'other': '0\u0B1F\u0B4D\u0B30\u0B3F'},
  }, COMPACT_DECIMAL_LONG_PATTERN: const {
    3: {'other': '0 \u0B39\u0B1C\u0B3E\u0B30'},
    6: {'other': '0 \u0B28\u0B3F\u0B5F\u0B41\u0B24'},
    9: {'other': '0 \u0B36\u0B39\u0B15\u0B4B\u0B1F\u0B3F'},
    12: {'other': '0 \u0B32\u0B15\u0B4D\u0B37\u0B15\u0B4B\u0B1F\u0B3F'},
  }, COMPACT_DECIMAL_SHORT_CURRENCY_PATTERN: const {
    3: {'other': '\u00A40\u0B39'},
    6: {'other': '\u00A40\u0B28\u0B3F'},
    9: {'other': '\u00A40\u0B2C\u0B3F'},
    12: {'other': '\u00A40\u0B1F\u0B4D\u0B30\u0B3F'},
  }),
  // Compact number symbols for locale pa.
  "pa": new CompactNumberSymbols(COMPACT_DECIMAL_SHORT_PATTERN: const {
    3: {'other': '0\u00A0\u0A39\u0A1C\u0A3C\u0A3E\u0A30'},
    5: {'other': '0\u00A0\u0A32\u0A71\u0A16'},
    7: {'other': '0\u00A0\u0A15\u0A30\u0A4B\u0A5C'},
    9: {'other': '0\u00A0\u0A05\u0A30\u0A2C'},
    11: {'other': '0\u00A0\u0A16\u0A30\u0A2C'},
    13: {'other': '0\u00A0\u0A28\u0A40\u0A32'},
  }, COMPACT_DECIMAL_LONG_PATTERN: const {
    3: {'other': '0 \u0A39\u0A1C\u0A3C\u0A3E\u0A30'},
    5: {'other': '0 \u0A32\u0A71\u0A16'},
    7: {'other': '0 \u0A15\u0A30\u0A4B\u0A5C'},
    9: {'other': '0 \u0A05\u0A30\u0A2C'},
    11: {'other': '0 \u0A16\u0A30\u0A2C'},
    13: {'other': '0 \u0A28\u0A40\u0A32'},
  }, COMPACT_DECIMAL_SHORT_CURRENCY_PATTERN: const {
    3: {'other': '\u00A4\u00A00\u00A0\u0A39\u0A1C\u0A3C\u0A3E\u0A30'},
    5: {'other': '\u00A4\u00A00\u00A0\u0A32\u0A71\u0A16'},
    7: {'other': '\u00A4\u00A00\u00A0\u0A15\u0A30\u0A4B\u0A5C'},
    9: {'other': '\u00A4\u00A00\u00A0\u0A05\u0A30\u0A2C'},
    11: {'other': '\u00A4\u00A00\u00A0\u0A16\u0A30\u0A2C'},
    13: {'other': '\u00A4\u00A00\u00A0\u0A28\u0A40\u0A32'},
  }),
  // Compact number symbols for locale pl.
  "pl": new CompactNumberSymbols(COMPACT_DECIMAL_SHORT_PATTERN: const {
    3: {'other': '0\u00A0tys.'},
    6: {'other': '0\u00A0mln'},
    9: {'other': '0\u00A0mld'},
    12: {'other': '0\u00A0bln'},
  }, COMPACT_DECIMAL_LONG_PATTERN: const {
    3: {
      'few': '0 tysi\u0105ce',
      'many': '0 tysi\u0119cy',
      'one': '0 tysi\u0105c',
      'other': '0 tysi\u0105ca',
    },
    6: {
      'few': '0 miliony',
      'many': '0 milion\u00F3w',
      'one': '0 milion',
      'other': '0 miliona',
    },
    9: {
      'few': '0 miliardy',
      'many': '0 miliard\u00F3w',
      'one': '0 miliard',
      'other': '0 miliarda',
    },
    12: {
      'few': '0 biliony',
      'many': '0 bilion\u00F3w',
      'one': '0 bilion',
      'other': '0 biliona',
    },
  }, COMPACT_DECIMAL_SHORT_CURRENCY_PATTERN: const {
    3: {'other': '0\u00A0tys.\u00A0\u00A4'},
    6: {'other': '0\u00A0mln\u00A0\u00A4'},
    9: {'other': '0\u00A0mld\u00A0\u00A4'},
    12: {'other': '0\u00A0bln\u00A0\u00A4'},
  }),
  // Compact number symbols for locale ps.
  "ps": new CompactNumberSymbols(COMPACT_DECIMAL_SHORT_PATTERN: const {
    3: {'other': '0K'},
    6: {'other': '0M'},
    9: {'other': '0B'},
    11: {
      'one': '000G',
      'other': '000B',
    },
    12: {'other': '0T'},
  }, COMPACT_DECIMAL_LONG_PATTERN: const {
    9: {'other': '0G'},
  }, COMPACT_DECIMAL_SHORT_CURRENCY_PATTERN: const {
    3: {'other': '0K\u00A0\u00A4'},
    6: {'other': '0M\u00A0\u00A4'},
    9: {'other': '0G\u00A0\u00A4'},
    10: {
      'one': '00G\u00A0\u00A4',
      'other': '\u00A400B',
    },
    11: {'other': '\u00A4000B'},
    12: {'other': '0T\u00A0\u00A4'},
  }),
  // Compact number symbols for locale pt.
  "pt": new CompactNumberSymbols(COMPACT_DECIMAL_SHORT_PATTERN: const {
    3: {'other': '0\u00A0mil'},
    6: {'other': '0\u00A0mi'},
    9: {'other': '0\u00A0bi'},
    12: {'other': '0\u00A0tri'},
  }, COMPACT_DECIMAL_LONG_PATTERN: const {
    3: {'other': '0 mil'},
    6: {
      'one': '0 milh\u00E3o',
      'other': '0 milh\u00F5es',
    },
    9: {
      'one': '0 bilh\u00E3o',
      'other': '0 bilh\u00F5es',
    },
    12: {
      'one': '0 trilh\u00E3o',
      'other': '0 trilh\u00F5es',
    },
  }, COMPACT_DECIMAL_SHORT_CURRENCY_PATTERN: const {
    3: {'other': '\u00A4\u00A00\u00A0mil'},
    6: {'other': '\u00A4\u00A00\u00A0mi'},
    9: {'other': '\u00A4\u00A00\u00A0bi'},
    12: {'other': '\u00A4\u00A00\u00A0tri'},
  }),
  // Compact number symbols for locale pt_BR.
  "pt_BR": new CompactNumberSymbols(COMPACT_DECIMAL_SHORT_PATTERN: const {
    3: {'other': '0\u00A0mil'},
    6: {'other': '0\u00A0mi'},
    9: {'other': '0\u00A0bi'},
    12: {'other': '0\u00A0tri'},
  }, COMPACT_DECIMAL_LONG_PATTERN: const {
    3: {'other': '0 mil'},
    6: {
      'one': '0 milh\u00E3o',
      'other': '0 milh\u00F5es',
    },
    9: {
      'one': '0 bilh\u00E3o',
      'other': '0 bilh\u00F5es',
    },
    12: {
      'one': '0 trilh\u00E3o',
      'other': '0 trilh\u00F5es',
    },
  }, COMPACT_DECIMAL_SHORT_CURRENCY_PATTERN: const {
    3: {'other': '\u00A4\u00A00\u00A0mil'},
    6: {'other': '\u00A4\u00A00\u00A0mi'},
    9: {'other': '\u00A4\u00A00\u00A0bi'},
    12: {'other': '\u00A4\u00A00\u00A0tri'},
  }),
  // Compact number symbols for locale pt_PT.
  "pt_PT": new CompactNumberSymbols(COMPACT_DECIMAL_SHORT_PATTERN: const {
    3: {'other': '0\u00A0mil'},
    6: {'other': '0\u00A0M'},
    9: {'other': '0\u00A0mM'},
    12: {'other': '0\u00A0Bi'},
  }, COMPACT_DECIMAL_LONG_PATTERN: const {
    3: {'other': '0 mil'},
    6: {
      'one': '0 milh\u00E3o',
      'other': '0 milh\u00F5es',
    },
    7: {'other': '00 milh\u00F5es'},
    9: {'other': '0 mil milh\u00F5es'},
    12: {
      'one': '0 bili\u00E3o',
      'other': '0 bili\u00F5es',
    },
    13: {'other': '00 bili\u00F5es'},
  }, COMPACT_DECIMAL_SHORT_CURRENCY_PATTERN: const {
    3: {'other': '0\u00A0mil\u00A0\u00A4'},
    6: {'other': '0\u00A0M\u00A0\u00A4'},
    9: {'other': '0\u00A0mM\u00A0\u00A4'},
    12: {'other': '0\u00A0B\u00A0\u00A4'},
  }),
  // Compact number symbols for locale ro.
  "ro": new CompactNumberSymbols(COMPACT_DECIMAL_SHORT_PATTERN: const {
    3: {'other': '0\u00A0K'},
    6: {'other': '0\u00A0mil.'},
    9: {'other': '0\u00A0mld.'},
    12: {'other': '0\u00A0tril.'},
  }, COMPACT_DECIMAL_LONG_PATTERN: const {
    3: {
      'few': '0 mii',
      'one': '0 mie',
      'other': '0 de mii',
    },
    6: {
      'few': '0 milioane',
      'one': '0 milion',
      'other': '0 de milioane',
    },
    9: {
      'few': '0 miliarde',
      'one': '0 miliard',
      'other': '0 de miliarde',
    },
    12: {
      'few': '0 trilioane',
      'one': '0 trilion',
      'other': '0 de trilioane',
    },
  }, COMPACT_DECIMAL_SHORT_CURRENCY_PATTERN: const {
    3: {
      'few': '0\u00A0mii\u00A0\u00A4',
      'one': '0\u00A0mie\u00A0\u00A4',
      'other': '0\u00A0mii\u00A0\u00A4',
    },
    4: {'other': '00\u00A0mii\u00A0\u00A4'},
    6: {'other': '0\u00A0mil.\u00A0\u00A4'},
    9: {'other': '0\u00A0mld.\u00A0\u00A4'},
    12: {'other': '0\u00A0tril.\u00A0\u00A4'},
  }),
  // Compact number symbols for locale ru.
  "ru": new CompactNumberSymbols(COMPACT_DECIMAL_SHORT_PATTERN: const {
    3: {'other': '0\u00A0\u0442\u044B\u0441.'},
    6: {'other': '0\u00A0\u043C\u043B\u043D'},
    9: {'other': '0\u00A0\u043C\u043B\u0440\u0434'},
    12: {'other': '0\u00A0\u0442\u0440\u043B\u043D'},
  }, COMPACT_DECIMAL_LONG_PATTERN: const {
    3: {
      'few': '0 \u0442\u044B\u0441\u044F\u0447\u0438',
      'many': '0 \u0442\u044B\u0441\u044F\u0447',
      'one': '0 \u0442\u044B\u0441\u044F\u0447\u0430',
      'other': '0 \u0442\u044B\u0441\u044F\u0447\u0438',
    },
    6: {
      'few': '0 \u043C\u0438\u043B\u043B\u0438\u043E\u043D\u0430',
      'many': '0 \u043C\u0438\u043B\u043B\u0438\u043E\u043D\u043E\u0432',
      'one': '0 \u043C\u0438\u043B\u043B\u0438\u043E\u043D',
      'other': '0 \u043C\u0438\u043B\u043B\u0438\u043E\u043D\u0430',
    },
    9: {
      'few': '0 \u043C\u0438\u043B\u043B\u0438\u0430\u0440\u0434\u0430',
      'many': '0 \u043C\u0438\u043B\u043B\u0438\u0430\u0440\u0434\u043E\u0432',
      'one': '0 \u043C\u0438\u043B\u043B\u0438\u0430\u0440\u0434',
      'other': '0 \u043C\u0438\u043B\u043B\u0438\u0430\u0440\u0434\u0430',
    },
    12: {
      'few': '0 \u0442\u0440\u0438\u043B\u043B\u0438\u043E\u043D\u0430',
      'many': '0 \u0442\u0440\u0438\u043B\u043B\u0438\u043E\u043D\u043E\u0432',
      'one': '0 \u0442\u0440\u0438\u043B\u043B\u0438\u043E\u043D',
      'other': '0 \u0442\u0440\u0438\u043B\u043B\u0438\u043E\u043D\u0430',
    },
  }, COMPACT_DECIMAL_SHORT_CURRENCY_PATTERN: const {
    3: {'other': '0\u00A0\u0442\u044B\u0441.\u00A0\u00A4'},
    6: {'other': '0\u00A0\u043C\u043B\u043D\u00A0\u00A4'},
    9: {'other': '0\u00A0\u043C\u043B\u0440\u0434\u00A0\u00A4'},
    12: {'other': '0\u00A0\u0442\u0440\u043B\u043D\u00A0\u00A4'},
  }),
  // Compact number symbols for locale si.
  "si": new CompactNumberSymbols(COMPACT_DECIMAL_SHORT_PATTERN: const {
    3: {'other': '\u0DAF0'},
    6: {'other': '\u0DB8\u0DD20'},
    9: {'other': '\u0DB6\u0DD20'},
    12: {'other': '\u0DA7\u0DCA\u200D\u0DBB\u0DD20'},
  }, COMPACT_DECIMAL_LONG_PATTERN: const {
    3: {'other': '\u0DAF\u0DC4\u0DC3 0'},
    6: {'other': '\u0DB8\u0DD2\u0DBD\u0DD2\u0DBA\u0DB1 0'},
    9: {'other': '\u0DB6\u0DD2\u0DBD\u0DD2\u0DBA\u0DB1 0'},
    12: {'other': '\u0DA7\u0DCA\u200D\u0DBB\u0DD2\u0DBD\u0DD2\u0DBA\u0DB1 0'},
  }, COMPACT_DECIMAL_SHORT_CURRENCY_PATTERN: const {
    3: {'other': '\u00A4\u0DAF0'},
    6: {'other': '\u00A4\u0DB8\u0DD20'},
    9: {'other': '\u00A4\u0DB6\u0DD20'},
    12: {'other': '\u00A4\u0DA7\u0DCA\u200D\u0DBB\u0DD20'},
  }),
  // Compact number symbols for locale sk.
  "sk": new CompactNumberSymbols(COMPACT_DECIMAL_SHORT_PATTERN: const {
    3: {'other': '0\u00A0tis.'},
    6: {'other': '0\u00A0mil.'},
    9: {'other': '0\u00A0mld.'},
    12: {'other': '0\u00A0bil.'},
  }, COMPACT_DECIMAL_LONG_PATTERN: const {
    3: {
      'few': '0 tis\u00EDce',
      'many': '0 tis\u00EDca',
      'one': '0 tis\u00EDc',
      'other': '0 tis\u00EDc',
    },
    4: {
      'few': '00 tis\u00EDc',
      'many': '00 tis\u00EDca',
      'one': '00 tis\u00EDc',
      'other': '00 tis\u00EDc',
    },
    6: {
      'few': '0 mili\u00F3ny',
      'many': '0 mili\u00F3na',
      'one': '0 mili\u00F3n',
      'other': '0 mili\u00F3nov',
    },
    7: {
      'few': '00 mili\u00F3nov',
      'many': '00 mili\u00F3na',
      'one': '00 mili\u00F3nov',
      'other': '00 mili\u00F3nov',
    },
    9: {
      'few': '0 miliardy',
      'many': '0 miliardy',
      'one': '0 miliarda',
      'other': '0 mili\u00E1rd',
    },
    10: {
      'few': '00 mili\u00E1rd',
      'many': '00 miliardy',
      'one': '00 mili\u00E1rd',
      'other': '00 mili\u00E1rd',
    },
    12: {
      'few': '0 bili\u00F3ny',
      'many': '0 bili\u00F3na',
      'one': '0 bili\u00F3n',
      'other': '0 bili\u00F3nov',
    },
    13: {
      'few': '00 bili\u00F3nov',
      'many': '00 bili\u00F3na',
      'one': '00 bili\u00F3nov',
      'other': '00 bili\u00F3nov',
    },
  }, COMPACT_DECIMAL_SHORT_CURRENCY_PATTERN: const {
    3: {'other': '0\u00A0tis.\u00A0\u00A4'},
    6: {'other': '0\u00A0mil.\u00A0\u00A4'},
    9: {'other': '0\u00A0mld.\u00A0\u00A4'},
    12: {'other': '0\u00A0bil.\u00A0\u00A4'},
  }),
  // Compact number symbols for locale sl.
  "sl": new CompactNumberSymbols(COMPACT_DECIMAL_SHORT_PATTERN: const {
    3: {'other': '0\u00A0tis.'},
    6: {'other': '0\u00A0mio.'},
    9: {'other': '0\u00A0mrd.'},
    12: {'other': '0\u00A0bil.'},
  }, COMPACT_DECIMAL_LONG_PATTERN: const {
    3: {'other': '0 tiso\u010D'},
    6: {
      'few': '0 milijone',
      'one': '0 milijon',
      'other': '0 milijonov',
      'two': '0 milijona',
    },
    7: {
      'few': '00 milijoni',
      'one': '00 milijon',
      'other': '00 milijonov',
      'two': '00 milijona',
    },
    9: {
      'few': '0 milijarde',
      'one': '0 milijarda',
      'other': '0 milijard',
      'two': '0 milijardi',
    },
    12: {
      'few': '0 bilijoni',
      'one': '0 bilijon',
      'other': '0 bilijonov',
      'two': '0 bilijona',
    },
  }, COMPACT_DECIMAL_SHORT_CURRENCY_PATTERN: const {
    3: {'other': '0\u00A0tis.\u00A0\u00A4'},
    6: {'other': '0\u00A0mio.\u00A0\u00A4'},
    9: {'other': '0\u00A0mrd.\u00A0\u00A4'},
    12: {'other': '0\u00A0bil.\u00A0\u00A4'},
  }),
  // Compact number symbols for locale sq.
  "sq": new CompactNumberSymbols(COMPACT_DECIMAL_SHORT_PATTERN: const {
    3: {'other': '0\u00A0mij\u00EB'},
    6: {'other': '0\u00A0mln'},
    9: {'other': '0\u00A0mld'},
    12: {'other': '0\u00A0bln'},
  }, COMPACT_DECIMAL_LONG_PATTERN: const {
    3: {'other': '0 mij\u00EB'},
    6: {'other': '0 milion'},
    9: {'other': '0 miliard'},
    12: {'other': '0 bilion'},
  }, COMPACT_DECIMAL_SHORT_CURRENCY_PATTERN: const {
    3: {'other': '0\u00A0mij\u00EB\u00A0\u00A4'},
    6: {'other': '0\u00A0mln\u00A0\u00A4'},
    9: {'other': '0\u00A0mld\u00A0\u00A4'},
    12: {'other': '0\u00A0bln\u00A0\u00A4'},
  }),
  // Compact number symbols for locale sr.
  "sr": new CompactNumberSymbols(COMPACT_DECIMAL_SHORT_PATTERN: const {
    3: {'other': '0\u00A0\u0445\u0438\u0459.'},
    6: {'other': '0\u00A0\u043C\u0438\u043B.'},
    9: {'other': '0\u00A0\u043C\u043B\u0440\u0434.'},
    12: {'other': '0\u00A0\u0431\u0438\u043B.'},
  }, COMPACT_DECIMAL_LONG_PATTERN: const {
    3: {
      'few': '0 \u0445\u0438\u0459\u0430\u0434\u0435',
      'one': '0 \u0445\u0438\u0459\u0430\u0434\u0430',
      'other': '0 \u0445\u0438\u0459\u0430\u0434\u0430',
    },
    6: {
      'few': '0 \u043C\u0438\u043B\u0438\u043E\u043D\u0430',
      'one': '0 \u043C\u0438\u043B\u0438\u043E\u043D',
      'other': '0 \u043C\u0438\u043B\u0438\u043E\u043D\u0430',
    },
    9: {
      'few': '0 \u043C\u0438\u043B\u0438\u0458\u0430\u0440\u0434\u0435',
      'one': '0 \u043C\u0438\u043B\u0438\u0458\u0430\u0440\u0434\u0430',
      'other': '0 \u043C\u0438\u043B\u0438\u0458\u0430\u0440\u0434\u0438',
    },
    12: {
      'few': '0 \u0431\u0438\u043B\u0438\u043E\u043D\u0430',
      'one': '0 \u0431\u0438\u043B\u0438\u043E\u043D',
      'other': '0 \u0431\u0438\u043B\u0438\u043E\u043D\u0430',
    },
  }, COMPACT_DECIMAL_SHORT_CURRENCY_PATTERN: const {
    3: {'other': '0\u00A0\u0445\u0438\u0459.\u00A0\u00A4'},
    6: {'other': '0\u00A0\u043C\u0438\u043B.\u00A0\u00A4'},
    9: {'other': '0\u00A0\u043C\u043B\u0440\u0434.\u00A0\u00A4'},
    12: {'other': '0\u00A0\u0431\u0438\u043B.\u00A0\u00A4'},
  }),
  // Compact number symbols for locale sr_Latn.
  "sr_Latn": new CompactNumberSymbols(COMPACT_DECIMAL_SHORT_PATTERN: const {
    3: {'other': '0\u00A0hilj.'},
    6: {'other': '0\u00A0mil.'},
    9: {'other': '0\u00A0mlrd.'},
    12: {'other': '0\u00A0bil.'},
  }, COMPACT_DECIMAL_LONG_PATTERN: const {
    3: {
      'few': '0 hiljade',
      'one': '0 hiljada',
      'other': '0 hiljada',
    },
    6: {
      'few': '0 miliona',
      'one': '0 milion',
      'other': '0 miliona',
    },
    9: {
      'few': '0 milijarde',
      'one': '0 milijarda',
      'other': '0 milijardi',
    },
    12: {
      'few': '0 biliona',
      'one': '0 bilion',
      'other': '0 biliona',
    },
  }, COMPACT_DECIMAL_SHORT_CURRENCY_PATTERN: const {
    3: {'other': '0\u00A0hilj.\u00A0\u00A4'},
    6: {'other': '0\u00A0mil.\u00A0\u00A4'},
    9: {'other': '0\u00A0mlrd.\u00A0\u00A4'},
    12: {'other': '0\u00A0bil.\u00A0\u00A4'},
  }),
  // Compact number symbols for locale sv.
  "sv": new CompactNumberSymbols(COMPACT_DECIMAL_SHORT_PATTERN: const {
    3: {'other': '0\u00A0tn'},
    6: {'other': '0\u00A0mn'},
    9: {'other': '0\u00A0md'},
    12: {'other': '0\u00A0bn'},
  }, COMPACT_DECIMAL_LONG_PATTERN: const {
    3: {'other': '0 tusen'},
    6: {
      'one': '0 miljon',
      'other': '0 miljoner',
    },
    8: {'other': '000 miljoner'},
    9: {
      'one': '0 miljard',
      'other': '0 miljarder',
    },
    10: {'other': '00 miljarder'},
    12: {
      'one': '0 biljon',
      'other': '0 biljoner',
    },
    13: {'other': '00 biljoner'},
  }, COMPACT_DECIMAL_SHORT_CURRENCY_PATTERN: const {
    3: {'other': '0\u00A0tn\u00A0\u00A4'},
    6: {'other': '0\u00A0mn\u00A0\u00A4'},
    9: {'other': '0\u00A0md\u00A0\u00A4'},
    12: {'other': '0\u00A0bn\u00A0\u00A4'},
  }),
  // Compact number symbols for locale sw.
  "sw": new CompactNumberSymbols(COMPACT_DECIMAL_SHORT_PATTERN: const {
    3: {'other': 'elfu\u00A00;elfu\u00A0-0'},
    6: {
      'one': '0M;-0M',
      'other': '0M',
    },
    9: {'other': '0B;-0B'},
    12: {
      'one': '0T;-0T',
      'other': '0T',
    },
  }, COMPACT_DECIMAL_LONG_PATTERN: const {
    3: {'other': 'elfu 0;elfu -0'},
    6: {'other': 'milioni 0;milioni -0'},
    9: {'other': 'bilioni 0;bilioni -0'},
    12: {'other': 'trilioni 0;trilioni -0'},
  }, COMPACT_DECIMAL_SHORT_CURRENCY_PATTERN: const {
    3: {'other': '\u00A4\u00A0elfu0'},
    4: {'other': '\u00A4\u00A0elfu00;\u00A4elfu\u00A0-00'},
    5: {'other': '\u00A4\u00A0laki000;\u00A4laki\u00A0-000'},
    6: {
      'one': '\u00A4\u00A00M;\u00A4-0M',
      'other': '\u00A4\u00A00M',
    },
    7: {
      'one': '\u00A4\u00A000M;\u00A4M-00M',
      'other': '\u00A4\u00A000M;\u00A4-00M',
    },
    8: {
      'one': '\u00A4\u00A0000M;\u00A4Milioni-000',
      'other': '\u00A4\u00A0000M',
    },
    9: {'other': '\u00A4\u00A00B;\u00A4-0B'},
    12: {
      'one': '\u00A4\u00A00T;\u00A4-0T',
      'other': '\u00A4\u00A00T',
    },
    14: {'other': '\u00A4\u00A0000T;\u00A4-000T'},
  }),
  // Compact number symbols for locale ta.
  "ta": new CompactNumberSymbols(COMPACT_DECIMAL_SHORT_PATTERN: const {
    3: {'other': '0\u0B86'},
    6: {'other': '0\u0BAE\u0BBF'},
    9: {'other': '0\u0BAA\u0BBF'},
    12: {'other': '0\u0B9F\u0BBF'},
  }, COMPACT_DECIMAL_LONG_PATTERN: const {
    3: {'other': '0 \u0B86\u0BAF\u0BBF\u0BB0\u0BAE\u0BCD'},
    6: {'other': '0 \u0BAE\u0BBF\u0BB2\u0BCD\u0BB2\u0BBF\u0BAF\u0BA9\u0BCD'},
    9: {'other': '0 \u0BAA\u0BBF\u0BB2\u0BCD\u0BB2\u0BBF\u0BAF\u0BA9\u0BCD'},
    12: {
      'other':
          '0 \u0B9F\u0BBF\u0BB0\u0BBF\u0BB2\u0BCD\u0BB2\u0BBF\u0BAF\u0BA9\u0BCD'
    },
  }, COMPACT_DECIMAL_SHORT_CURRENCY_PATTERN: const {
    3: {'other': '\u00A4\u00A00\u0B86'},
    6: {'other': '\u00A4\u00A00\u0BAE\u0BBF'},
    9: {
      'one': '\u00A4\u00A00\u0BAA\u0BBF',
      'other': '\u00A40\u0BAA\u0BBF',
    },
    10: {'other': '\u00A4\u00A000\u0BAA\u0BBF'},
    11: {
      'one': '\u00A4\u00A0000\u0BAA\u0BBF',
      'other': '\u00A4000\u0BAA\u0BBF',
    },
    12: {'other': '\u00A4\u00A00\u0B9F\u0BBF'},
  }),
  // Compact number symbols for locale te.
  "te": new CompactNumberSymbols(COMPACT_DECIMAL_SHORT_PATTERN: const {
    3: {'other': '0\u0C35\u0C47'},
    6: {'other': '0\u0C2E\u0C3F'},
    9: {'other': '0\u0C2C\u0C3F'},
    12: {'other': '0\u0C1F\u0C4D\u0C30\u0C3F'},
  }, COMPACT_DECIMAL_LONG_PATTERN: const {
    3: {
      'one': '0 \u0C35\u0C47\u0C2F\u0C3F',
      'other': '0 \u0C35\u0C47\u0C32\u0C41',
    },
    4: {'other': '00 \u0C35\u0C47\u0C32\u0C41'},
    6: {
      'one': '0 \u0C2E\u0C3F\u0C32\u0C3F\u0C2F\u0C28\u0C4D',
      'other': '0 \u0C2E\u0C3F\u0C32\u0C3F\u0C2F\u0C28\u0C4D\u0C32\u0C41',
    },
    7: {'other': '00 \u0C2E\u0C3F\u0C32\u0C3F\u0C2F\u0C28\u0C4D\u0C32\u0C41'},
    9: {
      'one': '0 \u0C2C\u0C3F\u0C32\u0C3F\u0C2F\u0C28\u0C4D',
      'other': '0 \u0C2C\u0C3F\u0C32\u0C3F\u0C2F\u0C28\u0C4D\u0C32\u0C41',
    },
    10: {'other': '00 \u0C2C\u0C3F\u0C32\u0C3F\u0C2F\u0C28\u0C4D\u0C32\u0C41'},
    12: {
      'one': '0 \u0C1F\u0C4D\u0C30\u0C3F\u0C32\u0C3F\u0C2F\u0C28\u0C4D',
      'other':
          '0 \u0C1F\u0C4D\u0C30\u0C3F\u0C32\u0C3F\u0C2F\u0C28\u0C4D\u0C32\u0C41',
    },
    13: {
      'other':
          '00 \u0C1F\u0C4D\u0C30\u0C3F\u0C32\u0C3F\u0C2F\u0C28\u0C4D\u0C32\u0C41'
    },
  }, COMPACT_DECIMAL_SHORT_CURRENCY_PATTERN: const {
    3: {'other': '\u00A40\u0C35\u0C47'},
    6: {'other': '\u00A40\u0C2E\u0C3F'},
    9: {'other': '\u00A40\u0C2C\u0C3F'},
    12: {'other': '\u00A40\u0C1F\u0C4D\u0C30\u0C3F'},
  }),
  // Compact number symbols for locale th.
  "th": new CompactNumberSymbols(COMPACT_DECIMAL_SHORT_PATTERN: const {
    3: {'other': '0K'},
    6: {'other': '0M'},
    9: {'other': '0B'},
    12: {'other': '0T'},
  }, COMPACT_DECIMAL_LONG_PATTERN: const {
    3: {'other': '0 \u0E1E\u0E31\u0E19'},
    4: {'other': '0 \u0E2B\u0E21\u0E37\u0E48\u0E19'},
    5: {'other': '0 \u0E41\u0E2A\u0E19'},
    6: {'other': '0 \u0E25\u0E49\u0E32\u0E19'},
    9: {'other': '0 \u0E1E\u0E31\u0E19\u0E25\u0E49\u0E32\u0E19'},
    10: {'other': '0 \u0E2B\u0E21\u0E37\u0E48\u0E19\u0E25\u0E49\u0E32\u0E19'},
    11: {'other': '0 \u0E41\u0E2A\u0E19\u0E25\u0E49\u0E32\u0E19'},
    12: {'other': '0 \u0E25\u0E49\u0E32\u0E19\u0E25\u0E49\u0E32\u0E19'},
  }, COMPACT_DECIMAL_SHORT_CURRENCY_PATTERN: const {
    3: {'other': '\u00A40K'},
    6: {'other': '\u00A40M'},
    9: {'other': '\u00A40B'},
    12: {'other': '\u00A40T'},
  }),
  // Compact number symbols for locale tl.
  "tl": new CompactNumberSymbols(COMPACT_DECIMAL_SHORT_PATTERN: const {
    3: {'other': '0K'},
    6: {'other': '0M'},
    9: {'other': '0B'},
    12: {'other': '0T'},
  }, COMPACT_DECIMAL_LONG_PATTERN: const {
    3: {
      'one': '0 libo',
      'other': '0 na libo',
    },
    6: {
      'one': '0 milyon',
      'other': '0 na milyon',
    },
    9: {
      'one': '0 bilyon',
      'other': '0 na bilyon',
    },
    12: {
      'one': '0 trilyon',
      'other': '0 na trilyon',
    },
  }, COMPACT_DECIMAL_SHORT_CURRENCY_PATTERN: const {
    3: {'other': '\u00A40K'},
    6: {'other': '\u00A40M'},
    9: {'other': '\u00A40B'},
    12: {'other': '\u00A40T'},
  }),
  // Compact number symbols for locale tr.
  "tr": new CompactNumberSymbols(COMPACT_DECIMAL_SHORT_PATTERN: const {
    3: {'other': '0\u00A0B'},
    6: {'other': '0\u00A0Mn'},
    9: {'other': '0\u00A0Mr'},
    12: {'other': '0\u00A0Tn'},
  }, COMPACT_DECIMAL_LONG_PATTERN: const {
    3: {'other': '0 bin'},
    6: {'other': '0 milyon'},
    9: {'other': '0 milyar'},
    12: {'other': '0 trilyon'},
  }, COMPACT_DECIMAL_SHORT_CURRENCY_PATTERN: const {
    3: {'other': '0\u00A0B\u00A0\u00A4'},
    6: {'other': '0\u00A0Mn\u00A0\u00A4'},
    9: {'other': '0\u00A0Mr\u00A0\u00A4'},
    12: {'other': '0\u00A0Tn\u00A0\u00A4'},
  }),
  // Compact number symbols for locale uk.
  "uk": new CompactNumberSymbols(COMPACT_DECIMAL_SHORT_PATTERN: const {
    3: {'other': '0\u00A0\u0442\u0438\u0441.'},
    6: {'other': '0\u00A0\u043C\u043B\u043D'},
    9: {'other': '0\u00A0\u043C\u043B\u0440\u0434'},
    12: {'other': '0\u00A0\u0442\u0440\u043B\u043D'},
  }, COMPACT_DECIMAL_LONG_PATTERN: const {
    3: {
      'few': '0 \u0442\u0438\u0441\u044F\u0447\u0456',
      'many': '0 \u0442\u0438\u0441\u044F\u0447',
      'one': '0 \u0442\u0438\u0441\u044F\u0447\u0430',
      'other': '0 \u0442\u0438\u0441\u044F\u0447\u0456',
    },
    6: {
      'few': '0 \u043C\u0456\u043B\u044C\u0439\u043E\u043D\u0438',
      'many': '0 \u043C\u0456\u043B\u044C\u0439\u043E\u043D\u0456\u0432',
      'one': '0 \u043C\u0456\u043B\u044C\u0439\u043E\u043D',
      'other': '0 \u043C\u0456\u043B\u044C\u0439\u043E\u043D\u0430',
    },
    9: {
      'few': '0 \u043C\u0456\u043B\u044C\u044F\u0440\u0434\u0438',
      'many': '0 \u043C\u0456\u043B\u044C\u044F\u0440\u0434\u0456\u0432',
      'one': '0 \u043C\u0456\u043B\u044C\u044F\u0440\u0434',
      'other': '0 \u043C\u0456\u043B\u044C\u044F\u0440\u0434\u0430',
    },
    12: {
      'few': '0 \u0442\u0440\u0438\u043B\u044C\u0439\u043E\u043D\u0438',
      'many': '0 \u0442\u0440\u0438\u043B\u044C\u0439\u043E\u043D\u0456\u0432',
      'one': '0 \u0442\u0440\u0438\u043B\u044C\u0439\u043E\u043D',
      'other': '0 \u0442\u0440\u0438\u043B\u044C\u0439\u043E\u043D\u0430',
    },
  }, COMPACT_DECIMAL_SHORT_CURRENCY_PATTERN: const {
    3: {'other': '0\u00A0\u0442\u0438\u0441.\u00A0\u00A4'},
    6: {'other': '0\u00A0\u043C\u043B\u043D\u00A0\u00A4'},
    9: {'other': '0\u00A0\u043C\u043B\u0440\u0434\u00A0\u00A4'},
    12: {'other': '0\u00A0\u0442\u0440\u043B\u043D\u00A0\u00A4'},
  }),
  // Compact number symbols for locale ur.
  "ur": new CompactNumberSymbols(COMPACT_DECIMAL_SHORT_PATTERN: const {
    3: {'other': '0\u00A0\u06C1\u0632\u0627\u0631'},
    5: {'other': '0\u00A0\u0644\u0627\u06A9\u06BE'},
    7: {'other': '0\u00A0\u06A9\u0631\u0648\u0691'},
    9: {'other': '0\u00A0\u0627\u0631\u0628'},
    11: {'other': '0\u00A0\u06A9\u06BE\u0631\u0628'},
    13: {'other': '00\u00A0\u0679\u0631\u06CC\u0644\u06CC\u0646'},
  }, COMPACT_DECIMAL_LONG_PATTERN: const {
    3: {'other': '0 \u06C1\u0632\u0627\u0631'},
    5: {'other': '0 \u0644\u0627\u06A9\u06BE'},
    7: {'other': '0 \u06A9\u0631\u0648\u0691'},
    9: {'other': '0 \u0627\u0631\u0628'},
    11: {'other': '0 \u06A9\u06BE\u0631\u0628'},
    13: {'other': '00 \u0679\u0631\u06CC\u0644\u06CC\u0646'},
  }, COMPACT_DECIMAL_SHORT_CURRENCY_PATTERN: const {
    3: {'other': '\u00A4\u00A00\u00A0\u06C1\u0632\u0627\u0631'},
    5: {'other': '\u00A4\u00A00\u00A0\u0644\u0627\u06A9\u06BE'},
    7: {'other': '\u00A4\u00A00\u00A0\u06A9\u0631\u0648\u0691'},
    9: {'other': '\u00A4\u00A00\u00A0\u0627\u0631\u0628'},
    11: {'other': '\u00A4\u00A00\u00A0\u06A9\u06BE\u0631\u0628'},
    12: {'other': '\u00A40\u00A0\u0679\u0631\u06CC\u0644\u06CC\u0646'},
    13: {'other': '\u00A4\u00A000\u00A0\u0679\u0631\u06CC\u0644\u06CC\u0646'},
  }),
  // Compact number symbols for locale uz.
  "uz": new CompactNumberSymbols(COMPACT_DECIMAL_SHORT_PATTERN: const {
    3: {'other': '0\u00A0ming'},
    6: {'other': '0\u00A0mln'},
    9: {'other': '0\u00A0mlrd'},
    12: {'other': '0\u00A0trln'},
  }, COMPACT_DECIMAL_LONG_PATTERN: const {
    3: {'other': '0 ming'},
    6: {'other': '0 million'},
    9: {'other': '0 milliard'},
    12: {'other': '0 trillion'},
  }, COMPACT_DECIMAL_SHORT_CURRENCY_PATTERN: const {
    3: {'other': '0\u00A0ming\u00A0\u00A4'},
    6: {'other': '0\u00A0mln\u00A0\u00A4'},
    9: {'other': '0\u00A0mlrd\u00A0\u00A4'},
    12: {'other': '0\u00A0trln\u00A0\u00A4'},
  }),
  // Compact number symbols for locale vi.
  "vi": new CompactNumberSymbols(COMPACT_DECIMAL_SHORT_PATTERN: const {
    3: {'other': '0\u00A0N'},
    6: {'other': '0\u00A0Tr'},
    9: {'other': '0\u00A0T'},
    12: {'other': '0\u00A0NT'},
  }, COMPACT_DECIMAL_LONG_PATTERN: const {
    3: {'other': '0 ngh\u00ECn'},
    6: {'other': '0 tri\u1EC7u'},
    9: {'other': '0 t\u1EF7'},
    12: {'other': '0 ngh\u00ECn t\u1EF7'},
  }, COMPACT_DECIMAL_SHORT_CURRENCY_PATTERN: const {
    3: {'other': '0\u00A0N\u00A0\u00A4'},
    6: {'other': '0\u00A0Tr\u00A0\u00A4'},
    9: {'other': '0\u00A0T\u00A0\u00A4'},
    12: {'other': '0\u00A0NT\u00A0\u00A4'},
  }),
  // Compact number symbols for locale zh.
  "zh": new CompactNumberSymbols(COMPACT_DECIMAL_SHORT_PATTERN: const {
    3: {'other': '0'},
    4: {'other': '0\u4E07'},
    8: {'other': '0\u4EBF'},
    12: {'other': '0\u4E07\u4EBF'},
  }, COMPACT_DECIMAL_SHORT_CURRENCY_PATTERN: const {
    3: {'other': '0'},
    4: {'other': '\u00A40\u4E07'},
    8: {'other': '\u00A40\u4EBF'},
    12: {'other': '\u00A40\u4E07\u4EBF'},
  }),
  // Compact number symbols for locale zh_CN.
  "zh_CN": new CompactNumberSymbols(COMPACT_DECIMAL_SHORT_PATTERN: const {
    3: {'other': '0'},
    4: {'other': '0\u4E07'},
    8: {'other': '0\u4EBF'},
    12: {'other': '0\u4E07\u4EBF'},
  }, COMPACT_DECIMAL_SHORT_CURRENCY_PATTERN: const {
    3: {'other': '0'},
    4: {'other': '\u00A40\u4E07'},
    8: {'other': '\u00A40\u4EBF'},
    12: {'other': '\u00A40\u4E07\u4EBF'},
  }),
  // Compact number symbols for locale zh_HK.
  "zh_HK": new CompactNumberSymbols(COMPACT_DECIMAL_SHORT_PATTERN: const {
    3: {'other': '0K'},
    6: {'other': '0M'},
    9: {'other': '0B'},
    12: {'other': '0T'},
  }, COMPACT_DECIMAL_SHORT_CURRENCY_PATTERN: const {
    3: {'other': '\u00A40K'},
    6: {'other': '\u00A40M'},
    9: {'other': '\u00A40B'},
    12: {'other': '\u00A40T'},
  }),
  // Compact number symbols for locale zh_TW.
  "zh_TW": new CompactNumberSymbols(COMPACT_DECIMAL_SHORT_PATTERN: const {
    3: {'other': '0'},
    4: {'other': '0\u842C'},
    8: {'other': '0\u5104'},
    12: {'other': '0\u5146'},
  }, COMPACT_DECIMAL_SHORT_CURRENCY_PATTERN: const {
    3: {'other': '0'},
    4: {'other': '\u00A40\u842C'},
    8: {'other': '\u00A40\u5104'},
    12: {'other': '\u00A40\u5146'},
  }),
  // Compact number symbols for locale zu.
  "zu": new CompactNumberSymbols(COMPACT_DECIMAL_SHORT_PATTERN: const {
    3: {'other': '0K'},
    6: {'other': '0M'},
    9: {'other': '0B'},
    12: {'other': '0T'},
  }, COMPACT_DECIMAL_LONG_PATTERN: const {
    3: {'other': '0 inkulungwane'},
    6: {'other': '0 isigidi'},
    9: {'other': '0 isigidi sezigidi'},
    12: {'other': '0 isigidintathu'},
  }, COMPACT_DECIMAL_SHORT_CURRENCY_PATTERN: const {
    3: {'other': '\u00A40K'},
    6: {
      'one': '\u00A40M',
      'other': '\u00A4\u00A00M',
    },
    8: {'other': '\u00A4000M'},
    9: {'other': '\u00A40B'},
    12: {'other': '\u00A40T'},
  })
};

final currencyFractionDigits = {
  "ADP": 0,
  "AFN": 0,
  "ALL": 0,
  "AMD": 2,
  "BHD": 3,
  "BIF": 0,
  "BYN": 2,
  "BYR": 0,
  "CAD": 2,
  "CHF": 2,
  "CLF": 4,
  "CLP": 0,
  "COP": 2,
  "CRC": 2,
  "CZK": 2,
  "DEFAULT": 2,
  "DJF": 0,
  "DKK": 2,
  "ESP": 0,
  "GNF": 0,
  "GYD": 2,
  "HUF": 2,
  "IDR": 2,
  "IQD": 0,
  "IRR": 0,
  "ISK": 0,
  "ITL": 0,
  "JOD": 3,
  "JPY": 0,
  "KMF": 0,
  "KPW": 0,
  "KRW": 0,
  "KWD": 3,
  "LAK": 0,
  "LBP": 0,
  "LUF": 0,
  "LYD": 3,
  "MGA": 0,
  "MGF": 0,
  "MMK": 0,
  "MNT": 2,
  "MRO": 0,
  "MUR": 2,
  "NOK": 2,
  "OMR": 3,
  "PKR": 2,
  "PYG": 0,
  "RSD": 0,
  "RWF": 0,
  "SEK": 2,
  "SLE": 2,
  "SLL": 0,
  "SOS": 0,
  "STD": 0,
  "SYP": 0,
  "TMM": 0,
  "TND": 3,
  "TRL": 0,
  "TWD": 2,
  "TZS": 2,
  "UGX": 0,
  "UYI": 0,
  "UYW": 4,
  "UZS": 2,
  "VEF": 2,
  "VND": 0,
  "VUV": 0,
  "XAF": 0,
  "XOF": 0,
  "XPF": 0,
  "YER": 0,
  "ZMK": 0,
  "ZWD": 0,
};
