// Copyright 2013 The Flutter Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
// Autogenerated from Pigeon (v22.6.2), do not edit directly.
// See also: https://pub.dev/packages/pigeon

package dev.flutter.packages.file_selector_android;

import static java.lang.annotation.ElementType.METHOD;
import static java.lang.annotation.RetentionPolicy.CLASS;

import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import io.flutter.plugin.common.BasicMessageChannel;
import io.flutter.plugin.common.BinaryMessenger;
import io.flutter.plugin.common.MessageCodec;
import io.flutter.plugin.common.StandardMessageCodec;
import java.io.ByteArrayOutputStream;
import java.lang.annotation.Retention;
import java.lang.annotation.Target;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

/** Generated class from Pigeon. */
@SuppressWarnings({"unused", "unchecked", "CodeBlock2Expr", "RedundantSuppression", "serial"})
public class GeneratedFileSelectorApi {

  /** Error class for passing custom error details to Flutter via a thrown PlatformException. */
  public static class FlutterError extends RuntimeException {

    /** The error code. */
    public final String code;

    /** The error details. Must be a datatype supported by the api codec. */
    public final Object details;

    public FlutterError(@NonNull String code, @Nullable String message, @Nullable Object details) {
      super(message);
      this.code = code;
      this.details = details;
    }
  }

  @NonNull
  protected static ArrayList<Object> wrapError(@NonNull Throwable exception) {
    ArrayList<Object> errorList = new ArrayList<>(3);
    if (exception instanceof FlutterError) {
      FlutterError error = (FlutterError) exception;
      errorList.add(error.code);
      errorList.add(error.getMessage());
      errorList.add(error.details);
    } else {
      errorList.add(exception.toString());
      errorList.add(exception.getClass().getSimpleName());
      errorList.add(
          "Cause: " + exception.getCause() + ", Stacktrace: " + Log.getStackTraceString(exception));
    }
    return errorList;
  }

  @Target(METHOD)
  @Retention(CLASS)
  @interface CanIgnoreReturnValue {}

  public enum FileSelectorExceptionCode {
    SECURITY_EXCEPTION(0),
    IO_EXCEPTION(1),
    ILLEGAL_ARGUMENT_EXCEPTION(2),
    ILLEGAL_STATE_EXCEPTION(3);

    final int index;

    FileSelectorExceptionCode(final int index) {
      this.index = index;
    }
  }

  /** Generated class from Pigeon that represents data sent in messages. */
  public static final class FileSelectorNativeException {
    private @NonNull FileSelectorExceptionCode fileSelectorExceptionCode;

    public @NonNull FileSelectorExceptionCode getFileSelectorExceptionCode() {
      return fileSelectorExceptionCode;
    }

    public void setFileSelectorExceptionCode(@NonNull FileSelectorExceptionCode setterArg) {
      if (setterArg == null) {
        throw new IllegalStateException("Nonnull field \"fileSelectorExceptionCode\" is null.");
      }
      this.fileSelectorExceptionCode = setterArg;
    }

    private @NonNull String message;

    public @NonNull String getMessage() {
      return message;
    }

    public void setMessage(@NonNull String setterArg) {
      if (setterArg == null) {
        throw new IllegalStateException("Nonnull field \"message\" is null.");
      }
      this.message = setterArg;
    }

    /** Constructor is non-public to enforce null safety; use Builder. */
    FileSelectorNativeException() {}

    @Override
    public boolean equals(Object o) {
      if (this == o) {
        return true;
      }
      if (o == null || getClass() != o.getClass()) {
        return false;
      }
      FileSelectorNativeException that = (FileSelectorNativeException) o;
      return fileSelectorExceptionCode.equals(that.fileSelectorExceptionCode)
          && message.equals(that.message);
    }

    @Override
    public int hashCode() {
      return Objects.hash(fileSelectorExceptionCode, message);
    }

    public static final class Builder {

      private @Nullable FileSelectorExceptionCode fileSelectorExceptionCode;

      @CanIgnoreReturnValue
      public @NonNull Builder setFileSelectorExceptionCode(
          @NonNull FileSelectorExceptionCode setterArg) {
        this.fileSelectorExceptionCode = setterArg;
        return this;
      }

      private @Nullable String message;

      @CanIgnoreReturnValue
      public @NonNull Builder setMessage(@NonNull String setterArg) {
        this.message = setterArg;
        return this;
      }

      public @NonNull FileSelectorNativeException build() {
        FileSelectorNativeException pigeonReturn = new FileSelectorNativeException();
        pigeonReturn.setFileSelectorExceptionCode(fileSelectorExceptionCode);
        pigeonReturn.setMessage(message);
        return pigeonReturn;
      }
    }

    @NonNull
    ArrayList<Object> toList() {
      ArrayList<Object> toListResult = new ArrayList<>(2);
      toListResult.add(fileSelectorExceptionCode);
      toListResult.add(message);
      return toListResult;
    }

    static @NonNull FileSelectorNativeException fromList(
        @NonNull ArrayList<Object> pigeonVar_list) {
      FileSelectorNativeException pigeonResult = new FileSelectorNativeException();
      Object fileSelectorExceptionCode = pigeonVar_list.get(0);
      pigeonResult.setFileSelectorExceptionCode(
          (FileSelectorExceptionCode) fileSelectorExceptionCode);
      Object message = pigeonVar_list.get(1);
      pigeonResult.setMessage((String) message);
      return pigeonResult;
    }
  }

  /** Generated class from Pigeon that represents data sent in messages. */
  public static final class FileResponse {
    private @NonNull String path;

    public @NonNull String getPath() {
      return path;
    }

    public void setPath(@NonNull String setterArg) {
      if (setterArg == null) {
        throw new IllegalStateException("Nonnull field \"path\" is null.");
      }
      this.path = setterArg;
    }

    private @Nullable String mimeType;

    public @Nullable String getMimeType() {
      return mimeType;
    }

    public void setMimeType(@Nullable String setterArg) {
      this.mimeType = setterArg;
    }

    private @Nullable String name;

    public @Nullable String getName() {
      return name;
    }

    public void setName(@Nullable String setterArg) {
      this.name = setterArg;
    }

    private @NonNull Long size;

    public @NonNull Long getSize() {
      return size;
    }

    public void setSize(@NonNull Long setterArg) {
      if (setterArg == null) {
        throw new IllegalStateException("Nonnull field \"size\" is null.");
      }
      this.size = setterArg;
    }

    private @NonNull byte[] bytes;

    public @NonNull byte[] getBytes() {
      return bytes;
    }

    public void setBytes(@NonNull byte[] setterArg) {
      if (setterArg == null) {
        throw new IllegalStateException("Nonnull field \"bytes\" is null.");
      }
      this.bytes = setterArg;
    }

    private @Nullable FileSelectorNativeException fileSelectorNativeException;

    public @Nullable FileSelectorNativeException getFileSelectorNativeException() {
      return fileSelectorNativeException;
    }

    public void setFileSelectorNativeException(@Nullable FileSelectorNativeException setterArg) {
      this.fileSelectorNativeException = setterArg;
    }

    /** Constructor is non-public to enforce null safety; use Builder. */
    FileResponse() {}

    @Override
    public boolean equals(Object o) {
      if (this == o) {
        return true;
      }
      if (o == null || getClass() != o.getClass()) {
        return false;
      }
      FileResponse that = (FileResponse) o;
      return path.equals(that.path)
          && Objects.equals(mimeType, that.mimeType)
          && Objects.equals(name, that.name)
          && size.equals(that.size)
          && Arrays.equals(bytes, that.bytes)
          && Objects.equals(fileSelectorNativeException, that.fileSelectorNativeException);
    }

    @Override
    public int hashCode() {
      int pigeonVar_result = Objects.hash(path, mimeType, name, size, fileSelectorNativeException);
      pigeonVar_result = 31 * pigeonVar_result + Arrays.hashCode(bytes);
      return pigeonVar_result;
    }

    public static final class Builder {

      private @Nullable String path;

      @CanIgnoreReturnValue
      public @NonNull Builder setPath(@NonNull String setterArg) {
        this.path = setterArg;
        return this;
      }

      private @Nullable String mimeType;

      @CanIgnoreReturnValue
      public @NonNull Builder setMimeType(@Nullable String setterArg) {
        this.mimeType = setterArg;
        return this;
      }

      private @Nullable String name;

      @CanIgnoreReturnValue
      public @NonNull Builder setName(@Nullable String setterArg) {
        this.name = setterArg;
        return this;
      }

      private @Nullable Long size;

      @CanIgnoreReturnValue
      public @NonNull Builder setSize(@NonNull Long setterArg) {
        this.size = setterArg;
        return this;
      }

      private @Nullable byte[] bytes;

      @CanIgnoreReturnValue
      public @NonNull Builder setBytes(@NonNull byte[] setterArg) {
        this.bytes = setterArg;
        return this;
      }

      private @Nullable FileSelectorNativeException fileSelectorNativeException;

      @CanIgnoreReturnValue
      public @NonNull Builder setFileSelectorNativeException(
          @Nullable FileSelectorNativeException setterArg) {
        this.fileSelectorNativeException = setterArg;
        return this;
      }

      public @NonNull FileResponse build() {
        FileResponse pigeonReturn = new FileResponse();
        pigeonReturn.setPath(path);
        pigeonReturn.setMimeType(mimeType);
        pigeonReturn.setName(name);
        pigeonReturn.setSize(size);
        pigeonReturn.setBytes(bytes);
        pigeonReturn.setFileSelectorNativeException(fileSelectorNativeException);
        return pigeonReturn;
      }
    }

    @NonNull
    ArrayList<Object> toList() {
      ArrayList<Object> toListResult = new ArrayList<>(6);
      toListResult.add(path);
      toListResult.add(mimeType);
      toListResult.add(name);
      toListResult.add(size);
      toListResult.add(bytes);
      toListResult.add(fileSelectorNativeException);
      return toListResult;
    }

    static @NonNull FileResponse fromList(@NonNull ArrayList<Object> pigeonVar_list) {
      FileResponse pigeonResult = new FileResponse();
      Object path = pigeonVar_list.get(0);
      pigeonResult.setPath((String) path);
      Object mimeType = pigeonVar_list.get(1);
      pigeonResult.setMimeType((String) mimeType);
      Object name = pigeonVar_list.get(2);
      pigeonResult.setName((String) name);
      Object size = pigeonVar_list.get(3);
      pigeonResult.setSize((Long) size);
      Object bytes = pigeonVar_list.get(4);
      pigeonResult.setBytes((byte[]) bytes);
      Object fileSelectorNativeException = pigeonVar_list.get(5);
      pigeonResult.setFileSelectorNativeException(
          (FileSelectorNativeException) fileSelectorNativeException);
      return pigeonResult;
    }
  }

  /** Generated class from Pigeon that represents data sent in messages. */
  public static final class FileTypes {
    private @NonNull List<String> mimeTypes;

    public @NonNull List<String> getMimeTypes() {
      return mimeTypes;
    }

    public void setMimeTypes(@NonNull List<String> setterArg) {
      if (setterArg == null) {
        throw new IllegalStateException("Nonnull field \"mimeTypes\" is null.");
      }
      this.mimeTypes = setterArg;
    }

    private @NonNull List<String> extensions;

    public @NonNull List<String> getExtensions() {
      return extensions;
    }

    public void setExtensions(@NonNull List<String> setterArg) {
      if (setterArg == null) {
        throw new IllegalStateException("Nonnull field \"extensions\" is null.");
      }
      this.extensions = setterArg;
    }

    /** Constructor is non-public to enforce null safety; use Builder. */
    FileTypes() {}

    @Override
    public boolean equals(Object o) {
      if (this == o) {
        return true;
      }
      if (o == null || getClass() != o.getClass()) {
        return false;
      }
      FileTypes that = (FileTypes) o;
      return mimeTypes.equals(that.mimeTypes) && extensions.equals(that.extensions);
    }

    @Override
    public int hashCode() {
      return Objects.hash(mimeTypes, extensions);
    }

    public static final class Builder {

      private @Nullable List<String> mimeTypes;

      @CanIgnoreReturnValue
      public @NonNull Builder setMimeTypes(@NonNull List<String> setterArg) {
        this.mimeTypes = setterArg;
        return this;
      }

      private @Nullable List<String> extensions;

      @CanIgnoreReturnValue
      public @NonNull Builder setExtensions(@NonNull List<String> setterArg) {
        this.extensions = setterArg;
        return this;
      }

      public @NonNull FileTypes build() {
        FileTypes pigeonReturn = new FileTypes();
        pigeonReturn.setMimeTypes(mimeTypes);
        pigeonReturn.setExtensions(extensions);
        return pigeonReturn;
      }
    }

    @NonNull
    ArrayList<Object> toList() {
      ArrayList<Object> toListResult = new ArrayList<>(2);
      toListResult.add(mimeTypes);
      toListResult.add(extensions);
      return toListResult;
    }

    static @NonNull FileTypes fromList(@NonNull ArrayList<Object> pigeonVar_list) {
      FileTypes pigeonResult = new FileTypes();
      Object mimeTypes = pigeonVar_list.get(0);
      pigeonResult.setMimeTypes((List<String>) mimeTypes);
      Object extensions = pigeonVar_list.get(1);
      pigeonResult.setExtensions((List<String>) extensions);
      return pigeonResult;
    }
  }

  private static class PigeonCodec extends StandardMessageCodec {
    public static final PigeonCodec INSTANCE = new PigeonCodec();

    private PigeonCodec() {}

    @Override
    protected Object readValueOfType(byte type, @NonNull ByteBuffer buffer) {
      switch (type) {
        case (byte) 129:
          {
            Object value = readValue(buffer);
            return value == null
                ? null
                : FileSelectorExceptionCode.values()[((Long) value).intValue()];
          }
        case (byte) 130:
          return FileSelectorNativeException.fromList((ArrayList<Object>) readValue(buffer));
        case (byte) 131:
          return FileResponse.fromList((ArrayList<Object>) readValue(buffer));
        case (byte) 132:
          return FileTypes.fromList((ArrayList<Object>) readValue(buffer));
        default:
          return super.readValueOfType(type, buffer);
      }
    }

    @Override
    protected void writeValue(@NonNull ByteArrayOutputStream stream, Object value) {
      if (value instanceof FileSelectorExceptionCode) {
        stream.write(129);
        writeValue(stream, value == null ? null : ((FileSelectorExceptionCode) value).index);
      } else if (value instanceof FileSelectorNativeException) {
        stream.write(130);
        writeValue(stream, ((FileSelectorNativeException) value).toList());
      } else if (value instanceof FileResponse) {
        stream.write(131);
        writeValue(stream, ((FileResponse) value).toList());
      } else if (value instanceof FileTypes) {
        stream.write(132);
        writeValue(stream, ((FileTypes) value).toList());
      } else {
        super.writeValue(stream, value);
      }
    }
  }

  /** Asynchronous error handling return type for non-nullable API method returns. */
  public interface Result<T> {
    /** Success case callback method for handling returns. */
    void success(@NonNull T result);

    /** Failure case callback method for handling errors. */
    void error(@NonNull Throwable error);
  }
  /** Asynchronous error handling return type for nullable API method returns. */
  public interface NullableResult<T> {
    /** Success case callback method for handling returns. */
    void success(@Nullable T result);

    /** Failure case callback method for handling errors. */
    void error(@NonNull Throwable error);
  }
  /** Asynchronous error handling return type for void API method returns. */
  public interface VoidResult {
    /** Success case callback method for handling returns. */
    void success();

    /** Failure case callback method for handling errors. */
    void error(@NonNull Throwable error);
  }
  /**
   * An API to call to native code to select files or directories.
   *
   * <p>Generated interface from Pigeon that represents a handler of messages from Flutter.
   */
  public interface FileSelectorApi {
    /**
     * Opens a file dialog for loading files and returns a file path.
     *
     * <p>Returns `null` if user cancels the operation.
     */
    void openFile(
        @Nullable String initialDirectory,
        @NonNull FileTypes allowedTypes,
        @NonNull NullableResult<FileResponse> result);
    /**
     * Opens a file dialog for loading files and returns a list of file responses chosen by the
     * user.
     */
    void openFiles(
        @Nullable String initialDirectory,
        @NonNull FileTypes allowedTypes,
        @NonNull Result<List<FileResponse>> result);
    /**
     * Opens a file dialog for loading directories and returns a directory path.
     *
     * <p>Returns `null` if user cancels the operation.
     */
    void getDirectoryPath(
        @Nullable String initialDirectory, @NonNull NullableResult<String> result);

    /** The codec used by FileSelectorApi. */
    static @NonNull MessageCodec<Object> getCodec() {
      return PigeonCodec.INSTANCE;
    }
    /**
     * Sets up an instance of `FileSelectorApi` to handle messages through the `binaryMessenger`.
     */
    static void setUp(@NonNull BinaryMessenger binaryMessenger, @Nullable FileSelectorApi api) {
      setUp(binaryMessenger, "", api);
    }

    static void setUp(
        @NonNull BinaryMessenger binaryMessenger,
        @NonNull String messageChannelSuffix,
        @Nullable FileSelectorApi api) {
      messageChannelSuffix = messageChannelSuffix.isEmpty() ? "" : "." + messageChannelSuffix;
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger,
                "dev.flutter.pigeon.file_selector_android.FileSelectorApi.openFile"
                    + messageChannelSuffix,
                getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                String initialDirectoryArg = (String) args.get(0);
                FileTypes allowedTypesArg = (FileTypes) args.get(1);
                NullableResult<FileResponse> resultCallback =
                    new NullableResult<FileResponse>() {
                      public void success(FileResponse result) {
                        wrapped.add(0, result);
                        reply.reply(wrapped);
                      }

                      public void error(Throwable error) {
                        ArrayList<Object> wrappedError = wrapError(error);
                        reply.reply(wrappedError);
                      }
                    };

                api.openFile(initialDirectoryArg, allowedTypesArg, resultCallback);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger,
                "dev.flutter.pigeon.file_selector_android.FileSelectorApi.openFiles"
                    + messageChannelSuffix,
                getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                String initialDirectoryArg = (String) args.get(0);
                FileTypes allowedTypesArg = (FileTypes) args.get(1);
                Result<List<FileResponse>> resultCallback =
                    new Result<List<FileResponse>>() {
                      public void success(List<FileResponse> result) {
                        wrapped.add(0, result);
                        reply.reply(wrapped);
                      }

                      public void error(Throwable error) {
                        ArrayList<Object> wrappedError = wrapError(error);
                        reply.reply(wrappedError);
                      }
                    };

                api.openFiles(initialDirectoryArg, allowedTypesArg, resultCallback);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger,
                "dev.flutter.pigeon.file_selector_android.FileSelectorApi.getDirectoryPath"
                    + messageChannelSuffix,
                getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                String initialDirectoryArg = (String) args.get(0);
                NullableResult<String> resultCallback =
                    new NullableResult<String>() {
                      public void success(String result) {
                        wrapped.add(0, result);
                        reply.reply(wrapped);
                      }

                      public void error(Throwable error) {
                        ArrayList<Object> wrappedError = wrapError(error);
                        reply.reply(wrappedError);
                      }
                    };

                api.getDirectoryPath(initialDirectoryArg, resultCallback);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
    }
  }
}
