// Copyright (c) 2023, the Dart project authors.  Please see the AUTHORS file
// for details. All rights reserved. Use of this source code is governed by a
// BSD-style license that can be found in the LICENSE file.

import 'common/service_test_common.dart';
import 'common/test_helper.dart';

// AUTOGENERATED START
//
// Update these constants by running:
//
// dart pkg/vm_service/test/update_line_numbers.dart pkg/vm_service/test/step_through_call_on_field_test.dart
//
const LINE_A = 21;
// AUTOGENERATED END

const file = 'step_through_call_on_field_test.dart';

late Function() foo;

void code() /* LINE_A */ {
  foo = fooMethod;
  fooMethod();
  foo();
}

void fooMethod() {
  print('Hello from fooMethod');
}

final stops = <String>[];
const expected = <String>[
  '$file:${LINE_A + 0}:10', // after 'code', i.e. on '('
  '$file:${LINE_A + 1}:3', // on 'foo'
  '$file:${LINE_A + 2}:3', // on 'fooMethod'
  '$file:${LINE_A + 3}:6', // after 'foo' (on invisible '.call')
  '$file:${LINE_A + 4}:1', // on ending '}'
];

final tests = <IsolateTest>[
  hasPausedAtStart,
  setBreakpointAtLine(LINE_A),
  runStepThroughProgramRecordingStops(stops),
  checkRecordedStops(stops, expected),
];

void main([args = const <String>[]]) => runIsolateTests(
      args,
      tests,
      'step_through_call_on_field_test.dart',
      testeeConcurrent: code,
      pauseOnStart: true,
      pauseOnExit: true,
    );
