import 'package:clipious/settings/models/db/server.dart';
import 'package:clipious/utils/models/sharelink.dart';
import 'package:clipious/videos/models/video.dart';
import 'package:json_annotation/json_annotation.dart';

import '../../utils/models/image_object.dart';

part 'channel.g.dart';

@JsonSerializable()
class Channel implements ShareLinks {
  String author;
  String authorId;
  String authorUrl;
  List<ImageObject>? authorBanners;
  List<ImageObject> authorThumbnails;
  int subCount;
  int? totalViews;
  int? joined;
  bool autoGenerated;
  bool? isFamilyFriendly;
  String description;

  List<String>? allowedRegions;
  List<Video>? latestVideos;

  Channel(
      this.author,
      this.authorId,
      this.authorUrl,
      this.authorBanners,
      this.authorThumbnails,
      this.subCount,
      this.totalViews,
      this.joined,
      this.autoGenerated,
      this.isFamilyFriendly,
      this.description,
      this.allowedRegions,
      this.latestVideos);

  factory Channel.fromJson(Map<String, dynamic> json) =>
      _$ChannelFromJson(json);

  Map<String, dynamic> toJson() => _$ChannelToJson(this);

  @override
  String getInvidiousLink(Server server, int? timestamp) {
    return '${server.url}/channel/$authorId';
  }

  @override
  getRedirectLink(int? timestamp) {
    return 'https://redirect.invidious.io/channel/$authorId';
  }

  @override
  String getYoutubeLink(int? timestamp) {
    return 'https://www.youtube.com/channel/$authorId';
  }
}
