// Code generated by running "go generate" in golang.org/x/text. DO NOT EDIT.

package translations

import (
	"golang.org/x/text/language"
	"golang.org/x/text/message"
	"golang.org/x/text/message/catalog"
)

type dictionary struct {
	index []uint32
	data  string
}

func (d *dictionary) Lookup(key string) (data string, ok bool) {
	p, ok := messageKeyToIndex[key]
	if !ok {
		return "", false
	}
	start, end := d.index[p], d.index[p+1]
	if start == end {
		return "", false
	}
	return d.data[start:end], true
}

func init() {
	dict := map[string]catalog.Dictionary{
		"en_US": &dictionary{index: en_USIndex, data: en_USData},
		"ja_JP": &dictionary{index: ja_JPIndex, data: ja_JPData},
		"ru_RU": &dictionary{index: ru_RUIndex, data: ru_RUData},
		"tr_TR": &dictionary{index: tr_TRIndex, data: tr_TRData},
		"zh_CN": &dictionary{index: zh_CNIndex, data: zh_CNData},
		"zh_HK": &dictionary{index: zh_HKIndex, data: zh_HKData},
		"zh_TW": &dictionary{index: zh_TWIndex, data: zh_TWData},
	}
	fallback := language.MustParse("en-US")
	cat, err := catalog.NewFromMap(dict, catalog.Fallback(fallback))
	if err != nil {
		panic(err)
	}
	message.DefaultCatalog = cat
}

var messageKeyToIndex = map[string]int{
	"About":                  1,
	"Address":                25,
	"Appearance":             19,
	"Cancel":                 14,
	"Debug":                  38,
	"Debug log:":             2,
	"Disable Compression":    36,
	"Disable Local":          29,
	"Disable Multiplexing":   35,
	"Download":               6,
	"Enable Debug Log":       16,
	"Enter code to download": 3,
	"Font":                   22,
	"Force Local Only":       30,
	"Hash Algorithm":         34,
	"Language":               20,
	"License Info":           0,
	"Logo":                   23,
	"Multicast Address":      31,
	"Network Local":          28,
	"PAKE Curve":             33,
	"Password":               27,
	"Pick a file to send":    9,
	"Ports":                  26,
	"Receive":                4,
	"Receive Code":           5,
	"Received":               8,
	"Receiving file":         7,
	"Relay":                  24,
	"Send":                   10,
	"Send Code":              15,
	"Send cancelled.":        13,
	"Sending file":           11,
	"Sent file":              12,
	"Settings":               18,
	"Show / Hide":            17,
	"Theme":                  21,
	"Transfer Options":       32,
	"Upload Speed Throttle":  37,
}

var en_USIndex = []uint32{ // 40 elements
	// Entry 0 - 1F
	0x00000000, 0x0000000d, 0x00000013, 0x0000001e,
	0x00000035, 0x0000003d, 0x0000004a, 0x00000053,
	0x00000062, 0x0000006b, 0x0000007f, 0x00000084,
	0x00000091, 0x0000009b, 0x000000ab, 0x000000b2,
	0x000000bc, 0x000000cd, 0x000000d9, 0x000000e2,
	0x000000ed, 0x000000f6, 0x000000fc, 0x00000101,
	0x00000106, 0x0000010c, 0x00000114, 0x0000011a,
	0x00000123, 0x00000131, 0x0000013f, 0x00000150,
	// Entry 20 - 3F
	0x00000162, 0x00000173, 0x0000017e, 0x0000018d,
	0x000001a2, 0x000001b6, 0x000001cc, 0x000001d2,
} // Size: 184 bytes

const en_USData string = "" + // Size: 466 bytes
	"\x02License Info\x02About\x02Debug log:\x02Enter code to download\x02Rec" +
	"eive\x02Receive Code\x02Download\x02Receiving file\x02Received\x02Pick a" +
	" file to send\x02Send\x02Sending file\x02Sent file\x02Send cancelled." +
	"\x02Cancel\x02Send Code\x02Enable Debug Log\x02Show / Hide\x02Settings" +
	"\x02Appearance\x02Language\x02Theme\x02Font\x02Logo\x02Relay\x02Address" +
	"\x02Ports\x02Password\x02Network Local\x02Disable Local\x02Force Local O" +
	"nly\x02Multicast Address\x02Transfer Options\x02PAKE Curve\x02Hash Algor" +
	"ithm\x02Disable Multiplexing\x02Disable Compression\x02Upload Speed Thro" +
	"ttle\x02Debug"

var ja_JPIndex = []uint32{ // 40 elements
	// Entry 0 - 1F
	0x00000000, 0x00000016, 0x0000001d, 0x00000031,
	0x0000005c, 0x00000063, 0x00000073, 0x00000086,
	0x0000009f, 0x000000b2, 0x000000d4, 0x000000db,
	0x000000f4, 0x00000116, 0x0000013e, 0x0000014e,
	0x0000015e, 0x0000017d, 0x00000190, 0x00000197,
	0x0000019e, 0x000001a5, 0x000001af, 0x000001bc,
	0x000001c3, 0x000001cd, 0x000001da, 0x000001e4,
	0x000001f4, 0x00000213, 0x0000023e, 0x0000026f,
	// Entry 20 - 3F
	0x00000291, 0x000002a7, 0x000002b2, 0x000002c5,
	0x000002e1, 0x000002f4, 0x00000316, 0x00000323,
} // Size: 184 bytes

const ja_JPData string = "" + // Size: 803 bytes
	"\x02ライセンス情報\x02情報\x02デバッグログ:\x02コードを入力してダウンロード\x02受信\x02受信コード\x02ダウンロード" +
	"\x02ファイルを受信中\x02受信しました\x02ファイルを選択して送信\x02送信\x02ファイルを送信中\x02ファイルを送信しました" +
	"\x02送信はキャンセルされました\x02キャンセル\x02受信コード\x02デバッグログを有効化\x02表示 / 非表示\x02設定\x02外" +
	"観\x02言語\x02テーマ\x02フォント\x02ロゴ\x02リレー\x02アドレス\x02ポート\x02パスワード\x02ローカルネット" +
	"ワーク\x02ローカルネットワークを無効化\x02ローカルネットワークのみ使用する\x02マルチキャストアドレス\x02転送オプション" +
	"\x02PAKE Curve\x02ハッシュ方式\x02多重化を無効にする\x02圧縮を無効化\x02アップロード速度の制限\x02デバッグ"

var ru_RUIndex = []uint32{ // 40 elements
	// Entry 0 - 1F
	0x00000000, 0x0000002e, 0x00000035, 0x00000052,
	0x00000091, 0x0000009a, 0x000000a7, 0x000000b0,
	0x000000bf, 0x000000ce, 0x000000e4, 0x000000eb,
	0x000000f2, 0x000000ff, 0x0000011c, 0x0000012d,
	0x0000013a, 0x00000155, 0x00000167, 0x0000016e,
	0x00000175, 0x0000017e, 0x00000187, 0x00000192,
	0x000001a1, 0x000001b4, 0x000001bf, 0x000001ca,
	0x000001d7, 0x000001e0, 0x000001f6, 0x00000207,
	// Entry 20 - 3F
	0x00000214, 0x0000021f, 0x0000022b, 0x0000023b,
	0x00000269, 0x0000027d, 0x0000028c, 0x0000029b,
} // Size: 184 bytes

const ru_RUData string = "" + // Size: 667 bytes
	"\x02Лицензионная информация\x02Это\x02Журнал отладки:\x02Секрет должен б" +
	"ыть больше 5 знаков\x02Беру\x02Секрет\x02Беру\x02Получаю\x02Получил\x02" +
	"Что послать\x02Шлю\x02Шлю\x02Послал\x02Отмена посылки.\x02Отменить\x02С" +
	"екрет\x02Журналировать\x02Вкл / Выкл\x02Как\x02Вид\x02Язык\x02Тема\x02Ш" +
	"рифт\x02Логотип\x02Посредник\x02Адрес\x02Порты\x02Пароль\x02сеть\x02Не " +
	"локально\x02Локально\x02Группа\x02Обмен\x02Тип PAKE\x02Тип хеша\x02Без " +
	"мультиплексирования\x02Без сжатия\x02Медлить\x02Отладка"

var tr_TRIndex = []uint32{ // 40 elements
	// Entry 0 - 1F
	0x00000000, 0x00000007, 0x00000011, 0x0000002c,
	0x00000047, 0x0000004d, 0x00000054, 0x0000005b,
	0x00000066, 0x0000006e, 0x0000008c, 0x00000094,
	0x000000a8, 0x000000ba, 0x000000d1, 0x000000d8,
	0x000000e4, 0x0000010f, 0x0000010f, 0x00000117,
	0x00000123, 0x00000127, 0x0000012c, 0x0000012c,
	0x0000012c, 0x00000132, 0x00000138, 0x0000014c,
	0x00000153, 0x0000015d, 0x00000171, 0x0000018e,
	// Entry 20 - 3F
	0x0000018e, 0x000001a4, 0x000001b1, 0x000001c1,
	0x000001e5, 0x0000020c, 0x00000227, 0x00000236,
} // Size: 184 bytes

const tr_TRData string = "" + // Size: 566 bytes
	"\x02Lisans\x02Hakkında\x02Hata ayıklama günlüğü\x02İndirmek için kodu gi" +
	"rin\x02Almak\x02Kod al\x02İndir\x02Dosya alma\x02Alınan\x02Gönderilicek " +
	"dosyayı seçin\x02Gönder\x02Dosya gönderiliyor\x02Dosya gönderildi\x02Gön" +
	"derme iptal edildi\x02İptal\x02Kod gönder\x02Hata ayıklama günlüğünü etk" +
	"inleştir\x02Ayarlar\x02Görünüş\x02Dil\x02Tema\x02Röle\x02Adres\x02Bağlan" +
	"tı noktası\x02Şifre\x02Yerel ağ\x02Yerel devre dışı\x02Yalnızca yerel ol" +
	"arak zorla\x02Transfer seçenekleri\x02PAKR eğrisi\x02Karma algoritma\x02" +
	"Çoğullamayı devre dışı bırak\x02Sıkıştırmayı devre dışı bırak\x02Yüklem" +
	"e hızını kısma \x02Hata ayıklama"

var zh_CNIndex = []uint32{ // 40 elements
	// Entry 0 - 1F
	0x00000000, 0x00000010, 0x00000017, 0x00000025,
	0x00000038, 0x0000003f, 0x00000049, 0x00000050,
	0x0000005d, 0x00000067, 0x00000080, 0x00000087,
	0x00000097, 0x000000a7, 0x000000ba, 0x000000c1,
	0x000000ce, 0x000000e1, 0x000000f1, 0x000000f8,
	0x000000ff, 0x00000106, 0x0000010d, 0x00000114,
	0x0000011b, 0x00000122, 0x00000129, 0x00000130,
	0x00000137, 0x00000144, 0x00000151, 0x00000164,
	// Entry 20 - 3F
	0x00000171, 0x0000017e, 0x0000018a, 0x00000197,
	0x000001a7, 0x000001b4, 0x000001c7, 0x000001ce,
} // Size: 184 bytes

const zh_CNData string = "" + // Size: 462 bytes
	"\x02许可证信息\x02关于\x02除错记录:\x02输入代码下载\x02接收\x02接收码\x02下载\x02接收档案\x02已接收\x02" +
	"选择要发送的档案\x02发送\x02发送档案中\x02已发送档案\x02发送已取消。\x02取消\x02发送代码\x02启用除错记录\x02" +
	"显示 / 隐藏\x02设定\x02外观\x02语言\x02主题\x02字体\x02标志\x02中继\x02地址\x02端口\x02密码" +
	"\x02本地网络\x02停用本地\x02强制仅限本地\x02组播地址\x02传输选项\x02PAKE 曲线\x02哈希算法\x02停用多重化" +
	"\x02停用压缩\x02上传速度调节\x02除错"

var zh_HKIndex = []uint32{ // 40 elements
	// Entry 0 - 1F
	0x00000000, 0x00000010, 0x00000017, 0x00000025,
	0x0000003b, 0x00000042, 0x0000004c, 0x00000053,
	0x00000060, 0x0000006a, 0x00000083, 0x0000008a,
	0x0000009a, 0x000000aa, 0x000000bd, 0x000000c4,
	0x000000d1, 0x000000e4, 0x000000f4, 0x000000fb,
	0x00000102, 0x00000109, 0x00000110, 0x00000117,
	0x0000011e, 0x00000125, 0x0000012c, 0x00000133,
	0x0000013a, 0x00000147, 0x00000154, 0x00000167,
	// Entry 20 - 3F
	0x00000174, 0x00000181, 0x0000018d, 0x0000019d,
	0x000001ad, 0x000001ba, 0x000001cd, 0x000001d4,
} // Size: 184 bytes

const zh_HKData string = "" + // Size: 468 bytes
	"\x02許可證資訊\x02關於\x02除錯記錄:\x02輸入編碼以下載\x02接收\x02接收碼\x02下載\x02接收文件\x02已接收" +
	"\x02選擇要發送的文件\x02發送\x02發送文件中\x02已發送文件\x02發送已取消。\x02取消\x02發送代碼\x02啟用除錯記錄" +
	"\x02顯示 / 隱藏\x02設定\x02外觀\x02語言\x02主題\x02字體\x02標誌\x02中繼\x02地址\x02端口\x02密碼" +
	"\x02本地網絡\x02停用本地\x02強制只限本地\x02群播位址\x02傳輸選擇\x02PAKE 曲線\x02哈希演算法\x02停用多重化" +
	"\x02停用壓縮\x02上載速度節流\x02除錯"

var zh_TWIndex = []uint32{ // 40 elements
	// Entry 0 - 1F
	0x00000000, 0x00000010, 0x00000017, 0x00000025,
	0x00000038, 0x0000003f, 0x00000049, 0x00000050,
	0x0000005d, 0x00000067, 0x00000080, 0x00000087,
	0x00000097, 0x000000a7, 0x000000ba, 0x000000c1,
	0x000000ce, 0x000000e1, 0x000000f1, 0x000000f8,
	0x000000ff, 0x00000106, 0x0000010d, 0x00000114,
	0x0000011b, 0x00000122, 0x00000129, 0x00000133,
	0x0000013a, 0x00000147, 0x00000154, 0x00000167,
	// Entry 20 - 3F
	0x00000174, 0x00000181, 0x0000018d, 0x0000019d,
	0x000001ad, 0x000001ba, 0x000001cd, 0x000001d4,
} // Size: 184 bytes

const zh_TWData string = "" + // Size: 468 bytes
	"\x02許可證資訊\x02關於\x02除錯記錄:\x02輸入代碼下載\x02接收\x02接收碼\x02下載\x02接收檔案\x02已接收\x02" +
	"選擇要發送的檔案\x02發送\x02發送檔案中\x02已發送檔案\x02發送已取消。\x02取消\x02發送代碼\x02啟用除錯記錄\x02" +
	"顯示 / 隱藏\x02設定\x02外觀\x02語言\x02主題\x02字體\x02標誌\x02中繼\x02地址\x02連接埠\x02密碼" +
	"\x02本地網路\x02停用本地\x02強制僅限本地\x02群播位址\x02傳輸選項\x02PAKE 曲線\x02哈希演算法\x02停用多重化" +
	"\x02停用壓縮\x02上傳速度調節\x02除錯"

	// Total table size 5188 bytes (5KiB); checksum: 1CB70E48
