package com.github.enteraname74.soulsearching.coreui.strings

/**
 * French translation for application strings
 */
object FrStrings : Strings {
    override val appLogo = "Logo de l'application"
    override val noElements = "Aucun élément"
    override val cannotRetrieveSongs = "Impossible de récupérer des musiques !"
    override val backButton = "Bouton de retour"
    override val createPlaylistButton = "Bouton pour créer une playlist"
    override val headerBarRightButton = "Bouton droit de la bar d'état"
    override val image = "Image"
    override val moreButton = "Bouton pour plus d'options"
    override val more = "Plus"
    override val settingsAccessButton = "Bouton d'accès aux paramètres de l'application"
    override val shuffleButton = "Bouton pour jouer une liste de musique en aléatoire"
    override val favorite = "Favoris"
    override val missingPermissions =
        "Vous devez accepter toutes les permissions de l'application pour que cette dernière fonctionne correctement."
    override val playedList = "Liste jouée"
    override val currentSong = "Musique courante"
    override val lyrics = "Paroles"
    override val activateRemoteLyricsFetchTitle = "Activer la récupération des paroles à distance"
    override val activateRemoteLyricsFetchText by lazy {
        "L'application a besoin de votre permission pour rechercher les paroles de la musique courante via un service externe ($lyricsProviderName) " +
                "lorsque aucune parole n'est trouvée dans le fichier de la musique."
    }
    override val activateRemoteLyricsFetchHint by lazy {
        "L'application utilisera le nom, album et artiste d'une musique pour trouver les paroles de cette dernière via une source distante ($lyricsProviderName) " +
                "lorsque aucune parole n'a été trouvée dans le fichier de la musique.."
    }
    override val noLyricsFound = "Aucune parole n'a été trouvée pour cette musique"
    override val localLyricsProvider = "Paroles provenant du fichier de la musique"
    override val remoteLyricsProvider = "Paroles proposées par LrcLib"

    override val completeApplicationTitle = "Une application de musique complète"
    override val completeApplicationText = "Écoutez toutes vos musiques, tous vos albums, artistes et playlists."
    override val quickAccessTitle = "Gardez ce que vous aimez proche de vous"
    override val quickAccessText =
        "Avec les accès rapides, vous pouvez facilement accéder à votre album favori, ou à vos musiques préférées par exemple."
    override val modifyElementsTitle = "Modifiez vos éléments musicaux"
    override val modifyElementsText = "Vous pouvez modifier les informations d'un album, d'un artiste, d'une musique…"
    override val dynamicThemeFeatureTitle = "Thème dynamique"
    override val dynamicThemeFeatureText =
        "Soul Searching vous offre la possibilité d'avoir un thème dynamique dépendant de la musique en cours de lecture"
    override val manageFoldersTitle = "Gérez vos dossiers"
    override val manageFoldersText = "Définissez quels dossiers sont utilisés par l'application."
    override val addNewMusicsTitle = "Ajoutez de nouvelles musiques"
    override val addNewMusicsText = "Vous pouvez facilement ajouter de nouvelles musiques provenant de votre appareil."
    override val personalizeMainPageTitle = "Définissez ce que vous voulez réellement"
    override val personalizeMainPageText =
        "Vous ne voulez pas avoir les accès rapides ou vous voudriez avoir une barre vous aidant à accéder à des éléments du menu principal ? Vous pouvez réaliser vos envies dans les paramètres de l'application."

    override val searchingSongsFromYourDevice = "Recherche de musiques sur votre appareil…"
    override val searchForMusics = "Rechercher une musique"
    override val searchAll = "Rechercher une musique, un album, un artiste, une playlist…"

    override val artists = "Artistes"
    override val musics = "Musiques"
    override val folders = "Dossiers"
    override val byFolders = "Par dossiers"
    override val byMonths = "Par mois"
    override val quickAccess = "Accès rapides"

    override val sortByAddedDate = "Date d'ajout"
    override val sortByMostListened = "Nombre d'écoutes"
    override val sortByName = "Alphabétique"

    override val removeFromQuickAccess = "Retirer des accès rapides"
    override val removeFromPlaylist = "Retirer de la playlist"
    override val removeFromPlayedList = "Retirer de la liste jouée"
    override val addToQuickAccess = "Ajouter aux accès rapides"
    override val addToPlaylist = "Ajouter à une playlist"

    override val create = "Créer"
    override val cancel = "Annuler"
    override val delete = "Supprimer"

    override val soulMixInfoDialogText = "Écoutez un mélange de musiques de chacun de vos dossiers !\nVous pouvez " +
            "définir le nombre de musiques récupérées de chaque dossier dans les paramètres."

    override val createPlaylistDialogTitle = "Créer une nouvelle playlist"
    override val playlistName = "Nom de la playlist"
    override val musicName = "Nom de la musique"
    override val musicAlbumPosition = "Position dans l'album"
    override val albumName = "Nom de l'album"
    override val albumArtistName = "Nom de l'artiste de l'album"
    override val artistName = "Nom de l'artiste"
    override val playlistCover = "Couverture de la playlist"
    override val albumCover = "Couverture de l'album"
    override val artistCover = "Couverture de l'artiste"
    override val playlistInformation = "Informations de la playlist"
    override val musicInformation = "Informations de la musique"
    override val musicPath = "Chemin de la musique :"
    override val musicFileCover = "Couverture du fichier"
    override val musicAppCover = "Couverture de l'application"
    override val coverSelection = "Sélection d'une couverture"
    override val artistInformation = "Informations de l'artiste"
    override val albumInformation = "Informations de l'album"

    override val addArtist = "Ajouter un artiste"

    override val deleteMusicDialogTitle = "Voulez-vous vraiment supprimer cette musique ?"
    override val deleteMusicDialogText = "Elle sera supprimée de l'application."
    override val deleteAlbumDialogTitle = "Voulez-vous vraiment supprimer cet album ?"
    override val deletePlaylistDialogTitle = "Voulez-vous vraiment supprimer cette playlist ?"
    override val deleteArtistDialogTitle = "Voulez-vous vraiment supprimer cet artiste ?"

    override val deleteSelectedMusicsDialogTitle = "Voulez-vous vraiment supprimer ces musiques ?"
    override val deleteSelectedMusicsDialogText = "Elles seront supprimées de l'application."
    override val deleteSelectedAlbumsDialogTitle = "Voulez-vous vraiment supprimer ces albums ?"
    override val deleteSelectedArtistsDialogTitle = "Voulez-vous vraiment supprimer ces artistes ?"
    override val deleteSelectedPlaylistsDialogTitle = "Voulez-vous vraiment supprimer ces playlists ?"

    override val removeMusicFromPlaylistTitle = "Voulez-vous vraiment supprimer cette musique de cette playlist ?"
    override val removeMusicFromPlaylistText =
        "Cette musique sera retirée de cette playlist mais ne sera pas supprimée de l'application."
    override val removeSelectedMusicFromPlaylistTitle =
        "Voulez-vous vraiment supprimer les musiques sélectionnées de cette playlist ?"
    override val removeSelectedMusicFromPlaylistText = "" +
            "Elles seront retirées de cette playlist mais ne seront pas supprimées de l'application."

    override val modifyAlbum = "Modifier cet album"
    override val modifyArtist = "Modifier cet artiste"
    override val modifyMusic = "Modifier cette musique"
    override val modifyPlaylist = "Modifier cette playlist"
    override val coversOfTheAlbum = "Couvertures des musiques de l'album"
    override val coversOfTheArtist = "Couvertures des musiques de l'artiste"
    override val coversOfThePlaylist = "Couvertures des musiques de la playlist"
    override val coversOfSongAlbum = "Couvertures présentes dans l'album de la musique"
    override val noAvailableCovers = "Aucune couverture disponible"

    override val deleteAlbum = "Supprimer cet album"
    override val deleteArtist = "Supprimer cet artiste"
    override val deleteMusic = "Supprimer cette musique"
    override val deletePlaylist = "Supprimer cette playlist"
    override val deleteSelectedAlbums = "Supprimer les albums sélectionnés"
    override val deleteSelectedArtists = "Supprimer les artistes sélectionnés"
    override val deleteSelectedPlaylists = "Supprimer les playlists sélectionnées"
    override val deleteSelectedMusics = "Supprimer les musiques sélectionnées"

    override val playNext = "Jouer ensuite"
    override val addToQueue = "Ajouter à la file d'attente"

    override val personalizedThemeTitle = "Thème personnalisé"
    override val personalizedThemeText = "Appliquer le thème dynamique sur :"
    override val dynamicPlayerView = "La vue du lecteur"
    override val dynamicPlaylistView = "La vue des playlists, albums, artistes, mois et dossiers"
    override val dynamicOtherView = "Les autres vues"

    override val settings = "Paramètres"
    override val advancedSettingsTitle = "Paramètres avancés"
    override val advancedSettingsText = "Gérer les images, séparer les artistes"
    override val reloadCoversTitle = "Recharger les images"
    override val reloadCoversText = "Recharger les images depuis les informations des fichiers"
    override val reloadMusicsCovers = "Recharger les images des musiques"
    override val deletePlaylistsCovers = "Supprimer les images des playlists"
    override val reloadAlbumsCovers = "Recharger les images des albums"
    override val reloadArtistsCovers = "Recharger les images des artistes"

    override val splitMultipleArtistsTitle = "Séparer les artistes"
    override val splitMultipleArtistsText = "Sélectionner et séparer les artistes composés de plusieurs artistes"

    override val artistCoverMethodTitle = "Source des images d'artistes"
    override val artistCoverMethodText = "Choisir le mode de récupération des images d'artistes"
    override val activateArtistCoverMethod = "Activer la récupération par chemin"
    override val artistCoverMethodDynamicNameTitle = "Traitement du nom de l'artiste"

    override val coverFolderRetrieverPathSelectionTitle = "Sélectionner le dossier parent"
    override val coverFolderRetrieverPathSelectionNoPathSelected = "Aucun dossier sélectionné"

    override val coverFolderRetrieverFileExtension = "Extension de l'image"

    override val coverFolderRetrieverFolderTitle = "Dossier dynamique"
    override val coverFolderRetrieverFolderText = "Le nom du dossier correspond au nom de l'artiste"
    override val coverFolderRetrieverFolderIncomplete = "Les données requises sont incomplètes"
    override val coverFolderRetrieverRulesWhiteSpace = "Remplacer les espaces"
    override val coverFolderRetrieverRulesReplacement = "Remplacement"
    override val coverFolderRetrieverRulesDynamicNameUppercase = "Majuscule"
    override val coverFolderRetrieverRulesDynamicNameNoTreatment = "Aucun traitement"
    override val coverFolderRetrieverRulesDynamicNameLowercase = "Minuscule"

    override val coverFolderRetrieverFileTitle = "Fichier d'image dynamique"
    override val coverFolderRetrieverFileText = "Le nom du fichier de l'image correspond au nom de l'artiste"

    override val coverFolderRetrieverDynamicFileTitle = "Nom du fichier de l'image"

    override val activateGithubReleaseFetchTitle = "Activer la recherche de nouvelles versions provenant de GitHub"
    override val activateGithubReleaseFetchHint = "Vous recevrez une notification dans l'application lorsqu'une nouvelle version de cette dernière est disponible sur GitHub."
    override val activateGithubReleaseFetchText = "Voulez-vous recevoir une notification dans l'application lorsqu'une nouvelle version de cette dernière est disponible sur GitHub ?"
    override val goToSettings = "Aller aux paramètres"

    override val manageMusicsTitle = "Gérer les musiques"
    override val manageMusicsText = "Modification et ajout de musiques, gestion des dossiers utilisés"
    override val modifyMusicFileTitle = "Modifier les fichiers sur l'appareil"
    override val modifyMusicFileText =
        "Modifier les informations d'une musique modifiera les métadonnées du fichier sur votre appareil."
    override val colorThemeTitle = "Thème de couleur"
    override val colorThemeText = "Thème dynamique, personnalisé"
    override val personalizationTitle = "Personnalisation"
    override val personalizationText = "Gérer le lecteur et la vue de la page principale"
    override val aboutTitle = "À propos de Soul Searching"
    override val aboutText = "Développeurs, nom de la version de l'application"
    override val newReleaseAvailableTitle = "Nouvelle version disponible !"
    override val statisticsTitle = "Statistiques"
    override val statisticsText = "Statistiques sur vos écoutes"
    override val mostPlayedSongs = "Musiques les plus écoutées"
    override val mostPlayedAlbums = "Albums les plus écoutés"
    override val mostPlayedArtists = "Artistes les plus écoutés"
    override val artistsWithMostSongs = "Artistes avec le plus de musiques"
    override val mostPlayedPlaylists = "Playlists les plus écoutées"
    override val themeSelectionTitle = "Thème principal"
    override val themeSelectionText = "Définir le thème principal de l'application"
    override val forceDarkThemeTitle = "Forcer le thème sombre"
    override val forceLightThemeTitle = "Forcer le thème clair"
    override val steelTheme = "Acier"
    override val duskTheme = "Crépuscule"
    override val greeneryTheme = "Verdure"
    override val treeBarkTheme = "Écorce"

    override val mainPageTitle = "Page principale"
    override val mainPageText = "Gérer la vue de la page principale"
    override val showQuickAccess = "Afficher les accès rapides"
    override val showPlaylists = "Afficher les playlists"
    override val showAlbums = "Afficher les albums"
    override val showArtists = "Afficher les artistes"
    override val manageMusicsViewText = "Gérer la vue des musiques"
    override val showMusicsByFolders = "Afficher les musiques par dossiers"
    override val showMusicsByMonths = "Afficher les musiques par mois"
    override val useVerticalAccessBarTitle = "Utiliser la barre d'accès verticale"
    override val useHorizontalAccessBarText = "Utiliser la barre d'accès horizontale"

    override val managePlayerTitle = "Lecteur de musique"
    override val managePlayerText = "Gérer le lecteur de musique"
    override val playerSwipeTitle =
        "Faire glisser la couverture de la musique pour avancer ou reculer dans la liste jouée"
    override val playerRewindTitle = "Rembobiner la musique courante avant de jouer la précédente"
    override val playerMinimisedProgressionTitle = "Afficher la progression de la musique sur le lecteur minimisé"
    override val soulMixSettingsTitle = "Total de musiques récupérées de chaque dossier pour le Soul Mix"
    override val usedFoldersTitle = "Dossiers utilisés"
    override val usedFoldersText = "Définissez les dossiers utilisés par l'application"
    override val addMusicsTitle = "Ajouter des musiques"
    override val addMusicsText = "Ajouter des nouvelles musiques de votre téléphone dans l'application"
    override val fetchingFolders = "Récupération des dossiers"
    override val deletingMusicsFromUnselectedFolders = "Suppression des musiques des dossiers désélectionnés…"

    override val dynamicThemeTitle = "Thème dynamique"
    override val dynamicThemeText = "Thème de couleur global basé sur la pochette d'album de la musique jouée"
    override val systemThemeTitle = "Thème du système"
    override val systemThemeText = "Thème de couleur global basé sur le mode de couleur de votre système"

    override val leadDeveloper = "Développeur principal"
    override val developersTitle = "Développeurs"
    override val developersText = "Les développeurs derrière le projet Soul Searching"
    override val versionNameTitle = "Nom de la version de l'application"

    override val noNewMusics = "Aucune nouvelle musique à ajouter !"
    override val savingNewMusics = "Sauvegarde des nouvelles musiques…"
    override val songsSaved = "Musiques sauvegardées !"
    override val searchForNewSongs = "Rechercher de nouvelles musiques"

    override val appMigration = "Mise à jour des données de l'application"

    override val multipleArtistsTitle = "Musiques avec plusieurs artistes"
    override val multipleArtistsText =
        "Des musiques avec plusieurs artistes ont été trouvées par l'application. " +
                "Choisissez si vous voulez diviser ces artistes en plusieurs ou les conserver comme un seul artiste."
    override val multipleArtistsSelectionTitle = "Artistes sélectionnés à diviser :"
    override val noMultipleArtists = "Aucun artiste à diviser"

    override val multipleSelection = "Sélection multiple"

    override val fieldCannotBeEmpty = "Ce champ ne peut pas être vide"
    override val fieldMustBeANumber = "Ce champ doit être un nombre"

    override val playerVolume = "Volume du lecteur"

    override val anErrorOccurred = "Une erreur est survenue"
    override val albumDoesNotExists = "L'album n'existe pas"
    override val artistDoesNotExists = "L'artiste n'existe pas"
    override val playlistDoesNotExists = "La playlist n'existe pas"
    override val folderDoesNotExists = "Le dossier n'existe pas"
    override val monthPlaylistDoesNotExists = "La playlist de mois n'existe pas"

    override val artistDetailTitle = "Artiste"
    override val monthDetailTitle = "Mois"
    override val folderDetailTitle = "Dossier"

    override val elementDetailEdit = "Modifier"
    override val elementDetailPlay = "Lire"
    override val elementDetailShuffle = "Aléatoire"
    override val elementDetailTitles = "Titres"

    override fun musics(total: Int): String {
        return when (total) {
            1 -> "1 musique"
            0 -> "Aucune musique"
            else -> "$total musiques"
        }
    }

    override fun deletedMusicsAutomatically(total: Int): String =
        when (total) {
            0 -> "Aucune musique supprimée"
            1 -> "1 musique a été supprimée car elle n'existe plus sur l'appareil"
            else -> "$total musiques ont été supprimées car elles n'existent plus sur l'appareil"
        }

    override fun plays(total: Int): String =
        when (total) {
            0 -> "Aucune écoutes"
            1 -> "1 écoute"
            else -> "$total écoutes"
        }

    override fun fetchingMusicsFrom(path: String): String =
        "Récupération de musiques dans le dossier : $path"

    override fun selectedElements(total: Int): String =
        when (total) {
            0 -> "Aucun élément sélectionné"
            1 -> "Un élément sélectionné"
            else -> "$total éléments sélectionnés"
        }

    override fun newReleaseAvailableText(releaseName: String): String =
        "Une nouvelle version est disponible, prête à être téléchargée : $releaseName"

    override fun artistCoverMethodExampleTitle(artist: String): String =
        "Exemple de chemin avec l'artiste $artist :"
}