package com.github.enteraname74.soulsearching.coreui.screen

import androidx.compose.foundation.background
import androidx.compose.foundation.layout.Box
import androidx.compose.foundation.layout.fillMaxSize
import androidx.compose.runtime.Composable
import androidx.compose.ui.Modifier
import androidx.compose.ui.graphics.Color
import com.github.enteraname74.soulsearching.coreui.theme.color.SoulSearchingColorTheme

@Composable
fun SoulScreen(
    modifier: Modifier = Modifier,
    containerColor: Color = SoulSearchingColorTheme.colorScheme.primary,
    content: @Composable () -> Unit
) {
    Box(
        modifier = Modifier
            .fillMaxSize()
            .background(
                color = containerColor,
            )
            .then(modifier)
    ) {
        content()
    }
}