// Copyright (c) 2024, the Dart project authors.  Please see the AUTHORS file
// for details. All rights reserved. Use of this source code is governed by a
// BSD-style license that can be found in the LICENSE file.

import 'common/service_test_common.dart';
import 'common/test_helper.dart';

const String shortFile = 'break_on_equals_signs_of_assignments_test.dart';

// AUTOGENERATED START
//
// Update these constants by running:
//
// dart pkg/vm_service/test/update_line_numbers.dart pkg/vm_service/test/break_on_equals_signs_of_assignments_test.dart
//
const LINE_A = 38;
const LINE_B = 40;
const LINE_C = 42;
const LINE_D = 44;
const LINE_E = 46;
const LINE_F = 48;
const LINE_G = 51;
// AUTOGENERATED END

class E {
  int x = 0;
}

void testeeMain() {
  // In https://dartbug.com/56932, it was brought up that requesting a
  // breakpoint on line A below used to result in a breakpoint getting set on
  // the next line, but after we made some changes to breakpoint resolution
  // (https://github.com/dart-lang/sdk/commit/cdacfd80f1f5e2940056dbc32e9a8faaf1928db1),
  // requesting a breakpoint line A resulted in no breakpoint getting set. After
  // having a discussion on that issue, we decided to mark the `=` tokens within
  // assignment statements as locations where breakpoints can be set, and this
  // test ensures that the marking is happening correctly.
  var a = // LINE_A
      123;
  late var b = // LINE_B
      123;
  final c = // LINE_C
      123;
  late final d = // LINE_D
      123;
  a = // LINE_E
      456;
  b = // LINE_F
      456;
  final e = E();
  e.x = // LINE_G
      123;

  print(a);
  print(b);
  print(c);
  print(d);
  print(e);
}

List<String> stops = [];

const List<String> expected = [
  '$shortFile:$LINE_A:9', // on '='
  '$shortFile:$LINE_B:14', // on '='
  '$shortFile:$LINE_C:11', // on '='
  '$shortFile:$LINE_D:16', // on '='
  // Lines E, F and G contain assignment expressions instead of assignment
  // statements, so breakpoints get resolved on the LHS of them instead of on
  // the '=' tokens.
  '$shortFile:$LINE_E:3', // on 'a'
  '$shortFile:$LINE_F:3', // on 'b'
  '$shortFile:$LINE_G:5', // on 'x'
];

final tests = <IsolateTest>[
  hasPausedAtStart,
  setBreakpointAtLine(LINE_A),
  setBreakpointAtLine(LINE_B),
  setBreakpointAtLine(LINE_C),
  setBreakpointAtLine(LINE_D),
  setBreakpointAtLine(LINE_E),
  setBreakpointAtLine(LINE_F),
  setBreakpointAtLine(LINE_G),
  resumeProgramRecordingStops(stops, false),
  checkRecordedStops(stops, expected),
];

Future<void> main([args = const <String>[]]) => runIsolateTests(
      args,
      tests,
      shortFile,
      testeeConcurrent: testeeMain,
      pauseOnStart: true,
      pauseOnExit: true,
    );
