# Examples

## Single Variable Functions

```dart
import "package:function_tree/function_tree.dart";

void main() {
  final f = "sin(2 * x)".toSingleVariableFunction(),
      g = "2 * cos(x)".toSingleVariableFunction(),
      pi = "pi".interpret(),
      width = 30,
      min = -2,
      max = 2,
      spaces = (num y) => ((y - min) / (max - min) * width).round();

  for (var x = 0.0; x < 2 * pi; x += 0.2) {
    final chs = [for (var _ = 0; _ <= width; _++) " "];
    chs[spaces(f(x))] = "+";
    chs[spaces(g(x))] = ":";
    chs[spaces(0)] = "|";
    print(chs.join());
  }
}
```

Output:

```text
               |              :
               |  +           :
               |    +        : 
               |      +    :   
               |      +  :     
               |      +:       
               |    :          
               |  :            
               |               
            :  |               
         :     |               
      : +      |               
    :   +      |               
  :     +      |               
 :        +    |               
:            + |               
:              |+              
:              |   +           
  :            |     +         
   :           |      +        
     :         |      +        
        :      |     +         
          :    |   +           
             : | +             
              +|:              
           +   |   :           
         +     |      :        
        +      |         :     
        +      |           :   
         +     |            :  
           +   |             : 
              +|              :
```

## Multi-Variable Functions

```dart
import "package:function_tree/function_tree.dart";

void main() {
  final expression = "sqrt(x^2 + x*y + y^2) * log(2, abs(x) + 2) / 1.5",
      f = expression.toMultiVariableFunction(["x", "y"]),
      width = 30,
      from = -3,
      to = 3,
      by = (to - from) / width,
      map = (num t) => from + t * by,
      ch = (num result) => switch (result) {
            > 3 => "█",
            > 2.5 => "▓",
            > 1.5 => "▒",
            > 0.5 => "·",
            _ => " "
          };

  print([
    for (var y = 0; y < width; y++)
      [
        for (var x = 0; x < width; x++) ch(f({"x": map(x), "y": map(y)}))
      ].join("")
  ].join("\n"));
}
```

Output:

```text
█████████████▓▒░▒▒▓▓▓▓████████
████████████▓▓▒░▒▒▒▒▓▓▓▓██████
████████████▓▒▒░░▒▒▒▒▓▓▓▓█████
███████████▓▓▒░░░░░▒▒▒▒▓▓▓████
██████████▓▓▒▒░·░░░░▒▒▒▒▓▓████
██████████▓▒▒░░··░░░░░▒▒▒▓▓███
█████████▓▓▒░░·····░░░░▒▒▓▓███
█████████▓▒▒░░·······░░░▒▒▓███
████████▓▓▒░░·········░░▒▒▓▓██
███████▓▓▒▒░··········░░▒▒▓▓██
███████▓▒▒░░···········░▒▒▓▓██
██████▓▓▒░░············░▒▒▓███
██████▓▒▒░·····   ·····░▒▒▓███
█████▓▓▒░░····     ····░▒▒▓███
█████▓▒▒░····      ···░░▒▓▓███
█████▓▒░░····     ····░░▒▓████
████▓▓▒░░···      ····░▒▒▓████
████▓▒▒░····     ····░░▒▓▓████
████▓▒▒░·····   ·····░▒▒▓█████
████▓▒▒░············░░▒▓▓█████
███▓▓▒▒░···········░░▒▒▓██████
███▓▓▒▒░░··········░▒▒▓▓██████
███▓▓▒▒░░·········░░▒▓▓███████
████▓▒▒░░░·······░░▒▒▓████████
████▓▓▒▒░░░░·····░░▒▓▓████████
████▓▓▒▒▒░░░░░··░░▒▒▓█████████
█████▓▓▒▒▒▒░░░░·░▒▒▓▓█████████
█████▓▓▓▒▒▒▒░░░░░▒▓▓██████████
██████▓▓▓▓▒▒▒▒░░▒▒▓███████████
███████▓▓▓▓▒▒▒▒░▒▓▓███████████
```
