/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.stereo;

import java.util.Map;
import org.openscience.cdk.annotations.TestClass;
import org.openscience.cdk.annotations.TestMethod;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IChemObjectBuilder;
import org.openscience.cdk.interfaces.IDoubleBondStereochemistry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@TestClass(value="org.openscience.cdk.stereo.DoubleBondStereochemistryTest")
public class DoubleBondStereochemistry
implements IDoubleBondStereochemistry {
    private IDoubleBondStereochemistry.Conformation stereo;
    private IBond[] ligandBonds;
    private IBond stereoBond;
    private IChemObjectBuilder builder;

    public DoubleBondStereochemistry(IBond stereoBond, IBond[] ligandBonds, IDoubleBondStereochemistry.Conformation stereo) {
        if (ligandBonds.length > 2) {
            throw new IllegalArgumentException("expected two ligand bonds");
        }
        this.stereoBond = stereoBond;
        this.ligandBonds = ligandBonds;
        this.stereo = stereo;
    }

    @TestMethod(value="testBuilder")
    public void setBuilder(IChemObjectBuilder builder) {
        this.builder = builder;
    }

    @TestMethod(value="testBuilder")
    public IChemObjectBuilder getBuilder() {
        return this.builder;
    }

    @TestMethod(value="testGetBonds")
    public IBond[] getBonds() {
        IBond[] arrayCopy = new IBond[2];
        System.arraycopy(this.ligandBonds, 0, arrayCopy, 0, 2);
        return arrayCopy;
    }

    @TestMethod(value="testGetStereoBond")
    public IBond getStereoBond() {
        return this.stereoBond;
    }

    @TestMethod(value="testGetStereo")
    public IDoubleBondStereochemistry.Conformation getStereo() {
        return this.stereo;
    }

    @TestMethod(value="testMap_Map_Map,testMap_Null_Map,testMap_Map_Map_NullElement,testMap_Map_Map_EmptyMapping")
    public IDoubleBondStereochemistry map(Map<IAtom, IAtom> atoms, Map<IBond, IBond> bonds) {
        if (bonds == null) {
            throw new IllegalArgumentException("null bond mapping provided");
        }
        IBond doubleBond = this.stereoBond != null ? bonds.get(this.stereoBond) : null;
        IBond[] connected = new IBond[this.ligandBonds.length];
        for (int i = 0; i < connected.length; ++i) {
            if (this.ligandBonds[i] == null) continue;
            connected[i] = bonds.get(this.ligandBonds[i]);
        }
        return new DoubleBondStereochemistry(doubleBond, connected, this.stereo);
    }
}

