/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.graph;

import com.google.common.base.Preconditions;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.Multimap;
import com.google.common.collect.TreeMultimap;
import com.google.common.primitives.Ints;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import org.openscience.cdk.annotations.TestClass;
import org.openscience.cdk.annotations.TestMethod;
import org.openscience.cdk.graph.ShortestPaths;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@TestClass(value="org.openscience.cdk.graph.InitialCyclesTest")
final class InitialCycles {
    private final int[][] graph;
    private final int[] ordering;
    private final Multimap<Integer, Cycle> cycles = TreeMultimap.create();
    private final BiMap<Edge, Integer> edges;
    private static final int DEFAULT_DEGREE = 4;
    private int nDeg2Vertices;
    private final boolean biconnected;

    InitialCycles(int[][] graph) {
        this(graph, false);
    }

    private InitialCycles(int[][] graph, boolean biconnected) {
        this.graph = (int[][])Preconditions.checkNotNull((Object)graph, (Object)"no graph provided");
        this.biconnected = biconnected;
        this.ordering = this.ordering(graph);
        this.edges = HashBiMap.create((int)graph.length);
        int n = graph.length;
        for (int v = 0; v < n; ++v) {
            for (int w : graph[v]) {
                if (w <= v) continue;
                Edge edge = new Edge(v, w);
                this.edges.put((Object)edge, (Object)this.edges.size());
            }
        }
        this.compute();
    }

    @TestMethod(value="graph")
    int[][] graph() {
        return this.graph;
    }

    @TestMethod(value="lengths_K4,lengths_naphthalene,lengths_anthracene,lengths_bicyclo,lengths_cyclophane")
    Iterable<Integer> lengths() {
        return this.cycles.keySet();
    }

    @TestMethod(value="cyclesOfLength_empty,cycles_K4")
    Collection<Cycle> cyclesOfLength(int length) {
        return this.cycles.get((Object)length);
    }

    @TestMethod(value="cycles_K4,cycles_naphthalene,cycles_anthracene,cycles_bicyclo,cycles_cyclophane")
    Collection<Cycle> cycles() {
        return this.cycles.values();
    }

    @TestMethod(value="numberOfCycles_K4")
    int numberOfCycles() {
        return this.cycles.size();
    }

    @TestMethod(value="numberOfEdges_K4")
    int numberOfEdges() {
        return this.edges.size();
    }

    @TestMethod(value="edge_K4")
    Edge edge(int i) {
        return (Edge)this.edges.inverse().get((Object)i);
    }

    @TestMethod(value="indexOfEdge_K4")
    int indexOfEdge(int u, int v) {
        return (Integer)this.edges.get((Object)new Edge(u, v));
    }

    @TestMethod(value="toEdgeVector_K4")
    BitSet toEdgeVector(int[] path) {
        BitSet incidence = new BitSet(this.edges.size());
        int len = path.length - 1;
        for (int i = 0; i < len; ++i) {
            incidence.set(this.indexOfEdge(path[i], path[i + 1]));
        }
        return incidence;
    }

    private void compute() {
        int first;
        int n = this.graph.length;
        int[] s = new int[n];
        int[] vertices = new int[n];
        for (int v = 0; v < n; ++v) {
            vertices[this.ordering[v]] = v;
        }
        for (int i = first = this.biconnected && this.nDeg2Vertices < n ? this.nDeg2Vertices : 2; i < n; ++i) {
            int r = vertices[i];
            ShortestPaths pathsFromR = new ShortestPaths(this.graph, null, r, this.ordering);
            for (int j = 0; j < i; ++j) {
                int y = vertices[j];
                if (!pathsFromR.isPrecedingPathTo(y)) continue;
                int sizeOfS = 0;
                for (int z : this.graph[y]) {
                    int distToY;
                    if (!pathsFromR.isPrecedingPathTo(z)) continue;
                    int distToZ = pathsFromR.distanceTo(z);
                    if (distToZ + 1 == (distToY = pathsFromR.distanceTo(y))) {
                        s[sizeOfS++] = z;
                        continue;
                    }
                    if (distToZ != distToY || this.ordering[z] >= this.ordering[y]) continue;
                    int[] pathToY = pathsFromR.pathTo(y);
                    int[] pathToZ = pathsFromR.pathTo(z);
                    if (!InitialCycles.singletonIntersect(pathToZ, pathToY)) continue;
                    OddCycle cycle = new OddCycle(pathsFromR, pathToY, pathToZ);
                    this.add(cycle);
                }
                for (int k = 0; k < sizeOfS; ++k) {
                    for (int l = k + 1; l < sizeOfS; ++l) {
                        int[] pathToQ;
                        int[] pathToP = pathsFromR.pathTo(s[k]);
                        if (!InitialCycles.singletonIntersect(pathToP, pathToQ = pathsFromR.pathTo(s[l]))) continue;
                        EvenCycle cycle = new EvenCycle(pathsFromR, pathToP, y, pathToQ);
                        this.add(cycle);
                    }
                }
            }
        }
    }

    private void add(Cycle cycle) {
        this.cycles.put((Object)cycle.length(), (Object)cycle);
    }

    private int[] ordering(int[][] graph) {
        int v;
        int n = graph.length;
        int[] order = new int[n];
        int[] count = new int[5];
        for (v = 0; v < n; ++v) {
            int key = graph[v].length + 1;
            if (key >= count.length) {
                count = Arrays.copyOf(count, key * 2);
            }
            int n2 = key;
            count[n2] = count[n2] + 1;
        }
        for (int i = 1; i < count.length; ++i) {
            int n3 = i;
            count[n3] = count[n3] + count[i - 1];
        }
        for (v = 0; v < n; ++v) {
            int n4 = graph[v].length;
            count[n4] = count[n4] + 1;
        }
        this.nDeg2Vertices = count[2];
        return order;
    }

    @TestMethod(value="singleton,startOverlap,endOverlap,middleOverlap")
    static boolean singletonIntersect(int[] p, int[] q) {
        int n = p.length;
        for (int i = 1; i < n; ++i) {
            if (p[i] != q[i]) continue;
            return false;
        }
        return true;
    }

    @TestMethod(value="join")
    static int[] join(int[] pathToY, int[] pathToZ) {
        int[] path = Arrays.copyOf(pathToY, pathToY.length + pathToZ.length);
        int j = path.length - 1;
        for (int i = 0; i < pathToZ.length; ++i) {
            path[j--] = pathToZ[i];
        }
        return path;
    }

    @TestMethod(value="joinWith")
    static int[] join(int[] pathToP, int y, int[] pathToQ) {
        int[] path = Arrays.copyOf(pathToP, 1 + pathToQ.length + pathToQ.length);
        path[pathToP.length] = y;
        int j = path.length - 1;
        for (int i = 0; i < pathToQ.length; ++i) {
            path[j--] = pathToQ[i];
        }
        return path;
    }

    @TestMethod(value="bioconnected_simpleCycle")
    static InitialCycles ofBiconnectedComponent(int[][] graph) {
        return new InitialCycles(graph, true);
    }

    static final class Edge {
        private final int v;
        private final int w;

        Edge(int v, int w) {
            this.v = v;
            this.w = w;
        }

        @TestMethod(value="edgeIsTransitive")
        public boolean equals(Object o) {
            Edge that = (Edge)o;
            return this.v == that.v && this.w == that.w || this.v == that.w && this.w == that.v;
        }

        @TestMethod(value="edgeIsTransitive")
        public int hashCode() {
            return this.v ^ this.w;
        }

        @TestMethod(value="edgeToString")
        public String toString() {
            return "{" + this.v + ", " + this.w + "}";
        }
    }

    class OddCycle
    extends Cycle {
        int y;
        int z;

        OddCycle(ShortestPaths paths, int[] pathToY, int[] pathToZ) {
            super(paths, InitialCycles.join(pathToY, pathToZ));
            this.y = pathToY[pathToY.length - 1];
            this.z = pathToZ[pathToY.length - 1];
        }

        BitSet edges(int[] path) {
            return InitialCycles.this.toEdgeVector(path);
        }

        @TestMethod(value="cycles_family_odd")
        int[][] family() {
            int[][] pathsToY = this.paths.pathsTo(this.y);
            int[][] pathsToZ = this.paths.pathsTo(this.z);
            int[][] paths = new int[this.sizeOfFamily()][0];
            int i = 0;
            for (int[] pathToY : pathsToY) {
                for (int[] pathToZ : pathsToZ) {
                    paths[i++] = InitialCycles.join(pathToY, pathToZ);
                }
            }
            return paths;
        }

        int sizeOfFamily() {
            return this.paths.nPathsTo(this.y) * this.paths.nPathsTo(this.z);
        }
    }

    class EvenCycle
    extends Cycle {
        int p;
        int q;
        int y;

        EvenCycle(ShortestPaths paths, int[] pathToP, int y, int[] pathToQ) {
            super(paths, InitialCycles.join(pathToP, y, pathToQ));
            this.p = pathToP[pathToP.length - 1];
            this.q = pathToQ[pathToQ.length - 1];
            this.y = y;
        }

        BitSet edges(int[] path) {
            return InitialCycles.this.toEdgeVector(path);
        }

        @TestMethod(value="cycles_family_even")
        int[][] family() {
            int[][] pathsToP = this.paths.pathsTo(this.p);
            int[][] pathsToQ = this.paths.pathsTo(this.q);
            int[][] paths = new int[this.sizeOfFamily()][0];
            int i = 0;
            for (int[] pathToP : pathsToP) {
                for (int[] pathToQ : pathsToQ) {
                    paths[i++] = InitialCycles.join(pathToP, this.y, pathToQ);
                }
            }
            return paths;
        }

        int sizeOfFamily() {
            return this.paths.nPathsTo(this.p) * this.paths.nPathsTo(this.q);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static abstract class Cycle
    implements Comparable<Cycle> {
        private int[] path;
        ShortestPaths paths;
        BitSet edgeVector;

        Cycle(ShortestPaths paths, int[] path) {
            this.path = path;
            this.paths = paths;
            this.edgeVector = this.edges(path);
        }

        abstract BitSet edges(int[] var1);

        BitSet edgeVector() {
            return this.edgeVector;
        }

        int[] path() {
            return this.path;
        }

        abstract int[][] family();

        abstract int sizeOfFamily();

        int length() {
            return this.path.length - 1;
        }

        @Override
        public int compareTo(Cycle that) {
            return Ints.lexicographicalComparator().compare(this.path, that.path);
        }
    }
}

