/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.config;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.List;
import org.openscience.cdk.annotations.TestClass;
import org.openscience.cdk.annotations.TestMethod;
import org.openscience.cdk.config.IAtomTypeConfigurator;
import org.openscience.cdk.config.atomtypes.OWLAtomTypeReader;
import org.openscience.cdk.interfaces.IAtomType;
import org.openscience.cdk.interfaces.IChemObjectBuilder;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@TestClass(value="org.openscience.cdk.config.OWLBasedAtomTypeConfiguratorTest")
public class OWLBasedAtomTypeConfigurator
implements IAtomTypeConfigurator {
    private InputStream ins = null;
    private static ILoggingTool logger = LoggingToolFactory.createLoggingTool(OWLBasedAtomTypeConfigurator.class);

    @TestMethod(value="testCDKBasedAtomTypeConfigurator")
    public OWLBasedAtomTypeConfigurator() {
    }

    @Override
    @TestMethod(value="testSetInputStream_InputStream")
    public void setInputStream(InputStream ins) {
        this.ins = ins;
    }

    @Override
    @TestMethod(value="testReadAtomTypes_IChemObjectBuilder")
    public List<IAtomType> readAtomTypes(IChemObjectBuilder builder) throws IOException {
        if (this.ins == null) {
            throw new IOException("There was a problem getting an input stream");
        }
        OWLAtomTypeReader reader = new OWLAtomTypeReader(new InputStreamReader(this.ins));
        List<IAtomType> atomTypes = reader.readAtomTypes(builder);
        for (IAtomType atomType : atomTypes) {
            if (atomType != null) continue;
            logger.debug((Object)"Expecting an object but found null!");
        }
        return atomTypes;
    }
}

