/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk;

import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.openscience.cdk.annotations.TestClass;
import org.openscience.cdk.annotations.TestMethod;
import org.openscience.cdk.interfaces.ICDKObject;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@TestClass(value="org.openscience.cdk.DynamicFactoryTest")
public class DynamicFactory {
    private static final ILoggingTool logger = LoggingToolFactory.createLoggingTool(DynamicFactory.class);
    private static final Class<?>[] EMPTY_CLASS_ARRAY = new Class[0];
    private static final Map<Class<?>, Class<?>> BOXED_EQUIVALENT = new HashMap(20);
    private final Map<ConstructorKey, Creator<?>> cache;
    private final ConstructorLookup lookup;
    private final InterfaceProvider interfaceProvider;
    private final Object lock = new Object();

    public DynamicFactory(InterfaceProvider interfaceProvider, int n) {
        if (n < 0) {
            throw new IllegalArgumentException("cannot create factory with negative size");
        }
        if (interfaceProvider == null) {
            throw new IllegalArgumentException("null interface provider");
        }
        this.interfaceProvider = interfaceProvider;
        int size = n > 3 ? n + n / 3 : n + 1;
        this.cache = new HashMap(size * 2);
        this.lookup = new ConstructorLookup(size);
    }

    public DynamicFactory(int n) {
        this(new DefaultInterfaceProvider(), n);
    }

    private boolean isCDKInterface(Class<?> c) {
        return ICDKObject.class.isAssignableFrom(c) && c.isInterface();
    }

    private boolean isConcrete(Class<?> c) {
        return !c.isInterface() && !Modifier.isAbstract(c.getModifiers());
    }

    @TestMethod(value="testRegister,testRegister_NonCDKInterface")
    public <T extends ICDKObject> boolean register(Class<? extends T> impl) {
        if (!this.isConcrete(impl)) {
            throw new IllegalArgumentException("non-concrete implementation provided");
        }
        boolean registered = Boolean.FALSE;
        for (Class<?> c : this.interfaceProvider.getInterfaces(impl)) {
            if (!this.isCDKInterface(c)) continue;
            Class<?> intf = c;
            registered = this.register(intf, impl) || registered;
        }
        return registered;
    }

    @TestMethod(value="testRegister_Explicit,testRegister_PrivateConstructor,testRegister_Duplicate")
    public <T extends ICDKObject> boolean register(Class<T> intf, Class<? extends T> impl) {
        return this.register(intf, impl, null);
    }

    @TestMethod(value="testRegister_WithModifier")
    public <S extends ICDKObject, T extends S> boolean register(Class<S> intf, Class<T> impl, CreationModifier<T> modifier) {
        if (!this.isConcrete(impl)) {
            throw new IllegalArgumentException("attempt to register non-concrete class");
        }
        if (!intf.isInterface()) {
            throw new IllegalArgumentException("attempt to register a non-interface interface: " + intf.getSimpleName());
        }
        boolean registered = Boolean.FALSE;
        for (Constructor<?> untyped : impl.getConstructors()) {
            Constructor<?> typed = untyped;
            registered = this.register(intf, typed, modifier) || registered;
        }
        if (registered) {
            logger.debug((Object)("registered '" + intf.getSimpleName() + "' with '" + impl.getSimpleName() + "' implementation"));
        } else {
            logger.debug((Object)("could not registered '" + intf.getSimpleName() + "' with '" + impl.getSimpleName() + "' implementation"));
        }
        return registered;
    }

    @TestMethod(value="testRegister_Constructor")
    public <S extends ICDKObject, T extends S> boolean register(Class<S> intf, Constructor<T> constructor) {
        return this.register(intf, constructor, null);
    }

    @TestMethod(value="testRegister_Constructor_Modifier")
    public <S extends ICDKObject, T extends S> boolean register(Class<S> intf, Constructor<T> constructor, CreationModifier<T> modifier) {
        if (!Modifier.isPublic(constructor.getModifiers())) {
            return Boolean.FALSE;
        }
        return this.register(DynamicFactory.key(intf, constructor), constructor, modifier) != null;
    }

    private <T> Creator<T> register(ConstructorKey key, Constructor<T> constructor, CreationModifier<T> modifier) {
        Creator creator = new ReflectionCreator(constructor);
        if (modifier != null) {
            creator = new ModifiedCreator(creator, modifier);
        }
        return this.register(key, creator);
    }

    @TestMethod(value="testOfClass_Wrapping")
    public <T> Creator<T> register(ConstructorKey key, Creator<T> creator) {
        if (creator == null) {
            return null;
        }
        if (this.cache.containsKey(key)) {
            throw new IllegalArgumentException("cannot register " + key + " suppressed " + this.cache.get(key));
        }
        this.lookup.put(key.intf(), key);
        this.cache.put(key, creator);
        return creator;
    }

    private static ConstructorKey key(Class<?> intf, Constructor<?> constructor) {
        return DynamicFactory.key(intf, constructor.getParameterTypes());
    }

    @TestMethod(value="testKey_Default,testKey_Parameters,testKey_ArrayParameters,testKey_Primitives")
    public static ConstructorKey key(Class<?> intf, Class<?> ... types) {
        return new ClassBasedKey(intf, DynamicFactory.convert(types));
    }

    private static Class<?>[] convert(Class<?>[] classes) {
        Class[] types = new Class[classes.length];
        for (int i = 0; i < types.length; ++i) {
            types[i] = DynamicFactory.convert(classes[i]);
        }
        return types;
    }

    private static Class<?> convert(Class<?> unboxed) {
        Class<?> boxed = BOXED_EQUIVALENT.get(unboxed);
        return boxed == null ? unboxed : boxed;
    }

    @TestMethod(value="testOfClass_WithParams,testOfClass_Wrapping")
    public <T extends ICDKObject> T ofClass(Class<T> intf, Object ... objects) {
        try {
            if (!intf.isInterface()) {
                throw new IllegalArgumentException("expected interface, got " + intf.getClass());
            }
            Creator<T> constructor = this.get(new ObjectBasedKey(intf, objects));
            return (T)((ICDKObject)constructor.create(objects));
        }
        catch (InstantiationException e) {
            throw new IllegalArgumentException("unable to instantiate chem object: ", e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException("constructor is not accessible: ", e);
        }
        catch (InvocationTargetException e) {
            throw new IllegalArgumentException("invocation target exception: ", e);
        }
    }

    @TestMethod(value="testOfClass")
    public <T extends ICDKObject> T ofClass(Class<T> intf) {
        try {
            if (!intf.isInterface()) {
                throw new IllegalArgumentException("expected interface, got " + intf.getClass());
            }
            Creator<T> creator = this.get(new ClassBasedKey(intf, EMPTY_CLASS_ARRAY));
            return (T)((ICDKObject)creator.create(null));
        }
        catch (InstantiationException e) {
            throw new IllegalArgumentException("unable to instantiate chem object: ", e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException("constructor is not accessible: ", e);
        }
        catch (InvocationTargetException e) {
            throw new IllegalArgumentException("invocation target exception: ", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> Creator<T> get(ConstructorKey key) {
        Creator<Object> creator = this.cache.get(key);
        if (creator != null) {
            return creator;
        }
        Object object = this.lock;
        synchronized (object) {
            creator = this.cache.get(key);
            if (creator == null) {
                creator = this.find(key);
                creator = this.register(key, creator);
            }
        }
        return creator;
    }

    private <T> Creator<T> find(final ConstructorKey key) {
        for (ConstructorKey candidate : this.lookup.getCandidates(key)) {
            if (!key.isAssignable(candidate)) continue;
            return this.get(candidate);
        }
        if (key.isUniform()) {
            Object types = Array.newInstance(key.type(0), 0);
            ObjectBasedKey alt = new ObjectBasedKey(key.intf(), new Object[]{types});
            Creator<T> creator = this.get(alt);
            return new ArrayWrapCreator<T>(creator);
        }
        logger.debug((Object)("no instance handler found for " + key));
        return new Creator<T>(){

            @Override
            public T create(Object[] objects) {
                throw new IllegalArgumentException(DynamicFactory.this.getSuggestionMessage(key));
            }

            @Override
            public Class<T> getDeclaringClass() {
                throw new IllegalArgumentException("missing declaring class");
            }
        };
    }

    @TestMethod(value="testImplementationsOf")
    public <T extends ICDKObject> Set<Class<?>> implementorsOf(Class<T> intf) {
        HashSet implementations = new HashSet(5);
        for (ConstructorKey key : this.lookup.getConstructors(intf)) {
            implementations.add(this.get(key).getDeclaringClass());
        }
        return implementations;
    }

    @TestMethod(value="testSuggest")
    public Iterator<ConstructorKey> suggest(Class<?> intf) {
        return this.lookup.getConstructors(intf).iterator();
    }

    private String getSuggestionMessage(ConstructorKey key) {
        StringBuilder sb = new StringBuilder(200);
        sb.append("No constructor found for '").append(key);
        sb.append("' candidates are: ");
        Iterator<ConstructorKey> iterator = this.suggest(key.intf());
        while (iterator.hasNext()) {
            sb.append(iterator.next());
            if (!iterator.hasNext()) continue;
            sb.append(", ");
        }
        return sb.toString();
    }

    static {
        BOXED_EQUIVALENT.put(Integer.TYPE, Integer.class);
        BOXED_EQUIVALENT.put(Byte.TYPE, Byte.class);
        BOXED_EQUIVALENT.put(Short.TYPE, Short.class);
        BOXED_EQUIVALENT.put(Long.TYPE, Long.class);
        BOXED_EQUIVALENT.put(Boolean.TYPE, Boolean.class);
        BOXED_EQUIVALENT.put(Float.TYPE, Float.class);
        BOXED_EQUIVALENT.put(Double.TYPE, Double.class);
        BOXED_EQUIVALENT.put(Character.TYPE, Character.class);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ReflectionCreator<T>
    implements Creator<T> {
        private final Constructor<T> constructor;

        private ReflectionCreator(Constructor<T> constructor) {
            this.constructor = constructor;
        }

        @Override
        public T create(Object[] objects) throws InvocationTargetException, IllegalAccessException, InstantiationException {
            return this.constructor.newInstance(objects);
        }

        @Override
        public Class<T> getDeclaringClass() {
            return this.constructor.getDeclaringClass();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ArrayWrapCreator<T>
    implements Creator<T> {
        private final Creator<T> parent;

        public ArrayWrapCreator(Creator<T> parent) {
            this.parent = parent;
        }

        @Override
        public T create(Object[] objects) throws InvocationTargetException, IllegalAccessException, InstantiationException {
            return this.parent.create(new Object[]{objects});
        }

        @Override
        public Class<T> getDeclaringClass() {
            return this.parent.getDeclaringClass();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class BasicCreator<T>
    implements Creator<T> {
        private final Class<T> c;

        public BasicCreator(Class<T> c) {
            this.c = c;
        }

        @Override
        public Class<T> getDeclaringClass() {
            return this.c;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Creator<T> {
        public T create(Object[] var1) throws InvocationTargetException, IllegalAccessException, InstantiationException;

        public Class<T> getDeclaringClass();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ModifiedCreator<T>
    implements Creator<T> {
        private final CreationModifier<T> modifier;
        private final Creator<T> parent;

        private ModifiedCreator(Creator<T> parent, CreationModifier<T> modifier) {
            this.parent = parent;
            this.modifier = modifier;
        }

        @Override
        public T create(Object[] objects) throws InvocationTargetException, IllegalAccessException, InstantiationException {
            T instance = this.parent.create(objects);
            this.modifier.modify(instance);
            return instance;
        }

        @Override
        public Class<T> getDeclaringClass() {
            return this.parent.getDeclaringClass();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface CreationModifier<T> {
        public void modify(T var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface InterfaceProvider {
        public Class<?>[] getInterfaces(Class<?> var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class DefaultInterfaceProvider
    implements InterfaceProvider {
        protected DefaultInterfaceProvider() {
        }

        @Override
        public Class<?>[] getInterfaces(Class<?> c) {
            return c.getInterfaces();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class ConstructorKey
    implements Comparable<ConstructorKey> {
        public abstract Class<?> intf();

        public abstract Class<?> type(int var1);

        public abstract int n();

        public boolean equals(Object o) {
            if (o == null || !(o instanceof ConstructorKey)) {
                return false;
            }
            ConstructorKey that = (ConstructorKey)o;
            if (this.intf() != that.intf() || this.n() != that.n()) {
                return false;
            }
            for (int i = 0; i < this.n(); ++i) {
                if (this.type(i).equals(that.type(i))) continue;
                return false;
            }
            return true;
        }

        public boolean isUniform() {
            if (this.n() < 2) {
                return false;
            }
            Class<?> base = this.type(0);
            for (int i = 1; i < this.n(); ++i) {
                if (this.type(i) == base) continue;
                return false;
            }
            return true;
        }

        public int hashCode() {
            int result = this.intf().hashCode();
            for (int i = 0; i < this.n(); ++i) {
                result = 31 * result + this.type(i).hashCode();
            }
            return result;
        }

        @Override
        public int compareTo(ConstructorKey o) {
            if (this.n() != o.n()) {
                return this.n() > o.n() ? 1 : (this.n() < o.n() ? -1 : 0);
            }
            return this.toString().compareTo(o.toString());
        }

        public boolean isAssignable(ConstructorKey candidate) {
            for (int i = 0; i < candidate.n(); ++i) {
                if (candidate.type(i).isAssignableFrom(this.type(i))) continue;
                return false;
            }
            return true;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder(this.n() * 50);
            sb.append(this.intf().getSimpleName());
            sb.append("(");
            int max = this.n() - 1;
            for (int i = 0; i <= max; ++i) {
                sb.append(this.type(i).getSimpleName());
                if (i == max) continue;
                sb.append(", ");
            }
            sb.append(")");
            return sb.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ClassBasedKey
    extends ConstructorKey {
        private final Class<?> intf;
        private final Class<?>[] params;
        private final int n;

        private ClassBasedKey(Class<?> intf, Class<?>[] params) {
            this.intf = intf;
            this.params = params;
            this.n = params.length;
        }

        @Override
        public Class<?> intf() {
            return this.intf;
        }

        @Override
        public Class<?> type(int i) {
            return this.params[i];
        }

        @Override
        public int n() {
            return this.n;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ObjectBasedKey
    extends ConstructorKey {
        private final Class<?> intf;
        private final Object[] params;
        private final int n;

        private ObjectBasedKey(Class<?> intf, Object[] params) {
            this.intf = intf;
            this.params = params;
            this.n = params.length;
        }

        @Override
        public Class<?> intf() {
            return this.intf;
        }

        @Override
        public Class<?> type(int i) {
            if (this.params[i] == null) {
                throw new IllegalArgumentException("null param type");
            }
            return this.params[i].getClass();
        }

        @Override
        public int n() {
            return this.n;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ConstructorLookup {
        private final Map<Class<?>, Map<Integer, Set<ConstructorKey>>> keys;
        private final Set<ConstructorKey> EMPTY_KEY_SET = new HashSet<ConstructorKey>(0);

        public ConstructorLookup(int n) {
            this.keys = new HashMap(n);
        }

        public void put(Class<?> intf, ConstructorKey key) {
            int n;
            Map<Integer, Set<ConstructorKey>> map;
            if (!this.keys.containsKey(intf)) {
                this.keys.put(intf, new HashMap());
            }
            if (!(map = this.keys.get(intf)).containsKey(n = key.n())) {
                map.put(n, new HashSet(5));
            }
            map.get(n).add(key);
        }

        private Set<ConstructorKey> getConstructors(Class<?> intf) {
            Map<Integer, Set<ConstructorKey>> candidates = this.keys.get(intf);
            TreeSet<ConstructorKey> keys = new TreeSet<ConstructorKey>();
            if (candidates != null) {
                for (Map.Entry<Integer, Set<ConstructorKey>> e : candidates.entrySet()) {
                    keys.addAll((Collection<ConstructorKey>)e.getValue());
                }
            }
            return keys;
        }

        public Set<ConstructorKey> getCandidates(ConstructorKey key) {
            return this.getCandidates(key.intf(), key.n());
        }

        public Set<ConstructorKey> getCandidates(Class<?> intf, int n) {
            logger.debug((Object)("getting candidates for " + intf + " " + n));
            Map<Integer, Set<ConstructorKey>> map = this.keys.get(intf);
            if (map == null) {
                logger.debug((Object)("no keys for " + intf));
                logger.debug(this.keys);
                return this.EMPTY_KEY_SET;
            }
            Set<ConstructorKey> candidates = map.get(n);
            if (candidates == null) {
                logger.debug((Object)("no keys for parameter count" + n));
                logger.debug(map);
                return this.EMPTY_KEY_SET;
            }
            return candidates;
        }
    }
}

