--
-- Copyright 2024 The Android Open Source Project
--
-- Licensed under the Apache License, Version 2.0 (the "License");
-- you may not use this file except in compliance with the License.
-- You may obtain a copy of the License at
--
--     https://www.apache.org/licenses/LICENSE-2.0
--
-- Unless required by applicable law or agreed to in writing, software
-- distributed under the License is distributed on an "AS IS" BASIS,
-- WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
-- See the License for the specific language governing permissions and
-- limitations under the License.

-- Device specific device curves with 1D dependency (i.e. curve characteristics
-- are dependent only on one CPU policy). See go/wattson for more info.
CREATE PERFETTO TABLE _device_curves_1d AS
WITH
  data(device, policy, freq_khz, static, active, idle0, idle1) AS (
    SELECT
      *
    FROM (VALUES
      ("monaco", 0, 614400, 4.8, 9.41, 0.76, 0),
      ("monaco", 0, 864000, 6.68, 13.64, 0.83, 0),
      ("monaco", 0, 1363200, 12.6, 24.83, 1.1, 0),
      ("monaco", 0, 1708800, 18.39, 39.69, 1.34, 0),
      ("Tensor", 4, 400000, 0, 28.51, 5.24, 0),
      ("Tensor", 4, 553000, 0, 43.63, 6.1, 0),
      ("Tensor", 4, 696000, 0, 54.73, 6.76, 0),
      ("Tensor", 4, 799000, 0, 65.01, 6.89, 0),
      ("Tensor", 4, 910000, 0, 80.33, 7.61, 0),
      ("Tensor", 4, 1024000, 0, 92.91, 8.32, 0),
      ("Tensor", 4, 1197000, 0, 132.46, 8.09, 0),
      ("Tensor", 4, 1328000, 0, 146.82, 9.6, 0),
      ("Tensor", 4, 1491000, 0, 183.2, 11.58, 0),
      ("Tensor", 4, 1663000, 0, 238.55, 12.02, 0),
      ("Tensor", 4, 1836000, 0, 259.04, 16.11, 0),
      ("Tensor", 4, 1999000, 0, 361.98, 15.7, 0),
      ("Tensor", 4, 2130000, 0, 428.51, 18.94, 0),
      ("Tensor", 4, 2253000, 0, 527.05, 23.5, 0),
      ("Tensor", 6, 500000, 0, 87.31, 16.14, 0),
      ("Tensor", 6, 851000, 0, 170.29, 19.88, 0),
      ("Tensor", 6, 984000, 0, 207.43, 20.55, 0),
      ("Tensor", 6, 1106000, 0, 251.88, 23.06, 0),
      ("Tensor", 6, 1277000, 0, 306.57, 25.12, 0),
      ("Tensor", 6, 1426000, 0, 382.61, 26.76, 0),
      ("Tensor", 6, 1582000, 0, 465.9, 29.74, 0),
      ("Tensor", 6, 1745000, 0, 556.25, 32.87, 0),
      ("Tensor", 6, 1826000, 0, 613.51, 36.01, 0),
      ("Tensor", 6, 2048000, 0, 758.89, 41.67, 0),
      ("Tensor", 6, 2188000, 0, 874.03, 47.92, 0),
      ("Tensor", 6, 2252000, 0, 949.55, 51.07, 0),
      ("Tensor", 6, 2401000, 0, 1099.53, 57.42, 0),
      ("Tensor", 6, 2507000, 0, 1267.19, 66.14, 0),
      ("Tensor", 6, 2630000, 0, 1500.6, 82.36, 0),
      ("Tensor", 6, 2704000, 0, 1660.81, 95.11, 0),
      ("Tensor", 6, 2802000, 0, 1942.89, 121.43, 0),
      ("Tensor G4", 4, 357000, 0, 39.49, 6.1, 0),
      ("Tensor G4", 4, 578000, 0, 62.09, 6.5, 0),
      ("Tensor G4", 4, 648000, 0, 70.05, 6.93, 0),
      ("Tensor G4", 4, 787000, 0, 83.26, 7.31, 0),
      ("Tensor G4", 4, 910000, 0, 97.12, 7.55, 0),
      ("Tensor G4", 4, 1065000, 0, 116.15, 7.9, 0),
      ("Tensor G4", 4, 1221000, 0, 138.37, 8.47, 0),
      ("Tensor G4", 4, 1328000, 0, 155.59, 8.94, 0),
      ("Tensor G4", 4, 1418000, 0, 172.52, 9.37, 0),
      ("Tensor G4", 4, 1549000, 0, 200.69, 10.21, 0),
      ("Tensor G4", 4, 1795000, 0, 267.18, 11.89, 0),
      ("Tensor G4", 4, 1945000, 0, 317.06, 13.58, 0),
      ("Tensor G4", 4, 2130000, 0, 388.15, 16.02, 0),
      ("Tensor G4", 4, 2245000, 0, 430.4, 17.54, 0),
      ("Tensor G4", 4, 2367000, 0, 504.35, 20.92, 0),
      ("Tensor G4", 4, 2450000, 0, 579.03, 23.39, 0),
      ("Tensor G4", 4, 2600000, 0, 674.24, 31.07, 0),
      ("Tensor G4", 7, 700000, 0, 211.41, 17.97, 0),
      ("Tensor G4", 7, 1164000, 0, 375.49, 20.24, 0),
      ("Tensor G4", 7, 1396000, 0, 491.17, 22.35, 0),
      ("Tensor G4", 7, 1557000, 0, 589.06, 24.29, 0),
      ("Tensor G4", 7, 1745000, 0, 742.95, 26.79, 0),
      ("Tensor G4", 7, 1885000, 0, 862.73, 28.61, 0),
      ("Tensor G4", 7, 1999000, 0, 965.94, 30.04, 0),
      ("Tensor G4", 7, 2147000, 0, 1136.58, 32.65, 0),
      ("Tensor G4", 7, 2294000, 0, 1309.39, 35.62, 0),
      ("Tensor G4", 7, 2363000, 0, 1415.82, 37.93, 0),
      ("Tensor G4", 7, 2499000, 0, 1669.61, 42.96, 0),
      ("Tensor G4", 7, 2687000, 0, 2052.32, 52.16, 0),
      ("Tensor G4", 7, 2802000, 0, 2354.18, 60.2, 0),
      ("Tensor G4", 7, 2914000, 0, 2789.17, 77.16, 0),
      ("Tensor G4", 7, 2943000, 0, 2840.06, 79.64, 0),
      ("Tensor G4", 7, 2970000, 0, 2949.03, 84.78, 0),
      ("Tensor G4", 7, 3015000, 0, 3029.38, 87.22, 0),
      ("Tensor G4", 7, 3105000, 0, 3327.56, 99.47, 0),
      ("neo", 0, 691200, 3.1, 19.54, 0.61, 0),
      ("neo", 0, 940800, 4.33, 26.65, 0.79, 0),
      ("neo", 0, 1113600, 5.65, 32.33, 0.99, 0),
      ("neo", 0, 1497600, 7.19, 45.89, 1.51, 0),
      ("neo", 0, 1804800, 11.7, 99.98, 2.22, 0),
      ("neo", 0, 1996800, 12.5, 101.04, 2.62, 0)) AS _values
  )
SELECT
  *
FROM data;

-- Device specific device curves with 2D dependency (i.e. curve characteristics
-- are dependent on another CPU policy). See go/wattson for more info.
CREATE PERFETTO TABLE _device_curves_2d AS
WITH
  data(device, freq_khz, dependency, static, active, idle0, idle1) AS (
    SELECT
      *
    FROM (VALUES
      ("Tensor", 300000, 28.51, 3.73, 21.84, 0.47, 0),
      ("Tensor", 300000, 43.63, 5.66, 18.97, 0.99, 0),
      ("Tensor", 300000, 87.31, 2.61, 22.89, 0.76, 0),
      ("Tensor", 574000, 28.51, 5.73, 35.85, 0.93, 0),
      ("Tensor", 574000, 43.63, 5.41, 36.54, 0.98, 0),
      ("Tensor", 574000, 54.73, 5.61, 32.98, 0.99, 0),
      ("Tensor", 574000, 65.01, 9.7, 40.29, 1.33, 0),
      ("Tensor", 574000, 80.33, 9.81, 44.42, 1.24, 0),
      ("Tensor", 574000, 92.91, 9.71, 43.95, 1.31, 0),
      ("Tensor", 574000, 87.31, 5.6, 34.69, 1.03, 0),
      ("Tensor", 574000, 170.29, 5.57, 33.66, 1.02, 0),
      ("Tensor", 574000, 207.43, 5.68, 36.2, 0.98, 0),
      ("Tensor", 574000, 251.88, 5.59, 36.27, 1.02, 0),
      ("Tensor", 738000, 28.51, 6.62, 47.66, 1.08, 0),
      ("Tensor", 738000, 43.63, 6.7, 45.71, 1.03, 0),
      ("Tensor", 738000, 54.73, 6.7, 46.21, 1.04, 0),
      ("Tensor", 738000, 65.01, 9.8, 55.47, 1.23, 0),
      ("Tensor", 738000, 80.33, 9.69, 52.58, 1.31, 0),
      ("Tensor", 738000, 92.91, 9.77, 54.81, 1.3, 0),
      ("Tensor", 738000, 132.46, 18.75, 75.3, 2.05, 0),
      ("Tensor", 738000, 146.82, 18.98, 75.84, 1.91, 0),
      ("Tensor", 738000, 87.31, 6.63, 44.56, 1.11, 0),
      ("Tensor", 738000, 170.29, 6.65, 46.62, 1.08, 0),
      ("Tensor", 738000, 207.43, 6.63, 50.28, 1.08, 0),
      ("Tensor", 738000, 251.88, 6.74, 44.83, 1.07, 0),
      ("Tensor", 738000, 306.57, 6.6, 44.15, 1.09, 0),
      ("Tensor", 738000, 382.61, 18.97, 74.73, 1.94, 0),
      ("Tensor", 930000, 28.51, 9.64, 81.16, 1.27, 0),
      ("Tensor", 930000, 43.63, 9.88, 67.4, 1.28, 0),
      ("Tensor", 930000, 54.73, 9.69, 67.33, 1.3, 0),
      ("Tensor", 930000, 65.01, 9.69, 67.82, 1.3, 0),
      ("Tensor", 930000, 80.33, 9.79, 67.52, 1.29, 0),
      ("Tensor", 930000, 92.91, 9.75, 65.44, 1.28, 0),
      ("Tensor", 930000, 132.46, 18.84, 83.73, 2.0, 0),
      ("Tensor", 930000, 146.82, 18.88, 101.57, 1.97, 0),
      ("Tensor", 930000, 183.2, 18.86, 94.45, 1.99, 0),
      ("Tensor", 930000, 238.55, 35.46, 134.93, 3.29, 0),
      ("Tensor", 930000, 259.04, 35.34, 135.55, 3.36, 0),
      ("Tensor", 930000, 87.31, 9.76, 66.0, 1.28, 0),
      ("Tensor", 930000, 170.29, 9.8, 73.08, 1.24, 0),
      ("Tensor", 930000, 207.43, 9.75, 74.87, 1.25, 0),
      ("Tensor", 930000, 251.88, 9.68, 77.31, 1.3, 0),
      ("Tensor", 930000, 306.57, 9.83, 80.03, 1.25, 0),
      ("Tensor", 930000, 382.61, 19.01, 98.31, 1.94, 0),
      ("Tensor", 930000, 465.9, 18.94, 94.51, 1.98, 0),
      ("Tensor", 930000, 556.25, 19.0, 94.38, 1.93, 0),
      ("Tensor", 930000, 613.51, 18.98, 100.84, 1.92, 0),
      ("Tensor", 1098000, 28.51, 12.93, 109.45, 1.47, 0),
      ("Tensor", 1098000, 43.63, 12.92, 120.82, 1.48, 0),
      ("Tensor", 1098000, 54.73, 13.09, 107.17, 1.41, 0),
      ("Tensor", 1098000, 65.01, 12.82, 91.84, 1.56, 0),
      ("Tensor", 1098000, 80.33, 12.88, 99.1, 1.52, 0),
      ("Tensor", 1098000, 92.91, 12.81, 87.32, 1.57, 0),
      ("Tensor", 1098000, 132.46, 18.92, 115.83, 1.97, 0),
      ("Tensor", 1098000, 146.82, 18.97, 137.08, 1.93, 0),
      ("Tensor", 1098000, 183.2, 18.94, 120.36, 1.94, 0),
      ("Tensor", 1098000, 238.55, 35.21, 156.0, 3.43, 0),
      ("Tensor", 1098000, 259.04, 35.21, 155.3, 3.42, 0),
      ("Tensor", 1098000, 361.98, 35.49, 157.04, 3.24, 0),
      ("Tensor", 1098000, 428.51, 35.17, 156.91, 3.41, 0),
      ("Tensor", 1098000, 87.31, 13.0, 93.54, 1.45, 0),
      ("Tensor", 1098000, 170.29, 13.12, 104.28, 1.4, 0),
      ("Tensor", 1098000, 207.43, 12.85, 94.73, 1.52, 0),
      ("Tensor", 1098000, 251.88, 12.68, 95.73, 1.6, 0),
      ("Tensor", 1098000, 306.57, 12.94, 92.78, 1.46, 0),
      ("Tensor", 1098000, 382.61, 18.81, 128.5, 2.03, 0),
      ("Tensor", 1098000, 465.9, 19.0, 124.51, 1.89, 0),
      ("Tensor", 1098000, 556.25, 18.75, 121.84, 2.0, 0),
      ("Tensor", 1098000, 613.51, 19.01, 117.69, 1.9, 0),
      ("Tensor", 1098000, 758.89, 18.97, 107.49, 1.89, 0),
      ("Tensor", 1098000, 874.03, 18.95, 124.24, 1.92, 0),
      ("Tensor", 1197000, 28.51, 14.5, 128.64, 1.54, 0),
      ("Tensor", 1197000, 43.63, 14.41, 126.94, 1.58, 0),
      ("Tensor", 1197000, 54.73, 14.43, 123.96, 1.63, 0),
      ("Tensor", 1197000, 65.01, 14.39, 125.32, 1.59, 0),
      ("Tensor", 1197000, 80.33, 14.42, 126.37, 1.55, 0),
      ("Tensor", 1197000, 92.91, 14.5, 110.43, 1.54, 0),
      ("Tensor", 1197000, 132.46, 19.0, 121.68, 1.9, 222.0),
      ("Tensor", 1197000, 146.82, 18.88, 122.27, 1.96, 0),
      ("Tensor", 1197000, 183.2, 18.84, 118.62, 1.98, 0),
      ("Tensor", 1197000, 238.55, 35.35, 175.31, 3.32, 0),
      ("Tensor", 1197000, 259.04, 35.37, 178.17, 3.38, 0),
      ("Tensor", 1197000, 361.98, 35.34, 186.68, 3.38, 0),
      ("Tensor", 1197000, 428.51, 35.37, 176.06, 3.34, 0),
      ("Tensor", 1197000, 527.05, 35.29, 169.24, 3.38, 111.0),
      ("Tensor", 1197000, 87.31, 14.47, 95.77, 1.55, 0),
      ("Tensor", 1197000, 170.29, 14.42, 101.17, 1.6, 0),
      ("Tensor", 1197000, 207.43, 14.21, 116.52, 1.68, 0),
      ("Tensor", 1197000, 251.88, 14.32, 111.16, 1.62, 0),
      ("Tensor", 1197000, 306.57, 14.42, 84.46, 1.6, 0),
      ("Tensor", 1197000, 382.61, 18.83, 130.44, 2.01, 0),
      ("Tensor", 1197000, 465.9, 18.98, 140.9, 1.9, 0),
      ("Tensor", 1197000, 556.25, 18.82, 143.87, 1.94, 0),
      ("Tensor", 1197000, 613.51, 18.91, 131.75, 1.96, 0),
      ("Tensor", 1197000, 758.89, 18.99, 128.36, 1.96, 0),
      ("Tensor", 1197000, 874.03, 18.71, 132.46, 2.07, 0),
      ("Tensor", 1197000, 949.55, 18.82, 130.95, 2.0, 0),
      ("Tensor", 1328000, 28.51, 17.0, 135.89, 1.84, 0),
      ("Tensor", 1328000, 43.63, 17.1, 161.84, 1.78, 0),
      ("Tensor", 1328000, 54.73, 16.99, 142.03, 1.87, 0),
      ("Tensor", 1328000, 65.01, 17.07, 169.36, 1.83, 0),
      ("Tensor", 1328000, 80.33, 17.19, 111.73, 1.81, 0),
      ("Tensor", 1328000, 92.91, 17.21, 128.66, 1.78, 0),
      ("Tensor", 1328000, 132.46, 18.83, 129.66, 2.02, 0),
      ("Tensor", 1328000, 146.82, 18.88, 132.55, 1.96, 0),
      ("Tensor", 1328000, 183.2, 18.87, 146.14, 2.0, 0),
      ("Tensor", 1328000, 238.55, 35.43, 185.94, 3.27, 0),
      ("Tensor", 1328000, 259.04, 35.46, 165.55, 3.27, 0),
      ("Tensor", 1328000, 361.98, 35.37, 186.76, 3.29, 0),
      ("Tensor", 1328000, 428.51, 35.35, 207.2, 3.34, 0),
      ("Tensor", 1328000, 527.05, 35.31, 209.73, 3.42, 0),
      ("Tensor", 1328000, 87.31, 17.15, 130.76, 1.77, 0),
      ("Tensor", 1328000, 170.29, 17.06, 123.6, 1.84, 0),
      ("Tensor", 1328000, 207.43, 17.21, 130.23, 1.77, 0),
      ("Tensor", 1328000, 251.88, 17.16, 139.65, 1.84, 0),
      ("Tensor", 1328000, 306.57, 17.14, 123.95, 1.83, 0),
      ("Tensor", 1328000, 382.61, 19.15, 141.04, 1.91, 0),
      ("Tensor", 1328000, 465.9, 19.13, 108.29, 1.91, 0),
      ("Tensor", 1328000, 556.25, 19.12, 133.38, 1.9, 0),
      ("Tensor", 1328000, 613.51, 18.87, 137.51, 2.06, 0),
      ("Tensor", 1328000, 758.89, 19.02, 145.9, 1.96, 0),
      ("Tensor", 1328000, 874.03, 19.06, 129.5, 1.94, 0),
      ("Tensor", 1328000, 949.55, 19.05, 125.72, 1.91, 0),
      ("Tensor", 1328000, 1099.53, 35.57, 187.29, 3.33, 0),
      ("Tensor", 1328000, 1267.19, 35.38, 213.14, 3.44, 0),
      ("Tensor", 1328000, 1500.6, 35.47, 181.15, 3.41, 0),
      ("Tensor", 1401000, 28.51, 18.85, 184.12, 2.06, 0),
      ("Tensor", 1401000, 43.63, 18.91, 168.23, 1.98, 0),
      ("Tensor", 1401000, 54.73, 19.11, 184.69, 1.92, 0),
      ("Tensor", 1401000, 65.01, 19.16, 175.13, 1.91, 0),
      ("Tensor", 1401000, 80.33, 19.02, 161.7, 1.97, 0),
      ("Tensor", 1401000, 92.91, 18.97, 156.68, 2.01, 0),
      ("Tensor", 1401000, 132.46, 19.07, 155.0, 1.97, 0),
      ("Tensor", 1401000, 146.82, 18.95, 159.64, 1.96, 0),
      ("Tensor", 1401000, 183.2, 19.13, 136.78, 1.95, 0),
      ("Tensor", 1401000, 238.55, 35.67, 186.73, 3.29, 0),
      ("Tensor", 1401000, 259.04, 35.51, 220.26, 3.45, 0),
      ("Tensor", 1401000, 361.98, 35.75, 249.18, 3.3, 0),
      ("Tensor", 1401000, 428.51, 35.65, 217.48, 3.4, 0),
      ("Tensor", 1401000, 527.05, 35.66, 248.9, 3.41, 0),
      ("Tensor", 1401000, 87.31, 19.05, 152.39, 1.98, 0),
      ("Tensor", 1401000, 170.29, 19.0, 148.12, 2.03, 0),
      ("Tensor", 1401000, 207.43, 19.01, 128.71, 2.0, 0),
      ("Tensor", 1401000, 251.88, 18.18, 132.83, 2.01, 0),
      ("Tensor", 1401000, 306.57, 19.07, 138.09, 1.95, 0),
      ("Tensor", 1401000, 382.61, 18.92, 144.69, 2.05, 0),
      ("Tensor", 1401000, 465.9, 18.95, 151.34, 2.05, 0),
      ("Tensor", 1401000, 556.25, 18.98, 152.04, 2.01, 0),
      ("Tensor", 1401000, 613.51, 19.11, 151.71, 1.95, 0),
      ("Tensor", 1401000, 758.89, 19.04, 136.69, 1.98, 0),
      ("Tensor", 1401000, 874.03, 18.97, 152.56, 2.0, 0),
      ("Tensor", 1401000, 949.55, 19.09, 149.02, 1.97, 0),
      ("Tensor", 1401000, 1099.53, 35.91, 210.3, 3.23, 0),
      ("Tensor", 1401000, 1267.19, 35.64, 188.64, 3.32, 0),
      ("Tensor", 1401000, 1500.6, 35.41, 202.75, 3.5, 0),
      ("Tensor", 1401000, 1660.81, 35.69, 204.49, 3.4, 0),
      ("Tensor", 1401000, 1942.89, 35.64, 208.14, 3.45, 0),
      ("Tensor", 1598000, 28.51, 24.83, 196.05, 2.36, 0),
      ("Tensor", 1598000, 43.63, 24.68, 234.53, 2.37, 0),
      ("Tensor", 1598000, 54.73, 24.71, 230.15, 2.34, 0),
      ("Tensor", 1598000, 65.01, 24.87, 175.64, 2.34, 0),
      ("Tensor", 1598000, 80.33, 24.76, 228.23, 2.36, 0),
      ("Tensor", 1598000, 92.91, 24.6, 228.37, 2.47, 0),
      ("Tensor", 1598000, 132.46, 24.77, 201.12, 2.43, 0),
      ("Tensor", 1598000, 146.82, 24.68, 202.37, 2.41, 0),
      ("Tensor", 1598000, 183.2, 24.58, 199.78, 2.52, 0),
      ("Tensor", 1598000, 238.55, 35.59, 210.2, 3.46, 0),
      ("Tensor", 1598000, 259.04, 35.74, 315.02, 3.33, 0),
      ("Tensor", 1598000, 361.98, 35.65, 285.37, 3.44, 0),
      ("Tensor", 1598000, 428.51, 35.31, 256.84, 3.7, 0),
      ("Tensor", 1598000, 527.05, 35.91, 255.65, 3.37, 0),
      ("Tensor", 1598000, 87.31, 24.78, 184.21, 2.34, 0),
      ("Tensor", 1598000, 170.29, 24.73, 175.69, 2.41, 0),
      ("Tensor", 1598000, 207.43, 24.68, 195.14, 2.43, 0),
      ("Tensor", 1598000, 251.88, 24.65, 194.89, 2.46, 0),
      ("Tensor", 1598000, 306.57, 24.63, 167.1, 2.49, 0),
      ("Tensor", 1598000, 382.61, 24.7, 190.42, 2.45, 0),
      ("Tensor", 1598000, 465.9, 24.79, 190.72, 2.39, 0),
      ("Tensor", 1598000, 556.25, 24.73, 180.52, 2.44, 0),
      ("Tensor", 1598000, 613.51, 24.72, 203.15, 2.4, 0),
      ("Tensor", 1598000, 758.89, 24.82, 197.7, 2.39, 0),
      ("Tensor", 1598000, 874.03, 24.7, 185.45, 2.47, 0),
      ("Tensor", 1598000, 949.55, 24.83, 155.38, 2.35, 0),
      ("Tensor", 1598000, 1099.53, 36.0, 237.12, 3.25, 0),
      ("Tensor", 1598000, 1267.19, 35.89, 253.55, 3.34, 0),
      ("Tensor", 1598000, 1500.6, 35.76, 208.38, 3.45, 0),
      ("Tensor", 1598000, 1660.81, 35.7, 218.73, 3.46, 0),
      ("Tensor", 1598000, 1942.89, 35.65, 248.51, 3.47, 0),
      ("Tensor", 1704000, 28.51, 28.98, 234.84, 2.73, 0),
      ("Tensor", 1704000, 43.63, 29.01, 210.31, 2.66, 0),
      ("Tensor", 1704000, 54.73, 28.95, 300.74, 2.73, 0),
      ("Tensor", 1704000, 65.01, 28.77, 270.96, 2.79, 0),
      ("Tensor", 1704000, 80.33, 28.84, 284.84, 2.76, 0),
      ("Tensor", 1704000, 92.91, 28.76, 251.86, 2.85, 0),
      ("Tensor", 1704000, 132.46, 28.75, 256.3, 2.78, 0),
      ("Tensor", 1704000, 146.82, 28.65, 246.88, 2.86, 0),
      ("Tensor", 1704000, 183.2, 28.73, 267.07, 2.88, 0),
      ("Tensor", 1704000, 238.55, 35.81, 266.03, 3.49, 0),
      ("Tensor", 1704000, 259.04, 35.78, 274.06, 3.35, 0),
      ("Tensor", 1704000, 361.98, 35.67, 268.14, 3.46, 0),
      ("Tensor", 1704000, 428.51, 35.75, 273.4, 3.41, 0),
      ("Tensor", 1704000, 527.05, 35.42, 276.92, 3.72, 0),
      ("Tensor", 1704000, 87.31, 29.1, 239.74, 2.65, 0),
      ("Tensor", 1704000, 170.29, 28.79, 216.53, 2.74, 0),
      ("Tensor", 1704000, 207.43, 28.9, 259.03, 2.76, 0),
      ("Tensor", 1704000, 251.88, 28.71, 211.76, 2.82, 0),
      ("Tensor", 1704000, 306.57, 28.79, 216.77, 2.8, 0),
      ("Tensor", 1704000, 382.61, 28.94, 207.8, 2.71, 0),
      ("Tensor", 1704000, 465.9, 28.96, 232.83, 2.67, 0),
      ("Tensor", 1704000, 556.25, 28.67, 237.37, 2.85, 0),
      ("Tensor", 1704000, 613.51, 29.0, 224.71, 2.71, 0),
      ("Tensor", 1704000, 758.89, 28.86, 239.69, 2.73, 0),
      ("Tensor", 1704000, 874.03, 28.88, 218.8, 2.76, 0),
      ("Tensor", 1704000, 949.55, 28.87, 272.23, 2.76, 0),
      ("Tensor", 1704000, 1099.53, 35.74, 258.98, 3.33, 0),
      ("Tensor", 1704000, 1267.19, 35.74, 276.92, 3.4, 0),
      ("Tensor", 1704000, 1500.6, 35.71, 249.7, 3.45, 0),
      ("Tensor", 1704000, 1660.81, 36.01, 253.04, 3.29, 0),
      ("Tensor", 1704000, 1942.89, 35.91, 266.15, 3.4, 0),
      ("Tensor", 1803000, 28.51, 35.71, 342.95, 3.49, 0),
      ("Tensor", 1803000, 43.63, 35.76, 330.57, 3.41, 0),
      ("Tensor", 1803000, 54.73, 35.71, 355.0, 3.41, 0),
      ("Tensor", 1803000, 65.01, 35.67, 310.42, 3.45, 0),
      ("Tensor", 1803000, 80.33, 35.95, 309.22, 3.38, 0),
      ("Tensor", 1803000, 92.91, 35.6, 303.94, 3.55, 0),
      ("Tensor", 1803000, 132.46, 36.0, 346.31, 3.26, 0),
      ("Tensor", 1803000, 146.82, 35.9, 300.16, 3.36, 0),
      ("Tensor", 1803000, 183.2, 35.88, 215.33, 3.33, 0),
      ("Tensor", 1803000, 238.55, 35.72, 284.35, 3.47, 0),
      ("Tensor", 1803000, 259.04, 35.9, 289.0, 3.32, 0),
      ("Tensor", 1803000, 361.98, 34.96, 293.38, 3.33, 0),
      ("Tensor", 1803000, 428.51, 35.07, 359.86, 3.19, 0),
      ("Tensor", 1803000, 527.05, 35.07, 295.24, 3.23, 0),
      ("Tensor", 1803000, 87.31, 34.68, 223.89, 3.4, 0),
      ("Tensor", 1803000, 170.29, 34.74, 261.39, 3.4, 0),
      ("Tensor", 1803000, 207.43, 35.08, 269.51, 3.26, 0),
      ("Tensor", 1803000, 251.88, 35.06, 269.58, 3.21, 0),
      ("Tensor", 1803000, 306.57, 34.87, 218.3, 3.39, 0),
      ("Tensor", 1803000, 382.61, 34.86, 264.34, 3.36, 0),
      ("Tensor", 1803000, 465.9, 34.9, 263.56, 3.36, 0),
      ("Tensor", 1803000, 556.25, 35.09, 210.36, 3.29, 0),
      ("Tensor", 1803000, 613.51, 35.06, 256.1, 3.34, 0),
      ("Tensor", 1803000, 758.89, 35.18, 269.91, 3.16, 0),
      ("Tensor", 1803000, 874.03, 35.16, 261.04, 3.25, 0),
      ("Tensor", 1803000, 949.55, 34.84, 272.92, 3.49, 0),
      ("Tensor", 1803000, 1099.53, 35.2, 260.24, 3.38, 0),
      ("Tensor", 1803000, 1267.19, 34.89, 240.7, 3.58, 0),
      ("Tensor", 1803000, 1500.6, 35.21, 150.76, 3.42, 0),
      ("Tensor", 1803000, 1660.81, 35.2, 277.28, 3.44, 0),
      ("Tensor", 1803000, 1942.89, 35.12, 269.2, 3.62, 0),
      ("Tensor G4", 820000, 610000, 3.3, 47.6, 1.04, 0),
      ("Tensor G4", 820000, 820000, 6.77, 65.48, 1.17, 0),
      ("Tensor G4", 820000, 970000, 8.61, 78.56, 1.28, 0),
      ("Tensor G4", 820000, 1098000, 12.5, 92.7, 1.28, 0),
      ("Tensor G4", 820000, 1197000, 15.24, 110.72, 1.46, 0),
      ("Tensor G4", 820000, 1328000, 21.73, 134.04, 1.58, 0),
      ("Tensor G4", 820000, 1444000, 26.89, 151.02, 1.75, 0),
      ("Tensor G4", 820000, 1548000, 31.53, 164.93, 1.8, 0),
      ("Tensor G4", 820000, 1704000, 43.86, 157.18, 2.24, 0),
      ("Tensor G4", 820000, 1800000, 52.1, 137.62, 2.64, 0),
      ("Tensor G4", 820000, 1880000, 59.74, 145.28, 2.44, 0),
      ("Tensor G4", 820000, 1950000, 71.34, 156.19, 3.12, 0),
      ("Tensor G4", 820000, 2024000, 86.3, 155.05, 3.53, 0),
      ("Tensor G4", 820000, 2120000, 112.45, 176.15, 4.74, 0),
      ("Tensor G4", 820000, 2150000, 112.1, 155.11, 4.69, 0),
      ("Tensor G4", 955000, 610000, 6.18, 56.03, 0.68, 0),
      ("Tensor G4", 955000, 820000, 6.39, 74.22, 1.21, 0),
      ("Tensor G4", 955000, 970000, 9.18, 82.2, 1.26, 0),
      ("Tensor G4", 955000, 1098000, 12.62, 98.11, 1.34, 0),
      ("Tensor G4", 955000, 1197000, 15.72, 117.95, 1.41, 0),
      ("Tensor G4", 955000, 1328000, 21.94, 141.91, 1.57, 0),
      ("Tensor G4", 955000, 1444000, 27.38, 162.99, 1.85, 0),
      ("Tensor G4", 955000, 1548000, 31.94, 175.19, 1.72, 0),
      ("Tensor G4", 955000, 1704000, 43.84, 130.38, 2.44, 0),
      ("Tensor G4", 955000, 1800000, 52.67, 117.99, 2.5, 0),
      ("Tensor G4", 955000, 1880000, 59.69, 145.08, 2.91, 0),
      ("Tensor G4", 955000, 1950000, 73.33, 141.24, 3.23, 0),
      ("Tensor G4", 955000, 2024000, 86.96, 171.19, 3.7, 0),
      ("Tensor G4", 955000, 2120000, 112.7, 188.38, 5.0, 0),
      ("Tensor G4", 955000, 2150000, 111.86, 179.34, 5.53, 0),
      ("Tensor G4", 1098000, 610000, 7.23, 66.6, 1.26, 0),
      ("Tensor G4", 1098000, 820000, 8.04, 80.19, 1.21, 0),
      ("Tensor G4", 1098000, 970000, 9.56, 90.34, 1.22, 0),
      ("Tensor G4", 1098000, 1098000, 12.86, 109.5, 1.33, 0),
      ("Tensor G4", 1098000, 1197000, 16.57, 120.41, 1.07, 0),
      ("Tensor G4", 1098000, 1328000, 22.15, 145.31, 1.54, 0),
      ("Tensor G4", 1098000, 1444000, 27.91, 163.9, 1.68, 0),
      ("Tensor G4", 1098000, 1548000, 32.01, 174.89, 1.87, 0),
      ("Tensor G4", 1098000, 1704000, 44.5, 139.63, 2.24, 0),
      ("Tensor G4", 1098000, 1800000, 53.21, 140.32, 2.52, 0),
      ("Tensor G4", 1098000, 1880000, 60.44, 157.97, 2.83, 0),
      ("Tensor G4", 1098000, 1950000, 73.65, 169.76, 3.28, 0),
      ("Tensor G4", 1098000, 2024000, 87.15, 182.83, 3.98, 0),
      ("Tensor G4", 1098000, 2120000, 114.08, 187.49, 4.17, 0),
      ("Tensor G4", 1098000, 2150000, 113.79, 189.6, 4.65, 0),
      ("Tensor G4", 1197000, 610000, 8.34, 75.11, 1.27, 0),
      ("Tensor G4", 1197000, 820000, 9.54, 84.82, 1.14, 0),
      ("Tensor G4", 1197000, 970000, 10.37, 89.93, 1.18, 0),
      ("Tensor G4", 1197000, 1098000, 12.81, 104.44, 1.37, 0),
      ("Tensor G4", 1197000, 1197000, 16.36, 129.81, 1.39, 0),
      ("Tensor G4", 1197000, 1328000, 22.4, 145.01, 1.64, 0),
      ("Tensor G4", 1197000, 1444000, 28.1, 170.53, 1.61, 0),
      ("Tensor G4", 1197000, 1548000, 32.23, 186.28, 1.91, 0),
      ("Tensor G4", 1197000, 1704000, 44.93, 156.69, 2.32, 0),
      ("Tensor G4", 1197000, 1800000, 53.17, 151.91, 2.43, 0),
      ("Tensor G4", 1197000, 1880000, 60.94, 141.69, 2.72, 0),
      ("Tensor G4", 1197000, 1950000, 73.72, 189.86, 3.42, 0),
      ("Tensor G4", 1197000, 2024000, 87.87, 158.58, 3.7, 0),
      ("Tensor G4", 1197000, 2120000, 114.16, 193.12, 4.81, 0),
      ("Tensor G4", 1197000, 2150000, 113.59, 191.22, 4.8, 0),
      ("Tensor G4", 1328000, 610000, 10.73, 90.03, 1.33, 0),
      ("Tensor G4", 1328000, 820000, 11.88, 99.06, 1.31, 0),
      ("Tensor G4", 1328000, 970000, 12.77, 106.72, 1.33, 0),
      ("Tensor G4", 1328000, 1098000, 13.12, 110.06, 1.39, 0),
      ("Tensor G4", 1328000, 1197000, 16.68, 127.98, 1.33, 0),
      ("Tensor G4", 1328000, 1328000, 22.66, 154.27, 1.68, 0),
      ("Tensor G4", 1328000, 1444000, 28.49, 174.25, 1.72, 0),
      ("Tensor G4", 1328000, 1548000, 32.16, 191.25, 1.73, 0),
      ("Tensor G4", 1328000, 1704000, 44.27, 129.41, 2.25, 0),
      ("Tensor G4", 1328000, 1800000, 53.79, 154.61, 2.51, 0),
      ("Tensor G4", 1328000, 1880000, 61.04, 163.47, 2.68, 0),
      ("Tensor G4", 1328000, 1950000, 75.05, 189.16, 3.08, 0),
      ("Tensor G4", 1328000, 2024000, 89.05, 204.54, 3.43, 0),
      ("Tensor G4", 1328000, 2120000, 115.33, 210.24, 4.36, 0),
      ("Tensor G4", 1328000, 2150000, 114.98, 206.93, 4.34, 0),
      ("Tensor G4", 1425000, 610000, 13.32, 101.33, 1.43, 0),
      ("Tensor G4", 1425000, 820000, 14.56, 111.02, 1.46, 0),
      ("Tensor G4", 1425000, 970000, 15.11, 121.09, 1.47, 0),
      ("Tensor G4", 1425000, 1098000, 16.25, 128.03, 1.41, 0),
      ("Tensor G4", 1425000, 1197000, 16.68, 127.43, 1.45, 0),
      ("Tensor G4", 1425000, 1328000, 22.57, 156.98, 1.68, 0),
      ("Tensor G4", 1425000, 1444000, 28.81, 182.29, 1.72, 0),
      ("Tensor G4", 1425000, 1548000, 33.08, 198.0, 1.83, 0),
      ("Tensor G4", 1425000, 1704000, 45.21, 162.21, 2.12, 0),
      ("Tensor G4", 1425000, 1800000, 54.37, 167.27, 2.5, 0),
      ("Tensor G4", 1425000, 1880000, 61.48, 116.14, 2.89, 0),
      ("Tensor G4", 1425000, 1950000, 74.85, 180.6, 3.49, 0),
      ("Tensor G4", 1425000, 2024000, 89.32, 187.51, 3.6, 0),
      ("Tensor G4", 1425000, 2120000, 115.2, 203.97, 4.57, 0),
      ("Tensor G4", 1425000, 2150000, 115.53, 210.01, 4.25, 0),
      ("Tensor G4", 1548000, 610000, 16.36, 123.83, 1.45, 0),
      ("Tensor G4", 1548000, 820000, 17.5, 128.9, 1.62, 0),
      ("Tensor G4", 1548000, 970000, 18.34, 139.52, 1.58, 0),
      ("Tensor G4", 1548000, 1098000, 19.32, 149.77, 1.53, 0),
      ("Tensor G4", 1548000, 1197000, 19.8, 152.01, 1.43, 0),
      ("Tensor G4", 1548000, 1328000, 22.59, 159.55, 1.61, 0),
      ("Tensor G4", 1548000, 1444000, 28.75, 198.79, 1.86, 0),
      ("Tensor G4", 1548000, 1548000, 33.46, 211.95, 1.77, 0),
      ("Tensor G4", 1548000, 1704000, 46.36, 169.26, 2.11, 0),
      ("Tensor G4", 1548000, 1800000, 54.71, 177.24, 2.42, 0),
      ("Tensor G4", 1548000, 1880000, 62.25, 145.44, 2.76, 0),
      ("Tensor G4", 1548000, 1950000, 75.84, 191.27, 3.09, 0),
      ("Tensor G4", 1548000, 2024000, 88.97, 198.32, 3.86, 0),
      ("Tensor G4", 1548000, 2120000, 115.79, 232.48, 4.72, 0),
      ("Tensor G4", 1548000, 2150000, 115.31, 222.76, 4.71, 0),
      ("Tensor G4", 1696000, 610000, 19.61, 132.84, 1.68, 0),
      ("Tensor G4", 1696000, 820000, 21.09, 151.29, 1.59, 0),
      ("Tensor G4", 1696000, 970000, 21.92, 157.59, 1.75, 0),
      ("Tensor G4", 1696000, 1098000, 22.76, 163.33, 1.59, 0),
      ("Tensor G4", 1696000, 1197000, 23.53, 173.96, 1.67, 0),
      ("Tensor G4", 1696000, 1328000, 24.28, 184.05, 1.58, 0),
      ("Tensor G4", 1696000, 1444000, 29.47, 203.99, 1.77, 0),
      ("Tensor G4", 1696000, 1548000, 33.94, 225.78, 1.7, 0),
      ("Tensor G4", 1696000, 1704000, 46.92, 171.8, 2.16, 0),
      ("Tensor G4", 1696000, 1800000, 55.32, 217.17, 2.38, 0),
      ("Tensor G4", 1696000, 1880000, 62.55, 224.61, 2.77, 0),
      ("Tensor G4", 1696000, 1950000, 76.98, 204.48, 2.82, 0),
      ("Tensor G4", 1696000, 2024000, 90.13, 226.98, 3.76, 0),
      ("Tensor G4", 1696000, 2120000, 116.77, 245.48, 4.52, 0),
      ("Tensor G4", 1696000, 2150000, 112.69, 222.79, 6.43, 0),
      ("Tensor G4", 1849000, 610000, 29.35, 176.28, 1.8, 0),
      ("Tensor G4", 1849000, 820000, 30.31, 187.61, 1.94, 0),
      ("Tensor G4", 1849000, 970000, 31.7, 202.99, 2.05, 0),
      ("Tensor G4", 1849000, 1098000, 32.48, 207.22, 2.01, 0),
      ("Tensor G4", 1849000, 1197000, 33.7, 222.81, 1.9, 0),
      ("Tensor G4", 1849000, 1328000, 34.79, 229.5, 1.9, 0),
      ("Tensor G4", 1849000, 1444000, 35.97, 228.13, 1.91, 0),
      ("Tensor G4", 1849000, 1548000, 36.59, 235.62, 2.01, 0),
      ("Tensor G4", 1849000, 1704000, 47.47, 233.89, 2.16, 0),
      ("Tensor G4", 1849000, 1800000, 55.69, 211.69, 2.53, 0),
      ("Tensor G4", 1849000, 1880000, 63.47, 225.85, 2.39, 0),
      ("Tensor G4", 1849000, 1950000, 77.22, 209.34, 3.0, 0),
      ("Tensor G4", 1849000, 2024000, 90.92, 230.3, 3.48, 0),
      ("Tensor G4", 1849000, 2120000, 117.19, 247.78, 4.49, 0),
      ("Tensor G4", 1849000, 2150000, 117.53, 239.55, 4.32, 0),
      ("Tensor G4", 1950000, 610000, 40.27, 197.26, 2.54, 0),
      ("Tensor G4", 1950000, 820000, 41.93, 221.2, 2.67, 0),
      ("Tensor G4", 1950000, 970000, 43.45, 239.45, 2.56, 0),
      ("Tensor G4", 1950000, 1098000, 44.27, 240.43, 2.64, 0),
      ("Tensor G4", 1950000, 1197000, 45.84, 259.94, 2.42, 0),
      ("Tensor G4", 1950000, 1328000, 47.03, 273.66, 2.55, 0),
      ("Tensor G4", 1950000, 1444000, 48.53, 267.32, 2.32, 0),
      ("Tensor G4", 1950000, 1548000, 49.59, 232.85, 2.35, 0),
      ("Tensor G4", 1950000, 1704000, 51.2, 234.87, 2.23, 0),
      ("Tensor G4", 1950000, 1800000, 55.47, 205.6, 2.67, 0),
      ("Tensor G4", 1950000, 1880000, 63.68, 201.13, 2.59, 0),
      ("Tensor G4", 1950000, 1950000, 77.22, 201.28, 3.13, 0),
      ("Tensor G4", 1950000, 2024000, 90.93, 230.61, 3.81, 0),
      ("Tensor G4", 1950000, 2120000, 118.19, 233.8, 4.28, 0),
      ("Tensor G4", 1950000, 2150000, 118.61, 240.57, 4.6, 0)) AS _values
  )
SELECT
  *
FROM data;

CREATE PERFETTO TABLE _device_curves_l3 AS
WITH
  data(device, freq_khz, dependency, l3_hit, l3_miss) AS (
    SELECT
      *
    FROM (VALUES
      ("Tensor", 300000, 28.51, 0.3989, 0.0629),
      ("Tensor", 300000, 43.63, 0.4119, 0.0656),
      ("Tensor", 300000, 87.31, 0.3298, 0.1029),
      ("Tensor", 574000, 28.51, 0.4894, 0.0239),
      ("Tensor", 574000, 43.63, 0.4991, 0.0960),
      ("Tensor", 574000, 54.73, 0.4949, 0.0971),
      ("Tensor", 574000, 65.01, 0.6116, 0.1266),
      ("Tensor", 574000, 80.33, 0.5897, 0.1385),
      ("Tensor", 574000, 92.91, 0.5619, 0.0635),
      ("Tensor", 574000, 87.31, 0.5377, 0.1210),
      ("Tensor", 574000, 170.29, 0.5271, 0.1591),
      ("Tensor", 574000, 207.43, 0.5395, 0.1599),
      ("Tensor", 574000, 251.88, 0.5552, 0.1393),
      ("Tensor", 738000, 28.51, 0.5825, 0.1271),
      ("Tensor", 738000, 43.63, 0.5751, 0.0396),
      ("Tensor", 738000, 54.73, 0.6433, 0.1050),
      ("Tensor", 738000, 65.01, 0.6401, 0.1293),
      ("Tensor", 738000, 80.33, 0.7069, 0.1252),
      ("Tensor", 738000, 92.91, 0.6999, 0.1143),
      ("Tensor", 738000, 132.46, 0.9076, 0.1960),
      ("Tensor", 738000, 146.82, 0.9708, 0.1953),
      ("Tensor", 738000, 87.31, 0.6437, 0.2086),
      ("Tensor", 738000, 170.29, 0.6274, 0.1852),
      ("Tensor", 738000, 207.43, 0.6231, 0.2066),
      ("Tensor", 738000, 251.88, 0.6256, 0.2199),
      ("Tensor", 738000, 306.57, 0.6719, 0.2485),
      ("Tensor", 738000, 382.61, 1.1072, 0.3483),
      ("Tensor", 930000, 28.51, 0.7812, 0.1727),
      ("Tensor", 930000, 43.63, 0.7343, 0.1846),
      ("Tensor", 930000, 54.73, 0.7551, 0.2006),
      ("Tensor", 930000, 65.01, 0.7330, 0.1864),
      ("Tensor", 930000, 80.33, 0.8250, 0.1451),
      ("Tensor", 930000, 92.91, 0.7331, 0.2092),
      ("Tensor", 930000, 132.46, 1.0791, 0.4804),
      ("Tensor", 930000, 146.82, 1.0172, 0.0844),
      ("Tensor", 930000, 183.2, 1.0396, 0.2614),
      ("Tensor", 930000, 238.55, 1.6492, 0.3497),
      ("Tensor", 930000, 259.04, 1.5561, 0.3407),
      ("Tensor", 930000, 87.31, 0.8530, 0.4182),
      ("Tensor", 930000, 170.29, 0.8694, 0.2854),
      ("Tensor", 930000, 207.43, 0.8620, 0.2568),
      ("Tensor", 930000, 251.88, 0.8763, 0.2336),
      ("Tensor", 930000, 306.57, 0.8717, 0.3756),
      ("Tensor", 930000, 382.61, 1.1774, 0.5021),
      ("Tensor", 930000, 465.9, 1.1264, 0.5799),
      ("Tensor", 930000, 556.25, 1.2303, 0.5421),
      ("Tensor", 930000, 613.51, 1.2330, 0.4498),
      ("Tensor", 1098000, 28.51, 0.9744, 0.2106),
      ("Tensor", 1098000, 43.63, 0.9980, 0.0500),
      ("Tensor", 1098000, 54.73, 0.9500, 0.1928),
      ("Tensor", 1098000, 65.01, 0.9132, 0.2391),
      ("Tensor", 1098000, 80.33, 0.9922, 0.2576),
      ("Tensor", 1098000, 92.91, 0.9607, 0.2397),
      ("Tensor", 1098000, 132.46, 1.1253, 0.6195),
      ("Tensor", 1098000, 146.82, 1.1609, 0.0960),
      ("Tensor", 1098000, 183.2, 1.1783, 0.0851),
      ("Tensor", 1098000, 238.55, 1.6941, 0.4295),
      ("Tensor", 1098000, 259.04, 1.7152, 0.4610),
      ("Tensor", 1098000, 361.98, 1.7941, 0.4293),
      ("Tensor", 1098000, 428.51, 1.6758, 0.4437),
      ("Tensor", 1098000, 87.31, 1.0485, 0.4038),
      ("Tensor", 1098000, 170.29, 1.0510, 0.2815),
      ("Tensor", 1098000, 207.43, 1.0785, 0.4137),
      ("Tensor", 1098000, 251.88, 1.0909, 0.3933),
      ("Tensor", 1098000, 306.57, 1.1533, 0.3811),
      ("Tensor", 1098000, 382.61, 1.2718, 0.3814),
      ("Tensor", 1098000, 465.9, 1.3463, 0.4100),
      ("Tensor", 1098000, 556.25, 1.3065, 0.5207),
      ("Tensor", 1098000, 613.51, 1.3456, 0.4903),
      ("Tensor", 1098000, 758.89, 1.3466, 0.7218),
      ("Tensor", 1098000, 874.03, 1.3132, 0.4923),
      ("Tensor", 1197000, 28.51, 1.0507, 0.2411),
      ("Tensor", 1197000, 43.63, 1.0387, 0.2875),
      ("Tensor", 1197000, 54.73, 1.0173, 0.2232),
      ("Tensor", 1197000, 65.01, 1.0160, 0.2418),
      ("Tensor", 1197000, 80.33, 1.0555, 0.0966),
      ("Tensor", 1197000, 92.91, 1.0663, 0.0987),
      ("Tensor", 1197000, 132.46, 1.1885, 0.2852),
      ("Tensor", 1197000, 146.82, 1.2442, 0.2724),
      ("Tensor", 1197000, 183.2, 1.2474, 0.3269),
      ("Tensor", 1197000, 238.55, 1.8142, 0.3429),
      ("Tensor", 1197000, 259.04, 1.7692, 1.0737),
      ("Tensor", 1197000, 361.98, 1.7939, 0.1120),
      ("Tensor", 1197000, 428.51, 1.8126, 0.3744),
      ("Tensor", 1197000, 527.05, 1.7413, 0.5198),
      ("Tensor", 1197000, 87.31, 1.1288, 0.6817),
      ("Tensor", 1197000, 170.29, 1.1779, 0.5681),
      ("Tensor", 1197000, 207.43, 1.1835, 0.3389),
      ("Tensor", 1197000, 251.88, 1.2115, 0.4506),
      ("Tensor", 1197000, 306.57, 1.1726, 0.8719),
      ("Tensor", 1197000, 382.61, 1.3825, 0.5140),
      ("Tensor", 1197000, 465.9, 1.4179, 0.3585),
      ("Tensor", 1197000, 556.25, 1.3804, 0.3197),
      ("Tensor", 1197000, 613.51, 1.3379, 0.5614),
      ("Tensor", 1197000, 758.89, 1.3335, 0.5443),
      ("Tensor", 1197000, 874.03, 1.4382, 0.5255),
      ("Tensor", 1197000, 949.55, 1.3961, 0.5423),
      ("Tensor", 1328000, 28.51, 1.2307, 0.5565),
      ("Tensor", 1328000, 43.63, 1.2186, 0.2366),
      ("Tensor", 1328000, 54.73, 1.2243, 0.4145),
      ("Tensor", 1328000, 65.01, 1.2620, 0.0973),
      ("Tensor", 1328000, 80.33, 1.2462, 0.5669),
      ("Tensor", 1328000, 92.91, 1.2787, 0.2332),
      ("Tensor", 1328000, 132.46, 1.4364, 0.3260),
      ("Tensor", 1328000, 146.82, 1.3636, 0.3354),
      ("Tensor", 1328000, 183.2, 1.3733, 0.0512),
      ("Tensor", 1328000, 238.55, 1.9295, 0.4588),
      ("Tensor", 1328000, 259.04, 1.8278, 0.9316),
      ("Tensor", 1328000, 361.98, 1.9043, 0.4921),
      ("Tensor", 1328000, 428.51, 1.9144, 0.1139),
      ("Tensor", 1328000, 527.05, 1.9550, 0.0603),
      ("Tensor", 1328000, 87.31, 1.3772, 0.5737),
      ("Tensor", 1328000, 170.29, 1.3985, 0.6368),
      ("Tensor", 1328000, 207.43, 1.3933, 0.5311),
      ("Tensor", 1328000, 251.88, 1.3932, 0.4567),
      ("Tensor", 1328000, 306.57, 1.3984, 0.6616),
      ("Tensor", 1328000, 382.61, 1.5067, 0.5776),
      ("Tensor", 1328000, 465.9, 1.5167, 1.0309),
      ("Tensor", 1328000, 556.25, 1.5021, 0.6845),
      ("Tensor", 1328000, 613.51, 1.4775, 0.6285),
      ("Tensor", 1328000, 758.89, 1.5237, 0.5402),
      ("Tensor", 1328000, 874.03, 1.5349, 0.7490),
      ("Tensor", 1328000, 949.55, 1.5436, 0.7984),
      ("Tensor", 1328000, 1099.53, 2.1755, 1.0387),
      ("Tensor", 1328000, 1267.19, 2.2320, 0.7382),
      ("Tensor", 1328000, 1500.6, 2.2489, 1.1762),
      ("Tensor", 1401000, 28.51, 1.3279, 0.2793),
      ("Tensor", 1401000, 43.63, 1.3065, 0.3853),
      ("Tensor", 1401000, 54.73, 1.3290, 0.3016),
      ("Tensor", 1401000, 65.01, 1.2483, 0.3683),
      ("Tensor", 1401000, 80.33, 1.4059, 0.2825),
      ("Tensor", 1401000, 92.91, 1.3702, 0.3389),
      ("Tensor", 1401000, 132.46, 1.3920, 0.3614),
      ("Tensor", 1401000, 146.82, 1.3752, 0.3310),
      ("Tensor", 1401000, 183.2, 1.4015, 0.6546),
      ("Tensor", 1401000, 238.55, 1.8982, 1.0324),
      ("Tensor", 1401000, 259.04, 1.9447, 0.5336),
      ("Tensor", 1401000, 361.98, 2.1219, 0.0662),
      ("Tensor", 1401000, 428.51, 1.9576, 0.5584),
      ("Tensor", 1401000, 527.05, 2.0221, 0.1254),
      ("Tensor", 1401000, 87.31, 1.5283, 0.5764),
      ("Tensor", 1401000, 170.29, 1.5211, 0.5643),
      ("Tensor", 1401000, 207.43, 1.5574, 0.7558),
      ("Tensor", 1401000, 251.88, 1.5492, 0.7862),
      ("Tensor", 1401000, 306.57, 1.5389, 0.7523),
      ("Tensor", 1401000, 382.61, 1.6449, 0.5993),
      ("Tensor", 1401000, 465.9, 1.5953, 0.5512),
      ("Tensor", 1401000, 556.25, 1.5672, 0.5489),
      ("Tensor", 1401000, 613.51, 1.5639, 0.5507),
      ("Tensor", 1401000, 758.89, 1.5878, 0.7536),
      ("Tensor", 1401000, 874.03, 1.5562, 0.5431),
      ("Tensor", 1401000, 949.55, 1.5908, 0.6087),
      ("Tensor", 1401000, 1099.53, 2.2693, 0.8953),
      ("Tensor", 1401000, 1267.19, 2.3182, 1.2289),
      ("Tensor", 1401000, 1500.6, 2.3090, 1.0687),
      ("Tensor", 1401000, 1660.81, 2.2751, 0.9966),
      ("Tensor", 1401000, 1942.89, 2.3278, 0.9065),
      ("Tensor", 1598000, 28.51, 1.7424, 0.8926),
      ("Tensor", 1598000, 43.63, 1.7003, 0.4482),
      ("Tensor", 1598000, 54.73, 1.6099, 0.5281),
      ("Tensor", 1598000, 65.01, 1.8018, 0.9634),
      ("Tensor", 1598000, 80.33, 1.7615, 0.3445),
      ("Tensor", 1598000, 92.91, 1.7317, 0.3396),
      ("Tensor", 1598000, 132.46, 1.7293, 0.5079),
      ("Tensor", 1598000, 146.82, 1.8771, 0.4685),
      ("Tensor", 1598000, 183.2, 1.8724, 0.4693),
      ("Tensor", 1598000, 238.55, 1.9587, 1.2295),
      ("Tensor", 1598000, 259.04, 2.2287, 0.5220),
      ("Tensor", 1598000, 361.98, 2.1786, 0.1494),
      ("Tensor", 1598000, 428.51, 2.1631, 0.4924),
      ("Tensor", 1598000, 527.05, 2.1703, 0.5427),
      ("Tensor", 1598000, 87.31, 1.9632, 0.9534),
      ("Tensor", 1598000, 170.29, 1.9820, 0.9433),
      ("Tensor", 1598000, 207.43, 1.9745, 0.8002),
      ("Tensor", 1598000, 251.88, 1.9514, 0.8323),
      ("Tensor", 1598000, 306.57, 1.9796, 1.1016),
      ("Tensor", 1598000, 382.61, 1.9432, 0.8556),
      ("Tensor", 1598000, 465.9, 2.0700, 0.8211),
      ("Tensor", 1598000, 556.25, 2.0052, 0.9492),
      ("Tensor", 1598000, 613.51, 2.0165, 0.7016),
      ("Tensor", 1598000, 758.89, 2.0881, 0.6641),
      ("Tensor", 1598000, 874.03, 2.1239, 0.8702),
      ("Tensor", 1598000, 949.55, 2.0952, 1.1728),
      ("Tensor", 1598000, 1099.53, 2.4810, 0.9498),
      ("Tensor", 1598000, 1267.19, 2.4644, 0.9131),
      ("Tensor", 1598000, 1500.6, 2.4030, 1.3728),
      ("Tensor", 1598000, 1660.81, 2.4271, 1.2680),
      ("Tensor", 1598000, 1942.89, 2.4761, 0.9789),
      ("Tensor", 1704000, 28.51, 1.9466, 0.9753),
      ("Tensor", 1704000, 43.63, 1.9336, 1.0846),
      ("Tensor", 1704000, 54.73, 1.9280, 0.2116),
      ("Tensor", 1704000, 65.01, 1.9616, 0.4219),
      ("Tensor", 1704000, 80.33, 1.9627, 0.1957),
      ("Tensor", 1704000, 92.91, 1.9763, 0.5599),
      ("Tensor", 1704000, 132.46, 1.9514, 0.4326),
      ("Tensor", 1704000, 146.82, 2.0093, 0.4861),
      ("Tensor", 1704000, 183.2, 1.9438, 0.1584),
      ("Tensor", 1704000, 238.55, 2.3012, 0.6019),
      ("Tensor", 1704000, 259.04, 2.2896, 0.5019),
      ("Tensor", 1704000, 361.98, 2.2292, 0.6076),
      ("Tensor", 1704000, 428.51, 2.2087, 0.5726),
      ("Tensor", 1704000, 527.05, 2.2317, 0.4878),
      ("Tensor", 1704000, 87.31, 2.3606, 0.7822),
      ("Tensor", 1704000, 170.29, 2.2564, 0.9656),
      ("Tensor", 1704000, 207.43, 2.2618, 0.9988),
      ("Tensor", 1704000, 251.88, 2.2796, 0.9681),
      ("Tensor", 1704000, 306.57, 2.2224, 0.8812),
      ("Tensor", 1704000, 382.61, 2.2368, 1.0353),
      ("Tensor", 1704000, 465.9, 2.3125, 0.8402),
      ("Tensor", 1704000, 556.25, 2.3199, 0.7728),
      ("Tensor", 1704000, 613.51, 2.3633, 0.8597),
      ("Tensor", 1704000, 758.89, 2.2779, 0.6885),
      ("Tensor", 1704000, 874.03, 2.2575, 1.0289),
      ("Tensor", 1704000, 949.55, 2.2798, 0.9689),
      ("Tensor", 1704000, 1099.53, 2.5202, 1.0626),
      ("Tensor", 1704000, 1267.19, 2.4070, 0.8463),
      ("Tensor", 1704000, 1500.6, 2.5998, 1.0795),
      ("Tensor", 1704000, 1660.81, 2.6273, 1.0329),
      ("Tensor", 1704000, 1942.89, 2.6179, 0.7569),
      ("Tensor", 1803000, 28.51, 2.2197, 0.4673),
      ("Tensor", 1803000, 43.63, 2.3144, 0.5120),
      ("Tensor", 1803000, 54.73, 2.2720, 0.1952),
      ("Tensor", 1803000, 65.01, 2.3472, 0.5479),
      ("Tensor", 1803000, 80.33, 2.3035, 0.5622),
      ("Tensor", 1803000, 92.91, 2.2129, 0.6828),
      ("Tensor", 1803000, 132.46, 2.3176, 0.1645),
      ("Tensor", 1803000, 146.82, 2.3127, 0.4992),
      ("Tensor", 1803000, 183.2, 2.1449, 1.4705),
      ("Tensor", 1803000, 238.55, 2.3243, 0.6256),
      ("Tensor", 1803000, 259.04, 2.1328, 0.6293),
      ("Tensor", 1803000, 361.98, 2.3165, 0.5265),
      ("Tensor", 1803000, 428.51, 2.2775, 0.6412),
      ("Tensor", 1803000, 527.05, 2.4124, 0.5151),
      ("Tensor", 1803000, 87.31, 2.5536, 1.5678),
      ("Tensor", 1803000, 170.29, 2.5831, 1.1737),
      ("Tensor", 1803000, 207.43, 2.6063, 1.0591),
      ("Tensor", 1803000, 251.88, 2.6951, 0.9158),
      ("Tensor", 1803000, 306.57, 2.5400, 1.5096),
      ("Tensor", 1803000, 382.61, 2.6623, 1.1037),
      ("Tensor", 1803000, 465.9, 2.6996, 1.0774),
      ("Tensor", 1803000, 556.25, 2.6692, 1.6543),
      ("Tensor", 1803000, 613.51, 2.7288, 1.1255),
      ("Tensor", 1803000, 758.89, 2.6649, 1.1010),
      ("Tensor", 1803000, 874.03, 2.6489, 1.1485),
      ("Tensor", 1803000, 949.55, 2.6389, 1.0942),
      ("Tensor", 1803000, 1099.53, 2.6256, 1.0997),
      ("Tensor", 1803000, 1267.19, 2.6630, 1.2641),
      ("Tensor", 1803000, 1500.6, 2.7385, 2.3263),
      ("Tensor", 1803000, 1660.81, 2.6901, 1.0629),
      ("Tensor", 1803000, 1942.89, 2.7476, 1.0673),
      ("Tensor G4", 820000, 610000, 0.4824, 0.8357),
      ("Tensor G4", 955000, 610000, 0.4801, 0.852),
      ("Tensor G4", 1098000, 610000, 0.4988, 0.8219),
      ("Tensor G4", 1197000, 610000, 0.5025, 0.8369),
      ("Tensor G4", 1328000, 610000, 0.516, 0.8928),
      ("Tensor G4", 1425000, 610000, 0.5266, 0.8895),
      ("Tensor G4", 1548000, 610000, 0.5286, 0.915),
      ("Tensor G4", 1696000, 610000, 0.5288, 1.0169),
      ("Tensor G4", 1849000, 610000, 0.5326, 1.1313),
      ("Tensor G4", 1950000, 610000, 0.5495, 1.1839),
      ("Tensor G4", 820000, 820000, 0.4815, 0.8114),
      ("Tensor G4", 955000, 820000, 0.5055, 0.9356),
      ("Tensor G4", 1098000, 820000, 0.5168, 0.9567),
      ("Tensor G4", 1197000, 820000, 0.5228, 0.8653),
      ("Tensor G4", 1328000, 820000, 0.5228, 0.8895),
      ("Tensor G4", 1425000, 820000, 0.5309, 0.9692),
      ("Tensor G4", 1548000, 820000, 0.5461, 0.9987),
      ("Tensor G4", 1696000, 820000, 0.564, 1.053),
      ("Tensor G4", 1849000, 820000, 0.5649, 0.9087),
      ("Tensor G4", 1950000, 820000, 0.5737, 1.0893),
      ("Tensor G4", 820000, 970000, 0.4923, 0.852),
      ("Tensor G4", 955000, 970000, 0.5014, 0.8357),
      ("Tensor G4", 1098000, 970000, 0.4952, 1.0169),
      ("Tensor G4", 1197000, 970000, 0.5284, 0.8594),
      ("Tensor G4", 1328000, 970000, 0.5332, 0.8521),
      ("Tensor G4", 1425000, 970000, 0.5424, 0.8612),
      ("Tensor G4", 1548000, 970000, 0.5641, 0.883),
      ("Tensor G4", 1696000, 970000, 0.5524, 0.915),
      ("Tensor G4", 1849000, 970000, 0.5685, 0.8765),
      ("Tensor G4", 1950000, 970000, 0.5527, 0.8164),
      ("Tensor G4", 820000, 1098000, 0.5084, 0.947),
      ("Tensor G4", 955000, 1098000, 0.5177, 0.8058),
      ("Tensor G4", 1098000, 1098000, 0.5284, 0.763),
      ("Tensor G4", 1197000, 1098000, 0.596, 0.8633),
      ("Tensor G4", 1328000, 1098000, 0.596, 0.8633),
      ("Tensor G4", 1425000, 1098000, 0.5373, 0.7504),
      ("Tensor G4", 1548000, 1098000, 0.5186, 0.8604),
      ("Tensor G4", 1696000, 1098000, 0.5772, 89.73),
      ("Tensor G4", 1849000, 1098000, 0.5758, 0.9588),
      ("Tensor G4", 1950000, 1098000, 0.5904, 1.1074),
      ("Tensor G4", 820000, 1197000, 0.5105, 0.866),
      ("Tensor G4", 955000, 1197000, 0.5241, 0.8533),
      ("Tensor G4", 1098000, 1197000, 0.5347, 0.8569),
      ("Tensor G4", 1197000, 1197000, 0.524, 0.8318),
      ("Tensor G4", 1328000, 1197000, 0.5298, 0.8374),
      ("Tensor G4", 1425000, 1197000, 0.5201, 0.9479),
      ("Tensor G4", 1548000, 1197000, 0.497, 0.9093),
      ("Tensor G4", 1696000, 1197000, 0.5007, 0.8765),
      ("Tensor G4", 1849000, 1197000, 0.6107, 0.8682),
      ("Tensor G4", 1950000, 1197000, 0.5888, 0.9738),
      ("Tensor G4", 820000, 1328000, 0.534, 0.9162),
      ("Tensor G4", 955000, 1328000, 0.5551, 0.9499),
      ("Tensor G4", 1098000, 1328000, 0.556, 0.954),
      ("Tensor G4", 1197000, 1328000, 0.5711, 0.9117),
      ("Tensor G4", 1328000, 1328000, 0.5372, 0.956),
      ("Tensor G4", 1425000, 1328000, 0.5482, 0.934),
      ("Tensor G4", 1548000, 1328000, 0.5615, 0.7495),
      ("Tensor G4", 1696000, 1328000, 0.53, 0.9145),
      ("Tensor G4", 1849000, 1328000, 0.5504, 0.9478),
      ("Tensor G4", 1950000, 1328000, 0.6243, 0.9335),
      ("Tensor G4", 820000, 1444000, 0.5437, 0.9403),
      ("Tensor G4", 955000, 1444000, 0.5635, 0.9997),
      ("Tensor G4", 1098000, 1444000, 0.5711, 0.919),
      ("Tensor G4", 1197000, 1444000, 0.5595, 0.9455),
      ("Tensor G4", 1328000, 1444000, 0.5772, 0.9415),
      ("Tensor G4", 1425000, 1444000, 0.5507, 0.9582),
      ("Tensor G4", 1548000, 1444000, 0.5535, 0.8986),
      ("Tensor G4", 1696000, 1444000, 0.507, 0.9369),
      ("Tensor G4", 1849000, 1444000, 0.628, 0.8878),
      ("Tensor G4", 1950000, 1444000, 0.658, 1.0974),
      ("Tensor G4", 820000, 1548000, 0.578, 0.8322),
      ("Tensor G4", 955000, 1548000, 0.603, 0.9371),
      ("Tensor G4", 1098000, 1548000, 0.6163, 0.962),
      ("Tensor G4", 1197000, 1548000, 0.6105, 0.9323),
      ("Tensor G4", 1328000, 1548000, 0.589, 0.8355),
      ("Tensor G4", 1425000, 1548000, 0.5924, 0.9416),
      ("Tensor G4", 1548000, 1548000, 0.5611, 0.8911),
      ("Tensor G4", 1696000, 1548000, 0.5792, 0.905),
      ("Tensor G4", 1849000, 1548000, 0.6021, 0.9761),
      ("Tensor G4", 1950000, 1548000, 0.6579, 1.0438),
      ("Tensor G4", 820000, 1704000, 1.5584, 1.2388),
      ("Tensor G4", 955000, 1704000, 1.5287, 1.104),
      ("Tensor G4", 1098000, 1704000, 1.6412, 1.2419),
      ("Tensor G4", 1197000, 1704000, 1.9947, 1.318),
      ("Tensor G4", 1328000, 1704000, 1.6701, 1.178),
      ("Tensor G4", 1425000, 1704000, 1.5944, 1.3017),
      ("Tensor G4", 1548000, 1704000, 1.6769, 1.6058),
      ("Tensor G4", 1696000, 1704000, 1.7215, 1.8),
      ("Tensor G4", 1849000, 1704000, 1.9143, 2.0842),
      ("Tensor G4", 1950000, 1704000, 1.932, 2.8572),
      ("Tensor G4", 820000, 1800000, 1.575, 1.5401),
      ("Tensor G4", 955000, 1800000, 1.6833, 1.5087),
      ("Tensor G4", 1098000, 1800000, 1.5571, 2.0737),
      ("Tensor G4", 1197000, 1800000, 1.6815, 1.8473),
      ("Tensor G4", 1328000, 1800000, 1.7828, 1.666),
      ("Tensor G4", 1425000, 1800000, 1.8061, 1.8018),
      ("Tensor G4", 1548000, 1800000, 1.9956, 1.64),
      ("Tensor G4", 1696000, 1800000, 1.8592, 1.701),
      ("Tensor G4", 1849000, 1800000, 1.5758, 1.5364),
      ("Tensor G4", 1950000, 1800000, 1.9823, 1.7952),
      ("Tensor G4", 820000, 1880000, 1.7249, 1.7787),
      ("Tensor G4", 955000, 1880000, 1.7635, 2.0677),
      ("Tensor G4", 1098000, 1880000, 1.805, 1.5907),
      ("Tensor G4", 1197000, 1880000, 1.7293, 2.0645),
      ("Tensor G4", 1328000, 1880000, 1.918, 1.9844),
      ("Tensor G4", 1425000, 1880000, 2.0013, 1.5541),
      ("Tensor G4", 1548000, 1880000, 2.0504, 1.9877),
      ("Tensor G4", 1696000, 1880000, 1.9603, 1.8955),
      ("Tensor G4", 1849000, 1880000, 2.1168, 1.9674),
      ("Tensor G4", 1950000, 1880000, 2.2047, 2.4697),
      ("Tensor G4", 820000, 1950000, 1.9756, 1.4938),
      ("Tensor G4", 955000, 1950000, 1.90147, 1.8144),
      ("Tensor G4", 1098000, 1950000, 2.1539, 2.0811),
      ("Tensor G4", 1197000, 1950000, 2.2192, 1.8968),
      ("Tensor G4", 1328000, 1950000, 2.2974, 2.1572),
      ("Tensor G4", 1425000, 1950000, 2.3865, 2.2972),
      ("Tensor G4", 1548000, 1950000, 2.4361, 2.3942),
      ("Tensor G4", 1696000, 1950000, 2.8677, 2.2737),
      ("Tensor G4", 1849000, 1950000, 2.6123, 2.5181),
      ("Tensor G4", 1950000, 1950000, 2.7293, 2.5798),
      ("Tensor G4", 820000, 2024000, 2.0136, 1.7557),
      ("Tensor G4", 955000, 2024000, 1.9834, 1.6844),
      ("Tensor G4", 1098000, 2024000, 2.1129, 1.8735),
      ("Tensor G4", 1197000, 2024000, 2.5894, 2.2185),
      ("Tensor G4", 1328000, 2024000, 2.6949, 2.1905),
      ("Tensor G4", 1425000, 2024000, 2.8143, 2.7641),
      ("Tensor G4", 1548000, 2024000, 2.8513, 2.6064),
      ("Tensor G4", 1696000, 2024000, 2.663, 2.3265),
      ("Tensor G4", 1849000, 2024000, 2.6618, 2.595),
      ("Tensor G4", 1950000, 2024000, 2.7227, 2.7533),
      ("Tensor G4", 820000, 2120000, 2.5414, 2.6693),
      ("Tensor G4", 955000, 2120000, 2.7682, 2.7252),
      ("Tensor G4", 1098000, 2120000, 3.1524, 2.8636),
      ("Tensor G4", 1197000, 2120000, 3.0192, 2.6325),
      ("Tensor G4", 1328000, 2120000, 2.9797, 3.1899),
      ("Tensor G4", 1425000, 2120000, 3.176, 3.069),
      ("Tensor G4", 1548000, 2120000, 3.1105, 2.2982),
      ("Tensor G4", 1696000, 2120000, 2.9221, 3.2752),
      ("Tensor G4", 1849000, 2120000, 3.2659, 3.0112),
      ("Tensor G4", 1950000, 2120000, 3.1351, 3.5576),
      ("Tensor G4", 820000, 2150000, 2.9947, 2.6827),
      ("Tensor G4", 955000, 2150000, 2.9357, 2.5455),
      ("Tensor G4", 1098000, 2150000, 3.1562, 2.8923),
      ("Tensor G4", 1197000, 2150000, 3.0068, 3.2811),
      ("Tensor G4", 1328000, 2150000, 3.1187, 3.0526),
      ("Tensor G4", 1425000, 2150000, 3.2907, 2.9659),
      ("Tensor G4", 1548000, 2150000, 2.9841, 3.347),
      ("Tensor G4", 1696000, 2150000, 3.2313, 3.1632),
      ("Tensor G4", 1849000, 2150000, 3.091, 3.1305),
      ("Tensor G4", 1950000, 2150000, 3.326, 3.0211)) AS _values
  )
SELECT
  *
FROM data;
