# Copyright 2023 The Chromium Authors
# Use of this source code is governed by a BSD-style license that can be
# found in the LICENSE file.
"""Codegen for GEN_JNI.java used for compiling (.class file is discarded)."""


def Generate(jni_objs, *, gen_jni_class, script_name):
  sb = []
  sb.append(f"""\
//
// This file is a placeholder. It was generated by {script_name}
// Contains placeholder methods specific to library targets. The real class
// is generated on a per-apk basis.
//

package {gen_jni_class.package_with_dots};

import org.jni_zero.internal.NullUnmarked;

@NullUnmarked
public class {gen_jni_class.name} {{
""")

  for jni_obj in jni_objs:
    for native in jni_obj.proxy_natives:
      sig_params = native.proxy_params.to_java_declaration()
      sb.append(f"""
  public static native {native.proxy_return_type.to_java()} {native.proxy_name}\
({sig_params});""")

  sb.append('\n}\n')
  return ''.join(sb)
