/*
Copyright (C) 2021 by nekohasekai <contact-sagernet@sekai.icu>

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <https://www.gnu.org/licenses/>.
*/

package common

import (
	"github.com/v2fly/v2ray-core/v5/common"
)

func CloseIgnore(closer ...interface{}) {
	for _, c := range closer {
		if c == nil {
			continue
		}
		if ia, ok := c.(common.Interruptible); ok {
			ia.Interrupt()
		} else if ca, ok := c.(common.Closable); ok {
			_ = ca.Close()
		}
	}
}
