# Exclave

Exclave is a proxy client.

<details>

Features:
- Various proxy protocols
- Group and subscription
- Routing
- Proxy chain

Some supported protocols:
- Shadowsocks (optional SIP003 plugin)
- Shadowsocks 2022 (optional SIP003 plugin)
- Trojan
- Hysteria 2
- AnyTLS
- mieru
- NaïveProxy (as a standalone plugin)
- TUIC
- Juicity
- VMess (with various optional sub-protocols)
- VLESS (with various optional sub-protocols)
- WireGuard (as a proxy rather than a VPN)
- SSH proxy
- HTTP CONNECT tunnel and HTTPS CONNECT tunnel (optional HTTP/2 and HTTP/3)
- SOCKS4, SOCKS4A and SOCKS5

</details>

It is a fork of the archived Android proxy client SagerNet and uses a custom overhauled fork of V2Ray.

## Download

- Exclave

  [<img src="images/get-it-on-github.png" alt="Get it on GitHub" height="80">](https://github.com/dyhkwong/Exclave/releases) [<img src="images/get-it-on-f-droid.png" alt="Get it on F-Droid" height="80">](https://f-droid.org/packages/com.github.dyhkwong.sagernet)

- NaïveProxy Plugin

  [<img src="images/get-it-on-github.png" alt="Get it on GitHub" height="80">](https://github.com/klzgrad/naiveproxy/releases)

Starting in September 2026, Google will [block apps from "sideloading"](https://developer.android.com/developer-verification) on [certified Android devices](https://www.android.com/certified/partners/). If you are a user who values digital freedom, we need your voice to express opposition. Your support will not only help save this app, but also help defend software freedom and open distribution.

<details>

- Since August 2025, Google has been advancing a move to block apps from being installed by users on certified Android devices if developers do not verify their identities and register their apps.
- Only organization developers with a D-U-N-S number can [publish new apps sthat use `VpnService` on Play Store](https://support.google.com/googleplay/android-developer/answer/13634885).
- The "limited distribution" outside Play Store for "hobbyist developers" is based on user invitation and comes with limits on the number of apps and installations.
- The maintainer of this app is unable and unwilling to provide real identity information to register this app.
- As a result, you will end up have no choice but to use Android Debug Bridge (ADB) to install this app on certified Android devices.

</details>

## License

    Copyright (C) 2023 dyhkwong
    Copyright (C) 2021 by nekohasekai <contact-sagernet@sekai.icu>

    This program (except for all files in directory "library/core/clash") is free software: you can redistribute it and/or modify it under the terms of the GNU General Public License as published by the Free Software Foundation, either version 3 of the License, or (at your option) any later version.

    All files in directory "library/core/clash" are free software: you can redistribute them and/or modify them under the terms of the GNU General Public License as published by the Free Software Foundation, version 3.

    This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.

    You should have received a copy of the GNU General Public License along with this program. If not, see <https://www.gnu.org/licenses/>.

## Translation

Is Exclave not in your language, or the translation is incorrect or incomplete? Get involved in the translations on [Hosted Weblate](https://hosted.weblate.org/projects/exclave/).

## Report issues

Please report issues [here](https://github.com/dyhkwong/Exclave/issues). Do not report issues to upstream because the core used is heavily modified.

- For crashes, log file using "debug" log level is required. Log files may contain secret keys used to connect to servers. Please remove potential sensitive information or encrypt with GPG before posting them publicly.
- For memory leak and high system resource usage, pprof profile is required. Long press "About" - "Version" to enable pprof HTTP server settings and kill and restart the app to take effect.
- Encrypt with [this GPG public key](https://github.com/dyhkwong.gpg) if the issue contains sensitive information or you are reporting a vulnerability.

## Explanation of terms

[Exclave wiki](https://github.com/dyhkwong/Exclave/wiki). It contains some subjective comments. Viewer discretion is advised.

## Build from source

The following procedures are only applicable to for typical AMD64 Linux distros. It is possible to build on other platforms but the arguments may need some modifications.
- Install and configure Git, JDK 21, Android SDK Platform 36, Android NDK r29 and Go 1.25.5.
- Install [this Go Mobile fork](https://github.com/sagernet/gomobile) by running `go install github.com/sagernet/gomobile/cmd/gomobile@v0.1.9` and `go install github.com/sagernet/gomobile/cmd/gobind@v0.1.9` in order.
  - This fork version of Go Mobile is for reproducible build only. If you don't need reproducible build, you can replace it with the official Go Mobile (remove `-buildvcs=false` in `library/core/build.sh` and replace `github.com/sagernet/gomobile` module with `golang.org/x/mobile` in `library/core`).
- Use Git to clone this project.
- Replace `release.keystore` with your own. It can be generated by Java `keytool`.
- Append the following lines to your `local.properties`.
```
    KEYSTORE_PASS=your_keystore_pass
    ALIAS_NAME=your_alias_name
    ALIAS_PASS=your_alias_pass
```
- Build `libcore`: `./run lib core`, or run `library/core/build.sh` manually.
- Download assets (`geosite.dat`, `geoip.dat` and `mozilla_included.pem`) if you have not downloaded them before: `./gradlew :app:downloadAssets` (or update assets: `./gradlew :app:updateAssets`)
- Build the app: `./gradlew :app:assembleOssRelease`
- APK files are located in `app/build/outputs/apk/oss/release`

## Dependencies, submodules and assets

- See [app/build.gradle.kts](app/build.gradle.kts), [buildSrc/build.gradle.kts](buildSrc/build.gradle.kts) and [library/proto-stub/build.gradle.kts](library/proto-stub/build.gradle.kts) for Android libraries used in Exclave.
- See [library/core/go.mod](library/core/go.mod) for Go libraries used in Exclave.
- See [plugin/api/build.gradle.kts](plugin/api/build.gradle.kts) for Android libraries used in plugins.
- `geosite.dat` is downloaded from https://github.com/v2fly/domain-list-community/releases. It is licensed under the MIT license.
- `geoip.dat` is downloaded from https://github.com/v2fly/geoip/releases. It is licensed under CC-BY-4.0.
- `mozilla_included.pem` is downloaded from https://www.ccadb.org/resources. It is licensed under CDLA-2.0 Permissive.
- Submodules are for compiling native binaries of plugins. They are executables that run in separate processes and therefore not subjected to the restrictions of GPL. Please refer to submodule repositories for their respective licenses.

## Acknowledgment

- [Shadowsocks](https://github.com/shadowsocks/shadowsocks-android)
- [SagerNet](https://github.com/SagerNet/SagerNet)
- [Matsuri](https://github.com/MatsuriDayo/Matsuri)
- [NekoBox](https://github.com/MatsuriDayo/NekoBoxForAndroid)
- [husi](https://github.com/xchacha20-poly1305/husi)
