/*
 * Copyright (C) 2017 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

// Autogenerated by:
// ../../src/tools/ftrace_proto_gen/ftrace_proto_gen.cc
// Do not edit.

#include "src/traced/probes/ftrace/event_info.h"

#include "perfetto/protozero/proto_utils.h"

namespace perfetto {

using protozero::proto_utils::ProtoSchemaType;

std::vector<Event> GetStaticEventInfo() {
  static constexpr uint16_t kUnsetOffset = 0;
  static constexpr uint16_t kUnsetSize = 0;
  static constexpr uint16_t kUnsetFtraceId = 0;
  return {
      {"android_fs_dataread_end",
       "android_fs",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "bytes", 1, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "ino", 2, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "offset", 3, ProtoSchemaType::kInt64,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       431,
       kUnsetSize},
      {"android_fs_dataread_start",
       "android_fs",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "bytes", 1, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "cmdline", 2, ProtoSchemaType::kString,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "i_size", 3, ProtoSchemaType::kInt64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "ino", 4, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "offset", 5, ProtoSchemaType::kInt64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "pathbuf", 6, ProtoSchemaType::kString,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "pid", 7, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       432,
       kUnsetSize},
      {"android_fs_datawrite_end",
       "android_fs",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "bytes", 1, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "ino", 2, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "offset", 3, ProtoSchemaType::kInt64,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       433,
       kUnsetSize},
      {"android_fs_datawrite_start",
       "android_fs",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "bytes", 1, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "cmdline", 2, ProtoSchemaType::kString,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "i_size", 3, ProtoSchemaType::kInt64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "ino", 4, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "offset", 5, ProtoSchemaType::kInt64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "pathbuf", 6, ProtoSchemaType::kString,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "pid", 7, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       434,
       kUnsetSize},
      {"android_fs_fsync_end",
       "android_fs",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "bytes", 1, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "ino", 2, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "offset", 3, ProtoSchemaType::kInt64,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       435,
       kUnsetSize},
      {"android_fs_fsync_start",
       "android_fs",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "cmdline", 1, ProtoSchemaType::kString,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "i_size", 2, ProtoSchemaType::kInt64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "ino", 3, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "pathbuf", 4, ProtoSchemaType::kString,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "pid", 5, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       436,
       kUnsetSize},
      {"bcl_irq_trigger",
       "bcl_exynos",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "id", 1, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "throttle", 2, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "cpu0_limit", 3, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "cpu1_limit", 4, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "cpu2_limit", 5, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "tpu_limit", 6, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "gpu_limit", 7, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "voltage", 8, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "capacity", 9, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       533,
       kUnsetSize},
      {"binder_transaction",
       "binder",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "debug_id", 1, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "target_node", 2, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "to_proc", 3, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "to_thread", 4, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "reply", 5, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "code", 6, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "flags", 7, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       50,
       kUnsetSize},
      {"binder_transaction_received",
       "binder",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "debug_id", 1, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       51,
       kUnsetSize},
      {"binder_set_priority",
       "binder",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "proc", 1, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "thread", 2, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "old_prio", 3, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "new_prio", 4, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "desired_prio", 5, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       52,
       kUnsetSize},
      {"binder_lock",
       "binder",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "tag", 1, ProtoSchemaType::kString,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       53,
       kUnsetSize},
      {"binder_locked",
       "binder",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "tag", 1, ProtoSchemaType::kString,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       54,
       kUnsetSize},
      {"binder_unlock",
       "binder",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "tag", 1, ProtoSchemaType::kString,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       55,
       kUnsetSize},
      {"binder_transaction_alloc_buf",
       "binder",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "data_size", 1, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "debug_id", 2, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "offsets_size", 3, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "extra_buffers_size", 4, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       323,
       kUnsetSize},
      {"binder_command",
       "binder",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "cmd", 1, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       485,
       kUnsetSize},
      {"binder_return",
       "binder",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "cmd", 1, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       486,
       kUnsetSize},
      {"block_rq_issue",
       "block",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "dev", 1, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "sector", 2, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "nr_sector", 3, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "bytes", 4, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "rwbs", 5, ProtoSchemaType::kString,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "comm", 6, ProtoSchemaType::kString,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "cmd", 7, ProtoSchemaType::kString,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       45,
       kUnsetSize},
      {"block_bio_backmerge",
       "block",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "dev", 1, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "sector", 2, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "nr_sector", 3, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "rwbs", 4, ProtoSchemaType::kString,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "comm", 5, ProtoSchemaType::kString,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       115,
       kUnsetSize},
      {"block_bio_bounce",
       "block",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "dev", 1, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "sector", 2, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "nr_sector", 3, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "rwbs", 4, ProtoSchemaType::kString,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "comm", 5, ProtoSchemaType::kString,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       116,
       kUnsetSize},
      {"block_bio_complete",
       "block",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "dev", 1, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "sector", 2, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "nr_sector", 3, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "error", 4, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "rwbs", 5, ProtoSchemaType::kString,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       117,
       kUnsetSize},
      {"block_bio_frontmerge",
       "block",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "dev", 1, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "sector", 2, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "nr_sector", 3, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "rwbs", 4, ProtoSchemaType::kString,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "comm", 5, ProtoSchemaType::kString,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       118,
       kUnsetSize},
      {"block_bio_queue",
       "block",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "dev", 1, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "sector", 2, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "nr_sector", 3, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "rwbs", 4, ProtoSchemaType::kString,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "comm", 5, ProtoSchemaType::kString,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       119,
       kUnsetSize},
      {"block_bio_remap",
       "block",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "dev", 1, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "sector", 2, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "nr_sector", 3, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "old_dev", 4, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "old_sector", 5, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "rwbs", 6, ProtoSchemaType::kString,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       120,
       kUnsetSize},
      {"block_dirty_buffer",
       "block",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "dev", 1, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "sector", 2, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "size", 3, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       121,
       kUnsetSize},
      {"block_getrq",
       "block",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "dev", 1, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "sector", 2, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "nr_sector", 3, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "rwbs", 4, ProtoSchemaType::kString,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "comm", 5, ProtoSchemaType::kString,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       122,
       kUnsetSize},
      {"block_plug",
       "block",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "comm", 1, ProtoSchemaType::kString,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       123,
       kUnsetSize},
      {"block_rq_abort",
       "block",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "dev", 1, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "sector", 2, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "nr_sector", 3, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "errors", 4, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "rwbs", 5, ProtoSchemaType::kString,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "cmd", 6, ProtoSchemaType::kString,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       124,
       kUnsetSize},
      {"block_rq_complete",
       "block",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "dev", 1, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "sector", 2, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "nr_sector", 3, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "errors", 4, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "rwbs", 5, ProtoSchemaType::kString,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "cmd", 6, ProtoSchemaType::kString,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "error", 7, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       125,
       kUnsetSize},
      {"block_rq_insert",
       "block",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "dev", 1, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "sector", 2, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "nr_sector", 3, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "bytes", 4, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "rwbs", 5, ProtoSchemaType::kString,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "comm", 6, ProtoSchemaType::kString,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "cmd", 7, ProtoSchemaType::kString,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       126,
       kUnsetSize},
      {"block_rq_remap",
       "block",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "dev", 1, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "sector", 2, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "nr_sector", 3, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "old_dev", 4, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "old_sector", 5, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "nr_bios", 6, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "rwbs", 7, ProtoSchemaType::kString,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       128,
       kUnsetSize},
      {"block_rq_requeue",
       "block",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "dev", 1, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "sector", 2, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "nr_sector", 3, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "errors", 4, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "rwbs", 5, ProtoSchemaType::kString,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "cmd", 6, ProtoSchemaType::kString,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       129,
       kUnsetSize},
      {"block_sleeprq",
       "block",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "dev", 1, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "sector", 2, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "nr_sector", 3, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "rwbs", 4, ProtoSchemaType::kString,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "comm", 5, ProtoSchemaType::kString,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       130,
       kUnsetSize},
      {"block_split",
       "block",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "dev", 1, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "sector", 2, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "new_sector", 3, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "rwbs", 4, ProtoSchemaType::kString,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "comm", 5, ProtoSchemaType::kString,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       131,
       kUnsetSize},
      {"block_touch_buffer",
       "block",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "dev", 1, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "sector", 2, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "size", 3, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       132,
       kUnsetSize},
      {"block_unplug",
       "block",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "nr_rq", 1, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "comm", 2, ProtoSchemaType::kString,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       133,
       kUnsetSize},
      {"block_io_start",
       "block",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "dev", 1, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "sector", 2, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "nr_sector", 3, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "bytes", 4, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "ioprio", 5, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "rwbs", 6, ProtoSchemaType::kString,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "comm", 7, ProtoSchemaType::kString,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "cmd", 8, ProtoSchemaType::kString,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       546,
       kUnsetSize},
      {"block_io_done",
       "block",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "dev", 1, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "sector", 2, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "nr_sector", 3, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "bytes", 4, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "ioprio", 5, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "rwbs", 6, ProtoSchemaType::kString,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "comm", 7, ProtoSchemaType::kString,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "cmd", 8, ProtoSchemaType::kString,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       547,
       kUnsetSize},
      {"cgroup_attach_task",
       "cgroup",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "dst_root", 1, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "dst_id", 2, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "pid", 3, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "comm", 4, ProtoSchemaType::kString,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "cname", 5, ProtoSchemaType::kString,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "dst_level", 6, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "dst_path", 7, ProtoSchemaType::kString,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       67,
       kUnsetSize},
      {"cgroup_mkdir",
       "cgroup",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "root", 1, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "id", 2, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "cname", 3, ProtoSchemaType::kString,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "level", 4, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "path", 5, ProtoSchemaType::kString,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       68,
       kUnsetSize},
      {"cgroup_remount",
       "cgroup",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "root", 1, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "ss_mask", 2, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "name", 3, ProtoSchemaType::kString,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       69,
       kUnsetSize},
      {"cgroup_rmdir",
       "cgroup",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "root", 1, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "id", 2, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "cname", 3, ProtoSchemaType::kString,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "level", 4, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "path", 5, ProtoSchemaType::kString,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       70,
       kUnsetSize},
      {"cgroup_transfer_tasks",
       "cgroup",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "dst_root", 1, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "dst_id", 2, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "pid", 3, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "comm", 4, ProtoSchemaType::kString,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "cname", 5, ProtoSchemaType::kString,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "dst_level", 6, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "dst_path", 7, ProtoSchemaType::kString,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       71,
       kUnsetSize},
      {"cgroup_destroy_root",
       "cgroup",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "root", 1, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "ss_mask", 2, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "name", 3, ProtoSchemaType::kString,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       72,
       kUnsetSize},
      {"cgroup_release",
       "cgroup",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "root", 1, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "id", 2, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "cname", 3, ProtoSchemaType::kString,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "level", 4, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "path", 5, ProtoSchemaType::kString,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       73,
       kUnsetSize},
      {"cgroup_rename",
       "cgroup",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "root", 1, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "id", 2, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "cname", 3, ProtoSchemaType::kString,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "level", 4, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "path", 5, ProtoSchemaType::kString,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       74,
       kUnsetSize},
      {"cgroup_setup_root",
       "cgroup",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "root", 1, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "ss_mask", 2, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "name", 3, ProtoSchemaType::kString,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       75,
       kUnsetSize},
      {"clk_enable",
       "clk",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "name", 1, ProtoSchemaType::kString,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       320,
       kUnsetSize},
      {"clk_disable",
       "clk",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "name", 1, ProtoSchemaType::kString,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       321,
       kUnsetSize},
      {"clk_set_rate",
       "clk",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "name", 1, ProtoSchemaType::kString,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "rate", 2, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       322,
       kUnsetSize},
      {"cma_alloc_start",
       "cma",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "align", 1, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "count", 2, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "name", 3, ProtoSchemaType::kString,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       465,
       kUnsetSize},
      {"cma_alloc_info",
       "cma",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "align", 1, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "count", 2, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "err_iso", 3, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "err_mig", 4, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "err_test", 5, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "name", 6, ProtoSchemaType::kString,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "nr_mapped", 7, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "nr_migrated", 8, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "nr_reclaimed", 9, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "pfn", 10, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       466,
       kUnsetSize},
      {"cma_alloc_finish",
       "cma",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "name", 1, ProtoSchemaType::kString,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "pfn", 2, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "page", 3, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "count", 4, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "align", 5, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "errorno", 6, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       576,
       kUnsetSize},
      {"mm_compaction_begin",
       "compaction",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "zone_start", 1, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "migrate_pfn", 2, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "free_pfn", 3, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "zone_end", 4, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "sync", 5, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       99,
       kUnsetSize},
      {"mm_compaction_defer_compaction",
       "compaction",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "nid", 1, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "idx", 2, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "order", 3, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "considered", 4, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "defer_shift", 5, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "order_failed", 6, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       100,
       kUnsetSize},
      {"mm_compaction_deferred",
       "compaction",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "nid", 1, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "idx", 2, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "order", 3, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "considered", 4, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "defer_shift", 5, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "order_failed", 6, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       101,
       kUnsetSize},
      {"mm_compaction_defer_reset",
       "compaction",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "nid", 1, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "idx", 2, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "order", 3, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "considered", 4, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "defer_shift", 5, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "order_failed", 6, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       102,
       kUnsetSize},
      {"mm_compaction_end",
       "compaction",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "zone_start", 1, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "migrate_pfn", 2, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "free_pfn", 3, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "zone_end", 4, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "sync", 5, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "status", 6, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       103,
       kUnsetSize},
      {"mm_compaction_finished",
       "compaction",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "nid", 1, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "idx", 2, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "order", 3, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "ret", 4, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       104,
       kUnsetSize},
      {"mm_compaction_isolate_freepages",
       "compaction",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "start_pfn", 1, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "end_pfn", 2, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "nr_scanned", 3, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "nr_taken", 4, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       105,
       kUnsetSize},
      {"mm_compaction_isolate_migratepages",
       "compaction",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "start_pfn", 1, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "end_pfn", 2, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "nr_scanned", 3, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "nr_taken", 4, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       106,
       kUnsetSize},
      {"mm_compaction_kcompactd_sleep",
       "compaction",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "nid", 1, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       107,
       kUnsetSize},
      {"mm_compaction_kcompactd_wake",
       "compaction",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "nid", 1, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "order", 2, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "classzone_idx", 3, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "highest_zoneidx", 4, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       108,
       kUnsetSize},
      {"mm_compaction_migratepages",
       "compaction",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "nr_migrated", 1, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "nr_failed", 2, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       109,
       kUnsetSize},
      {"mm_compaction_suitable",
       "compaction",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "nid", 1, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "idx", 2, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "order", 3, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "ret", 4, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       110,
       kUnsetSize},
      {"mm_compaction_try_to_compact_pages",
       "compaction",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "order", 1, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "gfp_mask", 2, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "mode", 3, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "prio", 4, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       111,
       kUnsetSize},
      {"mm_compaction_wakeup_kcompactd",
       "compaction",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "nid", 1, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "order", 2, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "classzone_idx", 3, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "highest_zoneidx", 4, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       112,
       kUnsetSize},
      {"param_set_value_cpm",
       "cpm_trace",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "body", 1, ProtoSchemaType::kString,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "value", 2, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "timestamp", 3, ProtoSchemaType::kInt64,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       543,
       kUnsetSize},
      {"cpuhp_exit",
       "cpuhp",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "cpu", 1, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "idx", 2, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "ret", 3, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "state", 4, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       343,
       kUnsetSize},
      {"cpuhp_multi_enter",
       "cpuhp",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "cpu", 1, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "fun", 2, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "idx", 3, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "target", 4, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       344,
       kUnsetSize},
      {"cpuhp_enter",
       "cpuhp",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "cpu", 1, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "fun", 2, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "idx", 3, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "target", 4, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       345,
       kUnsetSize},
      {"cpuhp_latency",
       "cpuhp",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "cpu", 1, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "ret", 2, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "state", 3, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "time", 4, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       346,
       kUnsetSize},
      {"cpuhp_pause",
       "cpuhp",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "active_cpus", 1, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "cpus", 2, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "pause", 3, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "time", 4, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       352,
       kUnsetSize},
      {"cros_ec_sensorhub_data",
       "cros_ec",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "current_time", 1, ProtoSchemaType::kInt64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "current_timestamp", 2, ProtoSchemaType::kInt64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "delta", 3, ProtoSchemaType::kInt64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "ec_fifo_timestamp", 4, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "ec_sensor_num", 5, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "fifo_timestamp", 6, ProtoSchemaType::kInt64,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       364,
       kUnsetSize},
      {"dcvsh_freq",
       "dcvsh",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "cpu", 1, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "freq", 2, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       508,
       kUnsetSize},
      {"devfreq_frequency",
       "devfreq",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "dev_name", 1, ProtoSchemaType::kString,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "freq", 2, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "prev_freq", 3, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "busy_time", 4, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "total_time", 5, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       541,
       kUnsetSize},
      {"dma_fence_init",
       "dma_fence",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "context", 1, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "driver", 2, ProtoSchemaType::kString,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "seqno", 3, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "timeline", 4, ProtoSchemaType::kString,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       414,
       kUnsetSize},
      {"dma_fence_emit",
       "dma_fence",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "context", 1, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "driver", 2, ProtoSchemaType::kString,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "seqno", 3, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "timeline", 4, ProtoSchemaType::kString,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       415,
       kUnsetSize},
      {"dma_fence_signaled",
       "dma_fence",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "context", 1, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "driver", 2, ProtoSchemaType::kString,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "seqno", 3, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "timeline", 4, ProtoSchemaType::kString,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       416,
       kUnsetSize},
      {"dma_fence_wait_start",
       "dma_fence",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "context", 1, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "driver", 2, ProtoSchemaType::kString,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "seqno", 3, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "timeline", 4, ProtoSchemaType::kString,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       417,
       kUnsetSize},
      {"dma_fence_wait_end",
       "dma_fence",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "context", 1, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "driver", 2, ProtoSchemaType::kString,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "seqno", 3, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "timeline", 4, ProtoSchemaType::kString,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       418,
       kUnsetSize},
      {"dma_heap_stat",
       "dmabuf_heap",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "inode", 1, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "len", 2, ProtoSchemaType::kInt64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "total_allocated", 3, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       351,
       kUnsetSize},
      {"tracing_mark_write",
       "dpu",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "pid", 1, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "trace_name", 2, ProtoSchemaType::kString,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "trace_begin", 3, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "name", 4, ProtoSchemaType::kString,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "type", 5, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "value", 6, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       348,
       kUnsetSize},
      {"dsi_cmd_fifo_status",
       "dpu",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "header", 1, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "payload", 2, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       492,
       kUnsetSize},
      {"dsi_rx",
       "dpu",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "cmd", 1, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "rx_buf", 2, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       493,
       kUnsetSize},
      {"dsi_tx",
       "dpu",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "type", 1, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "tx_buf", 2, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "last", 3, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "delay_ms", 4, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       494,
       kUnsetSize},
      {"disp_dpu_underrun",
       "dpu",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "id", 1, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "frames_pending", 2, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "vsync_count", 3, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       549,
       kUnsetSize},
      {"disp_vblank_irq_enable",
       "dpu",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "id", 1, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "output_id", 2, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "enable", 3, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       550,
       kUnsetSize},
      {"drm_vblank_event",
       "drm",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "crtc", 1, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "high_prec", 2, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "seq", 3, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "time", 4, ProtoSchemaType::kInt64,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       409,
       kUnsetSize},
      {"drm_vblank_event_delivered",
       "drm",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "crtc", 1, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "file", 2, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "seq", 3, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       410,
       kUnsetSize},
      {"dwc3_alloc_request",
       "dwc3",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "name", 1, ProtoSchemaType::kString,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "req", 2, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "actual", 3, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "length", 4, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "status", 5, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "zero", 6, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "short_not_ok", 7, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "no_interrupt", 8, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       561,
       kUnsetSize},
      {"dwc3_complete_trb",
       "dwc3",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "name", 1, ProtoSchemaType::kString,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "trb", 2, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "allocated", 3, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "queued", 4, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "bpl", 5, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "bph", 6, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "size", 7, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "ctrl", 8, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "type", 9, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "enqueue", 10, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "dequeue", 11, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       562,
       kUnsetSize},
      {"dwc3_ctrl_req",
       "dwc3",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "bRequestType", 1, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "bRequest", 2, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "wValue", 3, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "wIndex", 4, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "wLength", 5, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "str", 6, ProtoSchemaType::kString,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       563,
       kUnsetSize},
      {"dwc3_ep_dequeue",
       "dwc3",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "name", 1, ProtoSchemaType::kString,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "req", 2, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "actual", 3, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "length", 4, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "status", 5, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "zero", 6, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "short_not_ok", 7, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "no_interrupt", 8, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       564,
       kUnsetSize},
      {"dwc3_ep_queue",
       "dwc3",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "name", 1, ProtoSchemaType::kString,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "req", 2, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "actual", 3, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "length", 4, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "status", 5, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "zero", 6, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "short_not_ok", 7, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "no_interrupt", 8, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       565,
       kUnsetSize},
      {"dwc3_event",
       "dwc3",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "event", 1, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "ep0state", 2, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "str", 3, ProtoSchemaType::kString,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       566,
       kUnsetSize},
      {"dwc3_free_request",
       "dwc3",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "name", 1, ProtoSchemaType::kString,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "req", 2, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "actual", 3, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "length", 4, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "status", 5, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "zero", 6, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "short_not_ok", 7, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "no_interrupt", 8, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       567,
       kUnsetSize},
      {"dwc3_gadget_ep_cmd",
       "dwc3",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "name", 1, ProtoSchemaType::kString,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "cmd", 2, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "param0", 3, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "param1", 4, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "param2", 5, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "cmd_status", 6, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       568,
       kUnsetSize},
      {"dwc3_gadget_ep_disable",
       "dwc3",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "name", 1, ProtoSchemaType::kString,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "maxpacket", 2, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "maxpacket_limit", 3, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "max_streams", 4, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "maxburst", 5, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "flags", 6, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "direction", 7, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "trb_enqueue", 8, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "trb_dequeue", 9, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       569,
       kUnsetSize},
      {"dwc3_gadget_ep_enable",
       "dwc3",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "name", 1, ProtoSchemaType::kString,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "maxpacket", 2, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "maxpacket_limit", 3, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "max_streams", 4, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "maxburst", 5, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "flags", 6, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "direction", 7, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "trb_enqueue", 8, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "trb_dequeue", 9, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       570,
       kUnsetSize},
      {"dwc3_gadget_generic_cmd",
       "dwc3",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "cmd", 1, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "param", 2, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "status", 3, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       571,
       kUnsetSize},
      {"dwc3_gadget_giveback",
       "dwc3",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "name", 1, ProtoSchemaType::kString,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "req", 2, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "actual", 3, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "length", 4, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "status", 5, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "zero", 6, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "short_not_ok", 7, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "no_interrupt", 8, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       572,
       kUnsetSize},
      {"dwc3_prepare_trb",
       "dwc3",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "name", 1, ProtoSchemaType::kString,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "trb", 2, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "allocated", 3, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "queued", 4, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "bpl", 5, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "bph", 6, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "size", 7, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "ctrl", 8, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "type", 9, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "enqueue", 10, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "dequeue", 11, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       573,
       kUnsetSize},
      {"dwc3_readl",
       "dwc3",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "base", 1, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "offset", 2, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "value", 3, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "msg", 4, ProtoSchemaType::kString,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       574,
       kUnsetSize},
      {"dwc3_writel",
       "dwc3",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "base", 1, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "offset", 2, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "value", 3, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "msg", 4, ProtoSchemaType::kString,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       575,
       kUnsetSize},
      {"ext4_da_write_begin",
       "ext4",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "dev", 1, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "ino", 2, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "pos", 3, ProtoSchemaType::kInt64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "len", 4, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "flags", 5, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       41,
       kUnsetSize},
      {"ext4_da_write_end",
       "ext4",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "dev", 1, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "ino", 2, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "pos", 3, ProtoSchemaType::kInt64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "len", 4, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "copied", 5, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       42,
       kUnsetSize},
      {"ext4_sync_file_enter",
       "ext4",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "dev", 1, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "ino", 2, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "parent", 3, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "datasync", 4, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       43,
       kUnsetSize},
      {"ext4_sync_file_exit",
       "ext4",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "dev", 1, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "ino", 2, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "ret", 3, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       44,
       kUnsetSize},
      {"ext4_alloc_da_blocks",
       "ext4",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "dev", 1, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "ino", 2, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "data_blocks", 3, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "meta_blocks", 4, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       134,
       kUnsetSize},
      {"ext4_allocate_blocks",
       "ext4",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "dev", 1, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "ino", 2, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "block", 3, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "len", 4, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "logical", 5, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "lleft", 6, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "lright", 7, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "goal", 8, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "pleft", 9, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "pright", 10, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "flags", 11, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       135,
       kUnsetSize},
      {"ext4_allocate_inode",
       "ext4",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "dev", 1, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "ino", 2, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "dir", 3, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "mode", 4, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       136,
       kUnsetSize},
      {"ext4_begin_ordered_truncate",
       "ext4",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "dev", 1, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "ino", 2, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "new_size", 3, ProtoSchemaType::kInt64,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       137,
       kUnsetSize},
      {"ext4_collapse_range",
       "ext4",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "dev", 1, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "ino", 2, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "offset", 3, ProtoSchemaType::kInt64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "len", 4, ProtoSchemaType::kInt64,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       138,
       kUnsetSize},
      {"ext4_da_release_space",
       "ext4",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "dev", 1, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "ino", 2, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "i_blocks", 3, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "freed_blocks", 4, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "reserved_data_blocks", 5, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "reserved_meta_blocks", 6, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "allocated_meta_blocks", 7, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "mode", 8, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       139,
       kUnsetSize},
      {"ext4_da_reserve_space",
       "ext4",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "dev", 1, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "ino", 2, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "i_blocks", 3, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "reserved_data_blocks", 4, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "reserved_meta_blocks", 5, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "mode", 6, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "md_needed", 7, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       140,
       kUnsetSize},
      {"ext4_da_update_reserve_space",
       "ext4",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "dev", 1, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "ino", 2, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "i_blocks", 3, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "used_blocks", 4, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "reserved_data_blocks", 5, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "reserved_meta_blocks", 6, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "allocated_meta_blocks", 7, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "quota_claim", 8, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "mode", 9, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       141,
       kUnsetSize},
      {"ext4_da_write_pages",
       "ext4",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "dev", 1, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "ino", 2, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "first_page", 3, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "nr_to_write", 4, ProtoSchemaType::kInt64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "sync_mode", 5, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "b_blocknr", 6, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "b_size", 7, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "b_state", 8, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "io_done", 9, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "pages_written", 10, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       142,
       kUnsetSize},
      {"ext4_da_write_pages_extent",
       "ext4",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "dev", 1, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "ino", 2, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "lblk", 3, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "len", 4, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "flags", 5, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       143,
       kUnsetSize},
      {"ext4_direct_IO_enter",
       "ext4",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "dev", 1, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "ino", 2, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "pos", 3, ProtoSchemaType::kInt64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "len", 4, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "rw", 5, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       144,
       kUnsetSize},
      {"ext4_direct_IO_exit",
       "ext4",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "dev", 1, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "ino", 2, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "pos", 3, ProtoSchemaType::kInt64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "len", 4, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "rw", 5, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "ret", 6, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       145,
       kUnsetSize},
      {"ext4_discard_blocks",
       "ext4",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "dev", 1, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "blk", 2, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "count", 3, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       146,
       kUnsetSize},
      {"ext4_discard_preallocations",
       "ext4",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "dev", 1, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "ino", 2, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "len", 3, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "needed", 4, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       147,
       kUnsetSize},
      {"ext4_drop_inode",
       "ext4",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "dev", 1, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "ino", 2, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "drop", 3, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       148,
       kUnsetSize},
      {"ext4_es_cache_extent",
       "ext4",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "dev", 1, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "ino", 2, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "lblk", 3, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "len", 4, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "pblk", 5, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "status", 6, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       149,
       kUnsetSize},
      {"ext4_es_find_delayed_extent_range_enter",
       "ext4",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "dev", 1, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "ino", 2, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "lblk", 3, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       150,
       kUnsetSize},
      {"ext4_es_find_delayed_extent_range_exit",
       "ext4",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "dev", 1, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "ino", 2, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "lblk", 3, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "len", 4, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "pblk", 5, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "status", 6, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       151,
       kUnsetSize},
      {"ext4_es_insert_extent",
       "ext4",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "dev", 1, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "ino", 2, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "lblk", 3, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "len", 4, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "pblk", 5, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "status", 6, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       152,
       kUnsetSize},
      {"ext4_es_lookup_extent_enter",
       "ext4",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "dev", 1, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "ino", 2, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "lblk", 3, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       153,
       kUnsetSize},
      {"ext4_es_lookup_extent_exit",
       "ext4",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "dev", 1, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "ino", 2, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "lblk", 3, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "len", 4, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "pblk", 5, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "status", 6, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "found", 7, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       154,
       kUnsetSize},
      {"ext4_es_remove_extent",
       "ext4",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "dev", 1, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "ino", 2, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "lblk", 3, ProtoSchemaType::kInt64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "len", 4, ProtoSchemaType::kInt64,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       155,
       kUnsetSize},
      {"ext4_es_shrink",
       "ext4",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "dev", 1, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "nr_shrunk", 2, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "scan_time", 3, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "nr_skipped", 4, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "retried", 5, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       156,
       kUnsetSize},
      {"ext4_es_shrink_count",
       "ext4",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "dev", 1, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "nr_to_scan", 2, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "cache_cnt", 3, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       157,
       kUnsetSize},
      {"ext4_es_shrink_scan_enter",
       "ext4",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "dev", 1, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "nr_to_scan", 2, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "cache_cnt", 3, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       158,
       kUnsetSize},
      {"ext4_es_shrink_scan_exit",
       "ext4",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "dev", 1, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "nr_shrunk", 2, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "cache_cnt", 3, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       159,
       kUnsetSize},
      {"ext4_evict_inode",
       "ext4",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "dev", 1, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "ino", 2, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "nlink", 3, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       160,
       kUnsetSize},
      {"ext4_ext_convert_to_initialized_enter",
       "ext4",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "dev", 1, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "ino", 2, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "m_lblk", 3, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "m_len", 4, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "u_lblk", 5, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "u_len", 6, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "u_pblk", 7, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       161,
       kUnsetSize},
      {"ext4_ext_convert_to_initialized_fastpath",
       "ext4",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "dev", 1, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "ino", 2, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "m_lblk", 3, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "m_len", 4, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "u_lblk", 5, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "u_len", 6, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "u_pblk", 7, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "i_lblk", 8, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "i_len", 9, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "i_pblk", 10, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       162,
       kUnsetSize},
      {"ext4_ext_handle_unwritten_extents",
       "ext4",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "dev", 1, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "ino", 2, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "flags", 3, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "lblk", 4, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "pblk", 5, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "len", 6, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "allocated", 7, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "newblk", 8, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       163,
       kUnsetSize},
      {"ext4_ext_in_cache",
       "ext4",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "dev", 1, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "ino", 2, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "lblk", 3, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "ret", 4, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       164,
       kUnsetSize},
      {"ext4_ext_load_extent",
       "ext4",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "dev", 1, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "ino", 2, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "pblk", 3, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "lblk", 4, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       165,
       kUnsetSize},
      {"ext4_ext_map_blocks_enter",
       "ext4",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "dev", 1, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "ino", 2, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "lblk", 3, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "len", 4, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "flags", 5, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       166,
       kUnsetSize},
      {"ext4_ext_map_blocks_exit",
       "ext4",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "dev", 1, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "ino", 2, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "flags", 3, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "pblk", 4, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "lblk", 5, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "len", 6, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "mflags", 7, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "ret", 8, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       167,
       kUnsetSize},
      {"ext4_ext_put_in_cache",
       "ext4",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "dev", 1, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "ino", 2, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "lblk", 3, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "len", 4, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "start", 5, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       168,
       kUnsetSize},
      {"ext4_ext_remove_space",
       "ext4",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "dev", 1, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "ino", 2, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "start", 3, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "end", 4, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "depth", 5, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       169,
       kUnsetSize},
      {"ext4_ext_remove_space_done",
       "ext4",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "dev", 1, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "ino", 2, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "start", 3, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "end", 4, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "depth", 5, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "partial", 6, ProtoSchemaType::kInt64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "eh_entries", 7, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "pc_lblk", 8, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "pc_pclu", 9, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "pc_state", 10, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       170,
       kUnsetSize},
      {"ext4_ext_rm_idx",
       "ext4",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "dev", 1, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "ino", 2, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "pblk", 3, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       171,
       kUnsetSize},
      {"ext4_ext_rm_leaf",
       "ext4",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "dev", 1, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "ino", 2, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "partial", 3, ProtoSchemaType::kInt64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "start", 4, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "ee_lblk", 5, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "ee_pblk", 6, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "ee_len", 7, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "pc_lblk", 8, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "pc_pclu", 9, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "pc_state", 10, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       172,
       kUnsetSize},
      {"ext4_ext_show_extent",
       "ext4",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "dev", 1, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "ino", 2, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "pblk", 3, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "lblk", 4, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "len", 5, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       173,
       kUnsetSize},
      {"ext4_fallocate_enter",
       "ext4",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "dev", 1, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "ino", 2, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "offset", 3, ProtoSchemaType::kInt64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "len", 4, ProtoSchemaType::kInt64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "mode", 5, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "pos", 6, ProtoSchemaType::kInt64,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       174,
       kUnsetSize},
      {"ext4_fallocate_exit",
       "ext4",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "dev", 1, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "ino", 2, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "pos", 3, ProtoSchemaType::kInt64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "blocks", 4, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "ret", 5, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       175,
       kUnsetSize},
      {"ext4_find_delalloc_range",
       "ext4",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "dev", 1, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "ino", 2, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "from", 3, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "to", 4, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "reverse", 5, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "found", 6, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "found_blk", 7, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       176,
       kUnsetSize},
      {"ext4_forget",
       "ext4",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "dev", 1, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "ino", 2, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "block", 3, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "is_metadata", 4, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "mode", 5, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       177,
       kUnsetSize},
      {"ext4_free_blocks",
       "ext4",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "dev", 1, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "ino", 2, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "block", 3, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "count", 4, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "flags", 5, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "mode", 6, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       178,
       kUnsetSize},
      {"ext4_free_inode",
       "ext4",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "dev", 1, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "ino", 2, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "uid", 3, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "gid", 4, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "blocks", 5, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "mode", 6, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       179,
       kUnsetSize},
      {"ext4_get_implied_cluster_alloc_exit",
       "ext4",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "dev", 1, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "flags", 2, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "lblk", 3, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "pblk", 4, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "len", 5, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "ret", 6, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       180,
       kUnsetSize},
      {"ext4_get_reserved_cluster_alloc",
       "ext4",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "dev", 1, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "ino", 2, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "lblk", 3, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "len", 4, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       181,
       kUnsetSize},
      {"ext4_ind_map_blocks_enter",
       "ext4",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "dev", 1, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "ino", 2, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "lblk", 3, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "len", 4, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "flags", 5, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       182,
       kUnsetSize},
      {"ext4_ind_map_blocks_exit",
       "ext4",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "dev", 1, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "ino", 2, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "flags", 3, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "pblk", 4, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "lblk", 5, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "len", 6, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "mflags", 7, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "ret", 8, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       183,
       kUnsetSize},
      {"ext4_insert_range",
       "ext4",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "dev", 1, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "ino", 2, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "offset", 3, ProtoSchemaType::kInt64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "len", 4, ProtoSchemaType::kInt64,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       184,
       kUnsetSize},
      {"ext4_invalidatepage",
       "ext4",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "dev", 1, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "ino", 2, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "index", 3, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "offset", 4, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "length", 5, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       185,
       kUnsetSize},
      {"ext4_journal_start",
       "ext4",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "dev", 1, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "ip", 2, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "blocks", 3, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "rsv_blocks", 4, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "nblocks", 5, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "revoke_creds", 6, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       186,
       kUnsetSize},
      {"ext4_journal_start_reserved",
       "ext4",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "dev", 1, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "ip", 2, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "blocks", 3, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       187,
       kUnsetSize},
      {"ext4_journalled_invalidatepage",
       "ext4",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "dev", 1, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "ino", 2, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "index", 3, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "offset", 4, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "length", 5, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       188,
       kUnsetSize},
      {"ext4_journalled_write_end",
       "ext4",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "dev", 1, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "ino", 2, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "pos", 3, ProtoSchemaType::kInt64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "len", 4, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "copied", 5, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       189,
       kUnsetSize},
      {"ext4_load_inode",
       "ext4",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "dev", 1, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "ino", 2, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       190,
       kUnsetSize},
      {"ext4_load_inode_bitmap",
       "ext4",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "dev", 1, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "group", 2, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       191,
       kUnsetSize},
      {"ext4_mark_inode_dirty",
       "ext4",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "dev", 1, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "ino", 2, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "ip", 3, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       192,
       kUnsetSize},
      {"ext4_mb_bitmap_load",
       "ext4",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "dev", 1, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "group", 2, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       193,
       kUnsetSize},
      {"ext4_mb_buddy_bitmap_load",
       "ext4",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "dev", 1, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "group", 2, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       194,
       kUnsetSize},
      {"ext4_mb_discard_preallocations",
       "ext4",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "dev", 1, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "needed", 2, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       195,
       kUnsetSize},
      {"ext4_mb_new_group_pa",
       "ext4",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "dev", 1, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "ino", 2, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "pa_pstart", 3, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "pa_lstart", 4, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "pa_len", 5, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       196,
       kUnsetSize},
      {"ext4_mb_new_inode_pa",
       "ext4",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "dev", 1, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "ino", 2, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "pa_pstart", 3, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "pa_lstart", 4, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "pa_len", 5, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       197,
       kUnsetSize},
      {"ext4_mb_release_group_pa",
       "ext4",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "dev", 1, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "pa_pstart", 2, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "pa_len", 3, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       198,
       kUnsetSize},
      {"ext4_mb_release_inode_pa",
       "ext4",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "dev", 1, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "ino", 2, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "block", 3, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "count", 4, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       199,
       kUnsetSize},
      {"ext4_mballoc_alloc",
       "ext4",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "dev", 1, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "ino", 2, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "orig_logical", 3, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "orig_start", 4, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "orig_group", 5, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "orig_len", 6, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "goal_logical", 7, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "goal_start", 8, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "goal_group", 9, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "goal_len", 10, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "result_logical", 11, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "result_start", 12, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "result_group", 13, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "result_len", 14, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "found", 15, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "groups", 16, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "buddy", 17, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "flags", 18, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "tail", 19, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "cr", 20, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       200,
       kUnsetSize},
      {"ext4_mballoc_discard",
       "ext4",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "dev", 1, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "ino", 2, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "result_start", 3, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "result_group", 4, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "result_len", 5, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       201,
       kUnsetSize},
      {"ext4_mballoc_free",
       "ext4",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "dev", 1, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "ino", 2, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "result_start", 3, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "result_group", 4, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "result_len", 5, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       202,
       kUnsetSize},
      {"ext4_mballoc_prealloc",
       "ext4",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "dev", 1, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "ino", 2, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "orig_logical", 3, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "orig_start", 4, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "orig_group", 5, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "orig_len", 6, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "result_logical", 7, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "result_start", 8, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "result_group", 9, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "result_len", 10, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       203,
       kUnsetSize},
      {"ext4_other_inode_update_time",
       "ext4",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "dev", 1, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "ino", 2, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "orig_ino", 3, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "uid", 4, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "gid", 5, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "mode", 6, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       204,
       kUnsetSize},
      {"ext4_punch_hole",
       "ext4",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "dev", 1, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "ino", 2, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "offset", 3, ProtoSchemaType::kInt64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "len", 4, ProtoSchemaType::kInt64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "mode", 5, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       205,
       kUnsetSize},
      {"ext4_read_block_bitmap_load",
       "ext4",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "dev", 1, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "group", 2, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "prefetch", 3, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       206,
       kUnsetSize},
      {"ext4_readpage",
       "ext4",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "dev", 1, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "ino", 2, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "index", 3, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       207,
       kUnsetSize},
      {"ext4_releasepage",
       "ext4",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "dev", 1, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "ino", 2, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "index", 3, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       208,
       kUnsetSize},
      {"ext4_remove_blocks",
       "ext4",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "dev", 1, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "ino", 2, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "from", 3, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "to", 4, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "partial", 5, ProtoSchemaType::kInt64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "ee_pblk", 6, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "ee_lblk", 7, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "ee_len", 8, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "pc_lblk", 9, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "pc_pclu", 10, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "pc_state", 11, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       209,
       kUnsetSize},
      {"ext4_request_blocks",
       "ext4",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "dev", 1, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "ino", 2, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "len", 3, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "logical", 4, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "lleft", 5, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "lright", 6, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "goal", 7, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "pleft", 8, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "pright", 9, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "flags", 10, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       210,
       kUnsetSize},
      {"ext4_request_inode",
       "ext4",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "dev", 1, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "dir", 2, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "mode", 3, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       211,
       kUnsetSize},
      {"ext4_sync_fs",
       "ext4",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "dev", 1, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "wait", 2, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       212,
       kUnsetSize},
      {"ext4_trim_all_free",
       "ext4",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "dev_major", 1, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "dev_minor", 2, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "group", 3, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "start", 4, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "len", 5, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       213,
       kUnsetSize},
      {"ext4_trim_extent",
       "ext4",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "dev_major", 1, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "dev_minor", 2, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "group", 3, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "start", 4, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "len", 5, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       214,
       kUnsetSize},
      {"ext4_truncate_enter",
       "ext4",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "dev", 1, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "ino", 2, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "blocks", 3, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       215,
       kUnsetSize},
      {"ext4_truncate_exit",
       "ext4",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "dev", 1, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "ino", 2, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "blocks", 3, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       216,
       kUnsetSize},
      {"ext4_unlink_enter",
       "ext4",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "dev", 1, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "ino", 2, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "parent", 3, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "size", 4, ProtoSchemaType::kInt64,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       217,
       kUnsetSize},
      {"ext4_unlink_exit",
       "ext4",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "dev", 1, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "ino", 2, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "ret", 3, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       218,
       kUnsetSize},
      {"ext4_write_begin",
       "ext4",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "dev", 1, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "ino", 2, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "pos", 3, ProtoSchemaType::kInt64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "len", 4, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "flags", 5, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       219,
       kUnsetSize},
      {"ext4_write_end",
       "ext4",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "dev", 1, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "ino", 2, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "pos", 3, ProtoSchemaType::kInt64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "len", 4, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "copied", 5, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       230,
       kUnsetSize},
      {"ext4_writepage",
       "ext4",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "dev", 1, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "ino", 2, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "index", 3, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       231,
       kUnsetSize},
      {"ext4_writepages",
       "ext4",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "dev", 1, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "ino", 2, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "nr_to_write", 3, ProtoSchemaType::kInt64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "pages_skipped", 4, ProtoSchemaType::kInt64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "range_start", 5, ProtoSchemaType::kInt64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "range_end", 6, ProtoSchemaType::kInt64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "writeback_index", 7, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "sync_mode", 8, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "for_kupdate", 9, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "range_cyclic", 10, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       232,
       kUnsetSize},
      {"ext4_writepages_result",
       "ext4",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "dev", 1, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "ino", 2, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "ret", 3, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "pages_written", 4, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "pages_skipped", 5, ProtoSchemaType::kInt64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "writeback_index", 6, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "sync_mode", 7, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       233,
       kUnsetSize},
      {"ext4_zero_range",
       "ext4",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "dev", 1, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "ino", 2, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "offset", 3, ProtoSchemaType::kInt64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "len", 4, ProtoSchemaType::kInt64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "mode", 5, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       234,
       kUnsetSize},
      {"f2fs_do_submit_bio",
       "f2fs",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "dev", 1, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "btype", 2, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "sync", 3, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "sector", 4, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "size", 5, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       243,
       kUnsetSize},
      {"f2fs_evict_inode",
       "f2fs",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "dev", 1, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "ino", 2, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "pino", 3, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "mode", 4, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "size", 5, ProtoSchemaType::kInt64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "nlink", 6, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "blocks", 7, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "advise", 8, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       244,
       kUnsetSize},
      {"f2fs_fallocate",
       "f2fs",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "dev", 1, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "ino", 2, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "mode", 3, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "offset", 4, ProtoSchemaType::kInt64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "len", 5, ProtoSchemaType::kInt64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "size", 6, ProtoSchemaType::kInt64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "blocks", 7, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "ret", 8, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       245,
       kUnsetSize},
      {"f2fs_get_data_block",
       "f2fs",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "dev", 1, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "ino", 2, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "iblock", 3, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "bh_start", 4, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "bh_size", 5, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "ret", 6, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       246,
       kUnsetSize},
      {"f2fs_get_victim",
       "f2fs",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "dev", 1, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "type", 2, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "gc_type", 3, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "alloc_mode", 4, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "gc_mode", 5, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "victim", 6, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "ofs_unit", 7, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "pre_victim", 8, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "prefree", 9, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "free", 10, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "cost", 11, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       247,
       kUnsetSize},
      {"f2fs_iget",
       "f2fs",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "dev", 1, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "ino", 2, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "pino", 3, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "mode", 4, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "size", 5, ProtoSchemaType::kInt64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "nlink", 6, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "blocks", 7, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "advise", 8, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       248,
       kUnsetSize},
      {"f2fs_iget_exit",
       "f2fs",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "dev", 1, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "ino", 2, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "ret", 3, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       249,
       kUnsetSize},
      {"f2fs_new_inode",
       "f2fs",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "dev", 1, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "ino", 2, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "ret", 3, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       250,
       kUnsetSize},
      {"f2fs_readpage",
       "f2fs",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "dev", 1, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "ino", 2, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "index", 3, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "blkaddr", 4, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "type", 5, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "dir", 6, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "dirty", 7, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "uptodate", 8, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       251,
       kUnsetSize},
      {"f2fs_reserve_new_block",
       "f2fs",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "dev", 1, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "nid", 2, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "ofs_in_node", 3, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       252,
       kUnsetSize},
      {"f2fs_set_page_dirty",
       "f2fs",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "dev", 1, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "ino", 2, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "type", 3, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "dir", 4, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "index", 5, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "dirty", 6, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "uptodate", 7, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       253,
       kUnsetSize},
      {"f2fs_submit_write_page",
       "f2fs",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "dev", 1, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "ino", 2, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "type", 3, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "index", 4, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "block", 5, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       254,
       kUnsetSize},
      {"f2fs_sync_file_enter",
       "f2fs",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "dev", 1, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "ino", 2, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "pino", 3, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "mode", 4, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "size", 5, ProtoSchemaType::kInt64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "nlink", 6, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "blocks", 7, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "advise", 8, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       255,
       kUnsetSize},
      {"f2fs_sync_file_exit",
       "f2fs",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "dev", 1, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "ino", 2, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "need_cp", 3, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "datasync", 4, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "ret", 5, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "cp_reason", 6, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       256,
       kUnsetSize},
      {"f2fs_sync_fs",
       "f2fs",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "dev", 1, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "dirty", 2, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "wait", 3, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       257,
       kUnsetSize},
      {"f2fs_truncate",
       "f2fs",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "dev", 1, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "ino", 2, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "pino", 3, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "mode", 4, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "size", 5, ProtoSchemaType::kInt64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "nlink", 6, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "blocks", 7, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "advise", 8, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       258,
       kUnsetSize},
      {"f2fs_truncate_blocks_enter",
       "f2fs",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "dev", 1, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "ino", 2, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "size", 3, ProtoSchemaType::kInt64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "blocks", 4, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "from", 5, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       259,
       kUnsetSize},
      {"f2fs_truncate_blocks_exit",
       "f2fs",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "dev", 1, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "ino", 2, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "ret", 3, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       260,
       kUnsetSize},
      {"f2fs_truncate_data_blocks_range",
       "f2fs",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "dev", 1, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "ino", 2, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "nid", 3, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "ofs", 4, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "free", 5, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       261,
       kUnsetSize},
      {"f2fs_truncate_inode_blocks_enter",
       "f2fs",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "dev", 1, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "ino", 2, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "size", 3, ProtoSchemaType::kInt64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "blocks", 4, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "from", 5, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       262,
       kUnsetSize},
      {"f2fs_truncate_inode_blocks_exit",
       "f2fs",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "dev", 1, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "ino", 2, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "ret", 3, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       263,
       kUnsetSize},
      {"f2fs_truncate_node",
       "f2fs",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "dev", 1, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "ino", 2, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "nid", 3, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "blk_addr", 4, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       264,
       kUnsetSize},
      {"f2fs_truncate_nodes_enter",
       "f2fs",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "dev", 1, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "ino", 2, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "nid", 3, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "blk_addr", 4, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       265,
       kUnsetSize},
      {"f2fs_truncate_nodes_exit",
       "f2fs",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "dev", 1, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "ino", 2, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "ret", 3, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       266,
       kUnsetSize},
      {"f2fs_truncate_partial_nodes",
       "f2fs",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "dev", 1, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "ino", 2, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "depth", 4, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "err", 5, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       267,
       kUnsetSize},
      {"f2fs_unlink_enter",
       "f2fs",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "dev", 1, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "ino", 2, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "size", 3, ProtoSchemaType::kInt64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "blocks", 4, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "name", 5, ProtoSchemaType::kString,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       268,
       kUnsetSize},
      {"f2fs_unlink_exit",
       "f2fs",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "dev", 1, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "ino", 2, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "ret", 3, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       269,
       kUnsetSize},
      {"f2fs_vm_page_mkwrite",
       "f2fs",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "dev", 1, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "ino", 2, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "type", 3, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "dir", 4, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "index", 5, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "dirty", 6, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "uptodate", 7, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       270,
       kUnsetSize},
      {"f2fs_write_begin",
       "f2fs",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "dev", 1, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "ino", 2, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "pos", 3, ProtoSchemaType::kInt64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "len", 4, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "flags", 5, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       271,
       kUnsetSize},
      {"f2fs_write_checkpoint",
       "f2fs",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "dev", 1, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "is_umount", 2, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "msg", 3, ProtoSchemaType::kString,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "reason", 4, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       272,
       kUnsetSize},
      {"f2fs_write_end",
       "f2fs",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "dev", 1, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "ino", 2, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "pos", 3, ProtoSchemaType::kInt64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "len", 4, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "copied", 5, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       273,
       kUnsetSize},
      {"f2fs_iostat",
       "f2fs",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "app_bio", 1, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "app_brio", 2, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "app_dio", 3, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "app_drio", 4, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "app_mio", 5, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "app_mrio", 6, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "app_rio", 7, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "app_wio", 8, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "dev", 9, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "fs_cdrio", 10, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "fs_cp_dio", 11, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "fs_cp_mio", 12, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "fs_cp_nio", 13, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "fs_dio", 14, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "fs_discard", 15, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "fs_drio", 16, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "fs_gc_dio", 17, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "fs_gc_nio", 18, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "fs_gdrio", 19, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "fs_mio", 20, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "fs_mrio", 21, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "fs_nio", 22, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "fs_nrio", 23, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       419,
       kUnsetSize},
      {"f2fs_iostat_latency",
       "f2fs",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "d_rd_avg", 1, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "d_rd_cnt", 2, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "d_rd_peak", 3, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "d_wr_as_avg", 4, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "d_wr_as_cnt", 5, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "d_wr_as_peak", 6, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "d_wr_s_avg", 7, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "d_wr_s_cnt", 8, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "d_wr_s_peak", 9, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "dev", 10, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "m_rd_avg", 11, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "m_rd_cnt", 12, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "m_rd_peak", 13, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "m_wr_as_avg", 14, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "m_wr_as_cnt", 15, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "m_wr_as_peak", 16, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "m_wr_s_avg", 17, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "m_wr_s_cnt", 18, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "m_wr_s_peak", 19, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "n_rd_avg", 20, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "n_rd_cnt", 21, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "n_rd_peak", 22, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "n_wr_as_avg", 23, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "n_wr_as_cnt", 24, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "n_wr_as_peak", 25, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "n_wr_s_avg", 26, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "n_wr_s_cnt", 27, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "n_wr_s_peak", 28, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       420,
       kUnsetSize},
      {"f2fs_background_gc",
       "f2fs",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "dev", 1, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "wait_ms", 2, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "prefree", 3, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "free", 4, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       495,
       kUnsetSize},
      {"f2fs_gc_begin",
       "f2fs",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "dev", 1, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "sync", 2, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "background", 3, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "dirty_nodes", 4, ProtoSchemaType::kInt64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "dirty_dents", 5, ProtoSchemaType::kInt64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "dirty_imeta", 6, ProtoSchemaType::kInt64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "free_sec", 7, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "free_seg", 8, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "reserved_seg", 9, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "prefree_seg", 10, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "gc_type", 11, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "no_bg_gc", 12, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "nr_free_secs", 13, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       496,
       kUnsetSize},
      {"f2fs_gc_end",
       "f2fs",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "dev", 1, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "ret", 2, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "seg_freed", 3, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "sec_freed", 4, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "dirty_nodes", 5, ProtoSchemaType::kInt64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "dirty_dents", 6, ProtoSchemaType::kInt64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "dirty_imeta", 7, ProtoSchemaType::kInt64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "free_sec", 8, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "free_seg", 9, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "reserved_seg", 10, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "prefree_seg", 11, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       497,
       kUnsetSize},
      {"fastrpc_dma_stat",
       "fastrpc",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "cid", 1, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "len", 2, ProtoSchemaType::kInt64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "total_allocated", 3, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       347,
       kUnsetSize},
      {"fastrpc_dma_free",
       "fastrpc",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "cid", 1, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "phys", 2, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "size", 3, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       498,
       kUnsetSize},
      {"fastrpc_dma_alloc",
       "fastrpc",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "cid", 1, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "phys", 2, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "size", 3, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "attr", 4, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "mflags", 5, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       499,
       kUnsetSize},
      {"fastrpc_dma_unmap",
       "fastrpc",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "cid", 1, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "phys", 2, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "size", 3, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       500,
       kUnsetSize},
      {"fastrpc_dma_map",
       "fastrpc",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "cid", 1, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "fd", 2, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "phys", 3, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "size", 4, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "len", 5, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "attr", 6, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "mflags", 7, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       501,
       kUnsetSize},
      {"fence_init",
       "fence",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "context", 1, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "driver", 2, ProtoSchemaType::kString,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "seqno", 3, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "timeline", 4, ProtoSchemaType::kString,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       316,
       kUnsetSize},
      {"fence_destroy",
       "fence",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "context", 1, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "driver", 2, ProtoSchemaType::kString,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "seqno", 3, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "timeline", 4, ProtoSchemaType::kString,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       317,
       kUnsetSize},
      {"fence_enable_signal",
       "fence",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "context", 1, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "driver", 2, ProtoSchemaType::kString,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "seqno", 3, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "timeline", 4, ProtoSchemaType::kString,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       318,
       kUnsetSize},
      {"fence_signaled",
       "fence",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "context", 1, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "driver", 2, ProtoSchemaType::kString,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "seqno", 3, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "timeline", 4, ProtoSchemaType::kString,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       319,
       kUnsetSize},
      {"mm_filemap_add_to_page_cache",
       "filemap",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "pfn", 1, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "i_ino", 2, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "index", 3, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "s_dev", 4, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "page", 5, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       97,
       kUnsetSize},
      {"mm_filemap_delete_from_page_cache",
       "filemap",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "pfn", 1, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "i_ino", 2, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "index", 3, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "s_dev", 4, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "page", 5, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       98,
       kUnsetSize},
      {"do_sys_open",
       "fs",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "filename", 1, ProtoSchemaType::kString,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "flags", 2, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "mode", 3, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       544,
       kUnsetSize},
      {"open_exec",
       "fs",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "filename", 1, ProtoSchemaType::kString,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       545,
       kUnsetSize},
      {"print",
       "ftrace",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "buf", 2, ProtoSchemaType::kString,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       3,
       kUnsetSize},
      {"funcgraph_entry",
       "ftrace",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "depth", 1, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "func", 2, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       437,
       kUnsetSize},
      {"funcgraph_exit",
       "ftrace",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "calltime", 1, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "depth", 2, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "func", 3, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "overrun", 4, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "rettime", 5, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       438,
       kUnsetSize},
      {"tracing_mark_write",
       "g2d",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "pid", 1, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "name", 4, ProtoSchemaType::kString,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "type", 5, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "value", 6, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       349,
       kUnsetSize},
      {"google_icc_event",
       "google_icc_trace",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "event", 1, ProtoSchemaType::kString,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "timestamp", 2, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       502,
       kUnsetSize},
      {"google_irm_event",
       "google_irm_trace",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "event", 1, ProtoSchemaType::kString,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "timestamp", 2, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       503,
       kUnsetSize},
      {"gpu_mem_total",
       "gpu_mem",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "gpu_id", 1, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "pid", 2, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "size", 3, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       340,
       kUnsetSize},
      {"drm_sched_job",
       "gpu_scheduler",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "entity", 1, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "fence", 2, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "hw_job_count", 3, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "id", 4, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "job_count", 5, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "name", 6, ProtoSchemaType::kString,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       411,
       kUnsetSize},
      {"drm_run_job",
       "gpu_scheduler",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "entity", 1, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "fence", 2, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "hw_job_count", 3, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "id", 4, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "job_count", 5, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "name", 6, ProtoSchemaType::kString,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       412,
       kUnsetSize},
      {"drm_sched_process_job",
       "gpu_scheduler",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "fence", 1, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       413,
       kUnsetSize},
      {"hyp_enter", "hyp", {}, kUnsetFtraceId, 476, kUnsetSize},
      {"hyp_exit", "hyp", {}, kUnsetFtraceId, 477, kUnsetSize},
      {"host_hcall",
       "hyp",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "id", 1, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "invalid", 2, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       478,
       kUnsetSize},
      {"host_smc",
       "hyp",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "id", 1, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "forwarded", 2, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       479,
       kUnsetSize},
      {"host_mem_abort",
       "hyp",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "esr", 1, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "addr", 2, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       480,
       kUnsetSize},
      {"host_ffa_call",
       "hyp",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "func_id", 1, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "res_a1", 2, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "res_a2", 3, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "res_a3", 4, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "res_a4", 5, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "handled", 6, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "err", 7, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       578,
       kUnsetSize},
      {"iommu_idmap",
       "hyp",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "from", 1, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "to", 2, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "prot", 3, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       580,
       kUnsetSize},
      {"psci_mem_protect",
       "hyp",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "count", 1, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "was", 2, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       581,
       kUnsetSize},
      {"host_hcall",
       "hypervisor",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "id", 1, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "invalid", 2, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       582,
       kUnsetSize},
      {"host_smc",
       "hypervisor",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "id", 1, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "forwarded", 2, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       583,
       kUnsetSize},
      {"hyp_exit", "hypervisor", {}, kUnsetFtraceId, 584, kUnsetSize},
      {"iommu_idmap",
       "hypervisor",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "from", 1, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "to", 2, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "prot", 3, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       585,
       kUnsetSize},
      {"psci_mem_protect",
       "hypervisor",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "count", 1, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "was", 2, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       586,
       kUnsetSize},
      {"host_mem_abort",
       "hypervisor",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "esr", 1, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "addr", 2, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       587,
       kUnsetSize},
      {"hyp_enter", "hypervisor", {}, kUnsetFtraceId, 588, kUnsetSize},
      {"iommu_idmap_complete",
       "hypervisor",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "map", 1, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       589,
       kUnsetSize},
      {"vcpu_illegal_trap",
       "hypervisor",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "esr", 1, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       590,
       kUnsetSize},
      {"i2c_read",
       "i2c",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "adapter_nr", 1, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "msg_nr", 2, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "addr", 3, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "flags", 4, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "len", 5, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       27,
       kUnsetSize},
      {"i2c_write",
       "i2c",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "adapter_nr", 1, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "msg_nr", 2, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "addr", 3, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "flags", 4, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "len", 5, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "buf", 6, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       28,
       kUnsetSize},
      {"i2c_result",
       "i2c",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "adapter_nr", 1, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "nr_msgs", 2, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "ret", 3, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       29,
       kUnsetSize},
      {"i2c_reply",
       "i2c",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "adapter_nr", 1, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "msg_nr", 2, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "addr", 3, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "flags", 4, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "len", 5, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "buf", 6, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       30,
       kUnsetSize},
      {"smbus_read",
       "i2c",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "adapter_nr", 1, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "flags", 2, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "addr", 3, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "command", 4, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "protocol", 5, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       31,
       kUnsetSize},
      {"smbus_write",
       "i2c",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "adapter_nr", 1, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "addr", 2, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "flags", 3, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "command", 4, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "len", 5, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "protocol", 6, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       32,
       kUnsetSize},
      {"smbus_result",
       "i2c",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "adapter_nr", 1, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "addr", 2, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "flags", 3, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "read_write", 4, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "command", 5, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "res", 6, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "protocol", 7, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       33,
       kUnsetSize},
      {"smbus_reply",
       "i2c",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "adapter_nr", 1, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "addr", 2, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "flags", 3, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "command", 4, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "len", 5, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "protocol", 6, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       34,
       kUnsetSize},
      {"ion_stat",
       "ion",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "buffer_id", 1, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "len", 2, ProtoSchemaType::kInt64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "total_allocated", 3, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       335,
       kUnsetSize},
      {"ipi_entry",
       "ipi",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "reason", 1, ProtoSchemaType::kString,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       21,
       kUnsetSize},
      {"ipi_exit",
       "ipi",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "reason", 1, ProtoSchemaType::kString,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       22,
       kUnsetSize},
      {"ipi_raise",
       "ipi",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "target_cpus", 1, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "reason", 2, ProtoSchemaType::kString,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       23,
       kUnsetSize},
      {"softirq_entry",
       "irq",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "vec", 1, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       24,
       kUnsetSize},
      {"softirq_exit",
       "irq",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "vec", 1, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       25,
       kUnsetSize},
      {"softirq_raise",
       "irq",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "vec", 1, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       26,
       kUnsetSize},
      {"irq_handler_entry",
       "irq",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "irq", 1, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "name", 2, ProtoSchemaType::kString,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "handler", 3, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       36,
       kUnsetSize},
      {"irq_handler_exit",
       "irq",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "irq", 1, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "ret", 2, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       37,
       kUnsetSize},
      {"local_timer_entry",
       "irq_vectors",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "vector", 1, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       559,
       kUnsetSize},
      {"local_timer_exit",
       "irq_vectors",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "vector", 1, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       560,
       kUnsetSize},
      {"gpu_frequency",
       "kgsl",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "gpu_freq", 1, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "gpu_id", 2, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       509,
       kUnsetSize},
      {"adreno_cmdbatch_queued",
       "kgsl",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "id", 1, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "timestamp", 2, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "queued", 3, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "flags", 4, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "prio", 5, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       534,
       kUnsetSize},
      {"adreno_cmdbatch_submitted",
       "kgsl",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "id", 1, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "timestamp", 2, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "inflight", 3, ProtoSchemaType::kInt64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "flags", 4, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "ticks", 5, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "secs", 6, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "usecs", 7, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "prio", 8, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "rb_id", 9, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "rptr", 10, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "wptr", 11, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "q_inflight", 12, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "dispatch_queue", 13, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       535,
       kUnsetSize},
      {"adreno_cmdbatch_sync",
       "kgsl",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "id", 1, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "timestamp", 2, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "ticks", 3, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "prio", 4, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       536,
       kUnsetSize},
      {"adreno_cmdbatch_retired",
       "kgsl",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "id", 1, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "timestamp", 2, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "inflight", 3, ProtoSchemaType::kInt64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "recovery", 4, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "flags", 5, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "start", 6, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "retire", 7, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "prio", 8, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "rb_id", 9, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "rptr", 10, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "wptr", 11, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "q_inflight", 12, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "fault_recovery", 13, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "dispatch_queue", 14, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "submitted_to_rb", 15, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "retired_on_gmu", 16, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "active", 17, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       537,
       kUnsetSize},
      {"alloc_pages_iommu_end",
       "kmem",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "gfp_flags", 1, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "order", 2, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       274,
       kUnsetSize},
      {"alloc_pages_iommu_fail",
       "kmem",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "gfp_flags", 1, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "order", 2, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       275,
       kUnsetSize},
      {"alloc_pages_iommu_start",
       "kmem",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "gfp_flags", 1, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "order", 2, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       276,
       kUnsetSize},
      {"alloc_pages_sys_end",
       "kmem",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "gfp_flags", 1, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "order", 2, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       277,
       kUnsetSize},
      {"alloc_pages_sys_fail",
       "kmem",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "gfp_flags", 1, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "order", 2, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       278,
       kUnsetSize},
      {"alloc_pages_sys_start",
       "kmem",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "gfp_flags", 1, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "order", 2, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       279,
       kUnsetSize},
      {"dma_alloc_contiguous_retry",
       "kmem",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "tries", 1, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       280,
       kUnsetSize},
      {"iommu_map_range",
       "kmem",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "chunk_size", 1, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "len", 2, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "pa", 3, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "va", 4, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       281,
       kUnsetSize},
      {"iommu_sec_ptbl_map_range_end",
       "kmem",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "len", 1, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "num", 2, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "pa", 3, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "sec_id", 4, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "va", 5, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       282,
       kUnsetSize},
      {"iommu_sec_ptbl_map_range_start",
       "kmem",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "len", 1, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "num", 2, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "pa", 3, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "sec_id", 4, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "va", 5, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       283,
       kUnsetSize},
      {"ion_alloc_buffer_end",
       "kmem",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "client_name", 1, ProtoSchemaType::kString,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "flags", 2, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "heap_name", 3, ProtoSchemaType::kString,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "len", 4, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "mask", 5, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       284,
       kUnsetSize},
      {"ion_alloc_buffer_fail",
       "kmem",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "client_name", 1, ProtoSchemaType::kString,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "error", 2, ProtoSchemaType::kInt64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "flags", 3, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "heap_name", 4, ProtoSchemaType::kString,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "len", 5, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "mask", 6, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       285,
       kUnsetSize},
      {"ion_alloc_buffer_fallback",
       "kmem",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "client_name", 1, ProtoSchemaType::kString,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "error", 2, ProtoSchemaType::kInt64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "flags", 3, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "heap_name", 4, ProtoSchemaType::kString,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "len", 5, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "mask", 6, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       286,
       kUnsetSize},
      {"ion_alloc_buffer_start",
       "kmem",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "client_name", 1, ProtoSchemaType::kString,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "flags", 2, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "heap_name", 3, ProtoSchemaType::kString,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "len", 4, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "mask", 5, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       287,
       kUnsetSize},
      {"ion_cp_alloc_retry",
       "kmem",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "tries", 1, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       288,
       kUnsetSize},
      {"ion_cp_secure_buffer_end",
       "kmem",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "align", 1, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "flags", 2, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "heap_name", 3, ProtoSchemaType::kString,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "len", 4, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       289,
       kUnsetSize},
      {"ion_cp_secure_buffer_start",
       "kmem",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "align", 1, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "flags", 2, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "heap_name", 3, ProtoSchemaType::kString,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "len", 4, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       290,
       kUnsetSize},
      {"ion_prefetching",
       "kmem",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "len", 1, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       291,
       kUnsetSize},
      {"ion_secure_cma_add_to_pool_end",
       "kmem",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "is_prefetch", 1, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "len", 2, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "pool_total", 3, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       292,
       kUnsetSize},
      {"ion_secure_cma_add_to_pool_start",
       "kmem",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "is_prefetch", 1, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "len", 2, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "pool_total", 3, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       293,
       kUnsetSize},
      {"ion_secure_cma_allocate_end",
       "kmem",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "align", 1, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "flags", 2, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "heap_name", 3, ProtoSchemaType::kString,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "len", 4, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       294,
       kUnsetSize},
      {"ion_secure_cma_allocate_start",
       "kmem",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "align", 1, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "flags", 2, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "heap_name", 3, ProtoSchemaType::kString,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "len", 4, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       295,
       kUnsetSize},
      {"ion_secure_cma_shrink_pool_end",
       "kmem",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "drained_size", 1, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "skipped_size", 2, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       296,
       kUnsetSize},
      {"ion_secure_cma_shrink_pool_start",
       "kmem",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "drained_size", 1, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "skipped_size", 2, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       297,
       kUnsetSize},
      {"kfree",
       "kmem",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "call_site", 1, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "ptr", 2, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       298,
       kUnsetSize},
      {"kmalloc",
       "kmem",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "bytes_alloc", 1, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "bytes_req", 2, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "call_site", 3, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "gfp_flags", 4, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "ptr", 5, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       299,
       kUnsetSize},
      {"kmalloc_node",
       "kmem",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "bytes_alloc", 1, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "bytes_req", 2, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "call_site", 3, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "gfp_flags", 4, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "node", 5, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "ptr", 6, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       300,
       kUnsetSize},
      {"kmem_cache_alloc",
       "kmem",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "bytes_alloc", 1, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "bytes_req", 2, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "call_site", 3, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "gfp_flags", 4, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "ptr", 5, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       301,
       kUnsetSize},
      {"kmem_cache_alloc_node",
       "kmem",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "bytes_alloc", 1, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "bytes_req", 2, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "call_site", 3, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "gfp_flags", 4, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "node", 5, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "ptr", 6, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       302,
       kUnsetSize},
      {"kmem_cache_free",
       "kmem",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "call_site", 1, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "ptr", 2, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       303,
       kUnsetSize},
      {"migrate_pages_end",
       "kmem",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "mode", 1, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       304,
       kUnsetSize},
      {"migrate_pages_start",
       "kmem",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "mode", 1, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       305,
       kUnsetSize},
      {"migrate_retry",
       "kmem",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "tries", 1, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       306,
       kUnsetSize},
      {"mm_page_alloc",
       "kmem",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "gfp_flags", 1, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "migratetype", 2, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "order", 3, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "page", 4, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "pfn", 5, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       307,
       kUnsetSize},
      {"mm_page_alloc_extfrag",
       "kmem",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "alloc_migratetype", 1, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "alloc_order", 2, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "fallback_migratetype", 3, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "fallback_order", 4, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "page", 5, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "change_ownership", 6, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "pfn", 7, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       308,
       kUnsetSize},
      {"mm_page_alloc_zone_locked",
       "kmem",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "migratetype", 1, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "order", 2, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "page", 3, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "pfn", 4, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       309,
       kUnsetSize},
      {"mm_page_free",
       "kmem",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "order", 1, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "page", 2, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "pfn", 3, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       310,
       kUnsetSize},
      {"mm_page_free_batched",
       "kmem",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "cold", 1, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "page", 2, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "pfn", 3, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       311,
       kUnsetSize},
      {"mm_page_pcpu_drain",
       "kmem",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "migratetype", 1, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "order", 2, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "page", 3, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "pfn", 4, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       312,
       kUnsetSize},
      {"rss_stat",
       "kmem",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "member", 1, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "size", 2, ProtoSchemaType::kInt64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "curr", 3, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "mm_id", 4, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       313,
       kUnsetSize},
      {"ion_heap_shrink",
       "kmem",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "heap_name", 1, ProtoSchemaType::kString,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "len", 2, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "total_allocated", 3, ProtoSchemaType::kInt64,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       314,
       kUnsetSize},
      {"ion_heap_grow",
       "kmem",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "heap_name", 1, ProtoSchemaType::kString,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "len", 2, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "total_allocated", 3, ProtoSchemaType::kInt64,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       315,
       kUnsetSize},
      {"ion_buffer_create",
       "kmem",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "addr", 1, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "len", 2, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       336,
       kUnsetSize},
      {"ion_buffer_destroy",
       "kmem",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "addr", 1, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "len", 2, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       337,
       kUnsetSize},
      {"mm_alloc_contig_migrate_range_info",
       "kmem",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "start", 1, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "end", 2, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "nr_migrated", 3, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "nr_reclaimed", 4, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "nr_mapped", 5, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "migratetype", 6, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       577,
       kUnsetSize},
      {"dmabuf_rss_stat",
       "kmem",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "rss", 1, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "rss_delta", 2, ProtoSchemaType::kInt64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "i_ino", 3, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       579,
       kUnsetSize},
      {"kvm_access_fault",
       "kvm",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "ipa", 1, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       368,
       kUnsetSize},
      {"kvm_ack_irq",
       "kvm",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "irqchip", 1, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "pin", 2, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       369,
       kUnsetSize},
      {"kvm_age_hva",
       "kvm",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "end", 1, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "start", 2, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       370,
       kUnsetSize},
      {"kvm_age_page",
       "kvm",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "gfn", 1, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "hva", 2, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "level", 3, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "referenced", 4, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       371,
       kUnsetSize},
      {"kvm_arm_clear_debug",
       "kvm",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "guest_debug", 1, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       372,
       kUnsetSize},
      {"kvm_arm_set_dreg32",
       "kvm",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "name", 1, ProtoSchemaType::kString,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "value", 2, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       373,
       kUnsetSize},
      {"kvm_arm_set_regset",
       "kvm",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "len", 1, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "name", 2, ProtoSchemaType::kString,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       374,
       kUnsetSize},
      {"kvm_arm_setup_debug",
       "kvm",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "guest_debug", 1, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "vcpu", 2, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       375,
       kUnsetSize},
      {"kvm_entry",
       "kvm",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "vcpu_pc", 1, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       376,
       kUnsetSize},
      {"kvm_exit",
       "kvm",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "esr_ec", 1, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "ret", 2, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "vcpu_pc", 3, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       377,
       kUnsetSize},
      {"kvm_fpu",
       "kvm",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "load", 1, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       378,
       kUnsetSize},
      {"kvm_get_timer_map",
       "kvm",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "direct_ptimer", 1, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "direct_vtimer", 2, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "emul_ptimer", 3, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "vcpu_id", 4, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       379,
       kUnsetSize},
      {"kvm_guest_fault",
       "kvm",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "hsr", 1, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "hxfar", 2, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "ipa", 3, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "vcpu_pc", 4, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       380,
       kUnsetSize},
      {"kvm_handle_sys_reg",
       "kvm",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "hsr", 1, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       381,
       kUnsetSize},
      {"kvm_hvc_arm64",
       "kvm",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "imm", 1, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "r0", 2, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "vcpu_pc", 3, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       382,
       kUnsetSize},
      {"kvm_irq_line",
       "kvm",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "irq_num", 1, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "level", 2, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "type", 3, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "vcpu_idx", 4, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       383,
       kUnsetSize},
      {"kvm_mmio",
       "kvm",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "gpa", 1, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "len", 2, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "type", 3, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "val", 4, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       384,
       kUnsetSize},
      {"kvm_mmio_emulate",
       "kvm",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "cpsr", 1, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "instr", 2, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "vcpu_pc", 3, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       385,
       kUnsetSize},
      {"kvm_set_guest_debug",
       "kvm",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "guest_debug", 1, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "vcpu", 2, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       386,
       kUnsetSize},
      {"kvm_set_irq",
       "kvm",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "gsi", 1, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "irq_source_id", 2, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "level", 3, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       387,
       kUnsetSize},
      {"kvm_set_spte_hva",
       "kvm",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "hva", 1, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       388,
       kUnsetSize},
      {"kvm_set_way_flush",
       "kvm",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "cache", 1, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "vcpu_pc", 2, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       389,
       kUnsetSize},
      {"kvm_sys_access",
       "kvm",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "CRm", 1, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "CRn", 2, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "Op0", 3, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "Op1", 4, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "Op2", 5, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "is_write", 6, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "name", 7, ProtoSchemaType::kString,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "vcpu_pc", 8, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       390,
       kUnsetSize},
      {"kvm_test_age_hva",
       "kvm",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "hva", 1, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       391,
       kUnsetSize},
      {"kvm_timer_emulate",
       "kvm",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "should_fire", 1, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "timer_idx", 2, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       392,
       kUnsetSize},
      {"kvm_timer_hrtimer_expire",
       "kvm",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "timer_idx", 1, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       393,
       kUnsetSize},
      {"kvm_timer_restore_state",
       "kvm",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "ctl", 1, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "cval", 2, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "timer_idx", 3, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       394,
       kUnsetSize},
      {"kvm_timer_save_state",
       "kvm",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "ctl", 1, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "cval", 2, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "timer_idx", 3, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       395,
       kUnsetSize},
      {"kvm_timer_update_irq",
       "kvm",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "irq", 1, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "level", 2, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "vcpu_id", 3, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       396,
       kUnsetSize},
      {"kvm_toggle_cache",
       "kvm",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "now", 1, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "vcpu_pc", 2, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "was", 3, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       397,
       kUnsetSize},
      {"kvm_unmap_hva_range",
       "kvm",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "end", 1, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "start", 2, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       398,
       kUnsetSize},
      {"kvm_userspace_exit",
       "kvm",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "reason", 1, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       399,
       kUnsetSize},
      {"kvm_vcpu_wakeup",
       "kvm",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "ns", 1, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "valid", 2, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "waited", 3, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       400,
       kUnsetSize},
      {"kvm_wfx_arm64",
       "kvm",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "is_wfe", 1, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "vcpu_pc", 2, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       401,
       kUnsetSize},
      {"trap_reg",
       "kvm",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "fn", 1, ProtoSchemaType::kString,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "is_write", 2, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "reg", 3, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "write_value", 4, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       402,
       kUnsetSize},
      {"vgic_update_irq_pending",
       "kvm",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "irq", 1, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "level", 2, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "vcpu_id", 3, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       403,
       kUnsetSize},
      {"lowmemory_kill",
       "lowmemorykiller",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "comm", 1, ProtoSchemaType::kString,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "pid", 2, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "pagecache_size", 3, ProtoSchemaType::kInt64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "pagecache_limit", 4, ProtoSchemaType::kInt64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "free", 5, ProtoSchemaType::kInt64,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       35,
       kUnsetSize},
      {"tracing_mark_write",
       "lwis",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "lwis_name", 1, ProtoSchemaType::kString,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "type", 2, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "pid", 3, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "func_name", 4, ProtoSchemaType::kString,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "value", 5, ProtoSchemaType::kInt64,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       467,
       kUnsetSize},
      {"tracing_mark_write",
       "mali",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "name", 1, ProtoSchemaType::kString,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "pid", 2, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "type", 3, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "value", 4, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       350,
       kUnsetSize},
      {"mali_KCPU_CQS_SET",
       "mali",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "id", 1, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "info_val1", 2, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "info_val2", 3, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "kctx_id", 4, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "kctx_tgid", 5, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       470,
       kUnsetSize},
      {"mali_KCPU_CQS_WAIT_START",
       "mali",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "id", 1, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "info_val1", 2, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "info_val2", 3, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "kctx_id", 4, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "kctx_tgid", 5, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       471,
       kUnsetSize},
      {"mali_KCPU_CQS_WAIT_END",
       "mali",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "id", 1, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "info_val1", 2, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "info_val2", 3, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "kctx_id", 4, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "kctx_tgid", 5, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       472,
       kUnsetSize},
      {"mali_KCPU_FENCE_SIGNAL",
       "mali",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "info_val1", 1, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "info_val2", 2, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "kctx_tgid", 3, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "kctx_id", 4, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "id", 5, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       473,
       kUnsetSize},
      {"mali_KCPU_FENCE_WAIT_START",
       "mali",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "info_val1", 1, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "info_val2", 2, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "kctx_tgid", 3, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "kctx_id", 4, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "id", 5, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       474,
       kUnsetSize},
      {"mali_KCPU_FENCE_WAIT_END",
       "mali",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "info_val1", 1, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "info_val2", 2, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "kctx_tgid", 3, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "kctx_id", 4, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "id", 5, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       475,
       kUnsetSize},
      {"mali_CSF_INTERRUPT_START",
       "mali",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "kctx_tgid", 1, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "kctx_id", 2, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "info_val", 3, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       482,
       kUnsetSize},
      {"mali_CSF_INTERRUPT_END",
       "mali",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "kctx_tgid", 1, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "kctx_id", 2, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "info_val", 3, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       483,
       kUnsetSize},
      {"mali_PM_MCU_HCTL_CORES_DOWN_SCALE_NOTIFY_PEND",
       "mali",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "kctx_tgid", 1, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "kctx_id", 2, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "info_val", 3, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       510,
       kUnsetSize},
      {"mali_PM_MCU_HCTL_CORES_NOTIFY_PEND",
       "mali",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "kctx_tgid", 1, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "kctx_id", 2, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "info_val", 3, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       511,
       kUnsetSize},
      {"mali_PM_MCU_HCTL_CORE_INACTIVE_PEND",
       "mali",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "kctx_tgid", 1, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "kctx_id", 2, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "info_val", 3, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       512,
       kUnsetSize},
      {"mali_PM_MCU_HCTL_MCU_ON_RECHECK",
       "mali",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "kctx_tgid", 1, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "kctx_id", 2, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "info_val", 3, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       513,
       kUnsetSize},
      {"mali_PM_MCU_HCTL_SHADERS_CORE_OFF_PEND",
       "mali",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "kctx_tgid", 1, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "kctx_id", 2, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "info_val", 3, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       514,
       kUnsetSize},
      {"mali_PM_MCU_HCTL_SHADERS_PEND_OFF",
       "mali",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "kctx_tgid", 1, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "kctx_id", 2, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "info_val", 3, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       515,
       kUnsetSize},
      {"mali_PM_MCU_HCTL_SHADERS_PEND_ON",
       "mali",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "kctx_tgid", 1, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "kctx_id", 2, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "info_val", 3, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       516,
       kUnsetSize},
      {"mali_PM_MCU_HCTL_SHADERS_READY_OFF",
       "mali",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "kctx_tgid", 1, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "kctx_id", 2, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "info_val", 3, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       517,
       kUnsetSize},
      {"mali_PM_MCU_IN_SLEEP",
       "mali",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "kctx_tgid", 1, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "kctx_id", 2, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "info_val", 3, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       518,
       kUnsetSize},
      {"mali_PM_MCU_OFF",
       "mali",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "kctx_tgid", 1, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "kctx_id", 2, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "info_val", 3, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       519,
       kUnsetSize},
      {"mali_PM_MCU_ON",
       "mali",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "kctx_tgid", 1, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "kctx_id", 2, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "info_val", 3, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       520,
       kUnsetSize},
      {"mali_PM_MCU_ON_CORE_ATTR_UPDATE_PEND",
       "mali",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "kctx_tgid", 1, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "kctx_id", 2, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "info_val", 3, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       521,
       kUnsetSize},
      {"mali_PM_MCU_ON_GLB_REINIT_PEND",
       "mali",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "kctx_tgid", 1, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "kctx_id", 2, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "info_val", 3, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       522,
       kUnsetSize},
      {"mali_PM_MCU_ON_HALT",
       "mali",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "kctx_tgid", 1, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "kctx_id", 2, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "info_val", 3, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       523,
       kUnsetSize},
      {"mali_PM_MCU_ON_HWCNT_DISABLE",
       "mali",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "kctx_tgid", 1, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "kctx_id", 2, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "info_val", 3, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       524,
       kUnsetSize},
      {"mali_PM_MCU_ON_HWCNT_ENABLE",
       "mali",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "kctx_tgid", 1, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "kctx_id", 2, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "info_val", 3, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       525,
       kUnsetSize},
      {"mali_PM_MCU_ON_PEND_HALT",
       "mali",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "kctx_tgid", 1, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "kctx_id", 2, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "info_val", 3, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       526,
       kUnsetSize},
      {"mali_PM_MCU_ON_PEND_SLEEP",
       "mali",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "kctx_tgid", 1, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "kctx_id", 2, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "info_val", 3, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       527,
       kUnsetSize},
      {"mali_PM_MCU_ON_SLEEP_INITIATE",
       "mali",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "kctx_tgid", 1, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "kctx_id", 2, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "info_val", 3, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       528,
       kUnsetSize},
      {"mali_PM_MCU_PEND_OFF",
       "mali",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "kctx_tgid", 1, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "kctx_id", 2, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "info_val", 3, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       529,
       kUnsetSize},
      {"mali_PM_MCU_PEND_ON_RELOAD",
       "mali",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "kctx_tgid", 1, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "kctx_id", 2, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "info_val", 3, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       530,
       kUnsetSize},
      {"mali_PM_MCU_POWER_DOWN",
       "mali",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "kctx_tgid", 1, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "kctx_id", 2, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "info_val", 3, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       531,
       kUnsetSize},
      {"mali_PM_MCU_RESET_WAIT",
       "mali",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "kctx_tgid", 1, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "kctx_id", 2, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "info_val", 3, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       532,
       kUnsetSize},
      {"gpu_power_state",
       "mali",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "change_ns", 1, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "from_state", 2, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "to_state", 3, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       548,
       kUnsetSize},
      {"mdp_cmd_kickoff",
       "mdss",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "ctl_num", 1, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "kickoff_cnt", 2, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       76,
       kUnsetSize},
      {"mdp_commit",
       "mdss",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "num", 1, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "play_cnt", 2, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "clk_rate", 3, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "bandwidth", 4, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       77,
       kUnsetSize},
      {"mdp_perf_set_ot",
       "mdss",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "pnum", 1, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "xin_id", 2, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "rd_lim", 3, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "is_vbif_rt", 4, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       78,
       kUnsetSize},
      {"mdp_sspp_change",
       "mdss",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "num", 1, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "play_cnt", 2, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "mixer", 3, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "stage", 4, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "flags", 5, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "format", 6, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "img_w", 7, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "img_h", 8, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "src_x", 9, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "src_y", 10, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "src_w", 11, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "src_h", 12, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "dst_x", 13, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "dst_y", 14, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "dst_w", 15, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "dst_h", 16, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       79,
       kUnsetSize},
      {"tracing_mark_write",
       "mdss",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "pid", 1, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "trace_name", 2, ProtoSchemaType::kString,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "trace_begin", 3, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       80,
       kUnsetSize},
      {"mdp_cmd_pingpong_done",
       "mdss",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "ctl_num", 1, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "intf_num", 2, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "pp_num", 3, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "koff_cnt", 4, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       81,
       kUnsetSize},
      {"mdp_compare_bw",
       "mdss",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "new_ab", 1, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "new_ib", 2, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "new_wb", 3, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "old_ab", 4, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "old_ib", 5, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "old_wb", 6, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "params_changed", 7, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "update_bw", 8, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       82,
       kUnsetSize},
      {"mdp_perf_set_panic_luts",
       "mdss",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "pnum", 1, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "fmt", 2, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "mode", 3, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "panic_lut", 4, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "robust_lut", 5, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       83,
       kUnsetSize},
      {"mdp_sspp_set",
       "mdss",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "num", 1, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "play_cnt", 2, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "mixer", 3, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "stage", 4, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "flags", 5, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "format", 6, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "img_w", 7, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "img_h", 8, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "src_x", 9, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "src_y", 10, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "src_w", 11, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "src_h", 12, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "dst_x", 13, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "dst_y", 14, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "dst_w", 15, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "dst_h", 16, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       84,
       kUnsetSize},
      {"mdp_cmd_readptr_done",
       "mdss",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "ctl_num", 1, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "koff_cnt", 2, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       85,
       kUnsetSize},
      {"mdp_misr_crc",
       "mdss",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "block_id", 1, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "vsync_cnt", 2, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "crc", 3, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       86,
       kUnsetSize},
      {"mdp_perf_set_qos_luts",
       "mdss",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "pnum", 1, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "fmt", 2, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "intf", 3, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "rot", 4, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "fl", 5, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "lut", 6, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "linear", 7, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       87,
       kUnsetSize},
      {"mdp_trace_counter",
       "mdss",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "pid", 1, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "counter_name", 2, ProtoSchemaType::kString,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "value", 3, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       88,
       kUnsetSize},
      {"mdp_cmd_release_bw",
       "mdss",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "ctl_num", 1, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       89,
       kUnsetSize},
      {"mdp_mixer_update",
       "mdss",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "mixer_num", 1, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       90,
       kUnsetSize},
      {"mdp_perf_set_wm_levels",
       "mdss",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "pnum", 1, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "use_space", 2, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "priority_bytes", 3, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "wm0", 4, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "wm1", 5, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "wm2", 6, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "mb_cnt", 7, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "mb_size", 8, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       91,
       kUnsetSize},
      {"mdp_video_underrun_done",
       "mdss",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "ctl_num", 1, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "underrun_cnt", 2, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       92,
       kUnsetSize},
      {"mdp_cmd_wait_pingpong",
       "mdss",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "ctl_num", 1, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "kickoff_cnt", 2, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       93,
       kUnsetSize},
      {"mdp_perf_prefill_calc",
       "mdss",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "pnum", 1, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "latency_buf", 2, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "ot", 3, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "y_buf", 4, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "y_scaler", 5, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "pp_lines", 6, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "pp_bytes", 7, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "post_sc", 8, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "fbc_bytes", 9, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "prefill_bytes", 10, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       94,
       kUnsetSize},
      {"mdp_perf_update_bus",
       "mdss",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "client", 1, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "ab_quota", 2, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "ib_quota", 3, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       95,
       kUnsetSize},
      {"rotator_bw_ao_as_context",
       "mdss",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "state", 1, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       96,
       kUnsetSize},
      {"mm_event_record",
       "mm_event",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "avg_lat", 1, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "count", 2, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "max_lat", 3, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "type", 4, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       328,
       kUnsetSize},
      {"netif_receive_skb",
       "net",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "len", 1, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "name", 2, ProtoSchemaType::kString,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "skbaddr", 3, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       360,
       kUnsetSize},
      {"net_dev_xmit",
       "net",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "len", 1, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "name", 2, ProtoSchemaType::kString,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "rc", 3, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "skbaddr", 4, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       361,
       kUnsetSize},
      {"napi_gro_receive_entry",
       "net",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "data_len", 1, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "gso_size", 2, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "gso_type", 3, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "hash", 4, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "ip_summed", 5, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "l4_hash", 6, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "len", 7, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "mac_header", 8, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "mac_header_valid", 9, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "name", 10, ProtoSchemaType::kString,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "napi_id", 11, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "nr_frags", 12, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "protocol", 13, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "queue_mapping", 14, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "skbaddr", 15, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "truesize", 16, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "vlan_proto", 17, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "vlan_tagged", 18, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "vlan_tci", 19, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       365,
       kUnsetSize},
      {"napi_gro_receive_exit",
       "net",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "ret", 1, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       366,
       kUnsetSize},
      {"oom_score_adj_update",
       "oom",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "comm", 1, ProtoSchemaType::kString,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "oom_score_adj", 2, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "pid", 3, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       326,
       kUnsetSize},
      {"mark_victim",
       "oom",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "pid", 1, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       334,
       kUnsetSize},
      {"dsi_cmd_fifo_status",
       "panel",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "header", 1, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "payload", 2, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       428,
       kUnsetSize},
      {"dsi_rx",
       "panel",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "cmd", 1, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "rx_buf", 2, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       429,
       kUnsetSize},
      {"dsi_tx",
       "panel",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "last", 1, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "tx_buf", 2, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "type", 3, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       430,
       kUnsetSize},
      {"panel_write_generic",
       "panel",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "pid", 1, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "trace_name", 2, ProtoSchemaType::kString,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "trace_begin", 3, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "name", 4, ProtoSchemaType::kString,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "type", 5, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "value", 6, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       490,
       kUnsetSize},
      {"sched_switch_with_ctrs",
       "perf_trace_counters",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "old_pid", 1, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "new_pid", 2, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "cctr", 3, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "ctr0", 4, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "ctr1", 5, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "ctr2", 6, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "ctr3", 7, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "lctr0", 8, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "lctr1", 9, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "ctr4", 10, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "ctr5", 11, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "prev_comm", 12, ProtoSchemaType::kString,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "prev_pid", 13, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "cyc", 14, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "inst", 15, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "stallbm", 16, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "l3dm", 17, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "next_pid", 18, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "next_comm", 19, ProtoSchemaType::kString,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "prev_state", 20, ProtoSchemaType::kInt64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "amu0", 21, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "amu1", 22, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "amu2", 23, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       487,
       kUnsetSize},
      {"pixel_mm_kswapd_wake",
       "pixel_mm",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "whatever", 1, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       538,
       kUnsetSize},
      {"pixel_mm_kswapd_done",
       "pixel_mm",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "delta_nr_scanned", 1, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "delta_nr_reclaimed", 2, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       539,
       kUnsetSize},
      {"cpu_frequency",
       "power",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "state", 1, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "cpu_id", 2, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       11,
       kUnsetSize},
      {"cpu_frequency_limits",
       "power",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "min_freq", 1, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "max_freq", 2, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "cpu_id", 3, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       12,
       kUnsetSize},
      {"cpu_idle",
       "power",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "state", 1, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "cpu_id", 2, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       13,
       kUnsetSize},
      {"clock_enable",
       "power",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "name", 1, ProtoSchemaType::kString,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "state", 2, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "cpu_id", 3, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       14,
       kUnsetSize},
      {"clock_disable",
       "power",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "name", 1, ProtoSchemaType::kString,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "state", 2, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "cpu_id", 3, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       15,
       kUnsetSize},
      {"clock_set_rate",
       "power",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "name", 1, ProtoSchemaType::kString,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "state", 2, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "cpu_id", 3, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       16,
       kUnsetSize},
      {"suspend_resume",
       "power",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "action", 1, ProtoSchemaType::kString,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "val", 2, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "start", 3, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       113,
       kUnsetSize},
      {"gpu_frequency",
       "power",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "gpu_id", 1, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "state", 2, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       332,
       kUnsetSize},
      {"wakeup_source_activate",
       "power",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "name", 1, ProtoSchemaType::kString,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "state", 2, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       404,
       kUnsetSize},
      {"wakeup_source_deactivate",
       "power",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "name", 1, ProtoSchemaType::kString,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "state", 2, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       405,
       kUnsetSize},
      {"gpu_work_period",
       "power",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "gpu_id", 1, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "uid", 2, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "start_time_ns", 3, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "end_time_ns", 4, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "total_active_duration_ns", 5, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       488,
       kUnsetSize},
      {"device_pm_callback_start",
       "power",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "device", 1, ProtoSchemaType::kString,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "driver", 2, ProtoSchemaType::kString,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "parent", 3, ProtoSchemaType::kString,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "pm_ops", 4, ProtoSchemaType::kString,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "event", 5, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       504,
       kUnsetSize},
      {"device_pm_callback_end",
       "power",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "device", 1, ProtoSchemaType::kString,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "driver", 2, ProtoSchemaType::kString,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "error", 3, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       505,
       kUnsetSize},
      {"console",
       "printk",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "msg", 1, ProtoSchemaType::kString,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       408,
       kUnsetSize},
      {"sys_enter",
       "raw_syscalls",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "id", 1, ProtoSchemaType::kInt64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "args", 2, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       329,
       kUnsetSize},
      {"sys_exit",
       "raw_syscalls",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "id", 1, ProtoSchemaType::kInt64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "ret", 2, ProtoSchemaType::kInt64,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       330,
       kUnsetSize},
      {"regulator_disable",
       "regulator",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "name", 1, ProtoSchemaType::kString,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       60,
       kUnsetSize},
      {"regulator_disable_complete",
       "regulator",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "name", 1, ProtoSchemaType::kString,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       61,
       kUnsetSize},
      {"regulator_enable",
       "regulator",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "name", 1, ProtoSchemaType::kString,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       62,
       kUnsetSize},
      {"regulator_enable_complete",
       "regulator",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "name", 1, ProtoSchemaType::kString,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       63,
       kUnsetSize},
      {"regulator_enable_delay",
       "regulator",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "name", 1, ProtoSchemaType::kString,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       64,
       kUnsetSize},
      {"regulator_set_voltage",
       "regulator",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "name", 1, ProtoSchemaType::kString,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "min", 2, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "max", 3, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       65,
       kUnsetSize},
      {"regulator_set_voltage_complete",
       "regulator",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "name", 1, ProtoSchemaType::kString,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "val", 2, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       66,
       kUnsetSize},
      {"rpm_status",
       "rpm",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "name", 1, ProtoSchemaType::kString,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "status", 2, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       489,
       kUnsetSize},
      {"tracing_mark_write",
       "samsung",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "pid", 1, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "trace_name", 2, ProtoSchemaType::kString,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "trace_begin", 3, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "trace_type", 4, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "value", 5, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       484,
       kUnsetSize},
      {"sched_switch",
       "sched",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "prev_comm", 1, ProtoSchemaType::kString,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "prev_pid", 2, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "prev_prio", 3, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "prev_state", 4, ProtoSchemaType::kInt64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "next_comm", 5, ProtoSchemaType::kString,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "next_pid", 6, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "next_prio", 7, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       4,
       kUnsetSize},
      {"sched_wakeup",
       "sched",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "comm", 1, ProtoSchemaType::kString,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "pid", 2, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "prio", 3, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "success", 4, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "target_cpu", 5, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       17,
       kUnsetSize},
      {"sched_blocked_reason",
       "sched",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "pid", 1, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "caller", 2, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "io_wait", 3, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       18,
       kUnsetSize},
      {"sched_cpu_hotplug",
       "sched",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "affected_cpu", 1, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "error", 2, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "status", 3, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       19,
       kUnsetSize},
      {"sched_waking",
       "sched",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "comm", 1, ProtoSchemaType::kString,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "pid", 2, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "prio", 3, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "success", 4, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "target_cpu", 5, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       20,
       kUnsetSize},
      {"sched_wakeup_new",
       "sched",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "comm", 1, ProtoSchemaType::kString,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "pid", 2, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "prio", 3, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "success", 4, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "target_cpu", 5, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       114,
       kUnsetSize},
      {"sched_process_exec",
       "sched",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "filename", 1, ProtoSchemaType::kString,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "pid", 2, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "old_pid", 3, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       237,
       kUnsetSize},
      {"sched_process_exit",
       "sched",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "comm", 1, ProtoSchemaType::kString,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "pid", 2, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "tgid", 3, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "prio", 4, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       238,
       kUnsetSize},
      {"sched_process_fork",
       "sched",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "parent_comm", 1, ProtoSchemaType::kString,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "parent_pid", 2, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "child_comm", 3, ProtoSchemaType::kString,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "child_pid", 4, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       239,
       kUnsetSize},
      {"sched_process_free",
       "sched",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "comm", 1, ProtoSchemaType::kString,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "pid", 2, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "prio", 3, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       240,
       kUnsetSize},
      {"sched_process_hang",
       "sched",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "comm", 1, ProtoSchemaType::kString,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "pid", 2, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       241,
       kUnsetSize},
      {"sched_process_wait",
       "sched",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "comm", 1, ProtoSchemaType::kString,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "pid", 2, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "prio", 3, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       242,
       kUnsetSize},
      {"sched_pi_setprio",
       "sched",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "comm", 1, ProtoSchemaType::kString,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "newprio", 2, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "oldprio", 3, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "pid", 4, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       353,
       kUnsetSize},
      {"sched_cpu_util_cfs",
       "sched",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "active", 1, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "capacity", 2, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "capacity_orig", 3, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "cpu", 4, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "cpu_importance", 5, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "cpu_util", 6, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "exit_lat", 7, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "group_capacity", 8, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "grp_overutilized", 9, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "idle_cpu", 10, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "nr_running", 11, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "spare_cap", 12, ProtoSchemaType::kInt64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "task_fits", 13, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "wake_group_util", 14, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "wake_util", 15, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       421,
       kUnsetSize},
      {"sched_migrate_task",
       "sched",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "comm", 1, ProtoSchemaType::kString,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "pid", 2, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "prio", 3, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "orig_cpu", 4, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "dest_cpu", 5, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "running", 6, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "load", 7, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       491,
       kUnsetSize},
      {"sched_wakeup_task_attr",
       "sched",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "pid", 1, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "cpu_affinity", 2, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "task_util", 3, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "uclamp_min", 4, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "vruntime", 5, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       540,
       kUnsetSize},
      {"scm_call_start",
       "scm",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "arginfo", 1, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "x0", 2, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "x5", 3, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       338,
       kUnsetSize},
      {"scm_call_end", "scm", {}, kUnsetFtraceId, 339, kUnsetSize},
      {"tracing_mark_write",
       "sde",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "pid", 1, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "trace_name", 2, ProtoSchemaType::kString,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "trace_type", 3, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "value", 4, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "trace_begin", 5, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       333,
       kUnsetSize},
      {"sde_evtlog",
       "sde",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "evtlog_tag", 1, ProtoSchemaType::kString,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "pid", 2, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "tag_id", 3, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       354,
       kUnsetSize},
      {"sde_perf_calc_crtc",
       "sde",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "bw_ctl_ebi", 1, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "bw_ctl_llcc", 2, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "bw_ctl_mnoc", 3, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "core_clk_rate", 4, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "crtc", 5, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "ib_ebi", 6, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "ib_llcc", 7, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "ib_mnoc", 8, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       355,
       kUnsetSize},
      {"sde_perf_crtc_update",
       "sde",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "bw_ctl_ebi", 1, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "bw_ctl_llcc", 2, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "bw_ctl_mnoc", 3, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "core_clk_rate", 4, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "crtc", 5, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "params", 6, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "per_pipe_ib_ebi", 7, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "per_pipe_ib_llcc", 8, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "per_pipe_ib_mnoc", 9, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "stop_req", 10, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "update_bus", 11, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "update_clk", 12, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       356,
       kUnsetSize},
      {"sde_perf_set_qos_luts",
       "sde",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "fl", 1, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "fmt", 2, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "lut", 3, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "lut_usage", 4, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "pnum", 5, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "rt", 6, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       357,
       kUnsetSize},
      {"sde_perf_update_bus",
       "sde",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "ab_quota", 1, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "bus_id", 2, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "client", 3, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "ib_quota", 4, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       358,
       kUnsetSize},
      {"signal_deliver",
       "signal",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "code", 1, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "sa_flags", 2, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "sig", 3, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       324,
       kUnsetSize},
      {"signal_generate",
       "signal",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "code", 1, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "comm", 2, ProtoSchemaType::kString,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "group", 3, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "pid", 4, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "result", 5, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "sig", 6, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       325,
       kUnsetSize},
      {"kfree_skb",
       "skb",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "location", 1, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "protocol", 2, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "skbaddr", 3, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       367,
       kUnsetSize},
      {"inet_sock_set_state",
       "sock",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "daddr", 1, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "dport", 2, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "family", 3, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "newstate", 4, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "oldstate", 5, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "protocol", 6, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "saddr", 7, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "skaddr", 8, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "sport", 9, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       362,
       kUnsetSize},
      {"sync_pt",
       "sync",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "timeline", 1, ProtoSchemaType::kString,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "value", 2, ProtoSchemaType::kString,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       38,
       kUnsetSize},
      {"sync_timeline",
       "sync",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "name", 1, ProtoSchemaType::kString,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "value", 2, ProtoSchemaType::kString,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       39,
       kUnsetSize},
      {"sync_wait",
       "sync",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "name", 1, ProtoSchemaType::kString,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "status", 2, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "begin", 3, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       40,
       kUnsetSize},
      {"rss_stat_throttled",
       "synthetic",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "curr", 1, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "member", 2, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "mm_id", 3, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "size", 4, ProtoSchemaType::kInt64,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       359,
       kUnsetSize},
      {"suspend_resume_minimal",
       "synthetic",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "start", 1, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       481,
       kUnsetSize},
      {"0",
       "systrace",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "flag", 1, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "name", 2, ProtoSchemaType::kString,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "pid", 3, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "value", 4, ProtoSchemaType::kInt64,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       331,
       kUnsetSize},
      {"task_newtask",
       "task",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "pid", 1, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "comm", 2, ProtoSchemaType::kString,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "clone_flags", 3, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "oom_score_adj", 4, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       235,
       kUnsetSize},
      {"task_rename",
       "task",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "pid", 1, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "oldcomm", 2, ProtoSchemaType::kString,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "newcomm", 3, ProtoSchemaType::kString,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "oom_score_adj", 4, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       236,
       kUnsetSize},
      {"tcp_retransmit_skb",
       "tcp",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "daddr", 1, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "dport", 2, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "saddr", 3, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "skaddr", 4, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "skbaddr", 5, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "sport", 6, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "state", 7, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       363,
       kUnsetSize},
      {"thermal_temperature",
       "thermal",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "id", 1, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "temp", 2, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "temp_prev", 3, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "thermal_zone", 4, ProtoSchemaType::kString,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       341,
       kUnsetSize},
      {"cdev_update",
       "thermal",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "target", 1, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "type", 2, ProtoSchemaType::kString,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       342,
       kUnsetSize},
      {"thermal_exynos_acpm_bulk",
       "thermal_exynos",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "tz_id", 1, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "current_temp", 2, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "ctrl_temp", 3, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "cdev_state", 4, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "pid_et_p", 5, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "pid_power_range", 6, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "pid_p", 7, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "pid_i", 8, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "k_p", 9, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "k_i", 10, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "timestamp", 11, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       506,
       kUnsetSize},
      {"thermal_exynos_acpm_high_overhead",
       "thermal_exynos",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "tz_id", 1, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "current_temp", 2, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "ctrl_temp", 3, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "cdev_state", 4, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "pid_et_p", 5, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "k_p", 6, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "k_i", 7, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       507,
       kUnsetSize},
      {"hrtimer_start",
       "timer",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "hrtimer", 1, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "function", 2, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "expires", 3, ProtoSchemaType::kInt64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "softexpires", 4, ProtoSchemaType::kInt64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "mode", 5, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       551,
       kUnsetSize},
      {"hrtimer_cancel",
       "timer",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "hrtimer", 1, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       552,
       kUnsetSize},
      {"hrtimer_expire_entry",
       "timer",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "hrtimer", 1, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "now", 2, ProtoSchemaType::kInt64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "function", 3, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       553,
       kUnsetSize},
      {"hrtimer_expire_exit",
       "timer",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "hrtimer", 1, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       554,
       kUnsetSize},
      {"timer_start",
       "timer",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "timer", 1, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "function", 2, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "expires", 3, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "now", 4, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "deferrable", 5, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "flags", 6, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "bucket_expiry", 7, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       555,
       kUnsetSize},
      {"timer_cancel",
       "timer",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "timer", 1, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       556,
       kUnsetSize},
      {"timer_expire_entry",
       "timer",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "timer", 1, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "now", 2, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "function", 3, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "baseclk", 4, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       557,
       kUnsetSize},
      {"timer_expire_exit",
       "timer",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "timer", 1, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       558,
       kUnsetSize},
      {"trusty_smc",
       "trusty",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "r0", 1, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "r1", 2, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "r2", 3, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "r3", 4, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       445,
       kUnsetSize},
      {"trusty_smc_done",
       "trusty",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "ret", 1, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       446,
       kUnsetSize},
      {"trusty_std_call32",
       "trusty",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "r0", 1, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "r1", 2, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "r2", 3, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "r3", 4, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       447,
       kUnsetSize},
      {"trusty_std_call32_done",
       "trusty",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "ret", 1, ProtoSchemaType::kInt64,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       448,
       kUnsetSize},
      {"trusty_share_memory",
       "trusty",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "len", 1, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "lend", 2, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "nents", 3, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       449,
       kUnsetSize},
      {"trusty_share_memory_done",
       "trusty",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "handle", 1, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "len", 2, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "lend", 3, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "nents", 4, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "ret", 5, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       450,
       kUnsetSize},
      {"trusty_reclaim_memory",
       "trusty",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "id", 1, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       451,
       kUnsetSize},
      {"trusty_reclaim_memory_done",
       "trusty",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "id", 1, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "ret", 2, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       452,
       kUnsetSize},
      {"trusty_irq",
       "trusty",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "irq", 1, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       453,
       kUnsetSize},
      {"trusty_ipc_handle_event",
       "trusty",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "chan", 1, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "event_id", 2, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "srv_name", 3, ProtoSchemaType::kString,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       454,
       kUnsetSize},
      {"trusty_ipc_connect",
       "trusty",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "chan", 1, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "port", 2, ProtoSchemaType::kString,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "state", 3, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       455,
       kUnsetSize},
      {"trusty_ipc_connect_end",
       "trusty",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "chan", 1, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "err", 2, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "state", 3, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       456,
       kUnsetSize},
      {"trusty_ipc_write",
       "trusty",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "buf_id", 1, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "chan", 2, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "kind_shm", 3, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "len_or_err", 4, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "shm_cnt", 5, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "srv_name", 6, ProtoSchemaType::kString,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       457,
       kUnsetSize},
      {"trusty_ipc_poll",
       "trusty",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "chan", 1, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "poll_mask", 2, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "srv_name", 3, ProtoSchemaType::kString,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       458,
       kUnsetSize},
      {"trusty_ipc_read",
       "trusty",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "chan", 1, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "srv_name", 2, ProtoSchemaType::kString,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       460,
       kUnsetSize},
      {"trusty_ipc_read_end",
       "trusty",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "buf_id", 1, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "chan", 2, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "len_or_err", 3, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "shm_cnt", 4, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "srv_name", 5, ProtoSchemaType::kString,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       461,
       kUnsetSize},
      {"trusty_ipc_rx",
       "trusty",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "buf_id", 1, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "chan", 2, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "srv_name", 3, ProtoSchemaType::kString,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       462,
       kUnsetSize},
      {"trusty_enqueue_nop",
       "trusty",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "arg1", 1, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "arg2", 2, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "arg3", 3, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       464,
       kUnsetSize},
      {"ufshcd_command",
       "ufs",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "dev_name", 1, ProtoSchemaType::kString,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "doorbell", 2, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "intr", 3, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "lba", 4, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "opcode", 5, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "str", 6, ProtoSchemaType::kString,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "tag", 7, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "transfer_len", 8, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "group_id", 9, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "str_t", 10, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       406,
       kUnsetSize},
      {"ufshcd_clk_gating",
       "ufs",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "dev_name", 1, ProtoSchemaType::kString,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "state", 2, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       407,
       kUnsetSize},
      {"v4l2_qbuf",
       "v4l2",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "bytesused", 1, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "field", 2, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "flags", 3, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "index", 4, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "minor", 5, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "sequence", 6, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "timecode_flags", 7, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "timecode_frames", 8, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "timecode_hours", 9, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "timecode_minutes", 10, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "timecode_seconds", 11, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "timecode_type", 12, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "timecode_userbits0", 13, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "timecode_userbits1", 14, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "timecode_userbits2", 15, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "timecode_userbits3", 16, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "timestamp", 17, ProtoSchemaType::kInt64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "type", 18, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       422,
       kUnsetSize},
      {"v4l2_dqbuf",
       "v4l2",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "bytesused", 1, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "field", 2, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "flags", 3, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "index", 4, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "minor", 5, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "sequence", 6, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "timecode_flags", 7, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "timecode_frames", 8, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "timecode_hours", 9, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "timecode_minutes", 10, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "timecode_seconds", 11, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "timecode_type", 12, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "timecode_userbits0", 13, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "timecode_userbits1", 14, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "timecode_userbits2", 15, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "timecode_userbits3", 16, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "timestamp", 17, ProtoSchemaType::kInt64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "type", 18, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       423,
       kUnsetSize},
      {"vb2_v4l2_buf_queue",
       "v4l2",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "field", 1, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "flags", 2, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "minor", 3, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "sequence", 4, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "timecode_flags", 5, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "timecode_frames", 6, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "timecode_hours", 7, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "timecode_minutes", 8, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "timecode_seconds", 9, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "timecode_type", 10, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "timecode_userbits0", 11, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "timecode_userbits1", 12, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "timecode_userbits2", 13, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "timecode_userbits3", 14, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "timestamp", 15, ProtoSchemaType::kInt64,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       424,
       kUnsetSize},
      {"vb2_v4l2_buf_done",
       "v4l2",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "field", 1, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "flags", 2, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "minor", 3, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "sequence", 4, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "timecode_flags", 5, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "timecode_frames", 6, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "timecode_hours", 7, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "timecode_minutes", 8, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "timecode_seconds", 9, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "timecode_type", 10, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "timecode_userbits0", 11, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "timecode_userbits1", 12, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "timecode_userbits2", 13, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "timecode_userbits3", 14, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "timestamp", 15, ProtoSchemaType::kInt64,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       425,
       kUnsetSize},
      {"vb2_v4l2_qbuf",
       "v4l2",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "field", 1, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "flags", 2, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "minor", 3, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "sequence", 4, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "timecode_flags", 5, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "timecode_frames", 6, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "timecode_hours", 7, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "timecode_minutes", 8, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "timecode_seconds", 9, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "timecode_type", 10, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "timecode_userbits0", 11, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "timecode_userbits1", 12, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "timecode_userbits2", 13, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "timecode_userbits3", 14, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "timestamp", 15, ProtoSchemaType::kInt64,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       426,
       kUnsetSize},
      {"vb2_v4l2_dqbuf",
       "v4l2",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "field", 1, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "flags", 2, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "minor", 3, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "sequence", 4, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "timecode_flags", 5, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "timecode_frames", 6, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "timecode_hours", 7, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "timecode_minutes", 8, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "timecode_seconds", 9, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "timecode_type", 10, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "timecode_userbits0", 11, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "timecode_userbits1", 12, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "timecode_userbits2", 13, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "timecode_userbits3", 14, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "timestamp", 15, ProtoSchemaType::kInt64,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       427,
       kUnsetSize},
      {"virtio_gpu_cmd_queue",
       "virtio_gpu",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "ctx_id", 1, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "dev", 2, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "fence_id", 3, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "flags", 4, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "name", 5, ProtoSchemaType::kString,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "num_free", 6, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "seqno", 7, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "type", 8, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "vq", 9, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       468,
       kUnsetSize},
      {"virtio_gpu_cmd_response",
       "virtio_gpu",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "ctx_id", 1, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "dev", 2, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "fence_id", 3, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "flags", 4, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "name", 5, ProtoSchemaType::kString,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "num_free", 6, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "seqno", 7, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "type", 8, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "vq", 9, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       469,
       kUnsetSize},
      {"virtio_video_cmd",
       "virtio_video",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "stream_id", 1, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "type", 2, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       439,
       kUnsetSize},
      {"virtio_video_cmd_done",
       "virtio_video",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "stream_id", 1, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "type", 2, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       440,
       kUnsetSize},
      {"virtio_video_resource_queue",
       "virtio_video",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "data_size0", 1, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "data_size1", 2, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "data_size2", 3, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "data_size3", 4, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "queue_type", 5, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "resource_id", 6, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "stream_id", 7, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "timestamp", 8, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       441,
       kUnsetSize},
      {"virtio_video_resource_queue_done",
       "virtio_video",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "data_size0", 1, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "data_size1", 2, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "data_size2", 3, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "data_size3", 4, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "queue_type", 5, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "resource_id", 6, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "stream_id", 7, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "timestamp", 8, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       442,
       kUnsetSize},
      {"mm_vmscan_direct_reclaim_begin",
       "vmscan",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "order", 1, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "may_writepage", 2, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "gfp_flags", 3, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       46,
       kUnsetSize},
      {"mm_vmscan_direct_reclaim_end",
       "vmscan",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "nr_reclaimed", 1, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       47,
       kUnsetSize},
      {"mm_vmscan_kswapd_wake",
       "vmscan",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "nid", 1, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "order", 2, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "zid", 3, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       48,
       kUnsetSize},
      {"mm_vmscan_kswapd_sleep",
       "vmscan",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "nid", 1, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       49,
       kUnsetSize},
      {"mm_shrink_slab_start",
       "vmscan",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "cache_items", 1, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "delta", 2, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "gfp_flags", 3, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "lru_pgs", 4, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "nr_objects_to_shrink", 5, ProtoSchemaType::kInt64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "pgs_scanned", 6, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "shr", 7, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "shrink", 8, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "total_scan", 9, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "nid", 10, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "priority", 11, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       443,
       kUnsetSize},
      {"mm_shrink_slab_end",
       "vmscan",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "new_scan", 1, ProtoSchemaType::kInt64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "retval", 2, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "shr", 3, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "shrink", 4, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "total_scan", 5, ProtoSchemaType::kInt64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "unused_scan", 6, ProtoSchemaType::kInt64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "nid", 7, ProtoSchemaType::kInt32,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       444,
       kUnsetSize},
      {"workqueue_activate_work",
       "workqueue",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "work", 1, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       56,
       kUnsetSize},
      {"workqueue_execute_end",
       "workqueue",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "work", 1, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "function", 2, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       57,
       kUnsetSize},
      {"workqueue_execute_start",
       "workqueue",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "work", 1, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "function", 2, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       58,
       kUnsetSize},
      {"workqueue_queue_work",
       "workqueue",
       {
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "work", 1, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "function", 2, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "workqueue", 3, ProtoSchemaType::kUint64,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "req_cpu", 4, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
           {kUnsetOffset, kUnsetSize, FtraceFieldType::kInvalidFtraceFieldType,
            "cpu", 5, ProtoSchemaType::kUint32,
            TranslationStrategy::kInvalidTranslationStrategy},
       },
       kUnsetFtraceId,
       59,
       kUnsetSize},
  };
}

}  // namespace perfetto
