/*
 * Copyright (C) 2025 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#ifndef SRC_TRACE_PROCESSOR_IMPORTERS_PROTO_WINSCOPE_WINSCOPE_TRANSFORM_TRACKER_H_
#define SRC_TRACE_PROCESSOR_IMPORTERS_PROTO_WINSCOPE_WINSCOPE_TRANSFORM_TRACKER_H_

#include "src/trace_processor/importers/proto/winscope/winscope_geometry.h"
#include "src/trace_processor/tables/winscope_tables_py.h"
#include "src/trace_processor/types/trace_processor_context.h"

namespace perfetto::trace_processor::winscope {

struct TransformMatrixHasher {
  size_t operator()(const geometry::TransformMatrix& r) const {
    return base::FnvHasher::Combine(r.dsdx, r.dtdx, r.tx, r.dsdy, r.dtdy, r.ty);
  }
};

class WinscopeTransformTracker {
 public:
  explicit WinscopeTransformTracker(TraceProcessorContext* context)
      : context_(context) {}
  TraceProcessorContext* context_;

  const tables::WinscopeTransformTable::Id& GetOrInsertRow(
      geometry::TransformMatrix& matrix);

 private:
  base::FlatHashMap<geometry::TransformMatrix,
                    tables::WinscopeTransformTable::Id,
                    TransformMatrixHasher>
      rows_;
};

}  // namespace perfetto::trace_processor::winscope

#endif  // SRC_TRACE_PROCESSOR_IMPORTERS_PROTO_WINSCOPE_WINSCOPE_TRANSFORM_TRACKER_H_
