/******************************************************************************
 *                                                                            *
 * Copyright (C) 2021 by nekohasekai <contact-sagernet@sekai.icu>             *
 *                                                                            *
 * This program is free software: you can redistribute it and/or modify       *
 * it under the terms of the GNU General Public License as published by       *
 * the Free Software Foundation, either version 3 of the License, or          *
 *  (at your option) any later version.                                       *
 *                                                                            *
 * This program is distributed in the hope that it will be useful,            *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of             *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the              *
 * GNU General Public License for more details.                               *
 *                                                                            *
 * You should have received a copy of the GNU General Public License          *
 * along with this program. If not, see <http://www.gnu.org/licenses/>.       *
 *                                                                            *
 ******************************************************************************/

package io.nekohasekai.sagernet.ui.profile

import android.os.Bundle
import androidx.preference.EditTextPreference
import com.takisoft.preferencex.PreferenceFragmentCompat
import com.takisoft.preferencex.SimpleMenuPreference
import io.nekohasekai.sagernet.Key
import io.nekohasekai.sagernet.R
import io.nekohasekai.sagernet.database.DataStore
import io.nekohasekai.sagernet.fmt.mieru.MieruBean
import io.nekohasekai.sagernet.ktx.unwrapIDN

class MieruSettingsActivity : ProfileSettingsActivity<MieruBean>() {

    override fun createEntity() = MieruBean()

    override fun MieruBean.init() {
        DataStore.profileName = name
        DataStore.serverAddress = serverAddress
        DataStore.serverPort = serverPort
        DataStore.serverProtocolVersion = protocol
        DataStore.serverUsername = username
        DataStore.serverPassword = password
        //DataStore.serverMTU = mtu
        DataStore.serverMieruMuxLevel = multiplexingLevel
        DataStore.serverMieruHandshakeMode = handshakeMode
        DataStore.serverPorts = portRange
    }

    override fun MieruBean.serialize() {
        name = DataStore.profileName
        serverAddress = DataStore.serverAddress.unwrapIDN()
        serverPort = DataStore.serverPort
        protocol = DataStore.serverProtocolVersion
        username = DataStore.serverUsername
        password = DataStore.serverPassword
        //mtu = DataStore.serverMTU
        multiplexingLevel = DataStore.serverMieruMuxLevel
        handshakeMode = DataStore.serverMieruHandshakeMode
        portRange = DataStore.serverPorts
    }

    override fun PreferenceFragmentCompat.createPreferences(
        savedInstanceState: Bundle?,
        rootKey: String?,
    ) {
        addPreferencesFromResource(R.xml.mieru_preferences)

        val serverPort = findPreference<EditTextPreference>(Key.SERVER_PORT)!!
        val serverPortRange = findPreference<EditTextPreference>(Key.SERVER_PORTS)!!
        serverPort.isEnabled = serverPortRange.text.isEmpty()
        serverPortRange.setOnPreferenceChangeListener { _, newValue ->
            newValue as String
            serverPort.isEnabled = newValue.isEmpty()
            true
        }

        /*val protocol = findPreference<SimpleMenuPreference>(Key.SERVER_PROTOCOL)!!
        val mtu = findPreference<EditTextPreference>(Key.SERVER_MTU)!!
        mtu.isVisible = protocol.value == "${MieruBean.PROTOCOL_UDP}"
        protocol.setOnPreferenceChangeListener { _, newValue ->
            mtu.isVisible = newValue == "${MieruBean.PROTOCOL_UDP}"
            true
        }*/

        findPreference<EditTextPreference>(Key.SERVER_PASSWORD)!!.apply {
            summaryProvider = PasswordSummaryProvider
        }
    }

}