plugins {
    id("com.android.application")
    id("org.jetbrains.kotlin.android")
}

android {
    namespace = "io.nekohasekai.sagernet.plugin.naive"


    buildTypes {
        getByName("release") {
            isMinifyEnabled = true
        }
    }

    buildToolsVersion = "36.0.0"

    compileSdk = 36

    defaultConfig {
        minSdk = 24
        targetSdk = 36

        applicationId = "io.nekohasekai.sagernet.plugin.naive"
        versionCode = System.getenv("APK_VERSION_NAME").removePrefix("v").split(".")[0].toInt() * 10 + System.getenv("APK_VERSION_NAME").removePrefix("v").split("-")[1].toInt()
        versionName = System.getenv("APK_VERSION_NAME").removePrefix("v")
        splits.abi {
            isEnable = true
            isUniversalApk = false
            reset()
            include(System.getenv("APK_ABI"))
        }
    }

    compileOptions {
        sourceCompatibility = JavaVersion.VERSION_21
        targetCompatibility = JavaVersion.VERSION_21
    }

    lint {
        showAll = true
        checkAllWarnings = true
        checkReleaseBuilds = false
        warningsAsErrors = true
    }

    packaging {
        jniLibs.useLegacyPackaging = true
    }

    applicationVariants.all {
        outputs.all {
            this as com.android.build.gradle.internal.api.BaseVariantOutputImpl
            outputFileName =
                outputFileName.replace(project.name, "naiveproxy-plugin-v$versionName")
                    .replace("-release", "")
                    .replace("-oss", "")
        }
    }

    sourceSets.getByName("main") {
        jniLibs.srcDir("libs")
    }
}
