# <img src="docs/logo.png" alt="Logo" width="50"/>TaskerHA

A Tasker plugin to fully integrate HomeAssistant into your workflow!

You can respond to entity state changes, call any HA service, or retrieve an entity's state.

TaskerHA lets you:

- Call any Home Assistant service from a Tasker action
- Read the state and attributes of any entity
- Trigger Tasker profiles when an entity changes state over a websocket connection
- Send direct messages from HA to tasker and back with a custom event (uses websocket)


Table of contents:
- [TaskerHA](#taskerha)
  - [Requirements](#requirements)
  - [Download](#download)
  - [Quick start](#quick-start)
  - [Usage](#usage)
    - [Setup](#setup)
    - [Call service action](#call-service-action)
      - [Response in tasker](#response-in-tasker)
      - [Error codes](#error-codes)
    - [Get State action](#get-state-action)
      - [Response in tasker](#response-in-tasker-1)
      - [Error codes](#error-codes-1)
    - [Direct message from ha profile](#direct-message-from-ha-profile)
      - [Response in tasker](#response-in-tasker-2)
      - [Error codes](#error-codes-2)
    - [Trigger state change profile](#trigger-state-change-profile)
      - [Response in tasker](#response-in-tasker-3)
      - [Error codes](#error-codes-3)
  - [Support](#support)


## Requirements

- <a href="https://tasker.joaoapps.com/" target="_blank">Tasker</a>
- <a href="https://www.home-assistant.io/" target="_blank">Home assistant</a>

## Download

<a  href="https://github.com/db1996/TaskerHa/releases/latest">
<img width="150" height="auto" src="https://user-images.githubusercontent.com/69304392/148696068-0cfea65d-b18f-4685-82b5-329a330b1c0d.png"
alt="Download from GitHub releases" /></a>
<!-- <a  href="https://f-droid.org/packages/com.github.db1996.taskerha/"> -->
<!-- <img width="150" height="auto" src="https://fdroid.gitlab.io/artwork/badge/get-it-on.png" -->
<!-- alt="Download from fdroid" /></a> -->


![GitHub All Releases](https://img.shields.io/github/downloads/db1996/TaskerHa/total)
<!-- ![F-Droid Version](https://img.shields.io/f-droid/v/com.github.db1996.taskerha) -->

F-droid release coming soon

<!-- NOTE: You can not install the f-droid release next to the github release. You will have to uninstall and reinstall the version you want. Tasks/profiles should keep working but you'll have to configure your server again. -->



## Quick start

1. Create a <a href="https://www.home-assistant.io/docs/authentication/" target="_blank">Create a Long-lived access token</a> in your Home Assistant user profile.
2. [Download](#download) and install the APK.
3. Open the TaskerHA app and configure your Home Assistant URL and token.
4. In Tasker, add an "HA Call service" or "HA Get state" action.
5. (Optional) Enable websockets in the app and create an "HA On trigger state" profile to react to entity changes.

## Usage

### Setup

1. <a href="https://www.home-assistant.io/docs/authentication/" target="_blank">Create a Long-lived access token</a> in your Homeassistant. And save it for later in the process.
2. Install the app. For now, the APK is available <a href="https://github.com/db1996/TaskerHa/releases/latest" target="_blank">here in releases</a>, but in the future it will be available on f-droid (hopefully)
3. Open the app (outside of tasker) and fill in your Homeassistant server details. This works both over localhost and remote
   - Use the scheme and optionally the port in the url. Example: `http://192.168.1.xxx:8123` for a local instance. Or `https://ha.yourdomain.com`. For proxy servers you do **not** need to use a port.
   - Do not use a trailing backslash in the host.
   - NOTE: Turning on the websocket will prompt you to turn off battery optimization. Without it the websocket connection might be killed by android and profiles will no longer fire.
   - Turning off websockets in TaskerHa also means any profiles active will never fire.
   - All tasks will use the same server. Maybe a future enhancement will be multi server support but I am not sure how useful that would be.
4. Test the server. If it's correct, save!

### Call service action

1. Create a new task in tasker
2. Add action -> plugin -> taskerHa -> HA Call service
3. In the configuration of the task, there are searching and filtering options for all available services in your Homeassistant.
   1. Pick a service to call (filter through domains to make this easier to find)
   2. Once a service is picked. Any fields that need to be filled in will appear.
   3. If an entity_id is needed, an entity picker with searching options will apear. It will already be filtered by the domain of the picked service
   4. Any optional extra data (think light transition for example), can be turned off/on with the checkboxes. If it's turned off the value is not pushed to Homeassistant at all.

This should work for every single service in your Homeassistant, if there are issues with specific services you come accross, please create an issue!

Extra data where you usually see dropdowns in the Homeassistant UI will also have dropdowns here.

You can use tasker variables in any of the text fields and they will be replaced automatically. This includes all optional data.

**Example**

Turn on a light from Tasker:

- Action: Plugin -> TaskerHA -> HA Call service
- Service: `light.turn_on`
- Entity: `light.living_room`
- Optional data: set `brightness: 200`

#### Response in tasker

The following variables are available from within tasker after the action

| Variable | Function                                                                                                                                                                                                   |
| -------- | ---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- |
| %ha_data | Complete API response (JSON), this will **usually** contain the new updated state of a called entity. But it's inconsistent from HA                                                                        |
| %err     | Error code, is 0 if no error occured. Check below for a complete list of error codes. If an error occurs it will also error the task itself unless you have "continue after error" turned on on the action |
| %errmsg  | Error message. Usually contains a friendly error message, with some java exception next to it.                                                                                                             |

#### Error codes

| Error code | Description                                                                                                                                                                        |
| ---------- | ---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- |
| 1          | Can't connect to Home Assistant. This means the app could not ping HA. The error will contain more details depending on the reason. But usually this means it can't reach the host |
| 2          | Invalid input. This means domain or service cannot be empty                                                                                                                        |
| 3          | Service call failed. This means that it can connect correctly with Homeassistant but the service call itself failed. %errmsg will contain more details                             |
| 9999       | Unknown error occured. %errmsg will contain more details (java error)                                                                                                              |


### Get State action

1. Create a new task in tasker
2. Add action -> plugin -> taskerHa -> HA Get State
3. In the task configuration, there's an entity picker to search with. And you can filter by domain (fuzzy search)

You can use tasker variables for the entity ID, make sure to use the "%" for any variable use.

**Example**

Check if the alarm is armed:

- Action: Plugin -> TaskerHA -> HA Get state
- Entity: `alarm_control_panel.home_alarm`
- After the action, read `%ha_state` in Tasker.  
  For example, run different actions based on `%ha_state ~ armed_away` or `disarmed`.


#### Response in tasker

The following variables are available from within tasker after the action

| Variable  | Function                                                                                                                                                                                                   |
| --------- | ---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- |
| %ha_state | Contains the current state of the choosen entity                                                                                                                                                           |
| %ha_attrs | Contains in JSON any attributes on the entity. For example, for lights you will get the color, brightness etc.                                                                                             |
| %ha_raw   | Raw JSON of the full API response from homeassistant.                                                                                                                                                      |
| %err      | Error code, is 0 if no error occured. Check below for a complete list of error codes. If an error occurs it will also error the task itself unless you have "continue after error" turned on on the action |
| %errmsg   | Error message. Usually contains a friendly error message, with some java exception next to it.                                                                                                             |

#### Error codes

| Error code | Description                                                                                                                                                                        |
| ---------- | ---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- |
| 1          | Can't connect to Home Assistant. This means the app could not ping HA. The error will contain more details depending on the reason. But usually this means it can't reach the host |
| 2          | Invalid input. This means entity ID cannot be empty                                                                                                                                |
| 3          | Get entity state call failed. This means that it can connect correctly with Homeassistant but the entity state call itself failed. %errmsg will contain more details               |
| 9999       | Unknown error occured. %errmsg will contain more details (java error)                                                                                                              |

### Direct message to HA action

1. Create a new task in tasker
2. Add action -> plugin -> taskerHa -> HA send message back

You can use tasker variables for the type and message.

**Example**

Activate an automation in Homeassistant

In Tasker:

- action -> plugin -> taskerHa -> HA send message back
- Set type to "this_automation"
- Set message to "some_message"

In Homeassistant:

- Automations -> new automation -> add trigger -> Manual event -> Edit as yaml and paste:

``` yaml
trigger: event
event_type: taskerha_message_back
event_data:
  type: this_automation # Optional, acts as a filter
  message: some_message # Optional, acts as a filter
```

#### Response in tasker

The following variables are available from within tasker after the action

| Variable | Function                                                                                                                                                                                                   |
| -------- | ---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- |
| %ha_type | Contains the type sent in the event                                                                                                                                                                        |
| %ha_message | Contains the message sent in the event                                                                                                                                                                  |
| %rawJson | Contains the raw JSON response from the event                                                                                                                                                              |
| %err     | Error code, is 0 if no error occured. Check below for a complete list of error codes. If an error occurs it will also error the task itself unless you have "continue after error" turned on on the action |
| %errmsg  | Error message. Usually contains a friendly error message, with some java exception next to it.                                                                                                             |

#### Error codes

| Error code | Description                                                                                                                                                                        |
| ---------- | ---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- |
| 1          | Can't connect to Home Assistant. This means the app could not ping HA. The error will contain more details depending on the reason. But usually this means it can't reach the host |
| 9999       | Unknown error occured. %errmsg will contain more details (java error)                                                                                                              |


### Direct message from ha profile

1. Create a new profile in Tasker: plugin -> taskerHa -> HA Direct Message
2. You can optionally enter text in `type` and `message`
   - These can be used for filtering, if you enter these in tasker, they have to be filled in homeassistant. 
   - If you leave it empty it is ignored and you will receive the value.

You can use tasker variables for both fields, make sure to use the "%" for any variable use.

The websocket option in the main app has to be turned on for this. Oterwise it will never fire.

**Example**

Send a message to tasker in an automation with a specific type

In Tasker:

- Profile: Plugin -> TaskerHA -> HA Direct message
- `type`: some_type (can be left empty to not filter on type)
- `message`: (leave empty to not filter on message)

In Homeassistant:

- Automations -> new automation -> add action -> Manual event
- Go in to edit yaml mode (top right 3 dots)

```yaml
event: taskerha_message
event_data:
  type: some_type
  message: "some message"  # optional
```

#### Response in tasker

The following variables are available from within tasker after the action

| Variable | Function                                                                                                                                                                                                   |
| -------- | ---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- |
| %ha_type | Contains the type sent in the event                                                                                                                                                                        |
| %ha_message | Contains the message sent in the event                                                                                                                                                                  |
| %err     | Error code, is 0 if no error occured. Check below for a complete list of error codes. If an error occurs it will also error the task itself unless you have "continue after error" turned on on the action |
| %errmsg  | Error message. Usually contains a friendly error message, with some java exception next to it.                                                                                                             |

#### Error codes

| Error code | Description                                                           |
| ---------- | --------------------------------------------------------------------- |
| 9999       | Unknown error occured. %errmsg will contain more details (java error) |

### Trigger state change profile

1. Create a new profile in Tasker: plugin -> taskerHa -> HA On trigger state
2. In the configuration, there's an entity picker to search with. And you can filter by domain (fuzzy search).
3. You can enter from and to fields to filter events based on the `old_state` and `new_state`. This works the same as a trigger in a Homeassistant automation (`for` is not possible right now)

You can use tasker variables for the entity ID, from and to states, make sure to use the "%" for any variable use.

The websocket option in the main app has to be turned on for this. Oterwise it will never fire.

Any state change to the choosen element will fire the profile

**Example**

Run a Tasker task when the door opens:

- Profile: Plugin -> TaskerHA -> HA On trigger state
- Entity: `binary_sensor.front_door`
- From: `off`
- To: `on`

Now any time the door opens, this profile will fire and you can run any Tasker task.

#### Response in tasker

The following variables are available from within tasker after the action

| Variable   | Function                                                                                                                                                                                                   |
| ---------- | ---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- |
| %ha_entity | Contains the entity_id of the choosen entity                                                                                                                                                               |
| %ha_from   | Contains the old state of the choosen entity. Example `off`                                                                                                                                                |
| %ha_to     | Contains the current state of the choosen entity. Example `on`                                                                                                                                             |
| %ha_for    | Contains the duration the entity was in the state (format: hours:minutes:seconds)                                                                                                                          |
| %ha_attrs  | Contains in JSON any attributes on the entity for the new state. For example, for lights you will get the color, brightness etc.                                                                           |
| %ha_raw    | Raw JSON of the full entity state change response from homeassistant.                                                                                                                                      |
| %err       | Error code, is 0 if no error occured. Check below for a complete list of error codes. If an error occurs it will also error the task itself unless you have "continue after error" turned on on the action |
| %errmsg    | Error message. Usually contains a friendly error message, with some java exception next to it.                                                                                                             |

#### Error codes

| Error code | Description                                                           |
| ---------- | --------------------------------------------------------------------- |
| 9999       | Unknown error occured. %errmsg will contain more details (java error) |

## Support

<a href="https://www.buymeacoffee.com/db1996" target="_blank"><img src="https://www.buymeacoffee.com/assets/img/custom_images/orange_img.png" alt="Buy Me A Coffee" style="height: 41px !important;width: 174px !important;box-shadow: 0px 3px 2px 0px rgba(190, 190, 190, 0.5) !important;-webkit-box-shadow: 0px 3px 2px 0px rgba(190, 190, 190, 0.5) !important;" ></a>
