/* 
 * Copyright (C) 2016 Davide Imbriaco
 *
 * This Java file is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.syncthing.java.core.utils

import net.syncthing.java.core.beans.BlockInfo
import org.bouncycastle.util.encoders.Hex
import java.security.MessageDigest

object BlockUtils {

    fun hashBlocks(blocks: List<BlockInfo>): String {
        val string = blocks.joinToString(",") { it.hash }.toByteArray()
        val hash = MessageDigest.getInstance("SHA-256").digest(string)
        return Hex.toHexString(hash)
    }
}
