package com.nutomic.syncthingandroid.model;

/**
 * Sources:
 * - https://github.com/syncthing/syncthing/tree/main/lib/config
 * - https://github.com/syncthing/syncthing/blob/main/lib/config/optionsconfiguration.go
 */
public class Options {
    public String[] listenAddresses;                // json:"listenAddresses" xml:"listenAddress" default:"default"
    public String[] globalAnnounceServers;          // json:"globalAnnounceServers" xml:"globalAnnounceServer" default:"default"
    public boolean globalAnnounceEnabled = true;
    public boolean localAnnounceEnabled = true;
    public int localAnnouncePort = 21027;
    public String localAnnounceMCAddr;              // [ff12::8384]:21027
    public int maxSendKbps = 0;
    public int maxRecvKbps = 0;
    public int reconnectionIntervalS = 60;
    public boolean relaysEnabled = true;
    public int relayReconnectIntervalM = 10;
    public boolean startBrowser = false;            // Normally "true" but makes no sense on Android.
    public boolean natEnabled = true;
    public int natLeaseMinutes = 60;
    public int natRenewalMinutes = 30;
    public int natTimeoutSeconds = 10;
    public int urAccepted = 0;                      // 0: Undecided
    public String urUniqueId;                       // Automatically generated by SyncthingNative
    public String urURL = "https://data.syncthing.net/newdata";
    public boolean urPostInsecurely = false;
    public int urInitialDelayS = 1800;
    public int autoUpgradeIntervalH = 0;            // Normally "12" but makes no sense on Android.
    public boolean upgradeToPreReleases = false;
    public int keepTemporariesH = 24;
    public boolean cacheIgnoredFiles = false;
    public int progressUpdateIntervalS = 5;
    public boolean limitBandwidthInLan = false;
    public String releasesURL = "https://upgrades.syncthing.net/meta.json";
    public String[] alwaysLocalNets;                // Still present in SyncthingNative 1.0.1
    public boolean overwriteRemoteDeviceNamesOnConnect = false;
    public int tempIndexMinBlocks = 10;
    public boolean setLowPriority = true;

    // Since v0.14.28
    public MinHomeDiskFree minHomeDiskFree;

    // Since v1.2.0
    // json: crURL, xml: crashReportingURL
    public String crURL = "https://crash.syncthing.net/newcrash";
    public boolean crashReportingEnabled = true;
    public int stunKeepaliveStartS = 180;
    public int stunKeepaliveMinS = 20;
    public String stunServer = "default";

    // Since v1.4.0
    // See https://github.com/syncthing/syncthing/pull/6290
    public int maxFolderConcurrency = 1;
    // See https://github.com/syncthing/syncthing/pull/6303
    public int maxConcurrentIncomingRequestKiB = 0;

    // Since v1.10.0
    // See https://github.com/syncthing/syncthing/pull/6896
    public boolean announceLanAddresses = true;

    // Since v1.11.0
    // See https://github.com/calmh/syncthing/commit/e57eec8660606fa65fd3080b9c5d98447f54abeb
    public boolean sendFullIndexOnUpgrade = false;

    // Since v1.12.0
    // See https://github.com/syncthing/syncthing/pull/7055
    public String featureFlag = "";

    // Since v1.13.0
    public int connectionLimitEnough = 0;
    public int connectionLimitMax = 0;

    // Items that may be temporarily missing because they are empty.
    /**
     * Possible notification IDs:
     * crAutoDisabled                  (crash reporting after upgrade to v1.2.0)
     * crAutoEnabled                   (crash reporting after upgrade to v1.2.0)
     */
    public String unackedNotificationID = "";

    public static class MinHomeDiskFree {
        public float value = 1;
        public String unit = "%";
    }

    public static final int USAGE_REPORTING_UNDECIDED = 0;
    public static final int USAGE_REPORTING_DENIED    = -1;

    public boolean isUsageReportingAccepted(int urVersionMax) {
        return urAccepted == urVersionMax;
    }

    public boolean isUsageReportingDecided(int urVersionMax) {
        return isUsageReportingAccepted(urVersionMax) || urAccepted == USAGE_REPORTING_DENIED;
    }
}
