/*
 * Decompiled with CFR 0.152.
 */
package com.ghostsq.commander.utils;

import android.content.IntentFilter;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.content.res.Resources;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.util.Log;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserFactory;

public final class MnfUtils {
    private static final String TAG = "MnfUtils";
    private ApplicationInfo ai;
    private Resources rr;
    private String apk_path;
    private String mans;
    private static final int endDocTag = 0x100101;
    private static final int startTag = 0x100102;
    private static final int endTag = 0x100103;

    public MnfUtils(PackageManager pm, String app_name) {
        try {
            this.ai = pm.getApplicationInfo(app_name, 0);
            this.rr = pm.getResourcesForApplication(this.ai);
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
        }
    }

    public MnfUtils(String apk_path_) {
        this.apk_path = apk_path_;
    }

    public final String extractManifest() {
        try {
            InputStream is;
            if (this.mans != null) {
                return this.mans;
            }
            if (this.ai != null) {
                this.apk_path = this.ai.publicSourceDir;
            }
            if (this.apk_path == null) {
                return null;
            }
            ZipFile zip = new ZipFile(this.apk_path);
            ZipEntry entry = zip.getEntry("AndroidManifest.xml");
            if (entry != null && (is = zip.getInputStream(entry)) != null) {
                int n;
                ByteArrayOutputStream baos = new ByteArrayOutputStream((int)entry.getSize());
                byte[] buf = new byte[4096];
                while ((n = is.read(buf)) != -1) {
                    baos.write(buf, 0, n);
                }
                is.close();
                this.mans = this.decompressXML(baos.toByteArray());
                return this.mans;
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        return null;
    }

    public final Drawable extractIcon() {
        try {
            if (this.apk_path == null) {
                return null;
            }
            ZipFile zip = new ZipFile(this.apk_path);
            ZipEntry entry = zip.getEntry("res/drawable/icon.png");
            if (entry != null) {
                InputStream is = zip.getInputStream(entry);
                return is != null ? new BitmapDrawable(is) : null;
            }
        }
        catch (Throwable e) {
            Log.e((String)TAG, (String)("Can't get icon for " + this.apk_path), (Throwable)e);
        }
        return null;
    }

    private final String decompressXML(byte[] xml2) {
        int xmlTagOff;
        StringBuffer xml_sb = new StringBuffer(8192);
        int numbStrings = this.LEW(xml2, 16);
        int sitOff = 36;
        int stOff = sitOff + numbStrings * 4;
        for (int ii = xmlTagOff = this.LEW(xml2, 12); ii < xml2.length - 4; ii += 4) {
            if (this.LEW(xml2, ii) != 0x100102) continue;
            xmlTagOff = ii;
            break;
        }
        int off = xmlTagOff;
        int indent = 0;
        int startTagLineNo = -2;
        while (off < xml2.length) {
            int tag0 = this.LEW(xml2, off);
            int lineNo = this.LEW(xml2, off + 8);
            int nameNsSi = this.LEW(xml2, off + 16);
            int nameSi = this.LEW(xml2, off + 20);
            if (tag0 == 0x100102) {
                int tag6 = this.LEW(xml2, off + 24);
                int numbAttrs = this.LEW(xml2, off + 28);
                off += 36;
                String name = this.compXmlString(xml2, sitOff, stOff, nameSi);
                startTagLineNo = lineNo;
                StringBuffer sb = new StringBuffer();
                for (int ii = 0; ii < numbAttrs; ++ii) {
                    int attrNameNsSi = this.LEW(xml2, off);
                    int attrNameSi = this.LEW(xml2, off + 4);
                    int attrValueSi = this.LEW(xml2, off + 8);
                    int attrFlags = this.LEW(xml2, off + 12);
                    int attrResId = this.LEW(xml2, off + 16);
                    off += 20;
                    String attrName = this.compXmlString(xml2, sitOff, stOff, attrNameSi);
                    String attrValue = null;
                    if (attrValueSi != -1) {
                        attrValue = this.compXmlString(xml2, sitOff, stOff, attrValueSi);
                    } else {
                        if (this.rr != null) {
                            try {
                                attrValue = this.rr.getString(attrResId);
                            }
                            catch (Resources.NotFoundException notFoundException) {
                                // empty catch block
                            }
                        }
                        if (attrValue == null) {
                            attrValue = "0x" + Integer.toHexString(attrResId);
                        }
                    }
                    sb.append("\n").append(this.spaces(indent + 1)).append(attrName).append("=\"").append(attrValue).append("\"");
                }
                xml_sb.append("\n").append(this.spaces(indent)).append("<").append(name);
                if (sb.length() > 0) {
                    xml_sb.append(sb);
                }
                xml_sb.append(">");
                ++indent;
                continue;
            }
            if (tag0 == 0x100103) {
                off += 24;
                String name = this.compXmlString(xml2, sitOff, stOff, nameSi);
                xml_sb.append("\n").append(this.spaces(--indent)).append("</").append(name).append(">");
                continue;
            }
            if (tag0 == 0x100101) break;
            Log.e((String)TAG, (String)("  Unrecognized tag code '" + Integer.toHexString(tag0) + "' at offset " + off));
            break;
        }
        Log.v((String)TAG, (String)("    end at offset " + off));
        return xml_sb.toString();
    }

    private final String compXmlString(byte[] xml2, int sitOff, int stOff, int strInd) {
        if (strInd < 0) {
            return null;
        }
        int strOff = stOff + this.LEW(xml2, sitOff + strInd * 4);
        return this.compXmlStringAt(xml2, strOff);
    }

    private final String spaces(int i) {
        char[] dummy = new char[i * 2];
        Arrays.fill(dummy, ' ');
        return new String(dummy);
    }

    private final String compXmlStringAt(byte[] arr, int strOff) {
        int strLen = arr[strOff + 1] << 8 & 0xFF00 | arr[strOff] & 0xFF;
        byte[] chars = new byte[strLen];
        for (int ii = 0; ii < strLen; ++ii) {
            chars[ii] = arr[strOff + 2 + ii * 2];
        }
        return new String(chars);
    }

    private final int LEW(byte[] arr, int off) {
        return arr[off + 3] << 24 & 0xFF000000 | arr[off + 2] << 16 & 0xFF0000 | arr[off + 1] << 8 & 0xFF00 | arr[off] & 0xFF;
    }

    public final IntentFilter[] getIntentFilters(String act_name) {
        try {
            if (this.mans == null) {
                this.mans = this.extractManifest();
            }
            if (this.mans != null && this.mans.length() > 0) {
                int et;
                ArrayList<IntentFilter> list = new ArrayList<IntentFilter>();
                XmlPullParserFactory factory = XmlPullParserFactory.newInstance();
                factory.setNamespaceAware(true);
                XmlPullParser xpp = factory.newPullParser();
                xpp.setInput((Reader)new StringReader(this.mans));
                while ((et = xpp.next()) != 1) {
                    String can;
                    if (et != 2 || !"activity".equals(xpp.getName()) || act_name.indexOf(can = xpp.getAttributeValue(null, "name")) < 0) continue;
                    int d = xpp.getDepth();
                    while ((et = xpp.next()) != 1 && (d < xpp.getDepth() || et != 3)) {
                        if (!"intent-filter".equals(xpp.getName())) continue;
                        IntentFilter inf = new IntentFilter();
                        MnfUtils.initIntentFilterFromXml(inf, xpp);
                        list.add(inf);
                    }
                    break block2;
                }
                if (list.size() > 0) {
                    IntentFilter[] ret = new IntentFilter[list.size()];
                    return list.toArray(ret);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    private static final boolean initIntentFilterFromXml(IntentFilter inf, XmlPullParser xpp) {
        try {
            int type;
            int outerDepth = xpp.getDepth();
            String NAME = "name";
            while ((type = xpp.next()) != 1 && (type != 3 || xpp.getDepth() > outerDepth)) {
                if (type == 3 || type == 4) continue;
                String tag = xpp.getName();
                if (tag.equals("action")) {
                    String name = xpp.getAttributeValue(null, "name");
                    if (name == null) continue;
                    inf.addAction(name);
                    continue;
                }
                if (tag.equals("category")) {
                    String name = xpp.getAttributeValue(null, "name");
                    if (name == null) continue;
                    inf.addCategory(name);
                    continue;
                }
                if (!tag.equals("data")) continue;
                int na = xpp.getAttributeCount();
                for (int i = 0; i < na; ++i) {
                    String port = null;
                    String an = xpp.getAttributeName(i);
                    String av = xpp.getAttributeValue(i);
                    if ("mimeType".equals(an)) {
                        try {
                            inf.addDataType(av);
                        }
                        catch (IntentFilter.MalformedMimeTypeException malformedMimeTypeException) {}
                        continue;
                    }
                    if ("scheme".equals(an)) {
                        inf.addDataScheme(av);
                        continue;
                    }
                    if ("host".equals(an)) {
                        inf.addDataAuthority(av, port);
                        continue;
                    }
                    if ("port".equals(an)) {
                        port = av;
                        continue;
                    }
                    if ("path".equals(an)) {
                        inf.addDataPath(av, 0);
                        continue;
                    }
                    if ("pathPrefix".equals(an)) {
                        inf.addDataPath(av, 1);
                        continue;
                    }
                    if (!"pathPattern".equals(an)) continue;
                    inf.addDataPath(av, 2);
                }
            }
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }
}

