/*
 * Decompiled with CFR 0.152.
 */
package com.ghostsq.commander.utils;

import android.annotation.TargetApi;
import android.content.Context;
import android.os.Build;
import android.security.KeyPairGeneratorSpec;
import android.util.Log;
import com.ghostsq.commander.utils.KeyGenNew;
import java.math.BigInteger;
import java.security.Key;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Calendar;
import java.util.GregorianCalendar;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.security.auth.x500.X500Principal;

@TargetApi(value=18)
public class KeyStorage {
    private static final String TAG = "KeyStore";
    public static final String PROVIDER_ANDROID_KEYSTORE = "AndroidKeyStore";

    public static Key provideAESKey(Context ctx, String alias) {
        try {
            KeyStore ks = KeyStore.getInstance(PROVIDER_ANDROID_KEYSTORE);
            ks.load(null);
            KeyStore.Entry entry = ks.getEntry(alias, null);
            if (entry == null) {
                Log.w((String)TAG, (String)("!!!Key not found for alias=" + alias));
                KeyGenerator kg = KeyGenerator.getInstance("AES", PROVIDER_ANDROID_KEYSTORE);
                SecretKey skey = kg.generateKey();
                entry = ks.getEntry(alias, null);
            }
            if (!(entry instanceof KeyStore.SecretKeyEntry)) {
                Log.w((String)TAG, (String)"Not an instance of a SecretKeyEntry");
                return null;
            }
            KeyStore.SecretKeyEntry secretKeyEntry = (KeyStore.SecretKeyEntry)entry;
            return secretKeyEntry.getSecretKey();
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)("Alias=" + alias), (Throwable)e);
            return null;
        }
    }

    public static Key provideRSAKey(Context ctx, String alias, boolean private_key) {
        try {
            KeyStore.Entry entry;
            KeyStore ks = KeyStore.getInstance(PROVIDER_ANDROID_KEYSTORE);
            ks.load(null);
            if (!ks.containsAlias(alias)) {
                Log.w((String)TAG, (String)("!!!Keys not found for alias " + alias));
                if (Build.VERSION.SDK_INT >= 23) {
                    KeyGenNew.generateRSAKey(alias);
                } else {
                    KeyStorage.generateRSAKey(ctx, alias);
                }
            }
            if ((entry = ks.getEntry(alias, null)) == null) {
                Log.e((String)TAG, (String)("No entry for alias " + alias));
                return null;
            }
            if (!(entry instanceof KeyStore.PrivateKeyEntry)) {
                Log.e((String)TAG, (String)"Not an instance of a PrivateKeyEntry");
                return null;
            }
            KeyStore.PrivateKeyEntry private_key_entry = (KeyStore.PrivateKeyEntry)entry;
            if (private_key) {
                return private_key_entry.getPrivateKey();
            }
            return private_key_entry.getCertificate().getPublicKey();
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)("Alias=" + alias), (Throwable)e);
            return null;
        }
    }

    private static boolean generateRSAKey(Context ctx, String alias) {
        try {
            GregorianCalendar start = new GregorianCalendar();
            GregorianCalendar end = new GregorianCalendar();
            ((Calendar)end).add(1, 20);
            String cert_sbj = "CN=" + alias + ", O=Ghost Squared, OU=Ghost Commander";
            KeyPairGeneratorSpec params = new KeyPairGeneratorSpec.Builder(ctx).setAlias(alias).setSubject(new X500Principal(cert_sbj)).setSerialNumber(BigInteger.valueOf(5382L)).setStartDate(start.getTime()).setEndDate(end.getTime()).build();
            KeyPairGenerator kp_gen = KeyPairGenerator.getInstance("RSA", PROVIDER_ANDROID_KEYSTORE);
            kp_gen.initialize((AlgorithmParameterSpec)params);
            KeyPair kp = kp_gen.generateKeyPair();
            return kp != null;
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)alias, (Throwable)e);
            return false;
        }
    }
}

