/*
 * Decompiled with CFR 0.152.
 */
package com.ghostsq.commander.utils;

import android.content.ContentResolver;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.media.ExifInterface;
import android.media.ThumbnailUtils;
import android.os.Build;
import android.provider.MediaStore;
import android.util.Log;
import com.ghostsq.commander.utils.ForwardCompat;
import java.io.IOException;
import java.io.InputStream;

public class ImageInfo {
    private static final String TAG = "ImageInfo";

    public static float getImageFileOrientationDegree(String path) {
        try {
            ExifInterface exif = new ExifInterface(path);
            int ov = exif.getAttributeInt("Orientation", 0);
            float degrees = 0.0f;
            switch (ov) {
                case 6: {
                    degrees = 90.0f;
                    break;
                }
                case 8: {
                    degrees = 270.0f;
                }
            }
            return degrees;
        }
        catch (IOException e) {
            e.printStackTrace();
            return 0.0f;
        }
    }

    public static String getImageFileInfoHTML(String path) {
        try {
            return ImageInfo.getImageInfoAsHTML(new ExifInterface(path));
        }
        catch (IOException e) {
            Log.e((String)TAG, (String)("File path: " + path), (Throwable)e);
            return null;
        }
    }

    public static String getImageStreamInfoHTML(InputStream is) {
        if (Build.VERSION.SDK_INT < 24) {
            return null;
        }
        ExifInterface exif = ForwardCompat.getExifInterfaceFromStream(is);
        return exif != null ? ImageInfo.getImageInfoAsHTML(exif) : null;
    }

    public static String getImageInfoAsHTML(ExifInterface exif) {
        String dt;
        String mo;
        String ma;
        int fe;
        int li;
        int wi;
        StringBuilder sb = new StringBuilder(100);
        int ov = exif.getAttributeInt("Orientation", 0);
        String os = null;
        switch (ov) {
            case 1: {
                os = "Normal";
                break;
            }
            case 6: {
                os = "90\u00b0";
                break;
            }
            case 8: {
                os = "270\u00b0";
                break;
            }
            case 3: {
                os = "180\u00b0";
                break;
            }
            case 2: {
                os = "Hor.flip";
                break;
            }
            case 4: {
                os = "Ver.flip";
                break;
            }
            case 5: {
                os = "Transposed";
                break;
            }
            case 7: {
                os = "Transversed";
            }
        }
        int INV = -1;
        if (os != null) {
            sb.append("<b>Orientation:</b> ").append(os);
        }
        if ((wi = exif.getAttributeInt("ImageWidth", -1)) > 0) {
            sb.append("<br/><b>Width:</b> ").append(wi);
        }
        if ((li = exif.getAttributeInt("ImageLength", -1)) > 0) {
            sb.append("<br/><b>Height:</b> ").append(li);
        }
        if (Build.VERSION.SDK_INT >= 11) {
            ForwardCompat.getImageFileExtraInfo(exif, sb);
        }
        if ((fe = exif.getAttributeInt("Flash", -1)) > 0) {
            sb.append("<br/><b>Flash:</b> ").append(fe);
            int wb = exif.getAttributeInt("WhiteBalance", -1);
            if (wb != -1) {
                String ws = null;
                if (wb == 0) {
                    ws = "Auto";
                }
                if (wb == 1) {
                    ws = "Manual";
                }
                if (ws != null) {
                    sb.append("<br/><b>WB:</b> ").append(ws);
                }
            }
        }
        if ((ma = exif.getAttribute("Make")) != null) {
            sb.append("<br/><b>Make:</b> ").append(ma);
        }
        if ((mo = exif.getAttribute("Model")) != null) {
            sb.append("<br/><b>Model:</b> ").append(mo);
        }
        if ((dt = exif.getAttribute("DateTime")) != null) {
            sb.append("<br/><b>Date:</b> ").append(dt);
        }
        return sb.toString();
    }

    public static Bitmap createVideoThumbnail(String path) {
        return ThumbnailUtils.createVideoThumbnail((String)path, (int)1);
    }

    public static Bitmap getVideoThumbnail(ContentResolver cr, long id2, int sample_size) {
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inSampleSize = sample_size;
        return MediaStore.Video.Thumbnails.getThumbnail((ContentResolver)cr, (long)id2, (int)1, (BitmapFactory.Options)options);
    }
}

