/*
 * Decompiled with CFR 0.152.
 */
package com.ghostsq.commander.utils;

import android.content.Context;
import android.util.Base64;
import com.ghostsq.commander.utils.KeyStorage;
import com.ghostsq.commander.utils.Utils;
import java.security.Key;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;

public class Crypt {
    private static final String TAG = "Crypt";
    private static final String SEED = "5hO@%#O7&!H3#R";
    private static byte[] rawKey = null;

    public static byte[] getRawKey() throws Exception {
        if (rawKey != null) {
            return rawKey;
        }
        rawKey = Crypt.getRawKey(SEED);
        return rawKey;
    }

    private static byte[] getRawKey(String seed) throws Exception {
        KeyGenerator kgen = KeyGenerator.getInstance("AES");
        SecureRandom sr = SecureRandom.getInstance("SHA1PRNG");
        sr.setSeed(seed.getBytes());
        kgen.init(128, sr);
        SecretKey skey = kgen.generateKey();
        byte[] raw2 = skey.getEncoded();
        return raw2;
    }

    public static String encrypt(String cleartext, boolean base64out) throws Exception {
        byte[] rawKey = Crypt.getRawKey();
        byte[] result = Crypt.encrypt(rawKey, cleartext.getBytes());
        if (base64out) {
            return Base64.encodeToString((byte[])result, (int)0);
        }
        return Utils.toHexString(result, null);
    }

    public static String decrypt(String encrypted, boolean base64in) throws Exception {
        byte[] rawKey = Crypt.getRawKey();
        byte[] enc = base64in ? Base64.decode((String)encrypted, (int)0) : Utils.hexStringToBytes(encrypted);
        byte[] result = Crypt.decrypt(rawKey, enc);
        return new String(result);
    }

    public static byte[] encrypt(byte[] raw_key, byte[] clear) throws Exception {
        SecretKeySpec skeySpec = new SecretKeySpec(raw_key, "AES");
        Cipher cipher = Cipher.getInstance("AES");
        cipher.init(1, skeySpec);
        byte[] encrypted = cipher.doFinal(clear);
        return encrypted;
    }

    public static byte[] decrypt(byte[] raw_key, byte[] encrypted) throws Exception {
        SecretKeySpec skeySpec = new SecretKeySpec(raw_key, "AES");
        Cipher cipher = Cipher.getInstance("AES");
        cipher.init(2, skeySpec);
        byte[] decrypted = cipher.doFinal(encrypted);
        return decrypted;
    }

    public static String encryptAES(Context ctx, String cleartext, boolean base64out) throws Exception {
        Cipher cipher = Cipher.getInstance("AES");
        Key k = KeyStorage.provideAESKey(ctx, "CryptAES");
        if (!(k instanceof SecretKey)) {
            return null;
        }
        cipher.init(1, k);
        byte[] encrypted = cipher.doFinal(cleartext.getBytes());
        if (base64out) {
            return Base64.encodeToString((byte[])encrypted, (int)0);
        }
        return Utils.toHexString(encrypted, null);
    }

    public static String decryptAES(Context ctx, String encrypted, boolean base64in) throws Exception {
        Cipher cipher = Cipher.getInstance("AES");
        Key k = KeyStorage.provideAESKey(ctx, "CryptAES");
        if (!(k instanceof SecretKey)) {
            return null;
        }
        cipher.init(2, k);
        byte[] encb = base64in ? Base64.decode((String)encrypted, (int)0) : Utils.hexStringToBytes(encrypted);
        byte[] decb = cipher.doFinal(encb);
        return new String(decb);
    }

    public static String encrypt(Context ctx, String cleartext, boolean base64out) throws Exception {
        Cipher cipher = Cipher.getInstance("RSA/ECB/PKCS1Padding");
        Key k = KeyStorage.provideRSAKey(ctx, TAG, false);
        if (!(k instanceof PublicKey)) {
            return null;
        }
        cipher.init(1, k);
        byte[] encrypted = cipher.doFinal(cleartext.getBytes());
        if (base64out) {
            return Base64.encodeToString((byte[])encrypted, (int)0);
        }
        return Utils.toHexString(encrypted, null);
    }

    public static String decrypt(Context ctx, String encrypted, boolean base64in) throws Exception {
        Cipher cipher = Cipher.getInstance("RSA/ECB/PKCS1Padding");
        Key k = KeyStorage.provideRSAKey(ctx, TAG, true);
        if (!(k instanceof PrivateKey)) {
            return null;
        }
        cipher.init(2, k);
        byte[] encb = base64in ? Base64.decode((String)encrypted, (int)0) : Utils.hexStringToBytes(encrypted);
        byte[] decb = cipher.doFinal(encb);
        return new String(decb);
    }
}

