/*
 * Decompiled with CFR 0.152.
 */
package com.ghostsq.commander.toolbuttons;

import android.app.ListActivity;
import android.content.Context;
import android.content.SharedPreferences;
import android.os.Bundle;
import android.preference.PreferenceManager;
import android.text.Editable;
import android.text.TextWatcher;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ArrayAdapter;
import android.widget.CheckBox;
import android.widget.CompoundButton;
import android.widget.EditText;
import android.widget.ListAdapter;
import android.widget.TextView;
import com.commonsware.cwac.tlv.TouchListView;
import com.ghostsq.commander.toolbuttons.ToolButton;
import com.ghostsq.commander.toolbuttons.ToolButtons;
import com.ghostsq.commander.utils.Utils;
import java.util.List;

public class ToolButtonsProps
extends ListActivity {
    public final String TAG = ((Object)((Object)this)).getClass().getName();
    private ToolButtonsAdapter adapter = null;
    private ToolButtons array = new ToolButtons();
    private TouchListView tlv;
    private TouchListView.DropListener onDrop = new TouchListView.DropListener(){

        public void drop(int from, int to) {
            ToolButton item = (ToolButton)ToolButtonsProps.this.adapter.getItem(from);
            ToolButtonsProps.this.adapter.remove(item);
            ToolButtonsProps.this.adapter.insert(item, to);
        }
    };
    private TouchListView.RemoveListener onRemove = new TouchListView.RemoveListener(){

        public void remove(int which) {
            ToolButtonsProps.this.adapter.remove(ToolButtonsProps.this.adapter.getItem(which));
        }
    };

    public void onCreate(Bundle bundle) {
        SharedPreferences sp = PreferenceManager.getDefaultSharedPreferences((Context)this);
        Utils.setTheme((Context)this, sp.getString("color_themes", "d"));
        super.onCreate(bundle);
        this.setContentView(2130903063);
        this.array.restore(sp, (Context)this, false);
        this.tlv = (TouchListView)this.getListView();
        this.adapter = new ToolButtonsAdapter();
        this.setListAdapter((ListAdapter)this.adapter);
        this.tlv.setDropListener(this.onDrop);
        this.tlv.setRemoveListener(this.onRemove);
    }

    protected void onPause() {
        super.onPause();
        Log.v((String)this.TAG, (String)"onPause()");
        this.toLog();
        SharedPreferences.Editor sp_edit = PreferenceManager.getDefaultSharedPreferences((Context)this).edit();
        this.array.store(sp_edit);
        sp_edit.commit();
    }

    public void toLog() {
        StringBuffer resb = new StringBuffer();
        for (int i = 0; i < this.array.size(); ++i) {
            resb.append(((ToolButton)this.array.get(i)).getCaption());
            resb.append("-");
            resb.append(((ToolButton)this.array.get(i)).isVisible());
            resb.append(", ");
        }
        Log.v((String)this.TAG, (String)resb.toString());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ToolButtonsAdapter
    extends ArrayAdapter<ToolButton> {
        ToolButtonsAdapter() {
            super((Context)ToolButtonsProps.this, 2130903042, (List)ToolButtonsProps.this.array);
        }

        public View getView(int position, View convertView, ViewGroup parent) {
            try {
                ToolButton tb = (ToolButton)ToolButtonsProps.this.array.get(position);
                if (tb != null) {
                    View row = convertView;
                    ViewHolder holder = null;
                    if (row == null) {
                        LayoutInflater inflater = ToolButtonsProps.this.getLayoutInflater();
                        row = inflater.inflate(2130903042, parent, false);
                        final ViewHolder viewHolder$ = new ViewHolder();
                        viewHolder$.tb = tb;
                        viewHolder$.label = (TextView)row.findViewById(2131230792);
                        viewHolder$.caped = (EditText)row.findViewById(2131230793);
                        viewHolder$.caped.addTextChangedListener(new TextWatcher(){

                            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
                            }

                            public void onTextChanged(CharSequence s, int start, int before, int count) {
                            }

                            public void afterTextChanged(Editable e) {
                                viewHolder$.tb.setCaption(viewHolder$.caped.getText().toString());
                            }
                        });
                        viewHolder$.viscb = (CheckBox)row.findViewById(2131230791);
                        viewHolder$.viscb.setOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener(){

                            public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
                                viewHolder$.tb.setVisible(buttonView.isChecked());
                            }
                        });
                        row.setTag((Object)viewHolder$);
                        holder = viewHolder$;
                    } else {
                        holder = (ViewHolder)row.getTag();
                        holder.tb = tb;
                    }
                    holder.label.setText((CharSequence)tb.getName((Context)ToolButtonsProps.this));
                    holder.viscb.setChecked(tb.isVisible());
                    holder.caped.setText((CharSequence)tb.getCaption());
                    return row;
                }
            }
            catch (Exception e) {
                Log.e((String)ToolButtonsProps.this.TAG, (String)("position " + position), (Throwable)e);
            }
            return null;
        }

        class ViewHolder {
            protected ToolButton tb;
            protected TextView label;
            protected CheckBox viscb;
            protected EditText caped;

            ViewHolder() {
            }
        }
    }
}

