/*
 * Decompiled with CFR 0.152.
 */
package com.ghostsq.commander.favorites;

import android.content.Context;
import android.content.SharedPreferences;
import android.net.Uri;
import android.os.Build;
import android.util.Log;
import com.ghostsq.commander.Panels;
import com.ghostsq.commander.favorites.Favorite;
import com.ghostsq.commander.utils.Credentials;
import com.ghostsq.commander.utils.ForwardCompat;
import com.ghostsq.commander.utils.Utils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.NoSuchElementException;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Favorites
extends ArrayList<Favorite> {
    private static final long serialVersionUID = 1L;
    private static final String old_sep = ",";
    private static final String sep = ";";
    private final String TAG = this.getClass().getSimpleName();
    private final Context c;
    private ArrayList<String> idsToRemove = new ArrayList();

    public Favorites(Context c_) {
        this.c = c_;
    }

    public final void addToFavorites(Uri u, Credentials crd, String comment) {
        this.removeFromFavorites(u);
        if (crd == null && Favorite.isPwdScreened(u)) {
            crd = this.searchForPassword(u);
        }
        Favorite f = new Favorite(u, crd);
        this.add(f);
        if (comment != null) {
            f.setComment(comment);
        }
    }

    public final void removeFromFavorites(Uri u) {
        int pos = this.findIgnoreAuth(u);
        if (pos >= 0) {
            this.remove(pos);
        } else {
            Log.w((String)this.TAG, (String)("Can't find in the list of favs:" + u));
        }
    }

    @Override
    public Favorite remove(int i) {
        Favorite f = (Favorite)this.get(i);
        this.idsToRemove.add(f.getID());
        return (Favorite)super.remove(i);
    }

    @Override
    public boolean remove(Object o) {
        if (!(o instanceof Favorite)) {
            return false;
        }
        Favorite f = (Favorite)o;
        this.idsToRemove.add(f.getID());
        return super.remove(f);
    }

    public final int findIgnoreAuth(Uri u) {
        try {
            if (u != null) {
                u = Utils.addTrailngSlash(Utils.updateUserInfo(u, null));
                for (int i = 0; i < this.size(); ++i) {
                    Favorite f = (Favorite)this.get(i);
                    if (f == null) {
                        Log.e((String)this.TAG, (String)"A fave is null!");
                        continue;
                    }
                    Uri fu = f.getUri();
                    if (fu == null) {
                        Log.e((String)this.TAG, (String)"A fave URI is null!");
                        continue;
                    }
                    if (!(fu = Utils.addTrailngSlash(fu)).equals((Object)u)) continue;
                    return i;
                }
            }
        }
        catch (Exception e) {
            Log.e((String)this.TAG, (String)("Uri: " + Favorite.screenPwd(u)), (Throwable)e);
        }
        return -1;
    }

    public final Credentials searchForPassword(Uri u) {
        try {
            String ui = u.getUserInfo();
            if (ui != null && ui.length() > 0) {
                String user = ui.substring(0, ui.indexOf(58));
                String host = u.getHost();
                String schm = u.getScheme();
                String path = u.getPath();
                if (path == null || path.length() == 0) {
                    path = "/";
                } else {
                    Utils.mbAddSl(path);
                }
                int best = -1;
                for (int i = 0; i < this.size(); ++i) {
                    try {
                        Uri fu;
                        Favorite f = (Favorite)this.get(i);
                        if (!user.equalsIgnoreCase(f.getUserName()) || !schm.equals((fu = f.getUri()).getScheme()) || !host.equalsIgnoreCase(fu.getHost())) continue;
                        best = i;
                        String fp = fu.getPath();
                        if (fp == null || path.length() == 0) {
                            fp = "/";
                        } else {
                            Utils.mbAddSl(fp);
                        }
                        if (!path.equalsIgnoreCase(fp)) continue;
                        break;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (best >= 0) {
                    Favorite f = (Favorite)this.get(best);
                    return f.borrowPassword(u);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Log.w((String)this.TAG, (String)"Faild to find a suitable Favorite with password!!!");
        return null;
    }

    public final void setDefaults() {
        try {
            this.add(new Favorite("home:", this.c.getString(2131361832)));
            this.add(new Favorite(Panels.DEFAULT_LOC, this.c.getString(2131361919)));
            if (Build.VERSION.SDK_INT >= 8) {
                this.add(new Favorite(Utils.getPath(Utils.PubPathType.DOWNLOADS), this.c.getString(2131361843)));
                this.add(new Favorite(Utils.getPath(Utils.PubPathType.DCIM), this.c.getString(2131361844)));
                this.add(new Favorite(Utils.getPath(Utils.PubPathType.PICTURES), this.c.getString(2131361845)));
                this.add(new Favorite(Utils.getPath(Utils.PubPathType.MUSIC), this.c.getString(2131361846)));
                this.add(new Favorite(Utils.getPath(Utils.PubPathType.MOVIES), this.c.getString(2131361847)));
            }
        }
        catch (Throwable e) {
            Log.e((String)this.TAG, null, (Throwable)e);
        }
    }

    public final void setFromString(String stored) {
        if (stored == null) {
            return;
        }
        this.clear();
        String use_sep = sep;
        String[] favs = stored.split(use_sep);
        try {
            for (int i = 0; i < favs.length; ++i) {
                String stored_fav = this.unescape(favs[i]);
                this.add(Favorite.fromString(stored_fav, this.c));
            }
        }
        catch (NoSuchElementException e) {
            Log.e((String)this.TAG, null, (Throwable)e);
        }
        if (this.isEmpty()) {
            this.add(new Favorite("home:", this.c.getString(2131361832)));
        }
    }

    private final String unescape(String s) {
        return s.replace("%3B", sep);
    }

    private final String escape(String s) {
        return s.replace(sep, "%3B");
    }

    public final void store() {
        SharedPreferences sp = this.c.getSharedPreferences("Favorites", 4);
        SharedPreferences.Editor ed = sp.edit();
        HashSet<String> ids = new HashSet<String>();
        for (int i = 0; i < this.size(); ++i) {
            ((Favorite)this.get(i)).store(this.c, ed);
            ids.add(((Favorite)this.get(i)).getID());
        }
        if (Build.VERSION.SDK_INT >= 11) {
            ForwardCompat.putStringSet(ed, "IDS", ids);
        } else {
            StringBuffer buf = new StringBuffer(256);
            for (String id2 : ids) {
                if (buf.length() > 0) {
                    buf.append(old_sep);
                }
                buf.append(id2);
            }
            ed.putString("IDScsv", buf.toString());
        }
        for (String id3 : this.idsToRemove) {
            Favorite.erasePrefs(id3, ed);
        }
        this.idsToRemove.clear();
        ed.commit();
    }

    public final void restore() {
        try {
            this.clear();
            SharedPreferences sp = this.c.getSharedPreferences("Favorites", 4);
            if (sp == null) {
                return;
            }
            if (Build.VERSION.SDK_INT >= 11) {
                Set<String> ids = ForwardCompat.getStringSet(sp, "IDS");
                if (ids == null) {
                    return;
                }
                for (String id2 : ids) {
                    this.restoreFav(id2, sp);
                }
            } else {
                String[] ida;
                String idcs = sp.getString("IDScsv", null);
                if (idcs == null) {
                    return;
                }
                for (String id3 : ida = idcs.split(old_sep)) {
                    this.restoreFav(id3, sp);
                }
            }
        }
        catch (Exception e) {
            Log.e((String)this.TAG, (String)"", (Throwable)e);
        }
    }

    private final void restoreFav(String id2, SharedPreferences sp) {
        Favorite fav = Favorite.restore(this.c, id2, sp);
        if (fav != null) {
            this.add(fav);
        }
    }

    public static void clearPrefs(Context c) {
        SharedPreferences sp = c.getSharedPreferences("Favorites", 4);
        SharedPreferences.Editor ed = sp.edit();
        ed.clear();
        ed.commit();
    }
}

