/*
 * Decompiled with CFR 0.152.
 */
package com.ghostsq.commander.adapters;

import android.content.Context;
import android.content.SharedPreferences;
import android.net.Uri;
import android.os.Build;
import android.os.Handler;
import android.preference.PreferenceManager;
import android.text.format.Formatter;
import android.util.Log;
import android.util.SparseBooleanArray;
import com.ghostsq.commander.Panels;
import com.ghostsq.commander.adapters.CommanderAdapter;
import com.ghostsq.commander.adapters.CommanderAdapterBase;
import com.ghostsq.commander.adapters.Engine;
import com.ghostsq.commander.adapters.Engines;
import com.ghostsq.commander.adapters.FSAdapter;
import com.ghostsq.commander.adapters.MediaScanEngine;
import com.ghostsq.commander.utils.Credentials;
import com.ghostsq.commander.utils.Utils;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import net.lingala.zip4j.core.ZipFile;
import net.lingala.zip4j.exception.ZipException;
import net.lingala.zip4j.io.ZipInputStream;
import net.lingala.zip4j.model.FileHeader;
import net.lingala.zip4j.model.ZipParameters;
import net.lingala.zip4j.progress.ProgressMonitor;
import net.lingala.zip4j.util.Zip4jUtil;

public class ZipAdapter
extends CommanderAdapterBase
implements Engines.IReciever {
    public static final String TAG = "ZipAdapter";
    protected static final int BLOCK_SIZE = 100000;
    public Uri uri = null;
    public ZipFile zip = null;
    public FileHeader[] items = null;
    public boolean password_validated = false;
    public String password = null;
    public String encoding = null;

    public ZipAdapter(Context ctx_) {
        super(ctx_);
        this.parentLink = "..";
    }

    public String getScheme() {
        return "zip";
    }

    public boolean hasFeature(CommanderAdapter.Feature feature) {
        switch (feature) {
            case REAL: 
            case SZ: {
                return true;
            }
            case F4: {
                return false;
            }
        }
        return super.hasFeature(feature);
    }

    public void setCredentials(Credentials crd) {
        try {
            String string2 = this.password = crd == null ? null : crd.getPassword();
            if (this.zip != null) {
                this.zip.setPassword(this.password != null ? this.password.toCharArray() : null);
            }
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"", (Throwable)e);
        }
    }

    public Credentials getCredentials() {
        return this.password != null ? new Credentials(null, this.password) : null;
    }

    public final ZipFile createZipFileInstance(Uri u) {
        try {
            if (u == null) {
                return null;
            }
            String zip_path = u.getPath();
            if (zip_path == null) {
                return null;
            }
            ZipFile zip_file = new ZipFile(zip_path);
            String enc = this.encoding;
            if (enc == null) {
                enc = u.getQueryParameter("e");
            }
            if (enc == null) {
                enc = "UTF-8";
            }
            zip_file.setFileNameCharset(enc);
            if (this.password != null && Zip4jUtil.checkFileExists((String)zip_path)) {
                zip_file.setPassword(this.password);
            }
            return zip_file;
        }
        catch (ZipException e) {
            Log.e((String)TAG, (String)("Can't create zip file instance for " + u.toString()), (Throwable)e);
            return null;
        }
    }

    public final synchronized void setZipFile(ZipFile zf) {
        this.zip = zf;
    }

    public final synchronized ZipFile getZipFile() {
        return this.zip;
    }

    public boolean readSource(Uri tmp_uri, String pass_back_on_done) {
        try {
            this.zip = null;
            if (tmp_uri != null) {
                this.uri = tmp_uri;
            }
            if (this.uri == null) {
                return false;
            }
            if (this.reader != null && this.reader.isAlive()) {
                this.commander.showInfo(this.ctx.getString(2131362054));
                this.reader.interrupt();
                Thread.sleep(500L);
                if (this.reader.isAlive()) {
                    return false;
                }
            }
            Log.v((String)TAG, (String)("reading " + this.uri));
            this.notify(-1);
            this.reader = new ListEngine(this.readerHandler, pass_back_on_done);
            this.reader.start();
            return true;
        }
        catch (Exception e) {
            this.commander.showError("Exception: " + e);
            e.printStackTrace();
            this.notify("Fail", -2);
            return false;
        }
    }

    protected void onReadComplete() {
        if (this.reader instanceof ListEngine) {
            ListEngine list_engine = (ListEngine)this.reader;
            FileHeader[] tmp_items = list_engine.getItems();
            if (tmp_items != null && (this.mode & 8) == 8) {
                int cnt = 0;
                for (int i = 0; i < tmp_items.length; ++i) {
                    if (tmp_items[i].getFileName().charAt(0) == '.') continue;
                    ++cnt;
                }
                this.items = new FileHeader[cnt];
                int j = 0;
                for (int i = 0; i < tmp_items.length; ++i) {
                    if (tmp_items[i].getFileName().charAt(0) == '.') continue;
                    this.items[j++] = tmp_items[i];
                }
            } else {
                this.items = tmp_items;
            }
            this.numItems = this.items != null ? this.items.length + 1 : 1;
            this.notifyDataSetChanged();
        }
    }

    public String toString() {
        return this.uri != null ? Uri.decode((String)this.uri.toString()) : "";
    }

    public Uri getUri() {
        return this.uri;
    }

    public void setUri(Uri uri_) {
        this.uri = uri_;
    }

    public void reqItemsSize(SparseBooleanArray cis) {
        FileHeader[] fhs = this.bitsToItems(cis);
        if (fhs == null) {
            return;
        }
        this.notify(-1);
        this.commander.startEngine(new CalcSizesEngine(fhs));
    }

    public boolean unpackZip(File zip_file) {
        try {
            if (!this.checkReadyness()) {
                return false;
            }
            this.notify(-1);
            this.commander.startEngine(new ExtractAllEngine(zip_file, zip_file.getParentFile()));
            return true;
        }
        catch (Exception e) {
            this.notify("Exception: " + e.getMessage(), -2);
            return false;
        }
    }

    public boolean copyItems(SparseBooleanArray cis, CommanderAdapter to, boolean move) {
        try {
            if (this.zip == null) {
                throw new RuntimeException("Invalid ZIP");
            }
            FileHeader[] subItems = this.bitsToItems(cis);
            if (subItems == null) {
                throw new RuntimeException("Nothing to extract");
            }
            if (!this.checkReadyness()) {
                return false;
            }
            Engines.IReciever recipient = null;
            File dest = null;
            if (to instanceof FSAdapter) {
                dest = new File(to.toString());
                if (!dest.exists()) {
                    dest.mkdirs();
                }
                if (!dest.isDirectory()) {
                    throw new RuntimeException(this.ctx.getString(2131361979));
                }
            } else {
                dest = new File(this.createTempDir());
                recipient = to.getReceiver();
            }
            this.notify(-1);
            this.commander.startEngine(new CopyFromEngine(subItems, dest, recipient));
            return true;
        }
        catch (Exception e) {
            this.commander.showError("Exception: " + e.getMessage());
            return false;
        }
    }

    public boolean createFile(String name) {
        try {
            File tmp_ctr = Utils.getTempDir(this.ctx);
            File tmp_file = new File(tmp_ctr, name);
            tmp_file.createNewFile();
            if (this.createItem(tmp_file, tmp_ctr.getAbsolutePath())) {
                this.notifyRefr(name);
                tmp_file.deleteOnExit();
                return true;
            }
        }
        catch (IOException e) {
            Log.e((String)TAG, (String)("Can't create " + name), (Throwable)e);
        }
        this.notify(this.ctx.getString(2131362021, new Object[]{name}), -2);
        return false;
    }

    public void createFolder(String fld_name) {
        File tmp_ctr = Utils.getTempDir(this.ctx);
        File tmp_fld = new File(tmp_ctr, fld_name);
        tmp_fld.mkdir();
        if (this.createItem(tmp_fld, tmp_ctr.getAbsolutePath())) {
            this.notifyRefr(fld_name);
        } else {
            this.notify(this.ctx.getString(2131362013, new Object[]{fld_name}), -2);
        }
        tmp_fld.deleteOnExit();
    }

    public boolean createItem(File item, String folder_path) {
        try {
            ZipParameters parameters = new ZipParameters();
            parameters.setCompressionMethod(8);
            parameters.setCompressionLevel(7);
            parameters.setDefaultFolderPath(folder_path);
            String dest_path = this.uri.getFragment();
            if (Utils.str(dest_path) && !"/".equals(dest_path)) {
                parameters.setRootFolderInZip(dest_path);
            }
            if (this.password != null) {
                parameters.setEncryptFiles(true);
                parameters.setEncryptionMethod(99);
                parameters.setAesKeyStrength(3);
                parameters.setPassword(this.password.toCharArray());
            }
            if (this.encoding != null) {
                // empty if block
            }
            if (this.zip == null) {
                this.zip = this.createZipFileInstance(this.uri);
            }
            ArrayList<File> f_list = new ArrayList<File>(1);
            f_list.add(item);
            this.zip.addFiles(f_list, parameters);
            return true;
        }
        catch (ZipException e) {
            Log.e((String)TAG, (String)("Creating folder " + item.getName()), (Throwable)e);
            return false;
        }
    }

    public boolean deleteItems(SparseBooleanArray cis) {
        try {
            if (!this.checkReadyness()) {
                return false;
            }
            FileHeader[] to_delete = this.bitsToItems(cis);
            if (to_delete != null && this.zip != null && this.uri != null) {
                this.notify(-1);
                this.commander.startEngine(new DelEngine(to_delete));
                return true;
            }
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"deleteItems()", (Throwable)e);
        }
        this.notify(null, -2);
        return false;
    }

    public Uri getItemUri(int position) {
        if (this.uri == null) {
            return null;
        }
        if (this.items == null || position > this.items.length) {
            return null;
        }
        String enc_path = Utils.escapeName(this.fixName(this.items[position - 1]));
        return this.uri.buildUpon().encodedFragment(enc_path).build();
    }

    public String getItemName(int position, boolean full) {
        if (this.items != null && position > 0 && position <= this.items.length) {
            if (full) {
                Uri item_uri;
                if (this.uri != null && (item_uri = this.getItemUri(position)) != null) {
                    return item_uri.toString();
                }
            } else {
                return new File(this.fixName(this.items[position - 1])).getName();
            }
        }
        return null;
    }

    public void openItem(int position) {
        if (position == 0) {
            if (this.uri == null) {
                return;
            }
            String cur = null;
            try {
                cur = this.uri.getFragment();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (cur == null || cur.length() == 0 || cur.length() == 1 && cur.charAt(0) == SLC) {
                File zip_file = new File(this.uri.getPath());
                String parent_dir = Utils.escapePath(zip_file.getParent());
                this.commander.Navigate(Uri.parse((String)(parent_dir != null ? parent_dir : Panels.DEFAULT_LOC)), null, zip_file.getName());
            } else {
                File cur_f = new File(cur);
                String parent_dir = cur_f.getParent();
                this.commander.Navigate(this.uri.buildUpon().fragment(parent_dir != null ? parent_dir : "").build(), null, cur_f.getName());
            }
            return;
        }
        if (this.items == null || position < 0 || position > this.items.length) {
            return;
        }
        FileHeader item = this.items[position - 1];
        if (item.isDirectory()) {
            this.commander.Navigate(this.uri.buildUpon().fragment(this.fixName(item)).build(), null, null);
        } else {
            this.commander.Open(this.uri.buildUpon().fragment(this.fixName(item)).build(), null);
        }
    }

    public boolean receiveItems(String[] uris, int move_mode) {
        try {
            if (!this.checkReadyness()) {
                return false;
            }
            if (uris == null || uris.length == 0) {
                this.notify(this.s(2131361975), -2);
                return false;
            }
            File[] list = Utils.getListOfFiles(uris);
            if (list == null) {
                this.notify("Something wrong with the files", -2);
                return false;
            }
            this.notify(-1);
            this.items = null;
            this.commander.startEngine(new CopyToEngine(list, this.uri.getFragment(), move_mode));
            return true;
        }
        catch (Exception e) {
            this.notify("Exception: " + e.getMessage(), -2);
            return false;
        }
    }

    public Engines.IReciever getReceiver() {
        return this;
    }

    public boolean createZip(File[] list, String zip_fn, String pw, String enc) {
        try {
            if (!this.checkReadyness()) {
                return false;
            }
            Uri.Builder ub = new Uri.Builder();
            ub.scheme(this.getScheme()).path(zip_fn);
            this.setUri(ub.build());
            this.password = pw;
            this.encoding = enc;
            this.notify(-1);
            this.commander.startEngine(new CopyToEngine(list, new File(zip_fn)));
            return true;
        }
        catch (Exception e) {
            this.notify("Exception: " + e.getMessage(), -2);
            return false;
        }
    }

    public boolean renameItem(int position, String new_name, boolean copy) {
        FileHeader to_rename = this.items[position - 1];
        if (to_rename != null && this.zip != null && Utils.str(new_name)) {
            this.notify(-1);
            RenameEngine eng = new RenameEngine(to_rename, new_name, copy);
            this.commander.startEngine(eng);
            return true;
        }
        return false;
    }

    public void prepareToDestroy() {
        super.prepareToDestroy();
        this.items = null;
    }

    public Object getItem(int position) {
        CommanderAdapter.Item item = new CommanderAdapter.Item();
        item.name = "";
        if (position == 0) {
            item.name = this.parentLink;
        } else if (this.items != null && position > 0 && position <= this.items.length) {
            int item_time;
            FileHeader zip_entry = this.items[position - 1];
            item.dir = zip_entry.isDirectory();
            String name = this.fixName(zip_entry);
            int lsp = name.lastIndexOf(SLC, item.dir ? name.length() - 2 : name.length());
            String string2 = item.name = lsp > 0 ? name.substring(lsp + 1) : name;
            if (!item.dir) {
                item.size = zip_entry.getUncompressedSize();
            }
            item.date = (item_time = zip_entry.getLastModFileTime()) > 0 ? new Date(Zip4jUtil.dosToJavaTme((int)item_time)) : null;
            item.attr = zip_entry.getFileComment();
        }
        return item;
    }

    private final String fixName(FileHeader entry) {
        try {
            return entry.getFileName();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private final FileHeader[] bitsToItems(SparseBooleanArray cis) {
        try {
            int counter = 0;
            for (int i = 0; i < cis.size(); ++i) {
                if (!cis.valueAt(i)) continue;
                ++counter;
            }
            FileHeader[] subItems = new FileHeader[counter];
            int j = 0;
            for (int i = 0; i < cis.size(); ++i) {
                if (!cis.valueAt(i)) continue;
                subItems[j++] = this.items[cis.keyAt(i) - 1];
            }
            return subItems;
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"", (Throwable)e);
            return null;
        }
    }

    private final boolean checkReadyness() {
        return true;
    }

    protected void reSort() {
        if (this.items == null) {
            return;
        }
        ZipItemPropComparator comp = new ZipItemPropComparator(this.mode & 0x30, (this.mode & 0x80) != 0, this.ascending);
        Arrays.sort(this.items, comp);
    }

    public CommanderAdapter.Item getItem(Uri u) {
        try {
            FileHeader zip_entry;
            String entry_name;
            String zip_path = u.getPath();
            if (zip_path == null) {
                return null;
            }
            if (this.zip == null) {
                this.zip = this.createZipFileInstance(u);
            }
            if ((entry_name = u.getFragment()) != null && (zip_entry = this.zip.getFileHeader(entry_name)) != null) {
                String name = this.fixName(zip_entry);
                CommanderAdapter.Item item = new CommanderAdapter.Item();
                item.dir = zip_entry.isDirectory();
                int lsp = name.lastIndexOf(SLC, item.dir ? name.length() - 2 : name.length());
                item.name = lsp > 0 ? name.substring(lsp + 1) : name;
                item.size = zip_entry.getUncompressedSize();
                long item_time = zip_entry.getLastModFileTime();
                item.date = item_time > 0L ? new Date(item_time) : null;
                return item;
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        return null;
    }

    public InputStream getContent(Uri u, long offset) {
        try {
            FileHeader cachedEntry;
            String opened_zip_path;
            String zip_path = u.getPath();
            if (zip_path == null) {
                return null;
            }
            String string2 = opened_zip_path = this.uri != null ? this.uri.getPath() : null;
            if (opened_zip_path == null || this.zip == null) {
                this.zip = this.createZipFileInstance(u);
            } else if (!zip_path.equalsIgnoreCase(opened_zip_path)) {
                return null;
            }
            String entry_name = u.getFragment();
            if (entry_name != null && (cachedEntry = this.zip.getFileHeader(entry_name)) != null) {
                ZipInputStream is = this.zip.getInputStream(cachedEntry);
                if (offset > 0L) {
                    is.skip(offset);
                }
                return is;
            }
        }
        catch (Throwable e) {
            Log.e((String)TAG, (String)("Uri:" + u), (Throwable)e);
        }
        return null;
    }

    public void closeStream(Closeable is) {
        if (is != null) {
            try {
                is.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ZipItemPropComparator
    implements Comparator<FileHeader> {
        int type;
        boolean case_ignore;
        boolean ascending;

        public ZipItemPropComparator(int type_, boolean case_ignore_, boolean ascending_) {
            this.type = type_;
            this.case_ignore = case_ignore_;
            this.ascending = ascending_;
        }

        @Override
        public int compare(FileHeader f1, FileHeader f2) {
            boolean f2IsDir;
            boolean f1IsDir = f1.isDirectory();
            if (f1IsDir != (f2IsDir = f2.isDirectory())) {
                return f1IsDir ? -1 : 1;
            }
            int ext_cmp = 0;
            switch (this.type) {
                case 48: {
                    ext_cmp = this.case_ignore ? Utils.getFileExt(f1.getFileName()).compareToIgnoreCase(Utils.getFileExt(f2.getFileName())) : Utils.getFileExt(f1.getFileName()).compareTo(Utils.getFileExt(f2.getFileName()));
                    break;
                }
                case 16: {
                    ext_cmp = f1.getUncompressedSize() - f2.getUncompressedSize() < 0L ? -1 : 1;
                    break;
                }
                case 32: {
                    int n = ext_cmp = f1.getLastModFileTime() - f2.getLastModFileTime() < 0 ? -1 : 1;
                }
            }
            if (ext_cmp == 0) {
                ext_cmp = this.case_ignore ? f1.getFileName().compareToIgnoreCase(f2.getFileName()) : f1.getFileName().compareTo(f2.getFileName());
            }
            return this.ascending ? ext_cmp : -ext_cmp;
        }
    }

    class RenameEngine
    extends ZipEngine {
        private FileHeader ren_entry;
        private String new_name;
        private boolean copy;

        RenameEngine(FileHeader ren_entry, String new_name, boolean copy) {
            this.copy = false;
            this.ren_entry = ren_entry;
            this.new_name = new_name;
            this.copy = copy;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            if (ZipAdapter.this.zip == null) {
                return;
            }
            this.sendProgress(ZipAdapter.this.ctx.getString(2131361916), 1, 1);
            ZipAdapter zipAdapter = ZipAdapter.this;
            synchronized (zipAdapter) {
                block11: {
                    block9: {
                        ZipAdapter.this.Init(null);
                        try {
                            try {
                                String inner_path = ZipAdapter.this.uri.getFragment();
                                if (Utils.str(inner_path)) {
                                    inner_path = Utils.mbAddSl(inner_path);
                                }
                                inner_path = inner_path != null ? inner_path + this.new_name : this.new_name;
                                ZipParameters parameters = new ZipParameters();
                                parameters.setCompressionMethod(8);
                                parameters.setCompressionLevel(7);
                                parameters.setFileNameInZip(inner_path);
                                parameters.setSourceExternalStream(true);
                                ZipInputStream zis = ZipAdapter.this.zip.getInputStream(this.ren_entry);
                                if (zis == null) {
                                    Log.e((String)this.TAG, (String)("Can't get input stream of " + this.ren_entry.getFileName()));
                                    this.sendResult(ZipAdapter.this.ctx.getString(2131361917));
                                    Object var6_6 = null;
                                    ZipAdapter.this.zip = null;
                                    return;
                                }
                                ZipAdapter.this.zip.addStream((InputStream)zis, parameters);
                                ZipAdapter.this.zip.removeFile(this.ren_entry);
                                if (!this.waitCompletion()) break block9;
                                this.sendResult(ZipAdapter.this.ctx.getString(2131361991));
                            }
                            catch (Exception e) {
                                this.error(e.getMessage());
                                Object var6_9 = null;
                                ZipAdapter.this.zip = null;
                                break block11;
                            }
                        }
                        catch (Throwable throwable) {
                            Object var6_10 = null;
                            ZipAdapter.this.zip = null;
                            throw throwable;
                        }
                        Object var6_7 = null;
                        ZipAdapter.this.zip = null;
                        return;
                    }
                    Object var6_8 = null;
                    ZipAdapter.this.zip = null;
                }
                this.sendResult(ZipAdapter.this.ctx.getString(2131361917));
                super.run();
                return;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class CopyToEngine
    extends ZipEngine {
        private File[] topList;
        private long totalSize;
        private int basePathLen;
        private File zipFile;
        private String destPath;
        private boolean newZip;
        private boolean move;
        private boolean del_src_dir;
        private String prep;

        CopyToEngine(File[] list, String dest_sub, int move_mode_) {
            this.totalSize = 0L;
            this.newZip = false;
            this.move = false;
            this.del_src_dir = false;
            this.topList = list;
            this.destPath = dest_sub != null ? (dest_sub.endsWith(CommanderAdapterBase.SLS) ? dest_sub : dest_sub + CommanderAdapterBase.SLS) : "";
            this.basePathLen = list.length > 0 ? list[0].getParent().length() + 1 : 0;
            this.move = (move_mode_ & 1) != 0;
            this.del_src_dir = (move_mode_ & 2) != 0;
        }

        CopyToEngine(File[] list, File zip_file) {
            this.totalSize = 0L;
            this.newZip = false;
            this.move = false;
            this.del_src_dir = false;
            this.topList = list;
            this.zipFile = zip_file;
            this.destPath = "";
            this.basePathLen = list.length > 0 ? list[0].getParent().length() + 1 : 0;
            this.newZip = true;
            this.prep = ZipAdapter.this.ctx.getString(2131361996);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            int num_files = 0;
            try {
                if (this.topList.length == 0) {
                    return;
                }
                this.sendProgress(this.prep, 1);
                ZipAdapter zipAdapter = ZipAdapter.this;
                synchronized (zipAdapter) {
                    File src_dir;
                    ZipAdapter.this.Init(null);
                    ArrayList<File> full_list = new ArrayList<File>(this.topList.length);
                    this.addToList(this.topList, full_list);
                    ZipParameters parameters = new ZipParameters();
                    parameters.setCompressionMethod(8);
                    parameters.setCompressionLevel(7);
                    parameters.setDefaultFolderPath(this.topList[0].getParent());
                    if (Utils.str(this.destPath) && !"/".equals(this.destPath)) {
                        parameters.setRootFolderInZip(this.destPath);
                    }
                    if (ZipAdapter.this.password != null) {
                        parameters.setEncryptFiles(true);
                        parameters.setEncryptionMethod(99);
                        parameters.setAesKeyStrength(3);
                        parameters.setPassword(ZipAdapter.this.password.toCharArray());
                    }
                    if (ZipAdapter.this.encoding != null) {
                        // empty if block
                    }
                    if (ZipAdapter.this.zip == null) {
                        ZipAdapter.this.zip = ZipAdapter.this.createZipFileInstance(ZipAdapter.this.uri);
                    }
                    ZipAdapter.this.zip.setRunInThread(true);
                    ZipAdapter.this.zip.addFiles(full_list, parameters);
                    if (!this.waitCompletion(2131362004)) {
                        this.sendResult(ZipAdapter.this.ctx.getString(2131361918));
                        return;
                    }
                    this.sendProgress(this.prep, 100);
                    ZipAdapter.this.zip.setRunInThread(false);
                    num_files = full_list.size();
                    if (this.del_src_dir && (src_dir = this.topList[0].getParentFile()) != null) {
                        src_dir.delete();
                    }
                }
            }
            catch (Exception e) {
                this.error("Exception: " + e.getMessage());
            }
            this.sendResult(Utils.getOpReport(ZipAdapter.this.ctx, num_files, 2131362029));
            super.run();
        }

        private final long addToList(File[] sub_list, ArrayList<File> full_list) {
            long total_size = 0L;
            try {
                for (int i = 0; i < sub_list.length; ++i) {
                    if (this.stop || this.isInterrupted()) {
                        this.errMsg = "Canceled";
                    } else {
                        File f = sub_list[i];
                        if (f == null || !f.exists()) continue;
                        if (f.isFile()) {
                            total_size += f.length();
                            full_list.add(f);
                            continue;
                        }
                        if (!f.isDirectory()) continue;
                        long dir_sz = this.addToList(f.listFiles(), full_list);
                        if (this.errMsg == null) {
                            if (dir_sz == 0L) {
                                full_list.add(f);
                                continue;
                            }
                            total_size += dir_sz;
                            continue;
                        }
                    }
                    break;
                }
            }
            catch (Exception e) {
                Log.e((String)this.TAG, (String)"addToList()", (Throwable)e);
                this.errMsg = "Exception: " + e.getMessage();
            }
            return total_size;
        }
    }

    class DelEngine
    extends EnumEngine {
        private String[] flat_names_to_delete;
        private FileHeader[] list;
        int tot_pp;

        DelEngine(FileHeader[] list) {
            this.flat_names_to_delete = null;
            this.tot_pp = 0;
            this.list = list;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            if (ZipAdapter.this.zip == null) {
                return;
            }
            this.sendProgress(ZipAdapter.this.ctx.getString(2131361916), 1, 1);
            ZipAdapter zipAdapter = ZipAdapter.this;
            synchronized (zipAdapter) {
                ZipAdapter.this.Init(null);
                try {
                    ZipAdapter.this.zip.setRunInThread(true);
                    int num_deleted = this.deleteFiles(this.list);
                    ZipAdapter.this.zip.setRunInThread(false);
                    ZipAdapter.this.zip = null;
                    this.sendResult(Utils.getOpReport(ZipAdapter.this.ctx, num_deleted, 2131362026));
                    return;
                }
                catch (Exception e) {
                    this.error(e.getMessage());
                    super.run();
                }
            }
        }

        private int deleteFiles(FileHeader[] to_delete) throws ZipException {
            int e_i = 0;
            int tot_i = 0;
            for (FileHeader h : to_delete) {
                int pp = e_i++ * 100 / to_delete.length;
                if (to_delete == this.list) {
                    this.tot_pp = pp;
                }
                this.sendProgress(h.getFileName(), this.tot_pp, pp);
                String fn = h.getFileName();
                if (!h.isDirectory() || ZipAdapter.this.zip.getFileHeader(fn) != null) {
                    ZipAdapter.this.zip.removeFile(h);
                    if (!this.waitCompletion(2131361999)) {
                        Log.e((String)this.TAG, (String)("Breaking on file " + fn));
                        break;
                    }
                    ++tot_i;
                    continue;
                }
                tot_i += this.deleteFiles(this.GetFolderList(fn));
                if (!this.noErrors()) break;
            }
            return tot_i;
        }
    }

    class CopyFromEngine
    extends EnumEngine {
        private File dest_folder;
        private FileHeader[] mList;
        private String base_pfx;
        private int base_len;
        private ArrayList<String> to_scan;

        CopyFromEngine(FileHeader[] list, File dest, Engines.IReciever recipient_) {
            this.mList = null;
            this.recipient = recipient_;
            this.mList = list;
            this.dest_folder = dest;
            try {
                this.base_pfx = ZipAdapter.this.uri.getFragment();
                if (this.base_pfx == null) {
                    this.base_pfx = "";
                }
                this.base_len = this.base_pfx.length();
                if (Build.VERSION.SDK_INT >= 11) {
                    this.to_scan = new ArrayList();
                }
            }
            catch (NullPointerException e) {
                Log.e((String)this.TAG, (String)"", (Throwable)e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            this.sendProgress(ZipAdapter.this.ctx.getString(2131361916), 0, 0);
            ZipAdapter zipAdapter = ZipAdapter.this;
            synchronized (zipAdapter) {
                ZipAdapter.this.zip.setRunInThread(true);
                int total = this.copyFiles(this.mList, "");
                ZipAdapter.this.zip.setRunInThread(false);
                if (!this.noErrors()) {
                    this.sendResult(ZipAdapter.this.ctx.getString(2131361918));
                    return;
                }
                if (this.recipient != null) {
                    this.sendReceiveReq(this.dest_folder);
                    return;
                }
                this.sendResult(Utils.getOpReport(ZipAdapter.this.ctx, total, 2131362030));
                if (this.to_scan != null && this.to_scan.size() > 0) {
                    String[] to_scan_a = new String[this.to_scan.size()];
                    this.to_scan.toArray(to_scan_a);
                    MediaScanEngine.scanMedia(ZipAdapter.this.ctx, to_scan_a);
                }
            }
            super.run();
        }

        private final int copyFiles(FileHeader[] list, String path) {
            int counter = 0;
            try {
                long dir_size = 0L;
                long byte_count = 0L;
                for (int i = 0; i < list.length; ++i) {
                    FileHeader f = list[i];
                    if (f.isDirectory()) continue;
                    dir_size += f.getUncompressedSize();
                }
                double conv = 100.0 / (double)dir_size;
                for (int i = 0; i < list.length; ++i) {
                    String entry_name_fixed;
                    FileHeader entry = list[i];
                    if (entry == null || (entry_name_fixed = ZipAdapter.this.fixName(entry)) == null) continue;
                    String file_path = path + new File(entry_name_fixed).getName();
                    File dest_file = new File(this.dest_folder, file_path);
                    String rel_name = entry_name_fixed.substring(this.base_len);
                    if (entry.isDirectory()) {
                        if (!(dest_file.mkdir() || dest_file.exists() && dest_file.isDirectory())) {
                            this.errMsg = "Can't create folder \"" + dest_file.getAbsolutePath() + "\"";
                            break;
                        }
                        FileHeader[] subItems = this.GetFolderList(entry_name_fixed);
                        if (subItems == null) {
                            this.errMsg = "Failed to get the file list of the subfolder '" + rel_name + "'.\n";
                            break;
                        }
                        counter += this.copyFiles(subItems, rel_name);
                        if (!this.noErrors()) {
                            break;
                        }
                    } else {
                        if (dest_file.exists()) {
                            int res = this.askOnFileExist(ZipAdapter.this.ctx.getString(2131362015, new Object[]{dest_file.getAbsolutePath()}), ZipAdapter.this.commander);
                            if (res == 1) break;
                            if (res == 4) continue;
                            if (res == 2 && !dest_file.delete()) {
                                this.error(ZipAdapter.this.ctx.getString(2131362022, new Object[]{dest_file.getAbsoluteFile()}));
                                break;
                            }
                        }
                        boolean n = false;
                        int so_far = (int)((double)byte_count * conv);
                        int fnl = rel_name.length();
                        ZipAdapter.this.zip.extractFile(entry, this.dest_folder.getAbsolutePath(), null, rel_name);
                        if (!this.waitCompletion(2131362002)) {
                            File dest_f = new File(this.dest_folder.getAbsolutePath(), entry.getFileName());
                            if (dest_f.exists()) {
                                dest_f.delete();
                            }
                            return counter;
                        }
                        if (this.to_scan != null) {
                            this.to_scan.add(dest_file.getAbsolutePath());
                        }
                    }
                    Utils.setFullPermissions(dest_file);
                    long entry_time = entry.getLastModFileTime();
                    if (entry_time > 0L) {
                        dest_file.setLastModified(entry_time);
                    }
                    if (this.stop || this.isInterrupted()) {
                        this.error(ZipAdapter.this.ctx.getString(2131362010));
                        break;
                    }
                    if (i >= list.length - 1) {
                        this.sendProgress(ZipAdapter.this.ctx.getString(2131362003, new Object[]{rel_name}), (int)((double)byte_count * conv));
                    }
                    ++counter;
                }
            }
            catch (Exception e) {
                Log.e((String)this.TAG, (String)"copyFiles()", (Throwable)e);
                this.error("Exception: " + e.getMessage());
            }
            return counter;
        }
    }

    class ExtractAllEngine
    extends ZipEngine {
        private File zipFile;
        private File destFolder;

        ExtractAllEngine(File zip_f, File dest) {
            this.zipFile = zip_f;
            this.destFolder = dest;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                this.sendProgress(ZipAdapter.this.ctx.getString(2131361916), 0, 0);
                ZipAdapter zipAdapter = ZipAdapter.this;
                synchronized (zipAdapter) {
                    if (ZipAdapter.this.zip == null) {
                        ZipAdapter.this.zip = new ZipFile(this.zipFile.getAbsolutePath());
                    }
                    ZipAdapter.this.zip.setRunInThread(true);
                    ZipAdapter.this.zip.extractAll(this.destFolder.getAbsolutePath());
                    this.waitCompletion(2131362002);
                    ZipAdapter.this.zip.setRunInThread(false);
                }
                if (!this.noErrors()) {
                    this.sendResult(ZipAdapter.this.ctx.getString(2131361918));
                    return;
                }
                this.sendResult(ZipAdapter.this.ctx.getString(2131362030, new Object[]{this.zipFile.getName()}));
                if (Build.VERSION.SDK_INT >= 11) {
                    SharedPreferences sp = PreferenceManager.getDefaultSharedPreferences((Context)ZipAdapter.this.ctx);
                    MediaScanEngine mse = new MediaScanEngine(ZipAdapter.this.ctx, this.destFolder, sp.getBoolean("scan_all", true), true);
                    mse.setHandler(this.thread_handler);
                    mse.run();
                }
            }
            catch (ZipException e) {
                Log.e((String)this.TAG, (String)("Can't extract " + this.zipFile.getAbsolutePath()));
            }
            super.run();
        }
    }

    class CalcSizesEngine
    extends EnumEngine {
        private FileHeader[] mList;
        private long totalSize;
        private long totalCompressed;
        private int dirs;

        CalcSizesEngine(FileHeader[] list) {
            this.mList = null;
            this.totalSize = 0L;
            this.totalCompressed = 0L;
            this.dirs = 0;
            this.mList = list;
        }

        public void run() {
            String name_fixed;
            FileHeader f;
            Context c = ZipAdapter.this.ctx;
            this.sendProgress(c.getString(2131361916), 0, 0);
            int num = this.calcSizes(this.mList);
            StringBuilder result = new StringBuilder(128);
            if (this.mList.length == 1) {
                f = this.mList[0];
                name_fixed = ZipAdapter.this.fixName(f);
                if (f.isDirectory()) {
                    result.append(c.getString(2131362044, new Object[]{name_fixed, num}));
                    if (this.dirs > 0) {
                        result.append(c.getString(2131362045, new Object[]{this.dirs, this.dirs > 1 ? c.getString(2131362047) : c.getString(2131362046)}));
                    }
                } else {
                    result.append(c.getString(2131362048, new Object[]{name_fixed}));
                }
            } else {
                result.append(c.getString(2131362049, new Object[]{num}));
            }
            if (this.totalSize > 0L) {
                result.append(c.getString(2131362050, new Object[]{Formatter.formatFileSize((Context)c, (long)this.totalSize).trim()}));
            }
            if (this.totalSize > 1024L) {
                result.append(c.getString(2131362051, new Object[]{this.totalSize}));
            }
            result.append("\n<b>Compressed: </b>");
            result.append(Formatter.formatFileSize((Context)c, (long)this.totalCompressed).trim());
            if (this.mList.length == 1) {
                f = this.mList[0];
                name_fixed = ZipAdapter.this.fixName(f);
                result.append(c.getString(2131362052));
                result.append("&#xA0;");
                String date_s = Utils.formatDate(new Date(Zip4jUtil.dosToJavaTme((int)f.getLastModFileTime())), c);
                result.append(date_s);
                if (!f.isDirectory()) {
                    String ext = Utils.getFileExt(name_fixed);
                    String mime = Utils.getMimeByExt(ext);
                    if (mime != null && !"*/*".equals(mime)) {
                        result.append("\n<b>MIME:</b>&#xA0;");
                        result.append(mime);
                    }
                    result.append("\n<b>CRC32:</b> ");
                    result.append(Long.toHexString(f.getCrc32()));
                    result.append("\n");
                    result.append(f.getFileComment());
                }
            }
            this.sendReport(result.toString());
        }

        private final int calcSizes(FileHeader[] list) {
            int counter = 0;
            try {
                for (int i = 0; i < list.length; ++i) {
                    FileHeader f = list[i];
                    String name_fixed = ZipAdapter.this.fixName(f);
                    if (f.isDirectory()) {
                        ++this.dirs;
                        FileHeader[] subItems = this.GetFolderList(name_fixed);
                        if (subItems == null) {
                            this.error("Failed to get the file list of the subfolder '" + name_fixed + "'.\n");
                            break;
                        }
                        counter += this.calcSizes(subItems);
                        continue;
                    }
                    this.totalSize += f.getUncompressedSize();
                    this.totalCompressed += f.getCompressedSize();
                    ++counter;
                }
            }
            catch (Exception e) {
                Log.e((String)this.TAG, (String)"", (Throwable)e);
                this.error(e.getMessage());
            }
            return counter;
        }
    }

    class ListEngine
    extends EnumEngine {
        private FileHeader[] items_tmp;
        public String pass_back_on_done;

        ListEngine(Handler h, String pass_back_on_done_) {
            super(h);
            this.items_tmp = null;
            this.pass_back_on_done = pass_back_on_done_;
        }

        public FileHeader[] getItems() {
            return this.items_tmp;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            block11: {
                block14: {
                    block13: {
                        block12: {
                            block10: {
                                try {
                                    try {
                                        Iterator iterator;
                                        ZipAdapter.this.setZipFile(ZipAdapter.this.createZipFileInstance(ZipAdapter.this.uri));
                                        if (ZipAdapter.this.zip.isEncrypted() && ZipAdapter.this.password == null) {
                                            this.sendLoginReq(ZipAdapter.this.uri.toString(), ZipAdapter.this.getCredentials(), this.pass_back_on_done, true);
                                            Object var6_1 = null;
                                            break block10;
                                        }
                                        if (ZipAdapter.this.zip == null) break block11;
                                        String cur_path = null;
                                        try {
                                            cur_path = ZipAdapter.this.uri.getFragment();
                                        }
                                        catch (NullPointerException e) {
                                            Log.e((String)this.TAG, (String)"uri.getFragment()", (Throwable)e);
                                        }
                                        List headers = null;
                                        headers = ZipAdapter.this.zip.getFileHeaders();
                                        if (headers == null) {
                                            this.sendProgress(ZipAdapter.this.ctx.getString(2131362218), -2, this.pass_back_on_done);
                                            break block12;
                                        }
                                        if (ZipAdapter.this.password != null && !ZipAdapter.this.password_validated && (iterator = headers.iterator()).hasNext()) {
                                            FileHeader fh = (FileHeader)iterator.next();
                                            if (!fh.isDirectory() && !this.isValid(fh)) {
                                                this.sendLoginReq(ZipAdapter.this.uri.toString(), ZipAdapter.this.getCredentials(), this.pass_back_on_done, true);
                                                break block13;
                                            }
                                            ZipAdapter.this.password_validated = true;
                                        }
                                        this.items_tmp = this.GetFolderList(cur_path);
                                        if (this.items_tmp == null) break block11;
                                        ZipItemPropComparator comp = new ZipItemPropComparator(ZipAdapter.this.mode & 0x30, (ZipAdapter.this.mode & 0x80) != 0, ZipAdapter.this.ascending);
                                        Arrays.sort(this.items_tmp, comp);
                                        this.sendProgress(null, -3, this.pass_back_on_done);
                                        break block14;
                                    }
                                    catch (Exception e) {
                                        Log.e((String)this.TAG, (String)ZipAdapter.this.uri.toString(), (Throwable)e);
                                        this.sendProgress(ZipAdapter.this.ctx.getString(2131362060), -2, this.pass_back_on_done);
                                        Object var6_6 = null;
                                        super.run();
                                        return;
                                    }
                                }
                                catch (Throwable throwable) {
                                    Object var6_7 = null;
                                    super.run();
                                    throw throwable;
                                }
                            }
                            super.run();
                            return;
                        }
                        Object var6_2 = null;
                        super.run();
                        return;
                    }
                    Object var6_3 = null;
                    super.run();
                    return;
                }
                Object var6_4 = null;
                super.run();
                return;
            }
            Object var6_5 = null;
            super.run();
            this.sendProgress(ZipAdapter.this.ctx.getString(2131362218), -2, this.pass_back_on_done);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class EnumEngine
    extends ZipEngine {
        protected EnumEngine() {
        }

        protected EnumEngine(Handler h) {
            super.setHandler(h);
        }

        protected final FileHeader[] GetFolderList(String fld_path) {
            if (ZipAdapter.this.zip == null) {
                return null;
            }
            List headers = null;
            try {
                headers = ZipAdapter.this.zip.getFileHeaders();
            }
            catch (ZipException e1) {
                Log.e((String)this.TAG, (String)("File: " + ZipAdapter.this.uri), (Throwable)e1);
            }
            if (headers == null) {
                return null;
            }
            return this.GetFolderList(fld_path, headers);
        }

        protected final FileHeader[] GetFolderList(String fld_path, List<FileHeader> headers) {
            if (headers == null) {
                return null;
            }
            if (fld_path == null) {
                fld_path = "";
            } else if (fld_path.length() > 0 && fld_path.charAt(0) == CommanderAdapterBase.SLC) {
                fld_path = fld_path.substring(1);
            }
            int fld_path_len = fld_path.length();
            if (fld_path_len > 0 && fld_path.charAt(fld_path_len - 1) != CommanderAdapterBase.SLC) {
                fld_path = fld_path + CommanderAdapterBase.SLC;
                ++fld_path_len;
            }
            ArrayList<FileHeader> array2 = new ArrayList<FileHeader>();
            for (FileHeader e : headers) {
                String entry_name;
                if (this.isStopReq()) {
                    return null;
                }
                if (e == null || (entry_name = ZipAdapter.this.fixName(e)) == null || fld_path.compareToIgnoreCase(entry_name) == 0 || !fld_path.regionMatches(true, 0, entry_name, 0, fld_path_len)) continue;
                int sl_pos = entry_name.indexOf(CommanderAdapterBase.SLC, fld_path_len);
                if (sl_pos > 0) {
                    String sub_dir = entry_name.substring(fld_path_len, sl_pos + 1);
                    int sub_dir_len = sub_dir.length();
                    boolean not_yet = true;
                    for (int i = 0; i < array2.size(); ++i) {
                        String a_name = ZipAdapter.this.fixName((FileHeader)array2.get(i));
                        if (!a_name.regionMatches(fld_path_len, sub_dir, 0, sub_dir_len)) continue;
                        not_yet = false;
                        break;
                    }
                    if (!not_yet) continue;
                    FileHeader sur_fld = new FileHeader();
                    sur_fld.setFileName(entry_name.substring(0, sl_pos + 1));
                    sur_fld.setDirectory(true);
                    array2.add(sur_fld);
                    continue;
                }
                array2.add(e);
            }
            return array2.toArray(new FileHeader[array2.size()]);
        }
    }

    class ZipEngine
    extends Engine {
        ZipEngine() {
        }

        protected synchronized boolean waitCompletion() {
            return this.waitCompletion(0);
        }

        protected synchronized boolean waitCompletion(int op_res_id) {
            try {
                ProgressMonitor pm = ZipAdapter.this.zip.getProgressMonitor();
                while (pm.getState() == 1) {
                    if (this.isStopReq()) {
                        pm.cancelAllTasks();
                        this.error(ZipAdapter.this.ctx.getString(2131362010));
                        return false;
                    }
                    String rep_str = op_res_id != 0 ? ZipAdapter.this.ctx.getString(op_res_id, new Object[]{pm.getFileName()}) : pm.getFileName();
                    this.sendProgress(rep_str, pm.getPercentDone(), 0);
                    this.wait(500L);
                }
                int res = pm.getResult();
                if (res == 0) {
                    return true;
                }
                if (res == 2) {
                    Throwable e = pm.getException();
                    if (e != null) {
                        String msg = e.getMessage();
                        if (msg != null) {
                            this.error(msg.replaceAll("^.+:", ""));
                        }
                        Log.e((String)this.TAG, (String)pm.getFileName(), (Throwable)e);
                    } else {
                        Log.e((String)this.TAG, (String)"zip error");
                    }
                }
            }
            catch (Exception e) {
                Log.e((String)this.TAG, (String)"zip exception!", (Throwable)e);
            }
            return false;
        }

        boolean isValid(FileHeader fh) {
            try {
                byte[] b;
                ZipInputStream is = null;
                if (fh == null) {
                    return false;
                }
                is = ZipAdapter.this.zip.getInputStream(fh);
                boolean ok = is.read(b = new byte[4096]) != -1;
                is.close(true);
                return ok;
            }
            catch (Exception e) {
                Log.w((String)this.TAG, (String)fh.getFileName(), (Throwable)e);
                return false;
            }
        }
    }
}

