/*
 * Decompiled with CFR 0.152.
 */
package com.ghostsq.commander.adapters;

import android.annotation.TargetApi;
import android.content.ContentResolver;
import android.content.ContentUris;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.res.Resources;
import android.database.Cursor;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Matrix;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Build;
import android.os.Handler;
import android.os.Message;
import android.provider.MediaStore;
import android.util.Log;
import android.util.SparseArray;
import com.ghostsq.commander.PictureViewer;
import com.ghostsq.commander.adapters.CommanderAdapter;
import com.ghostsq.commander.adapters.CommanderAdapterBase;
import com.ghostsq.commander.adapters.SAFAdapter;
import com.ghostsq.commander.utils.ImageInfo;
import com.ghostsq.commander.utils.MnfUtils;
import com.ghostsq.commander.utils.Utils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.SoftReference;

class ThumbnailsThread
extends Thread {
    private static final String TAG = "ThumbnailsThread";
    private static final int NOTIFY_THUMBNAIL_CHANGED = 653;
    private CommanderAdapterBase owner;
    private ContentResolver cr;
    private Handler thread_handler;
    private String base_path;
    private CommanderAdapter.Item[] list;
    private BitmapFactory.Options options;
    private Resources res;
    private byte[] buf;
    private int thumb_sz;
    private static final int apk_h = ".apk".hashCode();
    public static final SparseArray<Thumbnail> thumbnailCache = new SparseArray();

    ThumbnailsThread(CommanderAdapterBase owner, Handler thread_handler, String base_path, CommanderAdapter.Item[] list) {
        this.owner = owner;
        this.setName(this.getClass().getName());
        this.thread_handler = thread_handler;
        this.base_path = base_path;
        this.list = list;
        this.buf = new byte[102400];
        this.cr = owner.ctx.getContentResolver();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TargetApi(value=12)
    public void run() {
        try {
            if (this.list == null) {
                return;
            }
            this.setPriority(1);
            this.thumb_sz = this.owner.getImgWidth();
            this.options = new BitmapFactory.Options();
            this.res = this.owner.ctx.getResources();
            int fails_count = 0;
            boolean visible_only = this.list.length > 20;
            for (int a = 0; a < 2; ++a) {
                boolean succeeded = true;
                boolean need_update = false;
                boolean proc_visible = false;
                boolean proc_invisible = false;
                int processed = 0;
                for (int i = 0; i < this.list.length; ++i) {
                    String ext;
                    String fn;
                    visible_only = visible_only || fails_count > 1;
                    int n = -1;
                    while (true) {
                        for (int j = 0; j < this.list.length; ++j) {
                            if (this.list[j].need_thumb) {
                                n = j;
                                proc_visible = true;
                                break;
                            }
                            this.list[j].remThumbnailIfOld(visible_only ? 10000 : 60000);
                        }
                        if (!visible_only || proc_visible) break;
                        CommanderAdapterBase j = this.owner;
                        synchronized (j) {
                            this.owner.wait();
                        }
                    }
                    boolean bl = proc_invisible = n < 0;
                    if (proc_invisible) {
                        n = i;
                    } else {
                        --i;
                    }
                    if (!proc_visible) {
                        ThumbnailsThread.yield();
                        ThumbnailsThread.sleep(10L);
                    }
                    CommanderAdapter.Item f = this.list[n];
                    f.need_thumb = false;
                    if (f.dir) {
                        f.no_thumb = true;
                        continue;
                    }
                    if (f.isThumbNail()) continue;
                    if (f.name.indexOf(47) >= 0) {
                        fn = f.name;
                    } else if (Utils.str(this.base_path)) {
                        fn = Utils.mbAddSl(this.base_path) + f.name;
                    } else {
                        if (!(f.origin instanceof File)) continue;
                        fn = ((File)f.origin).getAbsolutePath();
                    }
                    if (!new File(fn).exists()) continue;
                    int fn_h = (fn + " " + f.size).hashCode();
                    Thumbnail cached = null;
                    SparseArray<Thumbnail> sparseArray = thumbnailCache;
                    synchronized (sparseArray) {
                        cached = (Thumbnail)thumbnailCache.get(fn_h);
                    }
                    if (cached != null) {
                        f.setThumbNail(cached.getDrawable());
                        f.attr = cached.getResInfo();
                    }
                    if ((ext = Utils.getFileExt(fn)) == null) continue;
                    if (ext.equals(".apk")) {
                        f.thumb_is_icon = true;
                    }
                    if (!f.isThumbNail()) {
                        Thumbnail t = null;
                        if (ext.equals(".apk")) {
                            t = this.getApkIcon(fn);
                        } else {
                            String type_cat = Utils.getCategoryByExt(ext);
                            if ("i".equals(type_cat)) {
                                t = this.createImageThumbnail(fn, f);
                            } else if ("v".equals(type_cat)) {
                                t = this.createVideoThumbnail(fn, f);
                                if (t == null) {
                                    f.no_thumb = true;
                                }
                            } else {
                                f.no_thumb = true;
                                f.setThumbNail(null);
                                continue;
                            }
                        }
                        if (t != null) {
                            f.setThumbNail((Drawable)t.srd.get());
                            f.attr = t.getResInfo();
                            SparseArray<Thumbnail> sparseArray2 = thumbnailCache;
                            synchronized (sparseArray2) {
                                thumbnailCache.put(fn_h, (Object)t);
                            }
                        } else {
                            succeeded = false;
                            if (fails_count++ > 10) {
                                Log.w((String)TAG, (String)"To many fails, giving up");
                                return;
                            }
                        }
                    }
                    need_update = true;
                    if (!f.isThumbNail() || processed++ <= 3 && (!proc_visible || !proc_invisible)) continue;
                    Message msg = this.thread_handler.obtainMessage(653);
                    msg.sendToTarget();
                    ThumbnailsThread.yield();
                    proc_visible = false;
                    need_update = false;
                    processed = 0;
                }
                if (need_update) {
                    Message msg = this.thread_handler.obtainMessage(653);
                    msg.sendToTarget();
                }
                if (!succeeded) {
                    continue;
                }
                break;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final Thumbnail createImageThumbnail(String fn, CommanderAdapter.Item f) {
        String func_name = "createImageThubnail()";
        int img_w = 0;
        int img_h = 0;
        FileInputStream fis = null;
        try {
            block60: {
                Cursor cursor = null;
                try {
                    long orig_id = -1L;
                    String[] th_proj = new String[]{"_id", "width", "height"};
                    if (f.origin instanceof Uri) {
                        try {
                            Uri u = (Uri)f.origin;
                            if (!SAFAdapter.isExternalStorageDocument(u)) {
                                orig_id = ContentUris.parseId((Uri)u);
                            }
                        }
                        catch (Exception u) {}
                    } else {
                        String where;
                        boolean SDK16UP = Build.VERSION.SDK_INT >= 16;
                        String[] id_proj = new String[]{"_id"};
                        String[] proj = SDK16UP ? th_proj : id_proj;
                        cursor = this.cr.query(MediaStore.Images.Media.EXTERNAL_CONTENT_URI, proj, where = "_data = '" + fn + "'", null, null);
                        if (cursor != null) {
                            if (cursor.getCount() > 0) {
                                cursor.moveToPosition(0);
                                orig_id = cursor.getLong(0);
                                if (SDK16UP) {
                                    img_w = cursor.getInt(1);
                                    img_h = cursor.getInt(2);
                                }
                            }
                            cursor.close();
                            cursor = null;
                        }
                    }
                    if (orig_id >= 0L) {
                        cursor = MediaStore.Images.Thumbnails.queryMiniThumbnail((ContentResolver)this.cr, (long)orig_id, (int)3, (String[])th_proj);
                        if (cursor != null && cursor.getCount() == 0) {
                            cursor.close();
                            cursor = null;
                        }
                        if (cursor == null) {
                            cursor = MediaStore.Images.Thumbnails.queryMiniThumbnail((ContentResolver)this.cr, (long)orig_id, (int)1, (String[])th_proj);
                        }
                    }
                    if (cursor == null) break block60;
                    if (cursor.getCount() > 0) {
                        cursor.moveToPosition(0);
                        long th_id = cursor.getLong(0);
                        Uri tcu = ContentUris.withAppendedId((Uri)MediaStore.Images.Thumbnails.EXTERNAL_CONTENT_URI, (long)th_id);
                        int tw = cursor.getInt(1);
                        int th = cursor.getInt(2);
                        InputStream in = null;
                        try {
                            in = this.cr.openInputStream(tcu);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        if (in != null) {
                            this.options.inSampleSize = tw > 0 && th > 0 ? this.getSampleSize(Math.max(tw, th)) : 4;
                            this.options.inJustDecodeBounds = false;
                            this.options.inTempStorage = this.buf;
                            Bitmap bitmap = BitmapFactory.decodeStream((InputStream)in, null, (BitmapFactory.Options)this.options);
                            if (bitmap != null) {
                                if (Build.VERSION.SDK_INT >= 5) {
                                    Bitmap rbmp;
                                    float degrees = ImageInfo.getImageFileOrientationDegree(fn);
                                    Log.d((String)TAG, (String)("Rotating " + degrees));
                                    if (degrees > 0.0f && (rbmp = PictureViewer.rotateBitmap(bitmap, degrees)) != null) {
                                        bitmap = rbmp;
                                    }
                                }
                                BitmapDrawable drawable2 = new BitmapDrawable(this.res, bitmap);
                                Thumbnail thb = new Thumbnail((Drawable)drawable2, img_w, img_h);
                                f.setThumbNail((Drawable)drawable2);
                                in.close();
                                Thumbnail thumbnail = thb;
                                return thumbnail;
                            }
                        }
                    }
                    cursor.close();
                    cursor = null;
                }
                catch (Exception e) {
                    Log.e((String)TAG, (String)fn, (Throwable)e);
                }
                finally {
                    if (cursor != null) {
                        cursor.close();
                    }
                }
            }
            this.options.inSampleSize = 1;
            this.options.inJustDecodeBounds = true;
            this.options.outWidth = 0;
            this.options.outHeight = 0;
            this.options.inTempStorage = this.buf;
            fis = new FileInputStream(fn);
            BitmapFactory.decodeStream((InputStream)fis, null, (BitmapFactory.Options)this.options);
            img_w = this.options.outWidth;
            img_h = this.options.outHeight;
            if (img_w > 0 && img_h > 0) {
                this.options.inSampleSize = this.getSampleSize(Math.max(this.options.outWidth, this.options.outHeight));
                this.options.inJustDecodeBounds = false;
                Bitmap bitmap = BitmapFactory.decodeFile((String)fn, (BitmapFactory.Options)this.options);
                if (bitmap != null) {
                    Bitmap rbmp;
                    float degrees;
                    if (Build.VERSION.SDK_INT >= 5 && (degrees = ImageInfo.getImageFileOrientationDegree(fn)) > 0.0f && (rbmp = PictureViewer.rotateBitmap(bitmap, degrees)) != null) {
                        bitmap = rbmp;
                    }
                    BitmapDrawable drawable3 = new BitmapDrawable(this.res, bitmap);
                    Thumbnail thb = new Thumbnail((Drawable)drawable3, img_w, img_h);
                    f.setThumbNail((Drawable)drawable3);
                    Thumbnail thumbnail = thb;
                    return thumbnail;
                }
            } else {
                Log.w((String)TAG, (String)"failed to get an image bounds");
            }
            fis.close();
            Log.e((String)TAG, (String)("createImageThubnail() failed for " + fn));
            return null;
        }
        catch (RuntimeException rte) {
            Log.e((String)TAG, (String)"createImageThubnail()", (Throwable)rte);
            return null;
        }
        catch (FileNotFoundException fne) {
            Log.e((String)TAG, (String)"createImageThubnail()", (Throwable)fne);
            return null;
        }
        catch (IOException ioe) {
            Log.e((String)TAG, (String)"createImageThubnail()", (Throwable)ioe);
            return null;
        }
        catch (Error err) {
            Log.e((String)TAG, (String)"createImageThubnail()", (Throwable)err);
            return null;
        }
        finally {
            try {
                if (fis != null) {
                    fis.close();
                }
            }
            catch (IOException rte) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Thumbnail createVideoThumbnail(String fn, CommanderAdapter.Item f) {
        if (Build.VERSION.SDK_INT < 5) {
            return null;
        }
        Cursor cursor = null;
        try {
            long orig_id = -1L;
            if (f.origin instanceof Uri) {
                try {
                    Uri u = (Uri)f.origin;
                    if (!SAFAdapter.isExternalStorageDocument(u)) {
                        orig_id = ContentUris.parseId((Uri)u);
                    }
                }
                catch (Exception u) {}
            } else {
                String[] id_proj = new String[]{"_id"};
                String where = "_data = '" + fn + "'";
                cursor = this.cr.query(MediaStore.Video.Media.EXTERNAL_CONTENT_URI, id_proj, where, null, null);
                if (cursor != null) {
                    if (cursor.getCount() > 0) {
                        cursor.moveToPosition(0);
                        orig_id = cursor.getLong(0);
                    }
                    cursor.close();
                    cursor = null;
                }
            }
            if (orig_id >= 0L) {
                int ss = this.getSampleSize(512);
                Bitmap vtb = ImageInfo.getVideoThumbnail(this.cr, orig_id, ss);
                BitmapDrawable drawable2 = new BitmapDrawable(this.res, vtb);
                Thumbnail thb = new Thumbnail((Drawable)drawable2, 0, 0);
                f.setThumbNail((Drawable)drawable2);
                Thumbnail thumbnail = thb;
                return thumbnail;
            }
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"", (Throwable)e);
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
        if (Build.VERSION.SDK_INT < 8) {
            return null;
        }
        try {
            Bitmap vtb = ImageInfo.createVideoThumbnail(fn);
            int scale = this.getSampleSize(512);
            if (scale > 1) {
                vtb = ThumbnailsThread.scaleBitmap(vtb, 1.0f / (float)scale);
            }
            BitmapDrawable drawable3 = new BitmapDrawable(this.res, vtb);
            Thumbnail thb = new Thumbnail((Drawable)drawable3, 0, 0);
            f.setThumbNail((Drawable)drawable3);
            return thb;
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"", (Throwable)e);
            return null;
        }
    }

    private final Thumbnail getApkIcon(String fn) {
        try {
            Drawable icon = null;
            PackageManager pm = this.owner.ctx.getPackageManager();
            PackageInfo info = pm.getPackageArchiveInfo(fn, 0);
            if (info != null) {
                try {
                    icon = pm.getApplicationIcon(info.packageName);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (icon != null) {
                    return new Thumbnail(icon);
                }
            }
            try {
                PackageInfo packageInfo = this.owner.ctx.getPackageManager().getPackageArchiveInfo(fn, 1);
                if (packageInfo != null) {
                    ApplicationInfo appInfo = packageInfo.applicationInfo;
                    if (Build.VERSION.SDK_INT >= 8) {
                        appInfo.sourceDir = fn;
                        appInfo.publicSourceDir = fn;
                    }
                    icon = appInfo.loadIcon(this.owner.ctx.getPackageManager());
                }
            }
            catch (Exception e) {
                Log.e((String)TAG, (String)("File: " + fn), (Throwable)e);
            }
            if (icon != null) {
                return new Thumbnail(icon);
            }
            MnfUtils mnfu = new MnfUtils(fn);
            icon = mnfu.extractIcon();
            if (icon != null) {
                return new Thumbnail(icon);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private final int getSampleSize(int greatest) {
        int b;
        int factor = greatest / this.thumb_sz;
        for (b = 0x8000000; b > 0 && b >= factor; b >>= 1) {
        }
        return b;
    }

    private static Bitmap scaleBitmap(Bitmap old_bmp, float scale) {
        if (old_bmp == null) {
            Log.e((String)TAG, (String)"old_bmp is null");
            return null;
        }
        Matrix m = new Matrix();
        m.postScale(scale, scale);
        try {
            Bitmap new_bmp = Bitmap.createBitmap((Bitmap)old_bmp, (int)0, (int)0, (int)old_bmp.getWidth(), (int)old_bmp.getHeight(), (Matrix)m, (boolean)false);
            if (new_bmp != null) {
                old_bmp.recycle();
                return new_bmp;
            }
        }
        catch (OutOfMemoryError outOfMemoryError) {
            // empty catch block
        }
        return null;
    }

    private class Thumbnail {
        private SoftReference<Drawable> srd;
        private int h;
        private int w;

        Thumbnail(Drawable d) {
            this(d, 0, 0);
        }

        Thumbnail(Drawable d, int w, int h) {
            this.srd = new SoftReference<Drawable>(d);
            this.h = h;
            this.w = w;
        }

        public final String getResInfo() {
            return this.h == 0 ? null : "" + this.w + "x" + this.h;
        }

        public Drawable getDrawable() {
            Drawable d = this.srd.get();
            return d;
        }
    }
}

