/*
 * Decompiled with CFR 0.152.
 */
package com.ghostsq.commander.adapters;

import android.annotation.TargetApi;
import android.content.ContentResolver;
import android.content.Context;
import android.database.Cursor;
import android.media.MediaScannerConnection;
import android.net.Uri;
import android.provider.MediaStore;
import android.util.Log;
import com.ghostsq.commander.adapters.Engine;
import com.ghostsq.commander.utils.Utils;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@TargetApi(value=11)
public class MediaScanEngine
extends Engine
implements MediaScannerConnection.MediaScannerConnectionClient {
    private static final String TAG = "MediaScanEngine";
    private MediaScannerConnection msc;
    private Context ctx;
    private ContentResolver cr;
    private File folder;
    private boolean all = false;
    private boolean rec = true;
    private FileItem[] to_scan_a;
    private int count = 0;
    private int num = 0;

    public MediaScanEngine(Context ctx, File folder, boolean all, boolean rec) {
        this.ctx = ctx;
        this.folder = folder;
        this.all = all;
        this.rec = rec;
        this.cr = ctx.getContentResolver();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.sendProgress("", 0, -1);
        this.deleteMissedEntries(this.folder.getAbsolutePath());
        ArrayList<FileItem> to_scan = new ArrayList<FileItem>();
        this.collectFiles(this.folder, to_scan, 0);
        this.num = to_scan.size();
        if (this.num > 0) {
            this.to_scan_a = new FileItem[this.num];
            to_scan.toArray(this.to_scan_a);
            this.msc = new MediaScannerConnection(this.ctx, (MediaScannerConnection.MediaScannerConnectionClient)this);
            this.msc.connect();
            MediaScanEngine mediaScanEngine = this;
            synchronized (mediaScanEngine) {
                while (!this.stop) {
                    try {
                        this.wait(1000L);
                    }
                    catch (InterruptedException e) {
                        this.stop = true;
                    }
                }
            }
            this.sendReport(this.count + " files were scanned");
        }
    }

    private void deleteMissedEntries(String dir) {
        String[] selectionParams;
        String selection;
        String[] projection;
        Uri ec_uri = MediaStore.Files.getContentUri((String)"external");
        Cursor cursor = this.cr.query(ec_uri, projection = new String[]{"_id", "_data", "date_modified", "mime_type", "_size", "title"}, selection = "_data like ? ", selectionParams = new String[]{dir + "%"}, null);
        if (cursor == null) {
            return;
        }
        int num = cursor.getCount();
        if (num <= 0) {
            return;
        }
        int count = 0;
        int ici = cursor.getColumnIndex("_id");
        int pci = cursor.getColumnIndex("_data");
        cursor.moveToFirst();
        do {
            ++count;
            String path = null;
            Uri e_uri = null;
            try {
                path = cursor.getString(pci);
                if (!Utils.str(path)) continue;
                File f = new File(path);
                if (!this.rec && !f.getParentFile().equals(this.folder) || f.exists() || (e_uri = MediaStore.Files.getContentUri((String)"external", (long)cursor.getLong(ici))) == null) continue;
                String rep = this.ctx.getString(2131361999, new Object[]{f.getName()});
                this.sendProgress(rep, count * 100 / num);
                this.cr.delete(e_uri, null, null);
            }
            catch (Exception e) {
                Log.e((String)TAG, (String)("Can't delete content entry " + e_uri + ", file: " + path));
            }
        } while (cursor.moveToNext());
        cursor.close();
    }

    private void collectFiles(File folder, List<FileItem> to_scan, int lvl) {
        if (folder == null) {
            return;
        }
        File[] files = folder.listFiles();
        if (files == null) {
            return;
        }
        int num = files.length;
        for (int fi = 0; fi < num; ++fi) {
            File f = files[fi];
            if (f == null) continue;
            try {
                if (f.isDirectory()) {
                    if (this.rec) {
                        this.collectFiles(f, to_scan, lvl + 1);
                    }
                } else {
                    String fn = f.getName();
                    if (".nomedia".equals(fn)) continue;
                    String ext = Utils.getFileExt(fn);
                    String mime = Utils.getMimeByExt(ext);
                    if (this.all || mime != null && (mime.startsWith("image/") || mime.startsWith("audio/") || mime.startsWith("video/") || mime.equals("application/x-mpegurl"))) {
                        to_scan.add(new FileItem(f.getAbsolutePath(), mime));
                    }
                }
                if (lvl != 0) continue;
                this.sendProgress(f.getName(), fi * 100 / num);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private final boolean scanNextFile() {
        if (this.count < this.num) {
            FileItem fi = this.to_scan_a[this.count++];
            this.msc.scanFile(fi.path, fi.mime);
            return true;
        }
        return false;
    }

    public void onMediaScannerConnected() {
        this.scanNextFile();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onScanCompleted(String path, Uri uri) {
        if (uri == null) {
            Log.w((String)TAG, (String)("Uri is null for " + path));
        } else {
            this.sendProgress(path, this.count * 100 / this.num);
            File f = new File(path);
            if (f.isFile() && f.length() == 0L && this.cr.delete(uri, null, null) > 0) {
                Log.w((String)"scanMedia()", (String)("Deleteing " + path));
                f.delete();
            }
        }
        if (this.stop || !this.scanNextFile()) {
            this.msc.disconnect();
            MediaScanEngine mediaScanEngine = this;
            synchronized (mediaScanEngine) {
                this.stop = true;
                this.notify();
            }
            return;
        }
    }

    public static void scanMedia(final Context ctx, String[] to_scan_a) {
        MediaScannerConnection.scanFile((Context)ctx, (String[])to_scan_a, null, (MediaScannerConnection.OnScanCompletedListener)new MediaScannerConnection.OnScanCompletedListener(){

            public void onScanCompleted(String path, Uri uri) {
                File f = new File(path);
                if (f.isFile() && f.length() == 0L && ctx.getContentResolver().delete(uri, null, null) > 0) {
                    Log.w((String)"scanMedia()", (String)("Deleteing " + path));
                    f.delete();
                }
            }
        });
    }

    class FileItem {
        public String path;
        public String mime;

        FileItem(String path, String mime) {
            this.path = path;
            this.mime = mime;
        }
    }
}

