/*
 * Decompiled with CFR 0.152.
 */
package com.ghostsq.commander.adapters;

import android.content.Context;
import android.net.Uri;
import android.os.Handler;
import android.os.Message;
import android.text.format.DateFormat;
import android.util.Log;
import android.util.SparseBooleanArray;
import com.ghostsq.commander.Commander;
import com.ghostsq.commander.adapters.CommanderAdapter;
import com.ghostsq.commander.adapters.CommanderAdapterBase;
import com.ghostsq.commander.adapters.Engine;
import com.ghostsq.commander.adapters.FSAdapter;
import com.ghostsq.commander.adapters.FileItem;
import com.ghostsq.commander.utils.Utils;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;

public class FindAdapter
extends FSAdapter {
    public static final String TAG = "FindAdapter";
    private Uri uri;

    public FindAdapter(Context ctx_) {
        super(ctx_);
        this.parentLink = "..";
    }

    public void Init(Commander c) {
        super.Init(c);
        if (c != null) {
            this.readerHandler = new SearchHandler();
        }
    }

    public String getScheme() {
        return "find";
    }

    public boolean hasFeature(CommanderAdapter.Feature feature) {
        switch (feature) {
            case LOCAL: 
            case SZ: 
            case SEARCH: 
            case SEND: {
                return true;
            }
        }
        return super.hasFeature(feature);
    }

    public int setMode(int mask, int mode_) {
        return super.setMode(mask, mode_ &= 0xFFFFFFFE);
    }

    public boolean readSource(Uri uri_, String pass_back_on_done) {
        block12: {
            try {
                String olo_s;
                boolean files;
                if (this.reader != null) {
                    this.reader.reqStop();
                }
                if (uri_ != null) {
                    this.uri = uri_;
                }
                if (this.uri == null) {
                    return false;
                }
                if (this.uri.getScheme().compareTo("find") != 0) break block12;
                String path = this.uri.getPath();
                String match = this.uri.getQueryParameter("q");
                if (path == null || path.length() <= 0 || match == null || match.length() <= 0) break block12;
                this.notify(-1);
                SearchEngine se = new SearchEngine(this.readerHandler, match, path, pass_back_on_done);
                this.reader = se;
                String dirs_s = this.uri.getQueryParameter("d");
                String files_s = this.uri.getQueryParameter("f");
                boolean dirs = dirs_s != null && "1".equals(dirs_s);
                boolean bl = files = files_s != null && "1".equals(files_s);
                if (dirs != files) {
                    se.setTypes(files);
                }
                if ((olo_s = this.uri.getQueryParameter("o")) != null && "1".equals(olo_s)) {
                    se.olo = true;
                }
                se.content = this.uri.getQueryParameter("c");
                se.larger_than = Utils.parseHumanSize(this.uri.getQueryParameter("l"));
                long st = Utils.parseHumanSize(this.uri.getQueryParameter("s"));
                if (st > 0L) {
                    se.smaller_than = st;
                }
                java.text.DateFormat df = DateFormat.getDateFormat((Context)this.ctx);
                try {
                    se.after_date = df.parse(this.uri.getQueryParameter("a"));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    se.before_date = df.parse(this.uri.getQueryParameter("b"));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.commander.startEngine(this.reader);
                return true;
            }
            catch (Exception e) {
                Log.e((String)TAG, (String)"FindAdapter.readSource() exception: ", (Throwable)e);
            }
        }
        Log.e((String)TAG, (String)("FindAdapter unable to read by the URI '" + (this.uri == null ? "null" : this.uri.toString()) + "'"));
        this.uri = null;
        return false;
    }

    public void openItem(int position) {
        if (position == 0) {
            if (this.uri != null) {
                this.commander.Navigate(Uri.parse((String)this.uri.getPath()), null, null);
            }
            return;
        }
        super.openItem(position);
    }

    public boolean copyItems(SparseBooleanArray cis, CommanderAdapter to, boolean move) {
        return to.receiveItems(this.bitsToNames(cis), move ? 1 : 0);
    }

    public boolean createFile(String fileURI) {
        this.commander.showError(this.ctx.getString(2131362057));
        return false;
    }

    public void createFolder(String string2) {
        this.commander.showError(this.ctx.getString(2131362057));
    }

    public Uri getUri() {
        return this.uri;
    }

    public String toString() {
        return this.uri != null ? Uri.decode((String)this.uri.toString()) : "";
    }

    public boolean receiveItems(String[] fileURIs, int move_mode) {
        this.notify(this.ctx.getString(2131362057), -2);
        return false;
    }

    protected void onReadComplete() {
        this.onFileFound();
        this.startThumbnailCreation();
    }

    protected void onFileFound() {
        try {
            if (this.reader instanceof SearchEngine) {
                SearchEngine list_engine = (SearchEngine)this.reader;
                this.items = list_engine.getItems(this.mode);
                this.numItems = this.items != null ? this.items.length + 1 : 1;
                this.notifyDataSetChanged();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Object getItem(int position) {
        try {
            Object o = super.getItem(position);
            if (o != null) {
                if (o instanceof FileItem) {
                    FileItem fi = (FileItem)o;
                    fi.name = fi.f().getAbsolutePath();
                }
                return o;
            }
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"getItem() Exception");
        }
        return null;
    }

    class SearchEngine
    extends Engine {
        private String[] cards;
        private String path;
        private int depth = 0;
        private String pass_back_on_done;
        public String match;
        public String content;
        public boolean olo = false;
        public long larger_than;
        public long smaller_than;
        public Date after_date;
        public Date before_date;
        private boolean dirs = true;
        private boolean files = true;
        private ArrayList<File> result;
        private int progress = 0;
        private long progress_last_sent = System.currentTimeMillis();

        SearchEngine(Handler h, String match_, String path_, String pass_back_on_done_) {
            super.setHandler(h);
            if (match_.indexOf(42) >= 0) {
                this.cards = Utils.prepareWildcard(match_);
                this.match = null;
            } else {
                this.cards = null;
                this.match = match_.toLowerCase();
            }
            this.path = path_;
            this.pass_back_on_done = pass_back_on_done_;
            this.larger_than = 0L;
            this.smaller_than = Long.MAX_VALUE;
        }

        final void setTypes(boolean files_only) {
            if (files_only) {
                this.files = true;
                this.dirs = false;
            } else {
                this.files = false;
                this.dirs = true;
            }
        }

        public void setHandler(Handler h) {
        }

        public void run() {
            try {
                this.setEngineName(null);
                FindAdapter.this.Init(null);
                this.result = new ArrayList();
                this.searchInFolder(new File(this.path));
                this.sendProgress(this.tooLong(8) ? FindAdapter.this.ctx.getString(2131361990) : null, -3, this.pass_back_on_done);
            }
            catch (Exception e) {
                this.sendProgress(e.getMessage(), -2, this.pass_back_on_done);
            }
        }

        protected final void searchInFolder(File dir) throws Exception {
            try {
                String dir_path = dir.getAbsolutePath();
                long cur_time = System.currentTimeMillis();
                if (cur_time - this.progress_last_sent > 500L) {
                    this.progress_last_sent = cur_time;
                    this.progress = 0;
                    this.sendProgress(dir_path, 0);
                }
                if (dir_path.compareTo("/sys") == 0) {
                    return;
                }
                if (dir_path.compareTo("/dev") == 0) {
                    return;
                }
                if (dir_path.compareTo("/proc") == 0) {
                    return;
                }
                File[] subfiles = dir.listFiles();
                if (subfiles == null || subfiles.length == 0) {
                    return;
                }
                double conv = 100.0 / (double)subfiles.length;
                for (int i = 0; i < subfiles.length; ++i) {
                    SearchEngine.sleep(1L);
                    if (this.stop || this.isInterrupted()) {
                        throw new Exception(FindAdapter.this.ctx.getString(2131361992));
                    }
                    File f = subfiles[i];
                    int np = (int)((double)i * conv);
                    if ((double)np - conv + 1.0 > (double)this.progress && (cur_time = System.currentTimeMillis()) - this.progress_last_sent > 1000L) {
                        this.progress_last_sent = cur_time;
                        this.progress = np;
                        this.sendProgress(f.getAbsolutePath(), this.progress);
                    }
                    this.addIfMatched(f);
                    if (!this.olo && f.isDirectory()) {
                        if (this.depth++ > 30) {
                            throw new Exception(FindAdapter.this.ctx.getString(2131361994));
                        }
                        this.searchInFolder(f);
                        --this.depth;
                    }
                    if (!this.isStopReq()) continue;
                    return;
                }
            }
            catch (Exception e) {
                Log.e((String)this.TAG, (String)"Exception on search: ", (Throwable)e);
            }
        }

        private final void addIfMatched(File f) {
            if (f == null) {
                return;
            }
            try {
                boolean dir = f.isDirectory();
                if (dir ? !this.dirs : !this.files) {
                    return;
                }
                long modified = f.lastModified();
                if (this.after_date != null && modified < this.after_date.getTime()) {
                    return;
                }
                if (this.before_date != null && modified > this.before_date.getTime()) {
                    return;
                }
                long size = f.length();
                if (size < this.larger_than || size > this.smaller_than) {
                    return;
                }
                if (this.cards != null && !Utils.match(f.getName(), this.cards)) {
                    return;
                }
                if (this.match != null && !f.getName().toLowerCase().contains(this.match)) {
                    return;
                }
                if (this.content != null && !dir && !this.searchInsideFile(f, this.content)) {
                    return;
                }
                this.result.add(f);
            }
            catch (Exception e) {
                Log.e((String)this.TAG, (String)f.getName(), (Throwable)e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private final boolean searchInsideFile(File f, String s) {
            block26: {
                block20: {
                    block25: {
                        block19: {
                            block24: {
                                block18: {
                                    block23: {
                                        block17: {
                                            start_time = System.currentTimeMillis();
                                            fis = null;
                                            try {
                                                try {
                                                    bb = s.getBytes();
                                                    l = s.length();
                                                    fl = f.length();
                                                    conv = 100.0 / (double)fl;
                                                    fis = new FileInputStream(f);
                                                    bis = new BufferedInputStream(fis);
                                                    cnt = 0;
                                                    p = 0;
                                                    do {
                                                        if ((ch = bis.read()) == -1) {
                                                            var16_14 = false;
                                                            var20_19 = null;
                                                            break block17;
                                                        }
                                                        if (ch == bb[0]) {
                                                            bis.mark(l);
                                                            for (i = 1; i < l; ++i) {
                                                                ch = bis.read();
                                                                if (ch == -1) {
                                                                    var17_16 = false;
                                                                    break block18;
                                                                }
                                                                if (ch != bb[i]) {
                                                                    bis.reset();
                                                                    break;
                                                                }
                                                                if (i < l - 1) continue;
                                                                var17_17 = true;
                                                                break block19;
                                                            }
                                                        }
                                                        if ((np = (int)((double)cnt++ * conv)) - 10 <= p || (cur_time = System.currentTimeMillis()) - this.progress_last_sent <= 1000L) continue;
                                                        this.progress_last_sent = cur_time;
                                                        p = np;
                                                        this.sendProgress(f.getAbsolutePath(), this.progress, p);
                                                    } while (!this.isStopReq());
                                                    var17_18 = false;
                                                    break block20;
                                                }
                                                catch (Exception e) {
                                                    Log.e((String)this.TAG, (String)("File: " + f.getName() + ", str=" + s), (Throwable)e);
                                                    var20_23 = null;
                                                    try {
                                                        fis.close();
                                                    }
                                                    catch (IOException var21_29) {
                                                        // empty catch block
                                                    }
                                                    Log.d((String)this.TAG, (String)("Elapsed time: " + (System.currentTimeMillis() - start_time) + "ms"));
                                                    return false;
                                                }
                                            }
                                            catch (Throwable var19_31) {
                                                block22: {
                                                    var20_24 = null;
                                                    ** try [egrp 2[TRYBLOCK] [11 : 315->323)] { 
lbl60:
                                                    // 1 sources

                                                    fis.close();
                                                    break block22;
lbl62:
                                                    // 1 sources

                                                    catch (IOException var21_30) {
                                                        // empty catch block
                                                    }
                                                }
                                                Log.d((String)this.TAG, (String)("Elapsed time: " + (System.currentTimeMillis() - start_time) + "ms"));
                                                throw var19_31;
                                            }
                                        }
                                        ** try [egrp 2[TRYBLOCK] [11 : 315->323)] { 
lbl70:
                                        // 1 sources

                                        fis.close();
                                        break block23;
lbl72:
                                        // 1 sources

                                        catch (IOException var21_25) {
                                            // empty catch block
                                        }
                                    }
                                    Log.d((String)this.TAG, (String)("Elapsed time: " + (System.currentTimeMillis() - start_time) + "ms"));
                                    return var16_14;
                                }
                                var20_20 = null;
                                ** try [egrp 2[TRYBLOCK] [11 : 315->323)] { 
lbl81:
                                // 1 sources

                                fis.close();
                                break block24;
lbl83:
                                // 1 sources

                                catch (IOException var21_26) {
                                    // empty catch block
                                }
                            }
                            Log.d((String)this.TAG, (String)("Elapsed time: " + (System.currentTimeMillis() - start_time) + "ms"));
                            return var17_16;
                        }
                        var20_21 = null;
                        ** try [egrp 2[TRYBLOCK] [11 : 315->323)] { 
lbl92:
                        // 1 sources

                        fis.close();
                        break block25;
lbl94:
                        // 1 sources

                        catch (IOException var21_27) {
                            // empty catch block
                        }
                    }
                    Log.d((String)this.TAG, (String)("Elapsed time: " + (System.currentTimeMillis() - start_time) + "ms"));
                    return var17_17;
                }
                var20_22 = null;
                ** try [egrp 2[TRYBLOCK] [11 : 315->323)] { 
lbl103:
                // 1 sources

                fis.close();
                break block26;
lbl105:
                // 1 sources

                catch (IOException var21_28) {
                    // empty catch block
                }
            }
            Log.d((String)this.TAG, (String)("Elapsed time: " + (System.currentTimeMillis() - start_time) + "ms"));
            return var17_18;
        }

        public final FileItem[] getItems(int mode) {
            if (this.result == null) {
                return null;
            }
            File[] files_ = new File[this.result.size()];
            this.result.toArray(files_);
            return FindAdapter.this.filesToItems(files_);
        }
    }

    protected class SearchHandler
    extends CommanderAdapterBase.ReaderHandler {
        private long lastTime;

        protected SearchHandler() {
            super(FindAdapter.this);
            this.lastTime = System.currentTimeMillis();
        }

        public void handleMessage(Message msg) {
            try {
                long cur_time;
                if (msg.what == 0 && (cur_time = System.currentTimeMillis()) - this.lastTime > 1000L) {
                    FindAdapter.this.onFileFound();
                    this.lastTime = cur_time;
                }
                super.handleMessage(msg);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

