/*
 * Decompiled with CFR 0.152.
 */
package com.ghostsq.commander.adapters;

import android.content.Context;
import android.content.SharedPreferences;
import android.net.Uri;
import android.os.Build;
import android.os.Handler;
import android.os.Message;
import android.preference.PreferenceManager;
import android.util.Log;
import android.util.SparseBooleanArray;
import android.view.ContextMenu;
import android.widget.AdapterView;
import com.ghostsq.commander.adapters.CommanderAdapter;
import com.ghostsq.commander.adapters.CommanderAdapterBase;
import com.ghostsq.commander.adapters.Engines;
import com.ghostsq.commander.adapters.FSEngines;
import com.ghostsq.commander.adapters.FileItem;
import com.ghostsq.commander.adapters.FindAdapter;
import com.ghostsq.commander.adapters.ItemComparator;
import com.ghostsq.commander.adapters.MediaScanEngine;
import com.ghostsq.commander.adapters.ThumbnailsThread;
import com.ghostsq.commander.utils.Lollipop;
import com.ghostsq.commander.utils.Replacer;
import com.ghostsq.commander.utils.Utils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;

public class FSAdapter
extends CommanderAdapterBase
implements Engines.IReciever {
    private static final String TAG = "FSAdapter";
    private String dirName = null;
    protected FileItem[] items = null;
    ThumbnailsThread tht = null;

    public FSAdapter(Context ctx_) {
        super(ctx_);
    }

    public String getScheme() {
        return "";
    }

    public boolean hasFeature(CommanderAdapter.Feature feature) {
        switch (feature) {
            case FS: 
            case LOCAL: 
            case REAL: 
            case SF4: 
            case SEARCH: 
            case SEND: 
            case MULT_RENAME: 
            case FILTER: {
                return true;
            }
        }
        return super.hasFeature(feature);
    }

    public String toString() {
        return Utils.mbAddSl(this.dirName);
    }

    public String getDir() {
        return this.dirName;
    }

    public Uri getUri() {
        try {
            return Uri.parse((String)Utils.escapePath(this.toString()));
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public void setUri(Uri uri) {
        String schm = uri.getScheme();
        if (Utils.str(schm) && !"file".equals(schm)) {
            return;
        }
        this.dirName = Utils.mbAddSl(uri.getPath());
    }

    public boolean readSource(Uri d, String pass_back_on_done) {
        try {
            if (d != null) {
                this.dirName = d.getPath();
            }
            if (this.dirName == null) {
                this.notify(this.s(2131361980) + ": " + (d == null ? "null" : d.toString()), -2);
                return false;
            }
            this.reader = new FSEngines.ListEngine(this, this.readerHandler, pass_back_on_done);
            this.reader.start();
            return true;
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"readSource() excception", (Throwable)e);
        }
        catch (OutOfMemoryError err) {
            Log.e((String)TAG, (String)"Out Of Memory", (Throwable)err);
            this.notify(this.s(2131362011), -2);
        }
        return false;
    }

    protected void onReadComplete() {
        if (this.reader instanceof FSEngines.ListEngine) {
            FSEngines.ListEngine le = (FSEngines.ListEngine)this.reader;
            File dir = le.getDirFile();
            if (dir == null) {
                return;
            }
            this.dirName = dir.getAbsolutePath();
            this.items = this.filesToItems(le.getFiles());
            this.parentLink = dir.getParent() == null ? SLS : "..";
            this.notifyDataSetChanged();
            this.startThumbnailCreation();
        }
    }

    protected void startThumbnailCreation() {
        if (this.thumbnail_size_perc > 0) {
            if (this.tht != null) {
                this.tht.interrupt();
            }
            this.tht = new ThumbnailsThread(this, new Handler(){

                public void handleMessage(Message msg) {
                    FSAdapter.this.notifyDataSetChanged();
                }
            }, this.dirName, this.items);
            this.tht.start();
        }
    }

    protected FileItem[] filesToItems(File[] files_) {
        int num_files;
        int num = num_files = files_.length;
        boolean hide = (this.mode & 8) == 8;
        ArrayList<FileItem> al = new ArrayList<FileItem>(num_files);
        for (int i = 0; i < num_files; ++i) {
            String link_target;
            File f = files_[i];
            if (hide && f.isHidden()) continue;
            String fn = null;
            if (Build.VERSION.SDK_INT >= 21 && (link_target = Lollipop.readlink(f.getAbsolutePath())) != null) {
                fn = f.getName();
                f = new File(link_target);
            }
            FileItem f_item = new FileItem(f);
            if (this.filter != null && !this.filter.isMatched(f_item)) continue;
            if (fn != null) {
                f_item.name = (f_item.dir ? File.separator : "") + fn;
                f_item.icon_id = 2130837530;
            }
            al.add(f_item);
        }
        FileItem[] items_ = new FileItem[al.size()];
        al.toArray(items_);
        this.reSort(items_);
        return items_;
    }

    public void populateContextMenu(ContextMenu menu2, AdapterView.AdapterContextMenuInfo acmi, int num) {
        try {
            if (acmi.position != 0) {
                CommanderAdapter.Item item = (CommanderAdapter.Item)this.getItem(acmi.position);
                if (!item.dir && ".zip".equals(Utils.getFileExt(item.name))) {
                    menu2.add(0, 2131230760, 0, 2131361909);
                    menu2.add(0, 2131230758, 0, 2131361914);
                }
                if (item.dir && num == 1 && Build.VERSION.SDK_INT >= 11) {
                    menu2.add(0, 2131230761, 0, 2131361841);
                }
            }
            super.populateContextMenu(menu2, acmi, num);
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"", (Throwable)e);
        }
    }

    public void doIt(int command_id, SparseBooleanArray cis) {
        if (2131230761 == command_id) {
            FileItem[] list = this.bitsToFilesEx(cis);
            if (list == null || list.length == 0) {
                return;
            }
            SharedPreferences sp = PreferenceManager.getDefaultSharedPreferences((Context)this.ctx);
            MediaScanEngine mse = new MediaScanEngine(this.ctx, list[0].f().getAbsoluteFile(), sp.getBoolean("scan_all", true), true);
            mse.setHandler(new CommanderAdapterBase.SimpleHandler(this));
            this.commander.startEngine(mse);
        }
    }

    public void openItem(int position) {
        if (position == 0) {
            if (this.parentLink == SLS) {
                this.commander.Navigate(Uri.parse((String)"home:"), null, null);
            } else {
                if (this.dirName == null) {
                    return;
                }
                File cur_dir_file = new File(this.dirName);
                String parent_dir = cur_dir_file.getParent();
                this.commander.Navigate(Uri.parse((String)Utils.escapePath(parent_dir != null ? parent_dir : DEFAULT_DIR)), null, cur_dir_file.getName());
            }
        } else {
            File file = this.items[position - 1].f();
            if (file == null) {
                return;
            }
            Uri open_uri = Uri.parse((String)Utils.escapePath(file.getAbsolutePath()));
            if (file.isDirectory()) {
                this.commander.Navigate(open_uri, null, null);
            } else {
                this.commander.Open(open_uri, null);
            }
        }
    }

    public Uri getItemUri(int position) {
        try {
            String item_name = this.getItemName(position, true);
            if (item_name == null) {
                return null;
            }
            return Uri.parse((String)Utils.escapePath(item_name));
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)("No item in the position " + position), (Throwable)e);
            return null;
        }
    }

    public String getItemName(int position, boolean full) {
        if (position < 0 || this.items == null || position > this.items.length) {
            return position == 0 ? this.parentLink : null;
        }
        if (full) {
            if (position == 0) {
                return this.dirName != null ? new File(this.dirName).getParent() : null;
            }
            File f = this.items[position - 1].f();
            return f != null ? f.getAbsolutePath() : null;
        }
        if (position == 0) {
            return this.parentLink;
        }
        FileItem item = this.items[position - 1];
        String name = item.name;
        if (name != null && item.dir && !(this instanceof FindAdapter)) {
            return name.replace("/", "");
        }
        return name;
    }

    public void reqItemsSize(SparseBooleanArray cis) {
        try {
            FSEngines.IFileItem[] list = this.bitsToFilesEx(cis);
            this.notify(-1);
            this.commander.startEngine(new FSEngines.CalcSizesEngine(this, list));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean renameItem(int position, String newName, boolean copy) {
        if (position <= 0) return false;
        if (position > this.items.length) {
            return false;
        }
        try {
            if (copy) {
                String dest_name;
                this.notify(-1);
                File[] list = new File[]{this.items[position - 1].f()};
                if (newName.indexOf(SLC) < 0) {
                    dest_name = this.dirName;
                    if (dest_name.charAt(dest_name.length() - 1) != SLC) {
                        dest_name = dest_name + SLS;
                    }
                    dest_name = dest_name + newName;
                } else {
                    dest_name = newName;
                }
                this.commander.startEngine(new FSEngines.CopyEngine(this, list, dest_name, 0, true));
                return true;
            }
            boolean ok = false;
            File f = this.items[position - 1].f();
            File new_file = new File(this.dirName, newName);
            if (new_file.exists()) {
                String new_ap;
                if (f.equals(new_file)) {
                    this.commander.showError(this.s(2131361976));
                    return false;
                }
                String old_ap = f.getAbsolutePath();
                if (!old_ap.equalsIgnoreCase(new_ap = new_file.getAbsolutePath())) {
                    FSEngines.AskEngine ae = new FSEngines.AskEngine(this, this.simpleHandler, this.ctx.getString(2131362015, new Object[]{newName}), f, new_file);
                    this.commander.startEngine(ae);
                    return true;
                }
                File tmp_file = new File(this.dirName, newName + "_TMP_");
                ok = f.renameTo(tmp_file);
                ok = tmp_file.renameTo(new_file);
            } else {
                ok = f.renameTo(new_file);
            }
            if (!ok) {
                this.notify(this.s(2131362060), -2);
                return ok;
            }
            this.notifyRefr(newName);
            if (Build.VERSION.SDK_INT < 11) return ok;
            if (new_file.isDirectory()) {
                SharedPreferences sp = PreferenceManager.getDefaultSharedPreferences((Context)this.ctx);
                MediaScanEngine mse = new MediaScanEngine(this.ctx, new_file, sp.getBoolean("scan_all", true), true);
                mse.start();
                return ok;
            }
            String[] to_scan = new String[]{f.getAbsolutePath(), new_file.getAbsolutePath()};
            MediaScanEngine.scanMedia(this.ctx, to_scan);
            return ok;
        }
        catch (SecurityException e) {
            this.commander.showError(this.ctx.getString(2131362016, new Object[]{e.getMessage()}));
            return false;
        }
    }

    public boolean renameItems(SparseBooleanArray cis, String pattern_str, String replace_to) {
        FSReplacer r = new FSReplacer(this.bitsToFiles(cis));
        r.replace(pattern_str, replace_to);
        this.notifyRefr(r.last_file_name);
        return false;
    }

    public CommanderAdapter.Item getItem(Uri u) {
        try {
            File f = new File(u.getPath());
            if (f.exists()) {
                CommanderAdapter.Item item = new CommanderAdapter.Item(f.getName());
                item.size = f.length();
                item.date = new Date(f.lastModified());
                item.dir = f.isDirectory();
                return item;
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        return null;
    }

    public InputStream getContent(Uri u, long skip) {
        try {
            String path = u.getPath();
            File f = new File(path);
            if (f.exists() && f.isFile()) {
                FileInputStream fis = new FileInputStream(f);
                if (skip > 0L) {
                    fis.skip(skip);
                }
                return fis;
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        return null;
    }

    public OutputStream saveContent(Uri u) {
        if (u != null) {
            File f = new File(u.getPath());
            try {
                return new FileOutputStream(f);
            }
            catch (FileNotFoundException e) {
                Log.e((String)TAG, (String)u.getPath(), (Throwable)e);
            }
        }
        return null;
    }

    public boolean createFile(String name) {
        try {
            String file_path = name.charAt(0) != '/' ? Utils.mbAddSl(this.dirName) + name : name;
            File f = new File(file_path);
            boolean ok = f.createNewFile();
            this.notify(null, ok ? -4 : -2);
            return ok;
        }
        catch (Exception e) {
            this.commander.showError(this.ctx.getString(2131362021, new Object[]{name, e.getMessage()}));
            return false;
        }
    }

    public void createFolder(String new_name) {
        try {
            if (new File(this.dirName, new_name).mkdir()) {
                this.notifyRefr(new_name);
                return;
            }
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"createFolder", (Throwable)e);
        }
        this.notify(this.ctx.getString(2131362013, new Object[]{new_name}), -2);
    }

    public boolean deleteItems(SparseBooleanArray cis) {
        try {
            FileItem[] list = this.bitsToFilesEx(cis);
            if (list != null) {
                this.notify(-1);
                this.commander.startEngine(new FSEngines.DeleteEngine((CommanderAdapterBase)this, list));
            }
        }
        catch (Exception e) {
            this.notify(e.getMessage(), -2);
        }
        return false;
    }

    public boolean copyItems(SparseBooleanArray cis, CommanderAdapter to, boolean move) {
        boolean ok = to.receiveItems(this.bitsToNames(cis), move ? 1 : 0);
        if (!ok) {
            this.notify(-2);
        }
        return ok;
    }

    public boolean receiveItems(String[] uris, int move_mode) {
        try {
            if (uris == null || uris.length == 0) {
                return false;
            }
            File dest_file = new File(this.dirName);
            if (dest_file.exists() ? !dest_file.isDirectory() : !dest_file.mkdirs()) {
                return false;
            }
            File[] list = Utils.getListOfFiles(uris);
            if (list != null) {
                this.notify(-1);
                this.commander.startEngine(new FSEngines.CopyEngine(this, list, this.dirName, move_mode, false));
                return true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    public void prepareToDestroy() {
        super.prepareToDestroy();
        if (this.tht != null) {
            this.tht.interrupt();
        }
        this.items = null;
    }

    private final FileItem[] bitsToFilesEx(SparseBooleanArray cis) {
        try {
            int counter = 0;
            for (int i = 0; i < cis.size(); ++i) {
                if (!cis.valueAt(i) || cis.keyAt(i) <= 0) continue;
                ++counter;
            }
            FileItem[] res = new FileItem[counter];
            int j = 0;
            for (int i = 0; i < cis.size(); ++i) {
                int k;
                if (!cis.valueAt(i) || (k = cis.keyAt(i)) <= 0) continue;
                res[j++] = this.items[k - 1];
            }
            return res;
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"bitsToFilesEx()", (Throwable)e);
            return null;
        }
    }

    public final File[] bitsToFiles(SparseBooleanArray cis) {
        try {
            int counter = 0;
            for (int i = 0; i < cis.size(); ++i) {
                if (!cis.valueAt(i) || cis.keyAt(i) <= 0) continue;
                ++counter;
            }
            File[] res = new File[counter];
            int j = 0;
            for (int i = 0; i < cis.size(); ++i) {
                int k;
                if (!cis.valueAt(i) || (k = cis.keyAt(i)) <= 0) continue;
                res[j++] = this.items[k - 1].f();
            }
            return res;
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"bitsToFiles()", (Throwable)e);
            return null;
        }
    }

    protected int getPredictedAttributesLength() {
        return 10;
    }

    public int getCount() {
        if (this.items == null) {
            return 1;
        }
        return this.items.length + 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getItem(int position) {
        CommanderAdapter.Item item = null;
        if (position == 0) {
            item = new CommanderAdapter.Item();
            item.name = this.parentLink;
            item.dir = true;
        } else if (this.items != null && position <= this.items.length) {
            FileItem[] fileItemArray = this.items;
            synchronized (this.items) {
                try {
                    // ** MonitorExit[var3_3] (shouldn't be in output)
                    return this.items[position - 1];
                }
                catch (Exception e) {
                    Log.e((String)TAG, (String)("getItem(" + position + ")"), (Throwable)e);
                    // ** MonitorExit[var3_3] (shouldn't be in output)
                }
            }
        } else {
            item = new CommanderAdapter.Item();
            item.name = "???";
        }
        return item;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void reSort() {
        if (this.items == null) {
            return;
        }
        FileItem[] fileItemArray = this.items;
        synchronized (this.items) {
            this.reSort(this.items);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public void reSort(FileItem[] items_) {
        if (items_ == null) {
            return;
        }
        ItemComparator comp = new ItemComparator(this.mode & 0x30, (this.mode & 0x80) != 0, this.ascending);
        Arrays.sort(items_, comp);
    }

    public Engines.IReciever getReceiver() {
        return this;
    }

    class FSReplacer
    extends Replacer {
        public String last_file_name = null;
        private File[] ff;

        FSReplacer(File[] ff) {
            this.ff = ff;
        }

        protected int getNumberOfOriginalStrings() {
            return this.ff.length;
        }

        protected String getOriginalString(int i) {
            return this.ff[i].getName();
        }

        protected void setReplacedString(int i, String replaced) {
            File f = this.ff[i];
            if (f.getName().equals(replaced)) {
                return;
            }
            File new_file = new File(FSAdapter.this.dirName, replaced);
            if (!new_file.exists() && !f.renameTo(new_file)) {
                String err_msg = FSAdapter.this.s(2131361976) + " " + f.getName();
                FSAdapter.this.notify(err_msg, -2);
            }
            this.last_file_name = new_file.getName();
        }
    }
}

