/*
 * Decompiled with CFR 0.152.
 */
package com.ghostsq.commander.adapters;

import android.annotation.TargetApi;
import android.content.ContentResolver;
import android.content.ContentValues;
import android.content.Context;
import android.content.Intent;
import android.database.Cursor;
import android.net.Uri;
import android.provider.MediaStore;
import android.util.Log;
import android.util.SparseBooleanArray;
import android.view.ContextMenu;
import com.ghostsq.commander.adapters.CommanderAdapter;
import com.ghostsq.commander.adapters.CommanderAdapterBase;
import com.ghostsq.commander.adapters.Engine;
import com.ghostsq.commander.adapters.Engines;
import com.ghostsq.commander.adapters.ItemComparator;
import com.ghostsq.commander.adapters.ThumbnailsThread;
import com.ghostsq.commander.utils.Utils;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Stack;

@TargetApi(value=11)
public class ContentAdapter
extends CommanderAdapterBase
implements Engines.IReciever {
    private static final String TAG = "ContentAdapter";
    public static final String SCHEME = "content:";
    public static final int MEDIA = 0;
    public static final int ALBUMS = 1;
    public static final int ARTISTS = 2;
    public static final int GENRES = 3;
    public static final int PLAYLISTS = 4;
    private int content_type;
    private Uri content_uri;
    private Stack<Uri> parents = new Stack();
    private String name;
    protected CommanderAdapter.Item[] items = null;
    private ThumbnailsThread tht = null;

    public ContentAdapter(Context ctx_) {
        super(ctx_);
    }

    public String getScheme() {
        return "content";
    }

    public boolean hasFeature(CommanderAdapter.Feature feature) {
        switch (feature) {
            case LOCAL: 
            case F8: {
                return true;
            }
            case SEND: 
            case FS: 
            case F2: 
            case F6: {
                return false;
            }
        }
        return super.hasFeature(feature);
    }

    public String toString() {
        if (Utils.str(this.name)) {
            return this.name;
        }
        Uri u = this.getUri();
        return u != null ? u.toString() : null;
    }

    public int setMode(int mask, int val) {
        if ((mask & 1) == 0) {
            super.setMode(mask, val);
        }
        return this.mode;
    }

    public Uri getUri() {
        return this.content_uri;
    }

    public void setUri(Uri uri) {
        this.content_uri = uri;
        this.content_type = ContentAdapter.getType(uri);
        if (uri != null && uri.equals((Object)ContentAdapter.getBaseUri(this.content_type))) {
            this.parentLink = SLS;
        }
    }

    public static final void populateHomeContextMenu(Context ctx, ContextMenu menu2) {
        String vs = ctx.getString(2131361954);
        menu2.add(0, 2, 0, (CharSequence)(vs + " \"" + ContentAdapter.getTypeName(2) + "\""));
        menu2.add(0, 1, 0, (CharSequence)(vs + " \"" + ContentAdapter.getTypeName(1) + "\""));
        menu2.add(0, 3, 0, (CharSequence)(vs + " \"" + ContentAdapter.getTypeName(3) + "\""));
        menu2.add(0, 4, 0, (CharSequence)(vs + " \"" + ContentAdapter.getTypeName(4) + "\""));
    }

    private static final String getTypeName(int id2) {
        if (id2 == 1) {
            return "Albums";
        }
        if (id2 == 2) {
            return "Artists";
        }
        if (id2 == 3) {
            return "Genres";
        }
        if (id2 == 4) {
            return "Playlists";
        }
        return null;
    }

    public static final Uri getBaseUri(int id2) {
        if (id2 == 1) {
            return MediaStore.Audio.Albums.EXTERNAL_CONTENT_URI;
        }
        if (id2 == 2) {
            return MediaStore.Audio.Artists.EXTERNAL_CONTENT_URI;
        }
        if (id2 == 3) {
            return MediaStore.Audio.Genres.EXTERNAL_CONTENT_URI;
        }
        if (id2 == 4) {
            return MediaStore.Audio.Playlists.EXTERNAL_CONTENT_URI;
        }
        return null;
    }

    private static final Uri getParentUri(Uri uri) {
        int ub;
        String a_id = uri.getQueryParameter("album_id");
        if (Utils.str(a_id)) {
            return MediaStore.Audio.Albums.EXTERNAL_CONTENT_URI.buildUpon().appendEncodedPath(a_id).build();
        }
        List ps = uri.getPathSegments();
        if ("albums".equalsIgnoreCase((String)ps.get(ub = ps.size() - 1)) && "artists".equalsIgnoreCase((String)ps.get(ub - 2))) {
            return MediaStore.Audio.Artists.EXTERNAL_CONTENT_URI.buildUpon().appendEncodedPath((String)ps.get(ub - 1)).build();
        }
        if ("members".equalsIgnoreCase((String)ps.get(ub)) && "genres".equalsIgnoreCase((String)ps.get(ub - 2))) {
            return MediaStore.Audio.Genres.EXTERNAL_CONTENT_URI.buildUpon().appendEncodedPath((String)ps.get(ub - 1)).build();
        }
        return null;
    }

    public static final int getType(Uri uri) {
        if (uri == null) {
            return -1;
        }
        if (Utils.str(uri.getQuery())) {
            return 0;
        }
        List ps = uri.getPathSegments();
        for (int i = ps.size() - 1; i > 0; --i) {
            String s = (String)ps.get(i);
            if ("members".equalsIgnoreCase(s)) {
                return 0;
            }
            if ("genres".equalsIgnoreCase(s)) {
                return 3;
            }
            if ("albums".equalsIgnoreCase(s)) {
                return 1;
            }
            if ("artists".equalsIgnoreCase(s)) {
                return 2;
            }
            if (!"playlists".equalsIgnoreCase(s)) continue;
            return 4;
        }
        return 0;
    }

    private static final String[] getProjection(int id2) {
        if (id2 == 1) {
            return new String[]{"_id", "album", "numsongs", "artist"};
        }
        if (id2 == 2) {
            return new String[]{"_id", "artist", "number_of_tracks", "number_of_albums"};
        }
        if (id2 == 3) {
            return new String[]{"_id", "name"};
        }
        if (id2 == 4) {
            return new String[]{"_id", "name"};
        }
        if (id2 == 0) {
            return new String[]{"_id", "title", "_data", "date_modified", "_size", "mime_type"};
        }
        return null;
    }

    private final String getField(int id2) {
        if (id2 == this.content_type) {
            return "_id";
        }
        if (id2 == 1) {
            return "album_id";
        }
        if (id2 == 3) {
            return "genre_id";
        }
        if (id2 == 2) {
            return "artist_id";
        }
        if (id2 == 4) {
            return "playlist_id";
        }
        return null;
    }

    public boolean readSource(Uri new_uri, String pass_back_on_done) {
        try {
            String parent_id;
            if (new_uri != null) {
                this.setUri(new_uri);
            } else if (this.content_uri == null) {
                return false;
            }
            ContentResolver cr = this.ctx.getContentResolver();
            this.name = null;
            Uri p_uri = ContentAdapter.getParentUri(this.content_uri);
            if (p_uri != null) {
                try {
                    Log.d((String)TAG, (String)(" Parent Uri: " + p_uri));
                    Cursor cursor = cr.query(p_uri, ContentAdapter.getProjection(ContentAdapter.getType(p_uri)), null, null, null);
                    if (cursor != null && cursor.getCount() > 0) {
                        cursor.moveToFirst();
                        this.name = "\"" + cursor.getString(1) + "\"";
                        cursor.close();
                    }
                }
                catch (Throwable e) {
                    Log.e((String)TAG, (String)"inner", (Throwable)e);
                }
            }
            if (this.name == null) {
                this.name = ContentAdapter.getTypeName(this.content_type);
            }
            String[] projection = ContentAdapter.getProjection(this.content_type);
            String selection = null;
            String[] sel_args = null;
            if (this.content_type == 0 && Utils.str(parent_id = this.content_uri.getQueryParameter("album_id"))) {
                selection = "album_id = ? ";
                sel_args = new String[]{parent_id};
            }
            Log.d((String)TAG, (String)("Quering type: " + this.content_type + " Uri: " + this.content_uri));
            Cursor cursor = cr.query(this.content_uri, projection, selection, sel_args, null);
            if (cursor != null) {
                try {
                    if (cursor.getCount() > 0) {
                        cursor.moveToFirst();
                        ArrayList<CommanderAdapter.Item> tmp_list = new ArrayList<CommanderAdapter.Item>();
                        int pci = cursor.getColumnIndex("_data");
                        int sci = cursor.getColumnIndex("_size");
                        int dci = cursor.getColumnIndex("date_modified");
                        int mci = cursor.getColumnIndex("mime_type");
                        int aci = cursor.getColumnIndex("artist");
                        int nci = cursor.getColumnIndex("numsongs");
                        boolean show_artists = this.content_type == 1 && MediaStore.Audio.Albums.EXTERNAL_CONTENT_URI.equals((Object)this.content_uri);
                        do {
                            long item_id = cursor.getLong(0);
                            CommanderAdapter.Item item = new CommanderAdapter.Item();
                            if (this.content_type == 2) {
                                item.origin = MediaStore.Audio.Artists.Albums.getContentUri((String)"external", (long)item_id);
                            } else if (this.content_type == 3) {
                                item.origin = MediaStore.Audio.Genres.Members.getContentUri((String)"external", (long)item_id);
                            } else if (this.content_type == 4) {
                                item.origin = MediaStore.Audio.Playlists.Members.getContentUri((String)"external", (long)item_id);
                            } else if (this.content_type == 1) {
                                item.origin = MediaStore.Audio.Media.EXTERNAL_CONTENT_URI.buildUpon().encodedQuery("album_id=" + item_id).build();
                                if (show_artists) {
                                    item.attr = cursor.getString(aci);
                                }
                                item.size = cursor.getInt(nci);
                            } else {
                                item.origin = MediaStore.Audio.Media.EXTERNAL_CONTENT_URI.buildUpon().appendEncodedPath(String.valueOf(item_id)).build();
                            }
                            item.name = cursor.getString(1);
                            if (item.name == null) {
                                item.name = "(?)";
                            }
                            boolean bl = item.dir = this.content_type != 0;
                            if ("title".equals(projection[1])) {
                                item.attr = cursor.getString(pci);
                                item.size = cursor.getLong(sci);
                                item.date = new Date(cursor.getLong(dci) * 1000L);
                                File f = new File(item.attr);
                                if (!f.exists()) {
                                    item.colorCache = -65536;
                                    item.icon_id = 2130837509;
                                } else {
                                    item.icon_id = ContentAdapter.getIconId(item.attr);
                                }
                                item.mime = cursor.getString(mci);
                            }
                            tmp_list.add(item);
                        } while (cursor.moveToNext());
                        cursor.close();
                        this.items = new CommanderAdapter.Item[tmp_list.size()];
                        tmp_list.toArray(this.items);
                        this.reSort(this.items);
                    } else {
                        this.items = new CommanderAdapter.Item[0];
                    }
                    super.setCount(this.items.length);
                }
                catch (Throwable e) {
                    Log.e((String)TAG, (String)"inner", (Throwable)e);
                }
            }
            this.notify(pass_back_on_done);
            return true;
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"outer", (Throwable)e);
            this.notify(e.getMessage(), -2);
        }
        catch (OutOfMemoryError err) {
            Log.e((String)TAG, (String)"Out Of Memory", (Throwable)err);
            this.notify(this.s(2131362011), -2);
        }
        return false;
    }

    protected void reSort() {
        this.reSort(this.items);
    }

    public void reSort(CommanderAdapter.Item[] items_) {
        if (items_ == null) {
            return;
        }
        ItemComparator comp = new ItemComparator(this.mode & 0x30, (this.mode & 0x80) != 0, this.ascending);
        Arrays.sort(items_, comp);
    }

    public void openItem(int position) {
        if (position == 0) {
            if (!this.parents.isEmpty()) {
                this.commander.Navigate(this.parents.pop(), null, this.name != null ? this.name.replace("\"", "") : null);
                return;
            }
            this.commander.Navigate(Uri.parse((String)"home:"), null, null);
            return;
        }
        CommanderAdapter.Item item = this.items[position - 1];
        if (item.dir) {
            this.parents.push(this.content_uri);
            this.parentLink = "..";
            this.commander.Navigate((Uri)item.origin, null, null);
            return;
        }
        Intent in = new Intent("android.intent.action.VIEW").setDataAndType((Uri)item.origin, item.mime);
        this.commander.issue(in, 0);
    }

    public Uri getItemUri(int position) {
        try {
            String item_name = this.getItemName(position, true);
            return Uri.parse((String)(SCHEME + Utils.escapePath(item_name)));
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public String getItemName(int position, boolean full) {
        if (position < 0 || this.items == null || position > this.items.length) {
            return position == 0 ? this.parentLink : null;
        }
        if (full) {
            String dirName = Utils.mbAddSl(this.content_uri.getPath());
            return position == 0 ? new File(dirName).getParent() : dirName + this.items[position - 1].name;
        }
        if (position == 0) {
            return this.parentLink;
        }
        String name = this.items[position - 1].name;
        if (name != null) {
            return name.replace("/", "");
        }
        return null;
    }

    public void reqItemsSize(SparseBooleanArray cis) {
    }

    public boolean renameItem(int position, String newName, boolean copy) {
        if (position <= 0 || position > this.items.length) {
            return false;
        }
        try {
            ContentResolver cr = this.ctx.getContentResolver();
            ContentValues cv = new ContentValues();
            CommanderAdapter.Item item = this.items[position - 1];
            return 1 == cr.update((Uri)item.origin, cv, null, null);
        }
        catch (Exception e) {
            this.commander.showError(this.ctx.getString(2131362016, new Object[]{e.getMessage()}));
            return false;
        }
    }

    public CommanderAdapter.Item getItem(Uri u) {
        try {
            if (!"ms".equals(u.getScheme())) {
                return null;
            }
            File f = new File(u.getPath());
            if (f.exists()) {
                CommanderAdapter.Item item = new CommanderAdapter.Item(f.getName());
                item.size = f.length();
                item.date = new Date(f.lastModified());
                item.dir = f.isDirectory();
                return item;
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        return null;
    }

    public InputStream getContent(Uri u, long skip) {
        try {
            ContentResolver cr = this.ctx.getContentResolver();
            InputStream is = cr.openInputStream(u);
            is.skip(skip);
            return is;
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)u.toString(), (Throwable)e);
            return null;
        }
    }

    public OutputStream saveContent(Uri u) {
        try {
            ContentResolver cr = this.ctx.getContentResolver();
            return cr.openOutputStream(u);
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)u.getPath(), (Throwable)e);
            return null;
        }
    }

    public boolean createFile(String fileURI) {
        return false;
    }

    public void createFolder(String new_name) {
    }

    public boolean deleteItems(SparseBooleanArray cis) {
        try {
            CommanderAdapter.Item[] list = this.bitsToItems(cis);
            if (list != null) {
                this.notify(-1);
                this.commander.startEngine(new DeleteEngine(list));
            }
        }
        catch (Exception e) {
            this.notify(e.getMessage(), -2);
        }
        return false;
    }

    public boolean copyItems(SparseBooleanArray cis, CommanderAdapter to, boolean move) {
        boolean ok = to.receiveItems(this.bitsToNames(cis), 0);
        if (!ok) {
            this.notify(-2);
            return ok;
        }
        return ok;
    }

    public boolean receiveItems(String[] uris, int move_mode) {
        return false;
    }

    public void prepareToDestroy() {
        super.prepareToDestroy();
        this.items = null;
    }

    public final CommanderAdapter.Item[] bitsToItems(SparseBooleanArray cis) {
        try {
            int counter = 0;
            for (int i = 0; i < cis.size(); ++i) {
                if (!cis.valueAt(i) || cis.keyAt(i) <= 0) continue;
                ++counter;
            }
            CommanderAdapter.Item[] res = new CommanderAdapter.Item[counter];
            int j = 0;
            for (int i = 0; i < cis.size(); ++i) {
                int k;
                if (!cis.valueAt(i) || (k = cis.keyAt(i)) <= 0) continue;
                res[j++] = this.items[k - 1];
            }
            return res;
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"bitsToFiles()", (Throwable)e);
            return null;
        }
    }

    protected int getPredictedAttributesLength() {
        return 10;
    }

    public int getCount() {
        if (this.items == null) {
            return 1;
        }
        return this.items.length + 1;
    }

    public Object getItem(int position) {
        CommanderAdapter.Item item = null;
        if (position == 0) {
            item = new CommanderAdapter.Item();
            item.name = this.parentLink;
            item.dir = true;
        } else {
            if (this.items != null && position <= this.items.length) {
                return this.items[position - 1];
            }
            item = new CommanderAdapter.Item();
            item.name = "???";
        }
        return item;
    }

    public Engines.IReciever getReceiver() {
        return this;
    }

    class DeleteEngine
    extends Engine {
        private CommanderAdapter.Item[] mList;
        ContentResolver cr;

        DeleteEngine(CommanderAdapter.Item[] list) {
            this.setName(".DeleteEngine");
            this.mList = list;
        }

        public void run() {
            try {
                ContentAdapter.this.Init(null);
                this.cr = ContentAdapter.this.ctx.getContentResolver();
                String dirName = Utils.mbAddSl(ContentAdapter.this.content_uri.getPath());
                int cnt = this.deleteItems(dirName, this.mList);
                this.sendResult(Utils.getOpReport(ContentAdapter.this.ctx, cnt, 2131362026));
            }
            catch (Exception e) {
                this.sendProgress(e.getMessage(), -7);
            }
        }

        private final int deleteItems(String base_path, CommanderAdapter.Item[] l) throws Exception {
            if (l == null) {
                return 0;
            }
            int cnt = 0;
            int num = l.length;
            double conv = 100.0 / (double)num;
            for (int i = 0; i < num; ++i) {
                DeleteEngine.sleep(1L);
                if (this.isStopReq()) {
                    throw new Exception(ContentAdapter.this.s(2131362010));
                }
                CommanderAdapter.Item f = l[i];
                this.sendProgress(ContentAdapter.this.ctx.getString(2131361999, new Object[]{f.name}), (int)((double)cnt * conv));
                Uri c_uri = (Uri)f.origin;
                if (c_uri == null) continue;
                cnt += this.cr.delete(c_uri, null, null);
            }
            return cnt;
        }
    }
}

