/*
 * Decompiled with CFR 0.152.
 */
package com.ghostsq.commander.adapters;

import android.content.Context;
import android.content.Intent;
import android.graphics.Typeface;
import android.net.Uri;
import android.os.Bundle;
import android.os.Environment;
import android.os.Handler;
import android.os.Message;
import android.os.Parcelable;
import android.text.format.DateFormat;
import android.util.Log;
import android.util.SparseBooleanArray;
import android.view.ContextMenu;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.BaseAdapter;
import android.widget.ImageView;
import android.widget.ListView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.ghostsq.commander.ColorsKeeper;
import com.ghostsq.commander.Commander;
import com.ghostsq.commander.FilterProps;
import com.ghostsq.commander.adapters.CommanderAdapter;
import com.ghostsq.commander.adapters.Engine;
import com.ghostsq.commander.adapters.Engines;
import com.ghostsq.commander.root.RootAdapter;
import com.ghostsq.commander.utils.Credentials;
import com.ghostsq.commander.utils.Utils;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class CommanderAdapterBase
extends BaseAdapter
implements CommanderAdapter {
    protected static final String DEFAULT_DIR = Environment.getExternalStorageDirectory().getAbsolutePath();
    protected final String TAG = this.getClass().getName();
    public Context ctx;
    public Commander commander = null;
    public static final String SLS = File.separator;
    public static final char SLC = File.separatorChar;
    public static final String PLS = "..";
    private static final boolean long_date = Locale.getDefault().getLanguage().compareTo("en") != 0;
    private java.text.DateFormat localeDateFormat;
    private java.text.DateFormat localeTimeFormat;
    protected static final int ICON_SIZE = 32;
    protected int icoWidth = 32;
    protected int imgWidth = 32;
    protected float density = 1.0f;
    protected LayoutInflater mInflater = null;
    private int parentWidth;
    private int nameWidth;
    private int sizeWidth;
    private int dateWidth;
    private int attrWidth;
    private boolean a3r = false;
    protected boolean dirty = true;
    protected int thumbnail_size_perc = 100;
    protected int font_size = 18;
    protected int mode = 0;
    protected boolean ascending = true;
    protected String parentLink = SLS;
    protected int numItems = 0;
    protected FilterProps filter;
    public int shownFrom = 0;
    public int shownNum = 3;
    private static ColorsKeeper ck;
    private static int[] typeColors;
    private static Pattern[][] filePatterns;
    protected Engine reader = null;
    protected ReaderHandler readerHandler = null;
    protected SimpleHandler simpleHandler = null;

    public static void setTypeMaskColors(ColorsKeeper ck_) {
        try {
            ColorsKeeper.FileTypeColor ftc;
            ck = ck_;
            int n = CommanderAdapterBase.ck.ftColors.size();
            typeColors = new int[n];
            filePatterns = new Pattern[n][];
            for (int i = 0; i < n && (ftc = CommanderAdapterBase.ck.ftColors.get(i)) != null; ++i) {
                int color2 = ftc.color;
                String smask = ftc.masks;
                if (smask != null) {
                    CommanderAdapterBase.typeColors[i] = color2;
                    String[] masks = smask.split(";");
                    int m = masks.length;
                    CommanderAdapterBase.filePatterns[i] = new Pattern[m];
                    for (int j = 0; j < m; ++j) {
                        String re = masks[j].replace(".", "\\.").replace("*", ".*");
                        CommanderAdapterBase.filePatterns[i][j] = Pattern.compile(re, 2);
                    }
                    continue;
                }
                break;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void onReadComplete() {
    }

    protected CommanderAdapterBase() {
    }

    protected CommanderAdapterBase(Context ctx_) {
        this.ctx = ctx_;
    }

    protected CommanderAdapterBase(Context ctx_, int mode_) {
        this.ctx = ctx_;
        this.mode = mode_;
    }

    public void Init(Commander c) {
        if (c != null) {
            this.commander = c;
            this.readerHandler = new ReaderHandler();
            this.simpleHandler = new SimpleHandler();
            if (this.ctx == null) {
                this.ctx = c.getContext();
            }
            this.mInflater = (LayoutInflater)this.ctx.getSystemService("layout_inflater");
            Utils.changeLanguage(this.ctx);
            this.localeDateFormat = DateFormat.getDateFormat((Context)this.ctx);
            this.localeTimeFormat = DateFormat.getTimeFormat((Context)this.ctx);
            this.density = this.ctx.getResources().getDisplayMetrics().density;
        }
        this.parentWidth = 0;
        this.nameWidth = 0;
        this.sizeWidth = 0;
        this.dateWidth = 0;
        this.attrWidth = 0;
    }

    public void setContext(Context ctx_) {
        this.ctx = ctx_;
    }

    private final void calcWidths() {
        try {
            if ((this.mode & 0x1000) == 4096) {
                this.icoWidth = (int)(this.density * 32.0f);
                if ((0x2000 & this.mode) != 0) {
                    this.icoWidth >>= 1;
                }
            } else {
                this.icoWidth = 0;
            }
            this.imgWidth = this.thumbnail_size_perc > 0 && this.thumbnail_size_perc != 100 ? this.icoWidth * this.thumbnail_size_perc / 100 : this.icoWidth;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public int getImgWidth() {
        return this.imgWidth;
    }

    public int getMode() {
        return this.mode;
    }

    public int setMode(int mask, int val) {
        if ((mask & 0x2000000) != 0) {
            this.font_size = val;
            return 0;
        }
        if ((mask & 0x1000000) != 0) {
            this.thumbnail_size_perc = val;
            this.calcWidths();
            return 0;
        }
        if ((mask & 0x3004) != 0) {
            this.calcWidths();
        }
        this.mode &= ~mask;
        this.mode |= val;
        if (mask != 65536) {
            this.dirty = true;
        }
        if ((mask & 0x40) != 0 || (mask & 0x30) != 0) {
            if ((mask & 0x40) != 0) {
                this.ascending = (val & 0x40) == 0;
            }
            this.reSort();
            this.notifyDataSetChanged();
        }
        return this.mode;
    }

    public void terminateOperation() {
        Log.i((String)this.TAG, (String)"terminateOperation()");
        if (this.reader != null) {
            this.reader.reqStop();
        }
    }

    public void prepareToDestroy() {
        Log.i((String)this.TAG, (String)"prepareToDestroy()");
        this.terminateOperation();
        this.reader = null;
    }

    public final boolean _isWorkerStillAlive() {
        return false;
    }

    protected Bundle wrap(String str) {
        Bundle b = new Bundle(1);
        b.putString("STRING", str);
        return b;
    }

    protected void notify(String s, String cookie) {
        if (this.readerHandler == null) {
            return;
        }
        Message msg = this.readerHandler.obtainMessage(s != null ? -2 : -3, s);
        if (msg != null) {
            Bundle b = new Bundle();
            b.putString("cookie", cookie);
            msg.setData(b);
            msg.sendToTarget();
        }
    }

    protected void notify(String cookie) {
        this.notify(null, cookie);
    }

    protected void notify(String s, int what, int arg1) {
        Message msg = Message.obtain((Handler)this.simpleHandler, (int)what, (int)arg1, (int)-1, (Object)s);
        if (msg != null) {
            msg.sendToTarget();
        }
    }

    protected void notify(String s, int what) {
        this.notify(s, what, -1);
    }

    protected void notify(int what) {
        this.notify(null, what, -1);
    }

    protected void notifyRefr(String item_name) {
        Message msg = this.readerHandler.obtainMessage(-4, null);
        if (msg != null) {
            Bundle b = new Bundle();
            b.putString("posto", item_name);
            msg.setData(b);
            msg.sendToTarget();
        }
    }

    protected void notifyNav(Uri uri) {
        Message msg = this.readerHandler.obtainMessage(-4, null);
        if (msg != null) {
            Bundle b = new Bundle();
            b.putParcelable("uri", (Parcelable)uri);
            msg.setData(b);
            msg.sendToTarget();
        }
    }

    protected boolean notErr() {
        this.notify(this.s(2131362057), -2);
        return false;
    }

    protected final String createTempDir() {
        return Utils.createTempDir(this.ctx).getAbsolutePath();
    }

    public int getCount() {
        return this.numItems;
    }

    public void setCount(int n) {
        this.numItems = n;
        this.notifyDataSetChanged();
    }

    public long getItemId(int position) {
        return position;
    }

    public View getView(int position, View convertView, ViewGroup parent) {
        CommanderAdapter.Item item = (CommanderAdapter.Item)this.getItem(position);
        if (item == null) {
            return null;
        }
        ListView flv = (ListView)parent;
        SparseBooleanArray cis = flv.getCheckedItemPositions();
        item.sel = cis != null ? cis.get(position) : false;
        View v = this.getView(convertView, parent, item);
        if (v == null) {
            Log.e((String)this.TAG, (String)("View for the position " + position + " is null!"));
        }
        return v;
    }

    protected String getLocalDateTimeStr(Date date) {
        try {
            return this.localeDateFormat.format(date) + " " + this.localeTimeFormat.format(date);
        }
        catch (Exception e) {
            e.printStackTrace();
            return "(ERR)";
        }
    }

    protected int getPredictedAttributesLength() {
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected View getView(View convertView, ViewGroup parent, CommanderAdapter.Item item) {
        View row_view = null;
        try {
            int fg_color;
            boolean current_wide;
            int parent_width = parent.getWidth();
            boolean recalc = this.dirty || this.parentWidth != parent_width;
            this.parentWidth = parent_width;
            this.dirty = false;
            boolean wm = (this.mode & 1) == 1;
            boolean dm = (this.mode & 2) == 2;
            boolean ao = (0x200 & this.mode) != 0;
            boolean bl = current_wide = convertView != null && convertView.getId() == 2131230876;
            if (convertView == null || wm && !current_wide || !wm && current_wide) {
                row_view = this.mInflater.inflate(wm ? 2130903059 : 2130903051, parent, false);
            } else {
                row_view = convertView;
                row_view.setBackgroundColor(0);
            }
            boolean fat = (this.mode & 4) == 4;
            boolean LEFT_P = true;
            int RIGHT_P = 2;
            ImageView imgView = (ImageView)row_view.findViewById(2131230824);
            TextView nameView = (TextView)row_view.findViewById(2131230825);
            TextView attrView = (TextView)row_view.findViewById(2131230828);
            TextView dateView = (TextView)row_view.findViewById(2131230826);
            TextView sizeView = (TextView)row_view.findViewById(2131230827);
            float fnt_sz_rdc = (float)this.font_size * 0.75f;
            String name = item.name;
            String size = "";
            String date = "";
            if (dm) {
                if (item.size >= 0L) {
                    size = Utils.getHumanSize(item.size);
                }
                String MDHM_date_frm = "MMM dd kk:mm";
                if (item.date != null) {
                    if (long_date) {
                        date = this.getLocalDateTimeStr(item.date);
                    } else {
                        String dateFormat = item.date.getYear() + 1900 == Calendar.getInstance().get(1) ? "MMM dd kk:mm" : "MMM dd yyyy ";
                        date = (String)DateFormat.format((CharSequence)dateFormat, (Date)item.date);
                    }
                }
                if (recalc) {
                    if (ao) {
                        this.sizeWidth = 0;
                        this.dateWidth = 0;
                        this.attrWidth = wm ? (parent_width - this.icoWidth) / 2 : parent_width - 1 - 2 - this.icoWidth;
                    } else {
                        if (dateView != null) {
                            String sample_date;
                            dateView.setTextSize(fnt_sz_rdc);
                            String string2 = sample_date = long_date ? "M" + this.getLocalDateTimeStr(new Date(-1L)) : "MMM dd kk:mm";
                            if (wm) {
                                sample_date = sample_date + "M";
                            }
                            this.dateWidth = (int)dateView.getPaint().measureText(sample_date);
                        }
                        if (sizeView != null) {
                            sizeView.setTextSize(fnt_sz_rdc);
                            this.sizeWidth = (int)sizeView.getPaint().measureText("99999.9M");
                        }
                        if (attrView != null) {
                            int al = this.getPredictedAttributesLength();
                            if (al > 0) {
                                char[] dummy = new char[al];
                                Arrays.fill(dummy, 'c');
                                if (this instanceof RootAdapter) {
                                    attrView.setTypeface(Typeface.create((String)"monospace", (int)0));
                                    attrView.setTextSize(fnt_sz_rdc * 0.9f);
                                } else {
                                    attrView.setTextSize(fnt_sz_rdc);
                                }
                                this.attrWidth = (int)attrView.getPaint().measureText(new String(dummy));
                                if (!wm) {
                                    int remain = parent_width - this.sizeWidth - this.dateWidth - this.icoWidth - 1 - 2;
                                    this.a3r = this.attrWidth > remain;
                                    this.attrWidth = remain;
                                    if (this.a3r) {
                                        this.attrWidth += this.sizeWidth + this.dateWidth;
                                    }
                                }
                            } else {
                                this.attrWidth = 0;
                            }
                        }
                    }
                }
            }
            if (item.sel && ck != null) {
                row_view.setBackgroundColor(CommanderAdapterBase.ck.selColor & 0xCFFFFFFF);
            }
            int img_width = this.icoWidth;
            if (imgView != null) {
                if (this.icoWidth > 0) {
                    Object th;
                    imgView.setVisibility(0);
                    boolean th_ok = false;
                    if (item.isThumbNail() && (item.thumb_is_icon || this.thumbnail_size_perc > 0) && (th = item.getThumbNail()) != null) {
                        if (!item.thumb_is_icon) {
                            img_width = this.imgWidth;
                        }
                        RelativeLayout.LayoutParams rllp = (RelativeLayout.LayoutParams)imgView.getLayoutParams();
                        rllp.width = img_width;
                        rllp.height = -2;
                        imgView.setImageDrawable(th);
                        imgView.requestLayout();
                        imgView.invalidate();
                        th_ok = true;
                    }
                    if (!th_ok) {
                        if (this.thumbnail_size_perc > 0 && !item.no_thumb && (this.mode & 0x10000) == 0) {
                            th = this;
                            synchronized (th) {
                                item.need_thumb = true;
                                this.notifyAll();
                            }
                        }
                        try {
                            RelativeLayout.LayoutParams rllp = (RelativeLayout.LayoutParams)imgView.getLayoutParams();
                            rllp.width = img_width;
                            rllp.height = -2;
                            int ico_id = item.icon_id != -1 ? item.icon_id : (SLS.equals(item.name) || PLS.equals(item.name) ? 2130837548 : (item.dir ? 2130837516 : CommanderAdapterBase.getIconId(name)));
                            imgView.setImageResource(ico_id);
                        }
                        catch (OutOfMemoryError e) {
                            Log.e((String)this.TAG, (String)"", (Throwable)e);
                        }
                    }
                } else {
                    imgView.setVisibility(8);
                }
            }
            int fg_color_m = fg_color = ck != null ? (item.sel ? CommanderAdapterBase.ck.sfgColor : CommanderAdapterBase.ck.fgrColor) : this.ctx.getResources().getColor(2131165187);
            if (!item.sel) {
                if (name == null || item.colorCache != 0) {
                    fg_color_m = item.colorCache;
                } else {
                    try {
                        for (int i = 0; i < typeColors.length; ++i) {
                            for (int j = 0; j < filePatterns[i].length; ++j) {
                                Pattern fp = filePatterns[i][j];
                                Matcher m = fp.matcher(name);
                                if (m == null || !m.matches()) continue;
                                item.colorCache = fg_color_m = typeColors[i];
                                break;
                            }
                            if (fg_color_m == fg_color) {
                                continue;
                            }
                            break;
                        }
                    }
                    catch (Exception e) {
                        Log.e((String)this.TAG, (String)("file: " + name), (Throwable)e);
                    }
                }
            }
            if (nameView != null) {
                nameView.setTextSize(1, (float)this.font_size);
                if (wm) {
                    this.nameWidth = parent_width - img_width - this.dateWidth - this.sizeWidth - this.attrWidth - 1 - 2;
                    if (this.nameWidth < 280) {
                        this.nameWidth += this.attrWidth;
                        this.attrWidth = 0;
                    }
                    int nw = this.nameWidth;
                    if (!Utils.str(item.attr)) {
                        nw += this.attrWidth;
                    }
                    nameView.setWidth(nw);
                }
                nameView.setText((CharSequence)(name != null ? name : "???"));
                nameView.setTextColor(fg_color_m);
            }
            if (dateView != null) {
                boolean vis = dm && !ao && this.dateWidth > 0;
                dateView.setVisibility(vis ? 0 : 8);
                if (vis) {
                    dateView.setTextSize(fnt_sz_rdc);
                    dateView.setWidth(this.dateWidth);
                    dateView.setText((CharSequence)date);
                    dateView.setTextColor(fg_color_m);
                }
            }
            if (sizeView != null) {
                boolean vis = dm && !ao && this.sizeWidth > 0;
                sizeView.setVisibility(vis ? 0 : 8);
                if (vis) {
                    sizeView.setTextSize(fnt_sz_rdc);
                    sizeView.setWidth(this.sizeWidth);
                    sizeView.setText((CharSequence)size);
                    sizeView.setTextColor(fg_color_m);
                }
            }
            if (attrView != null) {
                boolean vis = dm && this.attrWidth > 0;
                attrView.setVisibility(vis ? 0 : 8);
                if (vis) {
                    String attr_text;
                    String string3 = attr_text = item.attr != null ? item.attr.trim() : "";
                    if (!wm) {
                        RelativeLayout.LayoutParams rllp = new RelativeLayout.LayoutParams(-2, -2);
                        if (this.a3r) {
                            rllp.addRule(11);
                            rllp.addRule(3, 2131230826);
                            attrView.setGravity(5);
                        } else {
                            rllp.addRule(3, 2131230825);
                            rllp.addRule(5, 2131230825);
                            rllp.addRule(6, 2131230827);
                            attrView.setGravity(3);
                        }
                        attrView.setLayoutParams((ViewGroup.LayoutParams)rllp);
                    }
                    if (Utils.str(item.attr)) {
                        attrView.setWidth(this.attrWidth);
                        attrView.setTextSize(fnt_sz_rdc);
                        attrView.setVisibility(0);
                        attrView.setText((CharSequence)attr_text);
                        attrView.setTextColor(fg_color_m);
                        if (this instanceof RootAdapter) {
                            attrView.setTypeface(Typeface.create((String)"monospace", (int)0));
                            attrView.setTextSize(fnt_sz_rdc * 0.9f);
                        }
                    } else {
                        attrView.setWidth(0);
                        attrView.setText((CharSequence)attr_text);
                    }
                }
            }
            if (fat) {
                int vp = (int)(5.0f * this.density);
                row_view.setPadding(1, vp, 2, vp);
            } else {
                row_view.setPadding(1, 3, 2, 3);
            }
            row_view.setTag(null);
        }
        catch (Exception e) {
            Log.e((String)this.TAG, null, (Throwable)e);
        }
        return row_view;
    }

    public FilterProps getFilter() {
        return this.filter;
    }

    public void cancelFilter() {
        this.filter = null;
    }

    public void setFilter(FilterProps filter) {
        this.filter = filter;
    }

    public static final int getIconId(String file) {
        String cat = Utils.getCategoryByExt(Utils.getFileExt(file));
        if ("u".equals(cat)) {
            return 2130837547;
        }
        if ("a".equals(cat)) {
            return 2130837508;
        }
        if ("v".equals(cat)) {
            return 2130837550;
        }
        if ("i".equals(cat)) {
            return 2130837528;
        }
        if ("t".equals(cat)) {
            return 2130837544;
        }
        if ("b".equals(cat)) {
            return 2130837510;
        }
        if ("o".equals(cat)) {
            return 2130837510;
        }
        if ("p".equals(cat)) {
            return 2130837535;
        }
        if ("z".equals(cat)) {
            return 2130837553;
        }
        if ("m".equals(cat)) {
            return 2130837552;
        }
        if ("x".equals(cat)) {
            return 2130837507;
        }
        if ("d".equals(cat)) {
            return 2130837504;
        }
        return 2130837547;
    }

    protected final String[] bitsToNames(SparseBooleanArray cis) {
        try {
            int counter = 0;
            for (int i = 0; i < cis.size(); ++i) {
                if (!cis.valueAt(i)) continue;
                ++counter;
            }
            String[] paths = new String[counter];
            int j = 0;
            for (int i = 0; i < cis.size(); ++i) {
                if (!cis.valueAt(i)) continue;
                paths[j++] = this.getItemName(cis.keyAt(i), true);
            }
            return paths;
        }
        catch (Exception e) {
            Log.e((String)this.TAG, (String)"bitsToNames()", (Throwable)e);
            return null;
        }
    }

    public Uri getItemUri(int position) {
        return null;
    }

    public boolean hasFeature(CommanderAdapter.Feature feature) {
        switch (feature) {
            case F1: 
            case F9: 
            case F10: 
            case EQ: 
            case TGL: 
            case HOME: 
            case ENTER: 
            case ADD_FAV: 
            case FAVS: 
            case SDCARD: 
            case ROOT: 
            case SOFTKBD: 
            case SORTING: 
            case MENU: 
            case SCROLL: {
                return true;
            }
            case BY_NAME: 
            case BY_EXT: 
            case BY_SIZE: 
            case BY_DATE: {
                return this.hasFeature(CommanderAdapter.Feature.SORTING);
            }
            case F2: 
            case F3: 
            case F4: 
            case F5: 
            case F6: 
            case F7: 
            case F8: 
            case SZ: 
            case SEL_UNS: 
            case HIDDEN: 
            case REFRESH: 
            case CHKBL: {
                return this.hasFeature(CommanderAdapter.Feature.REAL);
            }
            case REAL: {
                return false;
            }
        }
        return false;
    }

    public void populateContextMenu(ContextMenu menu2, AdapterView.AdapterContextMenuInfo acmi, int num) {
        try {
            boolean file;
            CommanderAdapter.Item item = (CommanderAdapter.Item)this.getItem(acmi.position);
            boolean bl = file = !item.dir && acmi.position != 0;
            if (acmi.position == 0) {
                menu2.add(0, 2131230737, 0, 2131361820);
                return;
            }
            if (this.hasFeature(CommanderAdapter.Feature.SZ)) {
                menu2.add(0, 2131230741, 0, 2131361905);
            }
            if (num <= 1) {
                if (this.hasFeature(CommanderAdapter.Feature.F2)) {
                    menu2.add(0, 2131230722, 0, 2131361962);
                }
                if (file) {
                    if (this.hasFeature(CommanderAdapter.Feature.F3)) {
                        menu2.add(0, 2131230724, 0, 2131361954);
                    }
                    if (this.hasFeature(CommanderAdapter.Feature.F4)) {
                        menu2.add(0, 2131230726, 0, 2131361955);
                    }
                }
            }
            if (this.hasFeature(CommanderAdapter.Feature.LOCAL) && file) {
                menu2.add(0, 236, 0, 2131361906);
            }
            if (this.hasFeature(CommanderAdapter.Feature.F5)) {
                menu2.add(0, 2131230729, 0, 2131361964);
            }
            if (this.hasFeature(CommanderAdapter.Feature.F6)) {
                menu2.add(0, 2131230731, 0, 2131361965);
            }
            if (this.hasFeature(CommanderAdapter.Feature.F8)) {
                menu2.add(0, 2131230734, 0, 2131361986);
            }
            if (this.hasFeature(CommanderAdapter.Feature.LOCAL)) {
                if (file && num <= 1) {
                    menu2.add(0, 902, 0, 2131361907);
                }
                menu2.add(0, 2131230924, 0, 2131361903);
            }
            if (num <= 1) {
                menu2.add(0, 390, 0, 2131361910);
                if (this.hasFeature(CommanderAdapter.Feature.LOCAL)) {
                    menu2.add(0, 269, 0, 2131361875);
                }
            }
            if (acmi.position != 0 && item.dir && num == 1) {
                menu2.add(0, 414, 0, (CharSequence)this.ctx.getString(2131361911, new Object[]{item.name}));
                menu2.add(0, 2131230738, 0, (CharSequence)this.ctx.getString(2131361821, new Object[]{item.name}));
            }
        }
        catch (Exception e) {
            Log.e((String)this.TAG, (String)("populateContextMenu() " + e.getMessage()), (Throwable)e);
        }
    }

    public void setCredentials(Credentials crd) {
    }

    public Credentials getCredentials() {
        return null;
    }

    public void doIt(int command_id, SparseBooleanArray cis) {
    }

    public boolean handleActivityResult(int requestCode, int resultCode, Intent data) {
        return false;
    }

    public boolean renameItems(SparseBooleanArray cis, String pattern, String replace_to) {
        return false;
    }

    public CommanderAdapter.Item getItem(Uri u) {
        return null;
    }

    public InputStream getContent(Uri u, long skip) {
        return null;
    }

    public InputStream getContent(Uri u) {
        return this.getContent(u, 0L);
    }

    public OutputStream saveContent(Uri u) {
        return null;
    }

    public void closeStream(Closeable is) {
        try {
            if (is != null) {
                is.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public Engines.IReciever getReceiver() {
        return null;
    }

    protected void reSort() {
    }

    protected final String s(int r_id) {
        return this.ctx.getString(r_id);
    }

    static {
        typeColors = new int[0];
        filePatterns = new Pattern[0][];
    }

    protected class SimpleHandler
    extends Handler {
        protected SimpleHandler() {
        }

        public void handleMessage(Message msg) {
            CommanderAdapterBase.this.commander.notifyMe(msg);
        }
    }

    protected class ReaderHandler
    extends Handler {
        protected ReaderHandler() {
        }

        public void handleMessage(Message msg) {
            try {
                if (msg.what <= -2) {
                    CommanderAdapterBase.this.onReadComplete();
                    CommanderAdapterBase.this.reader = null;
                }
                CommanderAdapterBase.this.commander.notifyMe(msg);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

