/*
 * Decompiled with CFR 0.152.
 */
package com.ghostsq.commander.adapters;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.net.Uri;
import android.os.Environment;
import android.util.Log;
import com.ghostsq.commander.Commander;
import com.ghostsq.commander.adapters.AppsAdapter;
import com.ghostsq.commander.adapters.CommanderAdapter;
import com.ghostsq.commander.adapters.ContentAdapter;
import com.ghostsq.commander.adapters.FSAdapter;
import com.ghostsq.commander.adapters.FTPAdapter;
import com.ghostsq.commander.adapters.FavsAdapter;
import com.ghostsq.commander.adapters.FindAdapter;
import com.ghostsq.commander.adapters.HomeAdapter;
import com.ghostsq.commander.adapters.MSAdapter;
import com.ghostsq.commander.adapters.SAFAdapter;
import com.ghostsq.commander.adapters.ZipAdapter;
import com.ghostsq.commander.root.MountAdapter;
import com.ghostsq.commander.root.RootAdapter;
import com.ghostsq.commander.utils.Utils;
import dalvik.system.DexClassLoader;
import java.io.File;
import java.lang.reflect.Method;

public final class CA {
    public static final String TAG = "CA";
    protected static final int home_schema_h = "home".hashCode();
    protected static final int zip_schema_h = "zip".hashCode();
    protected static final int ftp_schema_h = "ftp".hashCode();
    protected static final int sftp_schema_h = "sftp".hashCode();
    protected static final int smb_schema_h = "smb".hashCode();
    protected static final int find_schema_h = "find".hashCode();
    protected static final int root_schema_h = "root".hashCode();
    protected static final int mnt_schema_h = "mount".hashCode();
    protected static final int apps_schema_h = "apps".hashCode();
    protected static final int favs_schema_h = "favs".hashCode();
    protected static final int file_schema_h = "file".hashCode();
    protected static final int ms_schema_h = "ms".hashCode();
    protected static final int content_schema_h = "content".hashCode();

    public static final boolean isLocal(String scheme) {
        return scheme == null || scheme.length() == 0 || "file".equals(scheme) || "find".equals(scheme);
    }

    public static final CommanderAdapter CreateAdapter(Uri uri, Commander c) {
        CommanderAdapter ca = CA.CreateAdapterInstance(uri, c.getContext());
        if (ca != null) {
            ca.Init(c);
        }
        return ca;
    }

    public static final CommanderAdapter CreateAdapterInstance(Uri uri, Context c) {
        String scheme = uri.getScheme();
        if (!Utils.str(scheme)) {
            return new FSAdapter(c);
        }
        int scheme_h = scheme.hashCode();
        if (file_schema_h == scheme_h) {
            return new FSAdapter(c);
        }
        if (home_schema_h == scheme_h) {
            return new HomeAdapter(c);
        }
        if (zip_schema_h == scheme_h) {
            return new ZipAdapter(c);
        }
        if (ftp_schema_h == scheme_h) {
            return new FTPAdapter(c);
        }
        if (find_schema_h == scheme_h) {
            return new FindAdapter(c);
        }
        if (root_schema_h == scheme_h) {
            return new RootAdapter(c);
        }
        if (mnt_schema_h == scheme_h) {
            return new MountAdapter(c);
        }
        if (apps_schema_h == scheme_h) {
            return new AppsAdapter(c);
        }
        if (favs_schema_h == scheme_h) {
            return new FavsAdapter(c);
        }
        if (ms_schema_h == scheme_h) {
            return new MSAdapter(c);
        }
        if (content_schema_h == scheme_h) {
            if (SAFAdapter.isExternalStorageDocument(uri)) {
                return new SAFAdapter(c);
            }
            return new ContentAdapter(c);
        }
        CommanderAdapter ca = CA.CreateExternalAdapter(c, scheme);
        return ca == null ? new FSAdapter(c) : ca;
    }

    @SuppressLint(value={"NewApi"})
    public static CommanderAdapter CreateExternalAdapter(Context ctx, String scheme) {
        try {
            File dex_f = ctx.getDir(scheme, 0);
            if (dex_f == null || !dex_f.exists()) {
                Log.w((String)TAG, (String)"app.data storage is not accessable, trying to use the SD card");
                File sd = Environment.getExternalStorageDirectory();
                if (sd == null) {
                    return null;
                }
                dex_f = new File(sd, "temp");
                if (!dex_f.exists()) {
                    dex_f.mkdir();
                }
            }
            String pkg_name = "com.ghostsq.commander." + ("smb".equals(scheme) ? "samba" : scheme);
            ApplicationInfo ai = ctx.getPackageManager().getApplicationInfo(pkg_name, 0);
            Log.i((String)TAG, (String)(scheme + " package is " + ai.sourceDir));
            ClassLoader pcl = ctx.getClass().getClassLoader();
            DexClassLoader cl = new DexClassLoader(ai.sourceDir, dex_f.getAbsolutePath(), null, pcl);
            Class creatorClass = cl.loadClass(pkg_name + "." + scheme);
            Log.i((String)TAG, (String)("Class has been loaded " + creatorClass.toString()));
            try {
                File[] list = dex_f.listFiles();
                for (int i = 0; i < list.length; ++i) {
                    list[i].delete();
                }
            }
            catch (Exception e) {
                Log.w((String)TAG, (String)"Can't remove the plugin's .dex: ", (Throwable)e);
            }
            Method cim = creatorClass.getMethod("createInstance", Context.class);
            if (cim != null) {
                return (CommanderAdapter)cim.invoke(null, ctx);
            }
        }
        catch (Throwable e) {
            Log.e((String)TAG, (String)("This class can't be created: " + scheme), (Throwable)e);
        }
        return null;
    }

    public static final int getDrawableIconId(String scheme) {
        if (!Utils.str(scheme)) {
            return 2130837516;
        }
        int scheme_h = scheme.hashCode();
        if (home_schema_h == scheme_h) {
            return 2130837527;
        }
        if (zip_schema_h == scheme_h) {
            return 2130837553;
        }
        if (ftp_schema_h == scheme_h) {
            return 2130837518;
        }
        if (sftp_schema_h == scheme_h) {
            return 2130837541;
        }
        if (smb_schema_h == scheme_h) {
            return 2130837542;
        }
        if (root_schema_h == scheme_h) {
            return 2130837537;
        }
        if (mnt_schema_h == scheme_h) {
            return 2130837531;
        }
        if (apps_schema_h == scheme_h) {
            return 2130837505;
        }
        return 2130837516;
    }
}

