/*
 * Decompiled with CFR 0.152.
 */
package com.ghostsq.commander;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.net.Uri;
import android.os.Bundle;
import android.os.Parcelable;
import android.preference.PreferenceManager;
import android.util.Log;
import android.view.View;
import android.widget.ArrayAdapter;
import android.widget.AutoCompleteTextView;
import android.widget.Button;
import android.widget.CheckBox;
import android.widget.CompoundButton;
import android.widget.EditText;
import android.widget.Spinner;
import android.widget.SpinnerAdapter;
import com.ghostsq.commander.utils.Credentials;
import com.ghostsq.commander.utils.ForwardCompat;
import com.ghostsq.commander.utils.Utils;
import java.util.HashSet;
import java.util.Set;

public class ServerForm
extends Activity
implements View.OnClickListener,
CompoundButton.OnCheckedChangeListener {
    private static final String TAG = "ServerForm";
    public static final String ADD_FAVE_KEY = "ADD_FAVE";
    public static final String COMMENT_KEY = "COMMENT";
    private Type type;
    private String schema;
    private ArrayAdapter<String> server_history_adapter;
    private AutoCompleteTextView server_edit;
    private EditText path_edit;
    private EditText domain_edit;
    private EditText name_edit;
    private CheckBox active_ftp_cb;
    private CheckBox add_fave_cb;
    private Spinner encoding_spin;
    private View domain_block;
    private View comment_block;

    public void onCreate(Bundle savedInstanceState) {
        try {
            SharedPreferences shared_pref = PreferenceManager.getDefaultSharedPreferences((Context)this);
            Utils.setDialogTheme((Context)this, shared_pref.getString("color_themes", "d"));
            super.onCreate(savedInstanceState);
            this.schema = this.getIntent().getStringExtra("schema");
            if (!Utils.str(this.schema)) {
                Log.e((String)TAG, (String)"No schema given");
                this.finish();
                return;
            }
            this.type = Type.getInstance(this.schema);
            this.requestWindowFeature(3);
            this.setContentView(2130903062);
            this.getWindow().setLayout(-1, -2);
            this.getWindow().setFeatureDrawableResource(3, this.type == Type.SMB ? 2130837542 : 2130837540);
            String title = this.type != null ? this.type.title : this.getIntent().getStringExtra("title");
            this.setTitle(this.getString(2131362078) + " " + title);
            this.server_edit = (AutoCompleteTextView)this.findViewById(2131230885);
            this.server_history_adapter = new ArrayAdapter((Context)this, 17367043);
            this.server_edit.setAdapter(this.server_history_adapter);
            this.server_edit.requestFocus();
            this.path_edit = (EditText)this.findViewById(2131230887);
            this.domain_edit = (EditText)this.findViewById(2131230891);
            this.domain_block = this.findViewById(2131230888);
            this.name_edit = (EditText)this.findViewById(2131230815);
            this.active_ftp_cb = (CheckBox)this.findViewById(2131230894);
            this.encoding_spin = (Spinner)this.findViewById(2131230832);
            this.add_fave_cb = (CheckBox)this.findViewById(2131230895);
            this.comment_block = this.findViewById(2131230896);
            this.add_fave_cb.setOnCheckedChangeListener((CompoundButton.OnCheckedChangeListener)this);
            View ftp_block = this.findViewById(2131230893);
            if (this.type == Type.FTP) {
                ArrayAdapter adapter = ArrayAdapter.createFromResource((Context)this, (int)2131296263, (int)17367048);
                adapter.setDropDownViewResource(0x1090009);
                this.encoding_spin.setAdapter((SpinnerAdapter)adapter);
            }
            Button connect_button = (Button)this.findViewById(2131230833);
            connect_button.setOnClickListener((View.OnClickListener)this);
            Button browse_button = (Button)this.findViewById(2131230889);
            browse_button.setOnClickListener((View.OnClickListener)this);
            Button cancel_button = (Button)this.findViewById(2131230834);
            cancel_button.setOnClickListener((View.OnClickListener)this);
            ftp_block.setVisibility(this.type == Type.FTP ? 0 : 8);
            this.domain_block.setVisibility(this.type == Type.SMB ? 0 : 8);
            this.add_fave_cb.setVisibility(0);
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"onCreate() Exception: ", (Throwable)e);
        }
    }

    protected void onStart() {
        try {
            super.onStart();
            SharedPreferences prefs = this.getPreferences(0);
            this.server_edit.setText((CharSequence)prefs.getString(this.schema + "_SERV", ""));
            this.path_edit.setText((CharSequence)prefs.getString(this.schema + "_PATH", "/"));
            this.domain_edit.setText((CharSequence)prefs.getString(this.schema + "_DOMAIN", ""));
            this.name_edit.setText((CharSequence)prefs.getString(this.schema + "_USER", ""));
            this.active_ftp_cb.setChecked(prefs.getBoolean(this.schema + "_ACTIVE", false));
            this.encoding_spin.setSelection(prefs.getInt(this.schema + "_ENCODING", 0));
            Set<String> hist_set = ForwardCompat.getStringSet(prefs, this.schema + "_SERV_HIST");
            if (hist_set != null) {
                for (String s : hist_set) {
                    this.server_history_adapter.add((Object)s);
                }
            }
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"onStart() Exception: ", (Throwable)e);
        }
    }

    protected void onPause() {
        try {
            super.onPause();
            SharedPreferences.Editor editor = this.getPreferences(0).edit();
            editor.putString(this.schema + "_SERV", this.server_edit.getText().toString());
            editor.putString(this.schema + "_PATH", this.path_edit.getText().toString());
            editor.putString(this.schema + "_DOMAIN", this.domain_edit.getText().toString());
            editor.putString(this.schema + "_USER", this.name_edit.getText().toString());
            editor.putBoolean(this.schema + "_ACTIVE", this.active_ftp_cb.isChecked());
            editor.putInt(this.schema + "_ENCODING", this.encoding_spin.getSelectedItemPosition());
            editor.commit();
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"onPause() Exception: ", (Throwable)e);
        }
    }

    protected void storeHistory() {
        try {
            SharedPreferences prefs = this.getPreferences(0);
            SharedPreferences.Editor editor = prefs.edit();
            Set<String> hist_set = ForwardCompat.getStringSet(prefs, this.schema + "_SERV_HIST");
            if (hist_set == null) {
                hist_set = new HashSet<String>();
            }
            hist_set.add(this.server_edit.getText().toString());
            ForwardCompat.putStringSet(editor, this.schema + "_SERV_HIST", hist_set);
            editor.commit();
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"onPause() Exception: ", (Throwable)e);
        }
    }

    protected void onSaveInstanceState(Bundle outState) {
        try {
            outState.putString(this.schema + "_SERV", this.server_edit.getText().toString());
            outState.putString(this.schema + "_PATH", this.path_edit.getText().toString());
            outState.putString(this.schema + "_USER", this.name_edit.getText().toString());
            outState.putString(this.schema + "_DOMAIN", this.domain_edit.getText().toString());
            outState.putBoolean(this.schema + "_ACTIVE", this.active_ftp_cb.isChecked());
            outState.putInt(this.schema + "_ENCODING", this.encoding_spin.getSelectedItemPosition());
            super.onSaveInstanceState(outState);
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"onSaveInstanceState() Exception: ", (Throwable)e);
        }
    }

    protected void onRestoreInstanceState(Bundle savedInstanceState) {
        try {
            this.server_edit.setText((CharSequence)savedInstanceState.getString(this.schema + "_SERV"));
            this.path_edit.setText((CharSequence)savedInstanceState.getString(this.schema + "_PATH"));
            this.name_edit.setText((CharSequence)savedInstanceState.getString(this.schema + "_USER"));
            this.domain_edit.setText((CharSequence)savedInstanceState.getString(this.schema + "_DOMAIN"));
            this.active_ftp_cb.setChecked(savedInstanceState.getBoolean(this.schema + "_ACTIVE", false));
            this.encoding_spin.setSelection(savedInstanceState.getInt(this.schema + "_ENCODING", 0));
            super.onRestoreInstanceState(savedInstanceState);
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"onRestoreInstanceState() Exception: ", (Throwable)e);
        }
    }

    public void onClick(View v) {
        try {
            if (v.getId() == 2131230889) {
                if (this.type == Type.SMB) {
                    this.setResult(-1, new Intent("com.ghostsq.commander.NAVIGATE", Uri.parse((String)"smb://")));
                }
            } else if (v.getId() == 2131230833) {
                int current_panel;
                EditText pass_edit = (EditText)this.findViewById(2131230817);
                String user = this.name_edit.getText().toString().trim();
                String pass = pass_edit.getText().toString().trim();
                Credentials crd = null;
                if (user.length() > 0) {
                    EditText domain_edit;
                    String domain;
                    if (this.type == Type.SMB && (domain = (domain_edit = (EditText)this.findViewById(2131230891)).getText().toString().trim()).length() > 0) {
                        user = domain + ";" + user;
                    }
                    crd = new Credentials(user, pass);
                }
                Uri.Builder uri_b = new Uri.Builder().scheme(this.schema).encodedAuthority(Utils.encodeToAuthority(this.server_edit.getText().toString().trim())).path(this.path_edit.getText().toString().trim());
                if (this.type == Type.FTP) {
                    String enc_s;
                    Object esio;
                    if (this.active_ftp_cb.isChecked()) {
                        uri_b.appendQueryParameter("a", "true");
                    }
                    if ((esio = this.encoding_spin.getSelectedItem()) instanceof String && Utils.str(enc_s = (String)esio) && !"Default".equals(enc_s)) {
                        enc_s = enc_s.substring(0, enc_s.indexOf("\n"));
                        uri_b.appendQueryParameter("e", enc_s);
                    }
                }
                Intent in = new Intent("com.ghostsq.commander.NAVIGATE", uri_b.build());
                if (crd != null) {
                    in.putExtra(Credentials.KEY, (Parcelable)crd);
                }
                if (this.add_fave_cb.isChecked()) {
                    in.putExtra(ADD_FAVE_KEY, true);
                    EditText cmt = (EditText)this.comment_block.findViewById(2131230897);
                    in.putExtra(COMMENT_KEY, cmt.getText().toString());
                }
                if ((current_panel = this.getIntent().getIntExtra("current_panel", -1)) >= 0) {
                    in.putExtra("current_panel", current_panel);
                }
                this.setResult(-1, in);
                this.storeHistory();
            } else {
                this.setResult(0);
            }
            this.finish();
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"onClick() Exception: ", (Throwable)e);
        }
    }

    public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
        this.comment_block.setVisibility(isChecked ? 0 : 8);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Type {
        FTP("ftp", "FTP"),
        SFTP("sftp", "SSH FTP"),
        SMB("smb", "Windows PC");

        public String schema;
        public String title;

        private Type(String schema_, String title_) {
            this.schema = schema_;
            this.title = title_;
        }

        public static Type getInstance(String s) {
            if (s.equals(Type.FTP.schema)) {
                return FTP;
            }
            if (s.equals(Type.SFTP.schema)) {
                return SFTP;
            }
            if (s.equals(Type.SMB.schema)) {
                return SMB;
            }
            return null;
        }
    }
}

