/*
 * Decompiled with CFR 0.152.
 */
package com.ghostsq.commander;

import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.graphics.drawable.ClipDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.graphics.drawable.LayerDrawable;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.CheckBox;
import android.widget.CompoundButton;
import android.widget.LinearLayout;
import android.widget.SeekBar;
import com.ghostsq.commander.utils.Utils;

public class SelZoneDialog
extends AlertDialog
implements DialogInterface.OnClickListener,
CompoundButton.OnCheckedChangeListener,
SeekBar.OnSeekBarChangeListener {
    private static final String TAG = "SelZone";
    private ResultSink sink;
    private Context context;
    private LinearLayout layout;
    private CheckBox r_cb;
    private SeekBar width_seek;
    private int width;
    private int sel_color;
    private int bg_color;
    private boolean atRight;

    SelZoneDialog(Context c, ResultSink sink_, boolean atRight_, int width_, int sel_color_, int bg_color_) {
        super(c);
        this.context = c;
        this.sink = sink_;
        this.width = width_;
        this.atRight = atRight_;
        this.sel_color = sel_color_;
        this.bg_color = bg_color_;
        this.setTitle(c.getString(2131362087));
        LayoutInflater factory = LayoutInflater.from((Context)c);
        this.setView(factory.inflate(2130903061, null));
        this.setButton(-1, c.getString(2131361929), this);
        this.setButton(-2, c.getString(2131361930), this);
    }

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.layout = (LinearLayout)this.findViewById(2131230880);
        this.r_cb = (CheckBox)this.findViewById(2131230881);
        if (this.r_cb != null) {
            this.r_cb.setOnCheckedChangeListener((CompoundButton.OnCheckedChangeListener)this);
            this.r_cb.setChecked(this.atRight);
        }
        this.width_seek = (SeekBar)this.findViewById(2131230882);
        if (this.width_seek != null) {
            this.width_seek.setProgressDrawable((Drawable)this.createSeekBarDrawable(this.sel_color));
            this.width_seek.setOnSeekBarChangeListener((SeekBar.OnSeekBarChangeListener)this);
            this.width_seek.setProgress(this.width);
        }
    }

    private final LayerDrawable createSeekBarDrawable(int fg_color) {
        LayerDrawable ld = null;
        try {
            Drawable[] list = new Drawable[2];
            GradientDrawable bg = Utils.getShadingEx(this.atRight ? fg_color : this.bg_color, 0.6f);
            bg.setCornerRadius(5.0f);
            list[0] = bg;
            GradientDrawable fg = Utils.getShadingEx(this.atRight ? this.bg_color : fg_color, 0.6f);
            fg.setCornerRadius(5.0f);
            list[1] = new ClipDrawable((Drawable)fg, 3, 1);
            ld = new LayerDrawable(list);
            ld.setId(0, 0x1020000);
            ld.setId(1, 16908301);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ld;
    }

    public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
        this.atRight = isChecked;
        if (this.width_seek != null) {
            this.layout.removeView((View)this.width_seek);
            this.width_seek = new SeekBar(this.context);
            LayerDrawable sbd = this.createSeekBarDrawable(this.sel_color);
            this.width_seek.setProgressDrawable((Drawable)sbd);
            this.width_seek.setOnSeekBarChangeListener((SeekBar.OnSeekBarChangeListener)this);
            this.width_seek.setProgress(this.width);
            this.layout.addView((View)this.width_seek);
        }
    }

    public void onProgressChanged(SeekBar seekBar, int progress, boolean fromUser) {
        if (!fromUser) {
            return;
        }
        this.width = progress;
    }

    public void onStartTrackingTouch(SeekBar seekBar) {
    }

    public void onStopTrackingTouch(SeekBar seekBar) {
    }

    public void onClick(DialogInterface dialog, int which) {
        if (which == -1 && this.sink != null) {
            this.sink.selZoneChanged(this.atRight, this.width);
        }
        this.dismiss();
    }

    public static interface ResultSink {
        public void selZoneChanged(boolean var1, int var2);
    }
}

