/*
 * Decompiled with CFR 0.152.
 */
package com.ghostsq.commander;

import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.graphics.Color;
import android.os.Bundle;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.CheckBox;
import android.widget.CompoundButton;
import android.widget.EditText;
import android.widget.SeekBar;
import com.ghostsq.commander.utils.Utils;

public class RGBPickerDialog
extends AlertDialog
implements DialogInterface.OnClickListener,
CompoundButton.OnCheckedChangeListener,
SeekBar.OnSeekBarChangeListener,
View.OnKeyListener {
    private static final String TAG = "RGB";
    private ResultSink colorChangeSink;
    private int curColor;
    private int defColor;
    private CheckBox dccb;
    private View sliders;
    private SeekBar r_seek;
    private SeekBar g_seek;
    private SeekBar b_seek;
    private EditText edit_rgb;
    private View preview;

    RGBPickerDialog(Context context, ResultSink sink, int color2, int def_color, String title) {
        super(context);
        this.colorChangeSink = sink;
        this.curColor = color2;
        this.defColor = def_color;
        Context c = this.getContext();
        String dlg_title = c.getString(2131362178);
        if (Utils.str(title)) {
            dlg_title = dlg_title + ": " + title;
        }
        this.setTitle(dlg_title);
        LayoutInflater factory = LayoutInflater.from((Context)c);
        this.setView(factory.inflate(2130903057, null));
        this.setButton(-1, c.getString(2131361929), this);
        this.setButton(-2, c.getString(2131361930), this);
    }

    protected void onCreate(Bundle savedInstanceState) {
        View dcv;
        super.onCreate(savedInstanceState);
        this.sliders = this.findViewById(2131230864);
        this.r_seek = (SeekBar)this.findViewById(2131230867);
        this.r_seek = (SeekBar)this.findViewById(2131230867);
        this.g_seek = (SeekBar)this.findViewById(2131230870);
        this.b_seek = (SeekBar)this.findViewById(2131230873);
        this.edit_rgb = (EditText)this.findViewById(2131230874);
        if (this.r_seek != null) {
            this.r_seek.setOnSeekBarChangeListener((SeekBar.OnSeekBarChangeListener)this);
            this.r_seek.setProgress(Color.red((int)this.curColor));
        }
        if (this.g_seek != null) {
            this.g_seek.setOnSeekBarChangeListener((SeekBar.OnSeekBarChangeListener)this);
            this.g_seek.setProgress(Color.green((int)this.curColor));
        }
        if (this.b_seek != null) {
            this.b_seek.setOnSeekBarChangeListener((SeekBar.OnSeekBarChangeListener)this);
            this.b_seek.setProgress(Color.blue((int)this.curColor));
        }
        this.edit_rgb.setOnKeyListener((View.OnKeyListener)this);
        this.setEditorValue();
        this.preview = this.findViewById(2131230822);
        if (this.preview != null) {
            this.preview.setBackgroundColor(this.curColor);
        }
        if (this.defColor != 0 && (dcv = this.findViewById(2131230863)) != null) {
            dcv.setVisibility(0);
            this.dccb = (CheckBox)dcv;
            this.dccb.setOnCheckedChangeListener((CompoundButton.OnCheckedChangeListener)this);
            this.dccb.setChecked(this.curColor == 0);
        }
    }

    public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
        if (isChecked) {
            this.curColor = 0;
            this.sliders.setVisibility(8);
        } else {
            if (this.curColor == 0) {
                this.curColor = this.defColor;
                this.setSeekBars();
            }
            this.preview.setBackgroundColor(this.curColor);
            this.sliders.setVisibility(0);
        }
    }

    public void onProgressChanged(SeekBar seekBar, int progress, boolean fromUser) {
        if (!fromUser) {
            return;
        }
        int id2 = seekBar.getId();
        switch (id2) {
            case 2131230867: {
                this.curColor = Color.rgb((int)progress, (int)Color.green((int)this.curColor), (int)Color.blue((int)this.curColor));
                break;
            }
            case 2131230870: {
                this.curColor = Color.rgb((int)Color.red((int)this.curColor), (int)progress, (int)Color.blue((int)this.curColor));
                break;
            }
            case 2131230873: {
                this.curColor = Color.rgb((int)Color.red((int)this.curColor), (int)Color.green((int)this.curColor), (int)progress);
            }
        }
        this.setEditorValue();
        this.preview.setBackgroundColor(this.curColor);
    }

    public void onStartTrackingTouch(SeekBar seekBar) {
    }

    public void onStopTrackingTouch(SeekBar seekBar) {
    }

    public void onClick(DialogInterface dialog, int which) {
        if (which == -1 && this.colorChangeSink != null) {
            this.colorChangeSink.colorChanged(this.curColor);
        }
        this.dismiss();
    }

    public boolean onKey(View v, int keyCode, KeyEvent event) {
        if (this.edit_rgb == null) {
            return false;
        }
        String s = this.edit_rgb.getText().toString();
        try {
            this.curColor = Color.parseColor((String)s);
            this.setSeekBars();
            this.preview.setBackgroundColor(this.curColor);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return false;
    }

    void setSeekBars() {
        this.r_seek.setProgress(Color.red((int)this.curColor));
        this.g_seek.setProgress(Color.green((int)this.curColor));
        this.b_seek.setProgress(Color.blue((int)this.curColor));
    }

    void setEditorValue() {
        this.edit_rgb.setText((CharSequence)("#" + String.format("%02X%02X%02X", Color.red((int)this.curColor), Color.green((int)this.curColor), Color.blue((int)this.curColor))));
    }

    public static interface ResultSink {
        public void colorChanged(int var1);
    }
}

