/*
 * Decompiled with CFR 0.152.
 */
package com.ghostsq.commander;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.AlertDialog;
import android.app.ProgressDialog;
import android.content.ContentResolver;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.SharedPreferences;
import android.database.Cursor;
import android.graphics.Bitmap;
import android.graphics.Matrix;
import android.graphics.PointF;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.AsyncTask;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.os.Parcelable;
import android.preference.PreferenceManager;
import android.provider.MediaStore;
import android.text.Html;
import android.util.Log;
import android.util.SparseBooleanArray;
import android.view.GestureDetector;
import android.view.LayoutInflater;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageButton;
import android.widget.ImageView;
import android.widget.TextView;
import android.widget.Toast;
import com.ghostsq.commander.Commander;
import com.ghostsq.commander.FileProvider;
import com.ghostsq.commander.adapters.CA;
import com.ghostsq.commander.adapters.CommanderAdapter;
import com.ghostsq.commander.adapters.Engine;
import com.ghostsq.commander.adapters.MSAdapter;
import com.ghostsq.commander.adapters.SAFAdapter;
import com.ghostsq.commander.utils.Credentials;
import com.ghostsq.commander.utils.ForwardCompat;
import com.ghostsq.commander.utils.ImageInfo;
import com.ghostsq.commander.utils.Utils;
import com.ortiz.touch.TouchImageView;
import java.io.File;
import java.io.InputStream;
import java.lang.ref.WeakReference;
import java.util.Date;
import java.util.List;

public class PictureViewer
extends Activity
implements View.OnTouchListener,
GestureDetector.OnDoubleTapListener {
    private static final String TAG = "PictureViewerActivity";
    public ImageView image_view;
    public TextView name_view;
    public boolean touch = false;
    public CommanderAdapter ca;
    private CommanderStub stub;
    private Uri uri = null;
    public int ca_pos = -1;
    public Handler h = new Handler();
    public ProgressDialog pd;
    private PointF last;
    private String temp_file_path;
    private String file_name;

    public void onCreate(Bundle savedInstanceState) {
        SharedPreferences sharedPref = PreferenceManager.getDefaultSharedPreferences((Context)this);
        Utils.setTheme((Context)this, sharedPref.getString("color_themes", "d"));
        super.onCreate(savedInstanceState);
        try {
            boolean ab = Utils.setActionBar(this);
            if (!ab) {
                this.requestWindowFeature(1);
            }
            this.touch = Build.VERSION.SDK_INT >= 8;
            FrameLayout fl = new FrameLayout((Context)this);
            fl.setBackgroundColor(-16777216);
            if (this.touch) {
                this.image_view = new TouchImageView((Context)this);
                ((TouchImageView)this.image_view).setOnDoubleTapListener(this);
            } else {
                this.image_view = new ImageView((Context)this);
            }
            fl.addView((View)this.image_view);
            this.image_view.setVisibility(8);
            this.image_view.setOnTouchListener((View.OnTouchListener)this);
            try {
                LayoutInflater li;
                View fbv;
                ImageButton mb;
                if (!ab && Build.VERSION.SDK_INT >= 17 && !ForwardCompat.hasPermanentMenuKey((Context)this) && (mb = (ImageButton)(fbv = (li = (LayoutInflater)this.getSystemService("layout_inflater")).inflate(2130903047, (ViewGroup)fl, true)).findViewById(2131230755)) != null) {
                    mb.setVisibility(0);
                    mb.setOnClickListener(new View.OnClickListener(){

                        public void onClick(View v) {
                            PictureViewer.this.openOptionsMenu();
                        }
                    });
                }
            }
            catch (Exception e1) {
                Log.e((String)TAG, (String)"", (Throwable)e1);
            }
            String fnt_sz_s = sharedPref.getString("font_size", "12");
            int fnt_sz = 12;
            try {
                fnt_sz = Integer.parseInt(fnt_sz_s);
            }
            catch (NumberFormatException mb) {
                // empty catch block
            }
            this.name_view = new TextView((Context)this);
            this.name_view.setTextColor(-1);
            this.name_view.setTextSize((float)fnt_sz);
            FrameLayout.LayoutParams lp = new FrameLayout.LayoutParams(-2, -2, 1);
            this.name_view.setLayoutParams((ViewGroup.LayoutParams)lp);
            fl.addView((View)this.name_view);
            this.setContentView((View)fl);
            this.stub = new CommanderStub();
        }
        catch (Throwable e) {
            Log.e((String)TAG, (String)"", (Throwable)e);
        }
    }

    public void onLowMemory() {
        Log.w((String)TAG, (String)"Low Memory!");
        super.onLowMemory();
    }

    protected void onStart() {
        super.onStart();
        Intent intent = this.getIntent();
        this.uri = intent.getData();
        if (this.uri == null) {
            return;
        }
        Log.d((String)TAG, (String)("uri=" + this.uri));
        String scheme = this.uri.getScheme();
        if ("content".equals(scheme) && "com.ghostsq.commander".equals(this.uri.getHost()) && !Utils.str(this.uri.getQuery())) {
            Log.d((String)TAG, (String)"Converting content to file");
            scheme = "file";
            this.uri = new Uri.Builder().scheme(scheme).path(this.uri.getPath()).build();
        }
        this.ca_pos = intent.getIntExtra("position", -1);
        int mode = intent.getIntExtra("mode", 0);
        Log.d((String)TAG, (String)("orig pos=" + this.ca_pos));
        this.ca = CA.CreateAdapterInstance(this.uri, (Context)this);
        this.file_name = null;
        Uri.Builder ub = this.uri.buildUpon();
        Uri parent_uri = null;
        if ("zip".equals(scheme)) {
            String cur = this.uri.getFragment();
            File cur_f = new File(cur);
            this.file_name = cur_f.getName();
            String parent_dir = cur_f.getParent();
            parent_uri = this.uri.buildUpon().fragment(parent_dir != null ? parent_dir : "").build();
        } else if (this.ca instanceof SAFAdapter) {
            parent_uri = SAFAdapter.getParent(this.uri);
        } else if ("gdrive".equals(scheme)) {
            this.ca_pos = -1;
        } else if ("box".equals(scheme)) {
            this.ca_pos = -1;
        } else if ("content".equals(scheme)) {
            this.ca_pos = -1;
        } else {
            ub.path("/");
            List ps = this.uri.getPathSegments();
            int n = ps.size();
            if (n > 0) {
                --n;
            }
            for (int i = 0; i < n; ++i) {
                ub.appendPath((String)ps.get(i));
            }
            parent_uri = ub.build();
            this.file_name = (String)ps.get(ps.size() - 1);
        }
        Log.d((String)TAG, (String)("Parent dir: " + parent_uri));
        if (this.ca == null) {
            return;
        }
        this.ca.Init(this.stub);
        this.ca.setMode(112, mode);
        Credentials crd = null;
        try {
            crd = (Credentials)intent.getParcelableExtra(Credentials.KEY);
            this.ca.setCredentials(crd);
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"on taking credentials from parcel", (Throwable)e);
        }
        this.image_view.invalidate();
        if (parent_uri != null && this.ca_pos > 0) {
            this.ca.setUri(parent_uri);
            Log.d((String)TAG, (String)"do read list");
            this.stub.reload_after_dir_read_done = true;
            this.ca.readSource(null, null);
        } else {
            new LoaderThread(this.uri, this.file_name).start();
        }
    }

    protected void onStop() {
        super.onStop();
        if (this.ca != null) {
            this.ca.prepareToDestroy();
            this.ca = null;
        }
    }

    public boolean onCreateOptionsMenu(Menu menu2) {
        try {
            Utils.changeLanguage((Context)this);
            MenuInflater inflater = this.getMenuInflater();
            inflater.inflate(2131492866, menu2);
            return true;
        }
        catch (Throwable e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean onMenuItemSelected(int featureId, MenuItem item) {
        super.onMenuItemSelected(featureId, item);
        try {
            switch (item.getItemId()) {
                case 2131230936: {
                    this.rotate(false);
                    break;
                }
                case 2131230935: {
                    this.rotate(true);
                    break;
                }
                case 2131230937: {
                    this.loadNext(true);
                    break;
                }
                case 2131230938: {
                    this.loadNext(false);
                    break;
                }
                case 2131230939: {
                    this.showInfo();
                    break;
                }
                case 2131230941: {
                    this.sendTo();
                    break;
                }
                case 2131230940: {
                    this.openWith();
                    break;
                }
                case 2131230942: {
                    this.delete();
                    break;
                }
                case 2131230930: {
                    this.finish();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return true;
    }

    public final void setBitmapToView(Bitmap bmp, String name) {
        try {
            this.hideWait();
            if (bmp != null) {
                this.image_view.setVisibility(0);
                this.image_view.setImageBitmap(PictureViewer.mbScaleDownBitmap(bmp));
                if (name != null) {
                    this.name_view.setTextColor(-1);
                    this.name_view.setText((CharSequence)name);
                    if (name != null) {
                        this.file_name = name;
                    }
                }
                return;
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    private final void rotate(boolean clockwise) {
        new RotateTask(this.image_view.getDrawable(), clockwise).execute(new Void[0]);
    }

    public static Bitmap rotateBitmap(Bitmap old_bmp, float degrees) {
        Matrix m = new Matrix();
        m.postRotate(degrees);
        int old_w = old_bmp.getWidth();
        int old_h = old_bmp.getHeight();
        for (int i = 1; i <= 8; i <<= 1) {
            try {
                Bitmap new_bmp;
                if (i > 1) {
                    float scale = 1.0f / (float)i;
                    m.postScale(scale, scale);
                }
                if ((new_bmp = Bitmap.createBitmap((Bitmap)old_bmp, (int)0, (int)0, (int)old_w, (int)old_h, (Matrix)m, (boolean)false)) == null) continue;
                old_bmp.recycle();
                return new_bmp;
            }
            catch (OutOfMemoryError outOfMemoryError) {
                // empty catch block
            }
        }
        return null;
    }

    public static Bitmap mbScaleDownBitmap(Bitmap old_bmp) {
        int MAX = 4096;
        int old_w = old_bmp.getWidth();
        int old_h = old_bmp.getHeight();
        if (old_w < 4096 && old_h < 4096) {
            return old_bmp;
        }
        int max_d = Math.max(old_w, old_h);
        int div = max_d / 4096 + 1;
        int new_w = old_w / div;
        int new_h = old_h / div;
        return Bitmap.createScaledBitmap((Bitmap)old_bmp, (int)new_w, (int)new_h, (boolean)true);
    }

    public final void showWait() {
        if (this.pd == null) {
            this.pd = ProgressDialog.show((Context)this, (CharSequence)"", (CharSequence)this.getString(2131362008), (boolean)true, (boolean)true);
        }
    }

    public final void hideWait() {
        if (this.pd != null) {
            this.pd.cancel();
        }
        this.pd = null;
    }

    public boolean onTouch(View v, MotionEvent event) {
        if (this.touch && ((TouchImageView)this.image_view).isZoomed()) {
            return false;
        }
        if (event.getAction() == 0) {
            this.last = new PointF(event.getX(), event.getY());
            return true;
        }
        if (event.getAction() == 1) {
            float x;
            float dx;
            float adx;
            if (this.last == null) {
                return false;
            }
            float ady = Math.abs(event.getY() - this.last.y);
            int thldX = v.getWidth() / 50;
            int thldY = v.getHeight() / 50;
            if (thldY < 50 && (adx = Math.abs(dx = (x = event.getX()) - this.last.x)) > (float)thldX) {
                this.loadNext(dx < 0.0f);
            }
            this.last = null;
            return true;
        }
        return false;
    }

    public boolean onDoubleTap(MotionEvent arg0) {
        return false;
    }

    public boolean onDoubleTapEvent(MotionEvent arg0) {
        return false;
    }

    public boolean onSingleTapConfirmed(MotionEvent event) {
        if (this.touch && ((TouchImageView)this.image_view).isZoomed()) {
            return false;
        }
        float x = event.getX();
        this.loadNext(x > (float)(this.image_view.getWidth() / 2));
        return true;
    }

    private final void delete() {
        if (this.ca_pos < 0 || this.ca == null) {
            return;
        }
        String name = this.ca.getItemName(this.ca_pos, false);
        new AlertDialog.Builder((Context)this).setTitle(2131361986).setIcon(17301543).setMessage((CharSequence)this.getString(2131361988, new Object[]{name})).setPositiveButton(2131361929, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                SparseBooleanArray sba = new SparseBooleanArray();
                sba.append(PictureViewer.this.ca_pos, true);
                PictureViewer.this.ca.deleteItems(sba);
            }
        }).setNegativeButton(2131361930, null).show();
    }

    private final void loadNext(boolean forward) {
        this.loadNext(forward ? 1 : -1, false);
    }

    public final void loadNext(int dir, boolean exit_at_end) {
        if (this.ca_pos < 0 || this.ca == null) {
            if (exit_at_end) {
                this.finish();
            }
            return;
        }
        int orig_pos = this.ca_pos;
        do {
            this.ca_pos += dir;
            if (this.ca_pos <= 0) {
                this.ca_pos = orig_pos;
                if (exit_at_end) {
                    this.finish();
                }
                return;
            }
            Uri pos_uri = this.ca.getItemUri(this.ca_pos);
            if (pos_uri == null) {
                this.ca_pos = orig_pos;
                if (exit_at_end) {
                    this.finish();
                }
                return;
            }
            this.uri = pos_uri;
            Log.d((String)TAG, (String)("Next uri: " + pos_uri));
            String name = this.ca.getItemName(this.ca_pos, false);
            if (name == null) {
                Log.e((String)TAG, (String)"Something is wrong, exiting");
                return;
            }
            String mime = Utils.getMimeByExt(Utils.getFileExt(name));
            Log.d((String)TAG, (String)("Next name: " + name + " mime: " + mime));
            if (!mime.startsWith("image/")) continue;
            Log.d((String)TAG, (String)("new pos=" + this.ca_pos));
            this.name_view.setTextColor(-7829368);
            this.name_view.setText((CharSequence)this.getString(2131361916));
            new LoaderThread(pos_uri, name).start();
            return;
        } while (dir != 0);
    }

    private static final String getFilePath(Uri uri, String temp_file_path) {
        String file_path = null;
        if (temp_file_path != null) {
            file_path = temp_file_path;
        } else {
            String scheme = uri.getScheme();
            if (CA.isLocal(scheme) || "ms".equals(scheme) || "content".equals(scheme) && "com.ghostsq.commander".equals(uri.getHost())) {
                file_path = uri.getPath();
            }
        }
        return file_path;
    }

    @SuppressLint(value={"InflateParams"})
    private final void showInfo() {
        AlertDialog.Builder builder = new AlertDialog.Builder((Context)this).setTitle((CharSequence)this.getString(2131362061)).setIcon(17301659).setPositiveButton(2131361929, null);
        LayoutInflater inflater = (LayoutInflater)this.getSystemService("layout_inflater");
        View layout2 = inflater.inflate(2130903064, null);
        TextView text_view = (TextView)layout2.findViewById(2131230898);
        String info_text = this.getInfo();
        if (info_text == null) {
            info_text = this.getString(2131362039);
        }
        text_view.setText((CharSequence)Html.fromHtml((String)info_text));
        builder.setView(layout2);
        builder.show();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final String getInfo() {
        String info_text = null;
        String file_path = PictureViewer.getFilePath(this.uri, this.temp_file_path);
        if (file_path != null) {
            String path_to_show = this.temp_file_path != null ? this.uri.toString() : file_path;
            info_text = "<b>File:</b> <small>" + path_to_show + "</small><br/>";
            String exif_text = ImageInfo.getImageFileInfoHTML(file_path);
            if (exif_text != null) {
                info_text = info_text + exif_text;
            }
            return info_text;
        }
        if (this.uri != null && "content".equals(this.uri.getScheme())) {
            String[] projection = new String[]{"_data", "_size", "title", "width", "height", "datetaken", "orientation", "description", "_display_name"};
            Cursor cursor = null;
            ContentResolver cr = null;
            try {
                cr = this.getContentResolver();
                cursor = cr.query(this.uri, projection, null, null, null);
                if (cursor != null && cursor.getCount() > 0) {
                    String path_to_show;
                    cursor.moveToFirst();
                    boolean no_m = false;
                    String exif_text = null;
                    String path = cursor.getString(cursor.getColumnIndex("_data"));
                    String string2 = path_to_show = path != null ? path : this.file_name;
                    if (path_to_show == null) {
                        path_to_show = cursor.getString(cursor.getColumnIndex("_display_name"));
                    }
                    String string3 = info_text = path_to_show != null ? "<b>File:</b> <small>" + path_to_show + "</small><br/>" : "";
                    if (path != null) {
                        exif_text = ImageInfo.getImageFileInfoHTML(path);
                    } else {
                        InputStream is = this.ca.getContent(this.uri);
                        if (is != null) {
                            exif_text = ImageInfo.getImageStreamInfoHTML(is);
                        }
                    }
                    if (exif_text != null) {
                        info_text = info_text + exif_text;
                        no_m = true;
                    }
                    StringBuilder sb = new StringBuilder();
                    for (String col : projection) {
                        String val = cursor.getString(cursor.getColumnIndex(col));
                        if (val == null || col.equals("_data") || col.equals("_display_name")) continue;
                        sb.append("<br/>");
                        if (col.equals("_size")) {
                            sb.append("<b>Size");
                            val = Utils.getHumanSize(Long.parseLong(val), false) + "B";
                        } else if (col.equals("title")) {
                            sb.append("<b>Title");
                        } else if (col.equals("width")) {
                            if (no_m) continue;
                            sb.append("<b>Width");
                        } else if (col.equals("height")) {
                            if (no_m) continue;
                            sb.append("<b>Height");
                        } else if (col.equals("orientation")) {
                            if (no_m) continue;
                            sb.append("<b>Orientation");
                        } else if (col.equals("description")) {
                            sb.append("<b>Description");
                        } else if (col.equals("datetaken")) {
                            if (no_m) continue;
                            sb.append("<b>Date taken");
                            val = new Date(Long.parseLong(val)).toString();
                        }
                        sb.append(":</b> ");
                        sb.append(val);
                    }
                    info_text = info_text + sb.toString();
                }
            }
            catch (Throwable e) {
                Log.e((String)TAG, (String)"on query", (Throwable)e);
            }
            finally {
                cursor.close();
            }
        }
        return info_text;
    }

    private final void sendTo() {
        SharedPreferences shared_pref = PreferenceManager.getDefaultSharedPreferences((Context)this);
        boolean use_content = shared_pref.getBoolean("send_content", true);
        Uri mod_uri = this.changeUri(this.uri, use_content);
        if (mod_uri == null) {
            return;
        }
        Intent out = new Intent("android.intent.action.SEND");
        out.setType(this.getIntent().getType());
        out.putExtra("android.intent.extra.SUBJECT", this.file_name);
        out.putExtra("android.intent.extra.STREAM", (Parcelable)mod_uri);
        out.addFlags(1);
        Log.d((String)TAG, (String)("Intent to send: " + out.toString()));
        this.startActivity(Intent.createChooser((Intent)out, (CharSequence)this.getString(2131361966)));
    }

    public final void openWith() {
        SharedPreferences shared_pref = PreferenceManager.getDefaultSharedPreferences((Context)this);
        boolean use_content = shared_pref.getBoolean("open_content", true);
        Intent in = this.getIntent();
        Intent out = new Intent("android.intent.action.VIEW");
        Log.d((String)TAG, (String)("Opening intent: " + in.toString()));
        Uri mod_uri = this.changeUri(this.uri, use_content);
        if (mod_uri == null) {
            return;
        }
        out.setDataAndType(mod_uri, "image/*");
        out.addFlags(3);
        Log.d((String)TAG, (String)("Intent to open: " + out.toString()));
        if (Build.VERSION.SDK_INT == 19) {
            this.startActivity(out);
        } else {
            this.startActivity(Intent.createChooser((Intent)out, (CharSequence)this.getString(2131361967)));
        }
    }

    private final Uri changeUri(Uri u, boolean use_content) {
        if (u == null) {
            return null;
        }
        if (use_content) {
            if (!"content".equals(u.getScheme())) {
                String file_path = PictureViewer.getFilePath(u, this.temp_file_path);
                if (file_path == null) {
                    Log.e((String)TAG, (String)"No file path");
                    return null;
                }
                Uri ms_uri = MSAdapter.getContentUri(u.getPath(), (Context)this, MediaStore.Images.Media.EXTERNAL_CONTENT_URI);
                if (ms_uri != null) {
                    return ms_uri;
                }
                return FileProvider.makeURI(file_path);
            }
            return u;
        }
        String file_path = PictureViewer.getFilePath(u, this.temp_file_path);
        if (file_path == null && this.ca instanceof SAFAdapter) {
            file_path = SAFAdapter.getPath((Context)this, u, true);
        }
        if (file_path != null) {
            return Uri.parse((String)("file://" + Utils.escapePath(file_path)));
        }
        return null;
    }

    static /* synthetic */ String access$302(PictureViewer x0, String x1) {
        x0.temp_file_path = x1;
        return x0.temp_file_path;
    }

    private class CommanderStub
    implements Commander {
        boolean reload_after_dir_read_done = false;

        private CommanderStub() {
        }

        public Context getContext() {
            return PictureViewer.this;
        }

        public void issue(Intent in, int ret) {
        }

        public void showError(String msg) {
        }

        public void showInfo(String msg) {
        }

        public void showDialog(int dialog_id) {
        }

        public void Navigate(Uri uri, Credentials crd, String positionTo) {
        }

        public void dispatchCommand(int id2) {
        }

        public void Open(Uri uri, Credentials crd) {
        }

        public int getResolution() {
            return 0;
        }

        public boolean notifyMe(Message m) {
            if (m.what == -3) {
                Log.d((String)PictureViewer.TAG, (String)"Completed");
                if (this.reload_after_dir_read_done) {
                    PictureViewer.this.loadNext(0, true);
                }
                this.reload_after_dir_read_done = false;
            }
            if (m.obj != null) {
                String s = null;
                if (m.obj instanceof Bundle) {
                    s = ((Bundle)m.obj).getString("STRING");
                } else if (m.obj instanceof String) {
                    s = (String)m.obj;
                }
                if (Utils.str(s)) {
                    boolean html = Utils.isHTML(s);
                    Toast.makeText((Context)PictureViewer.this, (CharSequence)(html ? Html.fromHtml((String)s) : s), (int)1).show();
                }
            }
            return false;
        }

        public boolean startEngine(Engine e) {
            e.setHandler(new Handler(){

                public void handleMessage(Message msg) {
                    if (msg.what == -4) {
                        Log.d((String)PictureViewer.TAG, (String)"Completed, need refresh");
                        CommanderStub.this.reload_after_dir_read_done = true;
                        PictureViewer.this.ca.readSource(null, null);
                        CommanderStub.this.notifyMe(msg);
                        return;
                    }
                }
            });
            e.start();
            return true;
        }
    }

    private class LoaderThread
    extends Thread {
        private Context ctx;
        private byte[] buf;
        private Uri u;
        private Bitmap bmp;
        private String name_to_show = null;

        LoaderThread(Uri u_, String name_) {
            this.ctx = PictureViewer.this;
            this.u = u_;
            this.name_to_show = name_;
            this.setName("PictureLoader");
        }

        /*
         * Exception decompiling
         */
        public void run() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 24[FORLOOP]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class RotateTask
    extends AsyncTask<Void, Void, Void> {
        private Drawable from_view;
        private WeakReference<Bitmap> wrRotatedBitmap;
        private boolean clockwise;

        public RotateTask(Drawable from_view, boolean clockwise) {
            this.from_view = from_view;
            this.clockwise = clockwise;
        }

        protected void onPreExecute() {
        }

        protected Void doInBackground(Void ... params) {
            try {
                if (this.from_view == null) {
                    Log.e((String)PictureViewer.TAG, (String)"No drawable");
                    return null;
                }
                if (!(this.from_view instanceof BitmapDrawable)) {
                    Log.e((String)PictureViewer.TAG, (String)"drawable is not a bitmap");
                    return null;
                }
                BitmapDrawable bd = (BitmapDrawable)this.from_view;
                Bitmap old_bmp = bd.getBitmap();
                float degrees = this.clockwise ? 90.0f : 270.0f;
                this.wrRotatedBitmap = new WeakReference<Bitmap>(PictureViewer.rotateBitmap(old_bmp, degrees));
            }
            catch (Throwable e) {
                Log.e((String)PictureViewer.TAG, (String)"", (Throwable)e);
            }
            return null;
        }

        protected void onPostExecute(Void param) {
            if (this.wrRotatedBitmap == null) {
                return;
            }
            Bitmap bmp = (Bitmap)this.wrRotatedBitmap.get();
            if (bmp != null) {
                PictureViewer.this.setBitmapToView(bmp, null);
            }
        }
    }
}

